// ============================================================================
// Copyright (c) 2022 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Thu Jun  2 17:27:37 2022
// ============================================================================

//`define ENABLE_DDR4A
//`define ENABLE_DDR4B
//`define ENABLE_QSFP28
//`define ENABLE_FMCP
//`define ENABLE_HPS
//`define ENABLE_HDMI
//`define ENABLE_PCIE

module ALCK(

      ///////// CLOCK /////////
      input              CLK_100_B3A_p,
      input              CLK_100_p,
      input              CLK_148M5_p,
      input              CLK_50_B2D_p,
      input              CLK_50_B2E_p,
      input              CLK_50_B3A_p,
      input              CLK_50_B3C_p,

      ///////// Buttons /////////
      input              CPU_RESET_n,
      input    [ 1: 0]   BUTTON, //BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   SW,

      ///////// LED /////////
      output   [ 1: 0]   LED, //LED is Low-Active

`ifdef ENABLE_DDR4A
      ///////// DDR4A /////////
      input              DDR4A_REFCLK_p,
      output   [16: 0]   DDR4A_A,
      output   [ 1: 0]   DDR4A_BA,
      output   [ 1: 0]   DDR4A_BG,
      output             DDR4A_CK,
      output             DDR4A_CK_n,
      output             DDR4A_CKE,
      inout    [ 8: 0]   DDR4A_DQS,
      inout    [ 8: 0]   DDR4A_DQS_n,
      inout    [71: 0]   DDR4A_DQ,
      inout    [ 8: 0]   DDR4A_DBI_n,
      output             DDR4A_CS_n,
      output             DDR4A_RESET_n,
      output             DDR4A_ODT,
      output             DDR4A_PAR,
      input              DDR4A_ALERT_n,
      output             DDR4A_ACT_n,
      input              DDR4A_EVENT_n,
      inout              DDR4A_SCL,
      inout              DDR4A_SDA,
      input              DDR4A_RZQ,
`endif /*ENABLE_DDR4A*/

`ifdef ENABLE_DDR4B
      ///////// DDR4B /////////
      input              DDR4B_REFCLK_p,
      output   [16: 0]   DDR4B_A,
      output   [ 1: 0]   DDR4B_BA,
      output   [ 1: 0]   DDR4B_BG,
      output             DDR4B_CK,
      output             DDR4B_CK_n,
      output             DDR4B_CKE,
      inout    [ 8: 0]   DDR4B_DQS,
      inout    [ 8: 0]   DDR4B_DQS_n,
      inout    [71: 0]   DDR4B_DQ,
      inout    [ 8: 0]   DDR4B_DBI_n,
      output             DDR4B_CS_n,
      output             DDR4B_RESET_n,
      output             DDR4B_ODT,
      output             DDR4B_PAR,
      input              DDR4B_ALERT_n,
      output             DDR4B_ACT_n,
      input              DDR4B_RZQ,
`endif /*ENABLE_DDR4B*/

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      output   [ 3: 0]   HDMI_TX_D_p,
      output   [ 3: 0]   HDMI_TX_D_n,
      input              FGT_REFCLK_100_p,
      input              HDMI_REFCLK_148M5_p,
      output             DVI_TX_5V,
      input              DVI_TX_CEC_IN_n,
      output             DVI_TX_CEC_OUT_n,
      input              DVI_TX_HPD_n,
      inout              DVI_TX_SCL,
      inout              DVI_TX_SDA,
      inout              HDMI_TX_SCL,
      inout              HDMI_TX_SDA,
`endif /*ENABLE_HDMI*/

      ///////// SI5340A0 /////////
      inout              SI5340A0_I2C_SCL,
      inout              SI5340A0_I2C_SDA,
      output             SI5340A0_OE_n,
      output             SI5340A0_RST_n,

      ///////// SI5340A1 /////////
      inout              SI5340A1_I2C_SCL,
      inout              SI5340A1_I2C_SDA,
      output             SI5340A1_OE_n,
      output             SI5340A1_RST_n,

      ///////// GPIO /////////
      input    [ 1: 0]   GPIO_CLK,
      inout    [ 3: 0]   GPIO_P,

`ifdef ENABLE_FMCP
      ///////// FMCP /////////
      inout              FMCP_CLK2_BIDIR_p,
      inout              FMCP_CLK2_BIDIR_n,
      inout              FMCP_CLK3_BIDIR_p,
      inout              FMCP_CLK3_BIDIR_n,
      output   [15: 0]   FMCP_DP_C2M_p,
      output   [15: 0]   FMCP_DP_C2M_n,
      input    [15: 0]   FMCP_DP_M2C_p,
      input    [15: 0]   FMCP_DP_M2C_n,
      inout    [23: 0]   FMCP_HA_p,
      inout    [23: 0]   FMCP_HA_n,
      inout    [21: 0]   FMCP_HB_p,
      inout    [21: 0]   FMCP_HB_n,
      inout    [33: 0]   FMCP_LA_p,
      inout    [33: 0]   FMCP_LA_n,
      input    [ 1: 0]   FMCP_CLK_M2C_p,
      input    [ 1: 0]   FMCP_GBTCLK_M2C_p,
      output             FMCP_REFCLK_C2M_p,
      input              FMCP_REFCLK_M2C_p,
      input    [ 3: 0]   FMCP_REFCLK_p,
      inout    [ 1: 0]   FMCP_GA,
      input              FMCP_RES0,
      inout              FMCP_RES1,
      inout              FMCP_SCL,
      inout              FMCP_SDA,
      output             FMCP_SYNC_C2M_p,
      input              FMCP_SYNC_M2C_p,
`endif /*ENABLE_FMCP*/

	//////////// FMC, FMC connect to HDMI-FMC //////////
	inout 		          		ADV7619_CSCL_FMC,
	inout 		          		ADV7619_CSDA_FMC,
	output		          		ADV7619_CS_n,
	input 		          		ADV7619_INT,
	output		          		ADV7619_RESET_n,
	output		     [1:0]		FMC_GA,
	output		          		FMC_I2C_SCL,
	inout 		          		FMC_I2C_SDA,
	output		          		RX0_DDC_SCL,
	inout 		          		RX0_DDC_SDA,
	output 		          		RX1_DDC_SCL,
	inout 		          		RX1_DDC_SDA,
	input 		     [5:0]		RX_AP,
	input 		    [15:0]		RX_BD,
	input 		          		RX_DE,
	input 		    [15:0]		RX_GD,
	input 		          		RX_HS,
	input 		          		RX_MCLK,
	input 		          		RX_PCLK,
	input 		    [15:0]		RX_RD,

	input 		          		RX_SCLK,
	input 		          		RX_VS,
	output 		          		SII9136_CSCL_FMC,
	inout 		          		SII9136_CSDA_FMC,
	input 		          		SII9136_INT,
	output		          		SII9136_RST_n,
	output		    [11:0]		TX_BD,
	output		          		TX_DE,
	output		          		TX_DSR3L,
	output		          		TX_DSR3R,
	output		    [11:0]		TX_GD,
	output		          		TX_HS,
	output		     [3:0]		TX_I2S,
	output		          		TX_MCLK,
	output		          		TX_PCLK,
	output		    [11:0]		TX_RD,
	output		          		TX_SCK,
	output		          		TX_SPDIF,
	output		          		TX_VS,
	output		          		TX_WS,

`ifdef ENABLE_PCIE
      ///////// PCIE /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      output   [ 7: 0]   PCIE_TX_p,
      output   [ 7: 0]   PCIE_TX_n,
      input    [ 7: 0]   PCIE_RX_p,
      input    [ 7: 0]   PCIE_RX_n,
      input              PCIE_REFCLK_p,
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFP28
      ///////// QSFP28 /////////
      output   [ 3: 0]   QSFP28_TX_p,
      output   [ 3: 0]   QSFP28_TX_n,
      input    [ 3: 0]   QSFP28_RX_p,
      input    [ 3: 0]   QSFP28_RX_n,
      input    [ 1: 0]   QSFP28_REFCLK_p,
      input              QSFP28_INTERRUPT_n,
      output             QSFP28_LP_MODE,
      input              QSFP28_MOD_PRS_n,
      output             QSFP28_MOD_SEL_n,
      output             QSFP28_RST_n,
      inout              QSFP28_SCL,
      inout              QSFP28_SDA,
`endif /*ENABLE_QSFP28*/

      ///////// EXP /////////
      input              EXP_EN,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      input              HPS_JTAG_TCK,
      input              HPS_JTAG_TDI,
      output             HPS_JTAG_TDO,
      input              HPS_JTAG_TMS,
      inout              HPS_KEY,
      inout              HPS_LED,
      input              HPS_OSC_CLK,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout    [ 3: 0]   HPS_SD_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n

);


//=======================================================
//  REG/WIRE declarations
//=======================================================
wire reset_n;
wire [23: 0] disp_data;
wire disp_clk;
wire disp_hs;
wire disp_vs;
wire disp_de;

//=======================================================
//  Structural coding
//=======================================================
assign ADV7619_CS_n = 1'b0;
assign reset_n = CPU_RESET_n;


hdmi_controller u0 (
             .clk_50 (CLK_50_B3A_p),                                          //                           clk_50_clk_in.clk
             .reset_n (reset_n    ),                                         //                     clk_50_clk_in_reset.reset_n

             // HDMI TX
             .hdmi_tx_fmc_i2c_scl_external_connection_export (SII9136_CSCL_FMC),  // hdmi_tx_fmc_i2c_scl_external_connection.export
             .hdmi_tx_fmc_i2c_sda_external_connection_export (SII9136_CSDA_FMC),  // hdmi_tx_fmc_i2c_sda_external_connection.export
             .sii9136_int_external_connection_export (SII9136_INT),          //         sii9136_int_external_connection.export
             .sii9136_rst_n_external_connection_export (SII9136_RST_n),        //       sii9136_rst_n_external_connection.export

             .i2c_scl_external_connection_export (ADV7619_CSCL_FMC),              //             i2c_scl_external_connection.export
             .i2c_sda_external_connection_export (ADV7619_CSDA_FMC),               //             i2c_sda_external_connection.export
          //   .sii9679_rst_external_connection_export (),           //         sii9679_rst_external_connection.export
             .adv7619_rst_external_connection_export (ADV7619_RESET_n),           //         adv7619_rst_external_connection.export
             .rx0_edid_i2c_scl_external_connection_export (RX0_DDC_SCL),         //        edid_i2c_scl_external_connection.export
             .rx0_edid_i2c_sda_external_connection_export (RX0_DDC_SDA),          //        edid_i2c_sda_external_connection.export
             .rx1_edid_i2c_scl_external_connection_export (RX1_DDC_SCL),         //        edid_i2c_scl_external_connection.export
             .rx1_edid_i2c_sda_external_connection_export (RX1_DDC_SDA),          //        edid_i2c_sda_external_connection.export
             .adv7619_int_external_connection_export (ADV7619_INT)          //         adv7619_int_external_connection.export

         );

			


			
//-------RESET-------------------			
wire RESET_DY ,rest;
assign rest = ADV7619_RESET_n & SII9136_RST_n & BUTTON[0];

RESET_DELY de1( 
  .BUTTON_N   (rest      ) , 
	.OSC_24    (RX_PCLK   ), 
   .RESET     (RESET_DY  )  
) ; 
						
			
//-------PLL -------------------
wire tx_pll_locked;
wire TX_PCLK_FIFO ;
wire RX_PCLK_FIFO ;
wire ninit_done ; 

//------RESET Initial ----------
reset_release  reset_release_0 (
		.ninit_done (ninit_done) 
	);	
	
//----Reconfig PLL -------------
wire        mgmt_clk          ;
wire        mgmt_reset        ;
wire        mgmt_waitrequest  ;
wire        mgmt_write        ;
wire        mgmt_read         ;
wire [7:0]  mgmt_writedata    ;
wire [7:0]  mgmt_readdata     ;
wire [9:0]  mgmt_address      ;
wire [29:0] reconfig_to_pll   ;
wire [10:0] reconfig_from_pll ;

assign      mgmt_clk   = CLK_50_B3A_p; 
assign      mgmt_reset = RESET_DY  ; 

//-----USER LOGIC --------------
CAL_iopll CAL0_fpll_inst( 		
      .reconfig_clk        (mgmt_clk       ),         
		.reconfig_reset      (mgmt_reset     ),      
		.reconfig_write      (mgmt_write     ),       
		.reconfig_read       (mgmt_read      ),       
		.reconfig_address    (mgmt_address   ),     
		.reconfig_writedata  (mgmt_writedata ),   
		.reconfig_readdata   (mgmt_readdata  ),    
		.reconfig_waitrequest(mgmt_waitrequest),   
		.pll_lock            (tx_pll_locked  )  
);

//------reconfigPLL , reconfig IP -----------
reconfig_iopll iopll_reconfig_0 (
		.mgmt_clk          (mgmt_clk        ),  
		.mgmt_reset        (mgmt_reset      ),  
		.mgmt_waitrequest  (mgmt_waitrequest),  
		.mgmt_write        (mgmt_write      ),  
		.mgmt_read         (mgmt_read       ),  
		.mgmt_writedata    (mgmt_writedata  ),  
		.mgmt_readdata     (mgmt_readdata   ),  
		.mgmt_address      (mgmt_address    ),  
		.reconfig_to_pll   (reconfig_to_pll ),  
		.reconfig_from_pll (reconfig_from_pll)  
	);
//------gen first clock 148MHZ----------------
wire outclk_148 ; 	
pll_50 pll_50_0 (
		.rst      (ninit_done ),   
		.refclk   (CLK_50_B3A_p ),   
		.locked   (),   
		.outclk_0 (outclk_148 )  
	);	
	
//-------PLL refclock switch------------------	
wire RX_PCLKK;
assign RX_PCLKK  = RESET_DY? outclk_148: RX_PCLK ; 

//-------TX PLL-------------------------------
pll tx_pll_inst (
        .rst               ( ninit_done      ),
	     .refclk            (  RX_PCLKK       ),	 // 1080p@60=74.35MHZ // 4K@30 =148.35MHZ
		  .locked            ( tx_pll_locked   ),
		  .reconfig_to_pll   (reconfig_to_pll  ),  
		  .reconfig_from_pll (reconfig_from_pll), 		  
        .outclk_0          ( TX_PCLK         ),  // RX_PCLKx2
        .outclk_1          ( TX_PCLK_FIFO    )  // RX_PCLKx1
	    // .outclk_2          ( RX_PCLK_FIFO    )   // RX_PCLKx1
    
);
assign  	 RX_PCLK_FIFO= ~RX_PCLK;//
//------VIDEO Stream	 ------------------------
wire [ 7: 0] RX_G0, RX_G1;
wire [ 7: 0] RX_B0, RX_B1;
wire [ 7: 0] RX_R0, RX_R1;
assign RX_G0[7: 0] = RX_RD[15: 8];
assign RX_B0[7: 0] = RX_RD[7: 0];
assign RX_R0[7: 0] = RX_GD[15: 8];
assign RX_G1[7: 0] = RX_GD[7: 0];
assign RX_B1[7: 0] = RX_BD[15: 8];
assign RX_R1[7: 0] = RX_BD[7: 0];


//===== latch hdmi source video====
reg [26:0] pix0_0;
reg [26:0] pix0_1;
always @(posedge RX_PCLK_FIFO)
begin
	pix0_0 <= {RX_DE,RX_HS,RX_VS,RX_R0, RX_G0,RX_B0};
	pix0_1 <= {RX_DE,RX_HS,RX_VS,RX_R1, RX_G1,RX_B1};
end


//===== video loopback ====
reg         rdreq_ack;
wire [4: 0] rdusedw;
always @(posedge TX_PCLK_FIFO or negedge reset_n)
begin
	if (~reset_n)
		rdreq_ack <= 1'b0;
	else if (rdusedw >=  5'd5)
		rdreq_ack <= 1'b1;
end
wire [26:0] pix1_0;
wire [26:0] pix1_1;
fifo fifo_inst(
         .wrclk  ( RX_PCLK_FIFO        ),
         .wrreq  ( 1'b1            ),
			.data   ( {pix0_1, pix0_0}),	// input x54(2 pixel)	 
         .rdclk  ( TX_PCLK_FIFO    ),
         .rdreq  ( rdreq_ack       ),
         .rdusedw( rdusedw         ),
			.q      ( {pix1_1, pix1_0})	// output x54(2 pixel)	
);
	  	  
reg [26:0] pix2_0;
reg [26:0] pix2_1; 
always @(posedge TX_PCLK_FIFO)
begin
		pix2_0 <= pix1_0;
		pix2_1 <= pix1_1;
end	  

//-------DDR TO  SDR-------
wire [26:0] tx_pade;
tx_gpio tx_gpio_inst (
    .din     ( {pix2_1[26:0], pix2_0[26:0] }), 
    .pad_out ( {TX_DE, TX_HS, TX_VS, TX_RD[11: 4], TX_GD[11: 4] , TX_BD[11: 4]} ), 
	 .ck      ( TX_PCLK_FIFO                                                        )      
);

assign {TX_RD[3: 0], TX_GD[3: 0], TX_BD[3: 0]} = {4'b0, 4'b0, 4'b0};

//--sound loopback---
assign TX_SCK   = RX_SCLK;
assign TX_I2S   = RX_AP[4: 1];
assign TX_MCLK  = RX_MCLK;
assign TX_SPDIF = RX_AP[0];
assign TX_WS    = RX_AP[5];

//-----VS heart-----------
CLOCKMEM  ck2( .RESET_n(1), .CLK(RX_VS) ,.CLK_FREQ (  29     )  ,.CK_1HZ   ( VS_1HZ ) ) ;
wire TX_PCLK_1HZ ; 
CLOCKMEM  ck3( .RESET_n(1), .CLK(TX_PCLK ) ,.CLK_FREQ (  297_000_000 )  ,.CK_1HZ   ( TX_PCLK_1HZ ) ) ;
//------LED Display-------
assign LED= {RESET_DY,  tx_pll_locked & TX_PCLK_1HZ };

//----- for singaltapeii  viewer ------
wire  M50_1HZ ; 
CLOCKMEM  ck1( .RESET_n(1), .CLK(CLK_50_B3A_p ) ,.CLK_FREQ (  50_000_000 )  ,.CK_1HZ   ( M50_1HZ ) ) ;
FRE_MEASURE f_CLK_50_B2A    ( .RESET_n(1),.MES_CLK (CLK_50_B3A_p   )   , .HZ1(M50_1HZ) , .FREQ(  ) ); 
FRE_MEASURE f_CLK_100_B2A   ( .RESET_n(1),.MES_CLK (CLK_100_B3A_p  )   , .HZ1(M50_1HZ) , .FREQ(  ) ); 
FRE_MEASURE f_RX_PCLK       ( .RESET_n(1),.MES_CLK (RX_PCLK      )   , .HZ1(M50_1HZ) , .FREQ(  ) ); 
FRE_MEASURE f_TX_PCLK       ( .RESET_n(1),.MES_CLK (TX_PCLK      )   , .HZ1(M50_1HZ) , .FREQ(  ) ); 
FRE_MEASURE f_TX_PCLK_FIFO  ( .RESET_n(1),.MES_CLK (TX_PCLK_FIFO )   , .HZ1(M50_1HZ) , .FREQ(  ) );
FRE_MEASURE f_RX_PCLK_FIFO  ( .RESET_n(1),.MES_CLK (RX_PCLK_FIFO )   , .HZ1(M50_1HZ) , .FREQ(  ) ); 



endmodule
