module CAL_iopll ( 
		input  wire         reconfig_clk,         
		input  wire         reconfig_reset,      
		output  reg         reconfig_write,       
		output  reg         reconfig_read,       
		output  reg [9:0]   reconfig_address,     
		output  reg [7:0]   reconfig_writedata,   
		input  wire [7:0]   reconfig_readdata,    
		input  wire         reconfig_waitrequest, 
		input  wire         pll_lock  ,
      output reg [4:0]    set_counter , 		
      output reg [4:0]    ST ,
		output reg          reconfig_done 
      
);
reg [31:0] delay ; 
always @( posedge  reconfig_reset  or posedge reconfig_clk )begin
if ( reconfig_reset ) begin 
     ST<= 0;
	  reconfig_address  <= 10'h00 ; 
	  reconfig_writedata<= 8'h0;
	  reconfig_write    <= 0 ;
	  reconfig_read     <= 0;
	  set_counter       <= 0;
	  reconfig_done     <= 0;
end 	
else case(ST) 
//---------cal eanble 
0: begin reconfig_write    <= 0;
         ST<=1;   
					 
        //recalibration use .mif					 
        if (set_counter ==0) begin reconfig_address[9:8]  <= 2'b00 ; reconfig_writedata[4:0]<= 5'b00000;end 					 
		  
	//c3 phase shift -45degree
   else if (set_counter ==1) begin reconfig_address[9:8]  <= 2'b11 ; reconfig_writedata<= 8'b0011_0_001;end 
   end 
1: begin reconfig_write    <= 1;
                ST<=2;   
   end 
2: begin reconfig_write    <= 0;
                ST<=3;   
   end 
	
3: begin 
         if ( reconfig_waitrequest) begin
             ST<=4;   
			end 
   end 
4: begin 
         if ( !reconfig_waitrequest) begin
             ST<=5;   
			end 
   end 
	
5: begin 
         //if ( set_counter!=1) begin
			//     set_counter<=set_counter+1;
         //     ST<=0;   
			//end 
			//else ST<=6;   
			ST<=6;   
   end 
	
6: begin //end
     ST<= 6;
	  reconfig_done     <= 1;

   end 
	
	
	endcase 	
end

endmodule