module RESET_DELY ( 
   input BUTTON_N  , 
	input OSC_24 , 
   output RESET  
) ; 

parameter SEC = 74_000_000 ; 
parameter SEC1 = 1*SEC  ; 
parameter SEC2 = 2*SEC  ; 
parameter SEC10 = 10*SEC  ; 

//=======================================================
//  REG/WIRE declarations
//=======================================================
reg [31:0] DELAY_CNT  ; 
  
//=======================================================
//  Structural coding
//=======================================================	

assign RESET =( ( DELAY_CNT>=0 ) &&  ( DELAY_CNT< (SEC2)) )?1:0 ; 

always @(negedge  BUTTON_N or posedge OSC_24  ) 
 if (  !BUTTON_N ) begin 
     DELAY_CNT<=0;
 end
 else  begin 
    if  ( DELAY_CNT < SEC10 ) DELAY_CNT <= DELAY_CNT+1; 
 end 
 
endmodule 