module  clk_counter (
                        clk_50,
                        clk_target,
                        q);

//  Read Out Side
input clk_50;
input clk_target;
output reg [31: 0] q;

reg [31: 0] counter_50 = 32'b0;
reg [31: 0] counter_target = 32'b0;
reg trig_1s = 1'b0;

always @(posedge clk_50) begin
    if (counter_50 < 32'd49999999) begin
        counter_50 <= counter_50 + 32'b1;
    end
    else begin
        counter_50 <= 1'b0;
    end
end

always @(posedge clk_50) begin
    if (counter_50 == 32'd49999999) begin
        trig_1s <= 1'b1;
    end
    else begin
        trig_1s <= 1'b0;
    end
end

reg [31: 0] counter_target_reg;
always @(posedge clk_50) begin
    q <= counter_target_reg;
end

reg [1: 0] trig_1s_reg;
reg trig_1s_sync;
always @(posedge clk_target) begin
    trig_1s_reg <= {trig_1s_reg[0], trig_1s};
    trig_1s_sync <= (trig_1s_reg == 2'b01);
end

always @(posedge clk_target) begin
    if (trig_1s_sync) begin
        counter_target_reg <= counter_target;
    end
end

always @(posedge clk_target) begin
    if (trig_1s_sync) begin
        counter_target <= 32'b0;
    end
    else begin
        counter_target <= counter_target + 32'b1;
    end
end

endmodule

