// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera MegaCore Function License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// $Id: //acds/rel/23.4/ip/iconnect/merlin/altera_merlin_router/altera_merlin_router.sv.terp#1 $
// $Revision: #1 $
// $Date: 2023/10/12 $

// -------------------------------------------------------
// Merlin Router
//
// Asserts the appropriate one-hot encoded channel based on 
// the address.
//
// Also sets the binary-encoded destination id.
// -------------------------------------------------------

`timescale 1 ns / 1 ns

// ------------------------------------------
// Generation parameters:
//    decoder_type            0 (address decoder)
//    default_channel         7
//    default_destid          14
//    default_rd_channel      -1
//    default_wr_channel      -1
//    has_default_slave       0
//    memory_aliasing_decode  0
//    output_name             hdmi_controller_altera_merlin_router_1921_blajl2q
//    pkt_addr_h              55
//    pkt_addr_l              36
//    pkt_dest_id_h           86
//    pkt_dest_id_l           82
//    pkt_protection_h        90
//    pkt_protection_l        88
//    pkt_trans_read          59
//    pkt_trans_write         58
//    slaves_info             14:000000000000010000000:0x40000:0x80000:both:1:0:0:1,13:000000000000000000100:0x80800:0x81000:both:1:0:0:1,20:000000000000000001000:0x81000:0x81020:both:1:0:0:1,5:100000000000000000000:0x81020:0x81030:both:1:0:0:1,4:010000000000000000000:0x81030:0x81040:both:1:0:0:1,6:001000000000000000000:0x81040:0x81050:both:1:0:0:1,3:000100000000000000000:0x81050:0x81060:both:1:0:0:1,2:000010000000000000000:0x81060:0x81070:both:1:0:0:1,7:000001000000000000000:0x81070:0x81080:both:1:0:0:1,1:000000100000000000000:0x81080:0x81090:both:1:0:0:1,0:000000010000000000000:0x81090:0x810a0:both:1:0:0:1,17:000000001000000000000:0x810a0:0x810b0:both:1:0:0:1,16:000000000100000000000:0x810b0:0x810c0:both:1:0:0:1,15:000000000010000000000:0x810c0:0x810d0:both:1:0:0:1,9:000000000001000000000:0x810d0:0x810e0:both:1:0:0:1,10:000000000000100000000:0x810e0:0x810f0:both:1:0:0:1,8:000000000000001000000:0x810f0:0x81100:both:1:0:0:1,18:000000000000000100000:0x81100:0x81110:both:1:0:0:1,12:000000000000000010000:0x81110:0x81120:both:1:0:0:1,19:000000000000000000010:0x81120:0x81128:read:1:0:0:1,11:000000000000000000001:0x81128:0x81130:both:1:0:0:1
//    st_channel_w            21
//    st_data_w               122
// ------------------------------------------

module hdmi_controller_altera_merlin_router_1921_blajl2q_default_decode
  #(
     parameter DEFAULT_CHANNEL = 7,
               DEFAULT_WR_CHANNEL = -1,
               DEFAULT_RD_CHANNEL = -1,
               DEFAULT_DESTID = 14 
   )
  (output [86 - 82 : 0] default_destination_id,
   output [21-1 : 0] default_wr_channel,
   output [21-1 : 0] default_rd_channel,
   output [21-1 : 0] default_src_channel
  );

  assign default_destination_id = 
    DEFAULT_DESTID[86 - 82 : 0];

  generate
    if (DEFAULT_CHANNEL == -1) begin : no_default_channel_assignment
      assign default_src_channel = '0;
    end
    else begin : default_channel_assignment
      assign default_src_channel = 21'b1 << DEFAULT_CHANNEL;
    end
  endgenerate

  generate
    if (DEFAULT_RD_CHANNEL == -1) begin : no_default_rw_channel_assignment
      assign default_wr_channel = '0;
      assign default_rd_channel = '0;
    end
    else begin : default_rw_channel_assignment
      assign default_wr_channel = 21'b1 << DEFAULT_WR_CHANNEL;
      assign default_rd_channel = 21'b1 << DEFAULT_RD_CHANNEL;
    end
  endgenerate

endmodule


module hdmi_controller_altera_merlin_router_1921_blajl2q
(
    // -------------------
    // Clock & Reset
    // -------------------
    input clk,
    input reset,

    // -------------------
    // Command Sink (Input)
    // -------------------
    input                       sink_valid,
    input  [122-1 : 0]    sink_data,
    input                       sink_startofpacket,
    input                       sink_endofpacket,
    output                      sink_ready,

    // -------------------
    // Command Source (Output)
    // -------------------
    output                          src_valid,
    output reg [122-1    : 0] src_data,
    output reg [21-1 : 0] src_channel,
    output                          src_startofpacket,
    output                          src_endofpacket,
    input                           src_ready
);

    // -------------------------------------------------------
    // Local parameters and variables
    // -------------------------------------------------------
    localparam PKT_ADDR_H = 55;
    localparam PKT_ADDR_L = 36;
    localparam PKT_DEST_ID_H = 86;
    localparam PKT_DEST_ID_L = 82;
    localparam PKT_PROTECTION_H = 90;
    localparam PKT_PROTECTION_L = 88;
    localparam ST_DATA_W = 122;
    localparam ST_CHANNEL_W = 21;
    localparam DECODER_TYPE = 0;

    localparam PKT_TRANS_WRITE = 58;
    localparam PKT_TRANS_READ  = 59;

    localparam PKT_ADDR_W = PKT_ADDR_H-PKT_ADDR_L + 1;
    localparam PKT_DEST_ID_W = PKT_DEST_ID_H-PKT_DEST_ID_L + 1;



    // -------------------------------------------------------
    // Figure out the number of bits to mask off for each slave span
    // during address decoding
    // -------------------------------------------------------
    // -------------------------------------------------------
    // Work out which address bits are significant based on the
    // address range of the slaves. If the required width is too
    // large or too small, we use the address field width instead.
    // -------------------------------------------------------
    localparam ADDR_RANGE = 64'h81130;
    localparam RANGE_ADDR_WIDTH = log2ceil(ADDR_RANGE);
    localparam OPTIMIZED_ADDR_H = (RANGE_ADDR_WIDTH > PKT_ADDR_W) ||
                                  (RANGE_ADDR_WIDTH == 0) ?
                                        PKT_ADDR_H :
                                        PKT_ADDR_L + RANGE_ADDR_WIDTH - 1;

    localparam REAL_ADDRESS_RANGE = OPTIMIZED_ADDR_H - PKT_ADDR_L;

      reg [PKT_ADDR_W-1 : 0] address;
      always @* begin
        address = {PKT_ADDR_W{1'b0}};
        address [REAL_ADDRESS_RANGE:0] = sink_data[OPTIMIZED_ADDR_H : PKT_ADDR_L];
      end   

    // -------------------------------------------------------
    // Pass almost everything through, untouched
    // -------------------------------------------------------
    assign sink_ready        = src_ready;
    assign src_valid         = sink_valid;
    assign src_startofpacket = sink_startofpacket;
    assign src_endofpacket   = sink_endofpacket;
    wire [PKT_DEST_ID_W-1:0] default_destid;
    wire [21-1 : 0] default_src_channel;




    // -------------------------------------------------------
    // Write and read transaction signals
    // -------------------------------------------------------
    wire read_transaction;
    assign read_transaction  = sink_data[PKT_TRANS_READ];


    hdmi_controller_altera_merlin_router_1921_blajl2q_default_decode the_default_decode(
      .default_destination_id (default_destid),
      .default_wr_channel   (),
      .default_rd_channel   (),
      .default_src_channel  (default_src_channel)
    );

    always @* begin
        src_data    = sink_data;
        src_channel = default_src_channel;
        src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = default_destid;

        // --------------------------------------------------
        // Address Decoder
        // Sets the channel and destination ID based on the address
        // --------------------------------------------------

        // slave 0: [0x40000, 0x80000) : sel [19:18]
        if ( {address[19:18],{18 {1'b0}}} == 20'h40000   ) begin
            src_channel = 21'b000000000000010000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 14;
        end

        // slave 1: [0x80800, 0x81000) : sel [19:11]
        if ( {address[19:11],{11 {1'b0}}} == 20'h80800   ) begin
            src_channel = 21'b000000000000000000100;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 13;
        end

        // slave 2: [0x81000, 0x81020) : sel [19:5]
        if ( {address[19:5],{5 {1'b0}}} == 20'h81000   ) begin
            src_channel = 21'b000000000000000001000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 20;
        end

        // slave 3: [0x81020, 0x81030) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h81020   ) begin
            src_channel = 21'b100000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 5;
        end

        // slave 4: [0x81030, 0x81040) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h81030   ) begin
            src_channel = 21'b010000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 4;
        end

        // slave 5: [0x81040, 0x81050) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h81040   ) begin
            src_channel = 21'b001000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 6;
        end

        // slave 6: [0x81050, 0x81060) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h81050   ) begin
            src_channel = 21'b000100000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 3;
        end

        // slave 7: [0x81060, 0x81070) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h81060   ) begin
            src_channel = 21'b000010000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 2;
        end

        // slave 8: [0x81070, 0x81080) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h81070   ) begin
            src_channel = 21'b000001000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 7;
        end

        // slave 9: [0x81080, 0x81090) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h81080   ) begin
            src_channel = 21'b000000100000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 1;
        end

        // slave 10: [0x81090, 0x810a0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h81090   ) begin
            src_channel = 21'b000000010000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 0;
        end

        // slave 11: [0x810a0, 0x810b0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h810a0   ) begin
            src_channel = 21'b000000001000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 17;
        end

        // slave 12: [0x810b0, 0x810c0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h810b0   ) begin
            src_channel = 21'b000000000100000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 16;
        end

        // slave 13: [0x810c0, 0x810d0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h810c0   ) begin
            src_channel = 21'b000000000010000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 15;
        end

        // slave 14: [0x810d0, 0x810e0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h810d0   ) begin
            src_channel = 21'b000000000001000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 9;
        end

        // slave 15: [0x810e0, 0x810f0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h810e0   ) begin
            src_channel = 21'b000000000000100000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 10;
        end

        // slave 16: [0x810f0, 0x81100) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h810f0   ) begin
            src_channel = 21'b000000000000001000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 8;
        end

        // slave 17: [0x81100, 0x81110) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h81100   ) begin
            src_channel = 21'b000000000000000100000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 18;
        end

        // slave 18: [0x81110, 0x81120) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h81110   ) begin
            src_channel = 21'b000000000000000010000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 12;
        end

        // slave 19: [0x81120, 0x81128) : sel [19:3]
        if ( {address[19:3],{3 {1'b0}}} == 20'h81120  && read_transaction  ) begin
            src_channel = 21'b000000000000000000010;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 19;
        end

        // slave 20: [0x81128, 0x81130) : sel [19:3]
        if ( {address[19:3],{3 {1'b0}}} == 20'h81128   ) begin
            src_channel = 21'b000000000000000000001;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 11;
        end
    end


    // --------------------------------------------------
    // Ceil(log2()) function
    // It's the 21st century. Consider using $clog2().
    // --------------------------------------------------
    function integer log2ceil;
        input reg[65:0] val;
        reg [65:0] i;

        begin
            i = 1;
            log2ceil = 0;

            while (i < val) begin
                log2ceil = log2ceil + 1;
                i = i << 1;
            end
        end
    endfunction

endmodule


