// hdmi_controller.v

// Generated using ACDS version 23.4 79

`timescale 1 ps / 1 ps
module hdmi_controller (
		output wire       i2c_scl_external_connection_export,             //             i2c_scl_external_connection.export
		inout  wire       i2c_sda_external_connection_export,             //             i2c_sda_external_connection.export
		output wire       rx0_edid_i2c_scl_external_connection_export,    //    rx0_edid_i2c_scl_external_connection.export
		inout  wire       rx0_edid_i2c_sda_external_connection_export,    //    rx0_edid_i2c_sda_external_connection.export
		output wire       rx1_edid_i2c_scl_external_connection_export,    //    rx1_edid_i2c_scl_external_connection.export
		inout  wire       rx1_edid_i2c_sda_external_connection_export,    //    rx1_edid_i2c_sda_external_connection.export
		input  wire       adv7619_int_external_connection_export,         //         adv7619_int_external_connection.export
		output wire       adv7619_rst_external_connection_export,         //         adv7619_rst_external_connection.export
		input  wire [3:0] in_port_to_the_button,                          //              button_external_connection.export
		input  wire       clk_50,                                         //                           clk_50_clk_in.clk
		input  wire       reset_n,                                        //                     clk_50_clk_in_reset.reset_n
		output wire       hdmi_tx_fmc_i2c_scl_external_connection_export, // hdmi_tx_fmc_i2c_scl_external_connection.export
		inout  wire       hdmi_tx_fmc_i2c_sda_external_connection_export, // hdmi_tx_fmc_i2c_sda_external_connection.export
		output wire [3:0] out_port_from_the_led,                          //                 led_external_connection.export
		input  wire       sii9136_int_external_connection_export,         //         sii9136_int_external_connection.export
		output wire       sii9136_rst_n_external_connection_export,       //       sii9136_rst_n_external_connection.export
		input  wire       sii9678_int_external_connection_export,         //         sii9678_int_external_connection.export
		input  wire [3:0] sw_external_connection_export                   //                  sw_external_connection.export
	);

	wire         clk_50_clk_clk;                                             // clk_50:clk_out -> [I2C_SCL:clk, I2C_SDA:clk, RX0_EDID_I2C_SCL:clk, RX0_EDID_I2C_SDA:clk, RX1_EDID_I2C_SCL:clk, RX1_EDID_I2C_SDA:clk, adv7619_int:clk, adv7619_rst:clk, button:clk, hdmi_tx_fmc_i2c_scl:clk, hdmi_tx_fmc_i2c_sda:clk, irq_mapper:clk, jtag_uart:clk, led:clk, mm_interconnect_0:clk_50_clk_clk, nios2_gen2_0:clk, onchip_memory2:clk, rst_controller:clk, rst_controller_001:clk, sii9136_int:clk, sii9136_rst_n:clk, sii9678_int:clk, sw:clk, sysid_qsys_0:clock, timer:clk]
	wire  [31:0] nios2_gen2_0_data_master_readdata;                          // mm_interconnect_0:nios2_gen2_0_data_master_readdata -> nios2_gen2_0:d_readdata
	wire         nios2_gen2_0_data_master_waitrequest;                       // mm_interconnect_0:nios2_gen2_0_data_master_waitrequest -> nios2_gen2_0:d_waitrequest
	wire         nios2_gen2_0_data_master_debugaccess;                       // nios2_gen2_0:debug_mem_slave_debugaccess_to_roms -> mm_interconnect_0:nios2_gen2_0_data_master_debugaccess
	wire  [19:0] nios2_gen2_0_data_master_address;                           // nios2_gen2_0:d_address -> mm_interconnect_0:nios2_gen2_0_data_master_address
	wire   [3:0] nios2_gen2_0_data_master_byteenable;                        // nios2_gen2_0:d_byteenable -> mm_interconnect_0:nios2_gen2_0_data_master_byteenable
	wire         nios2_gen2_0_data_master_read;                              // nios2_gen2_0:d_read -> mm_interconnect_0:nios2_gen2_0_data_master_read
	wire         nios2_gen2_0_data_master_readdatavalid;                     // mm_interconnect_0:nios2_gen2_0_data_master_readdatavalid -> nios2_gen2_0:d_readdatavalid
	wire         nios2_gen2_0_data_master_write;                             // nios2_gen2_0:d_write -> mm_interconnect_0:nios2_gen2_0_data_master_write
	wire  [31:0] nios2_gen2_0_data_master_writedata;                         // nios2_gen2_0:d_writedata -> mm_interconnect_0:nios2_gen2_0_data_master_writedata
	wire  [31:0] nios2_gen2_0_instruction_master_readdata;                   // mm_interconnect_0:nios2_gen2_0_instruction_master_readdata -> nios2_gen2_0:i_readdata
	wire         nios2_gen2_0_instruction_master_waitrequest;                // mm_interconnect_0:nios2_gen2_0_instruction_master_waitrequest -> nios2_gen2_0:i_waitrequest
	wire  [19:0] nios2_gen2_0_instruction_master_address;                    // nios2_gen2_0:i_address -> mm_interconnect_0:nios2_gen2_0_instruction_master_address
	wire         nios2_gen2_0_instruction_master_read;                       // nios2_gen2_0:i_read -> mm_interconnect_0:nios2_gen2_0_instruction_master_read
	wire         nios2_gen2_0_instruction_master_readdatavalid;              // mm_interconnect_0:nios2_gen2_0_instruction_master_readdatavalid -> nios2_gen2_0:i_readdatavalid
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect;   // mm_interconnect_0:jtag_uart_avalon_jtag_slave_chipselect -> jtag_uart:av_chipselect
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata;     // jtag_uart:av_readdata -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_readdata
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest;  // jtag_uart:av_waitrequest -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_waitrequest
	wire   [0:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_address;      // mm_interconnect_0:jtag_uart_avalon_jtag_slave_address -> jtag_uart:av_address
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_read;         // mm_interconnect_0:jtag_uart_avalon_jtag_slave_read -> jtag_uart:av_read_n
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_write;        // mm_interconnect_0:jtag_uart_avalon_jtag_slave_write -> jtag_uart:av_write_n
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata;    // mm_interconnect_0:jtag_uart_avalon_jtag_slave_writedata -> jtag_uart:av_writedata
	wire  [31:0] mm_interconnect_0_sysid_qsys_0_control_slave_readdata;      // sysid_qsys_0:readdata -> mm_interconnect_0:sysid_qsys_0_control_slave_readdata
	wire   [0:0] mm_interconnect_0_sysid_qsys_0_control_slave_address;       // mm_interconnect_0:sysid_qsys_0_control_slave_address -> sysid_qsys_0:address
	wire  [31:0] mm_interconnect_0_nios2_gen2_0_debug_mem_slave_readdata;    // nios2_gen2_0:debug_mem_slave_readdata -> mm_interconnect_0:nios2_gen2_0_debug_mem_slave_readdata
	wire         mm_interconnect_0_nios2_gen2_0_debug_mem_slave_waitrequest; // nios2_gen2_0:debug_mem_slave_waitrequest -> mm_interconnect_0:nios2_gen2_0_debug_mem_slave_waitrequest
	wire         mm_interconnect_0_nios2_gen2_0_debug_mem_slave_debugaccess; // mm_interconnect_0:nios2_gen2_0_debug_mem_slave_debugaccess -> nios2_gen2_0:debug_mem_slave_debugaccess
	wire   [8:0] mm_interconnect_0_nios2_gen2_0_debug_mem_slave_address;     // mm_interconnect_0:nios2_gen2_0_debug_mem_slave_address -> nios2_gen2_0:debug_mem_slave_address
	wire         mm_interconnect_0_nios2_gen2_0_debug_mem_slave_read;        // mm_interconnect_0:nios2_gen2_0_debug_mem_slave_read -> nios2_gen2_0:debug_mem_slave_read
	wire   [3:0] mm_interconnect_0_nios2_gen2_0_debug_mem_slave_byteenable;  // mm_interconnect_0:nios2_gen2_0_debug_mem_slave_byteenable -> nios2_gen2_0:debug_mem_slave_byteenable
	wire         mm_interconnect_0_nios2_gen2_0_debug_mem_slave_write;       // mm_interconnect_0:nios2_gen2_0_debug_mem_slave_write -> nios2_gen2_0:debug_mem_slave_write
	wire  [31:0] mm_interconnect_0_nios2_gen2_0_debug_mem_slave_writedata;   // mm_interconnect_0:nios2_gen2_0_debug_mem_slave_writedata -> nios2_gen2_0:debug_mem_slave_writedata
	wire         mm_interconnect_0_timer_s1_chipselect;                      // mm_interconnect_0:timer_s1_chipselect -> timer:chipselect
	wire  [15:0] mm_interconnect_0_timer_s1_readdata;                        // timer:readdata -> mm_interconnect_0:timer_s1_readdata
	wire   [2:0] mm_interconnect_0_timer_s1_address;                         // mm_interconnect_0:timer_s1_address -> timer:address
	wire         mm_interconnect_0_timer_s1_write;                           // mm_interconnect_0:timer_s1_write -> timer:write_n
	wire  [15:0] mm_interconnect_0_timer_s1_writedata;                       // mm_interconnect_0:timer_s1_writedata -> timer:writedata
	wire         mm_interconnect_0_led_s1_chipselect;                        // mm_interconnect_0:led_s1_chipselect -> led:chipselect
	wire  [31:0] mm_interconnect_0_led_s1_readdata;                          // led:readdata -> mm_interconnect_0:led_s1_readdata
	wire   [1:0] mm_interconnect_0_led_s1_address;                           // mm_interconnect_0:led_s1_address -> led:address
	wire         mm_interconnect_0_led_s1_write;                             // mm_interconnect_0:led_s1_write -> led:write_n
	wire  [31:0] mm_interconnect_0_led_s1_writedata;                         // mm_interconnect_0:led_s1_writedata -> led:writedata
	wire         mm_interconnect_0_sw_s1_chipselect;                         // mm_interconnect_0:sw_s1_chipselect -> sw:chipselect
	wire  [31:0] mm_interconnect_0_sw_s1_readdata;                           // sw:readdata -> mm_interconnect_0:sw_s1_readdata
	wire   [1:0] mm_interconnect_0_sw_s1_address;                            // mm_interconnect_0:sw_s1_address -> sw:address
	wire         mm_interconnect_0_sw_s1_write;                              // mm_interconnect_0:sw_s1_write -> sw:write_n
	wire  [31:0] mm_interconnect_0_sw_s1_writedata;                          // mm_interconnect_0:sw_s1_writedata -> sw:writedata
	wire         mm_interconnect_0_button_s1_chipselect;                     // mm_interconnect_0:button_s1_chipselect -> button:chipselect
	wire  [31:0] mm_interconnect_0_button_s1_readdata;                       // button:readdata -> mm_interconnect_0:button_s1_readdata
	wire   [1:0] mm_interconnect_0_button_s1_address;                        // mm_interconnect_0:button_s1_address -> button:address
	wire         mm_interconnect_0_button_s1_write;                          // mm_interconnect_0:button_s1_write -> button:write_n
	wire  [31:0] mm_interconnect_0_button_s1_writedata;                      // mm_interconnect_0:button_s1_writedata -> button:writedata
	wire         mm_interconnect_0_onchip_memory2_s1_chipselect;             // mm_interconnect_0:onchip_memory2_s1_chipselect -> onchip_memory2:chipselect
	wire  [31:0] mm_interconnect_0_onchip_memory2_s1_readdata;               // onchip_memory2:readdata -> mm_interconnect_0:onchip_memory2_s1_readdata
	wire  [15:0] mm_interconnect_0_onchip_memory2_s1_address;                // mm_interconnect_0:onchip_memory2_s1_address -> onchip_memory2:address
	wire   [3:0] mm_interconnect_0_onchip_memory2_s1_byteenable;             // mm_interconnect_0:onchip_memory2_s1_byteenable -> onchip_memory2:byteenable
	wire         mm_interconnect_0_onchip_memory2_s1_write;                  // mm_interconnect_0:onchip_memory2_s1_write -> onchip_memory2:write
	wire  [31:0] mm_interconnect_0_onchip_memory2_s1_writedata;              // mm_interconnect_0:onchip_memory2_s1_writedata -> onchip_memory2:writedata
	wire         mm_interconnect_0_onchip_memory2_s1_clken;                  // mm_interconnect_0:onchip_memory2_s1_clken -> onchip_memory2:clken
	wire         mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_chipselect;        // mm_interconnect_0:hdmi_tx_fmc_i2c_sda_s1_chipselect -> hdmi_tx_fmc_i2c_sda:chipselect
	wire  [31:0] mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_readdata;          // hdmi_tx_fmc_i2c_sda:readdata -> mm_interconnect_0:hdmi_tx_fmc_i2c_sda_s1_readdata
	wire   [1:0] mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_address;           // mm_interconnect_0:hdmi_tx_fmc_i2c_sda_s1_address -> hdmi_tx_fmc_i2c_sda:address
	wire         mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_write;             // mm_interconnect_0:hdmi_tx_fmc_i2c_sda_s1_write -> hdmi_tx_fmc_i2c_sda:write_n
	wire  [31:0] mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_writedata;         // mm_interconnect_0:hdmi_tx_fmc_i2c_sda_s1_writedata -> hdmi_tx_fmc_i2c_sda:writedata
	wire         mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_chipselect;        // mm_interconnect_0:hdmi_tx_fmc_i2c_scl_s1_chipselect -> hdmi_tx_fmc_i2c_scl:chipselect
	wire  [31:0] mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_readdata;          // hdmi_tx_fmc_i2c_scl:readdata -> mm_interconnect_0:hdmi_tx_fmc_i2c_scl_s1_readdata
	wire   [1:0] mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_address;           // mm_interconnect_0:hdmi_tx_fmc_i2c_scl_s1_address -> hdmi_tx_fmc_i2c_scl:address
	wire         mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_write;             // mm_interconnect_0:hdmi_tx_fmc_i2c_scl_s1_write -> hdmi_tx_fmc_i2c_scl:write_n
	wire  [31:0] mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_writedata;         // mm_interconnect_0:hdmi_tx_fmc_i2c_scl_s1_writedata -> hdmi_tx_fmc_i2c_scl:writedata
	wire         mm_interconnect_0_sii9136_int_s1_chipselect;                // mm_interconnect_0:sii9136_int_s1_chipselect -> sii9136_int:chipselect
	wire  [31:0] mm_interconnect_0_sii9136_int_s1_readdata;                  // sii9136_int:readdata -> mm_interconnect_0:sii9136_int_s1_readdata
	wire   [1:0] mm_interconnect_0_sii9136_int_s1_address;                   // mm_interconnect_0:sii9136_int_s1_address -> sii9136_int:address
	wire         mm_interconnect_0_sii9136_int_s1_write;                     // mm_interconnect_0:sii9136_int_s1_write -> sii9136_int:write_n
	wire  [31:0] mm_interconnect_0_sii9136_int_s1_writedata;                 // mm_interconnect_0:sii9136_int_s1_writedata -> sii9136_int:writedata
	wire         mm_interconnect_0_sii9136_rst_n_s1_chipselect;              // mm_interconnect_0:sii9136_rst_n_s1_chipselect -> sii9136_rst_n:chipselect
	wire  [31:0] mm_interconnect_0_sii9136_rst_n_s1_readdata;                // sii9136_rst_n:readdata -> mm_interconnect_0:sii9136_rst_n_s1_readdata
	wire   [1:0] mm_interconnect_0_sii9136_rst_n_s1_address;                 // mm_interconnect_0:sii9136_rst_n_s1_address -> sii9136_rst_n:address
	wire         mm_interconnect_0_sii9136_rst_n_s1_write;                   // mm_interconnect_0:sii9136_rst_n_s1_write -> sii9136_rst_n:write_n
	wire  [31:0] mm_interconnect_0_sii9136_rst_n_s1_writedata;               // mm_interconnect_0:sii9136_rst_n_s1_writedata -> sii9136_rst_n:writedata
	wire         mm_interconnect_0_sii9678_int_s1_chipselect;                // mm_interconnect_0:sii9678_int_s1_chipselect -> sii9678_int:chipselect
	wire  [31:0] mm_interconnect_0_sii9678_int_s1_readdata;                  // sii9678_int:readdata -> mm_interconnect_0:sii9678_int_s1_readdata
	wire   [1:0] mm_interconnect_0_sii9678_int_s1_address;                   // mm_interconnect_0:sii9678_int_s1_address -> sii9678_int:address
	wire         mm_interconnect_0_sii9678_int_s1_write;                     // mm_interconnect_0:sii9678_int_s1_write -> sii9678_int:write_n
	wire  [31:0] mm_interconnect_0_sii9678_int_s1_writedata;                 // mm_interconnect_0:sii9678_int_s1_writedata -> sii9678_int:writedata
	wire         mm_interconnect_0_i2c_scl_s1_chipselect;                    // mm_interconnect_0:I2C_SCL_s1_chipselect -> I2C_SCL:chipselect
	wire  [31:0] mm_interconnect_0_i2c_scl_s1_readdata;                      // I2C_SCL:readdata -> mm_interconnect_0:I2C_SCL_s1_readdata
	wire   [1:0] mm_interconnect_0_i2c_scl_s1_address;                       // mm_interconnect_0:I2C_SCL_s1_address -> I2C_SCL:address
	wire         mm_interconnect_0_i2c_scl_s1_write;                         // mm_interconnect_0:I2C_SCL_s1_write -> I2C_SCL:write_n
	wire  [31:0] mm_interconnect_0_i2c_scl_s1_writedata;                     // mm_interconnect_0:I2C_SCL_s1_writedata -> I2C_SCL:writedata
	wire         mm_interconnect_0_i2c_sda_s1_chipselect;                    // mm_interconnect_0:I2C_SDA_s1_chipselect -> I2C_SDA:chipselect
	wire  [31:0] mm_interconnect_0_i2c_sda_s1_readdata;                      // I2C_SDA:readdata -> mm_interconnect_0:I2C_SDA_s1_readdata
	wire   [1:0] mm_interconnect_0_i2c_sda_s1_address;                       // mm_interconnect_0:I2C_SDA_s1_address -> I2C_SDA:address
	wire         mm_interconnect_0_i2c_sda_s1_write;                         // mm_interconnect_0:I2C_SDA_s1_write -> I2C_SDA:write_n
	wire  [31:0] mm_interconnect_0_i2c_sda_s1_writedata;                     // mm_interconnect_0:I2C_SDA_s1_writedata -> I2C_SDA:writedata
	wire         mm_interconnect_0_adv7619_rst_s1_chipselect;                // mm_interconnect_0:adv7619_rst_s1_chipselect -> adv7619_rst:chipselect
	wire  [31:0] mm_interconnect_0_adv7619_rst_s1_readdata;                  // adv7619_rst:readdata -> mm_interconnect_0:adv7619_rst_s1_readdata
	wire   [1:0] mm_interconnect_0_adv7619_rst_s1_address;                   // mm_interconnect_0:adv7619_rst_s1_address -> adv7619_rst:address
	wire         mm_interconnect_0_adv7619_rst_s1_write;                     // mm_interconnect_0:adv7619_rst_s1_write -> adv7619_rst:write_n
	wire  [31:0] mm_interconnect_0_adv7619_rst_s1_writedata;                 // mm_interconnect_0:adv7619_rst_s1_writedata -> adv7619_rst:writedata
	wire         mm_interconnect_0_rx0_edid_i2c_scl_s1_chipselect;           // mm_interconnect_0:RX0_EDID_I2C_SCL_s1_chipselect -> RX0_EDID_I2C_SCL:chipselect
	wire  [31:0] mm_interconnect_0_rx0_edid_i2c_scl_s1_readdata;             // RX0_EDID_I2C_SCL:readdata -> mm_interconnect_0:RX0_EDID_I2C_SCL_s1_readdata
	wire   [1:0] mm_interconnect_0_rx0_edid_i2c_scl_s1_address;              // mm_interconnect_0:RX0_EDID_I2C_SCL_s1_address -> RX0_EDID_I2C_SCL:address
	wire         mm_interconnect_0_rx0_edid_i2c_scl_s1_write;                // mm_interconnect_0:RX0_EDID_I2C_SCL_s1_write -> RX0_EDID_I2C_SCL:write_n
	wire  [31:0] mm_interconnect_0_rx0_edid_i2c_scl_s1_writedata;            // mm_interconnect_0:RX0_EDID_I2C_SCL_s1_writedata -> RX0_EDID_I2C_SCL:writedata
	wire         mm_interconnect_0_rx0_edid_i2c_sda_s1_chipselect;           // mm_interconnect_0:RX0_EDID_I2C_SDA_s1_chipselect -> RX0_EDID_I2C_SDA:chipselect
	wire  [31:0] mm_interconnect_0_rx0_edid_i2c_sda_s1_readdata;             // RX0_EDID_I2C_SDA:readdata -> mm_interconnect_0:RX0_EDID_I2C_SDA_s1_readdata
	wire   [1:0] mm_interconnect_0_rx0_edid_i2c_sda_s1_address;              // mm_interconnect_0:RX0_EDID_I2C_SDA_s1_address -> RX0_EDID_I2C_SDA:address
	wire         mm_interconnect_0_rx0_edid_i2c_sda_s1_write;                // mm_interconnect_0:RX0_EDID_I2C_SDA_s1_write -> RX0_EDID_I2C_SDA:write_n
	wire  [31:0] mm_interconnect_0_rx0_edid_i2c_sda_s1_writedata;            // mm_interconnect_0:RX0_EDID_I2C_SDA_s1_writedata -> RX0_EDID_I2C_SDA:writedata
	wire         mm_interconnect_0_adv7619_int_s1_chipselect;                // mm_interconnect_0:adv7619_int_s1_chipselect -> adv7619_int:chipselect
	wire  [31:0] mm_interconnect_0_adv7619_int_s1_readdata;                  // adv7619_int:readdata -> mm_interconnect_0:adv7619_int_s1_readdata
	wire   [1:0] mm_interconnect_0_adv7619_int_s1_address;                   // mm_interconnect_0:adv7619_int_s1_address -> adv7619_int:address
	wire         mm_interconnect_0_adv7619_int_s1_write;                     // mm_interconnect_0:adv7619_int_s1_write -> adv7619_int:write_n
	wire  [31:0] mm_interconnect_0_adv7619_int_s1_writedata;                 // mm_interconnect_0:adv7619_int_s1_writedata -> adv7619_int:writedata
	wire         mm_interconnect_0_rx1_edid_i2c_scl_s1_chipselect;           // mm_interconnect_0:RX1_EDID_I2C_SCL_s1_chipselect -> RX1_EDID_I2C_SCL:chipselect
	wire  [31:0] mm_interconnect_0_rx1_edid_i2c_scl_s1_readdata;             // RX1_EDID_I2C_SCL:readdata -> mm_interconnect_0:RX1_EDID_I2C_SCL_s1_readdata
	wire   [1:0] mm_interconnect_0_rx1_edid_i2c_scl_s1_address;              // mm_interconnect_0:RX1_EDID_I2C_SCL_s1_address -> RX1_EDID_I2C_SCL:address
	wire         mm_interconnect_0_rx1_edid_i2c_scl_s1_write;                // mm_interconnect_0:RX1_EDID_I2C_SCL_s1_write -> RX1_EDID_I2C_SCL:write_n
	wire  [31:0] mm_interconnect_0_rx1_edid_i2c_scl_s1_writedata;            // mm_interconnect_0:RX1_EDID_I2C_SCL_s1_writedata -> RX1_EDID_I2C_SCL:writedata
	wire         mm_interconnect_0_rx1_edid_i2c_sda_s1_chipselect;           // mm_interconnect_0:RX1_EDID_I2C_SDA_s1_chipselect -> RX1_EDID_I2C_SDA:chipselect
	wire  [31:0] mm_interconnect_0_rx1_edid_i2c_sda_s1_readdata;             // RX1_EDID_I2C_SDA:readdata -> mm_interconnect_0:RX1_EDID_I2C_SDA_s1_readdata
	wire   [1:0] mm_interconnect_0_rx1_edid_i2c_sda_s1_address;              // mm_interconnect_0:RX1_EDID_I2C_SDA_s1_address -> RX1_EDID_I2C_SDA:address
	wire         mm_interconnect_0_rx1_edid_i2c_sda_s1_write;                // mm_interconnect_0:RX1_EDID_I2C_SDA_s1_write -> RX1_EDID_I2C_SDA:write_n
	wire  [31:0] mm_interconnect_0_rx1_edid_i2c_sda_s1_writedata;            // mm_interconnect_0:RX1_EDID_I2C_SDA_s1_writedata -> RX1_EDID_I2C_SDA:writedata
	wire         irq_mapper_receiver0_irq;                                   // timer:irq -> irq_mapper:receiver0_irq
	wire         irq_mapper_receiver1_irq;                                   // sw:irq -> irq_mapper:receiver1_irq
	wire         irq_mapper_receiver2_irq;                                   // button:irq -> irq_mapper:receiver2_irq
	wire         irq_mapper_receiver3_irq;                                   // jtag_uart:av_irq -> irq_mapper:receiver3_irq
	wire         irq_mapper_receiver4_irq;                                   // sii9136_int:irq -> irq_mapper:receiver4_irq
	wire         irq_mapper_receiver5_irq;                                   // sii9678_int:irq -> irq_mapper:receiver5_irq
	wire         irq_mapper_receiver6_irq;                                   // adv7619_int:irq -> irq_mapper:receiver6_irq
	wire  [31:0] nios2_gen2_0_irq_irq;                                       // irq_mapper:sender_irq -> nios2_gen2_0:irq
	wire         rst_controller_reset_out_reset;                             // rst_controller:reset_out -> [I2C_SCL:reset_n, I2C_SDA:reset_n, RX0_EDID_I2C_SCL:reset_n, RX0_EDID_I2C_SDA:reset_n, RX1_EDID_I2C_SCL:reset_n, RX1_EDID_I2C_SDA:reset_n, adv7619_int:reset_n, adv7619_rst:reset_n, button:reset_n, hdmi_tx_fmc_i2c_scl:reset_n, hdmi_tx_fmc_i2c_sda:reset_n, jtag_uart:rst_n, led:reset_n, mm_interconnect_0:jtag_uart_reset_reset_bridge_in_reset_reset, onchip_memory2:reset, rst_translator:in_reset, sii9136_int:reset_n, sii9136_rst_n:reset_n, sii9678_int:reset_n, sw:reset_n, sysid_qsys_0:reset_n, timer:reset_n]
	wire         rst_controller_reset_out_reset_req;                         // rst_controller:reset_req -> [onchip_memory2:reset_req, rst_translator:reset_req_in]
	wire         clk_50_clk_reset_reset;                                     // clk_50:reset_n_out -> [rst_controller:reset_in0, rst_controller_001:reset_in0]
	wire         rst_controller_001_reset_out_reset;                         // rst_controller_001:reset_out -> [irq_mapper:reset, mm_interconnect_0:nios2_gen2_0_reset_reset_bridge_in_reset_reset, nios2_gen2_0:reset_n]
	wire         rst_controller_001_reset_out_reset_req;                     // rst_controller_001:reset_req -> [nios2_gen2_0:reset_req, rst_translator_001:reset_req_in]
	wire         nios2_gen2_0_debug_reset_request_reset;                     // nios2_gen2_0:debug_reset_request -> rst_controller_001:reset_in1

	hdmi_controller_I2C_SCL i2c_scl (
		.clk        (clk_50_clk_clk),                          //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),         //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_i2c_scl_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_i2c_scl_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_i2c_scl_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_i2c_scl_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_i2c_scl_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (i2c_scl_external_connection_export)       //  output,   width = 1, external_connection.export
	);

	hdmi_controller_I2C_SDA i2c_sda (
		.clk        (clk_50_clk_clk),                          //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),         //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_i2c_sda_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_i2c_sda_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_i2c_sda_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_i2c_sda_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_i2c_sda_s1_readdata),   //  output,  width = 32,                    .readdata
		.bidir_port (i2c_sda_external_connection_export)       //   inout,   width = 1, external_connection.export
	);

	hdmi_controller_RX0_EDID_I2C_SCL rx0_edid_i2c_scl (
		.clk        (clk_50_clk_clk),                                   //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),                  //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_rx0_edid_i2c_scl_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_rx0_edid_i2c_scl_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_rx0_edid_i2c_scl_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_rx0_edid_i2c_scl_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_rx0_edid_i2c_scl_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (rx0_edid_i2c_scl_external_connection_export)       //  output,   width = 1, external_connection.export
	);

	hdmi_controller_RX0_EDID_I2C_SDA rx0_edid_i2c_sda (
		.clk        (clk_50_clk_clk),                                   //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),                  //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_rx0_edid_i2c_sda_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_rx0_edid_i2c_sda_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_rx0_edid_i2c_sda_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_rx0_edid_i2c_sda_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_rx0_edid_i2c_sda_s1_readdata),   //  output,  width = 32,                    .readdata
		.bidir_port (rx0_edid_i2c_sda_external_connection_export)       //   inout,   width = 1, external_connection.export
	);

	hdmi_controller_RX1_EDID_I2C_SCL rx1_edid_i2c_scl (
		.clk        (clk_50_clk_clk),                                   //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),                  //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_rx1_edid_i2c_scl_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_rx1_edid_i2c_scl_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_rx1_edid_i2c_scl_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_rx1_edid_i2c_scl_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_rx1_edid_i2c_scl_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (rx1_edid_i2c_scl_external_connection_export)       //  output,   width = 1, external_connection.export
	);

	hdmi_controller_RX1_EDID_I2C_SDA rx1_edid_i2c_sda (
		.clk        (clk_50_clk_clk),                                   //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),                  //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_rx1_edid_i2c_sda_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_rx1_edid_i2c_sda_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_rx1_edid_i2c_sda_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_rx1_edid_i2c_sda_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_rx1_edid_i2c_sda_s1_readdata),   //  output,  width = 32,                    .readdata
		.bidir_port (rx1_edid_i2c_sda_external_connection_export)       //   inout,   width = 1, external_connection.export
	);

	hdmi_controller_adv7619_int adv7619_int (
		.clk        (clk_50_clk_clk),                              //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),             //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_adv7619_int_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_adv7619_int_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_adv7619_int_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_adv7619_int_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_adv7619_int_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (adv7619_int_external_connection_export),      //   input,   width = 1, external_connection.export
		.irq        (irq_mapper_receiver6_irq)                     //  output,   width = 1,                 irq.irq
	);

	hdmi_controller_adv7619_rst adv7619_rst (
		.clk        (clk_50_clk_clk),                              //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),             //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_adv7619_rst_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_adv7619_rst_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_adv7619_rst_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_adv7619_rst_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_adv7619_rst_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (adv7619_rst_external_connection_export)       //  output,   width = 1, external_connection.export
	);

	hdmi_controller_button button (
		.clk        (clk_50_clk_clk),                         //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),        //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_button_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_button_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_button_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_button_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_button_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (in_port_to_the_button),                  //   input,   width = 4, external_connection.export
		.irq        (irq_mapper_receiver2_irq)                //  output,   width = 1,                 irq.irq
	);

	hdmi_controller_clk_50 clk_50_inst (
		.in_clk      (clk_50),                 //   input,  width = 1,       clk_in.clk
		.reset_n     (reset_n),                //   input,  width = 1, clk_in_reset.reset_n
		.clk_out     (clk_50_clk_clk),         //  output,  width = 1,          clk.clk
		.reset_n_out (clk_50_clk_reset_reset)  //  output,  width = 1,    clk_reset.reset_n
	);

	hdmi_controller_hdmi_tx_fmc_i2c_scl hdmi_tx_fmc_i2c_scl (
		.clk        (clk_50_clk_clk),                                      //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),                     //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (hdmi_tx_fmc_i2c_scl_external_connection_export)       //  output,   width = 1, external_connection.export
	);

	hdmi_controller_hdmi_tx_fmc_i2c_sda hdmi_tx_fmc_i2c_sda (
		.clk        (clk_50_clk_clk),                                      //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),                     //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_readdata),   //  output,  width = 32,                    .readdata
		.bidir_port (hdmi_tx_fmc_i2c_sda_external_connection_export)       //   inout,   width = 1, external_connection.export
	);

	hdmi_controller_jtag_uart jtag_uart (
		.clk            (clk_50_clk_clk),                                            //   input,   width = 1,               clk.clk
		.rst_n          (~rst_controller_reset_out_reset),                           //   input,   width = 1,             reset.reset_n
		.av_chipselect  (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),  //   input,   width = 1, avalon_jtag_slave.chipselect
		.av_address     (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),     //   input,   width = 1,                  .address
		.av_read_n      (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),       //   input,   width = 1,                  .read_n
		.av_readdata    (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),    //  output,  width = 32,                  .readdata
		.av_write_n     (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),      //   input,   width = 1,                  .write_n
		.av_writedata   (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),   //   input,  width = 32,                  .writedata
		.av_waitrequest (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest), //  output,   width = 1,                  .waitrequest
		.av_irq         (irq_mapper_receiver3_irq)                                   //  output,   width = 1,               irq.irq
	);

	hdmi_controller_led led (
		.clk        (clk_50_clk_clk),                      //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),     //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_led_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_led_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_led_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_led_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_led_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (out_port_from_the_led)                //  output,   width = 4, external_connection.export
	);

	hdmi_controller_nios2_gen2_0 nios2_gen2_0 (
		.clk                                 (clk_50_clk_clk),                                             //   input,   width = 1,                       clk.clk
		.reset_n                             (~rst_controller_001_reset_out_reset),                        //   input,   width = 1,                     reset.reset_n
		.reset_req                           (rst_controller_001_reset_out_reset_req),                     //   input,   width = 1,                          .reset_req
		.d_address                           (nios2_gen2_0_data_master_address),                           //  output,  width = 20,               data_master.address
		.d_byteenable                        (nios2_gen2_0_data_master_byteenable),                        //  output,   width = 4,                          .byteenable
		.d_read                              (nios2_gen2_0_data_master_read),                              //  output,   width = 1,                          .read
		.d_readdata                          (nios2_gen2_0_data_master_readdata),                          //   input,  width = 32,                          .readdata
		.d_waitrequest                       (nios2_gen2_0_data_master_waitrequest),                       //   input,   width = 1,                          .waitrequest
		.d_write                             (nios2_gen2_0_data_master_write),                             //  output,   width = 1,                          .write
		.d_writedata                         (nios2_gen2_0_data_master_writedata),                         //  output,  width = 32,                          .writedata
		.d_readdatavalid                     (nios2_gen2_0_data_master_readdatavalid),                     //   input,   width = 1,                          .readdatavalid
		.debug_mem_slave_debugaccess_to_roms (nios2_gen2_0_data_master_debugaccess),                       //  output,   width = 1,                          .debugaccess
		.i_address                           (nios2_gen2_0_instruction_master_address),                    //  output,  width = 20,        instruction_master.address
		.i_read                              (nios2_gen2_0_instruction_master_read),                       //  output,   width = 1,                          .read
		.i_readdata                          (nios2_gen2_0_instruction_master_readdata),                   //   input,  width = 32,                          .readdata
		.i_waitrequest                       (nios2_gen2_0_instruction_master_waitrequest),                //   input,   width = 1,                          .waitrequest
		.i_readdatavalid                     (nios2_gen2_0_instruction_master_readdatavalid),              //   input,   width = 1,                          .readdatavalid
		.irq                                 (nios2_gen2_0_irq_irq),                                       //   input,  width = 32,                       irq.irq
		.debug_reset_request                 (nios2_gen2_0_debug_reset_request_reset),                     //  output,   width = 1,       debug_reset_request.reset
		.debug_mem_slave_address             (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_address),     //   input,   width = 9,           debug_mem_slave.address
		.debug_mem_slave_byteenable          (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_byteenable),  //   input,   width = 4,                          .byteenable
		.debug_mem_slave_debugaccess         (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_debugaccess), //   input,   width = 1,                          .debugaccess
		.debug_mem_slave_read                (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_read),        //   input,   width = 1,                          .read
		.debug_mem_slave_readdata            (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_readdata),    //  output,  width = 32,                          .readdata
		.debug_mem_slave_waitrequest         (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_waitrequest), //  output,   width = 1,                          .waitrequest
		.debug_mem_slave_write               (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_write),       //   input,   width = 1,                          .write
		.debug_mem_slave_writedata           (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_writedata),   //   input,  width = 32,                          .writedata
		.dummy_ci_port                       ()                                                            //  output,   width = 1, custom_instruction_master.readra
	);

	hdmi_controller_onchip_memory2 onchip_memory2 (
		.clk        (clk_50_clk_clk),                                 //   input,   width = 1,   clk1.clk
		.address    (mm_interconnect_0_onchip_memory2_s1_address),    //   input,  width = 16,     s1.address
		.clken      (mm_interconnect_0_onchip_memory2_s1_clken),      //   input,   width = 1,       .clken
		.chipselect (mm_interconnect_0_onchip_memory2_s1_chipselect), //   input,   width = 1,       .chipselect
		.write      (mm_interconnect_0_onchip_memory2_s1_write),      //   input,   width = 1,       .write
		.readdata   (mm_interconnect_0_onchip_memory2_s1_readdata),   //  output,  width = 32,       .readdata
		.writedata  (mm_interconnect_0_onchip_memory2_s1_writedata),  //   input,  width = 32,       .writedata
		.byteenable (mm_interconnect_0_onchip_memory2_s1_byteenable), //   input,   width = 4,       .byteenable
		.reset      (rst_controller_reset_out_reset),                 //   input,   width = 1, reset1.reset
		.reset_req  (rst_controller_reset_out_reset_req)              //   input,   width = 1,       .reset_req
	);

	hdmi_controller_sii9136_int sii9136_int (
		.clk        (clk_50_clk_clk),                              //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),             //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_sii9136_int_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_sii9136_int_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_sii9136_int_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_sii9136_int_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_sii9136_int_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (sii9136_int_external_connection_export),      //   input,   width = 1, external_connection.export
		.irq        (irq_mapper_receiver4_irq)                     //  output,   width = 1,                 irq.irq
	);

	hdmi_controller_sii9136_rst_n sii9136_rst_n (
		.clk        (clk_50_clk_clk),                                //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),               //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_sii9136_rst_n_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_sii9136_rst_n_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_sii9136_rst_n_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_sii9136_rst_n_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_sii9136_rst_n_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (sii9136_rst_n_external_connection_export)       //  output,   width = 1, external_connection.export
	);

	hdmi_controller_sii9678_int sii9678_int (
		.clk        (clk_50_clk_clk),                              //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),             //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_sii9678_int_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_sii9678_int_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_sii9678_int_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_sii9678_int_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_sii9678_int_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (sii9678_int_external_connection_export),      //   input,   width = 1, external_connection.export
		.irq        (irq_mapper_receiver5_irq)                     //  output,   width = 1,                 irq.irq
	);

	hdmi_controller_sw sw (
		.clk        (clk_50_clk_clk),                     //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),    //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_sw_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_sw_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_sw_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_sw_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_sw_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (sw_external_connection_export),      //   input,   width = 4, external_connection.export
		.irq        (irq_mapper_receiver1_irq)            //  output,   width = 1,                 irq.irq
	);

	hdmi_controller_sysid_qsys_0 sysid_qsys_0 (
		.clock    (clk_50_clk_clk),                                        //   input,   width = 1,           clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                       //   input,   width = 1,         reset.reset_n
		.readdata (mm_interconnect_0_sysid_qsys_0_control_slave_readdata), //  output,  width = 32, control_slave.readdata
		.address  (mm_interconnect_0_sysid_qsys_0_control_slave_address)   //   input,   width = 1,              .address
	);

	hdmi_controller_timer timer (
		.clk        (clk_50_clk_clk),                        //   input,   width = 1,   clk.clk
		.reset_n    (~rst_controller_reset_out_reset),       //   input,   width = 1, reset.reset_n
		.address    (mm_interconnect_0_timer_s1_address),    //   input,   width = 3,    s1.address
		.writedata  (mm_interconnect_0_timer_s1_writedata),  //   input,  width = 16,      .writedata
		.readdata   (mm_interconnect_0_timer_s1_readdata),   //  output,  width = 16,      .readdata
		.chipselect (mm_interconnect_0_timer_s1_chipselect), //   input,   width = 1,      .chipselect
		.write_n    (~mm_interconnect_0_timer_s1_write),     //   input,   width = 1,      .write_n
		.irq        (irq_mapper_receiver0_irq)               //  output,   width = 1,   irq.irq
	);

	hdmi_controller_altera_mm_interconnect_1920_6yjrz7y mm_interconnect_0 (
		.nios2_gen2_0_data_master_address               (nios2_gen2_0_data_master_address),                           //   input,  width = 20,                 nios2_gen2_0_data_master.address
		.nios2_gen2_0_data_master_waitrequest           (nios2_gen2_0_data_master_waitrequest),                       //  output,   width = 1,                                         .waitrequest
		.nios2_gen2_0_data_master_byteenable            (nios2_gen2_0_data_master_byteenable),                        //   input,   width = 4,                                         .byteenable
		.nios2_gen2_0_data_master_read                  (nios2_gen2_0_data_master_read),                              //   input,   width = 1,                                         .read
		.nios2_gen2_0_data_master_readdata              (nios2_gen2_0_data_master_readdata),                          //  output,  width = 32,                                         .readdata
		.nios2_gen2_0_data_master_readdatavalid         (nios2_gen2_0_data_master_readdatavalid),                     //  output,   width = 1,                                         .readdatavalid
		.nios2_gen2_0_data_master_write                 (nios2_gen2_0_data_master_write),                             //   input,   width = 1,                                         .write
		.nios2_gen2_0_data_master_writedata             (nios2_gen2_0_data_master_writedata),                         //   input,  width = 32,                                         .writedata
		.nios2_gen2_0_data_master_debugaccess           (nios2_gen2_0_data_master_debugaccess),                       //   input,   width = 1,                                         .debugaccess
		.nios2_gen2_0_instruction_master_address        (nios2_gen2_0_instruction_master_address),                    //   input,  width = 20,          nios2_gen2_0_instruction_master.address
		.nios2_gen2_0_instruction_master_waitrequest    (nios2_gen2_0_instruction_master_waitrequest),                //  output,   width = 1,                                         .waitrequest
		.nios2_gen2_0_instruction_master_read           (nios2_gen2_0_instruction_master_read),                       //   input,   width = 1,                                         .read
		.nios2_gen2_0_instruction_master_readdata       (nios2_gen2_0_instruction_master_readdata),                   //  output,  width = 32,                                         .readdata
		.nios2_gen2_0_instruction_master_readdatavalid  (nios2_gen2_0_instruction_master_readdatavalid),              //  output,   width = 1,                                         .readdatavalid
		.jtag_uart_avalon_jtag_slave_address            (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),      //  output,   width = 1,              jtag_uart_avalon_jtag_slave.address
		.jtag_uart_avalon_jtag_slave_write              (mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),        //  output,   width = 1,                                         .write
		.jtag_uart_avalon_jtag_slave_read               (mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),         //  output,   width = 1,                                         .read
		.jtag_uart_avalon_jtag_slave_readdata           (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),     //   input,  width = 32,                                         .readdata
		.jtag_uart_avalon_jtag_slave_writedata          (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),    //  output,  width = 32,                                         .writedata
		.jtag_uart_avalon_jtag_slave_waitrequest        (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest),  //   input,   width = 1,                                         .waitrequest
		.jtag_uart_avalon_jtag_slave_chipselect         (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),   //  output,   width = 1,                                         .chipselect
		.sysid_qsys_0_control_slave_address             (mm_interconnect_0_sysid_qsys_0_control_slave_address),       //  output,   width = 1,               sysid_qsys_0_control_slave.address
		.sysid_qsys_0_control_slave_readdata            (mm_interconnect_0_sysid_qsys_0_control_slave_readdata),      //   input,  width = 32,                                         .readdata
		.nios2_gen2_0_debug_mem_slave_address           (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_address),     //  output,   width = 9,             nios2_gen2_0_debug_mem_slave.address
		.nios2_gen2_0_debug_mem_slave_write             (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_write),       //  output,   width = 1,                                         .write
		.nios2_gen2_0_debug_mem_slave_read              (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_read),        //  output,   width = 1,                                         .read
		.nios2_gen2_0_debug_mem_slave_readdata          (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_readdata),    //   input,  width = 32,                                         .readdata
		.nios2_gen2_0_debug_mem_slave_writedata         (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_writedata),   //  output,  width = 32,                                         .writedata
		.nios2_gen2_0_debug_mem_slave_byteenable        (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_byteenable),  //  output,   width = 4,                                         .byteenable
		.nios2_gen2_0_debug_mem_slave_waitrequest       (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_waitrequest), //   input,   width = 1,                                         .waitrequest
		.nios2_gen2_0_debug_mem_slave_debugaccess       (mm_interconnect_0_nios2_gen2_0_debug_mem_slave_debugaccess), //  output,   width = 1,                                         .debugaccess
		.timer_s1_address                               (mm_interconnect_0_timer_s1_address),                         //  output,   width = 3,                                 timer_s1.address
		.timer_s1_write                                 (mm_interconnect_0_timer_s1_write),                           //  output,   width = 1,                                         .write
		.timer_s1_readdata                              (mm_interconnect_0_timer_s1_readdata),                        //   input,  width = 16,                                         .readdata
		.timer_s1_writedata                             (mm_interconnect_0_timer_s1_writedata),                       //  output,  width = 16,                                         .writedata
		.timer_s1_chipselect                            (mm_interconnect_0_timer_s1_chipselect),                      //  output,   width = 1,                                         .chipselect
		.led_s1_address                                 (mm_interconnect_0_led_s1_address),                           //  output,   width = 2,                                   led_s1.address
		.led_s1_write                                   (mm_interconnect_0_led_s1_write),                             //  output,   width = 1,                                         .write
		.led_s1_readdata                                (mm_interconnect_0_led_s1_readdata),                          //   input,  width = 32,                                         .readdata
		.led_s1_writedata                               (mm_interconnect_0_led_s1_writedata),                         //  output,  width = 32,                                         .writedata
		.led_s1_chipselect                              (mm_interconnect_0_led_s1_chipselect),                        //  output,   width = 1,                                         .chipselect
		.sw_s1_address                                  (mm_interconnect_0_sw_s1_address),                            //  output,   width = 2,                                    sw_s1.address
		.sw_s1_write                                    (mm_interconnect_0_sw_s1_write),                              //  output,   width = 1,                                         .write
		.sw_s1_readdata                                 (mm_interconnect_0_sw_s1_readdata),                           //   input,  width = 32,                                         .readdata
		.sw_s1_writedata                                (mm_interconnect_0_sw_s1_writedata),                          //  output,  width = 32,                                         .writedata
		.sw_s1_chipselect                               (mm_interconnect_0_sw_s1_chipselect),                         //  output,   width = 1,                                         .chipselect
		.button_s1_address                              (mm_interconnect_0_button_s1_address),                        //  output,   width = 2,                                button_s1.address
		.button_s1_write                                (mm_interconnect_0_button_s1_write),                          //  output,   width = 1,                                         .write
		.button_s1_readdata                             (mm_interconnect_0_button_s1_readdata),                       //   input,  width = 32,                                         .readdata
		.button_s1_writedata                            (mm_interconnect_0_button_s1_writedata),                      //  output,  width = 32,                                         .writedata
		.button_s1_chipselect                           (mm_interconnect_0_button_s1_chipselect),                     //  output,   width = 1,                                         .chipselect
		.onchip_memory2_s1_address                      (mm_interconnect_0_onchip_memory2_s1_address),                //  output,  width = 16,                        onchip_memory2_s1.address
		.onchip_memory2_s1_write                        (mm_interconnect_0_onchip_memory2_s1_write),                  //  output,   width = 1,                                         .write
		.onchip_memory2_s1_readdata                     (mm_interconnect_0_onchip_memory2_s1_readdata),               //   input,  width = 32,                                         .readdata
		.onchip_memory2_s1_writedata                    (mm_interconnect_0_onchip_memory2_s1_writedata),              //  output,  width = 32,                                         .writedata
		.onchip_memory2_s1_byteenable                   (mm_interconnect_0_onchip_memory2_s1_byteenable),             //  output,   width = 4,                                         .byteenable
		.onchip_memory2_s1_chipselect                   (mm_interconnect_0_onchip_memory2_s1_chipselect),             //  output,   width = 1,                                         .chipselect
		.onchip_memory2_s1_clken                        (mm_interconnect_0_onchip_memory2_s1_clken),                  //  output,   width = 1,                                         .clken
		.hdmi_tx_fmc_i2c_sda_s1_address                 (mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_address),           //  output,   width = 2,                   hdmi_tx_fmc_i2c_sda_s1.address
		.hdmi_tx_fmc_i2c_sda_s1_write                   (mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_write),             //  output,   width = 1,                                         .write
		.hdmi_tx_fmc_i2c_sda_s1_readdata                (mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_readdata),          //   input,  width = 32,                                         .readdata
		.hdmi_tx_fmc_i2c_sda_s1_writedata               (mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_writedata),         //  output,  width = 32,                                         .writedata
		.hdmi_tx_fmc_i2c_sda_s1_chipselect              (mm_interconnect_0_hdmi_tx_fmc_i2c_sda_s1_chipselect),        //  output,   width = 1,                                         .chipselect
		.hdmi_tx_fmc_i2c_scl_s1_address                 (mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_address),           //  output,   width = 2,                   hdmi_tx_fmc_i2c_scl_s1.address
		.hdmi_tx_fmc_i2c_scl_s1_write                   (mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_write),             //  output,   width = 1,                                         .write
		.hdmi_tx_fmc_i2c_scl_s1_readdata                (mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_readdata),          //   input,  width = 32,                                         .readdata
		.hdmi_tx_fmc_i2c_scl_s1_writedata               (mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_writedata),         //  output,  width = 32,                                         .writedata
		.hdmi_tx_fmc_i2c_scl_s1_chipselect              (mm_interconnect_0_hdmi_tx_fmc_i2c_scl_s1_chipselect),        //  output,   width = 1,                                         .chipselect
		.sii9136_int_s1_address                         (mm_interconnect_0_sii9136_int_s1_address),                   //  output,   width = 2,                           sii9136_int_s1.address
		.sii9136_int_s1_write                           (mm_interconnect_0_sii9136_int_s1_write),                     //  output,   width = 1,                                         .write
		.sii9136_int_s1_readdata                        (mm_interconnect_0_sii9136_int_s1_readdata),                  //   input,  width = 32,                                         .readdata
		.sii9136_int_s1_writedata                       (mm_interconnect_0_sii9136_int_s1_writedata),                 //  output,  width = 32,                                         .writedata
		.sii9136_int_s1_chipselect                      (mm_interconnect_0_sii9136_int_s1_chipselect),                //  output,   width = 1,                                         .chipselect
		.sii9136_rst_n_s1_address                       (mm_interconnect_0_sii9136_rst_n_s1_address),                 //  output,   width = 2,                         sii9136_rst_n_s1.address
		.sii9136_rst_n_s1_write                         (mm_interconnect_0_sii9136_rst_n_s1_write),                   //  output,   width = 1,                                         .write
		.sii9136_rst_n_s1_readdata                      (mm_interconnect_0_sii9136_rst_n_s1_readdata),                //   input,  width = 32,                                         .readdata
		.sii9136_rst_n_s1_writedata                     (mm_interconnect_0_sii9136_rst_n_s1_writedata),               //  output,  width = 32,                                         .writedata
		.sii9136_rst_n_s1_chipselect                    (mm_interconnect_0_sii9136_rst_n_s1_chipselect),              //  output,   width = 1,                                         .chipselect
		.sii9678_int_s1_address                         (mm_interconnect_0_sii9678_int_s1_address),                   //  output,   width = 2,                           sii9678_int_s1.address
		.sii9678_int_s1_write                           (mm_interconnect_0_sii9678_int_s1_write),                     //  output,   width = 1,                                         .write
		.sii9678_int_s1_readdata                        (mm_interconnect_0_sii9678_int_s1_readdata),                  //   input,  width = 32,                                         .readdata
		.sii9678_int_s1_writedata                       (mm_interconnect_0_sii9678_int_s1_writedata),                 //  output,  width = 32,                                         .writedata
		.sii9678_int_s1_chipselect                      (mm_interconnect_0_sii9678_int_s1_chipselect),                //  output,   width = 1,                                         .chipselect
		.I2C_SCL_s1_address                             (mm_interconnect_0_i2c_scl_s1_address),                       //  output,   width = 2,                               I2C_SCL_s1.address
		.I2C_SCL_s1_write                               (mm_interconnect_0_i2c_scl_s1_write),                         //  output,   width = 1,                                         .write
		.I2C_SCL_s1_readdata                            (mm_interconnect_0_i2c_scl_s1_readdata),                      //   input,  width = 32,                                         .readdata
		.I2C_SCL_s1_writedata                           (mm_interconnect_0_i2c_scl_s1_writedata),                     //  output,  width = 32,                                         .writedata
		.I2C_SCL_s1_chipselect                          (mm_interconnect_0_i2c_scl_s1_chipselect),                    //  output,   width = 1,                                         .chipselect
		.I2C_SDA_s1_address                             (mm_interconnect_0_i2c_sda_s1_address),                       //  output,   width = 2,                               I2C_SDA_s1.address
		.I2C_SDA_s1_write                               (mm_interconnect_0_i2c_sda_s1_write),                         //  output,   width = 1,                                         .write
		.I2C_SDA_s1_readdata                            (mm_interconnect_0_i2c_sda_s1_readdata),                      //   input,  width = 32,                                         .readdata
		.I2C_SDA_s1_writedata                           (mm_interconnect_0_i2c_sda_s1_writedata),                     //  output,  width = 32,                                         .writedata
		.I2C_SDA_s1_chipselect                          (mm_interconnect_0_i2c_sda_s1_chipselect),                    //  output,   width = 1,                                         .chipselect
		.adv7619_rst_s1_address                         (mm_interconnect_0_adv7619_rst_s1_address),                   //  output,   width = 2,                           adv7619_rst_s1.address
		.adv7619_rst_s1_write                           (mm_interconnect_0_adv7619_rst_s1_write),                     //  output,   width = 1,                                         .write
		.adv7619_rst_s1_readdata                        (mm_interconnect_0_adv7619_rst_s1_readdata),                  //   input,  width = 32,                                         .readdata
		.adv7619_rst_s1_writedata                       (mm_interconnect_0_adv7619_rst_s1_writedata),                 //  output,  width = 32,                                         .writedata
		.adv7619_rst_s1_chipselect                      (mm_interconnect_0_adv7619_rst_s1_chipselect),                //  output,   width = 1,                                         .chipselect
		.RX0_EDID_I2C_SCL_s1_address                    (mm_interconnect_0_rx0_edid_i2c_scl_s1_address),              //  output,   width = 2,                      RX0_EDID_I2C_SCL_s1.address
		.RX0_EDID_I2C_SCL_s1_write                      (mm_interconnect_0_rx0_edid_i2c_scl_s1_write),                //  output,   width = 1,                                         .write
		.RX0_EDID_I2C_SCL_s1_readdata                   (mm_interconnect_0_rx0_edid_i2c_scl_s1_readdata),             //   input,  width = 32,                                         .readdata
		.RX0_EDID_I2C_SCL_s1_writedata                  (mm_interconnect_0_rx0_edid_i2c_scl_s1_writedata),            //  output,  width = 32,                                         .writedata
		.RX0_EDID_I2C_SCL_s1_chipselect                 (mm_interconnect_0_rx0_edid_i2c_scl_s1_chipselect),           //  output,   width = 1,                                         .chipselect
		.RX0_EDID_I2C_SDA_s1_address                    (mm_interconnect_0_rx0_edid_i2c_sda_s1_address),              //  output,   width = 2,                      RX0_EDID_I2C_SDA_s1.address
		.RX0_EDID_I2C_SDA_s1_write                      (mm_interconnect_0_rx0_edid_i2c_sda_s1_write),                //  output,   width = 1,                                         .write
		.RX0_EDID_I2C_SDA_s1_readdata                   (mm_interconnect_0_rx0_edid_i2c_sda_s1_readdata),             //   input,  width = 32,                                         .readdata
		.RX0_EDID_I2C_SDA_s1_writedata                  (mm_interconnect_0_rx0_edid_i2c_sda_s1_writedata),            //  output,  width = 32,                                         .writedata
		.RX0_EDID_I2C_SDA_s1_chipselect                 (mm_interconnect_0_rx0_edid_i2c_sda_s1_chipselect),           //  output,   width = 1,                                         .chipselect
		.adv7619_int_s1_address                         (mm_interconnect_0_adv7619_int_s1_address),                   //  output,   width = 2,                           adv7619_int_s1.address
		.adv7619_int_s1_write                           (mm_interconnect_0_adv7619_int_s1_write),                     //  output,   width = 1,                                         .write
		.adv7619_int_s1_readdata                        (mm_interconnect_0_adv7619_int_s1_readdata),                  //   input,  width = 32,                                         .readdata
		.adv7619_int_s1_writedata                       (mm_interconnect_0_adv7619_int_s1_writedata),                 //  output,  width = 32,                                         .writedata
		.adv7619_int_s1_chipselect                      (mm_interconnect_0_adv7619_int_s1_chipselect),                //  output,   width = 1,                                         .chipselect
		.RX1_EDID_I2C_SCL_s1_address                    (mm_interconnect_0_rx1_edid_i2c_scl_s1_address),              //  output,   width = 2,                      RX1_EDID_I2C_SCL_s1.address
		.RX1_EDID_I2C_SCL_s1_write                      (mm_interconnect_0_rx1_edid_i2c_scl_s1_write),                //  output,   width = 1,                                         .write
		.RX1_EDID_I2C_SCL_s1_readdata                   (mm_interconnect_0_rx1_edid_i2c_scl_s1_readdata),             //   input,  width = 32,                                         .readdata
		.RX1_EDID_I2C_SCL_s1_writedata                  (mm_interconnect_0_rx1_edid_i2c_scl_s1_writedata),            //  output,  width = 32,                                         .writedata
		.RX1_EDID_I2C_SCL_s1_chipselect                 (mm_interconnect_0_rx1_edid_i2c_scl_s1_chipselect),           //  output,   width = 1,                                         .chipselect
		.RX1_EDID_I2C_SDA_s1_address                    (mm_interconnect_0_rx1_edid_i2c_sda_s1_address),              //  output,   width = 2,                      RX1_EDID_I2C_SDA_s1.address
		.RX1_EDID_I2C_SDA_s1_write                      (mm_interconnect_0_rx1_edid_i2c_sda_s1_write),                //  output,   width = 1,                                         .write
		.RX1_EDID_I2C_SDA_s1_readdata                   (mm_interconnect_0_rx1_edid_i2c_sda_s1_readdata),             //   input,  width = 32,                                         .readdata
		.RX1_EDID_I2C_SDA_s1_writedata                  (mm_interconnect_0_rx1_edid_i2c_sda_s1_writedata),            //  output,  width = 32,                                         .writedata
		.RX1_EDID_I2C_SDA_s1_chipselect                 (mm_interconnect_0_rx1_edid_i2c_sda_s1_chipselect),           //  output,   width = 1,                                         .chipselect
		.nios2_gen2_0_reset_reset_bridge_in_reset_reset (rst_controller_001_reset_out_reset),                         //   input,   width = 1, nios2_gen2_0_reset_reset_bridge_in_reset.reset
		.jtag_uart_reset_reset_bridge_in_reset_reset    (rst_controller_reset_out_reset),                             //   input,   width = 1,    jtag_uart_reset_reset_bridge_in_reset.reset
		.clk_50_clk_clk                                 (clk_50_clk_clk)                                              //   input,   width = 1,                               clk_50_clk.clk
	);

	hdmi_controller_altera_irq_mapper_2001_nrrzavy irq_mapper (
		.clk           (clk_50_clk_clk),                     //   input,   width = 1,       clk.clk
		.reset         (rst_controller_001_reset_out_reset), //   input,   width = 1, clk_reset.reset
		.receiver0_irq (irq_mapper_receiver0_irq),           //   input,   width = 1, receiver0.irq
		.receiver1_irq (irq_mapper_receiver1_irq),           //   input,   width = 1, receiver1.irq
		.receiver2_irq (irq_mapper_receiver2_irq),           //   input,   width = 1, receiver2.irq
		.receiver3_irq (irq_mapper_receiver3_irq),           //   input,   width = 1, receiver3.irq
		.receiver4_irq (irq_mapper_receiver4_irq),           //   input,   width = 1, receiver4.irq
		.receiver5_irq (irq_mapper_receiver5_irq),           //   input,   width = 1, receiver5.irq
		.receiver6_irq (irq_mapper_receiver6_irq),           //   input,   width = 1, receiver6.irq
		.sender_irq    (nios2_gen2_0_irq_irq)                //  output,  width = 32,    sender.irq
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (1),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller (
		.reset_in0      (~clk_50_clk_reset_reset),            //   input,  width = 1, reset_in0.reset
		.clk            (clk_50_clk_clk),                     //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_reset_out_reset),     //  output,  width = 1, reset_out.reset
		.reset_req      (rst_controller_reset_out_reset_req), //  output,  width = 1,          .reset_req
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (2),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (1),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_001 (
		.reset_in0      (~clk_50_clk_reset_reset),                //   input,  width = 1, reset_in0.reset
		.reset_in1      (nios2_gen2_0_debug_reset_request_reset), //   input,  width = 1, reset_in1.reset
		.clk            (clk_50_clk_clk),                         //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_001_reset_out_reset),     //  output,  width = 1, reset_out.reset
		.reset_req      (rst_controller_001_reset_out_reset_req), //  output,  width = 1,          .reset_req
		.reset_req_in0  (1'b0),                                   // (terminated),                       
		.reset_req_in1  (1'b0),                                   // (terminated),                       
		.reset_in2      (1'b0),                                   // (terminated),                       
		.reset_req_in2  (1'b0),                                   // (terminated),                       
		.reset_in3      (1'b0),                                   // (terminated),                       
		.reset_req_in3  (1'b0),                                   // (terminated),                       
		.reset_in4      (1'b0),                                   // (terminated),                       
		.reset_req_in4  (1'b0),                                   // (terminated),                       
		.reset_in5      (1'b0),                                   // (terminated),                       
		.reset_req_in5  (1'b0),                                   // (terminated),                       
		.reset_in6      (1'b0),                                   // (terminated),                       
		.reset_req_in6  (1'b0),                                   // (terminated),                       
		.reset_in7      (1'b0),                                   // (terminated),                       
		.reset_req_in7  (1'b0),                                   // (terminated),                       
		.reset_in8      (1'b0),                                   // (terminated),                       
		.reset_req_in8  (1'b0),                                   // (terminated),                       
		.reset_in9      (1'b0),                                   // (terminated),                       
		.reset_req_in9  (1'b0),                                   // (terminated),                       
		.reset_in10     (1'b0),                                   // (terminated),                       
		.reset_req_in10 (1'b0),                                   // (terminated),                       
		.reset_in11     (1'b0),                                   // (terminated),                       
		.reset_req_in11 (1'b0),                                   // (terminated),                       
		.reset_in12     (1'b0),                                   // (terminated),                       
		.reset_req_in12 (1'b0),                                   // (terminated),                       
		.reset_in13     (1'b0),                                   // (terminated),                       
		.reset_req_in13 (1'b0),                                   // (terminated),                       
		.reset_in14     (1'b0),                                   // (terminated),                       
		.reset_req_in14 (1'b0),                                   // (terminated),                       
		.reset_in15     (1'b0),                                   // (terminated),                       
		.reset_req_in15 (1'b0)                                    // (terminated),                       
	);

endmodule
