// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// =================================================================================
// Creates a pulsed signal from an input signal
// =================================================================================

module pulse_gen (
    input  logic clk,            // the DPS clock
    input  logic rst,            // active high reset
    input  logic signal,         // the user's pulsed_signal signal
    output logic pulsed_signal  // the pulsed_signal signal for the IOPLL atom
 );
 
    //-------------------------------------------------------------------------
    // States
    localparam IDLE        = 0,  // Idle state: signal = 0, pulsed_signal = 0
               PULSE       = 1,  // Activate state: pulsed_signal = 1
               WAIT        = 2;  // Wait for signal to go low

    //-------------------------------------------------------------------------
    // FSM current and next states
    logic [1:0] state, next;     
    
    // State update
    always @(posedge clk) begin
        if (rst)    state <= IDLE;
        else        state <= next; 
    end  

    //-------------------------------------------------------------------------    
    // Next-state and output logic
    always @(*) begin
        next          = IDLE;  // Default next state 
        pulsed_signal = 1'b0;  // Default output
        
        case (state)
            IDLE :  begin
                        if (signal)  next = PULSE;
                        else         next = IDLE;
                    end     
                         
            PULSE : begin
                        pulsed_signal = 1'b1;
                        next          = WAIT;
                    end
                         
            WAIT :  begin         
                        if (~signal) next = IDLE;
                        else         next = WAIT;                  
                    end  
        endcase
    end
     
 endmodule




`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "2tGVyxZMIw9h5OvjMUznwUYqTrOP39w6fMEy0tmx58wstnXD2SK+nkX9QHF0/85B2nC8OMHvnBA8JbOHsbPAhYmC1Nobd756iZcXMv6ylMYRuB0oi/dG5L7MrkxBO84IuStk5TOL/CgZbHPQrDI1ymkEO49bahXp3C3+dbWZ+6fNmo1B6zlrDwB1aY4Gzxsbu8sn4Pur4CraHkuZz1feQcJL030Bl5lAOmKhLhxSPf1WaZdDepIJ2UwDitWWPiqyetg6BG6EUXRF1HuYc5vAtM/ss2GKL2pW9rQZ1pfrmzd0qV5kUgD9cf9o3tQ+DqGyfVa+JecRbtR6M+jUs/yJQpvGJr8QBCs8NkXHGAfbcxsth94CcL5/Xx7NtJPOcolY9HHZnaSVJeRsS6XduoGRimlOmZqIbysHG+hBxtRuTv0w/itumv2bXGGj3AHuBtdKnHPQmoAPNUyYD1nXspZDsCak8f1Cu6XEPJ36Atc5i6HVp1tOybWkXi9AaDhFFWLcC2iAfTHeK0uvBOPwBytWhbDy2GSQyE/r3OZzxLYoUi4SLx8Y1gv7QeMrmutfCQBDz5mz34tfUdFCiyS3U1lOzTdMHVIBJW6Lfc5xPBvtHP21a3FrJkxXbyVKF13Fg/p11tmTTlGPRFntXxFN8Ir3j5CzY2YkUuPV9+DpmDYhhRRgG0mVwr7AkHWQv2uDz0LDYJzHQhNTpDwUor5S4VGJnUuRHn142sjQarvqmLgz3XwuY69t/EHkCGR6RfRRrG1bpbEOLt2WR01DCJia1Wj3T9M/9uAFEEGsD32YJ7GIQqEV/R7n9IhctCtkk2RlMSmTHBz2acgYSfVixQ6krMos1RbVvpi37V5evS4BDMkDyWctzYzwQ83xpgmbbCNvC5jt/yPHwweRornpG3Kp9FD3Pp1HCM3/enwERbb3G/Y/mV3JqH06MQ/dg3+1fPhlepiMB/Ks7sy4xtEbFdECXcoiKzmcJ62uLHTbcFzt0GvAq+dilfi4MTqLiYm2QP3cK7TV"
`endif