// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module shift #(parameter WIDTH = 1, parameter DEPTH = 0) (
    input logic clk,
    input logic [WIDTH-1:0] din,
    output logic [WIDTH-1:0] dout
);

logic [WIDTH-1:0] shift_register [DEPTH-1:0];

integer i;
generate
if (DEPTH == 0)
begin
    always_comb
    begin
        dout = din;
    end
end
else
begin
    always_ff @(posedge clk)
    begin
        shift_register[0] <= din;
        for (i = 1; i < DEPTH; i = i + 1)
        begin
            shift_register[i] <= shift_register[i-1]; 
        end
    end

    always_comb
    begin
        dout = shift_register[DEPTH-1];
    end
end
endgenerate

endmodule 
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "2tGVyxZMIw9h5OvjMUznwUYqTrOP39w6fMEy0tmx58wstnXD2SK+nkX9QHF0/85B2nC8OMHvnBA8JbOHsbPAhYmC1Nobd756iZcXMv6ylMYRuB0oi/dG5L7MrkxBO84IuStk5TOL/CgZbHPQrDI1ymkEO49bahXp3C3+dbWZ+6fNmo1B6zlrDwB1aY4Gzxsbu8sn4Pur4CraHkuZz1feQcJL030Bl5lAOmKhLhxSPf3EzrheM3S15NAM0r92tmuXbh/albIA4boLb0BUQkKhViBGIf0NXoMVLdzovgGRkK8AIaTmvZ/rculiYChyMixjKFyg+nc3DMzB3OBfT4Usm+tNvBsN09eJE0uKG0DeMy4pMVh0UJYH+N9djDnBDXi1iPyyA1Qttr1zRhRcixwYBi8m3oKblMxYtXfGwq+Nb3zAY4OBAv6Xt+9zIwn+Yz0MNmmQ85ONafUfBxTmr/Dmt7E5hBrOlQj0rhsQbz8p0PIh+YCwK9hRfWIwuNiZwiUL66p1DMVtvXobHcqYa9g2jPL8nxhGyEhXRj2LFKxUKd9jQ9HNkKYkdqLBaj3Kh2PIqRG5WmjnMBuwZlz0wpnltukw/1HgReUwlSsgtwHu7rQuzaih/2iKUhYKPAi6RiW9ItA0SSkpVz/Y9Mgcp9OcGoig8+iopDUvxteNyhRwXNO2LMaBXwDSxfHS9nMvLMZmBjQyXmZv8n1pvnj+BZauQKhFJVJDrTgux1AuFBjflPwEqTy6c9Ry79toBv2+xnl4mcE0FpcDXq1NXFN1hpgjbATPH+zqVnJy/+qTkJegos2wDBbSazhTjKqnlHY6hPNNSA+KMG6YzLDYSDIk1bF1tDAQt82qaIWJ+TmOWdZhU2r279c1mf1Yt2jg7gZwTEHrNeQ+mbNNgyXPIWE29uxdEdSi6Zk/lu5Gvfs08xfqIQce7NjeeZNeTGouy5G4P5Jaaf2a7lYhWkgmBMs0J3CtDXJb/kogGZBjZLS8URzjPrJ0iVyYOlW7tJZpUEZM5kvE"
`endif