// ============================================================================
// Copyright (c) 2022 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Fri Jul 15 14:16:19 2022
// ============================================================================

//`define ENABLE_DDR4A
//`define ENABLE_DDR4B
//`define ENABLE_QSFP28
//`define ENABLE_FGT_REFCLK
`define ENABLE_FMCP
//`define ENABLE_HPS
//`define ENABLE_HDMI
//`define ENABLE_PCIE

module PCIe_Fundamental(

      ///////// CLOCK /////////
      input              CLK_100_B3A_p,
      input              CLK_100_p,
      input              CLK_148M5_p,
      input              CLK_50_B2D_p,
      input              CLK_50_B2E_p,
      input              CLK_50_B3A_p,
      input              CLK_50_B3C_p,

      ///////// Buttons /////////
      input              CPU_RESET_n,
      input    [ 1: 0]   BUTTON, //BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   SW,

      ///////// LED /////////
      output   [ 1: 0]   LED, //LED is Low-Active

`ifdef ENABLE_DDR4A
      ///////// DDR4A /////////
      input              DDR4A_REFCLK_p,
      output   [16: 0]   DDR4A_A,
      output   [ 1: 0]   DDR4A_BA,
      output   [ 1: 0]   DDR4A_BG,
      output             DDR4A_CK,
      output             DDR4A_CK_n,
      output             DDR4A_CKE,
      inout    [ 8: 0]   DDR4A_DQS,
      inout    [ 8: 0]   DDR4A_DQS_n,
      inout    [71: 0]   DDR4A_DQ,
      inout    [ 8: 0]   DDR4A_DBI_n,
      output             DDR4A_CS_n,
      output             DDR4A_RESET_n,
      output             DDR4A_ODT,
      output             DDR4A_PAR,
      input              DDR4A_ALERT_n,
      output             DDR4A_ACT_n,
      input              DDR4A_EVENT_n,
      inout              DDR4A_SCL,
      inout              DDR4A_SDA,
      input              DDR4A_RZQ,
`endif /*ENABLE_DDR4A*/

`ifdef ENABLE_DDR4B
      ///////// DDR4B /////////
      input              DDR4B_REFCLK_p,
      output   [16: 0]   DDR4B_A,
      output   [ 1: 0]   DDR4B_BA,
      output   [ 0: 0]   DDR4B_BG,
      output             DDR4B_CK,
      output             DDR4B_CK_n,
      output             DDR4B_CKE,
      inout    [ 8: 0]   DDR4B_DQS,
      inout    [ 8: 0]   DDR4B_DQS_n,
      inout    [71: 0]   DDR4B_DQ,
      inout    [ 8: 0]   DDR4B_DBI_n,
      output             DDR4B_CS_n,
      output             DDR4B_RESET_n,
      output             DDR4B_ODT,
      output             DDR4B_PAR,
      input              DDR4B_ALERT_n,
      output             DDR4B_ACT_n,
      input              DDR4B_RZQ,
`endif /*ENABLE_DDR4B*/

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      output   [ 3: 0]   HDMI_TX_D_p,
      output   [ 3: 0]   HDMI_TX_D_n,
      input              HDMI_REFCLK_148M5_p,
      output             DVI_TX_5V,
      input              DVI_TX_CEC_IN_n,
      output             DVI_TX_CEC_OUT_n,
      input              DVI_TX_HPD_n,
      inout              DVI_TX_SCL,
      inout              DVI_TX_SDA,
      inout              HDMI_TX_SCL,
      inout              HDMI_TX_SDA,
`endif /*ENABLE_HDMI*/

      ///////// SI5340A0 /////////
      inout              SI5340A0_I2C_SCL,
      inout              SI5340A0_I2C_SDA,
      output             SI5340A0_OE_n,
      output             SI5340A0_RST_n,

      ///////// SI5340A1 /////////
      inout              SI5340A1_I2C_SCL,
      inout              SI5340A1_I2C_SDA,
      output             SI5340A1_OE_n,
      output             SI5340A1_RST_n,

      ///////// GPIO /////////
      input    [ 1: 0]   GPIO_CLK,
      inout    [ 3: 0]   GPIO_P,

`ifdef ENABLE_FGT_REFCLK
      input              FGT_REFCLK_100_p,
`endif /*ENABLE_FGT_REFCLK*/

`ifdef ENABLE_FMCP
      ///////// FMCP /////////
      //inout              FMCP_CLK2_BIDIR_p,
      //inout              FMCP_CLK2_BIDIR_n,
      //inout              FMCP_CLK3_BIDIR_p,
      //inout              FMCP_CLK3_BIDIR_n,
      output   [15: 0]   FMCP_DP_C2M_p,
      output   [15: 0]   FMCP_DP_C2M_n,
      input    [15: 0]   FMCP_DP_M2C_p,
      input    [15: 0]   FMCP_DP_M2C_n,
      //inout    [23: 0]   FMCP_HA_p,
      //inout    [23: 0]   FMCP_HA_n,
      //inout    [21: 0]   FMCP_HB_p,
      //inout    [21: 0]   FMCP_HB_n,
      //inout    [33: 0]   FMCP_LA_p,
      //inout    [33: 0]   FMCP_LA_n,
      //input    [ 1: 0]   FMCP_CLK_M2C_p,
      //input    [ 1: 0]   FMCP_GBTCLK_M2C_p,
      input    [ 0: 0]   FMCP_GBTCLK_M2C_p,
      //output             FMCP_REFCLK_C2M_p,
      //input              FMCP_REFCLK_M2C_p,
      //input    [ 3: 0]   FMCP_REFCLK_p,
      input    [ 2: 2]   FMCP_REFCLK_p,
      //inout    [ 1: 0]   FMCP_GA,
      input              FMCP_RES0,
      //inout              FMCP_RES1,
      //inout              FMCP_SCL,
      //inout              FMCP_SDA,
      //output             FMCP_SYNC_C2M_p,
      //input              FMCP_SYNC_M2C_p,
`endif /*ENABLE_FMCP*/

`ifdef ENABLE_PCIE
      ///////// PCIE /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      output   [ 7: 0]   PCIE_TX_p,
      output   [ 7: 0]   PCIE_TX_n,
      input    [ 7: 0]   PCIE_RX_p,
      input    [ 7: 0]   PCIE_RX_n,
      input              PCIE_REFCLK_p,
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFP28
      ///////// QSFP28 /////////
      output   [ 3: 0]   QSFP28_TX_p,
      output   [ 3: 0]   QSFP28_TX_n,
      input    [ 3: 0]   QSFP28_RX_p,
      input    [ 3: 0]   QSFP28_RX_n,
      input    [ 1: 0]   QSFP28_REFCLK_p,
      input              QSFP28_INTERRUPT_n,
      output             QSFP28_LP_MODE,
      input              QSFP28_MOD_PRS_n,
      output             QSFP28_MOD_SEL_n,
      output             QSFP28_RST_n,
      inout              QSFP28_SCL,
      inout              QSFP28_SDA,
`endif /*ENABLE_QSFP28*/

      ///////// EXP /////////
      input              EXP_EN,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      input              HPS_JTAG_TCK,
      input              HPS_JTAG_TDI,
      output             HPS_JTAG_TDO,
      input              HPS_JTAG_TMS,
      inout              HPS_KEY,
      inout              HPS_LED,
      input              HPS_OSC_CLK,
      output             HPS_SD_CLK,
      inout              HPS_SD_CMD,
      inout    [ 3: 0]   HPS_SD_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n

);


//=======================================================
//  REG/WIRE declarations
//=======================================================

assign SI5340A0_OE_n = 1'bZ;
assign SI5340A0_RST_n = 1'bZ;
assign SI5340A1_OE_n = 1'bZ;
assign SI5340A1_RST_n = 1'bZ;

wire [1: 0] pio_led;
assign LED = ~pio_led;

//=======================================================
//  Structural coding
//=======================================================

pcie_ed u0 (
    .hip_serial_rx_n_in0    (FMCP_DP_M2C_n[0]),     //   input,  width = 1, hip_serial.rx_n_in0
    .hip_serial_rx_n_in1    (FMCP_DP_M2C_n[1]),     //   input,  width = 1,           .rx_n_in1
    .hip_serial_rx_n_in2    (FMCP_DP_M2C_n[2]),     //   input,  width = 1,           .rx_n_in2
    .hip_serial_rx_n_in3    (FMCP_DP_M2C_n[3]),     //   input,  width = 1,           .rx_n_in3
    .hip_serial_rx_n_in4    (FMCP_DP_M2C_n[4]),     //   input,  width = 1,           .rx_n_in4
    .hip_serial_rx_n_in5    (FMCP_DP_M2C_n[5]),     //   input,  width = 1,           .rx_n_in5
    .hip_serial_rx_n_in6    (FMCP_DP_M2C_n[6]),     //   input,  width = 1,           .rx_n_in6
    .hip_serial_rx_n_in7    (FMCP_DP_M2C_n[7]),     //   input,  width = 1,           .rx_n_in7
    .hip_serial_rx_n_in8    (FMCP_DP_M2C_n[8]),     //   input,  width = 1,           .rx_n_in8
    .hip_serial_rx_n_in9    (FMCP_DP_M2C_n[9]),     //   input,  width = 1,           .rx_n_in9
    .hip_serial_rx_n_in10   (FMCP_DP_M2C_n[10]),    //   input,  width = 1,           .rx_n_in10
    .hip_serial_rx_n_in11   (FMCP_DP_M2C_n[11]),    //   input,  width = 1,           .rx_n_in11
    .hip_serial_rx_n_in12   (FMCP_DP_M2C_n[12]),    //   input,  width = 1,           .rx_n_in12
    .hip_serial_rx_n_in13   (FMCP_DP_M2C_n[13]),    //   input,  width = 1,           .rx_n_in13
    .hip_serial_rx_n_in14   (FMCP_DP_M2C_n[14]),    //   input,  width = 1,           .rx_n_in14
    .hip_serial_rx_n_in15   (FMCP_DP_M2C_n[15]),    //   input,  width = 1,           .rx_n_in15
    .hip_serial_rx_p_in0    (FMCP_DP_M2C_p[0]),     //   input,  width = 1,           .rx_p_in0
    .hip_serial_rx_p_in1    (FMCP_DP_M2C_p[1]),     //   input,  width = 1,           .rx_p_in1
    .hip_serial_rx_p_in2    (FMCP_DP_M2C_p[2]),     //   input,  width = 1,           .rx_p_in2
    .hip_serial_rx_p_in3    (FMCP_DP_M2C_p[3]),     //   input,  width = 1,           .rx_p_in3
    .hip_serial_rx_p_in4    (FMCP_DP_M2C_p[4]),     //   input,  width = 1,           .rx_p_in4
    .hip_serial_rx_p_in5    (FMCP_DP_M2C_p[5]),     //   input,  width = 1,           .rx_p_in5
    .hip_serial_rx_p_in6    (FMCP_DP_M2C_p[6]),     //   input,  width = 1,           .rx_p_in6
    .hip_serial_rx_p_in7    (FMCP_DP_M2C_p[7]),     //   input,  width = 1,           .rx_p_in7
    .hip_serial_rx_p_in8    (FMCP_DP_M2C_p[8]),     //   input,  width = 1,           .rx_p_in8
    .hip_serial_rx_p_in9    (FMCP_DP_M2C_p[9]),     //   input,  width = 1,           .rx_p_in9
    .hip_serial_rx_p_in10   (FMCP_DP_M2C_p[10]),    //   input,  width = 1,           .rx_p_in10
    .hip_serial_rx_p_in11   (FMCP_DP_M2C_p[11]),    //   input,  width = 1,           .rx_p_in11
    .hip_serial_rx_p_in12   (FMCP_DP_M2C_p[12]),    //   input,  width = 1,           .rx_p_in12
    .hip_serial_rx_p_in13   (FMCP_DP_M2C_p[13]),    //   input,  width = 1,           .rx_p_in13
    .hip_serial_rx_p_in14   (FMCP_DP_M2C_p[14]),    //   input,  width = 1,           .rx_p_in14
    .hip_serial_rx_p_in15   (FMCP_DP_M2C_p[15]),    //   input,  width = 1,           .rx_p_in15
    .hip_serial_tx_n_out0   (FMCP_DP_C2M_n[0]),     //  output,  width = 1,           .tx_n_out0
    .hip_serial_tx_n_out1   (FMCP_DP_C2M_n[1]),     //  output,  width = 1,           .tx_n_out1
    .hip_serial_tx_n_out2   (FMCP_DP_C2M_n[2]),     //  output,  width = 1,           .tx_n_out2
    .hip_serial_tx_n_out3   (FMCP_DP_C2M_n[3]),     //  output,  width = 1,           .tx_n_out3
    .hip_serial_tx_n_out4   (FMCP_DP_C2M_n[4]),     //  output,  width = 1,           .tx_n_out4
    .hip_serial_tx_n_out5   (FMCP_DP_C2M_n[5]),     //  output,  width = 1,           .tx_n_out5
    .hip_serial_tx_n_out6   (FMCP_DP_C2M_n[6]),     //  output,  width = 1,           .tx_n_out6
    .hip_serial_tx_n_out7   (FMCP_DP_C2M_n[7]),     //  output,  width = 1,           .tx_n_out7
    .hip_serial_tx_n_out8   (FMCP_DP_C2M_n[8]),     //  output,  width = 1,           .tx_n_out8
    .hip_serial_tx_n_out9   (FMCP_DP_C2M_n[9]),     //  output,  width = 1,           .tx_n_out9
    .hip_serial_tx_n_out10  (FMCP_DP_C2M_n[10]),    //  output,  width = 1,           .tx_n_out10
    .hip_serial_tx_n_out11  (FMCP_DP_C2M_n[11]),    //  output,  width = 1,           .tx_n_out11
    .hip_serial_tx_n_out12  (FMCP_DP_C2M_n[12]),    //  output,  width = 1,           .tx_n_out12
    .hip_serial_tx_n_out13  (FMCP_DP_C2M_n[13]),    //  output,  width = 1,           .tx_n_out13
    .hip_serial_tx_n_out14  (FMCP_DP_C2M_n[14]),    //  output,  width = 1,           .tx_n_out14
    .hip_serial_tx_n_out15  (FMCP_DP_C2M_n[15]),    //  output,  width = 1,           .tx_n_out15
    .hip_serial_tx_p_out0   (FMCP_DP_C2M_p[0]),     //  output,  width = 1,           .tx_p_out0
    .hip_serial_tx_p_out1   (FMCP_DP_C2M_p[1]),     //  output,  width = 1,           .tx_p_out1
    .hip_serial_tx_p_out2   (FMCP_DP_C2M_p[2]),     //  output,  width = 1,           .tx_p_out2
    .hip_serial_tx_p_out3   (FMCP_DP_C2M_p[3]),     //  output,  width = 1,           .tx_p_out3
    .hip_serial_tx_p_out4   (FMCP_DP_C2M_p[4]),     //  output,  width = 1,           .tx_p_out4
    .hip_serial_tx_p_out5   (FMCP_DP_C2M_p[5]),     //  output,  width = 1,           .tx_p_out5
    .hip_serial_tx_p_out6   (FMCP_DP_C2M_p[6]),     //  output,  width = 1,           .tx_p_out6
    .hip_serial_tx_p_out7   (FMCP_DP_C2M_p[7]),     //  output,  width = 1,           .tx_p_out7
    .hip_serial_tx_p_out8   (FMCP_DP_C2M_p[8]),     //  output,  width = 1,           .tx_p_out8
    .hip_serial_tx_p_out9   (FMCP_DP_C2M_p[9]),     //  output,  width = 1,           .tx_p_out9
    .hip_serial_tx_p_out10  (FMCP_DP_C2M_p[10]),    //  output,  width = 1,           .tx_p_out10
    .hip_serial_tx_p_out11  (FMCP_DP_C2M_p[11]),    //  output,  width = 1,           .tx_p_out11
    .hip_serial_tx_p_out12  (FMCP_DP_C2M_p[12]),    //  output,  width = 1,           .tx_p_out12
    .hip_serial_tx_p_out13  (FMCP_DP_C2M_p[13]),    //  output,  width = 1,           .tx_p_out13
    .hip_serial_tx_p_out14  (FMCP_DP_C2M_p[14]),    //  output,  width = 1,           .tx_p_out14
    .hip_serial_tx_p_out15  (FMCP_DP_C2M_p[15]),    //  output,  width = 1,           .tx_p_out15
    .hip_in_refclk_fgt_0    (FMCP_GBTCLK_M2C_p[0]), //   input,  width = 1,        hip.in_refclk_fgt_0
    .hip_in_refclk_fgt_1    (FMCP_REFCLK_p[2]),     //   input,  width = 1,           .in_refclk_fgt_1
    .pin_perst_reset_n      (FMCP_RES0),            //   input,  width = 1,  pin_perst.reset_n
    .pio_button_export      (~BUTTON),              //   input,  width = 2, pio_button.export
    .pio_led_export         (pio_led)               //  output,  width = 2,    pio_led.export
);

endmodule
