// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps

module  onchip_memory_0_intel_onchip_memory_147_feley3y  (
    address,
    address2,
    byteenable,
    byteenable2,
    clk,
    read,
    read2,
    readdata,
    readdata2,
    reset,
    reset_req,
    write,
    write2,
    writedata,
    writedata2
    );

    parameter INIT_FILE = "UNUSED";

    input  [12:0]	address;
    input  [12:0]	address2;
    input  [63:0]	byteenable;
    input  [63:0]	byteenable2;
    input        	clk;
    input        	read;
    input        	read2;
    output [511:0]	readdata;
    output [511:0]	readdata2;
    input        	reset;
    input        	reset_req;
    input        	write;
    input        	write2;
    input  [511:0]	writedata;
    input  [511:0]	writedata2;

    wire    [511:0]	readdata;
    wire    [511:0]	q_a;
    wire    [511:0]	readdata2;
    wire    [511:0]	q_b;
    wire        	wren_a;
    wire        	wren_b;
    wire        	clken_int;
    wire        	ram_clocken0;



    assign wren_a = write;
    assign wren_b = write2;

    assign readdata = q_a;
    assign readdata2 = q_b;

    assign clken_int = ~reset_req;



    assign ram_clocken0 = clken_int;



    altera_syncram  altera_syncram_component (
                .address_a    	(address),
                .address_b    	(address2),
                .byteena_a    	(byteenable),
                .byteena_b    	(byteenable2),
                .clock0    	(clk),
                .clocken0    	(ram_clocken0),
                .data_a    	(writedata),
                .data_b    	(writedata2),
                .q_a    	(q_a),
                .q_b    	(q_b),
                .rden_a    	(read),
                .rden_b    	(read2),
                .wren_a    	(wren_a),
                .wren_b    	(wren_b),
                .aclr0    	(1'b0),
                .aclr1    	(1'b0),
                .address2_a    	(1'b1),
                .address2_b    	(1'b1),
                .addressstall_a    	(1'b0),
                .addressstall_b    	(1'b0),
                .clock1    	(1'b1),
                .clocken1    	(1'b1),
                .clocken2    	(1'b1),
                .clocken3    	(1'b1),
                .eccencbypass    	(1'b0),
                .eccencparity    	(8'b0),
                .eccstatus    	(),
                .sclr    	(1'b0)
                );

    defparam
        altera_syncram_component.intended_device_family  	= "Agilex 7",
        altera_syncram_component.lpm_type  	= "altera_syncram",
        altera_syncram_component.operation_mode  	= "BIDIR_DUAL_PORT",
        altera_syncram_component.ram_block_type  	= "AUTO",
        altera_syncram_component.byte_size  	= 8,
        altera_syncram_component.numwords_a  	= 8192,
        altera_syncram_component.numwords_b  	= 8192,
        altera_syncram_component.width_a  	= 512,
        altera_syncram_component.width_b  	= 512,
        altera_syncram_component.widthad_a  	= 13,
        altera_syncram_component.widthad_b  	= 13,
        altera_syncram_component.width_byteena_a  	= 64,
        altera_syncram_component.width_byteena_b  	= 64,
        altera_syncram_component.address_reg_b  	= "CLOCK0",
        altera_syncram_component.byteena_reg_b  	= "CLOCK0",
        altera_syncram_component.indata_reg_b  	= "CLOCK0",
        altera_syncram_component.outdata_reg_a  	= "UNREGISTERED",
        altera_syncram_component.outdata_aclr_a  	= "NONE",
        altera_syncram_component.outdata_sclr_a  	= "NONE",
        altera_syncram_component.outdata_reg_b  	= "UNREGISTERED",
        altera_syncram_component.outdata_aclr_b  	= "NONE",
        altera_syncram_component.outdata_sclr_b  	= "NONE",
        altera_syncram_component.clock_enable_input_a  	= "NORMAL",
        altera_syncram_component.clock_enable_output_a  	= "BYPASS",
        altera_syncram_component.clock_enable_input_b  	= "NORMAL",
        altera_syncram_component.clock_enable_output_b  	= "BYPASS",
        altera_syncram_component.read_during_write_mode_port_a  	= "NEW_DATA_NO_NBE_READ",
        altera_syncram_component.read_during_write_mode_port_b  	= "NEW_DATA_NO_NBE_READ",
        altera_syncram_component.read_during_write_mode_mixed_ports  	= "DONT_CARE";



endmodule
