// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


 
// synopsys translate_off
`timescale 1 ps / 1 ps
// synopsys translate_on

module intel_pcie_bam_interpreter_hw #(
   parameter DEVICE_FAMILY    = "Stratix 10",
   parameter PFNUM_WIDTH      = 3,
   parameter VFNUM_WIDTH      = 11,
   parameter BAM_ENABLE       = 0,
   parameter MAP_BAR          = 0,
   parameter MAP_PF           = 0,
   parameter MAP_VF           = 0,
   parameter ADDR_WIDTH       = 64,
   parameter DATA_WIDTH       = 512,
   parameter BURST_WIDTH      = 4,
   parameter BAM_ADDR_WIDTH   = (BAM_ENABLE ? (ADDR_WIDTH+PFNUM_WIDTH+VFNUM_WIDTH+4) : (ADDR_WIDTH+PFNUM_WIDTH+VFNUM_WIDTH+1)),
   parameter MAP_ADDR_WIDTH   = (BAM_ENABLE ? 
                                 ((MAP_BAR&MAP_PF&MAP_VF) ? (ADDR_WIDTH+PFNUM_WIDTH+VFNUM_WIDTH+4) : 
                                 (MAP_BAR&MAP_PF) ? (ADDR_WIDTH+PFNUM_WIDTH+3) : 
                                 (MAP_BAR) ? (ADDR_WIDTH+3) : (ADDR_WIDTH))
                                 :
                                 ((MAP_BAR&MAP_PF&MAP_VF) ? (ADDR_WIDTH+PFNUM_WIDTH+VFNUM_WIDTH+1) : 
                                 (MAP_BAR&MAP_PF) ? (ADDR_WIDTH+PFNUM_WIDTH) : 
                                 (MAP_BAR) ? (ADDR_WIDTH) : (ADDR_WIDTH))
                                 )
) (
   input  logic                        clk_i,
   input  logic                        reset_i,

   // AVMM Master PIO interface
   input  logic                        pio_read_i,
   input  logic                        pio_write_i,
   input  logic [BAM_ADDR_WIDTH-1:0]   pio_address_i,
   input  logic [BURST_WIDTH-1:0]      pio_burstcount_i,
   input  logic [DATA_WIDTH/8-1:0]     pio_byteenable_i,
   input  logic [DATA_WIDTH-1:0]       pio_writedata_i,
   output logic                        pio_waitrequest_o,
   output logic [DATA_WIDTH-1:0]       pio_readdata_o,
   output logic                        pio_readdatavalid_o,
   output logic [1:0]                  pio_response_o,
   output logic                        pio_writeresponsevalid_o,

   // AVMM Master PIO Conduit
   output logic                        pio_vfactive_o,
   output logic [PFNUM_WIDTH-1:0]      pio_pfnum_o,
   output logic [VFNUM_WIDTH-1:0]      pio_vfnum_o,
   // AVMM Master PIO interface
   output logic                        pio_read_o,
   output logic                        pio_write_o,
   output logic [MAP_ADDR_WIDTH-1:0]   pio_address_o,
   output logic [BURST_WIDTH-1:0]      pio_burstcount_o,
   output logic [DATA_WIDTH/8-1:0]     pio_byteenable_o,
   output logic [DATA_WIDTH-1:0]       pio_writedata_o,
   input  logic                        pio_waitrequest_i,
   input  logic [DATA_WIDTH-1:0]       pio_readdata_i,
   input  logic                        pio_readdatavalid_i,
   input  logic [1:0]                  pio_response_i,
   input  logic                        pio_writeresponsevalid_i,

   // Bursting Master AVMM Interface
   input  logic                        bam_read_i,
   input  logic                        bam_write_i,
   input  logic [BAM_ADDR_WIDTH-1:0]   bam_address_i,
   input  logic [BURST_WIDTH-1:0]      bam_burstcount_i,
   input  logic [DATA_WIDTH/8-1:0]     bam_byteenable_i,
   input  logic [DATA_WIDTH-1:0]       bam_writedata_i,
   output logic                        bam_waitrequest_o,
   output logic [DATA_WIDTH-1:0]       bam_readdata_o,
   output logic                        bam_readdatavalid_o,
   output logic [1:0]                  bam_response_o,

   // Bursting Master AVMM Conduit
   output logic                        bam_vfactive_o,
   output logic [PFNUM_WIDTH-1:0]      bam_pfnum_o,
   output logic [VFNUM_WIDTH-1:0]      bam_vfnum_o,
   // Bursting Master AVMM Interface
   output logic                        bam_read_o,
   output logic                        bam_write_o,
   output logic [MAP_ADDR_WIDTH-1:0]   bam_address_o,
   output logic [BURST_WIDTH-1:0]      bam_burstcount_o,
   output logic [DATA_WIDTH/8-1:0]     bam_byteenable_o,
   output logic [DATA_WIDTH-1:0]       bam_writedata_o,
   input  logic                        bam_waitrequest_i,
   input  logic [DATA_WIDTH-1:0]       bam_readdata_i,
   input  logic                        bam_readdatavalid_i,
   input  logic [1:0]                  bam_response_i
   );

   generate if (BAM_ENABLE) begin : bam_design

      logic                         bam_vfactive;
      logic [PFNUM_WIDTH-1:0]       bam_pfnum;
      logic [VFNUM_WIDTH-1:0]       bam_vfnum;
      logic [2:0]                   bam_bar;
      logic [ADDR_WIDTH-1:0]        bam_address;

      assign {bam_vfactive,bam_pfnum,bam_vfnum,bam_bar,bam_address} = bam_address_i;

      if (MAP_BAR&MAP_PF&MAP_VF) begin
         assign bam_address_o = {bam_vfactive,bam_pfnum,bam_vfnum,bam_bar,bam_address};
      end else if (MAP_BAR&MAP_PF) begin
         assign bam_address_o = {bam_pfnum,bam_bar,bam_address};
      end else if (MAP_BAR) begin
         assign bam_address_o = {bam_bar,bam_address};
      end else begin
         assign bam_address_o = {bam_address};
      end

      assign bam_vfactive_o      = bam_vfactive        ;
      assign bam_pfnum_o         = bam_pfnum           ;
      assign bam_vfnum_o         = bam_vfnum           ;
      assign bam_read_o          = bam_read_i          ;
      assign bam_write_o         = bam_write_i         ;
      assign bam_burstcount_o    = bam_burstcount_i    ;
      assign bam_byteenable_o    = bam_byteenable_i    ;
      assign bam_writedata_o     = bam_writedata_i     ;
      assign bam_waitrequest_o   = bam_waitrequest_i   ;
      assign bam_readdata_o      = bam_readdata_i      ;
      assign bam_readdatavalid_o = bam_readdatavalid_i ;
      assign bam_response_o      = bam_response_i      ;

   end else begin : pio_design

      logic                         pio_vfactive;
      logic [PFNUM_WIDTH-1:0]       pio_pfnum;
      logic [VFNUM_WIDTH-1:0]       pio_vfnum;
      logic [ADDR_WIDTH-1:0]        pio_address;

      assign {pio_vfactive,pio_pfnum,pio_vfnum,pio_address} = pio_address_i;

      if (MAP_BAR&MAP_PF&MAP_VF) begin
         assign pio_address_o = {pio_vfactive,pio_pfnum,pio_vfnum,pio_address};
      end else if (MAP_BAR&MAP_PF) begin
         assign pio_address_o = {pio_pfnum,pio_address};
      end else if (MAP_BAR) begin
         assign pio_address_o = {pio_address};
      end else begin
         assign pio_address_o = {pio_address};
      end

      assign pio_vfactive_o            = pio_vfactive             ;
      assign pio_pfnum_o               = pio_pfnum                ;
      assign pio_vfnum_o               = pio_vfnum                ;
      assign pio_read_o                = pio_read_i               ;
      assign pio_write_o               = pio_write_i              ;
      assign pio_burstcount_o          = pio_burstcount_i         ;
      assign pio_byteenable_o          = pio_byteenable_i         ;
      assign pio_writedata_o           = pio_writedata_i          ;
      assign pio_waitrequest_o         = pio_waitrequest_i        ;
      assign pio_readdata_o            = pio_readdata_i           ;
      assign pio_readdatavalid_o       = pio_readdatavalid_i      ;
      assign pio_response_o            = pio_response_i           ;
      assign pio_writeresponsevalid_o  = pio_writeresponsevalid_i ;

   end endgenerate

endmodule
 
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "u9XHOjfxKdGmdfBPGV1sGWcK6zQfrwpl7Ft5p5k+cbYn51MUCHL3YsEwA/lpffafeFnr19NlrA/9ePA5eUmA4MFMFM/Eg3FIZJld4WO5HdRkqhemddUlpmhCIgRcOwf/mLGsJEnVHhua4vSXY7kOsutPotqECmWew/f8AQ+egw7lkLI2DyyuAStsmCE1zNrhhCJh0B2R5mfJzeVFwSEVN8/cQRlEpu3MvGLxE0+GhILvFdBXiEtWlR8l6f0F4pAdDt6/XuCFze3qjLbN/fZjTcdV+H/4bHurrNixbpIvSQYcoi4EVabUZo+TPwTdyJyge60udxopRklnrt3/LiJti0cYwBhsSa6PHGD+dGAZCA4L94m9xC7dqG5n8YDhhPxNA0et4tgmhOpqPNdfVO4DG1v84NEGJ8FJGwYtqcBG25epuU5GyGDJ1sBJDIZiC39MDk/VOiT5dKwBDjK5L0QdvRpMvrLiXTVoHphnNdnqkFlnjlhIAvqsx89u1xmxt6T52dMXJxZiXpOzpgjMSrHkkCzMXVzZb60kbuqjv7hTolJ91P8/TEErONKGMZv0e4DUAYENRW2zlO2T6heaYG8q/sRTqjjAKHoIEIKfccKWTzml1Zaye0vph79444DuhKAnedIQPemSc52jclVgj225C8AAfU7NBrgGkbK5R23kbvJ6aVjhu3y7dcQQ3HQEBF0IKBOi1OIsqkOANuUwVC+2VR+8JIN/qyHa3dH7FJjbbJZhSKnJjl/gXCTq8kOMBewdOPNRBx02U3Y5Q5msqTzTphNI5uysKt/l60tDxXY/AMx1YAJMaR68O2gpRYrPAGC3GO5ooveVAj522/C9XDOICNaYZERQsW3WEvxy9N08duAfpXKftjoDPkgG4vF1dK+FGyDTyWpgsjIC2DD5ajqQF33/1KjLqiYhSMKFoabKebgr2/dpRvKS8NIhHUonmfRAVkRYR2YR5pWAOeYCl22Hw4JzGtKYdjTMqm8nGewESJhHGVaXbUvNDAIsaN3IhWUJ"
`endif