// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module pcie_ftile_mcdma_intel_pcie_ftile_mcdma_800_k5pmhgi
  # (
     parameter data_width_hwtcl                       = 512,
     parameter empty_width_hwtcl                      = $clog2(data_width_hwtcl/8),
     parameter burst_width_hwtcl                      = (data_width_hwtcl == 512) ? 4 : (data_width_hwtcl == 256) ? 5 : 6,
     parameter m1_data_width_hwtcl                    = 512,
     parameter m1_empty_width_hwtcl                   = $clog2(m1_data_width_hwtcl/8),
     parameter m1_burst_width_hwtcl                   = (m1_data_width_hwtcl == 512) ? 4 : (m1_data_width_hwtcl == 256) ? 5 : 6,
     parameter m2_data_width_hwtcl                    = 256,
     parameter m2_empty_width_hwtcl                   = $clog2(m2_data_width_hwtcl/8),
     parameter m2_burst_width_hwtcl                   = (m2_data_width_hwtcl == 512) ? 4 : (m2_data_width_hwtcl == 256) ? 5 : 6,
     parameter m3_data_width_hwtcl                    = 128,
     parameter m3_empty_width_hwtcl                   = $clog2(m3_data_width_hwtcl/8),
     parameter m3_burst_width_hwtcl                   = (m3_data_width_hwtcl == 512) ? 4 : (m2_data_width_hwtcl == 256) ? 5 : 6,
     parameter tile_hwtcl                             = "F", 
     parameter ST_CHANNEL_WIDTH                       = 11,
     parameter MPS_SUPPORTED                          = 512,
     parameter payload_width_integer_hwtcl            = 256,
     parameter hdr_width_integer_hwtcl                = 256,
     parameter pfx_width_integer_hwtcl                = 64,
     parameter double_width_integer_hwtcl             = 1,
     parameter total_pf_count_hwtcl                   = 4,
     parameter total_pf_count_width_hwtcl             = 2,
     parameter total_vf_count_hwtcl                   = 0,
     parameter total_vf_count_width_hwtcl             = 1,
     parameter device_family                          = "Agilex 7",
     parameter enable_user_flr_hwtcl                  = 1,
     parameter enable_user_msix_hwtcl                 = 1,
     parameter en_metadata_8_hwtcl                    = 0,
     parameter en_10bit_tag_hwtcl                     = 0,
     parameter enable_mcdma_hwtcl                     = 1,
     parameter enable_data_mover_hwtcl                = 0,
     parameter enable_bursting_master_hwtcl           = 0,
     parameter enable_bursting_slave_hwtcl            = 0,
     parameter enable_byte_aligned_txfr_hwtcl         = 1, // 0 = Cache-line aligned txfr, 1 = Byte aligned txfr
     parameter dynamic_cmap_en_hwtcl                  = 0,
     parameter dynamic_num_channel_hwtcl              = 256,
     parameter enable_cs_hwtcl                        = 0,
     parameter pfnum_hwtcl                            = 1,
     parameter pfcnt_w_hwtcl                          = 1,
     parameter vfcnt_w_hwtcl                          = 1,
     parameter bas_address_width_hwtcl                = 64,
     parameter max_bar_address_width_hwtcl            = 32,
     parameter pfnum_width_hwtcl                      = 3,
     parameter vfnum_width_hwtcl                      = 11,
     parameter pio_address_width_hwtcl                = 64,
     parameter pio_data_width_hwtcl                   = 64,
     parameter pio_bar2_size_per_f_hwtcl              = 64,//map to actual BAR2 allocation later
     parameter num_h2d_uport_hwtcl                    = 4,
     parameter num_d2h_uport_hwtcl                    = 4,
     parameter uport_type_h2d_hwtcl                   = 4'hF,
     parameter uport_type_d2h_hwtcl                   = 4'hF,
     parameter d2h_num_active_channel_hwtcl           = 1,
     parameter d2h_max_num_desc_fetch_hwtcl           = 16,
     parameter pf0_enable_sriov_hwtcl                 = 0,
     parameter pf0_num_vf_per_pf_hwtcl                = 0,
     parameter pf0_num_dma_chan_pf_hwtcl              = 0,
     parameter pf0_num_dma_chan_per_vf_hwtcl          = 0,
     parameter pf1_enable_sriov_hwtcl                 = 0,
     parameter pf1_num_vf_per_pf_hwtcl                = 0,
     parameter pf1_num_dma_chan_pf_hwtcl              = 0,
     parameter pf1_num_dma_chan_per_vf_hwtcl          = 0,
     parameter pf2_enable_sriov_hwtcl                 = 0,
     parameter pf2_num_vf_per_pf_hwtcl                = 0,
     parameter pf2_num_dma_chan_pf_hwtcl              = 0,
     parameter pf2_num_dma_chan_per_vf_hwtcl          = 0,
     parameter pf3_enable_sriov_hwtcl                 = 0,
     parameter pf3_num_vf_per_pf_hwtcl                = 0,
     parameter pf3_num_dma_chan_pf_hwtcl              = 0,
     parameter pf3_num_dma_chan_per_vf_hwtcl          = 0,
     parameter pf4_enable_sriov_hwtcl                 = 0,
     parameter pf4_num_vf_per_pf_hwtcl                = 0,
     parameter pf4_num_dma_chan_pf_hwtcl              = 0,
     parameter pf4_num_dma_chan_per_vf_hwtcl          = 0,
     parameter pf5_enable_sriov_hwtcl                 = 0,
     parameter pf5_num_vf_per_pf_hwtcl                = 0,
     parameter pf5_num_dma_chan_pf_hwtcl              = 0,
     parameter pf5_num_dma_chan_per_vf_hwtcl          = 0,
     parameter pf6_enable_sriov_hwtcl                 = 0,
     parameter pf6_num_vf_per_pf_hwtcl                = 0,
     parameter pf6_num_dma_chan_pf_hwtcl              = 0,
     parameter pf6_num_dma_chan_per_vf_hwtcl          = 0,
     parameter pf7_enable_sriov_hwtcl                 = 0,
     parameter pf7_num_vf_per_pf_hwtcl                = 0,
     parameter pf7_num_dma_chan_pf_hwtcl              = 0,
     parameter pf7_num_dma_chan_per_vf_hwtcl          = 0,
     parameter cs_address_width_hwtcl                 = 14,
     parameter top_topology_hwtcl                     = "Gen4 1x16, Interface - 512 bit",
     parameter att_en_for_bas_cs_hwtcl                = 0,
     parameter mapping_table_address_width_hwtcl      = 3,
     parameter mapping_window_address_width_hwtcl     = 16,
          
     parameter m1_att_en_for_bas_cs_hwtcl             = 0,
     parameter m1_mapping_table_address_width_hwtcl   = 3,
     parameter m1_mapping_window_address_width_hwtcl  = 16,

     parameter msi_enable_hwtcl                       = 0,
     parameter per_vec_mask_capable_hwtcl             = 0,
     parameter addr_64bit_capable_hwtcl               = 0,
     parameter multi_msg_capable_hwtcl                = 1,
     parameter ext_msg_data_capable_hwtcl             = 0,

     parameter m1_payload_width_integer_hwtcl            = 256,
     parameter m1_hdr_width_integer_hwtcl                = 256,
     parameter m1_pfx_width_integer_hwtcl                = 64,
     parameter m1_double_width_integer_hwtcl             = 1,
     parameter m1_total_pf_count_hwtcl                   = 4,
     parameter m1_total_pf_count_width_hwtcl             = 2,
     parameter m1_total_vf_count_hwtcl                   = 0,
     parameter m1_total_vf_count_width_hwtcl             = 1,
     parameter m1_enable_user_flr_hwtcl                  = 1,
     parameter m1_enable_user_msix_hwtcl                 = 1,
     parameter m1_en_metadata_8_hwtcl                    = 0,
     parameter m1_enable_mcdma_hwtcl                     = 1,
     parameter m1_enable_data_mover_hwtcl                = 0,
     parameter m1_enable_bursting_master_hwtcl           = 0,
     parameter m1_enable_bursting_slave_hwtcl            = 0,
     parameter m1_enable_byte_aligned_txfr_hwtcl         = 1, // 0 = Cache-line aligned txfr, 1 = Byte aligned txfr
     parameter m1_enable_cs_hwtcl                        = 0,
     parameter m1_pfnum_hwtcl                            = 1,
     parameter m1_pfcnt_w_hwtcl                          = 1,
     parameter m1_vfcnt_w_hwtcl                          = 1,
     parameter m1_bas_address_width_hwtcl                = 64,
     parameter m1_max_bar_address_width_hwtcl            = 32,
     parameter m1_pfnum_width_hwtcl                      = 3,
     parameter m1_vfnum_width_hwtcl                      = 11,
     parameter m1_pio_address_width_hwtcl                = 64,
     parameter m1_pio_data_width_hwtcl                   = 64,
     parameter m1_pio_bar2_size_per_f_hwtcl              = 64,//map to actual BAR2 allocation later
     parameter m1_num_h2d_uport_hwtcl                    = 4,
     parameter m1_num_d2h_uport_hwtcl                    = 4,
     parameter m1_uport_type_h2d_hwtcl                   = 4'hF,
     parameter m1_uport_type_d2h_hwtcl                   = 4'hF,
     parameter m1_d2h_num_active_channel_hwtcl           = 1,
     parameter m1_d2h_max_num_desc_fetch_hwtcl           = 16,
     parameter m1_pf0_enable_sriov_hwtcl                 = 0,
     parameter m1_pf0_num_vf_per_pf_hwtcl                = 0,
     parameter m1_pf0_num_dma_chan_pf_hwtcl              = 0,
     parameter m1_pf0_num_dma_chan_per_vf_hwtcl          = 0,
     parameter m1_pf1_enable_sriov_hwtcl                 = 0,
     parameter m1_pf1_num_vf_per_pf_hwtcl                = 0,
     parameter m1_pf1_num_dma_chan_pf_hwtcl              = 0,
     parameter m1_pf1_num_dma_chan_per_vf_hwtcl          = 0,
     parameter m1_pf2_enable_sriov_hwtcl                 = 0,
     parameter m1_pf2_num_vf_per_pf_hwtcl                = 0,
     parameter m1_pf2_num_dma_chan_pf_hwtcl              = 0,
     parameter m1_pf2_num_dma_chan_per_vf_hwtcl          = 0,
     parameter m1_pf3_enable_sriov_hwtcl                 = 0,
     parameter m1_pf3_num_vf_per_pf_hwtcl                = 0,
     parameter m1_pf3_num_dma_chan_pf_hwtcl              = 0,
     parameter m1_pf3_num_dma_chan_per_vf_hwtcl          = 0,
     parameter m1_pf4_enable_sriov_hwtcl                 = 0,
     parameter m1_pf4_num_vf_per_pf_hwtcl                = 0,
     parameter m1_pf4_num_dma_chan_pf_hwtcl              = 0,
     parameter m1_pf4_num_dma_chan_per_vf_hwtcl          = 0,
     parameter m1_pf5_enable_sriov_hwtcl                 = 0,
     parameter m1_pf5_num_vf_per_pf_hwtcl                = 0,
     parameter m1_pf5_num_dma_chan_pf_hwtcl              = 0,
     parameter m1_pf5_num_dma_chan_per_vf_hwtcl          = 0,
     parameter m1_pf6_enable_sriov_hwtcl                 = 0,
     parameter m1_pf6_num_vf_per_pf_hwtcl                = 0,
     parameter m1_pf6_num_dma_chan_pf_hwtcl              = 0,
     parameter m1_pf6_num_dma_chan_per_vf_hwtcl          = 0,
     parameter m1_pf7_enable_sriov_hwtcl                 = 0,
     parameter m1_pf7_num_vf_per_pf_hwtcl                = 0,
     parameter m1_pf7_num_dma_chan_pf_hwtcl              = 0,
     parameter m1_pf7_num_dma_chan_per_vf_hwtcl          = 0,
     parameter m1_cs_address_width_hwtcl                 = 14,
     parameter m1_msi_enable_hwtcl                       = 0,
     parameter m1_per_vec_mask_capable_hwtcl             = 0,
     parameter m1_addr_64bit_capable_hwtcl               = 0,
     parameter m1_multi_msg_capable_hwtcl                = 1,
     parameter m1_ext_msg_data_capable_hwtcl             = 0,

     parameter adapter_clk_source_hwtcl                                              = "IOPLL",

     parameter m2_pfnum_hwtcl                            = 1,
     parameter m2_pio_data_width_hwtcl                   = 64,
     parameter m2_pio_address_width_hwtcl                = 64,
     parameter m2_pfnum_width_hwtcl                      = 3,
     parameter m2_vfnum_width_hwtcl                      = 11,
     parameter m2_enable_user_msix_hwtcl                 = 1,
     parameter m2_enable_user_flr_hwtcl                  = 1,
     parameter m2_d2h_num_active_channel_hwtcl           = 1,
     parameter m2_d2h_max_num_desc_fetch_hwtcl           = 16,
     parameter m2_en_metadata_8_hwtcl                    = 0,
     parameter m2_pio_bar2_size_per_f_hwtcl              = 64,//map to actual BAR2 allocation later
     parameter m2_enable_mcdma_hwtcl                     = 1,
     parameter m2_enable_data_mover_hwtcl                = 0,
     parameter m2_enable_bursting_master_hwtcl           = 0,
     parameter m2_enable_bursting_slave_hwtcl            = 0,
     parameter m2_enable_byte_aligned_txfr_hwtcl         = 1, // 0 = Cache-line aligned txfr, 1 = Byte aligned txfr
     parameter m2_enable_cs_hwtcl                        = 0,
     parameter m2_pfcnt_w_hwtcl                          = 1,
     parameter m2_vfcnt_w_hwtcl                          = 1,
     parameter m2_bas_address_width_hwtcl                = 64,
     parameter m2_max_bar_address_width_hwtcl            = 32,
     parameter m2_double_width_integer_hwtcl             = 1,
     parameter m2_pfx_width_integer_hwtcl                = 64,
     parameter m2_hdr_width_integer_hwtcl                = 256,
     parameter m2_payload_width_integer_hwtcl            = 256,
     parameter m2_total_pf_count_hwtcl                   = 4,
     parameter m2_total_vf_count_hwtcl                   = 0,
     parameter m2_total_vf_count_width_hwtcl             = 1,
     parameter m2_total_pf_count_width_hwtcl             = 2,
     parameter m2_ext_msg_data_capable_hwtcl             = 0,
     parameter m2_multi_msg_capable_hwtcl                = 5,
     parameter m2_addr_64bit_capable_hwtcl               = 0,
     parameter m2_per_vec_mask_capable_hwtcl             = 0,
     parameter m2_msi_enable_hwtcl                       = 0,
     parameter m2_mapping_window_address_width_hwtcl  = 16,
     parameter m2_att_en_for_bas_cs_hwtcl             = 0,
     parameter m2_mapping_table_address_width_hwtcl   = 3,
     parameter m2_cs_address_width_hwtcl                 = 14,
     parameter m2_num_h2d_uport_hwtcl                    = 4,
     parameter m2_num_d2h_uport_hwtcl                    = 4,
     parameter m2_uport_type_h2d_hwtcl                   = 4'hF,
     parameter m2_uport_type_d2h_hwtcl                   = 4'hF,

     parameter m3_pfnum_hwtcl                            = 1,
     parameter m3_pio_data_width_hwtcl                   = 64,
     parameter m3_pio_address_width_hwtcl                = 64,
     parameter m3_pfnum_width_hwtcl                      = 3,
     parameter m3_vfnum_width_hwtcl                      = 11,
     parameter m3_enable_user_msix_hwtcl                 = 1,
     parameter m3_enable_user_flr_hwtcl                  = 1,
     parameter m3_d2h_num_active_channel_hwtcl           = 1,
     parameter m3_d2h_max_num_desc_fetch_hwtcl           = 16,
     parameter m3_en_metadata_8_hwtcl                    = 0,
     parameter m3_pio_bar2_size_per_f_hwtcl              = 64,//map to actual BAR2 allocation later
     parameter m3_enable_mcdma_hwtcl                     = 1,
     parameter m3_enable_data_mover_hwtcl                = 0,
     parameter m3_enable_bursting_master_hwtcl           = 0,
     parameter m3_enable_bursting_slave_hwtcl            = 0,
     parameter m3_enable_byte_aligned_txfr_hwtcl         = 1, // 0 = Cache-line aligned txfr, 1 = Byte aligned txfr
     parameter m3_enable_cs_hwtcl                        = 0,
     parameter m3_pfcnt_w_hwtcl                          = 1,
     parameter m3_vfcnt_w_hwtcl                          = 1,
     parameter m3_bas_address_width_hwtcl                = 64,
     parameter m3_max_bar_address_width_hwtcl            = 32,
     parameter m3_double_width_integer_hwtcl             = 1,
     parameter m3_pfx_width_integer_hwtcl                = 64,
     parameter m3_hdr_width_integer_hwtcl                = 256,
     parameter m3_payload_width_integer_hwtcl            = 256,
     parameter m3_total_pf_count_hwtcl                   = 4,
     parameter m3_total_vf_count_hwtcl                   = 0,
     parameter m3_total_vf_count_width_hwtcl             = 1,
     parameter m3_total_pf_count_width_hwtcl             = 2,
     parameter m3_ext_msg_data_capable_hwtcl             = 0,
     parameter m3_multi_msg_capable_hwtcl                = 5,
     parameter m3_addr_64bit_capable_hwtcl               = 0,
     parameter m3_per_vec_mask_capable_hwtcl             = 0,
     parameter m3_msi_enable_hwtcl                       = 0,
     parameter m3_mapping_window_address_width_hwtcl  = 16,
     parameter m3_att_en_for_bas_cs_hwtcl             = 0,
     parameter m3_mapping_table_address_width_hwtcl   = 3,
     parameter m3_cs_address_width_hwtcl                 = 14,
     parameter m3_num_h2d_uport_hwtcl                    = 4,
     parameter m3_num_d2h_uport_hwtcl                    = 4,
     parameter m3_uport_type_h2d_hwtcl                   = 4'hF,
     parameter m3_uport_type_d2h_hwtcl                   = 4'hF,

     // Parameters will be removed 
     // reserved
     parameter virtual_pcie_rate_hwtcl                                               = "CTOP_PCIE_GEN4",
     parameter ctop_core16_clrhip_not_rst_sticky                                     = "FALSE",
     parameter ctop_core8_clrhip_not_rst_sticky                                      = "FALSE",
     parameter ctop_core8_en_gpio_perst                                              = "FALSE",
     parameter core16_enable_pld_rst_port0_hwtcl                                     = 0,
     parameter core8_enable_independent_pin_perst_hwtcl                              = 0,
  
     // sim mode
     parameter sim_mode_hwtcl                                                        = "fast_sim_mode",

     // TLP bypass mode
     parameter core16_virtual_tlp_bypass_en_hwtcl                                    = 0,
     parameter core8_virtual_tlp_bypass_en_hwtcl                                     = 0,
     parameter core4_0_virtual_tlp_bypass_en_hwtcl                                   = 0,
     parameter core4_1_virtual_tlp_bypass_en_hwtcl                                   = 0,

     // ST signals width
     parameter core16_payload_width_integer_hwtcl                                    = 512,
     parameter core16_hdr_width_integer_hwtcl                                        = 256,
     parameter core16_pfx_width_integer_hwtcl                                        = 64,
     parameter core16_double_width_integer_hwtcl                                     = 2,
     parameter core16_empty_width_integer_hwtcl                                      = 6,
     parameter core8_payload_width_integer_hwtcl                                     = 256,
     parameter core8_hdr_width_integer_hwtcl                                         = 128,
     parameter core8_pfx_width_integer_hwtcl                                         = 32,
     parameter core8_double_width_integer_hwtcl                                      = 1,
     parameter core8_empty_width_integer_hwtcl                                       = 3,
     parameter core4_0_payload_width_integer_hwtcl                                   = 128,
     parameter core4_0_hdr_width_integer_hwtcl                                       = 128,
     parameter core4_0_pfx_width_integer_hwtcl                                       = 32,
     parameter core4_0_double_width_integer_hwtcl                                    = 1,
     parameter core4_0_empty_width_integer_hwtcl                                     = 2,
     parameter core4_1_payload_width_integer_hwtcl                                   = 128,
     parameter core4_1_hdr_width_integer_hwtcl                                       = 128,
     parameter core4_1_pfx_width_integer_hwtcl                                       = 32,
     parameter core4_1_double_width_integer_hwtcl                                    = 1,
     parameter core4_1_empty_width_integer_hwtcl                                     = 2,
  
     parameter core16_total_pf_count_width_hwtcl                                     = 1,
     parameter core16_total_vf_count_width_hwtcl                                     = 0,
     parameter core16_total_pf_count_hwtcl                                           = 1,
     parameter core16_total_vf_count_hwtcl                                           = 1,
     parameter core8_total_pf_count_width_hwtcl                                      = 1,
     parameter core8_total_vf_count_width_hwtcl                                      = 0,
     parameter core8_total_pf_count_hwtcl                                            = 1,
     parameter core8_total_vf_count_hwtcl                                            = 1,
  
     // rx_buffer_limit
     parameter core16_enable_rx_buffer_limit_ports_hwtcl                             = 1,
     parameter core8_enable_rx_buffer_limit_ports_hwtcl                              = 1,
     parameter core4_0_enable_rx_buffer_limit_ports_hwtcl                            = 1,
     parameter core4_1_enable_rx_buffer_limit_ports_hwtcl                            = 1,

     // Parity Error
     parameter core16_use_ast_parity_hwtcl                                           = 0,
     parameter core8_use_ast_parity_hwtcl                                            = 0,
     parameter core4_0_use_ast_parity_hwtcl                                          = 0,
     parameter core4_1_use_ast_parity_hwtcl                                          = 0,

     // PTM
     parameter core16_virtual_ptm_hwtcl                                              = 0,
     parameter core8_virtual_ptm_hwtcl                                               = 0,
     parameter rxbuf_features_enablement_full                                        = 0,

     // ECC enable
     parameter core16_enable_ecc_hwtcl                                               = 0,
     parameter core8_enable_ecc_hwtcl                                                = 0,
     parameter core4_0_enable_ecc_hwtcl                                              = 0,
     parameter core4_1_enable_ecc_hwtcl                                              = 0,

     // Power management interface parameter for p*_app_req_retry_en (pld_crs_en)
     parameter core16_enable_power_mgnt_intf_hwtcl                                   = 0,
     parameter core8_enable_power_mgnt_intf_hwtcl                                    = 0,
     parameter core4_0_enable_power_mgnt_intf_hwtcl                                  = 0,
     parameter core4_1_enable_power_mgnt_intf_hwtcl                                  = 0,

     // PCS Reconfig
     parameter PCS_CONFIG_EN                                                         = 0,
     parameter core16_hip_reconfig_hwtcl                                             = 0,
     parameter core8_hip_reconfig_hwtcl                                              = 0,
     parameter core4_0_hip_reconfig_hwtcl                                            = 0,
     parameter core4_1_hip_reconfig_hwtcl                                            = 0,
     parameter xcvr_reconfig_hwtcl                                                   = 0,
     parameter pld_clrpcs_hwtcl                                                      = 0,

     // VIRTIO - core16
     parameter core16_enable_virtio_hwtcl                                            = 0,
     parameter core16_virtio_start_byte_address_hwtcl                                = 8'h48,
     parameter core16_pf0_virtio_capability_present_hwtcl                            = 0,
     parameter core16_pf0_virtio_device_specific_cap_present_hwtcl                   = 0,
     parameter core16_pf0_virtio_cmn_config_bar_indicator_hwtcl                      = 0,
     parameter core16_pf0_virtio_cmn_config_bar_offset_hwtcl                         = 0,
     parameter core16_pf0_virtio_cmn_config_structure_length_hwtcl                   = 0,
     parameter core16_pf0_virtio_notification_bar_indicator_hwtcl                    = 0,
     parameter core16_pf0_virtio_notification_bar_offset_hwtcl                       = 0,
     parameter core16_pf0_virtio_notification_structure_length_hwtcl                 = 0,
     parameter core16_pf0_virtio_notify_off_multiplier_hwtcl                         = 0,
     parameter core16_pf0_virtio_isrstatus_bar_indicator_hwtcl                       = 0,
     parameter core16_pf0_virtio_isrstatus_bar_offset_hwtcl                          = 0,
     parameter core16_pf0_virtio_isrstatus_structure_length_hwtcl                    = 0,
     parameter core16_pf0_virtio_devspecific_bar_indicator_hwtcl                     = 0,
     parameter core16_pf0_virtio_devspecific_bar_offset_hwtcl                        = 0,
     parameter core16_pf0_virtio_devspecific_structure_length_hwtcl                  = 0,
     parameter core16_pf0_virtio_pciconfig_access_bar_indicator_hwtcl                = 0,
     parameter core16_pf0_virtio_pciconfig_access_bar_offset_hwtcl                   = 0,
     parameter core16_pf0_virtio_pciconfig_access_structure_length_hwtcl             = 0,
     parameter core16_pf1_virtio_capability_present_hwtcl                            = 0,
     parameter core16_pf1_virtio_device_specific_cap_present_hwtcl                   = 0,
     parameter core16_pf1_virtio_cmn_config_bar_indicator_hwtcl                      = 0,
     parameter core16_pf1_virtio_cmn_config_bar_offset_hwtcl                         = 0,
     parameter core16_pf1_virtio_cmn_config_structure_length_hwtcl                   = 0,
     parameter core16_pf1_virtio_notification_bar_indicator_hwtcl                    = 0,
     parameter core16_pf1_virtio_notification_bar_offset_hwtcl                       = 0,
     parameter core16_pf1_virtio_notification_structure_length_hwtcl                 = 0,
     parameter core16_pf1_virtio_notify_off_multiplier_hwtcl                         = 0,
     parameter core16_pf1_virtio_isrstatus_bar_indicator_hwtcl                       = 0,
     parameter core16_pf1_virtio_isrstatus_bar_offset_hwtcl                          = 0,
     parameter core16_pf1_virtio_isrstatus_structure_length_hwtcl                    = 0,
     parameter core16_pf1_virtio_devspecific_bar_indicator_hwtcl                     = 0,
     parameter core16_pf1_virtio_devspecific_bar_offset_hwtcl                        = 0,
     parameter core16_pf1_virtio_devspecific_structure_length_hwtcl                  = 0,
     parameter core16_pf1_virtio_pciconfig_access_bar_indicator_hwtcl                = 0,
     parameter core16_pf1_virtio_pciconfig_access_bar_offset_hwtcl                   = 0,
     parameter core16_pf1_virtio_pciconfig_access_structure_length_hwtcl             = 0,
     parameter core16_pf2_virtio_capability_present_hwtcl                            = 0,
     parameter core16_pf2_virtio_device_specific_cap_present_hwtcl                   = 0,
     parameter core16_pf2_virtio_cmn_config_bar_indicator_hwtcl                      = 0,
     parameter core16_pf2_virtio_cmn_config_bar_offset_hwtcl                         = 0,
     parameter core16_pf2_virtio_cmn_config_structure_length_hwtcl                   = 0,
     parameter core16_pf2_virtio_notification_bar_indicator_hwtcl                    = 0,
     parameter core16_pf2_virtio_notification_bar_offset_hwtcl                       = 0,
     parameter core16_pf2_virtio_notification_structure_length_hwtcl                 = 0,
     parameter core16_pf2_virtio_notify_off_multiplier_hwtcl                         = 0,
     parameter core16_pf2_virtio_isrstatus_bar_indicator_hwtcl                       = 0,
     parameter core16_pf2_virtio_isrstatus_bar_offset_hwtcl                          = 0,
     parameter core16_pf2_virtio_isrstatus_structure_length_hwtcl                    = 0,
     parameter core16_pf2_virtio_devspecific_bar_indicator_hwtcl                     = 0,
     parameter core16_pf2_virtio_devspecific_bar_offset_hwtcl                        = 0,
     parameter core16_pf2_virtio_devspecific_structure_length_hwtcl                  = 0,
     parameter core16_pf2_virtio_pciconfig_access_bar_indicator_hwtcl                = 0,
     parameter core16_pf2_virtio_pciconfig_access_bar_offset_hwtcl                   = 0,
     parameter core16_pf2_virtio_pciconfig_access_structure_length_hwtcl             = 0,
     parameter core16_pf3_virtio_capability_present_hwtcl                            = 0,
     parameter core16_pf3_virtio_device_specific_cap_present_hwtcl                   = 0,
     parameter core16_pf3_virtio_cmn_config_bar_indicator_hwtcl                      = 0,
     parameter core16_pf3_virtio_cmn_config_bar_offset_hwtcl                         = 0,
     parameter core16_pf3_virtio_cmn_config_structure_length_hwtcl                   = 0,
     parameter core16_pf3_virtio_notification_bar_indicator_hwtcl                    = 0,
     parameter core16_pf3_virtio_notification_bar_offset_hwtcl                       = 0,
     parameter core16_pf3_virtio_notification_structure_length_hwtcl                 = 0,
     parameter core16_pf3_virtio_notify_off_multiplier_hwtcl                         = 0,
     parameter core16_pf3_virtio_isrstatus_bar_indicator_hwtcl                       = 0,
     parameter core16_pf3_virtio_isrstatus_bar_offset_hwtcl                          = 0,
     parameter core16_pf3_virtio_isrstatus_structure_length_hwtcl                    = 0,
     parameter core16_pf3_virtio_devspecific_bar_indicator_hwtcl                     = 0,
     parameter core16_pf3_virtio_devspecific_bar_offset_hwtcl                        = 0,
     parameter core16_pf3_virtio_devspecific_structure_length_hwtcl                  = 0,
     parameter core16_pf3_virtio_pciconfig_access_bar_indicator_hwtcl                = 0,
     parameter core16_pf3_virtio_pciconfig_access_bar_offset_hwtcl                   = 0,
     parameter core16_pf3_virtio_pciconfig_access_structure_length_hwtcl             = 0,
     parameter core16_pf4_virtio_capability_present_hwtcl                            = 0,
     parameter core16_pf4_virtio_device_specific_cap_present_hwtcl                   = 0,
     parameter core16_pf4_virtio_cmn_config_bar_indicator_hwtcl                      = 0,
     parameter core16_pf4_virtio_cmn_config_bar_offset_hwtcl                         = 0,
     parameter core16_pf4_virtio_cmn_config_structure_length_hwtcl                   = 0,
     parameter core16_pf4_virtio_notification_bar_indicator_hwtcl                    = 0,
     parameter core16_pf4_virtio_notification_bar_offset_hwtcl                       = 0,
     parameter core16_pf4_virtio_notification_structure_length_hwtcl                 = 0,
     parameter core16_pf4_virtio_notify_off_multiplier_hwtcl                         = 0,
     parameter core16_pf4_virtio_isrstatus_bar_indicator_hwtcl                       = 0,
     parameter core16_pf4_virtio_isrstatus_bar_offset_hwtcl                          = 0,
     parameter core16_pf4_virtio_isrstatus_structure_length_hwtcl                    = 0,
     parameter core16_pf4_virtio_devspecific_bar_indicator_hwtcl                     = 0,
     parameter core16_pf4_virtio_devspecific_bar_offset_hwtcl                        = 0,
     parameter core16_pf4_virtio_devspecific_structure_length_hwtcl                  = 0,
     parameter core16_pf4_virtio_pciconfig_access_bar_indicator_hwtcl                = 0,
     parameter core16_pf4_virtio_pciconfig_access_bar_offset_hwtcl                   = 0,
     parameter core16_pf4_virtio_pciconfig_access_structure_length_hwtcl             = 0,
     parameter core16_pf5_virtio_capability_present_hwtcl                            = 0,
     parameter core16_pf5_virtio_device_specific_cap_present_hwtcl                   = 0,
     parameter core16_pf5_virtio_cmn_config_bar_indicator_hwtcl                      = 0,
     parameter core16_pf5_virtio_cmn_config_bar_offset_hwtcl                         = 0,
     parameter core16_pf5_virtio_cmn_config_structure_length_hwtcl                   = 0,
     parameter core16_pf5_virtio_notification_bar_indicator_hwtcl                    = 0,
     parameter core16_pf5_virtio_notification_bar_offset_hwtcl                       = 0,
     parameter core16_pf5_virtio_notification_structure_length_hwtcl                 = 0,
     parameter core16_pf5_virtio_notify_off_multiplier_hwtcl                         = 0,
     parameter core16_pf5_virtio_isrstatus_bar_indicator_hwtcl                       = 0,
     parameter core16_pf5_virtio_isrstatus_bar_offset_hwtcl                          = 0,
     parameter core16_pf5_virtio_isrstatus_structure_length_hwtcl                    = 0,
     parameter core16_pf5_virtio_devspecific_bar_indicator_hwtcl                     = 0,
     parameter core16_pf5_virtio_devspecific_bar_offset_hwtcl                        = 0,
     parameter core16_pf5_virtio_devspecific_structure_length_hwtcl                  = 0,
     parameter core16_pf5_virtio_pciconfig_access_bar_indicator_hwtcl                = 0,
     parameter core16_pf5_virtio_pciconfig_access_bar_offset_hwtcl                   = 0,
     parameter core16_pf5_virtio_pciconfig_access_structure_length_hwtcl             = 0,
     parameter core16_pf6_virtio_capability_present_hwtcl                            = 0,
     parameter core16_pf6_virtio_device_specific_cap_present_hwtcl                   = 0,
     parameter core16_pf6_virtio_cmn_config_bar_indicator_hwtcl                      = 0,
     parameter core16_pf6_virtio_cmn_config_bar_offset_hwtcl                         = 0,
     parameter core16_pf6_virtio_cmn_config_structure_length_hwtcl                   = 0,
     parameter core16_pf6_virtio_notification_bar_indicator_hwtcl                    = 0,
     parameter core16_pf6_virtio_notification_bar_offset_hwtcl                       = 0,
     parameter core16_pf6_virtio_notification_structure_length_hwtcl                 = 0,
     parameter core16_pf6_virtio_notify_off_multiplier_hwtcl                         = 0,
     parameter core16_pf6_virtio_isrstatus_bar_indicator_hwtcl                       = 0,
     parameter core16_pf6_virtio_isrstatus_bar_offset_hwtcl                          = 0,
     parameter core16_pf6_virtio_isrstatus_structure_length_hwtcl                    = 0,
     parameter core16_pf6_virtio_devspecific_bar_indicator_hwtcl                     = 0,
     parameter core16_pf6_virtio_devspecific_bar_offset_hwtcl                        = 0,
     parameter core16_pf6_virtio_devspecific_structure_length_hwtcl                  = 0,
     parameter core16_pf6_virtio_pciconfig_access_bar_indicator_hwtcl                = 0,
     parameter core16_pf6_virtio_pciconfig_access_bar_offset_hwtcl                   = 0,
     parameter core16_pf6_virtio_pciconfig_access_structure_length_hwtcl             = 0,
     parameter core16_pf7_virtio_capability_present_hwtcl                            = 0,
     parameter core16_pf7_virtio_device_specific_cap_present_hwtcl                   = 0,
     parameter core16_pf7_virtio_cmn_config_bar_indicator_hwtcl                      = 0,
     parameter core16_pf7_virtio_cmn_config_bar_offset_hwtcl                         = 0,
     parameter core16_pf7_virtio_cmn_config_structure_length_hwtcl                   = 0,
     parameter core16_pf7_virtio_notification_bar_indicator_hwtcl                    = 0,
     parameter core16_pf7_virtio_notification_bar_offset_hwtcl                       = 0,
     parameter core16_pf7_virtio_notification_structure_length_hwtcl                 = 0,
     parameter core16_pf7_virtio_notify_off_multiplier_hwtcl                         = 0,
     parameter core16_pf7_virtio_isrstatus_bar_indicator_hwtcl                       = 0,
     parameter core16_pf7_virtio_isrstatus_bar_offset_hwtcl                          = 0,
     parameter core16_pf7_virtio_isrstatus_structure_length_hwtcl                    = 0,
     parameter core16_pf7_virtio_devspecific_bar_indicator_hwtcl                     = 0,
     parameter core16_pf7_virtio_devspecific_bar_offset_hwtcl                        = 0,
     parameter core16_pf7_virtio_devspecific_structure_length_hwtcl                  = 0,
     parameter core16_pf7_virtio_pciconfig_access_bar_indicator_hwtcl                = 0,
     parameter core16_pf7_virtio_pciconfig_access_bar_offset_hwtcl                   = 0,
     parameter core16_pf7_virtio_pciconfig_access_structure_length_hwtcl             = 0,
     parameter core16_pf0vf_virtio_capability_present_hwtcl                          = 0,
     parameter core16_pf0vf_virtio_device_specific_cap_present_hwtcl                 = 0,
     parameter core16_pf0vf_virtio_cmn_config_bar_indicator_hwtcl                    = 0,
     parameter core16_pf0vf_virtio_cmn_config_bar_offset_hwtcl                       = 0,
     parameter core16_pf0vf_virtio_cmn_config_structure_length_hwtcl                 = 0,
     parameter core16_pf0vf_virtio_notification_bar_indicator_hwtcl                  = 0,
     parameter core16_pf0vf_virtio_notification_bar_offset_hwtcl                     = 0,
     parameter core16_pf0vf_virtio_notification_structure_length_hwtcl               = 0,
     parameter core16_pf0vf_virtio_notify_off_multiplier_hwtcl                       = 0,
     parameter core16_pf0vf_virtio_isrstatus_bar_indicator_hwtcl                     = 0,
     parameter core16_pf0vf_virtio_isrstatus_bar_offset_hwtcl                        = 0,
     parameter core16_pf0vf_virtio_isrstatus_structure_length_hwtcl                  = 0,
     parameter core16_pf0vf_virtio_devspecific_bar_indicator_hwtcl                   = 0,
     parameter core16_pf0vf_virtio_devspecific_bar_offset_hwtcl                      = 0,
     parameter core16_pf0vf_virtio_devspecific_structure_length_hwtcl                = 0,
     parameter core16_pf0vf_virtio_pciconfig_access_bar_indicator_hwtcl              = 0,
     parameter core16_pf0vf_virtio_pciconfig_access_bar_offset_hwtcl                 = 0,
     parameter core16_pf0vf_virtio_pciconfig_access_structure_length_hwtcl           = 0,
     parameter core16_pf1vf_virtio_capability_present_hwtcl                          = 0,
     parameter core16_pf1vf_virtio_device_specific_cap_present_hwtcl                 = 0,
     parameter core16_pf1vf_virtio_cmn_config_bar_indicator_hwtcl                    = 0,
     parameter core16_pf1vf_virtio_cmn_config_bar_offset_hwtcl                       = 0,
     parameter core16_pf1vf_virtio_cmn_config_structure_length_hwtcl                 = 0,
     parameter core16_pf1vf_virtio_notification_bar_indicator_hwtcl                  = 0,
     parameter core16_pf1vf_virtio_notification_bar_offset_hwtcl                     = 0,
     parameter core16_pf1vf_virtio_notification_structure_length_hwtcl               = 0,
     parameter core16_pf1vf_virtio_notify_off_multiplier_hwtcl                       = 0,
     parameter core16_pf1vf_virtio_isrstatus_bar_indicator_hwtcl                     = 0,
     parameter core16_pf1vf_virtio_isrstatus_bar_offset_hwtcl                        = 0,
     parameter core16_pf1vf_virtio_isrstatus_structure_length_hwtcl                  = 0,
     parameter core16_pf1vf_virtio_devspecific_bar_indicator_hwtcl                   = 0,
     parameter core16_pf1vf_virtio_devspecific_bar_offset_hwtcl                      = 0,
     parameter core16_pf1vf_virtio_devspecific_structure_length_hwtcl                = 0,
     parameter core16_pf1vf_virtio_pciconfig_access_bar_indicator_hwtcl              = 0,
     parameter core16_pf1vf_virtio_pciconfig_access_bar_offset_hwtcl                 = 0,
     parameter core16_pf1vf_virtio_pciconfig_access_structure_length_hwtcl           = 0,
     parameter core16_pf2vf_virtio_capability_present_hwtcl                          = 0,
     parameter core16_pf2vf_virtio_device_specific_cap_present_hwtcl                 = 0,
     parameter core16_pf2vf_virtio_cmn_config_bar_indicator_hwtcl                    = 0,
     parameter core16_pf2vf_virtio_cmn_config_bar_offset_hwtcl                       = 0,
     parameter core16_pf2vf_virtio_cmn_config_structure_length_hwtcl                 = 0,
     parameter core16_pf2vf_virtio_notification_bar_indicator_hwtcl                  = 0,
     parameter core16_pf2vf_virtio_notification_bar_offset_hwtcl                     = 0,
     parameter core16_pf2vf_virtio_notification_structure_length_hwtcl               = 0,
     parameter core16_pf2vf_virtio_notify_off_multiplier_hwtcl                       = 0,
     parameter core16_pf2vf_virtio_isrstatus_bar_indicator_hwtcl                     = 0,
     parameter core16_pf2vf_virtio_isrstatus_bar_offset_hwtcl                        = 0,
     parameter core16_pf2vf_virtio_isrstatus_structure_length_hwtcl                  = 0,
     parameter core16_pf2vf_virtio_devspecific_bar_indicator_hwtcl                   = 0,
     parameter core16_pf2vf_virtio_devspecific_bar_offset_hwtcl                      = 0,
     parameter core16_pf2vf_virtio_devspecific_structure_length_hwtcl                = 0,
     parameter core16_pf2vf_virtio_pciconfig_access_bar_indicator_hwtcl              = 0,
     parameter core16_pf2vf_virtio_pciconfig_access_bar_offset_hwtcl                 = 0,
     parameter core16_pf2vf_virtio_pciconfig_access_structure_length_hwtcl           = 0,
     parameter core16_pf3vf_virtio_capability_present_hwtcl                          = 0,
     parameter core16_pf3vf_virtio_device_specific_cap_present_hwtcl                 = 0,
     parameter core16_pf3vf_virtio_cmn_config_bar_indicator_hwtcl                    = 0,
     parameter core16_pf3vf_virtio_cmn_config_bar_offset_hwtcl                       = 0,
     parameter core16_pf3vf_virtio_cmn_config_structure_length_hwtcl                 = 0,
     parameter core16_pf3vf_virtio_notification_bar_indicator_hwtcl                  = 0,
     parameter core16_pf3vf_virtio_notification_bar_offset_hwtcl                     = 0,
     parameter core16_pf3vf_virtio_notification_structure_length_hwtcl               = 0,
     parameter core16_pf3vf_virtio_notify_off_multiplier_hwtcl                       = 0,
     parameter core16_pf3vf_virtio_isrstatus_bar_indicator_hwtcl                     = 0,
     parameter core16_pf3vf_virtio_isrstatus_bar_offset_hwtcl                        = 0,
     parameter core16_pf3vf_virtio_isrstatus_structure_length_hwtcl                  = 0,
     parameter core16_pf3vf_virtio_devspecific_bar_indicator_hwtcl                   = 0,
     parameter core16_pf3vf_virtio_devspecific_bar_offset_hwtcl                      = 0,
     parameter core16_pf3vf_virtio_devspecific_structure_length_hwtcl                = 0,
     parameter core16_pf3vf_virtio_pciconfig_access_bar_indicator_hwtcl              = 0,
     parameter core16_pf3vf_virtio_pciconfig_access_bar_offset_hwtcl                 = 0,
     parameter core16_pf3vf_virtio_pciconfig_access_structure_length_hwtcl           = 0,
     parameter core16_pf4vf_virtio_capability_present_hwtcl                          = 0,
     parameter core16_pf4vf_virtio_device_specific_cap_present_hwtcl                 = 0,
     parameter core16_pf4vf_virtio_cmn_config_bar_indicator_hwtcl                    = 0,
     parameter core16_pf4vf_virtio_cmn_config_bar_offset_hwtcl                       = 0,
     parameter core16_pf4vf_virtio_cmn_config_structure_length_hwtcl                 = 0,
     parameter core16_pf4vf_virtio_notification_bar_indicator_hwtcl                  = 0,
     parameter core16_pf4vf_virtio_notification_bar_offset_hwtcl                     = 0,
     parameter core16_pf4vf_virtio_notification_structure_length_hwtcl               = 0,
     parameter core16_pf4vf_virtio_notify_off_multiplier_hwtcl                       = 0,
     parameter core16_pf4vf_virtio_isrstatus_bar_indicator_hwtcl                     = 0,
     parameter core16_pf4vf_virtio_isrstatus_bar_offset_hwtcl                        = 0,
     parameter core16_pf4vf_virtio_isrstatus_structure_length_hwtcl                  = 0,
     parameter core16_pf4vf_virtio_devspecific_bar_indicator_hwtcl                   = 0,
     parameter core16_pf4vf_virtio_devspecific_bar_offset_hwtcl                      = 0,
     parameter core16_pf4vf_virtio_devspecific_structure_length_hwtcl                = 0,
     parameter core16_pf4vf_virtio_pciconfig_access_bar_indicator_hwtcl              = 0,
     parameter core16_pf4vf_virtio_pciconfig_access_bar_offset_hwtcl                 = 0,
     parameter core16_pf4vf_virtio_pciconfig_access_structure_length_hwtcl           = 0,
     parameter core16_pf5vf_virtio_capability_present_hwtcl                          = 0,
     parameter core16_pf5vf_virtio_device_specific_cap_present_hwtcl                 = 0,
     parameter core16_pf5vf_virtio_cmn_config_bar_indicator_hwtcl                    = 0,
     parameter core16_pf5vf_virtio_cmn_config_bar_offset_hwtcl                       = 0,
     parameter core16_pf5vf_virtio_cmn_config_structure_length_hwtcl                 = 0,
     parameter core16_pf5vf_virtio_notification_bar_indicator_hwtcl                  = 0,
     parameter core16_pf5vf_virtio_notification_bar_offset_hwtcl                     = 0,
     parameter core16_pf5vf_virtio_notification_structure_length_hwtcl               = 0,
     parameter core16_pf5vf_virtio_notify_off_multiplier_hwtcl                       = 0,
     parameter core16_pf5vf_virtio_isrstatus_bar_indicator_hwtcl                     = 0,
     parameter core16_pf5vf_virtio_isrstatus_bar_offset_hwtcl                        = 0,
     parameter core16_pf5vf_virtio_isrstatus_structure_length_hwtcl                  = 0,
     parameter core16_pf5vf_virtio_devspecific_bar_indicator_hwtcl                   = 0,
     parameter core16_pf5vf_virtio_devspecific_bar_offset_hwtcl                      = 0,
     parameter core16_pf5vf_virtio_devspecific_structure_length_hwtcl                = 0,
     parameter core16_pf5vf_virtio_pciconfig_access_bar_indicator_hwtcl              = 0,
     parameter core16_pf5vf_virtio_pciconfig_access_bar_offset_hwtcl                 = 0,
     parameter core16_pf5vf_virtio_pciconfig_access_structure_length_hwtcl           = 0,
     parameter core16_pf6vf_virtio_capability_present_hwtcl                          = 0,
     parameter core16_pf6vf_virtio_device_specific_cap_present_hwtcl                 = 0,
     parameter core16_pf6vf_virtio_cmn_config_bar_indicator_hwtcl                    = 0,
     parameter core16_pf6vf_virtio_cmn_config_bar_offset_hwtcl                       = 0,
     parameter core16_pf6vf_virtio_cmn_config_structure_length_hwtcl                 = 0,
     parameter core16_pf6vf_virtio_notification_bar_indicator_hwtcl                  = 0,
     parameter core16_pf6vf_virtio_notification_bar_offset_hwtcl                     = 0,
     parameter core16_pf6vf_virtio_notification_structure_length_hwtcl               = 0,
     parameter core16_pf6vf_virtio_notify_off_multiplier_hwtcl                       = 0,
     parameter core16_pf6vf_virtio_isrstatus_bar_indicator_hwtcl                     = 0,
     parameter core16_pf6vf_virtio_isrstatus_bar_offset_hwtcl                        = 0,
     parameter core16_pf6vf_virtio_isrstatus_structure_length_hwtcl                  = 0,
     parameter core16_pf6vf_virtio_devspecific_bar_indicator_hwtcl                   = 0,
     parameter core16_pf6vf_virtio_devspecific_bar_offset_hwtcl                      = 0,
     parameter core16_pf6vf_virtio_devspecific_structure_length_hwtcl                = 0,
     parameter core16_pf6vf_virtio_pciconfig_access_bar_indicator_hwtcl              = 0,
     parameter core16_pf6vf_virtio_pciconfig_access_bar_offset_hwtcl                 = 0,
     parameter core16_pf6vf_virtio_pciconfig_access_structure_length_hwtcl           = 0,
     parameter core16_pf7vf_virtio_capability_present_hwtcl                          = 0,
     parameter core16_pf7vf_virtio_device_specific_cap_present_hwtcl                 = 0,
     parameter core16_pf7vf_virtio_cmn_config_bar_indicator_hwtcl                    = 0,
     parameter core16_pf7vf_virtio_cmn_config_bar_offset_hwtcl                       = 0,
     parameter core16_pf7vf_virtio_cmn_config_structure_length_hwtcl                 = 0,
     parameter core16_pf7vf_virtio_notification_bar_indicator_hwtcl                  = 0,
     parameter core16_pf7vf_virtio_notification_bar_offset_hwtcl                     = 0,
     parameter core16_pf7vf_virtio_notification_structure_length_hwtcl               = 0,
     parameter core16_pf7vf_virtio_notify_off_multiplier_hwtcl                       = 0,
     parameter core16_pf7vf_virtio_isrstatus_bar_indicator_hwtcl                     = 0,
     parameter core16_pf7vf_virtio_isrstatus_bar_offset_hwtcl                        = 0,
     parameter core16_pf7vf_virtio_isrstatus_structure_length_hwtcl                  = 0,
     parameter core16_pf7vf_virtio_devspecific_bar_indicator_hwtcl                   = 0,
     parameter core16_pf7vf_virtio_devspecific_bar_offset_hwtcl                      = 0,
     parameter core16_pf7vf_virtio_devspecific_structure_length_hwtcl                = 0,
     parameter core16_pf7vf_virtio_pciconfig_access_bar_indicator_hwtcl              = 0,
     parameter core16_pf7vf_virtio_pciconfig_access_bar_offset_hwtcl                 = 0,
     parameter core16_pf7vf_virtio_pciconfig_access_structure_length_hwtcl           = 0,

     // VIRTIO - core8
     parameter core8_enable_virtio_hwtcl                                             = 0,
     parameter core8_virtio_start_byte_address_hwtcl                                 = 8'h48,
     parameter core8_pf0_virtio_capability_present_hwtcl                             = 0,
     parameter core8_pf0_virtio_device_specific_cap_present_hwtcl                    = 0,
     parameter core8_pf0_virtio_cmn_config_bar_indicator_hwtcl                       = 0,
     parameter core8_pf0_virtio_cmn_config_bar_offset_hwtcl                          = 0,
     parameter core8_pf0_virtio_cmn_config_structure_length_hwtcl                    = 0,
     parameter core8_pf0_virtio_notification_bar_indicator_hwtcl                     = 0,
     parameter core8_pf0_virtio_notification_bar_offset_hwtcl                        = 0,
     parameter core8_pf0_virtio_notification_structure_length_hwtcl                  = 0,
     parameter core8_pf0_virtio_notify_off_multiplier_hwtcl                          = 0,
     parameter core8_pf0_virtio_isrstatus_bar_indicator_hwtcl                        = 0,
     parameter core8_pf0_virtio_isrstatus_bar_offset_hwtcl                           = 0,
     parameter core8_pf0_virtio_isrstatus_structure_length_hwtcl                     = 0,
     parameter core8_pf0_virtio_devspecific_bar_indicator_hwtcl                      = 0,
     parameter core8_pf0_virtio_devspecific_bar_offset_hwtcl                         = 0,
     parameter core8_pf0_virtio_devspecific_structure_length_hwtcl                   = 0,
     parameter core8_pf0_virtio_pciconfig_access_bar_indicator_hwtcl                 = 0,
     parameter core8_pf0_virtio_pciconfig_access_bar_offset_hwtcl                    = 0,
     parameter core8_pf0_virtio_pciconfig_access_structure_length_hwtcl              = 0,
     parameter core8_pf1_virtio_capability_present_hwtcl                             = 0,
     parameter core8_pf1_virtio_device_specific_cap_present_hwtcl                    = 0,
     parameter core8_pf1_virtio_cmn_config_bar_indicator_hwtcl                       = 0,
     parameter core8_pf1_virtio_cmn_config_bar_offset_hwtcl                          = 0,
     parameter core8_pf1_virtio_cmn_config_structure_length_hwtcl                    = 0,
     parameter core8_pf1_virtio_notification_bar_indicator_hwtcl                     = 0,
     parameter core8_pf1_virtio_notification_bar_offset_hwtcl                        = 0,
     parameter core8_pf1_virtio_notification_structure_length_hwtcl                  = 0,
     parameter core8_pf1_virtio_notify_off_multiplier_hwtcl                          = 0,
     parameter core8_pf1_virtio_isrstatus_bar_indicator_hwtcl                        = 0,
     parameter core8_pf1_virtio_isrstatus_bar_offset_hwtcl                           = 0,
     parameter core8_pf1_virtio_isrstatus_structure_length_hwtcl                     = 0,
     parameter core8_pf1_virtio_devspecific_bar_indicator_hwtcl                      = 0,
     parameter core8_pf1_virtio_devspecific_bar_offset_hwtcl                         = 0,
     parameter core8_pf1_virtio_devspecific_structure_length_hwtcl                   = 0,
     parameter core8_pf1_virtio_pciconfig_access_bar_indicator_hwtcl                 = 0,
     parameter core8_pf1_virtio_pciconfig_access_bar_offset_hwtcl                    = 0,
     parameter core8_pf1_virtio_pciconfig_access_structure_length_hwtcl              = 0,
     parameter core8_pf2_virtio_capability_present_hwtcl                             = 0,
     parameter core8_pf2_virtio_device_specific_cap_present_hwtcl                    = 0,
     parameter core8_pf2_virtio_cmn_config_bar_indicator_hwtcl                       = 0,
     parameter core8_pf2_virtio_cmn_config_bar_offset_hwtcl                          = 0,
     parameter core8_pf2_virtio_cmn_config_structure_length_hwtcl                    = 0,
     parameter core8_pf2_virtio_notification_bar_indicator_hwtcl                     = 0,
     parameter core8_pf2_virtio_notification_bar_offset_hwtcl                        = 0,
     parameter core8_pf2_virtio_notification_structure_length_hwtcl                  = 0,
     parameter core8_pf2_virtio_notify_off_multiplier_hwtcl                          = 0,
     parameter core8_pf2_virtio_isrstatus_bar_indicator_hwtcl                        = 0,
     parameter core8_pf2_virtio_isrstatus_bar_offset_hwtcl                           = 0,
     parameter core8_pf2_virtio_isrstatus_structure_length_hwtcl                     = 0,
     parameter core8_pf2_virtio_devspecific_bar_indicator_hwtcl                      = 0,
     parameter core8_pf2_virtio_devspecific_bar_offset_hwtcl                         = 0,
     parameter core8_pf2_virtio_devspecific_structure_length_hwtcl                   = 0,
     parameter core8_pf2_virtio_pciconfig_access_bar_indicator_hwtcl                 = 0,
     parameter core8_pf2_virtio_pciconfig_access_bar_offset_hwtcl                    = 0,
     parameter core8_pf2_virtio_pciconfig_access_structure_length_hwtcl              = 0,
     parameter core8_pf3_virtio_capability_present_hwtcl                             = 0,
     parameter core8_pf3_virtio_device_specific_cap_present_hwtcl                    = 0,
     parameter core8_pf3_virtio_cmn_config_bar_indicator_hwtcl                       = 0,
     parameter core8_pf3_virtio_cmn_config_bar_offset_hwtcl                          = 0,
     parameter core8_pf3_virtio_cmn_config_structure_length_hwtcl                    = 0,
     parameter core8_pf3_virtio_notification_bar_indicator_hwtcl                     = 0,
     parameter core8_pf3_virtio_notification_bar_offset_hwtcl                        = 0,
     parameter core8_pf3_virtio_notification_structure_length_hwtcl                  = 0,
     parameter core8_pf3_virtio_notify_off_multiplier_hwtcl                          = 0,
     parameter core8_pf3_virtio_isrstatus_bar_indicator_hwtcl                        = 0,
     parameter core8_pf3_virtio_isrstatus_bar_offset_hwtcl                           = 0,
     parameter core8_pf3_virtio_isrstatus_structure_length_hwtcl                     = 0,
     parameter core8_pf3_virtio_devspecific_bar_indicator_hwtcl                      = 0,
     parameter core8_pf3_virtio_devspecific_bar_offset_hwtcl                         = 0,
     parameter core8_pf3_virtio_devspecific_structure_length_hwtcl                   = 0,
     parameter core8_pf3_virtio_pciconfig_access_bar_indicator_hwtcl                 = 0,
     parameter core8_pf3_virtio_pciconfig_access_bar_offset_hwtcl                    = 0,
     parameter core8_pf3_virtio_pciconfig_access_structure_length_hwtcl              = 0,
     parameter core8_pf4_virtio_capability_present_hwtcl                             = 0,
     parameter core8_pf4_virtio_device_specific_cap_present_hwtcl                    = 0,
     parameter core8_pf4_virtio_cmn_config_bar_indicator_hwtcl                       = 0,
     parameter core8_pf4_virtio_cmn_config_bar_offset_hwtcl                          = 0,
     parameter core8_pf4_virtio_cmn_config_structure_length_hwtcl                    = 0,
     parameter core8_pf4_virtio_notification_bar_indicator_hwtcl                     = 0,
     parameter core8_pf4_virtio_notification_bar_offset_hwtcl                        = 0,
     parameter core8_pf4_virtio_notification_structure_length_hwtcl                  = 0,
     parameter core8_pf4_virtio_notify_off_multiplier_hwtcl                          = 0,
     parameter core8_pf4_virtio_isrstatus_bar_indicator_hwtcl                        = 0,
     parameter core8_pf4_virtio_isrstatus_bar_offset_hwtcl                           = 0,
     parameter core8_pf4_virtio_isrstatus_structure_length_hwtcl                     = 0,
     parameter core8_pf4_virtio_devspecific_bar_indicator_hwtcl                      = 0,
     parameter core8_pf4_virtio_devspecific_bar_offset_hwtcl                         = 0,
     parameter core8_pf4_virtio_devspecific_structure_length_hwtcl                   = 0,
     parameter core8_pf4_virtio_pciconfig_access_bar_indicator_hwtcl                 = 0,
     parameter core8_pf4_virtio_pciconfig_access_bar_offset_hwtcl                    = 0,
     parameter core8_pf4_virtio_pciconfig_access_structure_length_hwtcl              = 0,
     parameter core8_pf5_virtio_capability_present_hwtcl                             = 0,
     parameter core8_pf5_virtio_device_specific_cap_present_hwtcl                    = 0,
     parameter core8_pf5_virtio_cmn_config_bar_indicator_hwtcl                       = 0,
     parameter core8_pf5_virtio_cmn_config_bar_offset_hwtcl                          = 0,
     parameter core8_pf5_virtio_cmn_config_structure_length_hwtcl                    = 0,
     parameter core8_pf5_virtio_notification_bar_indicator_hwtcl                     = 0,
     parameter core8_pf5_virtio_notification_bar_offset_hwtcl                        = 0,
     parameter core8_pf5_virtio_notification_structure_length_hwtcl                  = 0,
     parameter core8_pf5_virtio_notify_off_multiplier_hwtcl                          = 0,
     parameter core8_pf5_virtio_isrstatus_bar_indicator_hwtcl                        = 0,
     parameter core8_pf5_virtio_isrstatus_bar_offset_hwtcl                           = 0,
     parameter core8_pf5_virtio_isrstatus_structure_length_hwtcl                     = 0,
     parameter core8_pf5_virtio_devspecific_bar_indicator_hwtcl                      = 0,
     parameter core8_pf5_virtio_devspecific_bar_offset_hwtcl                         = 0,
     parameter core8_pf5_virtio_devspecific_structure_length_hwtcl                   = 0,
     parameter core8_pf5_virtio_pciconfig_access_bar_indicator_hwtcl                 = 0,
     parameter core8_pf5_virtio_pciconfig_access_bar_offset_hwtcl                    = 0,
     parameter core8_pf5_virtio_pciconfig_access_structure_length_hwtcl              = 0,
     parameter core8_pf6_virtio_capability_present_hwtcl                             = 0,
     parameter core8_pf6_virtio_device_specific_cap_present_hwtcl                    = 0,
     parameter core8_pf6_virtio_cmn_config_bar_indicator_hwtcl                       = 0,
     parameter core8_pf6_virtio_cmn_config_bar_offset_hwtcl                          = 0,
     parameter core8_pf6_virtio_cmn_config_structure_length_hwtcl                    = 0,
     parameter core8_pf6_virtio_notification_bar_indicator_hwtcl                     = 0,
     parameter core8_pf6_virtio_notification_bar_offset_hwtcl                        = 0,
     parameter core8_pf6_virtio_notification_structure_length_hwtcl                  = 0,
     parameter core8_pf6_virtio_notify_off_multiplier_hwtcl                          = 0,
     parameter core8_pf6_virtio_isrstatus_bar_indicator_hwtcl                        = 0,
     parameter core8_pf6_virtio_isrstatus_bar_offset_hwtcl                           = 0,
     parameter core8_pf6_virtio_isrstatus_structure_length_hwtcl                     = 0,
     parameter core8_pf6_virtio_devspecific_bar_indicator_hwtcl                      = 0,
     parameter core8_pf6_virtio_devspecific_bar_offset_hwtcl                         = 0,
     parameter core8_pf6_virtio_devspecific_structure_length_hwtcl                   = 0,
     parameter core8_pf6_virtio_pciconfig_access_bar_indicator_hwtcl                 = 0,
     parameter core8_pf6_virtio_pciconfig_access_bar_offset_hwtcl                    = 0,
     parameter core8_pf6_virtio_pciconfig_access_structure_length_hwtcl              = 0,
     parameter core8_pf7_virtio_capability_present_hwtcl                             = 0,
     parameter core8_pf7_virtio_device_specific_cap_present_hwtcl                    = 0,
     parameter core8_pf7_virtio_cmn_config_bar_indicator_hwtcl                       = 0,
     parameter core8_pf7_virtio_cmn_config_bar_offset_hwtcl                          = 0,
     parameter core8_pf7_virtio_cmn_config_structure_length_hwtcl                    = 0,
     parameter core8_pf7_virtio_notification_bar_indicator_hwtcl                     = 0,
     parameter core8_pf7_virtio_notification_bar_offset_hwtcl                        = 0,
     parameter core8_pf7_virtio_notification_structure_length_hwtcl                  = 0,
     parameter core8_pf7_virtio_notify_off_multiplier_hwtcl                          = 0,
     parameter core8_pf7_virtio_isrstatus_bar_indicator_hwtcl                        = 0,
     parameter core8_pf7_virtio_isrstatus_bar_offset_hwtcl                           = 0,
     parameter core8_pf7_virtio_isrstatus_structure_length_hwtcl                     = 0,
     parameter core8_pf7_virtio_devspecific_bar_indicator_hwtcl                      = 0,
     parameter core8_pf7_virtio_devspecific_bar_offset_hwtcl                         = 0,
     parameter core8_pf7_virtio_devspecific_structure_length_hwtcl                   = 0,
     parameter core8_pf7_virtio_pciconfig_access_bar_indicator_hwtcl                 = 0,
     parameter core8_pf7_virtio_pciconfig_access_bar_offset_hwtcl                    = 0,
     parameter core8_pf7_virtio_pciconfig_access_structure_length_hwtcl              = 0,
     parameter core8_pf0vf_virtio_capability_present_hwtcl                           = 0,
     parameter core8_pf0vf_virtio_device_specific_cap_present_hwtcl                  = 0,
     parameter core8_pf0vf_virtio_cmn_config_bar_indicator_hwtcl                     = 0,
     parameter core8_pf0vf_virtio_cmn_config_bar_offset_hwtcl                        = 0,
     parameter core8_pf0vf_virtio_cmn_config_structure_length_hwtcl                  = 0,
     parameter core8_pf0vf_virtio_notification_bar_indicator_hwtcl                   = 0,
     parameter core8_pf0vf_virtio_notification_bar_offset_hwtcl                      = 0,
     parameter core8_pf0vf_virtio_notification_structure_length_hwtcl                = 0,
     parameter core8_pf0vf_virtio_notify_off_multiplier_hwtcl                        = 0,
     parameter core8_pf0vf_virtio_isrstatus_bar_indicator_hwtcl                      = 0,
     parameter core8_pf0vf_virtio_isrstatus_bar_offset_hwtcl                         = 0,
     parameter core8_pf0vf_virtio_isrstatus_structure_length_hwtcl                   = 0,
     parameter core8_pf0vf_virtio_devspecific_bar_indicator_hwtcl                    = 0,
     parameter core8_pf0vf_virtio_devspecific_bar_offset_hwtcl                       = 0,
     parameter core8_pf0vf_virtio_devspecific_structure_length_hwtcl                 = 0,
     parameter core8_pf0vf_virtio_pciconfig_access_bar_indicator_hwtcl               = 0,
     parameter core8_pf0vf_virtio_pciconfig_access_bar_offset_hwtcl                  = 0,
     parameter core8_pf0vf_virtio_pciconfig_access_structure_length_hwtcl            = 0,
     parameter core8_pf1vf_virtio_capability_present_hwtcl                           = 0,
     parameter core8_pf1vf_virtio_device_specific_cap_present_hwtcl                  = 0,
     parameter core8_pf1vf_virtio_cmn_config_bar_indicator_hwtcl                     = 0,
     parameter core8_pf1vf_virtio_cmn_config_bar_offset_hwtcl                        = 0,
     parameter core8_pf1vf_virtio_cmn_config_structure_length_hwtcl                  = 0,
     parameter core8_pf1vf_virtio_notification_bar_indicator_hwtcl                   = 0,
     parameter core8_pf1vf_virtio_notification_bar_offset_hwtcl                      = 0,
     parameter core8_pf1vf_virtio_notification_structure_length_hwtcl                = 0,
     parameter core8_pf1vf_virtio_notify_off_multiplier_hwtcl                        = 0,
     parameter core8_pf1vf_virtio_isrstatus_bar_indicator_hwtcl                      = 0,
     parameter core8_pf1vf_virtio_isrstatus_bar_offset_hwtcl                         = 0,
     parameter core8_pf1vf_virtio_isrstatus_structure_length_hwtcl                   = 0,
     parameter core8_pf1vf_virtio_devspecific_bar_indicator_hwtcl                    = 0,
     parameter core8_pf1vf_virtio_devspecific_bar_offset_hwtcl                       = 0,
     parameter core8_pf1vf_virtio_devspecific_structure_length_hwtcl                 = 0,
     parameter core8_pf1vf_virtio_pciconfig_access_bar_indicator_hwtcl               = 0,
     parameter core8_pf1vf_virtio_pciconfig_access_bar_offset_hwtcl                  = 0,
     parameter core8_pf1vf_virtio_pciconfig_access_structure_length_hwtcl            = 0,
     parameter core8_pf2vf_virtio_capability_present_hwtcl                           = 0,
     parameter core8_pf2vf_virtio_device_specific_cap_present_hwtcl                  = 0,
     parameter core8_pf2vf_virtio_cmn_config_bar_indicator_hwtcl                     = 0,
     parameter core8_pf2vf_virtio_cmn_config_bar_offset_hwtcl                        = 0,
     parameter core8_pf2vf_virtio_cmn_config_structure_length_hwtcl                  = 0,
     parameter core8_pf2vf_virtio_notification_bar_indicator_hwtcl                   = 0,
     parameter core8_pf2vf_virtio_notification_bar_offset_hwtcl                      = 0,
     parameter core8_pf2vf_virtio_notification_structure_length_hwtcl                = 0,
     parameter core8_pf2vf_virtio_notify_off_multiplier_hwtcl                        = 0,
     parameter core8_pf2vf_virtio_isrstatus_bar_indicator_hwtcl                      = 0,
     parameter core8_pf2vf_virtio_isrstatus_bar_offset_hwtcl                         = 0,
     parameter core8_pf2vf_virtio_isrstatus_structure_length_hwtcl                   = 0,
     parameter core8_pf2vf_virtio_devspecific_bar_indicator_hwtcl                    = 0,
     parameter core8_pf2vf_virtio_devspecific_bar_offset_hwtcl                       = 0,
     parameter core8_pf2vf_virtio_devspecific_structure_length_hwtcl                 = 0,
     parameter core8_pf2vf_virtio_pciconfig_access_bar_indicator_hwtcl               = 0,
     parameter core8_pf2vf_virtio_pciconfig_access_bar_offset_hwtcl                  = 0,
     parameter core8_pf2vf_virtio_pciconfig_access_structure_length_hwtcl            = 0,
     parameter core8_pf3vf_virtio_capability_present_hwtcl                           = 0,
     parameter core8_pf3vf_virtio_device_specific_cap_present_hwtcl                  = 0,
     parameter core8_pf3vf_virtio_cmn_config_bar_indicator_hwtcl                     = 0,
     parameter core8_pf3vf_virtio_cmn_config_bar_offset_hwtcl                        = 0,
     parameter core8_pf3vf_virtio_cmn_config_structure_length_hwtcl                  = 0,
     parameter core8_pf3vf_virtio_notification_bar_indicator_hwtcl                   = 0,
     parameter core8_pf3vf_virtio_notification_bar_offset_hwtcl                      = 0,
     parameter core8_pf3vf_virtio_notification_structure_length_hwtcl                = 0,
     parameter core8_pf3vf_virtio_notify_off_multiplier_hwtcl                        = 0,
     parameter core8_pf3vf_virtio_isrstatus_bar_indicator_hwtcl                      = 0,
     parameter core8_pf3vf_virtio_isrstatus_bar_offset_hwtcl                         = 0,
     parameter core8_pf3vf_virtio_isrstatus_structure_length_hwtcl                   = 0,
     parameter core8_pf3vf_virtio_devspecific_bar_indicator_hwtcl                    = 0,
     parameter core8_pf3vf_virtio_devspecific_bar_offset_hwtcl                       = 0,
     parameter core8_pf3vf_virtio_devspecific_structure_length_hwtcl                 = 0,
     parameter core8_pf3vf_virtio_pciconfig_access_bar_indicator_hwtcl               = 0,
     parameter core8_pf3vf_virtio_pciconfig_access_bar_offset_hwtcl                  = 0,
     parameter core8_pf3vf_virtio_pciconfig_access_structure_length_hwtcl            = 0,
     parameter core8_pf4vf_virtio_capability_present_hwtcl                           = 0,
     parameter core8_pf4vf_virtio_device_specific_cap_present_hwtcl                  = 0,
     parameter core8_pf4vf_virtio_cmn_config_bar_indicator_hwtcl                     = 0,
     parameter core8_pf4vf_virtio_cmn_config_bar_offset_hwtcl                        = 0,
     parameter core8_pf4vf_virtio_cmn_config_structure_length_hwtcl                  = 0,
     parameter core8_pf4vf_virtio_notification_bar_indicator_hwtcl                   = 0,
     parameter core8_pf4vf_virtio_notification_bar_offset_hwtcl                      = 0,
     parameter core8_pf4vf_virtio_notification_structure_length_hwtcl                = 0,
     parameter core8_pf4vf_virtio_notify_off_multiplier_hwtcl                        = 0,
     parameter core8_pf4vf_virtio_isrstatus_bar_indicator_hwtcl                      = 0,
     parameter core8_pf4vf_virtio_isrstatus_bar_offset_hwtcl                         = 0,
     parameter core8_pf4vf_virtio_isrstatus_structure_length_hwtcl                   = 0,
     parameter core8_pf4vf_virtio_devspecific_bar_indicator_hwtcl                    = 0,
     parameter core8_pf4vf_virtio_devspecific_bar_offset_hwtcl                       = 0,
     parameter core8_pf4vf_virtio_devspecific_structure_length_hwtcl                 = 0,
     parameter core8_pf4vf_virtio_pciconfig_access_bar_indicator_hwtcl               = 0,
     parameter core8_pf4vf_virtio_pciconfig_access_bar_offset_hwtcl                  = 0,
     parameter core8_pf4vf_virtio_pciconfig_access_structure_length_hwtcl            = 0,
     parameter core8_pf5vf_virtio_capability_present_hwtcl                           = 0,
     parameter core8_pf5vf_virtio_device_specific_cap_present_hwtcl                  = 0,
     parameter core8_pf5vf_virtio_cmn_config_bar_indicator_hwtcl                     = 0,
     parameter core8_pf5vf_virtio_cmn_config_bar_offset_hwtcl                        = 0,
     parameter core8_pf5vf_virtio_cmn_config_structure_length_hwtcl                  = 0,
     parameter core8_pf5vf_virtio_notification_bar_indicator_hwtcl                   = 0,
     parameter core8_pf5vf_virtio_notification_bar_offset_hwtcl                      = 0,
     parameter core8_pf5vf_virtio_notification_structure_length_hwtcl                = 0,
     parameter core8_pf5vf_virtio_notify_off_multiplier_hwtcl                        = 0,
     parameter core8_pf5vf_virtio_isrstatus_bar_indicator_hwtcl                      = 0,
     parameter core8_pf5vf_virtio_isrstatus_bar_offset_hwtcl                         = 0,
     parameter core8_pf5vf_virtio_isrstatus_structure_length_hwtcl                   = 0,
     parameter core8_pf5vf_virtio_devspecific_bar_indicator_hwtcl                    = 0,
     parameter core8_pf5vf_virtio_devspecific_bar_offset_hwtcl                       = 0,
     parameter core8_pf5vf_virtio_devspecific_structure_length_hwtcl                 = 0,
     parameter core8_pf5vf_virtio_pciconfig_access_bar_indicator_hwtcl               = 0,
     parameter core8_pf5vf_virtio_pciconfig_access_bar_offset_hwtcl                  = 0,
     parameter core8_pf5vf_virtio_pciconfig_access_structure_length_hwtcl            = 0,
     parameter core8_pf6vf_virtio_capability_present_hwtcl                           = 0,
     parameter core8_pf6vf_virtio_device_specific_cap_present_hwtcl                  = 0,
     parameter core8_pf6vf_virtio_cmn_config_bar_indicator_hwtcl                     = 0,
     parameter core8_pf6vf_virtio_cmn_config_bar_offset_hwtcl                        = 0,
     parameter core8_pf6vf_virtio_cmn_config_structure_length_hwtcl                  = 0,
     parameter core8_pf6vf_virtio_notification_bar_indicator_hwtcl                   = 0,
     parameter core8_pf6vf_virtio_notification_bar_offset_hwtcl                      = 0,
     parameter core8_pf6vf_virtio_notification_structure_length_hwtcl                = 0,
     parameter core8_pf6vf_virtio_notify_off_multiplier_hwtcl                        = 0,
     parameter core8_pf6vf_virtio_isrstatus_bar_indicator_hwtcl                      = 0,
     parameter core8_pf6vf_virtio_isrstatus_bar_offset_hwtcl                         = 0,
     parameter core8_pf6vf_virtio_isrstatus_structure_length_hwtcl                   = 0,
     parameter core8_pf6vf_virtio_devspecific_bar_indicator_hwtcl                    = 0,
     parameter core8_pf6vf_virtio_devspecific_bar_offset_hwtcl                       = 0,
     parameter core8_pf6vf_virtio_devspecific_structure_length_hwtcl                 = 0,
     parameter core8_pf6vf_virtio_pciconfig_access_bar_indicator_hwtcl               = 0,
     parameter core8_pf6vf_virtio_pciconfig_access_bar_offset_hwtcl                  = 0,
     parameter core8_pf6vf_virtio_pciconfig_access_structure_length_hwtcl            = 0,
     parameter core8_pf7vf_virtio_capability_present_hwtcl                           = 0,
     parameter core8_pf7vf_virtio_device_specific_cap_present_hwtcl                  = 0,
     parameter core8_pf7vf_virtio_cmn_config_bar_indicator_hwtcl                     = 0,
     parameter core8_pf7vf_virtio_cmn_config_bar_offset_hwtcl                        = 0,
     parameter core8_pf7vf_virtio_cmn_config_structure_length_hwtcl                  = 0,
     parameter core8_pf7vf_virtio_notification_bar_indicator_hwtcl                   = 0,
     parameter core8_pf7vf_virtio_notification_bar_offset_hwtcl                      = 0,
     parameter core8_pf7vf_virtio_notification_structure_length_hwtcl                = 0,
     parameter core8_pf7vf_virtio_notify_off_multiplier_hwtcl                        = 0,
     parameter core8_pf7vf_virtio_isrstatus_bar_indicator_hwtcl                      = 0,
     parameter core8_pf7vf_virtio_isrstatus_bar_offset_hwtcl                         = 0,
     parameter core8_pf7vf_virtio_isrstatus_structure_length_hwtcl                   = 0,
     parameter core8_pf7vf_virtio_devspecific_bar_indicator_hwtcl                    = 0,
     parameter core8_pf7vf_virtio_devspecific_bar_offset_hwtcl                       = 0,
     parameter core8_pf7vf_virtio_devspecific_structure_length_hwtcl                 = 0,
     parameter core8_pf7vf_virtio_pciconfig_access_bar_indicator_hwtcl               = 0,
     parameter core8_pf7vf_virtio_pciconfig_access_bar_offset_hwtcl                  = 0,
     parameter core8_pf7vf_virtio_pciconfig_access_structure_length_hwtcl            = 0,

     parameter core16_pf0_vf_count_hwtcl                                             = 0,
     parameter core16_pf1_vf_count_hwtcl                                             = 0,
     parameter core16_pf2_vf_count_hwtcl                                             = 0,
     parameter core16_pf3_vf_count_hwtcl                                             = 0,
     parameter core16_pf4_vf_count_hwtcl                                             = 0,
     parameter core16_pf5_vf_count_hwtcl                                             = 0,
     parameter core16_pf6_vf_count_hwtcl                                             = 0,
     parameter core16_pf7_vf_count_hwtcl                                             = 0,
     parameter core8_pf0_vf_count_hwtcl                                              = 0,
     parameter core8_pf1_vf_count_hwtcl                                              = 0,
     parameter core8_pf2_vf_count_hwtcl                                              = 0,
     parameter core8_pf3_vf_count_hwtcl                                              = 0,
     parameter core8_pf4_vf_count_hwtcl                                              = 0,
     parameter core8_pf5_vf_count_hwtcl                                              = 0,
     parameter core8_pf6_vf_count_hwtcl                                              = 0,
     parameter core8_pf7_vf_count_hwtcl                                              = 0,

     // error interface enable
     parameter  core16_enable_error_intf_hwtcl                                       = 0,
     parameter  core8_enable_error_intf_hwtcl                                        = 0,
     parameter  core4_0_enable_error_intf_hwtcl                                      = 0,
     parameter  core4_1_enable_error_intf_hwtcl                                      = 0,

     // HIP_TOP params - core16
     parameter core16_pf0_bar0_address_width_hwtcl                                   = 16,
     parameter core16_pf0_bar1_address_width_hwtcl                                   = 16,
     parameter core16_pf0_bar2_address_width_hwtcl                                   = 16,
     parameter core16_pf0_bar3_address_width_hwtcl                                   = 16,
     parameter core16_pf0_bar4_address_width_hwtcl                                   = 16,
     parameter core16_pf0_bar5_address_width_hwtcl                                   = 16,
     parameter core16_pf1_bar0_address_width_hwtcl                                   = 16,
     parameter core16_pf1_bar1_address_width_hwtcl                                   = 16,
     parameter core16_pf1_bar2_address_width_hwtcl                                   = 16,
     parameter core16_pf1_bar3_address_width_hwtcl                                   = 16,
     parameter core16_pf1_bar4_address_width_hwtcl                                   = 16,
     parameter core16_pf1_bar5_address_width_hwtcl                                   = 16,
     parameter core16_pf2_bar0_address_width_hwtcl                                   = 16,
     parameter core16_pf2_bar1_address_width_hwtcl                                   = 16,
     parameter core16_pf2_bar2_address_width_hwtcl                                   = 16,
     parameter core16_pf2_bar3_address_width_hwtcl                                   = 16,
     parameter core16_pf2_bar4_address_width_hwtcl                                   = 16,
     parameter core16_pf2_bar5_address_width_hwtcl                                   = 16,
     parameter core16_pf3_bar0_address_width_hwtcl                                   = 16,
     parameter core16_pf3_bar1_address_width_hwtcl                                   = 16,
     parameter core16_pf3_bar2_address_width_hwtcl                                   = 16,
     parameter core16_pf3_bar3_address_width_hwtcl                                   = 16,
     parameter core16_pf3_bar4_address_width_hwtcl                                   = 16,
     parameter core16_pf3_bar5_address_width_hwtcl                                   = 16,
     parameter core16_pf4_bar0_address_width_hwtcl                                   = 16,
     parameter core16_pf4_bar1_address_width_hwtcl                                   = 16,
     parameter core16_pf4_bar2_address_width_hwtcl                                   = 16,
     parameter core16_pf4_bar3_address_width_hwtcl                                   = 16,
     parameter core16_pf4_bar4_address_width_hwtcl                                   = 16,
     parameter core16_pf4_bar5_address_width_hwtcl                                   = 16,
     parameter core16_pf5_bar0_address_width_hwtcl                                   = 16,
     parameter core16_pf5_bar1_address_width_hwtcl                                   = 16,
     parameter core16_pf5_bar2_address_width_hwtcl                                   = 16,
     parameter core16_pf5_bar3_address_width_hwtcl                                   = 16,
     parameter core16_pf5_bar4_address_width_hwtcl                                   = 16,
     parameter core16_pf5_bar5_address_width_hwtcl                                   = 16,
     parameter core16_pf6_bar0_address_width_hwtcl                                   = 16,
     parameter core16_pf6_bar1_address_width_hwtcl                                   = 16,
     parameter core16_pf6_bar2_address_width_hwtcl                                   = 16,
     parameter core16_pf6_bar3_address_width_hwtcl                                   = 16,
     parameter core16_pf6_bar4_address_width_hwtcl                                   = 16,
     parameter core16_pf6_bar5_address_width_hwtcl                                   = 16,
     parameter core16_pf7_bar0_address_width_hwtcl                                   = 16,
     parameter core16_pf7_bar1_address_width_hwtcl                                   = 16,
     parameter core16_pf7_bar2_address_width_hwtcl                                   = 16,
     parameter core16_pf7_bar3_address_width_hwtcl                                   = 16,
     parameter core16_pf7_bar4_address_width_hwtcl                                   = 16,
     parameter core16_pf7_bar5_address_width_hwtcl                                   = 16,

     parameter core16_pf0_expansion_base_address_register_integer_hwtcl              = 0,
     parameter core16_pf1_expansion_base_address_register_integer_hwtcl              = 0,
     parameter core16_pf2_expansion_base_address_register_integer_hwtcl              = 0,
     parameter core16_pf3_expansion_base_address_register_integer_hwtcl              = 0,
     parameter core16_pf4_expansion_base_address_register_integer_hwtcl              = 0,
     parameter core16_pf5_expansion_base_address_register_integer_hwtcl              = 0,
     parameter core16_pf6_expansion_base_address_register_integer_hwtcl              = 0,
     parameter core16_pf7_expansion_base_address_register_integer_hwtcl              = 0,

     parameter core16_pf0_sriov_vf_bar0_address_width_int_hwtcl                  = 16,
     parameter core16_pf0_sriov_vf_bar1_address_width_int_hwtcl                  = 16,
     parameter core16_pf0_sriov_vf_bar2_address_width_int_hwtcl                  = 16,
     parameter core16_pf0_sriov_vf_bar3_address_width_int_hwtcl                  = 16,
     parameter core16_pf0_sriov_vf_bar4_address_width_int_hwtcl                  = 16,
     parameter core16_pf0_sriov_vf_bar5_address_width_int_hwtcl                  = 16,
     parameter core16_pf1_sriov_vf_bar0_address_width_int_hwtcl                  = 16,
     parameter core16_pf1_sriov_vf_bar1_address_width_int_hwtcl                  = 16,
     parameter core16_pf1_sriov_vf_bar2_address_width_int_hwtcl                  = 16,
     parameter core16_pf1_sriov_vf_bar3_address_width_int_hwtcl                  = 16,
     parameter core16_pf1_sriov_vf_bar4_address_width_int_hwtcl                  = 16,
     parameter core16_pf1_sriov_vf_bar5_address_width_int_hwtcl                  = 16,
     parameter core16_pf2_sriov_vf_bar0_address_width_int_hwtcl                  = 16,
     parameter core16_pf2_sriov_vf_bar1_address_width_int_hwtcl                  = 16,
     parameter core16_pf2_sriov_vf_bar2_address_width_int_hwtcl                  = 16,
     parameter core16_pf2_sriov_vf_bar3_address_width_int_hwtcl                  = 16,
     parameter core16_pf2_sriov_vf_bar4_address_width_int_hwtcl                  = 16,
     parameter core16_pf2_sriov_vf_bar5_address_width_int_hwtcl                  = 16,
     parameter core16_pf3_sriov_vf_bar0_address_width_int_hwtcl                  = 16,
     parameter core16_pf3_sriov_vf_bar1_address_width_int_hwtcl                  = 16,
     parameter core16_pf3_sriov_vf_bar2_address_width_int_hwtcl                  = 16,
     parameter core16_pf3_sriov_vf_bar3_address_width_int_hwtcl                  = 16,
     parameter core16_pf3_sriov_vf_bar4_address_width_int_hwtcl                  = 16,
     parameter core16_pf3_sriov_vf_bar5_address_width_int_hwtcl                  = 16,
     parameter core16_pf4_sriov_vf_bar0_address_width_int_hwtcl                  = 16,
     parameter core16_pf4_sriov_vf_bar1_address_width_int_hwtcl                  = 16,
     parameter core16_pf4_sriov_vf_bar2_address_width_int_hwtcl                  = 16,
     parameter core16_pf4_sriov_vf_bar3_address_width_int_hwtcl                  = 16,
     parameter core16_pf4_sriov_vf_bar4_address_width_int_hwtcl                  = 16,
     parameter core16_pf4_sriov_vf_bar5_address_width_int_hwtcl                  = 16,
     parameter core16_pf5_sriov_vf_bar0_address_width_int_hwtcl                  = 16,
     parameter core16_pf5_sriov_vf_bar1_address_width_int_hwtcl                  = 16,
     parameter core16_pf5_sriov_vf_bar2_address_width_int_hwtcl                  = 16,
     parameter core16_pf5_sriov_vf_bar3_address_width_int_hwtcl                  = 16,
     parameter core16_pf5_sriov_vf_bar4_address_width_int_hwtcl                  = 16,
     parameter core16_pf5_sriov_vf_bar5_address_width_int_hwtcl                  = 16,
     parameter core16_pf6_sriov_vf_bar0_address_width_int_hwtcl                  = 16,
     parameter core16_pf6_sriov_vf_bar1_address_width_int_hwtcl                  = 16,
     parameter core16_pf6_sriov_vf_bar2_address_width_int_hwtcl                  = 16,
     parameter core16_pf6_sriov_vf_bar3_address_width_int_hwtcl                  = 16,
     parameter core16_pf6_sriov_vf_bar4_address_width_int_hwtcl                  = 16,
     parameter core16_pf6_sriov_vf_bar5_address_width_int_hwtcl                  = 16,
     parameter core16_pf7_sriov_vf_bar0_address_width_int_hwtcl                  = 16,
     parameter core16_pf7_sriov_vf_bar1_address_width_int_hwtcl                  = 16,
     parameter core16_pf7_sriov_vf_bar2_address_width_int_hwtcl                  = 16,
     parameter core16_pf7_sriov_vf_bar3_address_width_int_hwtcl                  = 16,
     parameter core16_pf7_sriov_vf_bar4_address_width_int_hwtcl                  = 16,
     parameter core16_pf7_sriov_vf_bar5_address_width_int_hwtcl                  = 16,

     // HIP_TOP params - core8
     parameter core8_pf0_bar0_address_width_hwtcl                                    = 16,
     parameter core8_pf0_bar1_address_width_hwtcl                                    = 16,
     parameter core8_pf0_bar2_address_width_hwtcl                                    = 16,
     parameter core8_pf0_bar3_address_width_hwtcl                                    = 16,
     parameter core8_pf0_bar4_address_width_hwtcl                                    = 16,
     parameter core8_pf0_bar5_address_width_hwtcl                                    = 16,
     parameter core8_pf1_bar0_address_width_hwtcl                                    = 16,
     parameter core8_pf1_bar1_address_width_hwtcl                                    = 16,
     parameter core8_pf1_bar2_address_width_hwtcl                                    = 16,
     parameter core8_pf1_bar3_address_width_hwtcl                                    = 16,
     parameter core8_pf1_bar4_address_width_hwtcl                                    = 16,
     parameter core8_pf1_bar5_address_width_hwtcl                                    = 16,
     parameter core8_pf2_bar0_address_width_hwtcl                                    = 16,
     parameter core8_pf2_bar1_address_width_hwtcl                                    = 16,
     parameter core8_pf2_bar2_address_width_hwtcl                                    = 16,
     parameter core8_pf2_bar3_address_width_hwtcl                                    = 16,
     parameter core8_pf2_bar4_address_width_hwtcl                                    = 16,
     parameter core8_pf2_bar5_address_width_hwtcl                                    = 16,
     parameter core8_pf3_bar0_address_width_hwtcl                                    = 16,
     parameter core8_pf3_bar1_address_width_hwtcl                                    = 16,
     parameter core8_pf3_bar2_address_width_hwtcl                                    = 16,
     parameter core8_pf3_bar3_address_width_hwtcl                                    = 16,
     parameter core8_pf3_bar4_address_width_hwtcl                                    = 16,
     parameter core8_pf3_bar5_address_width_hwtcl                                    = 16,
     parameter core8_pf4_bar0_address_width_hwtcl                                    = 16,
     parameter core8_pf4_bar1_address_width_hwtcl                                    = 16,
     parameter core8_pf4_bar2_address_width_hwtcl                                    = 16,
     parameter core8_pf4_bar3_address_width_hwtcl                                    = 16,
     parameter core8_pf4_bar4_address_width_hwtcl                                    = 16,
     parameter core8_pf4_bar5_address_width_hwtcl                                    = 16,
     parameter core8_pf5_bar0_address_width_hwtcl                                    = 16,
     parameter core8_pf5_bar1_address_width_hwtcl                                    = 16,
     parameter core8_pf5_bar2_address_width_hwtcl                                    = 16,
     parameter core8_pf5_bar3_address_width_hwtcl                                    = 16,
     parameter core8_pf5_bar4_address_width_hwtcl                                    = 16,
     parameter core8_pf5_bar5_address_width_hwtcl                                    = 16,
     parameter core8_pf6_bar0_address_width_hwtcl                                    = 16,
     parameter core8_pf6_bar1_address_width_hwtcl                                    = 16,
     parameter core8_pf6_bar2_address_width_hwtcl                                    = 16,
     parameter core8_pf6_bar3_address_width_hwtcl                                    = 16,
     parameter core8_pf6_bar4_address_width_hwtcl                                    = 16,
     parameter core8_pf6_bar5_address_width_hwtcl                                    = 16,
     parameter core8_pf7_bar0_address_width_hwtcl                                    = 16,
     parameter core8_pf7_bar1_address_width_hwtcl                                    = 16,
     parameter core8_pf7_bar2_address_width_hwtcl                                    = 16,
     parameter core8_pf7_bar3_address_width_hwtcl                                    = 16,
     parameter core8_pf7_bar4_address_width_hwtcl                                    = 16,
     parameter core8_pf7_bar5_address_width_hwtcl                                    = 16,

     parameter core8_pf0_expansion_base_address_register_integer_hwtcl               = 0,
     parameter core8_pf1_expansion_base_address_register_integer_hwtcl               = 0,
     parameter core8_pf2_expansion_base_address_register_integer_hwtcl               = 0,
     parameter core8_pf3_expansion_base_address_register_integer_hwtcl               = 0,
     parameter core8_pf4_expansion_base_address_register_integer_hwtcl               = 0,
     parameter core8_pf5_expansion_base_address_register_integer_hwtcl               = 0,
     parameter core8_pf6_expansion_base_address_register_integer_hwtcl               = 0,
     parameter core8_pf7_expansion_base_address_register_integer_hwtcl               = 0,

     parameter core8_pf0_sriov_vf_bar0_address_width_int_hwtcl                   = 16,
     parameter core8_pf0_sriov_vf_bar1_address_width_int_hwtcl                   = 16,
     parameter core8_pf0_sriov_vf_bar2_address_width_int_hwtcl                   = 16,
     parameter core8_pf0_sriov_vf_bar3_address_width_int_hwtcl                   = 16,
     parameter core8_pf0_sriov_vf_bar4_address_width_int_hwtcl                   = 16,
     parameter core8_pf0_sriov_vf_bar5_address_width_int_hwtcl                   = 16,
     parameter core8_pf1_sriov_vf_bar0_address_width_int_hwtcl                   = 16,
     parameter core8_pf1_sriov_vf_bar1_address_width_int_hwtcl                   = 16,
     parameter core8_pf1_sriov_vf_bar2_address_width_int_hwtcl                   = 16,
     parameter core8_pf1_sriov_vf_bar3_address_width_int_hwtcl                   = 16,
     parameter core8_pf1_sriov_vf_bar4_address_width_int_hwtcl                   = 16,
     parameter core8_pf1_sriov_vf_bar5_address_width_int_hwtcl                   = 16,
     parameter core8_pf2_sriov_vf_bar0_address_width_int_hwtcl                   = 16,
     parameter core8_pf2_sriov_vf_bar1_address_width_int_hwtcl                   = 16,
     parameter core8_pf2_sriov_vf_bar2_address_width_int_hwtcl                   = 16,
     parameter core8_pf2_sriov_vf_bar3_address_width_int_hwtcl                   = 16,
     parameter core8_pf2_sriov_vf_bar4_address_width_int_hwtcl                   = 16,
     parameter core8_pf2_sriov_vf_bar5_address_width_int_hwtcl                   = 16,
     parameter core8_pf3_sriov_vf_bar0_address_width_int_hwtcl                   = 16,
     parameter core8_pf3_sriov_vf_bar1_address_width_int_hwtcl                   = 16,
     parameter core8_pf3_sriov_vf_bar2_address_width_int_hwtcl                   = 16,
     parameter core8_pf3_sriov_vf_bar3_address_width_int_hwtcl                   = 16,
     parameter core8_pf3_sriov_vf_bar4_address_width_int_hwtcl                   = 16,
     parameter core8_pf3_sriov_vf_bar5_address_width_int_hwtcl                   = 16,
     parameter core8_pf4_sriov_vf_bar0_address_width_int_hwtcl                   = 16,
     parameter core8_pf4_sriov_vf_bar1_address_width_int_hwtcl                   = 16,
     parameter core8_pf4_sriov_vf_bar2_address_width_int_hwtcl                   = 16,
     parameter core8_pf4_sriov_vf_bar3_address_width_int_hwtcl                   = 16,
     parameter core8_pf4_sriov_vf_bar4_address_width_int_hwtcl                   = 16,
     parameter core8_pf4_sriov_vf_bar5_address_width_int_hwtcl                   = 16,
     parameter core8_pf5_sriov_vf_bar0_address_width_int_hwtcl                   = 16,
     parameter core8_pf5_sriov_vf_bar1_address_width_int_hwtcl                   = 16,
     parameter core8_pf5_sriov_vf_bar2_address_width_int_hwtcl                   = 16,
     parameter core8_pf5_sriov_vf_bar3_address_width_int_hwtcl                   = 16,
     parameter core8_pf5_sriov_vf_bar4_address_width_int_hwtcl                   = 16,
     parameter core8_pf5_sriov_vf_bar5_address_width_int_hwtcl                   = 16,
     parameter core8_pf6_sriov_vf_bar0_address_width_int_hwtcl                   = 16,
     parameter core8_pf6_sriov_vf_bar1_address_width_int_hwtcl                   = 16,
     parameter core8_pf6_sriov_vf_bar2_address_width_int_hwtcl                   = 16,
     parameter core8_pf6_sriov_vf_bar3_address_width_int_hwtcl                   = 16,
     parameter core8_pf6_sriov_vf_bar4_address_width_int_hwtcl                   = 16,
     parameter core8_pf6_sriov_vf_bar5_address_width_int_hwtcl                   = 16,
     parameter core8_pf7_sriov_vf_bar0_address_width_int_hwtcl                   = 16,
     parameter core8_pf7_sriov_vf_bar1_address_width_int_hwtcl                   = 16,
     parameter core8_pf7_sriov_vf_bar2_address_width_int_hwtcl                   = 16,
     parameter core8_pf7_sriov_vf_bar3_address_width_int_hwtcl                   = 16,
     parameter core8_pf7_sriov_vf_bar4_address_width_int_hwtcl                   = 16,
     parameter core8_pf7_sriov_vf_bar5_address_width_int_hwtcl                   = 16,

     // HIP_TOP params - core4_0
     parameter core4_0_pf0_bar0_address_width_hwtcl                              = 16,
     parameter core4_0_pf0_bar1_address_width_hwtcl                              = 16,
     parameter core4_0_pf0_bar2_address_width_hwtcl                              = 16,
     parameter core4_0_pf0_bar3_address_width_hwtcl                              = 16,
     parameter core4_0_pf0_bar4_address_width_hwtcl                              = 16,
     parameter core4_0_pf0_bar5_address_width_hwtcl                              = 16,

     // HIP_TOP params - core4_1
     parameter core4_1_pf0_bar0_address_width_hwtcl                              = 16,
     parameter core4_1_pf0_bar1_address_width_hwtcl                              = 16,
     parameter core4_1_pf0_bar2_address_width_hwtcl                              = 16,
     parameter core4_1_pf0_bar3_address_width_hwtcl                              = 16,
     parameter core4_1_pf0_bar4_address_width_hwtcl                              = 16,
     parameter core4_1_pf0_bar5_address_width_hwtcl                              = 16,

     //Preset
     parameter core16_pf0_dsp_16g_tx_preset_hwtcl                                    = 0,
     parameter core16_pf0_dsp_tx_preset_hwtcl                                        = 0,
     parameter core16_pf0_usp_16g_tx_preset_hwtcl                                    = 0,
     parameter core16_pf0_usp_tx_preset_hwtcl                                        = 0,
     parameter core16_pf0_dsp_rx_preset_hint_hwtcl                                   = 0,
     parameter core16_pf0_usp_rx_preset_hint_hwtcl                                   = 0,
  
     parameter core8_pf0_dsp_16g_tx_preset_hwtcl                                     = 0,
     parameter core8_pf0_dsp_tx_preset_hwtcl                                         = 0,
     parameter core8_pf0_usp_16g_tx_preset_hwtcl                                     = 0,
     parameter core8_pf0_usp_tx_preset_hwtcl                                         = 0,
     parameter core8_pf0_dsp_rx_preset_hint_hwtcl                                    = 0,
     parameter core8_pf0_usp_rx_preset_hint_hwtcl                                    = 0,
  
     parameter core4_0_pf0_dsp_16g_tx_preset_hwtcl                                   = 0,
     parameter core4_0_pf0_dsp_tx_preset_hwtcl                                       = 0,
     parameter core4_0_pf0_usp_16g_tx_preset_hwtcl                                   = 0,
     parameter core4_0_pf0_usp_tx_preset_hwtcl                                       = 0,
     parameter core4_0_pf0_dsp_rx_preset_hint_hwtcl                                  = 0,
     parameter core4_0_pf0_usp_rx_preset_hint_hwtcl                                  = 0,
  
     parameter core4_1_pf0_dsp_16g_tx_preset_hwtcl                                   = 0,
     parameter core4_1_pf0_dsp_tx_preset_hwtcl                                       = 0,
     parameter core4_1_pf0_usp_16g_tx_preset_hwtcl                                   = 0,
     parameter core4_1_pf0_usp_tx_preset_hwtcl                                       = 0,
     parameter core4_1_pf0_dsp_rx_preset_hint_hwtcl                                  = 0,
     parameter core4_1_pf0_usp_rx_preset_hint_hwtcl                                  = 0,

     parameter ftile_debug_toolkit_hwtcl                                             = 0, 
     parameter ftile_enable_pciess_register_access_hwtcl                             = 0, 
     parameter ftile_link_insp_en_hwtcl                                              = 0, 
     parameter ftile_link_insp_avmm_en_hwtcl                                         = 0,

     // user_mode_to_pld & pld_in_use ports enable
     parameter  core16_user_mode_to_pld_in_use_hwtcl                                 = 0,
     parameter  core8_user_mode_to_pld_in_use_hwtcl                                  = 0,
     parameter  core4_0_user_mode_to_pld_in_use_hwtcl                                = 0,
     parameter  core4_1_user_mode_to_pld_in_use_hwtcl                                = 0, 

     //sn cap
     parameter ctop_core16_sn_ser_num_reg_1_dw_hwtcl                                 = "0",
     parameter ctop_core16_sn_ser_num_reg_2_dw_hwtcl                                 = "0",
     parameter ctop_core4_0_sn_ser_num_reg_1_dw_hwtcl                                = "0",
     parameter ctop_core4_0_sn_ser_num_reg_2_dw_hwtcl                                = "0",
     parameter ctop_core4_1_sn_ser_num_reg_1_dw_hwtcl                                = "0",
     parameter ctop_core4_1_sn_ser_num_reg_2_dw_hwtcl                                = "0",
     parameter ctop_core8_sn_ser_num_reg_1_dw_hwtcl                                  = "0",
     parameter ctop_core8_sn_ser_num_reg_2_dw_hwtcl                                  = "0",


     // HIP_BB params
     parameter ctop_core16_virtual_pf0_sriov_num_vf_non_ari                          = 0,
     parameter ctop_core16_virtual_pf1_sriov_num_vf_non_ari                          = 0,
     parameter ctop_core16_virtual_pf2_sriov_num_vf_non_ari                          = 0,
     parameter ctop_core16_virtual_pf3_sriov_num_vf_non_ari                          = 0,
     parameter ctop_core16_virtual_pf4_sriov_num_vf_non_ari                          = 0,
     parameter ctop_core16_virtual_pf5_sriov_num_vf_non_ari                          = 0,
     parameter ctop_core16_virtual_pf6_sriov_num_vf_non_ari                          = 0,
     parameter ctop_core16_virtual_pf7_sriov_num_vf_non_ari                          = 0,
     parameter ctop_core8_virtual_pf0_sriov_num_vf_non_ari                           = 0,
     parameter ctop_core8_virtual_pf1_sriov_num_vf_non_ari                           = 0,
     parameter ctop_core8_virtual_pf2_sriov_num_vf_non_ari                           = 0,
     parameter ctop_core8_virtual_pf3_sriov_num_vf_non_ari                           = 0,
     parameter ctop_core8_virtual_pf4_sriov_num_vf_non_ari                           = 0,
     parameter ctop_core8_virtual_pf5_sriov_num_vf_non_ari                           = 0,
     parameter ctop_core8_virtual_pf6_sriov_num_vf_non_ari                           = 0,
     parameter ctop_core8_virtual_pf7_sriov_num_vf_non_ari                           = 0,

     parameter pcie_cvp_attr                                                         = "PCIE_CVP_ATTR_DISABLE",
     parameter ctop_core16_cvp_user_id                                               = 0,
     parameter ctop_core16_exvf_msix_tablesize_pf0                                   = 0,
     parameter ctop_core16_exvf_msix_tablesize_pf1                                   = 0,
     parameter ctop_core16_exvf_msix_tablesize_pf2                                   = 0,
     parameter ctop_core16_exvf_msix_tablesize_pf3                                   = 0,
     parameter ctop_core16_exvf_msix_tablesize_pf4                                   = 0,
     parameter ctop_core16_exvf_msix_tablesize_pf5                                   = 0,
     parameter ctop_core16_exvf_msix_tablesize_pf6                                   = 0,
     parameter ctop_core16_exvf_msix_tablesize_pf7                                   = 0,
     parameter ctop_core16_exvf_msixpba_bir_pf0                                      = 0,
     parameter ctop_core16_exvf_msixpba_bir_pf1                                      = 0,
     parameter ctop_core16_exvf_msixpba_bir_pf2                                      = 0,
     parameter ctop_core16_exvf_msixpba_bir_pf3                                      = 0,
     parameter ctop_core16_exvf_msixpba_bir_pf4                                      = 0,
     parameter ctop_core16_exvf_msixpba_bir_pf5                                      = 0,
     parameter ctop_core16_exvf_msixpba_bir_pf6                                      = 0,
     parameter ctop_core16_exvf_msixpba_bir_pf7                                      = 0,
     parameter ctop_core16_exvf_msixpba_offset_pf0                                   = 0,
     parameter ctop_core16_exvf_msixpba_offset_pf1                                   = 0,
     parameter ctop_core16_exvf_msixpba_offset_pf2                                   = 0,
     parameter ctop_core16_exvf_msixpba_offset_pf3                                   = 0,
     parameter ctop_core16_exvf_msixpba_offset_pf4                                   = 0,
     parameter ctop_core16_exvf_msixpba_offset_pf5                                   = 0,
     parameter ctop_core16_exvf_msixpba_offset_pf6                                   = 0,
     parameter ctop_core16_exvf_msixpba_offset_pf7                                   = 0,
     parameter ctop_core16_exvf_msixtable_bir_pf0                                    = 0,
     parameter ctop_core16_exvf_msixtable_bir_pf1                                    = 0,
     parameter ctop_core16_exvf_msixtable_bir_pf2                                    = 0,
     parameter ctop_core16_exvf_msixtable_bir_pf3                                    = 0,
     parameter ctop_core16_exvf_msixtable_bir_pf4                                    = 0,
     parameter ctop_core16_exvf_msixtable_bir_pf5                                    = 0,
     parameter ctop_core16_exvf_msixtable_bir_pf6                                    = 0,
     parameter ctop_core16_exvf_msixtable_bir_pf7                                    = 0,
     parameter ctop_core16_exvf_msixtable_offset_pf0                                 = 0,
     parameter ctop_core16_exvf_msixtable_offset_pf1                                 = 0,
     parameter ctop_core16_exvf_msixtable_offset_pf2                                 = 0,
     parameter ctop_core16_exvf_msixtable_offset_pf3                                 = 0,
     parameter ctop_core16_exvf_msixtable_offset_pf4                                 = 0,
     parameter ctop_core16_exvf_msixtable_offset_pf5                                 = 0,
     parameter ctop_core16_exvf_msixtable_offset_pf6                                 = 0,
     parameter ctop_core16_exvf_msixtable_offset_pf7                                 = 0,
     parameter ctop_core16_exvf_subsysid_pf0                                         = 0,
     parameter ctop_core16_exvf_subsysid_pf1                                         = 0,
     parameter ctop_core16_exvf_subsysid_pf2                                         = 0,
     parameter ctop_core16_exvf_subsysid_pf3                                         = 0,
     parameter ctop_core16_exvf_subsysid_pf4                                         = 0,
     parameter ctop_core16_exvf_subsysid_pf5                                         = 0,
     parameter ctop_core16_exvf_subsysid_pf6                                         = 0,
     parameter ctop_core16_exvf_subsysid_pf7                                         = 0,
     parameter ctop_core16_pf0_acs_cap_acs_at_block                                  = "DISABLE",
     parameter ctop_core16_pf0_acs_cap_acs_direct_translated_p2p                     = "DISABLE",
     parameter ctop_core16_pf0_acs_cap_acs_egress_ctrl_size                          = 8,
     parameter ctop_core16_pf0_acs_cap_acs_p2p_cpl_redirect                          = "DISABLE",
     parameter ctop_core16_pf0_acs_cap_acs_p2p_egress_control                        = "DISABLE",
     parameter ctop_core16_pf0_acs_cap_acs_p2p_req_redirect                          = "DISABLE",
     parameter ctop_core16_pf0_acs_cap_acs_src_valid                                 = "DISABLE",
     parameter ctop_core16_pf0_acs_cap_acs_usp_forwarding                            = "DISABLE",
     parameter ctop_core16_pf0_auto_lane_flip_ctrl_en                                = "ENABLE",
     parameter ctop_core16_pf0_bar0_prefetch                                         = "TRUE",
     parameter ctop_core16_pf0_bar0_type                                             = "CTOP_CORE16_PF0_BAR0_MEM64",
     parameter ctop_core16_pf0_bar1_prefetch                                         = "FALSE",
     parameter ctop_core16_pf0_bar2_prefetch                                         = "FALSE",
     parameter ctop_core16_pf0_bar2_type                                             = "CTOP_CORE16_PF0_BAR2_MEM32",
     parameter ctop_core16_pf0_bar3_prefetch                                         = "FALSE",
     parameter ctop_core16_pf0_bar4_prefetch                                         = "FALSE",
     parameter ctop_core16_pf0_bar4_type                                             = "CTOP_CORE16_PF0_BAR4_MEM32",
     parameter ctop_core16_pf0_bar5_prefetch                                         = "FALSE",
     parameter ctop_core16_pf0_base_class_code                                       = 255,
     parameter ctop_core16_pf0_eq_redo                                               = "DISABLE",
     parameter ctop_core16_pf0_eq_redo_atg4                                          = "DISABLE",
     parameter ctop_core16_pf0_gen3_eq_pset_req_vec                                  = 4,
     parameter ctop_core16_pf0_gen3_eq_pset_req_vec_atg4                             = 624,
     parameter ctop_core16_pf0_int_pin                                               = "CTOP_CORE16_PF0_NO_INT",
     parameter ctop_core16_pf0_loopback_enable                                       = "FALSE",
     parameter ctop_core16_pf0_pasid_cap_execute_permission_supported                = "DISABLE",
     parameter ctop_core16_pf0_pasid_cap_max_pasid_width                             = 0,
     parameter ctop_core16_pf0_pasid_cap_privileged_mode_supported                   = "DISABLE",
     parameter ctop_core16_pf0_pci_msi_64_bit_addr_cap                               = "FALSE",
     parameter ctop_core16_pf0_pci_msi_ext_data_cap                                  = "FALSE",
     parameter ctop_core16_pf0_pci_msi_multiple_msg_cap                              = "CTOP_CORE16_PF0_MSI_VEC_1",
     parameter ctop_core16_pf0_pci_msix_bir                                          = 0,
     parameter ctop_core16_pf0_pci_msix_pba                                          = 0,
     parameter ctop_core16_pf0_pci_msix_pba_offset                                   = 0,
     parameter ctop_core16_pf0_pci_msix_table_offset                                 = 0,
     parameter ctop_core16_pf0_pci_msix_table_size                                   = 0,
     parameter ctop_core16_pf0_pci_msix_table_size_vfcomm_cs2                        = 0,
     parameter ctop_core16_pf0_pci_type0_bar0_enabled                                = "ENABLE",
     parameter ctop_core16_pf0_pci_type0_bar1_enabled                                = "DISABLE",
     parameter ctop_core16_pf0_pci_type0_bar2_enabled                                = "DISABLE",
     parameter ctop_core16_pf0_pci_type0_bar3_enabled                                = "DISABLE",
     parameter ctop_core16_pf0_pci_type0_bar4_enabled                                = "DISABLE",
     parameter ctop_core16_pf0_pci_type0_bar5_enabled                                = "DISABLE",
     parameter ctop_core16_pf0_pci_type0_device_id                                   = 0,
     parameter ctop_core16_pf0_pci_type0_vendor_id                                   = 4466,
     parameter ctop_core16_pf0_pcie_cap_attention_indicator                          = "FALSE",
     parameter ctop_core16_pf0_pcie_cap_attention_indicator_button                   = "FALSE",
     parameter ctop_core16_pf0_pcie_cap_electromech_interlock                        = "FALSE",
     parameter ctop_core16_pf0_pcie_cap_ep_l0s_accpt_latency                         = 0,
     parameter ctop_core16_pf0_pcie_cap_ep_l1_accpt_latency                          = 0,
     parameter ctop_core16_pf0_pcie_cap_ext_tag_supp                                 = "CTOP_CORE16_PF0_SUPPORTED",
     parameter ctop_core16_pf0_pcie_cap_flr_cap                                      = "CTOP_CORE16_PF0_NOT_CAPABLE",
     parameter ctop_core16_pf0_pcie_cap_hot_plug_capable                             = "FALSE",
     parameter ctop_core16_pf0_pcie_cap_hot_plug_surprise                            = "FALSE",
     parameter ctop_core16_pf0_pcie_cap_mrl_sensor                                   = "FALSE",
     parameter ctop_core16_pf0_pcie_cap_no_cmd_cpl_support                           = "FALSE",
     parameter ctop_core16_pf0_pcie_cap_phy_slot_num                                 = 0,
     parameter ctop_core16_pf0_pcie_cap_port_num                                     = 1,
     parameter ctop_core16_pf0_pcie_cap_power_controller                             = "FALSE",
     parameter ctop_core16_pf0_pcie_cap_power_indicator                              = "FALSE",
     parameter ctop_core16_pf0_pcie_cap_sel_deemphasis                               = "CTOP_CORE16_PF0_MINUS_6DB",
     parameter ctop_core16_pf0_pcie_cap_slot_clk_config                              = "TRUE",
     parameter ctop_core16_pf0_pcie_cap_slot_power_limit_scale                       = 0,
     parameter ctop_core16_pf0_pcie_cap_slot_power_limit_value                       = 0,
     parameter ctop_core16_pf0_pcie_slot_imp                                         = "CTOP_CORE16_PF0_NOT_IMPLEMENTED",
     parameter ctop_core16_pf0_pme_support                                           = 15,
     parameter ctop_core16_pf0_program_interface                                     = 0,
     parameter ctop_core16_pf0_revision_id                                           = 1,
     parameter ctop_core16_pf0_rom_bar_enabled                                       = "DISABLE",
     parameter ctop_core16_pf0_rp_rom_bar_enabled                                    = "DISABLE",
     parameter ctop_core16_pf0_shadow_sriov_vf_stride_ari_cs2                        = 0,
     parameter ctop_core16_pf0_sriov_sup_page_size                                   = "0",
     parameter ctop_core16_pf0_sriov_vf_bar0_prefetch                                = "FALSE",
     parameter ctop_core16_pf0_sriov_vf_bar0_type                                    = "CTOP_CORE16_PF0_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core16_pf0_sriov_vf_bar1_prefetch                                = "FALSE",
     parameter ctop_core16_pf0_sriov_vf_bar2_prefetch                                = "FALSE",
     parameter ctop_core16_pf0_sriov_vf_bar2_type                                    = "CTOP_CORE16_PF0_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core16_pf0_sriov_vf_bar3_prefetch                                = "FALSE",
     parameter ctop_core16_pf0_sriov_vf_bar4_prefetch                                = "FALSE",
     parameter ctop_core16_pf0_sriov_vf_bar4_type                                    = "CTOP_CORE16_PF0_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core16_pf0_sriov_vf_bar5_prefetch                                = "FALSE",
     parameter ctop_core16_pf0_sriov_vf_device_id                                    = 0,
     parameter ctop_core16_pf0_sriov_vf_offset_ari_cs2                               = 0,
     parameter ctop_core16_pf0_sriov_vf_offset_nonari                                = 0,
     parameter ctop_core16_pf0_sriov_vf_stride_nonari                                = 0,
     parameter ctop_core16_pf0_subclass_code                                         = 0,
     parameter ctop_core16_pf0_subsys_dev_id                                         = 0,
     parameter ctop_core16_pf0_subsys_vendor_id                                      = 0,
     parameter ctop_core16_pf0_tph_req_cap_int_vec                                   = "DISABLE",
     parameter ctop_core16_pf0_tph_req_cap_int_vec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf0_tph_req_cap_st_table_loc_0_vfcomm_cs2                 = "CTOP_CORE16_PF0_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core16_pf0_tph_req_cap_st_table_loc_1                            = "CTOP_CORE16_PF0_NOT_IN_MSIX_TABLE",
     parameter ctop_core16_pf0_tph_req_cap_st_table_loc_1_vfcomm_cs2                 = "CTOP_CORE16_PF0_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core16_pf0_tph_req_cap_st_table_size                             = 0,
     parameter ctop_core16_pf0_tph_req_cap_st_table_size_vfcomm_cs2                  = 0,
     parameter ctop_core16_pf0_tph_req_device_spec                                   = "DISABLE",
     parameter ctop_core16_pf0_tph_req_device_spec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf1_acs_cap_acs_at_block                                  = "DISABLE",
     parameter ctop_core16_pf1_acs_cap_acs_direct_translated_p2p                     = "DISABLE",
     parameter ctop_core16_pf1_acs_cap_acs_egress_ctrl_size                          = 8,
     parameter ctop_core16_pf1_acs_cap_acs_p2p_cpl_redirect                          = "DISABLE",
     parameter ctop_core16_pf1_acs_cap_acs_p2p_egress_control                        = "DISABLE",
     parameter ctop_core16_pf1_acs_cap_acs_p2p_req_redirect                          = "DISABLE",
     parameter ctop_core16_pf1_acs_cap_acs_src_valid                                 = "DISABLE",
     parameter ctop_core16_pf1_acs_cap_acs_usp_forwarding                            = "DISABLE",
     parameter ctop_core16_pf1_bar0_prefetch                                         = "FALSE",
     parameter ctop_core16_pf1_bar0_type                                             = "CTOP_CORE16_PF1_BAR0_MEM32",
     parameter ctop_core16_pf1_bar1_prefetch                                         = "FALSE",
     parameter ctop_core16_pf1_bar2_prefetch                                         = "FALSE",
     parameter ctop_core16_pf1_bar2_type                                             = "CTOP_CORE16_PF1_BAR2_MEM32",
     parameter ctop_core16_pf1_bar3_prefetch                                         = "FALSE",
     parameter ctop_core16_pf1_bar4_prefetch                                         = "FALSE",
     parameter ctop_core16_pf1_bar4_type                                             = "CTOP_CORE16_PF1_BAR4_MEM32",
     parameter ctop_core16_pf1_bar5_prefetch                                         = "FALSE",
     parameter ctop_core16_pf1_base_class_code                                       = 255,
     parameter ctop_core16_pf1_int_pin                                               = "CTOP_CORE16_PF1_NO_INT",
     parameter ctop_core16_pf1_pasid_cap_execute_permission_supported                = "DISABLE",
     parameter ctop_core16_pf1_pasid_cap_max_pasid_width                             = 0,
     parameter ctop_core16_pf1_pasid_cap_privileged_mode_supported                   = "DISABLE",
     parameter ctop_core16_pf1_pci_msi_64_bit_addr_cap                               = "FALSE",
     parameter ctop_core16_pf1_pci_msi_ext_data_cap                                  = "FALSE",
     parameter ctop_core16_pf1_pci_msi_multiple_msg_cap                              = "CTOP_CORE16_PF1_MSI_VEC_1",
     parameter ctop_core16_pf1_pci_msix_bir                                          = 0,
     parameter ctop_core16_pf1_pci_msix_pba                                          = 0,
     parameter ctop_core16_pf1_pci_msix_pba_offset                                   = 0,
     parameter ctop_core16_pf1_pci_msix_table_offset                                 = 0,
     parameter ctop_core16_pf1_pci_msix_table_size                                   = 0,
     parameter ctop_core16_pf1_pci_msix_table_size_vfcomm_cs2                        = 0,
     parameter ctop_core16_pf1_pci_type0_bar0_enabled                                = "DISABLE",
     parameter ctop_core16_pf1_pci_type0_bar1_enabled                                = "DISABLE",
     parameter ctop_core16_pf1_pci_type0_bar2_enabled                                = "DISABLE",
     parameter ctop_core16_pf1_pci_type0_bar3_enabled                                = "DISABLE",
     parameter ctop_core16_pf1_pci_type0_bar4_enabled                                = "DISABLE",
     parameter ctop_core16_pf1_pci_type0_bar5_enabled                                = "DISABLE",
     parameter ctop_core16_pf1_pci_type0_device_id                                   = 0,
     parameter ctop_core16_pf1_pci_type0_vendor_id                                   = 0,
     parameter ctop_core16_pf1_pcie_cap_ep_l0s_accpt_latency                         = 0,
     parameter ctop_core16_pf1_pcie_cap_ep_l1_accpt_latency                          = 0,
     parameter ctop_core16_pf1_pcie_cap_ext_tag_supp                                 = "CTOP_CORE16_PF1_NOT_SUPPORTED",
     parameter ctop_core16_pf1_pcie_cap_flr_cap                                      = "CTOP_CORE16_PF1_NOT_CAPABLE",
     parameter ctop_core16_pf1_pcie_cap_slot_clk_config                              = "FALSE",
     parameter ctop_core16_pf1_pme_support                                           = 0,
     parameter ctop_core16_pf1_program_interface                                     = 0,
     parameter ctop_core16_pf1_revision_id                                           = 0,
     parameter ctop_core16_pf1_rom_bar_enabled                                       = "DISABLE",
     parameter ctop_core16_pf1_shadow_sriov_vf_stride_ari_cs2                        = 0,
     parameter ctop_core16_pf1_sriov_sup_page_size                                   = "0",
     parameter ctop_core16_pf1_sriov_vf_bar0_prefetch                                = "FALSE",
     parameter ctop_core16_pf1_sriov_vf_bar0_type                                    = "CTOP_CORE16_PF1_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core16_pf1_sriov_vf_bar1_prefetch                                = "FALSE",
     parameter ctop_core16_pf1_sriov_vf_bar2_prefetch                                = "FALSE",
     parameter ctop_core16_pf1_sriov_vf_bar2_type                                    = "CTOP_CORE16_PF1_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core16_pf1_sriov_vf_bar3_prefetch                                = "FALSE",
     parameter ctop_core16_pf1_sriov_vf_bar4_prefetch                                = "FALSE",
     parameter ctop_core16_pf1_sriov_vf_bar4_type                                    = "CTOP_CORE16_PF1_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core16_pf1_sriov_vf_bar5_prefetch                                = "FALSE",
     parameter ctop_core16_pf1_sriov_vf_device_id                                    = 0,
     parameter ctop_core16_pf1_sriov_vf_offset_ari_cs2                               = 0,
     parameter ctop_core16_pf1_sriov_vf_offset_position_nonari                       = 0,
     parameter ctop_core16_pf1_sriov_vf_stride_nonari                                = 0,
     parameter ctop_core16_pf1_subclass_code                                         = 0,
     parameter ctop_core16_pf1_subsys_dev_id                                         = 0,
     parameter ctop_core16_pf1_subsys_vendor_id                                      = 0,
     parameter ctop_core16_pf1_tph_req_cap_int_vec                                   = "DISABLE",
     parameter ctop_core16_pf1_tph_req_cap_int_vec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf1_tph_req_cap_st_table_loc_0_vfcomm_cs2                 = "CTOP_CORE16_PF1_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core16_pf1_tph_req_cap_st_table_loc_1                            = "CTOP_CORE16_PF1_NOT_IN_MSIX_TABLE",
     parameter ctop_core16_pf1_tph_req_cap_st_table_loc_1_vfcomm_cs2                 = "CTOP_CORE16_PF1_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core16_pf1_tph_req_cap_st_table_size                             = 0,
     parameter ctop_core16_pf1_tph_req_cap_st_table_size_vfcomm_cs2                  = 0,
     parameter ctop_core16_pf1_tph_req_device_spec                                   = "DISABLE",
     parameter ctop_core16_pf1_tph_req_device_spec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf2_acs_cap_acs_at_block                                  = "DISABLE",
     parameter ctop_core16_pf2_acs_cap_acs_direct_translated_p2p                     = "DISABLE",
     parameter ctop_core16_pf2_acs_cap_acs_egress_ctrl_size                          = 8,
     parameter ctop_core16_pf2_acs_cap_acs_p2p_cpl_redirect                          = "DISABLE",
     parameter ctop_core16_pf2_acs_cap_acs_p2p_egress_control                        = "DISABLE",
     parameter ctop_core16_pf2_acs_cap_acs_p2p_req_redirect                          = "DISABLE",
     parameter ctop_core16_pf2_acs_cap_acs_src_valid                                 = "DISABLE",
     parameter ctop_core16_pf2_acs_cap_acs_usp_forwarding                            = "DISABLE",
     parameter ctop_core16_pf2_bar0_prefetch                                         = "FALSE",
     parameter ctop_core16_pf2_bar0_type                                             = "CTOP_CORE16_PF2_BAR0_MEM32",
     parameter ctop_core16_pf2_bar1_prefetch                                         = "FALSE",
     parameter ctop_core16_pf2_bar2_prefetch                                         = "FALSE",
     parameter ctop_core16_pf2_bar2_type                                             = "CTOP_CORE16_PF2_BAR2_MEM32",
     parameter ctop_core16_pf2_bar3_prefetch                                         = "FALSE",
     parameter ctop_core16_pf2_bar4_prefetch                                         = "FALSE",
     parameter ctop_core16_pf2_bar4_type                                             = "CTOP_CORE16_PF2_BAR4_MEM32",
     parameter ctop_core16_pf2_bar5_prefetch                                         = "FALSE",
     parameter ctop_core16_pf2_base_class_code                                       = 255,
     parameter ctop_core16_pf2_int_pin                                               = "CTOP_CORE16_PF2_NO_INT",
     parameter ctop_core16_pf2_pasid_cap_execute_permission_supported                = "DISABLE",
     parameter ctop_core16_pf2_pasid_cap_max_pasid_width                             = 0,
     parameter ctop_core16_pf2_pasid_cap_privileged_mode_supported                   = "DISABLE",
     parameter ctop_core16_pf2_pci_msi_64_bit_addr_cap                               = "FALSE",
     parameter ctop_core16_pf2_pci_msi_ext_data_cap                                  = "FALSE",
     parameter ctop_core16_pf2_pci_msi_multiple_msg_cap                              = "CTOP_CORE16_PF2_MSI_VEC_1",
     parameter ctop_core16_pf2_pci_msix_bir                                          = 0,
     parameter ctop_core16_pf2_pci_msix_pba                                          = 0,
     parameter ctop_core16_pf2_pci_msix_pba_offset                                   = 0,
     parameter ctop_core16_pf2_pci_msix_table_offset                                 = 0,
     parameter ctop_core16_pf2_pci_msix_table_size                                   = 0,
     parameter ctop_core16_pf2_pci_msix_table_size_vfcomm_cs2                        = 0,
     parameter ctop_core16_pf2_pci_type0_bar0_enabled                                = "DISABLE",
     parameter ctop_core16_pf2_pci_type0_bar1_enabled                                = "DISABLE",
     parameter ctop_core16_pf2_pci_type0_bar2_enabled                                = "DISABLE",
     parameter ctop_core16_pf2_pci_type0_bar3_enabled                                = "DISABLE",
     parameter ctop_core16_pf2_pci_type0_bar4_enabled                                = "DISABLE",
     parameter ctop_core16_pf2_pci_type0_bar5_enabled                                = "DISABLE",
     parameter ctop_core16_pf2_pci_type0_device_id                                   = 0,
     parameter ctop_core16_pf2_pci_type0_vendor_id                                   = 0,
     parameter ctop_core16_pf2_pcie_cap_ep_l0s_accpt_latency                         = 0,
     parameter ctop_core16_pf2_pcie_cap_ep_l1_accpt_latency                          = 0,
     parameter ctop_core16_pf2_pcie_cap_ext_tag_supp                                 = "CTOP_CORE16_PF2_NOT_SUPPORTED",
     parameter ctop_core16_pf2_pcie_cap_flr_cap                                      = "CTOP_CORE16_PF2_NOT_CAPABLE",
     parameter ctop_core16_pf2_pcie_cap_slot_clk_config                              = "FALSE",
     parameter ctop_core16_pf2_pme_support                                           = 0,
     parameter ctop_core16_pf2_program_interface                                     = 0,
     parameter ctop_core16_pf2_revision_id                                           = 0,
     parameter ctop_core16_pf2_rom_bar_enabled                                       = "DISABLE",
     parameter ctop_core16_pf2_shadow_sriov_vf_stride_ari_cs2                        = 0,
     parameter ctop_core16_pf2_sriov_sup_page_size                                   = "0",
     parameter ctop_core16_pf2_sriov_vf_bar0_prefetch                                = "FALSE",
     parameter ctop_core16_pf2_sriov_vf_bar0_type                                    = "CTOP_CORE16_PF2_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core16_pf2_sriov_vf_bar1_prefetch                                = "FALSE",
     parameter ctop_core16_pf2_sriov_vf_bar2_prefetch                                = "FALSE",
     parameter ctop_core16_pf2_sriov_vf_bar2_type                                    = "CTOP_CORE16_PF2_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core16_pf2_sriov_vf_bar3_prefetch                                = "FALSE",
     parameter ctop_core16_pf2_sriov_vf_bar4_prefetch                                = "FALSE",
     parameter ctop_core16_pf2_sriov_vf_bar4_type                                    = "CTOP_CORE16_PF2_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core16_pf2_sriov_vf_bar5_prefetch                                = "FALSE",
     parameter ctop_core16_pf2_sriov_vf_device_id                                    = 0,
     parameter ctop_core16_pf2_sriov_vf_offset_ari_cs2                               = 0,
     parameter ctop_core16_pf2_sriov_vf_offset_position_nonari                       = 0,
     parameter ctop_core16_pf2_sriov_vf_stride_nonari                                = 0,
     parameter ctop_core16_pf2_subclass_code                                         = 0,
     parameter ctop_core16_pf2_subsys_dev_id                                         = 0,
     parameter ctop_core16_pf2_subsys_vendor_id                                      = 0,
     parameter ctop_core16_pf2_tph_req_cap_int_vec                                   = "DISABLE",
     parameter ctop_core16_pf2_tph_req_cap_int_vec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf2_tph_req_cap_st_table_loc_0_vfcomm_cs2                 = "CTOP_CORE16_PF2_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core16_pf2_tph_req_cap_st_table_loc_1                            = "CTOP_CORE16_PF2_NOT_IN_MSIX_TABLE",
     parameter ctop_core16_pf2_tph_req_cap_st_table_loc_1_vfcomm_cs2                 = "CTOP_CORE16_PF2_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core16_pf2_tph_req_cap_st_table_size                             = 0,
     parameter ctop_core16_pf2_tph_req_cap_st_table_size_vfcomm_cs2                  = 0,
     parameter ctop_core16_pf2_tph_req_device_spec                                   = "DISABLE",
     parameter ctop_core16_pf2_tph_req_device_spec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf3_acs_cap_acs_at_block                                  = "DISABLE",
     parameter ctop_core16_pf3_acs_cap_acs_direct_translated_p2p                     = "DISABLE",
     parameter ctop_core16_pf3_acs_cap_acs_egress_ctrl_size                          = 8,
     parameter ctop_core16_pf3_acs_cap_acs_p2p_cpl_redirect                          = "DISABLE",
     parameter ctop_core16_pf3_acs_cap_acs_p2p_egress_control                        = "DISABLE",
     parameter ctop_core16_pf3_acs_cap_acs_p2p_req_redirect                          = "DISABLE",
     parameter ctop_core16_pf3_acs_cap_acs_src_valid                                 = "DISABLE",
     parameter ctop_core16_pf3_acs_cap_acs_usp_forwarding                            = "DISABLE",
     parameter ctop_core16_pf3_bar0_prefetch                                         = "FALSE",
     parameter ctop_core16_pf3_bar0_type                                             = "CTOP_CORE16_PF3_BAR0_MEM32",
     parameter ctop_core16_pf3_bar1_prefetch                                         = "FALSE",
     parameter ctop_core16_pf3_bar2_prefetch                                         = "FALSE",
     parameter ctop_core16_pf3_bar2_type                                             = "CTOP_CORE16_PF3_BAR2_MEM32",
     parameter ctop_core16_pf3_bar3_prefetch                                         = "FALSE",
     parameter ctop_core16_pf3_bar4_prefetch                                         = "FALSE",
     parameter ctop_core16_pf3_bar4_type                                             = "CTOP_CORE16_PF3_BAR4_MEM32",
     parameter ctop_core16_pf3_bar5_prefetch                                         = "FALSE",
     parameter ctop_core16_pf3_base_class_code                                       = 255,
     parameter ctop_core16_pf3_int_pin                                               = "CTOP_CORE16_PF3_NO_INT",
     parameter ctop_core16_pf3_pasid_cap_execute_permission_supported                = "DISABLE",
     parameter ctop_core16_pf3_pasid_cap_max_pasid_width                             = 0,
     parameter ctop_core16_pf3_pasid_cap_privileged_mode_supported                   = "DISABLE",
     parameter ctop_core16_pf3_pci_msi_64_bit_addr_cap                               = "FALSE",
     parameter ctop_core16_pf3_pci_msi_ext_data_cap                                  = "FALSE",
     parameter ctop_core16_pf3_pci_msi_multiple_msg_cap                              = "CTOP_CORE16_PF3_MSI_VEC_1",
     parameter ctop_core16_pf3_pci_msix_bir                                          = 0,
     parameter ctop_core16_pf3_pci_msix_pba                                          = 0,
     parameter ctop_core16_pf3_pci_msix_pba_offset                                   = 0,
     parameter ctop_core16_pf3_pci_msix_table_offset                                 = 0,
     parameter ctop_core16_pf3_pci_msix_table_size                                   = 0,
     parameter ctop_core16_pf3_pci_msix_table_size_vfcomm_cs2                        = 0,
     parameter ctop_core16_pf3_pci_type0_bar0_enabled                                = "DISABLE",
     parameter ctop_core16_pf3_pci_type0_bar1_enabled                                = "DISABLE",
     parameter ctop_core16_pf3_pci_type0_bar2_enabled                                = "DISABLE",
     parameter ctop_core16_pf3_pci_type0_bar3_enabled                                = "DISABLE",
     parameter ctop_core16_pf3_pci_type0_bar4_enabled                                = "DISABLE",
     parameter ctop_core16_pf3_pci_type0_bar5_enabled                                = "DISABLE",
     parameter ctop_core16_pf3_pci_type0_device_id                                   = 0,
     parameter ctop_core16_pf3_pci_type0_vendor_id                                   = 0,
     parameter ctop_core16_pf3_pcie_cap_ep_l0s_accpt_latency                         = 0,
     parameter ctop_core16_pf3_pcie_cap_ep_l1_accpt_latency                          = 0,
     parameter ctop_core16_pf3_pcie_cap_ext_tag_supp                                 = "CTOP_CORE16_PF3_NOT_SUPPORTED",
     parameter ctop_core16_pf3_pcie_cap_flr_cap                                      = "CTOP_CORE16_PF3_NOT_CAPABLE",
     parameter ctop_core16_pf3_pcie_cap_slot_clk_config                              = "FALSE",
     parameter ctop_core16_pf3_pme_support                                           = 0,
     parameter ctop_core16_pf3_program_interface                                     = 0,
     parameter ctop_core16_pf3_revision_id                                           = 0,
     parameter ctop_core16_pf3_rom_bar_enabled                                       = "DISABLE",
     parameter ctop_core16_pf3_shadow_sriov_vf_stride_ari_cs2                        = 0,
     parameter ctop_core16_pf3_sriov_sup_page_size                                   = "0",
     parameter ctop_core16_pf3_sriov_vf_bar0_prefetch                                = "FALSE",
     parameter ctop_core16_pf3_sriov_vf_bar0_type                                    = "CTOP_CORE16_PF3_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core16_pf3_sriov_vf_bar1_prefetch                                = "FALSE",
     parameter ctop_core16_pf3_sriov_vf_bar2_prefetch                                = "FALSE",
     parameter ctop_core16_pf3_sriov_vf_bar2_type                                    = "CTOP_CORE16_PF3_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core16_pf3_sriov_vf_bar3_prefetch                                = "FALSE",
     parameter ctop_core16_pf3_sriov_vf_bar4_prefetch                                = "FALSE",
     parameter ctop_core16_pf3_sriov_vf_bar4_type                                    = "CTOP_CORE16_PF3_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core16_pf3_sriov_vf_bar5_prefetch                                = "FALSE",
     parameter ctop_core16_pf3_sriov_vf_device_id                                    = 0,
     parameter ctop_core16_pf3_sriov_vf_offset_ari_cs2                               = 0,
     parameter ctop_core16_pf3_sriov_vf_offset_position_nonari                       = 0,
     parameter ctop_core16_pf3_sriov_vf_stride_nonari                                = 0,
     parameter ctop_core16_pf3_subclass_code                                         = 0,
     parameter ctop_core16_pf3_subsys_dev_id                                         = 0,
     parameter ctop_core16_pf3_subsys_vendor_id                                      = 0,
     parameter ctop_core16_pf3_tph_req_cap_int_vec                                   = "DISABLE",
     parameter ctop_core16_pf3_tph_req_cap_int_vec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf3_tph_req_cap_st_table_loc_0_vfcomm_cs2                 = "CTOP_CORE16_PF3_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core16_pf3_tph_req_cap_st_table_loc_1                            = "CTOP_CORE16_PF3_NOT_IN_MSIX_TABLE",
     parameter ctop_core16_pf3_tph_req_cap_st_table_loc_1_vfcomm_cs2                 = "CTOP_CORE16_PF3_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core16_pf3_tph_req_cap_st_table_size                             = 0,
     parameter ctop_core16_pf3_tph_req_cap_st_table_size_vfcomm_cs2                  = 0,
     parameter ctop_core16_pf3_tph_req_device_spec                                   = "DISABLE",
     parameter ctop_core16_pf3_tph_req_device_spec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf4_acs_cap_acs_at_block                                  = "DISABLE",
     parameter ctop_core16_pf4_acs_cap_acs_direct_translated_p2p                     = "DISABLE",
     parameter ctop_core16_pf4_acs_cap_acs_egress_ctrl_size                          = 8,
     parameter ctop_core16_pf4_acs_cap_acs_p2p_cpl_redirect                          = "DISABLE",
     parameter ctop_core16_pf4_acs_cap_acs_p2p_egress_control                        = "DISABLE",
     parameter ctop_core16_pf4_acs_cap_acs_p2p_req_redirect                          = "DISABLE",
     parameter ctop_core16_pf4_acs_cap_acs_src_valid                                 = "DISABLE",
     parameter ctop_core16_pf4_acs_cap_acs_usp_forwarding                            = "DISABLE",
     parameter ctop_core16_pf4_bar0_prefetch                                         = "FALSE",
     parameter ctop_core16_pf4_bar0_type                                             = "CTOP_CORE16_PF4_BAR0_MEM32",
     parameter ctop_core16_pf4_bar1_prefetch                                         = "FALSE",
     parameter ctop_core16_pf4_bar2_prefetch                                         = "FALSE",
     parameter ctop_core16_pf4_bar2_type                                             = "CTOP_CORE16_PF4_BAR2_MEM32",
     parameter ctop_core16_pf4_bar3_prefetch                                         = "FALSE",
     parameter ctop_core16_pf4_bar4_prefetch                                         = "FALSE",
     parameter ctop_core16_pf4_bar4_type                                             = "CTOP_CORE16_PF4_BAR4_MEM32",
     parameter ctop_core16_pf4_bar5_prefetch                                         = "FALSE",
     parameter ctop_core16_pf4_base_class_code                                       = 255,
     parameter ctop_core16_pf4_int_pin                                               = "CTOP_CORE16_PF4_NO_INT",
     parameter ctop_core16_pf4_pasid_cap_execute_permission_supported                = "DISABLE",
     parameter ctop_core16_pf4_pasid_cap_max_pasid_width                             = 0,
     parameter ctop_core16_pf4_pasid_cap_privileged_mode_supported                   = "DISABLE",
     parameter ctop_core16_pf4_pci_msi_64_bit_addr_cap                               = "FALSE",
     parameter ctop_core16_pf4_pci_msi_ext_data_cap                                  = "FALSE",
     parameter ctop_core16_pf4_pci_msi_multiple_msg_cap                              = "CTOP_CORE16_PF4_MSI_VEC_1",
     parameter ctop_core16_pf4_pci_msix_bir                                          = 0,
     parameter ctop_core16_pf4_pci_msix_pba                                          = 0,
     parameter ctop_core16_pf4_pci_msix_pba_offset                                   = 0,
     parameter ctop_core16_pf4_pci_msix_table_offset                                 = 0,
     parameter ctop_core16_pf4_pci_msix_table_size                                   = 0,
     parameter ctop_core16_pf4_pci_msix_table_size_vfcomm_cs2                        = 0,
     parameter ctop_core16_pf4_pci_type0_bar0_enabled                                = "DISABLE",
     parameter ctop_core16_pf4_pci_type0_bar1_enabled                                = "DISABLE",
     parameter ctop_core16_pf4_pci_type0_bar2_enabled                                = "DISABLE",
     parameter ctop_core16_pf4_pci_type0_bar3_enabled                                = "DISABLE",
     parameter ctop_core16_pf4_pci_type0_bar4_enabled                                = "DISABLE",
     parameter ctop_core16_pf4_pci_type0_bar5_enabled                                = "DISABLE",
     parameter ctop_core16_pf4_pci_type0_device_id                                   = 0,
     parameter ctop_core16_pf4_pci_type0_vendor_id                                   = 0,
     parameter ctop_core16_pf4_pcie_cap_ep_l0s_accpt_latency                         = 0,
     parameter ctop_core16_pf4_pcie_cap_ep_l1_accpt_latency                          = 0,
     parameter ctop_core16_pf4_pcie_cap_ext_tag_supp                                 = "CTOP_CORE16_PF4_NOT_SUPPORTED",
     parameter ctop_core16_pf4_pcie_cap_flr_cap                                      = "CTOP_CORE16_PF4_NOT_CAPABLE",
     parameter ctop_core16_pf4_pcie_cap_slot_clk_config                              = "FALSE",
     parameter ctop_core16_pf4_pme_support                                           = 0,
     parameter ctop_core16_pf4_program_interface                                     = 0,
     parameter ctop_core16_pf4_revision_id                                           = 0,
     parameter ctop_core16_pf4_rom_bar_enabled                                       = "DISABLE",
     parameter ctop_core16_pf4_shadow_sriov_vf_stride_ari_cs2                        = 0,
     parameter ctop_core16_pf4_sriov_sup_page_size                                   = "0",
     parameter ctop_core16_pf4_sriov_vf_bar0_prefetch                                = "FALSE",
     parameter ctop_core16_pf4_sriov_vf_bar0_type                                    = "CTOP_CORE16_PF4_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core16_pf4_sriov_vf_bar1_prefetch                                = "FALSE",
     parameter ctop_core16_pf4_sriov_vf_bar2_prefetch                                = "FALSE",
     parameter ctop_core16_pf4_sriov_vf_bar2_type                                    = "CTOP_CORE16_PF4_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core16_pf4_sriov_vf_bar3_prefetch                                = "FALSE",
     parameter ctop_core16_pf4_sriov_vf_bar4_prefetch                                = "FALSE",
     parameter ctop_core16_pf4_sriov_vf_bar4_type                                    = "CTOP_CORE16_PF4_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core16_pf4_sriov_vf_bar5_prefetch                                = "FALSE",
     parameter ctop_core16_pf4_sriov_vf_device_id                                    = 0,
     parameter ctop_core16_pf4_sriov_vf_offset_ari_cs2                               = 0,
     parameter ctop_core16_pf4_sriov_vf_offset_position_nonari                       = 0,
     parameter ctop_core16_pf4_sriov_vf_stride_nonari                                = 0,
     parameter ctop_core16_pf4_subclass_code                                         = 0,
     parameter ctop_core16_pf4_subsys_dev_id                                         = 0,
     parameter ctop_core16_pf4_subsys_vendor_id                                      = 0,
     parameter ctop_core16_pf4_tph_req_cap_int_vec                                   = "DISABLE",
     parameter ctop_core16_pf4_tph_req_cap_int_vec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf4_tph_req_cap_st_table_loc_0_vfcomm_cs2                 = "CTOP_CORE16_PF4_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core16_pf4_tph_req_cap_st_table_loc_1                            = "CTOP_CORE16_PF4_NOT_IN_MSIX_TABLE",
     parameter ctop_core16_pf4_tph_req_cap_st_table_loc_1_vfcomm_cs2                 = "CTOP_CORE16_PF4_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core16_pf4_tph_req_cap_st_table_size                             = 0,
     parameter ctop_core16_pf4_tph_req_cap_st_table_size_vfcomm_cs2                  = 0,
     parameter ctop_core16_pf4_tph_req_device_spec                                   = "DISABLE",
     parameter ctop_core16_pf4_tph_req_device_spec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf5_acs_cap_acs_at_block                                  = "DISABLE",
     parameter ctop_core16_pf5_acs_cap_acs_direct_translated_p2p                     = "DISABLE",
     parameter ctop_core16_pf5_acs_cap_acs_egress_ctrl_size                          = 8,
     parameter ctop_core16_pf5_acs_cap_acs_p2p_cpl_redirect                          = "DISABLE",
     parameter ctop_core16_pf5_acs_cap_acs_p2p_egress_control                        = "DISABLE",
     parameter ctop_core16_pf5_acs_cap_acs_p2p_req_redirect                          = "DISABLE",
     parameter ctop_core16_pf5_acs_cap_acs_src_valid                                 = "DISABLE",
     parameter ctop_core16_pf5_acs_cap_acs_usp_forwarding                            = "DISABLE",
     parameter ctop_core16_pf5_bar0_prefetch                                         = "FALSE",
     parameter ctop_core16_pf5_bar0_type                                             = "CTOP_CORE16_PF5_BAR0_MEM32",
     parameter ctop_core16_pf5_bar1_prefetch                                         = "FALSE",
     parameter ctop_core16_pf5_bar2_prefetch                                         = "FALSE",
     parameter ctop_core16_pf5_bar2_type                                             = "CTOP_CORE16_PF5_BAR2_MEM32",
     parameter ctop_core16_pf5_bar3_prefetch                                         = "FALSE",
     parameter ctop_core16_pf5_bar4_prefetch                                         = "FALSE",
     parameter ctop_core16_pf5_bar4_type                                             = "CTOP_CORE16_PF5_BAR4_MEM32",
     parameter ctop_core16_pf5_bar5_prefetch                                         = "FALSE",
     parameter ctop_core16_pf5_base_class_code                                       = 255,
     parameter ctop_core16_pf5_int_pin                                               = "CTOP_CORE16_PF5_NO_INT",
     parameter ctop_core16_pf5_pasid_cap_execute_permission_supported                = "DISABLE",
     parameter ctop_core16_pf5_pasid_cap_max_pasid_width                             = 0,
     parameter ctop_core16_pf5_pasid_cap_privileged_mode_supported                   = "DISABLE",
     parameter ctop_core16_pf5_pci_msi_64_bit_addr_cap                               = "FALSE",
     parameter ctop_core16_pf5_pci_msi_ext_data_cap                                  = "FALSE",
     parameter ctop_core16_pf5_pci_msi_multiple_msg_cap                              = "CTOP_CORE16_PF5_MSI_VEC_1",
     parameter ctop_core16_pf5_pci_msix_bir                                          = 0,
     parameter ctop_core16_pf5_pci_msix_pba                                          = 0,
     parameter ctop_core16_pf5_pci_msix_pba_offset                                   = 0,
     parameter ctop_core16_pf5_pci_msix_table_offset                                 = 0,
     parameter ctop_core16_pf5_pci_msix_table_size                                   = 0,
     parameter ctop_core16_pf5_pci_msix_table_size_vfcomm_cs2                        = 0,
     parameter ctop_core16_pf5_pci_type0_bar0_enabled                                = "DISABLE",
     parameter ctop_core16_pf5_pci_type0_bar1_enabled                                = "DISABLE",
     parameter ctop_core16_pf5_pci_type0_bar2_enabled                                = "DISABLE",
     parameter ctop_core16_pf5_pci_type0_bar3_enabled                                = "DISABLE",
     parameter ctop_core16_pf5_pci_type0_bar4_enabled                                = "DISABLE",
     parameter ctop_core16_pf5_pci_type0_bar5_enabled                                = "DISABLE",
     parameter ctop_core16_pf5_pci_type0_device_id                                   = 0,
     parameter ctop_core16_pf5_pci_type0_vendor_id                                   = 0,
     parameter ctop_core16_pf5_pcie_cap_ep_l0s_accpt_latency                         = 0,
     parameter ctop_core16_pf5_pcie_cap_ep_l1_accpt_latency                          = 0,
     parameter ctop_core16_pf5_pcie_cap_ext_tag_supp                                 = "CTOP_CORE16_PF5_NOT_SUPPORTED",
     parameter ctop_core16_pf5_pcie_cap_flr_cap                                      = "CTOP_CORE16_PF5_NOT_CAPABLE",
     parameter ctop_core16_pf5_pcie_cap_slot_clk_config                              = "FALSE",
     parameter ctop_core16_pf5_pme_support                                           = 0,
     parameter ctop_core16_pf5_program_interface                                     = 0,
     parameter ctop_core16_pf5_revision_id                                           = 0,
     parameter ctop_core16_pf5_rom_bar_enabled                                       = "DISABLE",
     parameter ctop_core16_pf5_shadow_sriov_vf_stride_ari_cs2                        = 0,
     parameter ctop_core16_pf5_sriov_sup_page_size                                   = "0",
     parameter ctop_core16_pf5_sriov_vf_bar0_prefetch                                = "FALSE",
     parameter ctop_core16_pf5_sriov_vf_bar0_type                                    = "CTOP_CORE16_PF5_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core16_pf5_sriov_vf_bar1_prefetch                                = "FALSE",
     parameter ctop_core16_pf5_sriov_vf_bar2_prefetch                                = "FALSE",
     parameter ctop_core16_pf5_sriov_vf_bar2_type                                    = "CTOP_CORE16_PF5_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core16_pf5_sriov_vf_bar3_prefetch                                = "FALSE",
     parameter ctop_core16_pf5_sriov_vf_bar4_prefetch                                = "FALSE",
     parameter ctop_core16_pf5_sriov_vf_bar4_type                                    = "CTOP_CORE16_PF5_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core16_pf5_sriov_vf_bar5_prefetch                                = "FALSE",
     parameter ctop_core16_pf5_sriov_vf_device_id                                    = 0,
     parameter ctop_core16_pf5_sriov_vf_offset_ari_cs2                               = 0,
     parameter ctop_core16_pf5_sriov_vf_offset_position_nonari                       = 0,
     parameter ctop_core16_pf5_sriov_vf_stride_nonari                                = 0,
     parameter ctop_core16_pf5_subclass_code                                         = 0,
     parameter ctop_core16_pf5_subsys_dev_id                                         = 0,
     parameter ctop_core16_pf5_subsys_vendor_id                                      = 0,
     parameter ctop_core16_pf5_tph_req_cap_int_vec                                   = "DISABLE",
     parameter ctop_core16_pf5_tph_req_cap_int_vec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf5_tph_req_cap_st_table_loc_0_vfcomm_cs2                 = "CTOP_CORE16_PF5_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core16_pf5_tph_req_cap_st_table_loc_1                            = "CTOP_CORE16_PF5_NOT_IN_MSIX_TABLE",
     parameter ctop_core16_pf5_tph_req_cap_st_table_loc_1_vfcomm_cs2                 = "CTOP_CORE16_PF5_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core16_pf5_tph_req_cap_st_table_size                             = 0,
     parameter ctop_core16_pf5_tph_req_cap_st_table_size_vfcomm_cs2                  = 0,
     parameter ctop_core16_pf5_tph_req_device_spec                                   = "DISABLE",
     parameter ctop_core16_pf5_tph_req_device_spec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf6_acs_cap_acs_at_block                                  = "DISABLE",
     parameter ctop_core16_pf6_acs_cap_acs_direct_translated_p2p                     = "DISABLE",
     parameter ctop_core16_pf6_acs_cap_acs_egress_ctrl_size                          = 8,
     parameter ctop_core16_pf6_acs_cap_acs_p2p_cpl_redirect                          = "DISABLE",
     parameter ctop_core16_pf6_acs_cap_acs_p2p_egress_control                        = "DISABLE",
     parameter ctop_core16_pf6_acs_cap_acs_p2p_req_redirect                          = "DISABLE",
     parameter ctop_core16_pf6_acs_cap_acs_src_valid                                 = "DISABLE",
     parameter ctop_core16_pf6_acs_cap_acs_usp_forwarding                            = "DISABLE",
     parameter ctop_core16_pf6_bar0_prefetch                                         = "FALSE",
     parameter ctop_core16_pf6_bar0_type                                             = "CTOP_CORE16_PF6_BAR0_MEM32",
     parameter ctop_core16_pf6_bar1_prefetch                                         = "FALSE",
     parameter ctop_core16_pf6_bar2_prefetch                                         = "FALSE",
     parameter ctop_core16_pf6_bar2_type                                             = "CTOP_CORE16_PF6_BAR2_MEM32",
     parameter ctop_core16_pf6_bar3_prefetch                                         = "FALSE",
     parameter ctop_core16_pf6_bar4_prefetch                                         = "FALSE",
     parameter ctop_core16_pf6_bar4_type                                             = "CTOP_CORE16_PF6_BAR4_MEM32",
     parameter ctop_core16_pf6_bar5_prefetch                                         = "FALSE",
     parameter ctop_core16_pf6_base_class_code                                       = 255,
     parameter ctop_core16_pf6_int_pin                                               = "CTOP_CORE16_PF6_NO_INT",
     parameter ctop_core16_pf6_pasid_cap_execute_permission_supported                = "DISABLE",
     parameter ctop_core16_pf6_pasid_cap_max_pasid_width                             = 0,
     parameter ctop_core16_pf6_pasid_cap_privileged_mode_supported                   = "DISABLE",
     parameter ctop_core16_pf6_pci_msi_64_bit_addr_cap                               = "FALSE",
     parameter ctop_core16_pf6_pci_msi_ext_data_cap                                  = "FALSE",
     parameter ctop_core16_pf6_pci_msi_multiple_msg_cap                              = "CTOP_CORE16_PF6_MSI_VEC_1",
     parameter ctop_core16_pf6_pci_msix_bir                                          = 0,
     parameter ctop_core16_pf6_pci_msix_pba                                          = 0,
     parameter ctop_core16_pf6_pci_msix_pba_offset                                   = 0,
     parameter ctop_core16_pf6_pci_msix_table_offset                                 = 0,
     parameter ctop_core16_pf6_pci_msix_table_size                                   = 0,
     parameter ctop_core16_pf6_pci_msix_table_size_vfcomm_cs2                        = 0,
     parameter ctop_core16_pf6_pci_type0_bar0_enabled                                = "DISABLE",
     parameter ctop_core16_pf6_pci_type0_bar1_enabled                                = "DISABLE",
     parameter ctop_core16_pf6_pci_type0_bar2_enabled                                = "DISABLE",
     parameter ctop_core16_pf6_pci_type0_bar3_enabled                                = "DISABLE",
     parameter ctop_core16_pf6_pci_type0_bar4_enabled                                = "DISABLE",
     parameter ctop_core16_pf6_pci_type0_bar5_enabled                                = "DISABLE",
     parameter ctop_core16_pf6_pci_type0_device_id                                   = 0,
     parameter ctop_core16_pf6_pci_type0_vendor_id                                   = 0,
     parameter ctop_core16_pf6_pcie_cap_ep_l0s_accpt_latency                         = 0,
     parameter ctop_core16_pf6_pcie_cap_ep_l1_accpt_latency                          = 0,
     parameter ctop_core16_pf6_pcie_cap_ext_tag_supp                                 = "CTOP_CORE16_PF6_NOT_SUPPORTED",
     parameter ctop_core16_pf6_pcie_cap_flr_cap                                      = "CTOP_CORE16_PF6_NOT_CAPABLE",
     parameter ctop_core16_pf6_pcie_cap_slot_clk_config                              = "FALSE",
     parameter ctop_core16_pf6_pme_support                                           = 0,
     parameter ctop_core16_pf6_program_interface                                     = 0,
     parameter ctop_core16_pf6_revision_id                                           = 0,
     parameter ctop_core16_pf6_rom_bar_enabled                                       = "DISABLE",
     parameter ctop_core16_pf6_shadow_sriov_vf_stride_ari_cs2                        = 0,
     parameter ctop_core16_pf6_sriov_sup_page_size                                   = "0",
     parameter ctop_core16_pf6_sriov_vf_bar0_prefetch                                = "FALSE",
     parameter ctop_core16_pf6_sriov_vf_bar0_type                                    = "CTOP_CORE16_PF6_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core16_pf6_sriov_vf_bar1_prefetch                                = "FALSE",
     parameter ctop_core16_pf6_sriov_vf_bar2_prefetch                                = "FALSE",
     parameter ctop_core16_pf6_sriov_vf_bar2_type                                    = "CTOP_CORE16_PF6_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core16_pf6_sriov_vf_bar3_prefetch                                = "FALSE",
     parameter ctop_core16_pf6_sriov_vf_bar4_prefetch                                = "FALSE",
     parameter ctop_core16_pf6_sriov_vf_bar4_type                                    = "CTOP_CORE16_PF6_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core16_pf6_sriov_vf_bar5_prefetch                                = "FALSE",
     parameter ctop_core16_pf6_sriov_vf_device_id                                    = 0,
     parameter ctop_core16_pf6_sriov_vf_offset_ari_cs2                               = 0,
     parameter ctop_core16_pf6_sriov_vf_offset_position_nonari                       = 0,
     parameter ctop_core16_pf6_sriov_vf_stride_nonari                                = 0,
     parameter ctop_core16_pf6_subclass_code                                         = 0,
     parameter ctop_core16_pf6_subsys_dev_id                                         = 0,
     parameter ctop_core16_pf6_subsys_vendor_id                                      = 0,
     parameter ctop_core16_pf6_tph_req_cap_int_vec                                   = "DISABLE",
     parameter ctop_core16_pf6_tph_req_cap_int_vec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf6_tph_req_cap_st_table_loc_0_vfcomm_cs2                 = "CTOP_CORE16_PF6_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core16_pf6_tph_req_cap_st_table_loc_1                            = "CTOP_CORE16_PF6_NOT_IN_MSIX_TABLE",
     parameter ctop_core16_pf6_tph_req_cap_st_table_loc_1_vfcomm_cs2                 = "CTOP_CORE16_PF6_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core16_pf6_tph_req_cap_st_table_size                             = 0,
     parameter ctop_core16_pf6_tph_req_cap_st_table_size_vfcomm_cs2                  = 0,
     parameter ctop_core16_pf6_tph_req_device_spec                                   = "DISABLE",
     parameter ctop_core16_pf6_tph_req_device_spec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf7_acs_cap_acs_at_block                                  = "DISABLE",
     parameter ctop_core16_pf7_acs_cap_acs_direct_translated_p2p                     = "DISABLE",
     parameter ctop_core16_pf7_acs_cap_acs_egress_ctrl_size                          = 8,
     parameter ctop_core16_pf7_acs_cap_acs_p2p_cpl_redirect                          = "DISABLE",
     parameter ctop_core16_pf7_acs_cap_acs_p2p_egress_control                        = "DISABLE",
     parameter ctop_core16_pf7_acs_cap_acs_p2p_req_redirect                          = "DISABLE",
     parameter ctop_core16_pf7_acs_cap_acs_src_valid                                 = "DISABLE",
     parameter ctop_core16_pf7_acs_cap_acs_usp_forwarding                            = "DISABLE",
     parameter ctop_core16_pf7_bar0_prefetch                                         = "FALSE",
     parameter ctop_core16_pf7_bar0_type                                             = "CTOP_CORE16_PF7_BAR0_MEM32",
     parameter ctop_core16_pf7_bar1_prefetch                                         = "FALSE",
     parameter ctop_core16_pf7_bar2_prefetch                                         = "FALSE",
     parameter ctop_core16_pf7_bar2_type                                             = "CTOP_CORE16_PF7_BAR2_MEM32",
     parameter ctop_core16_pf7_bar3_prefetch                                         = "FALSE",
     parameter ctop_core16_pf7_bar4_prefetch                                         = "FALSE",
     parameter ctop_core16_pf7_bar4_type                                             = "CTOP_CORE16_PF7_BAR4_MEM32",
     parameter ctop_core16_pf7_bar5_prefetch                                         = "FALSE",
     parameter ctop_core16_pf7_base_class_code                                       = 255,
     parameter ctop_core16_pf7_int_pin                                               = "CTOP_CORE16_PF7_NO_INT",
     parameter ctop_core16_pf7_pasid_cap_execute_permission_supported                = "DISABLE",
     parameter ctop_core16_pf7_pasid_cap_max_pasid_width                             = 0,
     parameter ctop_core16_pf7_pasid_cap_privileged_mode_supported                   = "DISABLE",
     parameter ctop_core16_pf7_pci_msi_64_bit_addr_cap                               = "FALSE",
     parameter ctop_core16_pf7_pci_msi_ext_data_cap                                  = "FALSE",
     parameter ctop_core16_pf7_pci_msi_multiple_msg_cap                              = "CTOP_CORE16_PF7_MSI_VEC_1",
     parameter ctop_core16_pf7_pci_msix_bir                                          = 0,
     parameter ctop_core16_pf7_pci_msix_pba                                          = 0,
     parameter ctop_core16_pf7_pci_msix_pba_offset                                   = 0,
     parameter ctop_core16_pf7_pci_msix_table_offset                                 = 0,
     parameter ctop_core16_pf7_pci_msix_table_size                                   = 0,
     parameter ctop_core16_pf7_pci_msix_table_size_vfcomm_cs2                        = 0,
     parameter ctop_core16_pf7_pci_type0_bar0_enabled                                = "DISABLE",
     parameter ctop_core16_pf7_pci_type0_bar1_enabled                                = "DISABLE",
     parameter ctop_core16_pf7_pci_type0_bar2_enabled                                = "DISABLE",
     parameter ctop_core16_pf7_pci_type0_bar3_enabled                                = "DISABLE",
     parameter ctop_core16_pf7_pci_type0_bar4_enabled                                = "DISABLE",
     parameter ctop_core16_pf7_pci_type0_bar5_enabled                                = "DISABLE",
     parameter ctop_core16_pf7_pci_type0_device_id                                   = 0,
     parameter ctop_core16_pf7_pci_type0_vendor_id                                   = 0,
     parameter ctop_core16_pf7_pcie_cap_ep_l0s_accpt_latency                         = 0,
     parameter ctop_core16_pf7_pcie_cap_ep_l1_accpt_latency                          = 0,
     parameter ctop_core16_pf7_pcie_cap_ext_tag_supp                                 = "CTOP_CORE16_PF7_NOT_SUPPORTED",
     parameter ctop_core16_pf7_pcie_cap_flr_cap                                      = "CTOP_CORE16_PF7_NOT_CAPABLE",
     parameter ctop_core16_pf7_pcie_cap_slot_clk_config                              = "FALSE",
     parameter ctop_core16_pf7_pme_support                                           = 0,
     parameter ctop_core16_pf7_program_interface                                     = 0,
     parameter ctop_core16_pf7_revision_id                                           = 0,
     parameter ctop_core16_pf7_rom_bar_enabled                                       = "DISABLE",
     parameter ctop_core16_pf7_shadow_sriov_vf_stride_ari_cs2                        = 0,
     parameter ctop_core16_pf7_sriov_sup_page_size                                   = "0",
     parameter ctop_core16_pf7_sriov_vf_bar0_prefetch                                = "FALSE",
     parameter ctop_core16_pf7_sriov_vf_bar0_type                                    = "CTOP_CORE16_PF7_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core16_pf7_sriov_vf_bar1_prefetch                                = "FALSE",
     parameter ctop_core16_pf7_sriov_vf_bar2_prefetch                                = "FALSE",
     parameter ctop_core16_pf7_sriov_vf_bar2_type                                    = "CTOP_CORE16_PF7_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core16_pf7_sriov_vf_bar3_prefetch                                = "FALSE",
     parameter ctop_core16_pf7_sriov_vf_bar4_prefetch                                = "FALSE",
     parameter ctop_core16_pf7_sriov_vf_bar4_type                                    = "CTOP_CORE16_PF7_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core16_pf7_sriov_vf_bar5_prefetch                                = "FALSE",
     parameter ctop_core16_pf7_sriov_vf_device_id                                    = 0,
     parameter ctop_core16_pf7_sriov_vf_offset_ari_cs2                               = 0,
     parameter ctop_core16_pf7_sriov_vf_offset_position_nonari                       = 0,
     parameter ctop_core16_pf7_sriov_vf_stride_nonari                                = 0,
     parameter ctop_core16_pf7_subclass_code                                         = 0,
     parameter ctop_core16_pf7_subsys_dev_id                                         = 0,
     parameter ctop_core16_pf7_subsys_vendor_id                                      = 0,
     parameter ctop_core16_pf7_tph_req_cap_int_vec                                   = "DISABLE",
     parameter ctop_core16_pf7_tph_req_cap_int_vec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_pf7_tph_req_cap_st_table_loc_0_vfcomm_cs2                 = "CTOP_CORE16_PF7_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core16_pf7_tph_req_cap_st_table_loc_1                            = "CTOP_CORE16_PF7_NOT_IN_MSIX_TABLE",
     parameter ctop_core16_pf7_tph_req_cap_st_table_loc_1_vfcomm_cs2                 = "CTOP_CORE16_PF7_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core16_pf7_tph_req_cap_st_table_size                             = 0,
     parameter ctop_core16_pf7_tph_req_cap_st_table_size_vfcomm_cs2                  = 0,
     parameter ctop_core16_pf7_tph_req_device_spec                                   = "DISABLE",
     parameter ctop_core16_pf7_tph_req_device_spec_vfcomm_cs2                        = "DISABLE",
     parameter ctop_core16_rxbuf_limit_bypass                                        = 7,
     parameter ctop_core16_virtual_drop_vendor0_msg                                  = "FALSE",
     parameter ctop_core16_virtual_drop_vendor1_msg                                  = "FALSE",
     parameter ctop_core16_virtual_ep_native                                         = "CTOP_CORE16_NATIVE",
     parameter ctop_core16_virtual_link_rate                                         = "CTOP_CORE16_GEN4",
     parameter ctop_core16_virtual_link_width                                        = "CTOP_CORE16_X16",
     parameter ctop_core16_virtual_maxpayload_size                                   = "CTOP_CORE16_MAX_PAYLOAD_512",
     parameter ctop_core16_virtual_num_of_lanes                                      = "CTOP_CORE16_NUM_16",
     parameter ctop_core16_virtual_pf0_acs_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf0_ats_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf0_dlink_cap_enable                              = "ENABLE",
     parameter ctop_core16_virtual_pf0_exvf_acs_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf0_exvf_ats_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf0_exvf_msix_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf0_exvf_tph_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf0_exvf_virtio_en                                = "DISABLE",
     parameter ctop_core16_virtual_pf0_io_decode                                     = "CTOP_CORE16_IO32",
     parameter ctop_core16_virtual_pf0_ltr_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf0_msi_enable                                    = "DISABLE",
     parameter ctop_core16_virtual_pf0_msix_enable                                   = "DISABLE",
     parameter ctop_core16_virtual_pf0_pasid_cap_enable                              = "DISABLE",
     parameter ctop_core16_virtual_pf0_prefetch_decode                               = "CTOP_CORE16_PREF64",
     parameter ctop_core16_virtual_pf0_prs_ext_cap_enable                            = "DISABLE",
     parameter ctop_core16_virtual_pf0_ras_des_cap_enable                            = "DISABLE",
     parameter ctop_core16_virtual_pf0_sn_cap_enable                                 = "DISABLE",
     parameter ctop_core16_virtual_pf0_sriov_enable                                  = "DISABLE",
     parameter ctop_core16_virtual_pf0_sriov_vf_bar0_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf0_sriov_vf_bar1_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf0_sriov_vf_bar2_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf0_sriov_vf_bar3_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf0_sriov_vf_bar4_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf0_sriov_vf_bar5_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf0_tph_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf0_user_vsec_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf0_virtio_en                                     = "DISABLE",
     parameter ctop_core16_virtual_pf1_acs_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf1_ats_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf1_enable                                        = "DISABLE",
     parameter ctop_core16_virtual_pf1_exvf_acs_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf1_exvf_ats_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf1_exvf_msix_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf1_exvf_tph_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf1_exvf_virtio_en                                = "DISABLE",
     parameter ctop_core16_virtual_pf1_msi_enable                                    = "DISABLE",
     parameter ctop_core16_virtual_pf1_msix_enable                                   = "DISABLE",
     parameter ctop_core16_virtual_pf1_pasid_cap_enable                              = "DISABLE",
     parameter ctop_core16_virtual_pf1_prs_ext_cap_enable                            = "DISABLE",
     parameter ctop_core16_virtual_pf1_sriov_enable                                  = "DISABLE",
     parameter ctop_core16_virtual_pf1_sriov_vf_bar0_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf1_sriov_vf_bar1_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf1_sriov_vf_bar2_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf1_sriov_vf_bar3_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf1_sriov_vf_bar4_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf1_sriov_vf_bar5_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf1_tph_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf1_user_vsec_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf1_user_vsec_offset                              = "0",
     parameter ctop_core16_virtual_pf1_virtio_en                                     = "DISABLE",
     parameter ctop_core16_virtual_pf2_acs_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf2_ats_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf2_enable                                        = "DISABLE",
     parameter ctop_core16_virtual_pf2_exvf_acs_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf2_exvf_ats_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf2_exvf_msix_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf2_exvf_tph_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf2_exvf_virtio_en                                = "DISABLE",
     parameter ctop_core16_virtual_pf2_msi_enable                                    = "DISABLE",
     parameter ctop_core16_virtual_pf2_msix_enable                                   = "DISABLE",
     parameter ctop_core16_virtual_pf2_pasid_cap_enable                              = "DISABLE",
     parameter ctop_core16_virtual_pf2_prs_ext_cap_enable                            = "DISABLE",
     parameter ctop_core16_virtual_pf2_sriov_enable                                  = "DISABLE",
     parameter ctop_core16_virtual_pf2_sriov_vf_bar0_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf2_sriov_vf_bar1_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf2_sriov_vf_bar2_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf2_sriov_vf_bar3_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf2_sriov_vf_bar4_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf2_sriov_vf_bar5_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf2_tph_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf2_user_vsec_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf2_user_vsec_offset                              = "0",
     parameter ctop_core16_virtual_pf2_virtio_en                                     = "DISABLE",
     parameter ctop_core16_virtual_pf3_acs_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf3_ats_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf3_enable                                        = "DISABLE",
     parameter ctop_core16_virtual_pf3_exvf_acs_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf3_exvf_ats_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf3_exvf_msix_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf3_exvf_tph_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf3_exvf_virtio_en                                = "DISABLE",
     parameter ctop_core16_virtual_pf3_msi_enable                                    = "DISABLE",
     parameter ctop_core16_virtual_pf3_msix_enable                                   = "DISABLE",
     parameter ctop_core16_virtual_pf3_pasid_cap_enable                              = "DISABLE",
     parameter ctop_core16_virtual_pf3_prs_ext_cap_enable                            = "DISABLE",
     parameter ctop_core16_virtual_pf3_sriov_enable                                  = "DISABLE",
     parameter ctop_core16_virtual_pf3_sriov_vf_bar0_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf3_sriov_vf_bar1_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf3_sriov_vf_bar2_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf3_sriov_vf_bar3_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf3_sriov_vf_bar4_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf3_sriov_vf_bar5_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf3_tph_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf3_user_vsec_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf3_user_vsec_offset                              = "0",
     parameter ctop_core16_virtual_pf3_virtio_en                                     = "DISABLE",
     parameter ctop_core16_virtual_pf4_acs_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf4_ats_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf4_enable                                        = "DISABLE",
     parameter ctop_core16_virtual_pf4_exvf_acs_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf4_exvf_ats_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf4_exvf_msix_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf4_exvf_tph_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf4_exvf_virtio_en                                = "DISABLE",
     parameter ctop_core16_virtual_pf4_msi_enable                                    = "DISABLE",
     parameter ctop_core16_virtual_pf4_msix_enable                                   = "DISABLE",
     parameter ctop_core16_virtual_pf4_pasid_cap_enable                              = "DISABLE",
     parameter ctop_core16_virtual_pf4_prs_ext_cap_enable                            = "DISABLE",
     parameter ctop_core16_virtual_pf4_sriov_enable                                  = "DISABLE",
     parameter ctop_core16_virtual_pf4_sriov_vf_bar0_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf4_sriov_vf_bar1_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf4_sriov_vf_bar2_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf4_sriov_vf_bar3_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf4_sriov_vf_bar4_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf4_sriov_vf_bar5_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf4_tph_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf4_user_vsec_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf4_user_vsec_offset                              = "0",
     parameter ctop_core16_virtual_pf4_virtio_en                                     = "DISABLE",
     parameter ctop_core16_virtual_pf5_acs_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf5_ats_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf5_enable                                        = "DISABLE",
     parameter ctop_core16_virtual_pf5_exvf_acs_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf5_exvf_ats_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf5_exvf_msix_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf5_exvf_tph_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf5_exvf_virtio_en                                = "DISABLE",
     parameter ctop_core16_virtual_pf5_msi_enable                                    = "DISABLE",
     parameter ctop_core16_virtual_pf5_msix_enable                                   = "DISABLE",
     parameter ctop_core16_virtual_pf5_pasid_cap_enable                              = "DISABLE",
     parameter ctop_core16_virtual_pf5_prs_ext_cap_enable                            = "DISABLE",
     parameter ctop_core16_virtual_pf5_sriov_enable                                  = "DISABLE",
     parameter ctop_core16_virtual_pf5_sriov_vf_bar0_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf5_sriov_vf_bar1_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf5_sriov_vf_bar2_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf5_sriov_vf_bar3_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf5_sriov_vf_bar4_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf5_sriov_vf_bar5_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf5_tph_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf5_user_vsec_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf5_user_vsec_offset                              = "0",
     parameter ctop_core16_virtual_pf5_virtio_en                                     = "DISABLE",
     parameter ctop_core16_virtual_pf6_acs_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf6_ats_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf6_enable                                        = "DISABLE",
     parameter ctop_core16_virtual_pf6_exvf_acs_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf6_exvf_ats_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf6_exvf_msix_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf6_exvf_tph_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf6_exvf_virtio_en                                = "DISABLE",
     parameter ctop_core16_virtual_pf6_msi_enable                                    = "DISABLE",
     parameter ctop_core16_virtual_pf6_msix_enable                                   = "DISABLE",
     parameter ctop_core16_virtual_pf6_pasid_cap_enable                              = "DISABLE",
     parameter ctop_core16_virtual_pf6_prs_ext_cap_enable                            = "DISABLE",
     parameter ctop_core16_virtual_pf6_sriov_enable                                  = "DISABLE",
     parameter ctop_core16_virtual_pf6_sriov_vf_bar0_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf6_sriov_vf_bar1_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf6_sriov_vf_bar2_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf6_sriov_vf_bar3_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf6_sriov_vf_bar4_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf6_sriov_vf_bar5_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf6_tph_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf6_user_vsec_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf6_user_vsec_offset                              = "0",
     parameter ctop_core16_virtual_pf6_virtio_en                                     = "DISABLE",
     parameter ctop_core16_virtual_pf7_acs_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf7_ats_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf7_enable                                        = "DISABLE",
     parameter ctop_core16_virtual_pf7_exvf_acs_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf7_exvf_ats_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf7_exvf_msix_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf7_exvf_tph_cap_enable                           = "DISABLE",
     parameter ctop_core16_virtual_pf7_exvf_virtio_en                                = "DISABLE",
     parameter ctop_core16_virtual_pf7_msi_enable                                    = "DISABLE",
     parameter ctop_core16_virtual_pf7_msix_enable                                   = "DISABLE",
     parameter ctop_core16_virtual_pf7_pasid_cap_enable                              = "DISABLE",
     parameter ctop_core16_virtual_pf7_prs_ext_cap_enable                            = "DISABLE",
     parameter ctop_core16_virtual_pf7_sriov_enable                                  = "DISABLE",
     parameter ctop_core16_virtual_pf7_sriov_vf_bar0_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf7_sriov_vf_bar1_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf7_sriov_vf_bar2_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf7_sriov_vf_bar3_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf7_sriov_vf_bar4_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf7_sriov_vf_bar5_enabled                         = "DISABLE",
     parameter ctop_core16_virtual_pf7_tph_cap_enable                                = "DISABLE",
     parameter ctop_core16_virtual_pf7_user_vsec_cap_enable                          = "DISABLE",
     parameter ctop_core16_virtual_pf7_user_vsec_offset                              = "0",
     parameter ctop_core16_virtual_pf7_virtio_en                                     = "DISABLE",
     parameter ctop_core16_virtual_rp_ep_mode                                        = "CTOP_CORE16_EP",
     parameter ctop_core16_virtual_txeq_mode                                         = "CTOP_CORE16_EQ_FOM_MODE",
     parameter ctop_core16_virtual_ptm_autoupdate                                    = "CTOP_CORE16_AUTOUPDATE_DISABLE",
     parameter ctop_core16_vsec_next_offset                                          = "0",
     parameter ctop_core4_0_cvp_user_id                                              = 0,
     parameter ctop_core4_0_pf0_acs_cap_acs_at_block                                 = "DISABLE",
     parameter ctop_core4_0_pf0_acs_cap_acs_direct_translated_p2p                    = "DISABLE",
     parameter ctop_core4_0_pf0_acs_cap_acs_egress_ctrl_size                         = 8,
     parameter ctop_core4_0_pf0_acs_cap_acs_p2p_cpl_redirect                         = "DISABLE",
     parameter ctop_core4_0_pf0_acs_cap_acs_p2p_egress_control                       = "DISABLE",
     parameter ctop_core4_0_pf0_acs_cap_acs_p2p_req_redirect                         = "DISABLE",
     parameter ctop_core4_0_pf0_acs_cap_acs_src_valid                                = "DISABLE",
     parameter ctop_core4_0_pf0_acs_cap_acs_usp_forwarding                           = "DISABLE",
     parameter ctop_core4_0_pf0_auto_lane_flip_ctrl_en                               = "DISABLE",
     parameter ctop_core4_0_pf0_base_class_code                                      = 255,
     parameter ctop_core4_0_pf0_eq_redo                                              = "ENABLE",
     parameter ctop_core4_0_pf0_eq_redo_atg4                                         = "ENABLE",
     parameter ctop_core4_0_pf0_gen3_eq_pset_req_vec                                 = 4,
     parameter ctop_core4_0_pf0_gen3_eq_pset_req_vec_atg4                            = 624,
     parameter ctop_core4_0_pf0_loopback_enable                                      = "FALSE",
     parameter ctop_core4_0_pf0_pci_msix_bir                                         = 0,
     parameter ctop_core4_0_pf0_pci_msix_pba                                         = 0,
     parameter ctop_core4_0_pf0_pci_msix_pba_offset                                  = 0,
     parameter ctop_core4_0_pf0_pci_msix_table_offset                                = 0,
     parameter ctop_core4_0_pf0_pci_msix_table_size                                  = 0,
     parameter ctop_core4_0_pf0_pci_msix_table_size_vfcomm_cs2                       = 0,
     parameter ctop_core4_0_pf0_pci_type0_bar0_mask_31_1                             = 0,
     parameter ctop_core4_0_pf0_pci_type0_bar1_mask_31_1                             = 0,
     parameter ctop_core4_0_pf0_pci_type0_bar2_mask_31_1                             = 0,
     parameter ctop_core4_0_pf0_pci_type0_bar3_mask_31_1                             = 0,
     parameter ctop_core4_0_pf0_pci_type0_bar4_mask_31_1                             = 0,
     parameter ctop_core4_0_pf0_pci_type0_bar5_mask_31_1                             = 0,
     parameter ctop_core4_0_pf0_pci_type0_device_id                                  = 0,
     parameter ctop_core4_0_pf0_pci_type0_vendor_id                                  = 0,
     parameter ctop_core4_0_pf0_pcie_cap_attention_indicator                         = "FALSE",
     parameter ctop_core4_0_pf0_pcie_cap_attention_indicator_button                  = "FALSE",
     parameter ctop_core4_0_pf0_pcie_cap_electromech_interlock                       = "FALSE",
     parameter ctop_core4_0_pf0_pcie_cap_ep_l0s_accpt_latency                        = 0,
     parameter ctop_core4_0_pf0_pcie_cap_ep_l1_accpt_latency                         = 0,
     parameter ctop_core4_0_pf0_pcie_cap_ext_tag_supp                                = "CTOP_CORE4_0_PF0_NOT_SUPPORTED",
     parameter ctop_core4_0_pf0_pcie_cap_flr_cap                                     = "CTOP_CORE4_0_PF0_NOT_CAPABLE",
     parameter ctop_core4_0_pf0_pcie_cap_hot_plug_capable                            = "FALSE",
     parameter ctop_core4_0_pf0_pcie_cap_hot_plug_surprise                           = "FALSE",
     parameter ctop_core4_0_pf0_pcie_cap_mrl_sensor                                  = "FALSE",
     parameter ctop_core4_0_pf0_pcie_cap_no_cmd_cpl_support                          = "FALSE",
     parameter ctop_core4_0_pf0_pcie_cap_phy_slot_num                                = 0,
     parameter ctop_core4_0_pf0_pcie_cap_port_num                                    = 0,
     parameter ctop_core4_0_pf0_pcie_cap_power_controller                            = "FALSE",
     parameter ctop_core4_0_pf0_pcie_cap_power_indicator                             = "FALSE",
     parameter ctop_core4_0_pf0_pcie_cap_sel_deemphasis                              = "CTOP_CORE4_0_PF0_MINUS_6DB",
     parameter ctop_core4_0_pf0_pcie_cap_slot_clk_config                             = "FALSE",
     parameter ctop_core4_0_pf0_pcie_cap_slot_power_limit_scale                      = 0,
     parameter ctop_core4_0_pf0_pcie_cap_slot_power_limit_value                      = 0,
     parameter ctop_core4_0_pf0_pcie_slot_imp                                        = "CTOP_CORE4_0_PF0_NOT_IMPLEMENTED",
     parameter ctop_core4_0_pf0_pme_support                                          = 0,
     parameter ctop_core4_0_pf0_program_interface                                    = 0,
     parameter ctop_core4_0_pf0_revision_id                                          = 0,
     parameter ctop_core4_0_pf0_rom_bar_enabled                                      = "DISABLE",
     parameter ctop_core4_0_pf0_rp_rom_bar_enabled                                   = "DISABLE",
     parameter ctop_core4_0_pf0_subclass_code                                        = 0,
     parameter ctop_core4_0_pf0_subsys_dev_id                                        = 0,
     parameter ctop_core4_0_pf0_subsys_vendor_id                                     = 0,
     parameter ctop_core4_0_pf0_tph_req_cap_int_vec                                  = "DISABLE",
     parameter ctop_core4_0_pf0_tph_req_cap_int_vec_vfcomm_cs2                       = "DISABLE",
     parameter ctop_core4_0_pf0_tph_req_cap_st_table_loc_0_vfcomm_cs2                = "CTOP_CORE4_0_PF0_IN_TPH_STRUCT_VF",
     parameter ctop_core4_0_pf0_tph_req_cap_st_table_loc_1                           = "CTOP_CORE4_0_PF0_NOT_IN_MSIX_TABLE",
     parameter ctop_core4_0_pf0_tph_req_cap_st_table_size                            = 0,
     parameter ctop_core4_0_pf0_tph_req_cap_st_table_size_vfcomm_cs2                 = 1,
     parameter ctop_core4_0_pf0_tph_req_device_spec                                  = "DISABLE",
     parameter ctop_core4_0_pf0_tph_req_device_spec_vfcomm_cs2                       = "DISABLE",
     parameter ctop_core4_0_rxbuf_limit_bypass                                       = 0,
     parameter ctop_core4_0_vsec_next_offset                                         = "0",
     parameter ctop_core4_0_virtual_drop_vendor0_msg                                 = "FALSE",
     parameter ctop_core4_0_virtual_drop_vendor1_msg                                 = "FALSE",
     parameter ctop_core4_0_virtual_ep_native                                        = "CTOP_CORE4_0_NATIVE",
     parameter ctop_core4_0_virtual_link_rate                                        = "CTOP_CORE4_0_GEN1",
     parameter ctop_core4_0_virtual_maxpayload_size                                  = "CTOP_CORE4_0_MAX_PAYLOAD_128",
     parameter ctop_core4_0_virtual_num_of_lanes                                     = "CTOP_CORE4_0_NUM_1",
     parameter ctop_core4_0_virtual_pf0_acs_cap_enable                               = "DISABLE",
     parameter ctop_core4_0_virtual_pf0_dlink_cap_enable                             = "DISABLE",
     parameter ctop_core4_0_virtual_pf0_io_decode                                    = "CTOP_CORE4_0_IO32",
     parameter ctop_core4_0_virtual_pf0_msix_enable                                  = "DISABLE",
     parameter ctop_core4_0_virtual_pf0_pl16g_cap_enable                             = "DISABLE",
     parameter ctop_core4_0_virtual_pf0_prefetch_decode                              = "CTOP_CORE4_0_PREF64",
     parameter ctop_core4_0_virtual_pf0_prs_ext_cap_enable                           = "DISABLE",
     parameter ctop_core4_0_virtual_pf0_ras_des_cap_enable                           = "DISABLE",
     parameter ctop_core4_0_virtual_pf0_sn_cap_enable                                = "DISABLE",
     parameter ctop_core4_0_virtual_pf0_ats_cap_enable                               = "DISABLE",
     parameter ctop_core4_0_virtual_pf0_tph_cap_enable                               = "DISABLE",
     parameter ctop_core4_0_virtual_pf0_user_vsec_cap_enable                         = "DISABLE",
     parameter ctop_core4_0_virtual_rp_ep_mode                                       = "CTOP_CORE4_0_EP",
     parameter ctop_core4_0_virtual_txeq_mode                                        = "CTOP_CORE4_0_EQ_FOM_MODE",
     parameter ctop_core4_1_cvp_user_id                                              = 0,
     parameter ctop_core4_1_pf0_acs_cap_acs_at_block                                 = "DISABLE",
     parameter ctop_core4_1_pf0_acs_cap_acs_direct_translated_p2p                    = "DISABLE",
     parameter ctop_core4_1_pf0_acs_cap_acs_egress_ctrl_size                         = 8,
     parameter ctop_core4_1_pf0_acs_cap_acs_p2p_cpl_redirect                         = "DISABLE",
     parameter ctop_core4_1_pf0_acs_cap_acs_p2p_egress_control                       = "DISABLE",
     parameter ctop_core4_1_pf0_acs_cap_acs_p2p_req_redirect                         = "DISABLE",
     parameter ctop_core4_1_pf0_acs_cap_acs_src_valid                                = "DISABLE",
     parameter ctop_core4_1_pf0_acs_cap_acs_usp_forwarding                           = "DISABLE",
     parameter ctop_core4_1_pf0_auto_lane_flip_ctrl_en                               = "DISABLE",
     parameter ctop_core4_1_pf0_base_class_code                                      = 255,
     parameter ctop_core4_1_pf0_eq_redo                                              = "ENABLE",
     parameter ctop_core4_1_pf0_eq_redo_atg4                                         = "ENABLE",
     parameter ctop_core4_1_pf0_gen3_eq_pset_req_vec                                 = 4,
     parameter ctop_core4_1_pf0_gen3_eq_pset_req_vec_atg4                            = 624,
     parameter ctop_core4_1_pf0_loopback_enable                                      = "FALSE",
     parameter ctop_core4_1_pf0_pci_msix_bir                                         = 0,
     parameter ctop_core4_1_pf0_pci_msix_pba                                         = 0,
     parameter ctop_core4_1_pf0_pci_msix_pba_offset                                  = 0,
     parameter ctop_core4_1_pf0_pci_msix_table_offset                                = 0,
     parameter ctop_core4_1_pf0_pci_msix_table_size                                  = 0,
     parameter ctop_core4_1_pf0_pci_msix_table_size_vfcomm_cs2                       = 0,
     parameter ctop_core4_1_pf0_pci_type0_bar0_mask_31_1                             = 0,
     parameter ctop_core4_1_pf0_pci_type0_bar1_mask_31_1                             = 0,
     parameter ctop_core4_1_pf0_pci_type0_bar2_mask_31_1                             = 0,
     parameter ctop_core4_1_pf0_pci_type0_bar3_mask_31_1                             = 0,
     parameter ctop_core4_1_pf0_pci_type0_bar4_mask_31_1                             = 0,
     parameter ctop_core4_1_pf0_pci_type0_bar5_mask_31_1                             = 0,
     parameter ctop_core4_1_pf0_pci_type0_device_id                                  = 0,
     parameter ctop_core4_1_pf0_pci_type0_vendor_id                                  = 0,
     parameter ctop_core4_1_pf0_pcie_cap_attention_indicator                         = "FALSE",
     parameter ctop_core4_1_pf0_pcie_cap_attention_indicator_button                  = "FALSE",
     parameter ctop_core4_1_pf0_pcie_cap_electromech_interlock                       = "FALSE",
     parameter ctop_core4_1_pf0_pcie_cap_ep_l0s_accpt_latency                        = 0,
     parameter ctop_core4_1_pf0_pcie_cap_ep_l1_accpt_latency                         = 0,
     parameter ctop_core4_1_pf0_pcie_cap_ext_tag_supp                                = "CTOP_CORE4_1_PF0_NOT_SUPPORTED",
     parameter ctop_core4_1_pf0_pcie_cap_flr_cap                                     = "CTOP_CORE4_1_PF0_NOT_CAPABLE",
     parameter ctop_core4_1_pf0_pcie_cap_hot_plug_capable                            = "FALSE",
     parameter ctop_core4_1_pf0_pcie_cap_hot_plug_surprise                           = "FALSE",
     parameter ctop_core4_1_pf0_pcie_cap_mrl_sensor                                  = "FALSE",
     parameter ctop_core4_1_pf0_pcie_cap_no_cmd_cpl_support                          = "FALSE",
     parameter ctop_core4_1_pf0_pcie_cap_phy_slot_num                                = 0,
     parameter ctop_core4_1_pf0_pcie_cap_port_num                                    = 0,
     parameter ctop_core4_1_pf0_pcie_cap_power_controller                            = "FALSE",
     parameter ctop_core4_1_pf0_pcie_cap_power_indicator                             = "FALSE",
     parameter ctop_core4_1_pf0_pcie_cap_sel_deemphasis                              = "CTOP_CORE4_1_PF0_MINUS_6DB",
     parameter ctop_core4_1_pf0_pcie_cap_slot_clk_config                             = "FALSE",
     parameter ctop_core4_1_pf0_pcie_cap_slot_power_limit_scale                      = 0,
     parameter ctop_core4_1_pf0_pcie_cap_slot_power_limit_value                      = 0,
     parameter ctop_core4_1_pf0_pcie_slot_imp                                        = "CTOP_CORE4_1_PF0_NOT_IMPLEMENTED",
     parameter ctop_core4_1_pf0_pme_support                                          = 0,
     parameter ctop_core4_1_pf0_program_interface                                    = 0,
     parameter ctop_core4_1_pf0_revision_id                                          = 0,
     parameter ctop_core4_1_pf0_rom_bar_enabled                                      = "DISABLE",
     parameter ctop_core4_1_pf0_rp_rom_bar_enabled                                   = "DISABLE",
     parameter ctop_core4_1_pf0_subclass_code                                        = 0,
     parameter ctop_core4_1_pf0_subsys_dev_id                                        = 0,
     parameter ctop_core4_1_pf0_subsys_vendor_id                                     = 0,
     parameter ctop_core4_1_pf0_tph_req_cap_int_vec                                  = "DISABLE",
     parameter ctop_core4_1_pf0_tph_req_cap_int_vec_vfcomm_cs2                       = "DISABLE",
     parameter ctop_core4_1_pf0_tph_req_cap_st_table_loc_0_vfcomm_cs2                = "CTOP_CORE4_1_PF0_IN_TPH_STRUCT_VF",
     parameter ctop_core4_1_pf0_tph_req_cap_st_table_loc_1                           = "CTOP_CORE4_1_PF0_NOT_IN_MSIX_TABLE",
     parameter ctop_core4_1_pf0_tph_req_cap_st_table_size                            = 0,
     parameter ctop_core4_1_pf0_tph_req_cap_st_table_size_vfcomm_cs2                 = 1,
     parameter ctop_core4_1_pf0_tph_req_device_spec                                  = "DISABLE",
     parameter ctop_core4_1_pf0_tph_req_device_spec_vfcomm_cs2                       = "DISABLE",
     parameter ctop_core4_1_rxbuf_limit_bypass                                       = 0,
     parameter ctop_core4_1_vsec_next_offset                                         = "0",
     parameter ctop_core4_1_virtual_drop_vendor0_msg                                 = "FALSE",
     parameter ctop_core4_1_virtual_drop_vendor1_msg                                 = "FALSE",
     parameter ctop_core4_1_virtual_ep_native                                        = "CTOP_CORE4_1_NATIVE",
     parameter ctop_core4_1_virtual_link_rate                                        = "CTOP_CORE4_1_GEN1",
     parameter ctop_core4_1_virtual_maxpayload_size                                  = "CTOP_CORE4_1_MAX_PAYLOAD_128",
     parameter ctop_core4_1_virtual_num_of_lanes                                     = "CTOP_CORE4_1_NUM_1",
     parameter ctop_core4_1_virtual_pf0_acs_cap_enable                               = "DISABLE",
     parameter ctop_core4_1_virtual_pf0_dlink_cap_enable                             = "DISABLE",
     parameter ctop_core4_1_virtual_pf0_io_decode                                    = "CTOP_CORE4_1_IO32",
     parameter ctop_core4_1_virtual_pf0_msix_enable                                  = "DISABLE",
     parameter ctop_core4_1_virtual_pf0_pl16g_cap_enable                             = "DISABLE",
     parameter ctop_core4_1_virtual_pf0_prefetch_decode                              = "CTOP_CORE4_1_PREF64",
     parameter ctop_core4_1_virtual_pf0_prs_ext_cap_enable                           = "DISABLE",
     parameter ctop_core4_1_virtual_pf0_ras_des_cap_enable                           = "DISABLE",
     parameter ctop_core4_1_virtual_pf0_sn_cap_enable                                = "DISABLE",
     parameter ctop_core4_1_virtual_pf0_ats_cap_enable                               = "DISABLE",
     parameter ctop_core4_1_virtual_pf0_tph_cap_enable                               = "DISABLE",
     parameter ctop_core4_1_virtual_pf0_user_vsec_cap_enable                         = "DISABLE",
     parameter ctop_core4_1_virtual_rp_ep_mode                                       = "CTOP_CORE4_1_EP",
     parameter ctop_core4_1_virtual_txeq_mode                                        = "CTOP_CORE4_1_EQ_FOM_MODE",
     parameter ctop_core8_cvp_user_id                                                = 0,
     parameter ctop_core8_exvf_msix_tablesize_pf0                                    = 0,
     parameter ctop_core8_exvf_msix_tablesize_pf1                                    = 0,
     parameter ctop_core8_exvf_msix_tablesize_pf2                                    = 0,
     parameter ctop_core8_exvf_msix_tablesize_pf3                                    = 0,
     parameter ctop_core8_exvf_msix_tablesize_pf4                                    = 0,
     parameter ctop_core8_exvf_msix_tablesize_pf5                                    = 0,
     parameter ctop_core8_exvf_msix_tablesize_pf6                                    = 0,
     parameter ctop_core8_exvf_msix_tablesize_pf7                                    = 0,
     parameter ctop_core8_exvf_msixpba_bir_pf0                                       = 0,
     parameter ctop_core8_exvf_msixpba_bir_pf1                                       = 0,
     parameter ctop_core8_exvf_msixpba_bir_pf2                                       = 0,
     parameter ctop_core8_exvf_msixpba_bir_pf3                                       = 0,
     parameter ctop_core8_exvf_msixpba_bir_pf4                                       = 0,
     parameter ctop_core8_exvf_msixpba_bir_pf5                                       = 0,
     parameter ctop_core8_exvf_msixpba_bir_pf6                                       = 0,
     parameter ctop_core8_exvf_msixpba_bir_pf7                                       = 0,
     parameter ctop_core8_exvf_msixpba_offset_pf0                                    = 0,
     parameter ctop_core8_exvf_msixpba_offset_pf1                                    = 0,
     parameter ctop_core8_exvf_msixpba_offset_pf2                                    = 0,
     parameter ctop_core8_exvf_msixpba_offset_pf3                                    = 0,
     parameter ctop_core8_exvf_msixpba_offset_pf4                                    = 0,
     parameter ctop_core8_exvf_msixpba_offset_pf5                                    = 0,
     parameter ctop_core8_exvf_msixpba_offset_pf6                                    = 0,
     parameter ctop_core8_exvf_msixpba_offset_pf7                                    = 0,
     parameter ctop_core8_exvf_msixtable_bir_pf0                                     = 0,
     parameter ctop_core8_exvf_msixtable_bir_pf1                                     = 0,
     parameter ctop_core8_exvf_msixtable_bir_pf2                                     = 0,
     parameter ctop_core8_exvf_msixtable_bir_pf3                                     = 0,
     parameter ctop_core8_exvf_msixtable_bir_pf4                                     = 0,
     parameter ctop_core8_exvf_msixtable_bir_pf5                                     = 0,
     parameter ctop_core8_exvf_msixtable_bir_pf6                                     = 0,
     parameter ctop_core8_exvf_msixtable_bir_pf7                                     = 0,
     parameter ctop_core8_exvf_msixtable_offset_pf0                                  = 0,
     parameter ctop_core8_exvf_msixtable_offset_pf1                                  = 0,
     parameter ctop_core8_exvf_msixtable_offset_pf2                                  = 0,
     parameter ctop_core8_exvf_msixtable_offset_pf3                                  = 0,
     parameter ctop_core8_exvf_msixtable_offset_pf4                                  = 0,
     parameter ctop_core8_exvf_msixtable_offset_pf5                                  = 0,
     parameter ctop_core8_exvf_msixtable_offset_pf6                                  = 0,
     parameter ctop_core8_exvf_msixtable_offset_pf7                                  = 0,
     parameter ctop_core8_exvf_subsysid_pf0                                          = 0,
     parameter ctop_core8_exvf_subsysid_pf1                                          = 0,
     parameter ctop_core8_exvf_subsysid_pf2                                          = 0,
     parameter ctop_core8_exvf_subsysid_pf3                                          = 0,
     parameter ctop_core8_exvf_subsysid_pf4                                          = 0,
     parameter ctop_core8_exvf_subsysid_pf5                                          = 0,
     parameter ctop_core8_exvf_subsysid_pf6                                          = 0,
     parameter ctop_core8_exvf_subsysid_pf7                                          = 0,
     parameter ctop_core8_pf0_acs_cap_acs_at_block                                   = "DISABLE",
     parameter ctop_core8_pf0_acs_cap_acs_direct_translated_p2p                      = "DISABLE",
     parameter ctop_core8_pf0_acs_cap_acs_egress_ctrl_size                           = 8,
     parameter ctop_core8_pf0_acs_cap_acs_p2p_cpl_redirect                           = "DISABLE",
     parameter ctop_core8_pf0_acs_cap_acs_p2p_egress_control                         = "DISABLE",
     parameter ctop_core8_pf0_acs_cap_acs_p2p_req_redirect                           = "DISABLE",
     parameter ctop_core8_pf0_acs_cap_acs_src_valid                                  = "DISABLE",
     parameter ctop_core8_pf0_acs_cap_acs_usp_forwarding                             = "DISABLE",
     parameter ctop_core8_pf0_auto_lane_flip_ctrl_en                                 = "DISABLE",
     parameter ctop_core8_pf0_bar0_prefetch                                          = "FALSE",
     parameter ctop_core8_pf0_bar0_type                                              = "CTOP_CORE8_PF0_BAR0_MEM32",
     parameter ctop_core8_pf0_bar1_prefetch                                          = "FALSE",
     parameter ctop_core8_pf0_bar2_prefetch                                          = "FALSE",
     parameter ctop_core8_pf0_bar2_type                                              = "CTOP_CORE8_PF0_BAR2_MEM32",
     parameter ctop_core8_pf0_bar3_prefetch                                          = "FALSE",
     parameter ctop_core8_pf0_bar4_prefetch                                          = "FALSE",
     parameter ctop_core8_pf0_bar4_type                                              = "CTOP_CORE8_PF0_BAR4_MEM32",
     parameter ctop_core8_pf0_bar5_prefetch                                          = "FALSE",
     parameter ctop_core8_pf0_base_class_code                                        = 255,
     parameter ctop_core8_pf0_eq_redo                                                = "ENABLE",
     parameter ctop_core8_pf0_eq_redo_atg4                                           = "ENABLE",
     parameter ctop_core8_pf0_gen3_eq_pset_req_vec                                   = 4,
     parameter ctop_core8_pf0_gen3_eq_pset_req_vec_atg4                              = 624,
     parameter ctop_core8_pf0_int_pin                                                = "CTOP_CORE8_PF0_NO_INT",
     parameter ctop_core8_pf0_loopback_enable                                        = "FALSE",
     parameter ctop_core8_pf0_pasid_cap_execute_permission_supported                 = "DISABLE",
     parameter ctop_core8_pf0_pasid_cap_max_pasid_width                              = 0,
     parameter ctop_core8_pf0_pasid_cap_privileged_mode_supported                    = "DISABLE",
     parameter ctop_core8_pf0_pci_msi_64_bit_addr_cap                                = "FALSE",
     parameter ctop_core8_pf0_pci_msi_ext_data_cap                                   = "FALSE",
     parameter ctop_core8_pf0_pci_msi_multiple_msg_cap                               = "CTOP_CORE8_PF0_MSI_VEC_1",
     parameter ctop_core8_pf0_pci_msix_bir                                           = 0,
     parameter ctop_core8_pf0_pci_msix_pba                                           = 0,
     parameter ctop_core8_pf0_pci_msix_pba_offset                                    = 0,
     parameter ctop_core8_pf0_pci_msix_table_offset                                  = 0,
     parameter ctop_core8_pf0_pci_msix_table_size                                    = 0,
     parameter ctop_core8_pf0_pci_msix_table_size_vfcomm_cs2                         = 0,
     parameter ctop_core8_pf0_pci_type0_bar0_enabled                                 = "DISABLE",
     parameter ctop_core8_pf0_pci_type0_bar1_enabled                                 = "DISABLE",
     parameter ctop_core8_pf0_pci_type0_bar2_enabled                                 = "DISABLE",
     parameter ctop_core8_pf0_pci_type0_bar3_enabled                                 = "DISABLE",
     parameter ctop_core8_pf0_pci_type0_bar4_enabled                                 = "DISABLE",
     parameter ctop_core8_pf0_pci_type0_bar5_enabled                                 = "DISABLE",
     parameter ctop_core8_pf0_pci_type0_device_id                                    = 0,
     parameter ctop_core8_pf0_pci_type0_vendor_id                                    = 0,
     parameter ctop_core8_pf0_pcie_cap_attention_indicator                           = "FALSE",
     parameter ctop_core8_pf0_pcie_cap_attention_indicator_button                    = "FALSE",
     parameter ctop_core8_pf0_pcie_cap_electromech_interlock                         = "FALSE",
     parameter ctop_core8_pf0_pcie_cap_ep_l0s_accpt_latency                          = 0,
     parameter ctop_core8_pf0_pcie_cap_ep_l1_accpt_latency                           = 0,
     parameter ctop_core8_pf0_pcie_cap_ext_tag_supp                                  = "CTOP_CORE8_PF0_NOT_SUPPORTED",
     parameter ctop_core8_pf0_pcie_cap_flr_cap                                       = "CTOP_CORE8_PF0_NOT_CAPABLE",
     parameter ctop_core8_pf0_pcie_cap_hot_plug_capable                              = "FALSE",
     parameter ctop_core8_pf0_pcie_cap_hot_plug_surprise                             = "FALSE",
     parameter ctop_core8_pf0_pcie_cap_mrl_sensor                                    = "FALSE",
     parameter ctop_core8_pf0_pcie_cap_no_cmd_cpl_support                            = "FALSE",
     parameter ctop_core8_pf0_pcie_cap_phy_slot_num                                  = 0,
     parameter ctop_core8_pf0_pcie_cap_port_num                                      = 0,
     parameter ctop_core8_pf0_pcie_cap_power_controller                              = "FALSE",
     parameter ctop_core8_pf0_pcie_cap_power_indicator                               = "FALSE",
     parameter ctop_core8_pf0_pcie_cap_sel_deemphasis                                = "CTOP_CORE8_PF0_MINUS_6DB",
     parameter ctop_core8_pf0_pcie_cap_slot_clk_config                               = "FALSE",
     parameter ctop_core8_pf0_pcie_cap_slot_power_limit_scale                        = 0,
     parameter ctop_core8_pf0_pcie_cap_slot_power_limit_value                        = 0,
     parameter ctop_core8_pf0_pcie_slot_imp                                          = "CTOP_CORE8_PF0_NOT_IMPLEMENTED",
     parameter ctop_core8_pf0_pme_support                                            = 0,
     parameter ctop_core8_pf0_program_interface                                      = 0,
     parameter ctop_core8_pf0_revision_id                                            = 0,
     parameter ctop_core8_pf0_rom_bar_enabled                                        = "DISABLE",
     parameter ctop_core8_pf0_rp_rom_bar_enabled                                     = "DISABLE",
     parameter ctop_core8_pf0_shadow_sriov_vf_stride_ari_cs2                         = 0,
     parameter ctop_core8_pf0_sriov_sup_page_size                                    = "0",
     parameter ctop_core8_pf0_sriov_vf_bar0_prefetch                                 = "FALSE",
     parameter ctop_core8_pf0_sriov_vf_bar0_type                                     = "CTOP_CORE8_PF0_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core8_pf0_sriov_vf_bar1_prefetch                                 = "FALSE",
     parameter ctop_core8_pf0_sriov_vf_bar2_prefetch                                 = "FALSE",
     parameter ctop_core8_pf0_sriov_vf_bar2_type                                     = "CTOP_CORE8_PF0_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core8_pf0_sriov_vf_bar3_prefetch                                 = "FALSE",
     parameter ctop_core8_pf0_sriov_vf_bar4_prefetch                                 = "FALSE",
     parameter ctop_core8_pf0_sriov_vf_bar4_type                                     = "CTOP_CORE8_PF0_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core8_pf0_sriov_vf_bar5_prefetch                                 = "FALSE",
     parameter ctop_core8_pf0_sriov_vf_device_id                                     = 0,
     parameter ctop_core8_pf0_sriov_vf_offset_ari_cs2                                = 0,
     parameter ctop_core8_pf0_sriov_vf_offset_nonari                                 = 0,
     parameter ctop_core8_pf0_sriov_vf_stride_nonari                                 = 0,
     parameter ctop_core8_pf0_subclass_code                                          = 0,
     parameter ctop_core8_pf0_subsys_dev_id                                          = 0,
     parameter ctop_core8_pf0_subsys_vendor_id                                       = 0,
     parameter ctop_core8_pf0_tph_req_cap_int_vec                                    = "DISABLE",
     parameter ctop_core8_pf0_tph_req_cap_int_vec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf0_tph_req_cap_st_table_loc_0_vfcomm_cs2                  = "CTOP_CORE8_PF0_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core8_pf0_tph_req_cap_st_table_loc_1                             = "CTOP_CORE8_PF0_NOT_IN_MSIX_TABLE",
     parameter ctop_core8_pf0_tph_req_cap_st_table_loc_1_vfcomm_cs2                  = "CTOP_CORE8_PF0_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core8_pf0_tph_req_cap_st_table_size                              = 0,
     parameter ctop_core8_pf0_tph_req_cap_st_table_size_vfcomm_cs2                   = 0,
     parameter ctop_core8_pf0_tph_req_device_spec                                    = "DISABLE",
     parameter ctop_core8_pf0_tph_req_device_spec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf1_acs_cap_acs_at_block                                   = "DISABLE",
     parameter ctop_core8_pf1_acs_cap_acs_direct_translated_p2p                      = "DISABLE",
     parameter ctop_core8_pf1_acs_cap_acs_egress_ctrl_size                           = 8,
     parameter ctop_core8_pf1_acs_cap_acs_p2p_cpl_redirect                           = "DISABLE",
     parameter ctop_core8_pf1_acs_cap_acs_p2p_egress_control                         = "DISABLE",
     parameter ctop_core8_pf1_acs_cap_acs_p2p_req_redirect                           = "DISABLE",
     parameter ctop_core8_pf1_acs_cap_acs_src_valid                                  = "DISABLE",
     parameter ctop_core8_pf1_acs_cap_acs_usp_forwarding                             = "DISABLE",
     parameter ctop_core8_pf1_bar0_prefetch                                          = "FALSE",
     parameter ctop_core8_pf1_bar0_type                                              = "CTOP_CORE8_PF1_BAR0_MEM32",
     parameter ctop_core8_pf1_bar1_prefetch                                          = "FALSE",
     parameter ctop_core8_pf1_bar2_prefetch                                          = "FALSE",
     parameter ctop_core8_pf1_bar2_type                                              = "CTOP_CORE8_PF1_BAR2_MEM32",
     parameter ctop_core8_pf1_bar3_prefetch                                          = "FALSE",
     parameter ctop_core8_pf1_bar4_prefetch                                          = "FALSE",
     parameter ctop_core8_pf1_bar4_type                                              = "CTOP_CORE8_PF1_BAR4_MEM32",
     parameter ctop_core8_pf1_bar5_prefetch                                          = "FALSE",
     parameter ctop_core8_pf1_base_class_code                                        = 255,
     parameter ctop_core8_pf1_int_pin                                                = "CTOP_CORE8_PF1_NO_INT",
     parameter ctop_core8_pf1_pasid_cap_execute_permission_supported                 = "DISABLE",
     parameter ctop_core8_pf1_pasid_cap_max_pasid_width                              = 0,
     parameter ctop_core8_pf1_pasid_cap_privileged_mode_supported                    = "DISABLE",
     parameter ctop_core8_pf1_pci_msi_64_bit_addr_cap                                = "FALSE",
     parameter ctop_core8_pf1_pci_msi_ext_data_cap                                   = "FALSE",
     parameter ctop_core8_pf1_pci_msi_multiple_msg_cap                               = "CTOP_CORE8_PF1_MSI_VEC_1",
     parameter ctop_core8_pf1_pci_msix_bir                                           = 0,
     parameter ctop_core8_pf1_pci_msix_pba                                           = 0,
     parameter ctop_core8_pf1_pci_msix_pba_offset                                    = 0,
     parameter ctop_core8_pf1_pci_msix_table_offset                                  = 0,
     parameter ctop_core8_pf1_pci_msix_table_size                                    = 0,
     parameter ctop_core8_pf1_pci_msix_table_size_vfcomm_cs2                         = 0,
     parameter ctop_core8_pf1_pci_type0_bar0_enabled                                 = "DISABLE",
     parameter ctop_core8_pf1_pci_type0_bar1_enabled                                 = "DISABLE",
     parameter ctop_core8_pf1_pci_type0_bar2_enabled                                 = "DISABLE",
     parameter ctop_core8_pf1_pci_type0_bar3_enabled                                 = "DISABLE",
     parameter ctop_core8_pf1_pci_type0_bar4_enabled                                 = "DISABLE",
     parameter ctop_core8_pf1_pci_type0_bar5_enabled                                 = "DISABLE",
     parameter ctop_core8_pf1_pci_type0_device_id                                    = 0,
     parameter ctop_core8_pf1_pci_type0_vendor_id                                    = 0,
     parameter ctop_core8_pf1_pcie_cap_ep_l0s_accpt_latency                          = 0,
     parameter ctop_core8_pf1_pcie_cap_ep_l1_accpt_latency                           = 0,
     parameter ctop_core8_pf1_pcie_cap_ext_tag_supp                                  = "CTOP_CORE8_PF1_NOT_SUPPORTED",
     parameter ctop_core8_pf1_pcie_cap_flr_cap                                       = "CTOP_CORE8_PF1_NOT_CAPABLE",
     parameter ctop_core8_pf1_pcie_cap_slot_clk_config                               = "FALSE",
     parameter ctop_core8_pf1_pme_support                                            = 0,
     parameter ctop_core8_pf1_program_interface                                      = 0,
     parameter ctop_core8_pf1_revision_id                                            = 0,
     parameter ctop_core8_pf1_rom_bar_enabled                                        = "DISABLE",
     parameter ctop_core8_pf1_shadow_sriov_vf_stride_ari_cs2                         = 0,
     parameter ctop_core8_pf1_sriov_sup_page_size                                    = "0",
     parameter ctop_core8_pf1_sriov_vf_bar0_prefetch                                 = "FALSE",
     parameter ctop_core8_pf1_sriov_vf_bar0_type                                     = "CTOP_CORE8_PF1_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core8_pf1_sriov_vf_bar1_prefetch                                 = "FALSE",
     parameter ctop_core8_pf1_sriov_vf_bar2_prefetch                                 = "FALSE",
     parameter ctop_core8_pf1_sriov_vf_bar2_type                                     = "CTOP_CORE8_PF1_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core8_pf1_sriov_vf_bar3_prefetch                                 = "FALSE",
     parameter ctop_core8_pf1_sriov_vf_bar4_prefetch                                 = "FALSE",
     parameter ctop_core8_pf1_sriov_vf_bar4_type                                     = "CTOP_CORE8_PF1_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core8_pf1_sriov_vf_bar5_prefetch                                 = "FALSE",
     parameter ctop_core8_pf1_sriov_vf_device_id                                     = 0,
     parameter ctop_core8_pf1_sriov_vf_offset_ari_cs2                                = 0,
     parameter ctop_core8_pf1_sriov_vf_offset_position_nonari                        = 0,
     parameter ctop_core8_pf1_sriov_vf_stride_nonari                                 = 0,
     parameter ctop_core8_pf1_subclass_code                                          = 0,
     parameter ctop_core8_pf1_subsys_dev_id                                          = 0,
     parameter ctop_core8_pf1_subsys_vendor_id                                       = 0,
     parameter ctop_core8_pf1_tph_req_cap_int_vec                                    = "DISABLE",
     parameter ctop_core8_pf1_tph_req_cap_int_vec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf1_tph_req_cap_st_table_loc_0_vfcomm_cs2                  = "CTOP_CORE8_PF1_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core8_pf1_tph_req_cap_st_table_loc_1                             = "CTOP_CORE8_PF1_NOT_IN_MSIX_TABLE",
     parameter ctop_core8_pf1_tph_req_cap_st_table_loc_1_vfcomm_cs2                  = "CTOP_CORE8_PF1_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core8_pf1_tph_req_cap_st_table_size                              = 0,
     parameter ctop_core8_pf1_tph_req_cap_st_table_size_vfcomm_cs2                   = 0,
     parameter ctop_core8_pf1_tph_req_device_spec                                    = "DISABLE",
     parameter ctop_core8_pf1_tph_req_device_spec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf2_acs_cap_acs_at_block                                   = "DISABLE",
     parameter ctop_core8_pf2_acs_cap_acs_direct_translated_p2p                      = "DISABLE",
     parameter ctop_core8_pf2_acs_cap_acs_egress_ctrl_size                           = 8,
     parameter ctop_core8_pf2_acs_cap_acs_p2p_cpl_redirect                           = "DISABLE",
     parameter ctop_core8_pf2_acs_cap_acs_p2p_egress_control                         = "DISABLE",
     parameter ctop_core8_pf2_acs_cap_acs_p2p_req_redirect                           = "DISABLE",
     parameter ctop_core8_pf2_acs_cap_acs_src_valid                                  = "DISABLE",
     parameter ctop_core8_pf2_acs_cap_acs_usp_forwarding                             = "DISABLE",
     parameter ctop_core8_pf2_bar0_prefetch                                          = "FALSE",
     parameter ctop_core8_pf2_bar0_type                                              = "CTOP_CORE8_PF2_BAR0_MEM32",
     parameter ctop_core8_pf2_bar1_prefetch                                          = "FALSE",
     parameter ctop_core8_pf2_bar2_prefetch                                          = "FALSE",
     parameter ctop_core8_pf2_bar2_type                                              = "CTOP_CORE8_PF2_BAR2_MEM32",
     parameter ctop_core8_pf2_bar3_prefetch                                          = "FALSE",
     parameter ctop_core8_pf2_bar4_prefetch                                          = "FALSE",
     parameter ctop_core8_pf2_bar4_type                                              = "CTOP_CORE8_PF2_BAR4_MEM32",
     parameter ctop_core8_pf2_bar5_prefetch                                          = "FALSE",
     parameter ctop_core8_pf2_base_class_code                                        = 255,
     parameter ctop_core8_pf2_int_pin                                                = "CTOP_CORE8_PF2_NO_INT",
     parameter ctop_core8_pf2_pasid_cap_execute_permission_supported                 = "DISABLE",
     parameter ctop_core8_pf2_pasid_cap_max_pasid_width                              = 0,
     parameter ctop_core8_pf2_pasid_cap_privileged_mode_supported                    = "DISABLE",
     parameter ctop_core8_pf2_pci_msi_64_bit_addr_cap                                = "FALSE",
     parameter ctop_core8_pf2_pci_msi_ext_data_cap                                   = "FALSE",
     parameter ctop_core8_pf2_pci_msi_multiple_msg_cap                               = "CTOP_CORE8_PF2_MSI_VEC_1",
     parameter ctop_core8_pf2_pci_msix_bir                                           = 0,
     parameter ctop_core8_pf2_pci_msix_pba                                           = 0,
     parameter ctop_core8_pf2_pci_msix_pba_offset                                    = 0,
     parameter ctop_core8_pf2_pci_msix_table_offset                                  = 0,
     parameter ctop_core8_pf2_pci_msix_table_size                                    = 0,
     parameter ctop_core8_pf2_pci_msix_table_size_vfcomm_cs2                         = 0,
     parameter ctop_core8_pf2_pci_type0_bar0_enabled                                 = "DISABLE",
     parameter ctop_core8_pf2_pci_type0_bar1_enabled                                 = "DISABLE",
     parameter ctop_core8_pf2_pci_type0_bar2_enabled                                 = "DISABLE",
     parameter ctop_core8_pf2_pci_type0_bar3_enabled                                 = "DISABLE",
     parameter ctop_core8_pf2_pci_type0_bar4_enabled                                 = "DISABLE",
     parameter ctop_core8_pf2_pci_type0_bar5_enabled                                 = "DISABLE",
     parameter ctop_core8_pf2_pci_type0_device_id                                    = 0,
     parameter ctop_core8_pf2_pci_type0_vendor_id                                    = 0,
     parameter ctop_core8_pf2_pcie_cap_ep_l0s_accpt_latency                          = 0,
     parameter ctop_core8_pf2_pcie_cap_ep_l1_accpt_latency                           = 0,
     parameter ctop_core8_pf2_pcie_cap_ext_tag_supp                                  = "CTOP_CORE8_PF2_NOT_SUPPORTED",
     parameter ctop_core8_pf2_pcie_cap_flr_cap                                       = "CTOP_CORE8_PF2_NOT_CAPABLE",
     parameter ctop_core8_pf2_pcie_cap_slot_clk_config                               = "FALSE",
     parameter ctop_core8_pf2_pme_support                                            = 0,
     parameter ctop_core8_pf2_program_interface                                      = 0,
     parameter ctop_core8_pf2_revision_id                                            = 0,
     parameter ctop_core8_pf2_rom_bar_enabled                                        = "DISABLE",
     parameter ctop_core8_pf2_shadow_sriov_vf_stride_ari_cs2                         = 0,
     parameter ctop_core8_pf2_sriov_sup_page_size                                    = "0",
     parameter ctop_core8_pf2_sriov_vf_bar0_prefetch                                 = "FALSE",
     parameter ctop_core8_pf2_sriov_vf_bar0_type                                     = "CTOP_CORE8_PF2_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core8_pf2_sriov_vf_bar1_prefetch                                 = "FALSE",
     parameter ctop_core8_pf2_sriov_vf_bar2_prefetch                                 = "FALSE",
     parameter ctop_core8_pf2_sriov_vf_bar2_type                                     = "CTOP_CORE8_PF2_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core8_pf2_sriov_vf_bar3_prefetch                                 = "FALSE",
     parameter ctop_core8_pf2_sriov_vf_bar4_prefetch                                 = "FALSE",
     parameter ctop_core8_pf2_sriov_vf_bar4_type                                     = "CTOP_CORE8_PF2_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core8_pf2_sriov_vf_bar5_prefetch                                 = "FALSE",
     parameter ctop_core8_pf2_sriov_vf_device_id                                     = 0,
     parameter ctop_core8_pf2_sriov_vf_offset_ari_cs2                                = 0,
     parameter ctop_core8_pf2_sriov_vf_offset_position_nonari                        = 0,
     parameter ctop_core8_pf2_sriov_vf_stride_nonari                                 = 0,
     parameter ctop_core8_pf2_subclass_code                                          = 0,
     parameter ctop_core8_pf2_subsys_dev_id                                          = 0,
     parameter ctop_core8_pf2_subsys_vendor_id                                       = 0,
     parameter ctop_core8_pf2_tph_req_cap_int_vec                                    = "DISABLE",
     parameter ctop_core8_pf2_tph_req_cap_int_vec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf2_tph_req_cap_st_table_loc_0_vfcomm_cs2                  = "CTOP_CORE8_PF2_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core8_pf2_tph_req_cap_st_table_loc_1                             = "CTOP_CORE8_PF2_NOT_IN_MSIX_TABLE",
     parameter ctop_core8_pf2_tph_req_cap_st_table_loc_1_vfcomm_cs2                  = "CTOP_CORE8_PF2_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core8_pf2_tph_req_cap_st_table_size                              = 0,
     parameter ctop_core8_pf2_tph_req_cap_st_table_size_vfcomm_cs2                   = 0,
     parameter ctop_core8_pf2_tph_req_device_spec                                    = "DISABLE",
     parameter ctop_core8_pf2_tph_req_device_spec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf3_acs_cap_acs_at_block                                   = "DISABLE",
     parameter ctop_core8_pf3_acs_cap_acs_direct_translated_p2p                      = "DISABLE",
     parameter ctop_core8_pf3_acs_cap_acs_egress_ctrl_size                           = 8,
     parameter ctop_core8_pf3_acs_cap_acs_p2p_cpl_redirect                           = "DISABLE",
     parameter ctop_core8_pf3_acs_cap_acs_p2p_egress_control                         = "DISABLE",
     parameter ctop_core8_pf3_acs_cap_acs_p2p_req_redirect                           = "DISABLE",
     parameter ctop_core8_pf3_acs_cap_acs_src_valid                                  = "DISABLE",
     parameter ctop_core8_pf3_acs_cap_acs_usp_forwarding                             = "DISABLE",
     parameter ctop_core8_pf3_bar0_prefetch                                          = "FALSE",
     parameter ctop_core8_pf3_bar0_type                                              = "CTOP_CORE8_PF3_BAR0_MEM32",
     parameter ctop_core8_pf3_bar1_prefetch                                          = "FALSE",
     parameter ctop_core8_pf3_bar2_prefetch                                          = "FALSE",
     parameter ctop_core8_pf3_bar2_type                                              = "CTOP_CORE8_PF3_BAR2_MEM32",
     parameter ctop_core8_pf3_bar3_prefetch                                          = "FALSE",
     parameter ctop_core8_pf3_bar4_prefetch                                          = "FALSE",
     parameter ctop_core8_pf3_bar4_type                                              = "CTOP_CORE8_PF3_BAR4_MEM32",
     parameter ctop_core8_pf3_bar5_prefetch                                          = "FALSE",
     parameter ctop_core8_pf3_base_class_code                                        = 255,
     parameter ctop_core8_pf3_int_pin                                                = "CTOP_CORE8_PF3_NO_INT",
     parameter ctop_core8_pf3_pasid_cap_execute_permission_supported                 = "DISABLE",
     parameter ctop_core8_pf3_pasid_cap_max_pasid_width                              = 0,
     parameter ctop_core8_pf3_pasid_cap_privileged_mode_supported                    = "DISABLE",
     parameter ctop_core8_pf3_pci_msi_64_bit_addr_cap                                = "FALSE",
     parameter ctop_core8_pf3_pci_msi_ext_data_cap                                   = "FALSE",
     parameter ctop_core8_pf3_pci_msi_multiple_msg_cap                               = "CTOP_CORE8_PF3_MSI_VEC_1",
     parameter ctop_core8_pf3_pci_msix_bir                                           = 0,
     parameter ctop_core8_pf3_pci_msix_pba                                           = 0,
     parameter ctop_core8_pf3_pci_msix_pba_offset                                    = 0,
     parameter ctop_core8_pf3_pci_msix_table_offset                                  = 0,
     parameter ctop_core8_pf3_pci_msix_table_size                                    = 0,
     parameter ctop_core8_pf3_pci_msix_table_size_vfcomm_cs2                         = 0,
     parameter ctop_core8_pf3_pci_type0_bar0_enabled                                 = "DISABLE",
     parameter ctop_core8_pf3_pci_type0_bar1_enabled                                 = "DISABLE",
     parameter ctop_core8_pf3_pci_type0_bar2_enabled                                 = "DISABLE",
     parameter ctop_core8_pf3_pci_type0_bar3_enabled                                 = "DISABLE",
     parameter ctop_core8_pf3_pci_type0_bar4_enabled                                 = "DISABLE",
     parameter ctop_core8_pf3_pci_type0_bar5_enabled                                 = "DISABLE",
     parameter ctop_core8_pf3_pci_type0_device_id                                    = 0,
     parameter ctop_core8_pf3_pci_type0_vendor_id                                    = 0,
     parameter ctop_core8_pf3_pcie_cap_ep_l0s_accpt_latency                          = 0,
     parameter ctop_core8_pf3_pcie_cap_ep_l1_accpt_latency                           = 0,
     parameter ctop_core8_pf3_pcie_cap_ext_tag_supp                                  = "CTOP_CORE8_PF3_NOT_SUPPORTED",
     parameter ctop_core8_pf3_pcie_cap_flr_cap                                       = "CTOP_CORE8_PF3_NOT_CAPABLE",
     parameter ctop_core8_pf3_pcie_cap_slot_clk_config                               = "FALSE",
     parameter ctop_core8_pf3_pme_support                                            = 0,
     parameter ctop_core8_pf3_program_interface                                      = 0,
     parameter ctop_core8_pf3_revision_id                                            = 0,
     parameter ctop_core8_pf3_rom_bar_enabled                                        = "DISABLE",
     parameter ctop_core8_pf3_shadow_sriov_vf_stride_ari_cs2                         = 0,
     parameter ctop_core8_pf3_sriov_sup_page_size                                    = "0",
     parameter ctop_core8_pf3_sriov_vf_bar0_prefetch                                 = "FALSE",
     parameter ctop_core8_pf3_sriov_vf_bar0_type                                     = "CTOP_CORE8_PF3_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core8_pf3_sriov_vf_bar1_prefetch                                 = "FALSE",
     parameter ctop_core8_pf3_sriov_vf_bar2_prefetch                                 = "FALSE",
     parameter ctop_core8_pf3_sriov_vf_bar2_type                                     = "CTOP_CORE8_PF3_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core8_pf3_sriov_vf_bar3_prefetch                                 = "FALSE",
     parameter ctop_core8_pf3_sriov_vf_bar4_prefetch                                 = "FALSE",
     parameter ctop_core8_pf3_sriov_vf_bar4_type                                     = "CTOP_CORE8_PF3_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core8_pf3_sriov_vf_bar5_prefetch                                 = "FALSE",
     parameter ctop_core8_pf3_sriov_vf_device_id                                     = 0,
     parameter ctop_core8_pf3_sriov_vf_offset_ari_cs2                                = 0,
     parameter ctop_core8_pf3_sriov_vf_offset_position_nonari                        = 0,
     parameter ctop_core8_pf3_sriov_vf_stride_nonari                                 = 0,
     parameter ctop_core8_pf3_subclass_code                                          = 0,
     parameter ctop_core8_pf3_subsys_dev_id                                          = 0,
     parameter ctop_core8_pf3_subsys_vendor_id                                       = 0,
     parameter ctop_core8_pf3_tph_req_cap_int_vec                                    = "DISABLE",
     parameter ctop_core8_pf3_tph_req_cap_int_vec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf3_tph_req_cap_st_table_loc_0_vfcomm_cs2                  = "CTOP_CORE8_PF3_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core8_pf3_tph_req_cap_st_table_loc_1                             = "CTOP_CORE8_PF3_NOT_IN_MSIX_TABLE",
     parameter ctop_core8_pf3_tph_req_cap_st_table_loc_1_vfcomm_cs2                  = "CTOP_CORE8_PF3_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core8_pf3_tph_req_cap_st_table_size                              = 0,
     parameter ctop_core8_pf3_tph_req_cap_st_table_size_vfcomm_cs2                   = 0,
     parameter ctop_core8_pf3_tph_req_device_spec                                    = "DISABLE",
     parameter ctop_core8_pf3_tph_req_device_spec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf4_acs_cap_acs_at_block                                   = "DISABLE",
     parameter ctop_core8_pf4_acs_cap_acs_direct_translated_p2p                      = "DISABLE",
     parameter ctop_core8_pf4_acs_cap_acs_egress_ctrl_size                           = 8,
     parameter ctop_core8_pf4_acs_cap_acs_p2p_cpl_redirect                           = "DISABLE",
     parameter ctop_core8_pf4_acs_cap_acs_p2p_egress_control                         = "DISABLE",
     parameter ctop_core8_pf4_acs_cap_acs_p2p_req_redirect                           = "DISABLE",
     parameter ctop_core8_pf4_acs_cap_acs_src_valid                                  = "DISABLE",
     parameter ctop_core8_pf4_acs_cap_acs_usp_forwarding                             = "DISABLE",
     parameter ctop_core8_pf4_bar0_prefetch                                          = "FALSE",
     parameter ctop_core8_pf4_bar0_type                                              = "CTOP_CORE8_PF4_BAR0_MEM32",
     parameter ctop_core8_pf4_bar1_prefetch                                          = "FALSE",
     parameter ctop_core8_pf4_bar2_prefetch                                          = "FALSE",
     parameter ctop_core8_pf4_bar2_type                                              = "CTOP_CORE8_PF4_BAR2_MEM32",
     parameter ctop_core8_pf4_bar3_prefetch                                          = "FALSE",
     parameter ctop_core8_pf4_bar4_prefetch                                          = "FALSE",
     parameter ctop_core8_pf4_bar4_type                                              = "CTOP_CORE8_PF4_BAR4_MEM32",
     parameter ctop_core8_pf4_bar5_prefetch                                          = "FALSE",
     parameter ctop_core8_pf4_base_class_code                                        = 255,
     parameter ctop_core8_pf4_int_pin                                                = "CTOP_CORE8_PF4_NO_INT",
     parameter ctop_core8_pf4_pasid_cap_execute_permission_supported                 = "DISABLE",
     parameter ctop_core8_pf4_pasid_cap_max_pasid_width                              = 0,
     parameter ctop_core8_pf4_pasid_cap_privileged_mode_supported                    = "DISABLE",
     parameter ctop_core8_pf4_pci_msi_64_bit_addr_cap                                = "FALSE",
     parameter ctop_core8_pf4_pci_msi_ext_data_cap                                   = "FALSE",
     parameter ctop_core8_pf4_pci_msi_multiple_msg_cap                               = "CTOP_CORE8_PF4_MSI_VEC_1",
     parameter ctop_core8_pf4_pci_msix_bir                                           = 0,
     parameter ctop_core8_pf4_pci_msix_pba                                           = 0,
     parameter ctop_core8_pf4_pci_msix_pba_offset                                    = 0,
     parameter ctop_core8_pf4_pci_msix_table_offset                                  = 0,
     parameter ctop_core8_pf4_pci_msix_table_size                                    = 0,
     parameter ctop_core8_pf4_pci_msix_table_size_vfcomm_cs2                         = 0,
     parameter ctop_core8_pf4_pci_type0_bar0_enabled                                 = "DISABLE",
     parameter ctop_core8_pf4_pci_type0_bar1_enabled                                 = "DISABLE",
     parameter ctop_core8_pf4_pci_type0_bar2_enabled                                 = "DISABLE",
     parameter ctop_core8_pf4_pci_type0_bar3_enabled                                 = "DISABLE",
     parameter ctop_core8_pf4_pci_type0_bar4_enabled                                 = "DISABLE",
     parameter ctop_core8_pf4_pci_type0_bar5_enabled                                 = "DISABLE",
     parameter ctop_core8_pf4_pci_type0_device_id                                    = 0,
     parameter ctop_core8_pf4_pci_type0_vendor_id                                    = 0,
     parameter ctop_core8_pf4_pcie_cap_ep_l0s_accpt_latency                          = 0,
     parameter ctop_core8_pf4_pcie_cap_ep_l1_accpt_latency                           = 0,
     parameter ctop_core8_pf4_pcie_cap_ext_tag_supp                                  = "CTOP_CORE8_PF4_NOT_SUPPORTED",
     parameter ctop_core8_pf4_pcie_cap_flr_cap                                       = "CTOP_CORE8_PF4_NOT_CAPABLE",
     parameter ctop_core8_pf4_pcie_cap_slot_clk_config                               = "FALSE",
     parameter ctop_core8_pf4_pme_support                                            = 0,
     parameter ctop_core8_pf4_program_interface                                      = 0,
     parameter ctop_core8_pf4_revision_id                                            = 0,
     parameter ctop_core8_pf4_rom_bar_enabled                                        = "DISABLE",
     parameter ctop_core8_pf4_shadow_sriov_vf_stride_ari_cs2                         = 0,
     parameter ctop_core8_pf4_sriov_sup_page_size                                    = "0",
     parameter ctop_core8_pf4_sriov_vf_bar0_prefetch                                 = "FALSE",
     parameter ctop_core8_pf4_sriov_vf_bar0_type                                     = "CTOP_CORE8_PF4_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core8_pf4_sriov_vf_bar1_prefetch                                 = "FALSE",
     parameter ctop_core8_pf4_sriov_vf_bar2_prefetch                                 = "FALSE",
     parameter ctop_core8_pf4_sriov_vf_bar2_type                                     = "CTOP_CORE8_PF4_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core8_pf4_sriov_vf_bar3_prefetch                                 = "FALSE",
     parameter ctop_core8_pf4_sriov_vf_bar4_prefetch                                 = "FALSE",
     parameter ctop_core8_pf4_sriov_vf_bar4_type                                     = "CTOP_CORE8_PF4_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core8_pf4_sriov_vf_bar5_prefetch                                 = "FALSE",
     parameter ctop_core8_pf4_sriov_vf_device_id                                     = 0,
     parameter ctop_core8_pf4_sriov_vf_offset_ari_cs2                                = 0,
     parameter ctop_core8_pf4_sriov_vf_offset_position_nonari                        = 0,
     parameter ctop_core8_pf4_sriov_vf_stride_nonari                                 = 0,
     parameter ctop_core8_pf4_subclass_code                                          = 0,
     parameter ctop_core8_pf4_subsys_dev_id                                          = 0,
     parameter ctop_core8_pf4_subsys_vendor_id                                       = 0,
     parameter ctop_core8_pf4_tph_req_cap_int_vec                                    = "DISABLE",
     parameter ctop_core8_pf4_tph_req_cap_int_vec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf4_tph_req_cap_st_table_loc_0_vfcomm_cs2                  = "CTOP_CORE8_PF4_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core8_pf4_tph_req_cap_st_table_loc_1                             = "CTOP_CORE8_PF4_NOT_IN_MSIX_TABLE",
     parameter ctop_core8_pf4_tph_req_cap_st_table_loc_1_vfcomm_cs2                  = "CTOP_CORE8_PF4_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core8_pf4_tph_req_cap_st_table_size                              = 0,
     parameter ctop_core8_pf4_tph_req_cap_st_table_size_vfcomm_cs2                   = 0,
     parameter ctop_core8_pf4_tph_req_device_spec                                    = "DISABLE",
     parameter ctop_core8_pf4_tph_req_device_spec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf5_acs_cap_acs_at_block                                   = "DISABLE",
     parameter ctop_core8_pf5_acs_cap_acs_direct_translated_p2p                      = "DISABLE",
     parameter ctop_core8_pf5_acs_cap_acs_egress_ctrl_size                           = 8,
     parameter ctop_core8_pf5_acs_cap_acs_p2p_cpl_redirect                           = "DISABLE",
     parameter ctop_core8_pf5_acs_cap_acs_p2p_egress_control                         = "DISABLE",
     parameter ctop_core8_pf5_acs_cap_acs_p2p_req_redirect                           = "DISABLE",
     parameter ctop_core8_pf5_acs_cap_acs_src_valid                                  = "DISABLE",
     parameter ctop_core8_pf5_acs_cap_acs_usp_forwarding                             = "DISABLE",
     parameter ctop_core8_pf5_bar0_prefetch                                          = "FALSE",
     parameter ctop_core8_pf5_bar0_type                                              = "CTOP_CORE8_PF5_BAR0_MEM32",
     parameter ctop_core8_pf5_bar1_prefetch                                          = "FALSE",
     parameter ctop_core8_pf5_bar2_prefetch                                          = "FALSE",
     parameter ctop_core8_pf5_bar2_type                                              = "CTOP_CORE8_PF5_BAR2_MEM32",
     parameter ctop_core8_pf5_bar3_prefetch                                          = "FALSE",
     parameter ctop_core8_pf5_bar4_prefetch                                          = "FALSE",
     parameter ctop_core8_pf5_bar4_type                                              = "CTOP_CORE8_PF5_BAR4_MEM32",
     parameter ctop_core8_pf5_bar5_prefetch                                          = "FALSE",
     parameter ctop_core8_pf5_base_class_code                                        = 255,
     parameter ctop_core8_pf5_int_pin                                                = "CTOP_CORE8_PF5_NO_INT",
     parameter ctop_core8_pf5_pasid_cap_execute_permission_supported                 = "DISABLE",
     parameter ctop_core8_pf5_pasid_cap_max_pasid_width                              = 0,
     parameter ctop_core8_pf5_pasid_cap_privileged_mode_supported                    = "DISABLE",
     parameter ctop_core8_pf5_pci_msi_64_bit_addr_cap                                = "FALSE",
     parameter ctop_core8_pf5_pci_msi_ext_data_cap                                   = "FALSE",
     parameter ctop_core8_pf5_pci_msi_multiple_msg_cap                               = "CTOP_CORE8_PF5_MSI_VEC_1",
     parameter ctop_core8_pf5_pci_msix_bir                                           = 0,
     parameter ctop_core8_pf5_pci_msix_pba                                           = 0,
     parameter ctop_core8_pf5_pci_msix_pba_offset                                    = 0,
     parameter ctop_core8_pf5_pci_msix_table_offset                                  = 0,
     parameter ctop_core8_pf5_pci_msix_table_size                                    = 0,
     parameter ctop_core8_pf5_pci_msix_table_size_vfcomm_cs2                         = 0,
     parameter ctop_core8_pf5_pci_type0_bar0_enabled                                 = "DISABLE",
     parameter ctop_core8_pf5_pci_type0_bar1_enabled                                 = "DISABLE",
     parameter ctop_core8_pf5_pci_type0_bar2_enabled                                 = "DISABLE",
     parameter ctop_core8_pf5_pci_type0_bar3_enabled                                 = "DISABLE",
     parameter ctop_core8_pf5_pci_type0_bar4_enabled                                 = "DISABLE",
     parameter ctop_core8_pf5_pci_type0_bar5_enabled                                 = "DISABLE",
     parameter ctop_core8_pf5_pci_type0_device_id                                    = 0,
     parameter ctop_core8_pf5_pci_type0_vendor_id                                    = 0,
     parameter ctop_core8_pf5_pcie_cap_ep_l0s_accpt_latency                          = 0,
     parameter ctop_core8_pf5_pcie_cap_ep_l1_accpt_latency                           = 0,
     parameter ctop_core8_pf5_pcie_cap_ext_tag_supp                                  = "CTOP_CORE8_PF5_NOT_SUPPORTED",
     parameter ctop_core8_pf5_pcie_cap_flr_cap                                       = "CTOP_CORE8_PF5_NOT_CAPABLE",
     parameter ctop_core8_pf5_pcie_cap_slot_clk_config                               = "FALSE",
     parameter ctop_core8_pf5_pme_support                                            = 0,
     parameter ctop_core8_pf5_program_interface                                      = 0,
     parameter ctop_core8_pf5_revision_id                                            = 0,
     parameter ctop_core8_pf5_rom_bar_enabled                                        = "DISABLE",
     parameter ctop_core8_pf5_shadow_sriov_vf_stride_ari_cs2                         = 0,
     parameter ctop_core8_pf5_sriov_sup_page_size                                    = "0",
     parameter ctop_core8_pf5_sriov_vf_bar0_prefetch                                 = "FALSE",
     parameter ctop_core8_pf5_sriov_vf_bar0_type                                     = "CTOP_CORE8_PF5_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core8_pf5_sriov_vf_bar1_prefetch                                 = "FALSE",
     parameter ctop_core8_pf5_sriov_vf_bar2_prefetch                                 = "FALSE",
     parameter ctop_core8_pf5_sriov_vf_bar2_type                                     = "CTOP_CORE8_PF5_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core8_pf5_sriov_vf_bar3_prefetch                                 = "FALSE",
     parameter ctop_core8_pf5_sriov_vf_bar4_prefetch                                 = "FALSE",
     parameter ctop_core8_pf5_sriov_vf_bar4_type                                     = "CTOP_CORE8_PF5_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core8_pf5_sriov_vf_bar5_prefetch                                 = "FALSE",
     parameter ctop_core8_pf5_sriov_vf_device_id                                     = 0,
     parameter ctop_core8_pf5_sriov_vf_offset_ari_cs2                                = 0,
     parameter ctop_core8_pf5_sriov_vf_offset_position_nonari                        = 0,
     parameter ctop_core8_pf5_sriov_vf_stride_nonari                                 = 0,
     parameter ctop_core8_pf5_subclass_code                                          = 0,
     parameter ctop_core8_pf5_subsys_dev_id                                          = 0,
     parameter ctop_core8_pf5_subsys_vendor_id                                       = 0,
     parameter ctop_core8_pf5_tph_req_cap_int_vec                                    = "DISABLE",
     parameter ctop_core8_pf5_tph_req_cap_int_vec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf5_tph_req_cap_st_table_loc_0_vfcomm_cs2                  = "CTOP_CORE8_PF5_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core8_pf5_tph_req_cap_st_table_loc_1                             = "CTOP_CORE8_PF5_NOT_IN_MSIX_TABLE",
     parameter ctop_core8_pf5_tph_req_cap_st_table_loc_1_vfcomm_cs2                  = "CTOP_CORE8_PF5_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core8_pf5_tph_req_cap_st_table_size                              = 0,
     parameter ctop_core8_pf5_tph_req_cap_st_table_size_vfcomm_cs2                   = 0,
     parameter ctop_core8_pf5_tph_req_device_spec                                    = "DISABLE",
     parameter ctop_core8_pf5_tph_req_device_spec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf6_acs_cap_acs_at_block                                   = "DISABLE",
     parameter ctop_core8_pf6_acs_cap_acs_direct_translated_p2p                      = "DISABLE",
     parameter ctop_core8_pf6_acs_cap_acs_egress_ctrl_size                           = 8,
     parameter ctop_core8_pf6_acs_cap_acs_p2p_cpl_redirect                           = "DISABLE",
     parameter ctop_core8_pf6_acs_cap_acs_p2p_egress_control                         = "DISABLE",
     parameter ctop_core8_pf6_acs_cap_acs_p2p_req_redirect                           = "DISABLE",
     parameter ctop_core8_pf6_acs_cap_acs_src_valid                                  = "DISABLE",
     parameter ctop_core8_pf6_acs_cap_acs_usp_forwarding                             = "DISABLE",
     parameter ctop_core8_pf6_bar0_prefetch                                          = "FALSE",
     parameter ctop_core8_pf6_bar0_type                                              = "CTOP_CORE8_PF6_BAR0_MEM32",
     parameter ctop_core8_pf6_bar1_prefetch                                          = "FALSE",
     parameter ctop_core8_pf6_bar2_prefetch                                          = "FALSE",
     parameter ctop_core8_pf6_bar2_type                                              = "CTOP_CORE8_PF6_BAR2_MEM32",
     parameter ctop_core8_pf6_bar3_prefetch                                          = "FALSE",
     parameter ctop_core8_pf6_bar4_prefetch                                          = "FALSE",
     parameter ctop_core8_pf6_bar4_type                                              = "CTOP_CORE8_PF6_BAR4_MEM32",
     parameter ctop_core8_pf6_bar5_prefetch                                          = "FALSE",
     parameter ctop_core8_pf6_base_class_code                                        = 255,
     parameter ctop_core8_pf6_int_pin                                                = "CTOP_CORE8_PF6_NO_INT",
     parameter ctop_core8_pf6_pasid_cap_execute_permission_supported                 = "DISABLE",
     parameter ctop_core8_pf6_pasid_cap_max_pasid_width                              = 0,
     parameter ctop_core8_pf6_pasid_cap_privileged_mode_supported                    = "DISABLE",
     parameter ctop_core8_pf6_pci_msi_64_bit_addr_cap                                = "FALSE",
     parameter ctop_core8_pf6_pci_msi_ext_data_cap                                   = "FALSE",
     parameter ctop_core8_pf6_pci_msi_multiple_msg_cap                               = "CTOP_CORE8_PF6_MSI_VEC_1",
     parameter ctop_core8_pf6_pci_msix_bir                                           = 0,
     parameter ctop_core8_pf6_pci_msix_pba                                           = 0,
     parameter ctop_core8_pf6_pci_msix_pba_offset                                    = 0,
     parameter ctop_core8_pf6_pci_msix_table_offset                                  = 0,
     parameter ctop_core8_pf6_pci_msix_table_size                                    = 0,
     parameter ctop_core8_pf6_pci_msix_table_size_vfcomm_cs2                         = 0,
     parameter ctop_core8_pf6_pci_type0_bar0_enabled                                 = "DISABLE",
     parameter ctop_core8_pf6_pci_type0_bar1_enabled                                 = "DISABLE",
     parameter ctop_core8_pf6_pci_type0_bar2_enabled                                 = "DISABLE",
     parameter ctop_core8_pf6_pci_type0_bar3_enabled                                 = "DISABLE",
     parameter ctop_core8_pf6_pci_type0_bar4_enabled                                 = "DISABLE",
     parameter ctop_core8_pf6_pci_type0_bar5_enabled                                 = "DISABLE",
     parameter ctop_core8_pf6_pci_type0_device_id                                    = 0,
     parameter ctop_core8_pf6_pci_type0_vendor_id                                    = 0,
     parameter ctop_core8_pf6_pcie_cap_ep_l0s_accpt_latency                          = 0,
     parameter ctop_core8_pf6_pcie_cap_ep_l1_accpt_latency                           = 0,
     parameter ctop_core8_pf6_pcie_cap_ext_tag_supp                                  = "CTOP_CORE8_PF6_NOT_SUPPORTED",
     parameter ctop_core8_pf6_pcie_cap_flr_cap                                       = "CTOP_CORE8_PF6_NOT_CAPABLE",
     parameter ctop_core8_pf6_pcie_cap_slot_clk_config                               = "FALSE",
     parameter ctop_core8_pf6_pme_support                                            = 0,
     parameter ctop_core8_pf6_program_interface                                      = 0,
     parameter ctop_core8_pf6_revision_id                                            = 0,
     parameter ctop_core8_pf6_rom_bar_enabled                                        = "DISABLE",
     parameter ctop_core8_pf6_shadow_sriov_vf_stride_ari_cs2                         = 0,
     parameter ctop_core8_pf6_sriov_sup_page_size                                    = "0",
     parameter ctop_core8_pf6_sriov_vf_bar0_prefetch                                 = "FALSE",
     parameter ctop_core8_pf6_sriov_vf_bar0_type                                     = "CTOP_CORE8_PF6_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core8_pf6_sriov_vf_bar1_prefetch                                 = "FALSE",
     parameter ctop_core8_pf6_sriov_vf_bar2_prefetch                                 = "FALSE",
     parameter ctop_core8_pf6_sriov_vf_bar2_type                                     = "CTOP_CORE8_PF6_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core8_pf6_sriov_vf_bar3_prefetch                                 = "FALSE",
     parameter ctop_core8_pf6_sriov_vf_bar4_prefetch                                 = "FALSE",
     parameter ctop_core8_pf6_sriov_vf_bar4_type                                     = "CTOP_CORE8_PF6_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core8_pf6_sriov_vf_bar5_prefetch                                 = "FALSE",
     parameter ctop_core8_pf6_sriov_vf_device_id                                     = 0,
     parameter ctop_core8_pf6_sriov_vf_offset_ari_cs2                                = 0,
     parameter ctop_core8_pf6_sriov_vf_offset_position_nonari                        = 0,
     parameter ctop_core8_pf6_sriov_vf_stride_nonari                                 = 0,
     parameter ctop_core8_pf6_subclass_code                                          = 0,
     parameter ctop_core8_pf6_subsys_dev_id                                          = 0,
     parameter ctop_core8_pf6_subsys_vendor_id                                       = 0,
     parameter ctop_core8_pf6_tph_req_cap_int_vec                                    = "DISABLE",
     parameter ctop_core8_pf6_tph_req_cap_int_vec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf6_tph_req_cap_st_table_loc_0_vfcomm_cs2                  = "CTOP_CORE8_PF6_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core8_pf6_tph_req_cap_st_table_loc_1                             = "CTOP_CORE8_PF6_NOT_IN_MSIX_TABLE",
     parameter ctop_core8_pf6_tph_req_cap_st_table_loc_1_vfcomm_cs2                  = "CTOP_CORE8_PF6_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core8_pf6_tph_req_cap_st_table_size                              = 0,
     parameter ctop_core8_pf6_tph_req_cap_st_table_size_vfcomm_cs2                   = 0,
     parameter ctop_core8_pf6_tph_req_device_spec                                    = "DISABLE",
     parameter ctop_core8_pf6_tph_req_device_spec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf7_acs_cap_acs_at_block                                   = "DISABLE",
     parameter ctop_core8_pf7_acs_cap_acs_direct_translated_p2p                      = "DISABLE",
     parameter ctop_core8_pf7_acs_cap_acs_egress_ctrl_size                           = 8,
     parameter ctop_core8_pf7_acs_cap_acs_p2p_cpl_redirect                           = "DISABLE",
     parameter ctop_core8_pf7_acs_cap_acs_p2p_egress_control                         = "DISABLE",
     parameter ctop_core8_pf7_acs_cap_acs_p2p_req_redirect                           = "DISABLE",
     parameter ctop_core8_pf7_acs_cap_acs_src_valid                                  = "DISABLE",
     parameter ctop_core8_pf7_acs_cap_acs_usp_forwarding                             = "DISABLE",
     parameter ctop_core8_pf7_bar0_prefetch                                          = "FALSE",
     parameter ctop_core8_pf7_bar0_type                                              = "CTOP_CORE8_PF7_BAR0_MEM32",
     parameter ctop_core8_pf7_bar1_prefetch                                          = "FALSE",
     parameter ctop_core8_pf7_bar2_prefetch                                          = "FALSE",
     parameter ctop_core8_pf7_bar2_type                                              = "CTOP_CORE8_PF7_BAR2_MEM32",
     parameter ctop_core8_pf7_bar3_prefetch                                          = "FALSE",
     parameter ctop_core8_pf7_bar4_prefetch                                          = "FALSE",
     parameter ctop_core8_pf7_bar4_type                                              = "CTOP_CORE8_PF7_BAR4_MEM32",
     parameter ctop_core8_pf7_bar5_prefetch                                          = "FALSE",
     parameter ctop_core8_pf7_base_class_code                                        = 255,
     parameter ctop_core8_pf7_int_pin                                                = "CTOP_CORE8_PF7_NO_INT",
     parameter ctop_core8_pf7_pasid_cap_execute_permission_supported                 = "DISABLE",
     parameter ctop_core8_pf7_pasid_cap_max_pasid_width                              = 0,
     parameter ctop_core8_pf7_pasid_cap_privileged_mode_supported                    = "DISABLE",
     parameter ctop_core8_pf7_pci_msi_64_bit_addr_cap                                = "FALSE",
     parameter ctop_core8_pf7_pci_msi_ext_data_cap                                   = "FALSE",
     parameter ctop_core8_pf7_pci_msi_multiple_msg_cap                               = "CTOP_CORE8_PF7_MSI_VEC_1",
     parameter ctop_core8_pf7_pci_msix_bir                                           = 0,
     parameter ctop_core8_pf7_pci_msix_pba                                           = 0,
     parameter ctop_core8_pf7_pci_msix_pba_offset                                    = 0,
     parameter ctop_core8_pf7_pci_msix_table_offset                                  = 0,
     parameter ctop_core8_pf7_pci_msix_table_size                                    = 0,
     parameter ctop_core8_pf7_pci_msix_table_size_vfcomm_cs2                         = 0,
     parameter ctop_core8_pf7_pci_type0_bar0_enabled                                 = "DISABLE",
     parameter ctop_core8_pf7_pci_type0_bar1_enabled                                 = "DISABLE",
     parameter ctop_core8_pf7_pci_type0_bar2_enabled                                 = "DISABLE",
     parameter ctop_core8_pf7_pci_type0_bar3_enabled                                 = "DISABLE",
     parameter ctop_core8_pf7_pci_type0_bar4_enabled                                 = "DISABLE",
     parameter ctop_core8_pf7_pci_type0_bar5_enabled                                 = "DISABLE",
     parameter ctop_core8_pf7_pci_type0_device_id                                    = 0,
     parameter ctop_core8_pf7_pci_type0_vendor_id                                    = 0,
     parameter ctop_core8_pf7_pcie_cap_ep_l0s_accpt_latency                          = 0,
     parameter ctop_core8_pf7_pcie_cap_ep_l1_accpt_latency                           = 0,
     parameter ctop_core8_pf7_pcie_cap_ext_tag_supp                                  = "CTOP_CORE8_PF7_NOT_SUPPORTED",
     parameter ctop_core8_pf7_pcie_cap_flr_cap                                       = "CTOP_CORE8_PF7_NOT_CAPABLE",
     parameter ctop_core8_pf7_pcie_cap_slot_clk_config                               = "FALSE",
     parameter ctop_core8_pf7_pme_support                                            = 0,
     parameter ctop_core8_pf7_program_interface                                      = 0,
     parameter ctop_core8_pf7_revision_id                                            = 0,
     parameter ctop_core8_pf7_rom_bar_enabled                                        = "DISABLE",
     parameter ctop_core8_pf7_shadow_sriov_vf_stride_ari_cs2                         = 0,
     parameter ctop_core8_pf7_sriov_sup_page_size                                    = "0",
     parameter ctop_core8_pf7_sriov_vf_bar0_prefetch                                 = "FALSE",
     parameter ctop_core8_pf7_sriov_vf_bar0_type                                     = "CTOP_CORE8_PF7_SRIOV_VF_BAR0_MEM32",
     parameter ctop_core8_pf7_sriov_vf_bar1_prefetch                                 = "FALSE",
     parameter ctop_core8_pf7_sriov_vf_bar2_prefetch                                 = "FALSE",
     parameter ctop_core8_pf7_sriov_vf_bar2_type                                     = "CTOP_CORE8_PF7_SRIOV_VF_BAR2_MEM32",
     parameter ctop_core8_pf7_sriov_vf_bar3_prefetch                                 = "FALSE",
     parameter ctop_core8_pf7_sriov_vf_bar4_prefetch                                 = "FALSE",
     parameter ctop_core8_pf7_sriov_vf_bar4_type                                     = "CTOP_CORE8_PF7_SRIOV_VF_BAR4_MEM32",
     parameter ctop_core8_pf7_sriov_vf_bar5_prefetch                                 = "FALSE",
     parameter ctop_core8_pf7_sriov_vf_device_id                                     = 0,
     parameter ctop_core8_pf7_sriov_vf_offset_ari_cs2                                = 0,
     parameter ctop_core8_pf7_sriov_vf_offset_position_nonari                        = 0,
     parameter ctop_core8_pf7_sriov_vf_stride_nonari                                 = 0,
     parameter ctop_core8_pf7_subclass_code                                          = 0,
     parameter ctop_core8_pf7_subsys_dev_id                                          = 0,
     parameter ctop_core8_pf7_subsys_vendor_id                                       = 0,
     parameter ctop_core8_pf7_tph_req_cap_int_vec                                    = "DISABLE",
     parameter ctop_core8_pf7_tph_req_cap_int_vec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_pf7_tph_req_cap_st_table_loc_0_vfcomm_cs2                  = "CTOP_CORE8_PF7_NOT_IN_TPH_STRUCT_VF",
     parameter ctop_core8_pf7_tph_req_cap_st_table_loc_1                             = "CTOP_CORE8_PF7_NOT_IN_MSIX_TABLE",
     parameter ctop_core8_pf7_tph_req_cap_st_table_loc_1_vfcomm_cs2                  = "CTOP_CORE8_PF7_NOT_IN_MSIX_TABLE_VF",
     parameter ctop_core8_pf7_tph_req_cap_st_table_size                              = 0,
     parameter ctop_core8_pf7_tph_req_cap_st_table_size_vfcomm_cs2                   = 0,
     parameter ctop_core8_pf7_tph_req_device_spec                                    = "DISABLE",
     parameter ctop_core8_pf7_tph_req_device_spec_vfcomm_cs2                         = "DISABLE",
     parameter ctop_core8_rxbuf_limit_bypass                                         = 0,
     parameter ctop_core8_virtual_drop_vendor0_msg                                   = "FALSE",
     parameter ctop_core8_virtual_drop_vendor1_msg                                   = "FALSE",
     parameter ctop_core8_virtual_ep_native                                          = "CTOP_CORE8_NATIVE",
     parameter ctop_core8_virtual_link_rate                                          = "CTOP_CORE8_GEN1",
     parameter ctop_core8_virtual_link_width                                         = "CTOP_CORE8_X1",
     parameter ctop_core8_virtual_maxpayload_size                                    = "CTOP_CORE8_MAX_PAYLOAD_128",
     parameter ctop_core8_virtual_num_of_lanes                                       = "CTOP_CORE8_NUM_1",
     parameter ctop_core8_virtual_pf0_acs_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf0_ats_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf0_dlink_cap_enable                               = "DISABLE",
     parameter ctop_core8_virtual_pf0_exvf_acs_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf0_exvf_ats_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf0_exvf_msix_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf0_exvf_tph_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf0_exvf_virtio_en                                 = "DISABLE",
     parameter ctop_core8_virtual_pf0_io_decode                                      = "CTOP_CORE8_IO32",
     parameter ctop_core8_virtual_pf0_ltr_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf0_msi_enable                                     = "DISABLE",
     parameter ctop_core8_virtual_pf0_msix_enable                                    = "DISABLE",
     parameter ctop_core8_virtual_pf0_pasid_cap_enable                               = "DISABLE",
     parameter ctop_core8_virtual_pf0_prefetch_decode                                = "CTOP_CORE8_PREF64",
     parameter ctop_core8_virtual_pf0_prs_ext_cap_enable                             = "DISABLE",
     parameter ctop_core8_virtual_pf0_ras_des_cap_enable                             = "DISABLE",
     parameter ctop_core8_virtual_pf0_sn_cap_enable                                  = "DISABLE",
     parameter ctop_core8_virtual_pf0_sriov_enable                                   = "DISABLE",
     parameter ctop_core8_virtual_pf0_sriov_vf_bar0_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf0_sriov_vf_bar1_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf0_sriov_vf_bar2_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf0_sriov_vf_bar3_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf0_sriov_vf_bar4_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf0_sriov_vf_bar5_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf0_tph_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf0_user_vsec_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf0_virtio_en                                      = "DISABLE",
     parameter ctop_core8_virtual_pf1_acs_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf1_ats_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf1_enable                                         = "DISABLE",
     parameter ctop_core8_virtual_pf1_exvf_acs_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf1_exvf_ats_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf1_exvf_msix_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf1_exvf_tph_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf1_exvf_virtio_en                                 = "DISABLE",
     parameter ctop_core8_virtual_pf1_msi_enable                                     = "DISABLE",
     parameter ctop_core8_virtual_pf1_msix_enable                                    = "DISABLE",
     parameter ctop_core8_virtual_pf1_pasid_cap_enable                               = "DISABLE",
     parameter ctop_core8_virtual_pf1_prs_ext_cap_enable                             = "DISABLE",
     parameter ctop_core8_virtual_pf1_sriov_enable                                   = "DISABLE",
     parameter ctop_core8_virtual_pf1_sriov_vf_bar0_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf1_sriov_vf_bar1_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf1_sriov_vf_bar2_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf1_sriov_vf_bar3_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf1_sriov_vf_bar4_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf1_sriov_vf_bar5_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf1_tph_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf1_user_vsec_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf1_user_vsec_offset                               = "0",
     parameter ctop_core8_virtual_pf1_virtio_en                                      = "DISABLE",
     parameter ctop_core8_virtual_pf2_acs_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf2_ats_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf2_enable                                         = "DISABLE",
     parameter ctop_core8_virtual_pf2_exvf_acs_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf2_exvf_ats_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf2_exvf_msix_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf2_exvf_tph_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf2_exvf_virtio_en                                 = "DISABLE",
     parameter ctop_core8_virtual_pf2_msi_enable                                     = "DISABLE",
     parameter ctop_core8_virtual_pf2_msix_enable                                    = "DISABLE",
     parameter ctop_core8_virtual_pf2_pasid_cap_enable                               = "DISABLE",
     parameter ctop_core8_virtual_pf2_prs_ext_cap_enable                             = "DISABLE",
     parameter ctop_core8_virtual_pf2_sriov_enable                                   = "DISABLE",
     parameter ctop_core8_virtual_pf2_sriov_vf_bar0_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf2_sriov_vf_bar1_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf2_sriov_vf_bar2_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf2_sriov_vf_bar3_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf2_sriov_vf_bar4_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf2_sriov_vf_bar5_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf2_tph_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf2_user_vsec_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf2_user_vsec_offset                               = "0",
     parameter ctop_core8_virtual_pf2_virtio_en                                      = "DISABLE",
     parameter ctop_core8_virtual_pf3_acs_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf3_ats_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf3_enable                                         = "DISABLE",
     parameter ctop_core8_virtual_pf3_exvf_acs_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf3_exvf_ats_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf3_exvf_msix_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf3_exvf_tph_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf3_exvf_virtio_en                                 = "DISABLE",
     parameter ctop_core8_virtual_pf3_msi_enable                                     = "DISABLE",
     parameter ctop_core8_virtual_pf3_msix_enable                                    = "DISABLE",
     parameter ctop_core8_virtual_pf3_pasid_cap_enable                               = "DISABLE",
     parameter ctop_core8_virtual_pf3_prs_ext_cap_enable                             = "DISABLE",
     parameter ctop_core8_virtual_pf3_sriov_enable                                   = "DISABLE",
     parameter ctop_core8_virtual_pf3_sriov_vf_bar0_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf3_sriov_vf_bar1_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf3_sriov_vf_bar2_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf3_sriov_vf_bar3_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf3_sriov_vf_bar4_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf3_sriov_vf_bar5_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf3_tph_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf3_user_vsec_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf3_user_vsec_offset                               = "0",
     parameter ctop_core8_virtual_pf3_virtio_en                                      = "DISABLE",
     parameter ctop_core8_virtual_pf4_acs_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf4_ats_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf4_enable                                         = "DISABLE",
     parameter ctop_core8_virtual_pf4_exvf_acs_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf4_exvf_ats_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf4_exvf_msix_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf4_exvf_tph_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf4_exvf_virtio_en                                 = "DISABLE",
     parameter ctop_core8_virtual_pf4_msi_enable                                     = "DISABLE",
     parameter ctop_core8_virtual_pf4_msix_enable                                    = "DISABLE",
     parameter ctop_core8_virtual_pf4_pasid_cap_enable                               = "DISABLE",
     parameter ctop_core8_virtual_pf4_prs_ext_cap_enable                             = "DISABLE",
     parameter ctop_core8_virtual_pf4_sriov_enable                                   = "DISABLE",
     parameter ctop_core8_virtual_pf4_sriov_vf_bar0_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf4_sriov_vf_bar1_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf4_sriov_vf_bar2_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf4_sriov_vf_bar3_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf4_sriov_vf_bar4_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf4_sriov_vf_bar5_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf4_tph_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf4_user_vsec_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf4_user_vsec_offset                               = "0",
     parameter ctop_core8_virtual_pf4_virtio_en                                      = "DISABLE",
     parameter ctop_core8_virtual_pf5_acs_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf5_ats_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf5_enable                                         = "DISABLE",
     parameter ctop_core8_virtual_pf5_exvf_acs_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf5_exvf_ats_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf5_exvf_msix_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf5_exvf_tph_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf5_exvf_virtio_en                                 = "DISABLE",
     parameter ctop_core8_virtual_pf5_msi_enable                                     = "DISABLE",
     parameter ctop_core8_virtual_pf5_msix_enable                                    = "DISABLE",
     parameter ctop_core8_virtual_pf5_pasid_cap_enable                               = "DISABLE",
     parameter ctop_core8_virtual_pf5_prs_ext_cap_enable                             = "DISABLE",
     parameter ctop_core8_virtual_pf5_sriov_enable                                   = "DISABLE",
     parameter ctop_core8_virtual_pf5_sriov_vf_bar0_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf5_sriov_vf_bar1_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf5_sriov_vf_bar2_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf5_sriov_vf_bar3_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf5_sriov_vf_bar4_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf5_sriov_vf_bar5_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf5_tph_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf5_user_vsec_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf5_user_vsec_offset                               = "0",
     parameter ctop_core8_virtual_pf5_virtio_en                                      = "DISABLE",
     parameter ctop_core8_virtual_pf6_acs_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf6_ats_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf6_enable                                         = "DISABLE",
     parameter ctop_core8_virtual_pf6_exvf_acs_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf6_exvf_ats_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf6_exvf_msix_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf6_exvf_tph_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf6_exvf_virtio_en                                 = "DISABLE",
     parameter ctop_core8_virtual_pf6_msi_enable                                     = "DISABLE",
     parameter ctop_core8_virtual_pf6_msix_enable                                    = "DISABLE",
     parameter ctop_core8_virtual_pf6_pasid_cap_enable                               = "DISABLE",
     parameter ctop_core8_virtual_pf6_prs_ext_cap_enable                             = "DISABLE",
     parameter ctop_core8_virtual_pf6_sriov_enable                                   = "DISABLE",
     parameter ctop_core8_virtual_pf6_sriov_vf_bar0_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf6_sriov_vf_bar1_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf6_sriov_vf_bar2_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf6_sriov_vf_bar3_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf6_sriov_vf_bar4_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf6_sriov_vf_bar5_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf6_tph_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf6_user_vsec_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf6_user_vsec_offset                               = "0",
     parameter ctop_core8_virtual_pf6_virtio_en                                      = "DISABLE",
     parameter ctop_core8_virtual_pf7_acs_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf7_ats_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf7_enable                                         = "DISABLE",
     parameter ctop_core8_virtual_pf7_exvf_acs_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf7_exvf_ats_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf7_exvf_msix_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf7_exvf_tph_cap_enable                            = "DISABLE",
     parameter ctop_core8_virtual_pf7_exvf_virtio_en                                 = "DISABLE",
     parameter ctop_core8_virtual_pf7_msi_enable                                     = "DISABLE",
     parameter ctop_core8_virtual_pf7_msix_enable                                    = "DISABLE",
     parameter ctop_core8_virtual_pf7_pasid_cap_enable                               = "DISABLE",
     parameter ctop_core8_virtual_pf7_prs_ext_cap_enable                             = "DISABLE",
     parameter ctop_core8_virtual_pf7_sriov_enable                                   = "DISABLE",
     parameter ctop_core8_virtual_pf7_sriov_vf_bar0_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf7_sriov_vf_bar1_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf7_sriov_vf_bar2_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf7_sriov_vf_bar3_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf7_sriov_vf_bar4_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf7_sriov_vf_bar5_enabled                          = "DISABLE",
     parameter ctop_core8_virtual_pf7_tph_cap_enable                                 = "DISABLE",
     parameter ctop_core8_virtual_pf7_user_vsec_cap_enable                           = "DISABLE",
     parameter ctop_core8_virtual_pf7_user_vsec_offset                               = "0",
     parameter ctop_core8_virtual_pf7_virtio_en                                      = "DISABLE",
     parameter ctop_core8_virtual_rp_ep_mode                                         = "CTOP_CORE8_EP",
     parameter ctop_core8_virtual_txeq_mode                                          = "CTOP_CORE8_EQ_FOM_MODE",
     parameter ctop_core8_virtual_ptm_autoupdate                                     = "CTOP_CORE8_AUTOUPDATE_10MS",
     parameter ctop_core8_vsec_next_offset                                           = "0",
     parameter ctop_ctrltop_r_hrc_rst_ctrl_k_hrc_pin_perst_is_full_rst_attr          = "CTOP_CTRLTOP_R_HRC_RST_CTRL_K_HRC_PIN_PERST_IS_FULL_RST_ATTR_1",
     parameter ctop_virtual_ptm                                                      = "CTOP_DISABLED",
     parameter topology                                                              = "PCIE_X16",
     parameter virtual_sris_enable                                                   = "DISABLE_SRIS",
     parameter virtual_sup_mode                                                      = "USER_MODE",
     parameter virtual_tlp_bypass_en                                                 = "DISABLE_TLBP",


     parameter silicon_rev                                                           = "10nm8agdra",
     parameter generating_a0_hwtcl                                                   = 0,
     parameter generating_b0_hwtcl                                                   = 0,
     parameter generating_c0_hwtcl                                                   = 0,
     parameter duplex_mode                                                           = "ENABLE",
     parameter adapter_type_hwtcl                                                    = 0,

     parameter core16_enable_cpl_timeout_hwtcl                                       = 0,
     parameter core16_enable_pld_warm_rst_rdy_hwtcl                                  = 0,
     parameter core16_enable_10bit_tag_support_intf_hwtcl                            = 0,
     parameter core16_flr_cap_hwtcl                                                  = 0,
     parameter core8_enable_cpl_timeout_hwtcl                                        = 0,
     parameter core8_enable_pld_warm_rst_rdy_hwtcl                                   = 0,
     parameter core8_flr_cap_hwtcl                                                   = 0,
     parameter core4_0_enable_cpl_timeout_hwtcl                                      = 0,
     parameter core4_0_enable_pld_warm_rst_rdy_hwtcl                                 = 0,
     parameter core4_0_flr_cap_hwtcl                                                 = 0,
     parameter core4_1_enable_cpl_timeout_hwtcl                                      = 0,
     parameter core4_1_enable_pld_warm_rst_rdy_hwtcl                                 = 0,
     parameter core4_1_flr_cap_hwtcl                                                 = 0,
     parameter core16_enable_multi_func_hwtcl                                        = 0,
     parameter core8_enable_multi_func_hwtcl                                         = 0,

     parameter core16_enable_sriov_hwtcl                                             = 1,
     parameter core16_pf0_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core16_pf0_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core16_pf0_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core16_pf0_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core16_pf0_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core16_pf0_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core16_pf1_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core16_pf1_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core16_pf1_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core16_pf1_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core16_pf1_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core16_pf1_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core16_pf2_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core16_pf2_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core16_pf2_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core16_pf2_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core16_pf2_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core16_pf2_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core16_pf3_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core16_pf3_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core16_pf3_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core16_pf3_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core16_pf3_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core16_pf3_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core16_pf4_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core16_pf4_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core16_pf4_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core16_pf4_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core16_pf4_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core16_pf4_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core16_pf5_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core16_pf5_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core16_pf5_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core16_pf5_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core16_pf5_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core16_pf5_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core16_pf6_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core16_pf6_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core16_pf6_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core16_pf6_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core16_pf6_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core16_pf6_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core16_pf7_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core16_pf7_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core16_pf7_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core16_pf7_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core16_pf7_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core16_pf7_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core8_enable_sriov_hwtcl                                             = 1,
     parameter core8_pf0_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core8_pf0_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core8_pf0_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core8_pf0_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core8_pf0_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core8_pf0_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core8_pf1_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core8_pf1_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core8_pf1_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core8_pf1_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core8_pf1_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core8_pf1_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core8_pf2_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core8_pf2_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core8_pf2_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core8_pf2_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core8_pf2_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core8_pf2_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core8_pf3_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core8_pf3_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core8_pf3_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core8_pf3_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core8_pf3_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core8_pf3_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core8_pf4_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core8_pf4_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core8_pf4_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core8_pf4_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core8_pf4_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core8_pf4_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core8_pf5_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core8_pf5_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core8_pf5_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core8_pf5_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core8_pf5_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core8_pf5_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core8_pf6_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core8_pf6_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core8_pf6_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core8_pf6_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core8_pf6_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core8_pf6_sriov_vf_bar5_address_width_hwtcl                          = 20,
     parameter core8_pf7_sriov_vf_bar0_address_width_hwtcl                          = 20,
     parameter core8_pf7_sriov_vf_bar1_address_width_hwtcl                          = 20,
     parameter core8_pf7_sriov_vf_bar2_address_width_hwtcl                          = 20,
     parameter core8_pf7_sriov_vf_bar3_address_width_hwtcl                          = 20,
     parameter core8_pf7_sriov_vf_bar4_address_width_hwtcl                          = 20,
     parameter core8_pf7_sriov_vf_bar5_address_width_hwtcl                          = 20

     )(
       //Serial ports
       input                                                                              rx_n_in0, 
       input                                                                              rx_n_in1, 
       input                                                                              rx_n_in2, 
       input                                                                              rx_n_in3, 
       input                                                                              rx_n_in4, 
       input                                                                              rx_n_in5, 
       input                                                                              rx_n_in6, 
       input                                                                              rx_n_in7, 
       input                                                                              rx_n_in8, 
       input                                                                              rx_n_in9, 
       input                                                                              rx_n_in10, 
       input                                                                              rx_n_in11, 
       input                                                                              rx_n_in12, 
       input                                                                              rx_n_in13, 
       input                                                                              rx_n_in14, 
       input                                                                              rx_n_in15, 
       input                                                                              rx_p_in0, 
       input                                                                              rx_p_in1, 
       input                                                                              rx_p_in2, 
       input                                                                              rx_p_in3, 
       input                                                                              rx_p_in4, 
       input                                                                              rx_p_in5, 
       input                                                                              rx_p_in6, 
       input                                                                              rx_p_in7, 
       input                                                                              rx_p_in8, 
       input                                                                              rx_p_in9, 
       input                                                                              rx_p_in10, 
       input                                                                              rx_p_in11, 
       input                                                                              rx_p_in12, 
       input                                                                              rx_p_in13, 
       input                                                                              rx_p_in14, 
       input                                                                              rx_p_in15, 
       output                                                                             tx_n_out0, 
       output                                                                             tx_n_out1, 
       output                                                                             tx_n_out2, 
       output                                                                             tx_n_out3, 
       output                                                                             tx_n_out4, 
       output                                                                             tx_n_out5, 
       output                                                                             tx_n_out6, 
       output                                                                             tx_n_out7, 
       output                                                                             tx_n_out8, 
       output                                                                             tx_n_out9, 
       output                                                                             tx_n_out10, 
       output                                                                             tx_n_out11, 
       output                                                                             tx_n_out12, 
       output                                                                             tx_n_out13, 
       output                                                                             tx_n_out14, 
       output                                                                             tx_n_out15, 
       output                                                                             tx_p_out0, 
       output                                                                             tx_p_out1, 
       output                                                                             tx_p_out2, 
       output                                                                             tx_p_out3, 
       output                                                                             tx_p_out4, 
       output                                                                             tx_p_out5, 
       output                                                                             tx_p_out6, 
       output                                                                             tx_p_out7, 
       output                                                                             tx_p_out8, 
       output                                                                             tx_p_out9, 
       output                                                                             tx_p_out10, 
       output                                                                             tx_p_out11, 
       output                                                                             tx_p_out12, 
       output                                                                             tx_p_out13, 
       output                                                                             tx_p_out14, 
       output                                                                             tx_p_out15, 
       input                                                                              refclk0, 
       input                                                                              refclk1, 
  
       input                                                                              ninit_done, 
  
       output                                                                             app_clk, 
       output                                                                             app_rst_n,
  
       // IO interface level updates for F-Tile PCIe HIP
       input                                                                              pcie_systempll_clk,
       input                                                                              refclk2, 
       input                                                                              refclk3, 
  
       // AVMM Master PIO interface "(!enable_mcdma_hwtcl) || (enable_mcdma_hwtcl && enable_bursting_master_hwtcl)"
       output [pio_address_width_hwtcl-1:0]                                               rx_pio_address_o,
       output [pio_data_width_hwtcl/8-1:0]                                                rx_pio_byteenable_o,
       output                                                                             rx_pio_read_o,
       output                                                                             rx_pio_write_o,
       output [pio_data_width_hwtcl-1:0]                                                  rx_pio_writedata_o,
       output [3:0]                                                                       rx_pio_burstcount_o,
       input                                                                              rx_pio_waitrequest_i,
       input [pio_data_width_hwtcl-1:0]                                                   rx_pio_readdata_i,
       input                                                                              rx_pio_readdatavalid_i,
       input [1:0]                                                                        rx_pio_response_i,
       input                                                                              rx_pio_writeresponsevalid_i,

       // H2D AVST Master Interface    "(num_h2d_avst_uport_hwtcl < 1) || (!enable_mcdma_hwtcl)"
       output logic                                                                       h2d_st_sof_0_o,
       output logic                                                                       h2d_st_eof_0_o,
       output logic [empty_width_hwtcl-1:0]                                               h2d_st_empty_0_o,
       input logic                                                                        h2d_st_ready_0_i,
       output logic                                                                       h2d_st_valid_0_o,
       output logic [data_width_hwtcl-1:0]                                                h2d_st_data_0_o,
       output logic [ST_CHANNEL_WIDTH-1:0]                                                h2d_st_channel_0_o,
       // H2D AVST Master Interface   "(num_h2d_avst_uport_hwtcl < 2) || (!enable_mcdma_hwtcl)"
       output logic                                                                       h2d_st_sof_1_o,
       output logic                                                                       h2d_st_eof_1_o,
       output logic [empty_width_hwtcl-1:0]                                               h2d_st_empty_1_o,
       input logic                                                                        h2d_st_ready_1_i,
       output logic                                                                       h2d_st_valid_1_o,
       output logic [data_width_hwtcl-1:0]                                                h2d_st_data_1_o,
       output logic [ST_CHANNEL_WIDTH-1:0]                                                h2d_st_channel_1_o,
       // H2D AVST Master Interface    "(num_h2d_avst_uport_hwtcl < 3) || (!enable_mcdma_hwtcl)"
       output logic                                                                       h2d_st_sof_2_o,
       output logic                                                                       h2d_st_eof_2_o,
       output logic [empty_width_hwtcl-1:0]                                               h2d_st_empty_2_o,
       input logic                                                                        h2d_st_ready_2_i,
       output logic                                                                       h2d_st_valid_2_o,
       output logic [data_width_hwtcl-1:0]                                                h2d_st_data_2_o,
       output logic [ST_CHANNEL_WIDTH-1:0]                                                h2d_st_channel_2_o,
       // H2D AVST Master Interface    "(num_h2d_avst_uport_hwtcl < 4) || (!enable_mcdma_hwtcl)"
       output logic                                                                       h2d_st_sof_3_o,
       output logic                                                                       h2d_st_eof_3_o,
       output logic [empty_width_hwtcl-1:0]                                               h2d_st_empty_3_o,
       input logic                                                                        h2d_st_ready_3_i,
       output logic                                                                       h2d_st_valid_3_o,
       output logic [data_width_hwtcl-1:0]                                                h2d_st_data_3_o,
       output logic [ST_CHANNEL_WIDTH-1:0]                                                h2d_st_channel_3_o,
       // H2D AVMM Master Interface  "(num_h2d_avmm_uport_hwtcl < 1) || (!enable_mcdma_hwtcl)" 
       input logic                                                                        h2ddm_waitrequest_i,
       input logic                                                                        h2ddm_writeresponsevalid_i,
       output logic                                                                       h2ddm_write_o,
       output logic [63:0]                                                                h2ddm_address_o,
       output logic [burst_width_hwtcl-1:0]                                               h2ddm_burstcount_o,
       output logic [data_width_hwtcl/8-1:0]                                              h2ddm_byteenable_o,
       output logic [data_width_hwtcl-1:0]                                                h2ddm_writedata_o,
       // D2H AVST interface    "num_d2h_avst_uport_hwtcl < 1 || enable_mcdma_hwtcl == 0"
       input logic                                                                        d2h_st_sof_0_i,
       input logic                                                                        d2h_st_eof_0_i,
       input logic [empty_width_hwtcl-1:0]                                                d2h_st_empty_0_i,
       input logic [ST_CHANNEL_WIDTH-1:0]                                                 d2h_st_channel_0_i,
       input logic                                                                        d2h_st_valid_0_i,
       input logic [data_width_hwtcl-1:0]                                                 d2h_st_data_0_i,
       output logic                                                                       d2h_st_ready_0_o,
       // D2H AVST interface   "num_d2h_avst_uport_hwtcl < 2 || enable_mcdma_hwtcl == 0"
       input logic                                                                        d2h_st_sof_1_i,
       input logic                                                                        d2h_st_eof_1_i,
       input logic [empty_width_hwtcl-1:0]                                                d2h_st_empty_1_i,
       input logic [ST_CHANNEL_WIDTH-1:0]                                                 d2h_st_channel_1_i,
       input logic                                                                        d2h_st_valid_1_i,
       input logic [data_width_hwtcl-1:0]                                                 d2h_st_data_1_i,
       output logic                                                                       d2h_st_ready_1_o,
       // D2H AVST interface   "num_d2h_avst_uport_hwtcl < 3 || enable_mcdma_hwtcl == 0"
       input logic                                                                        d2h_st_sof_2_i,
       input logic                                                                        d2h_st_eof_2_i,
       input logic [empty_width_hwtcl-1:0]                                                d2h_st_empty_2_i,
       input logic [ST_CHANNEL_WIDTH-1:0]                                                 d2h_st_channel_2_i,
       input logic                                                                        d2h_st_valid_2_i,
       input logic [data_width_hwtcl-1:0]                                                 d2h_st_data_2_i,
       output logic                                                                       d2h_st_ready_2_o,
       // D2H AVST interface     "num_d2h_avst_uport_hwtcl < 4 || enable_mcdma_hwtcl == 0"
       input logic                                                                        d2h_st_sof_3_i,
       input logic                                                                        d2h_st_eof_3_i,
       input logic [empty_width_hwtcl-1:0]                                                d2h_st_empty_3_i,
       input logic [ST_CHANNEL_WIDTH-1:0]                                                 d2h_st_channel_3_i,
       input logic                                                                        d2h_st_valid_3_i,
       input logic [data_width_hwtcl-1:0]                                                 d2h_st_data_3_i,
       output logic                                                                       d2h_st_ready_3_o,
       //D2H AVMM Read Master Interface    "(num_d2h_avmm_uport_hwtcl < 1) || (!enable_mcdma_hwtcl)"
       output logic [63:0]                                                                d2hdm_address_o,
       output logic [data_width_hwtcl/8-1:0]                                              d2hdm_byteenable_o,
       output logic                                                                       d2hdm_read_o,
       output logic [burst_width_hwtcl-1:0]                                               d2hdm_burstcount_o,
       input logic                                                                        d2hdm_waitrequest_i,
       input logic [data_width_hwtcl-1:0]                                                 d2hdm_readdata_i,
       input logic                                                                        d2hdm_readdatavalid_i,
       input logic [1:0]                                                                  d2hdm_response_i,

       //AVST interface
       //H2D descriptor input on AVST sink interface
       output logic                                                                       h2ddm_desc_ready_o,
       input logic                                                                        h2ddm_desc_valid_i, 
       input logic [255:0]                                                                h2ddm_desc_data_i, // h2d_desc_bypass_t
       //H2D AVST Status source interface                                                
       output logic [31:0]                                                                h2ddm_desc_status_data_o, // h2d_desc_status_t
       output logic                                                                       h2ddm_desc_status_valid_o,
       //H2D AVST Source completion interface                                            
       output logic [data_width_hwtcl-1:0]                                                h2ddm_desc_cmpl_data_o, // h2d_desc_cmpl_t
       output logic [empty_width_hwtcl-1:0]                                               h2ddm_desc_cmpl_empty_o,
       output logic                                                                       h2ddm_desc_cmpl_sop_o, 
       output logic                                                                       h2ddm_desc_cmpl_eop_o, 
       output logic                                                                       h2ddm_desc_cmpl_valid_o, 
       input logic                                                                        h2ddm_desc_cmpl_ready_i,
       //D2H descriptor input on AVST sink interface                                     
       output logic                                                                       d2hdm_desc_ready_o, 
       input logic                                                                        d2hdm_desc_valid_i, 
       input logic [255:0]                                                                d2hdm_desc_data_i, // d2h_desc_bypass_t
       //D2H AVST Status source interface                                                
       output logic [31:0]                                                                d2hdm_desc_status_data_o, // d2h_desc_status_t
       output logic                                                                       d2hdm_desc_status_valid_o,
  
       // "(!enable_bursting_master_hwtcl)" 
       input logic                                                                        bam_waitrequest_i, 
       output logic [enable_cs_hwtcl ==1 ? 63 : (((pfcnt_w_hwtcl+vfcnt_w_hwtcl)+max_bar_address_width_hwtcl)+4)-1:0] bam_address_o, 
       output logic [(data_width_hwtcl/8)-1:0]                                            bam_byteenable_o, 
       output logic                                                                       bam_read_o, 
       input logic [data_width_hwtcl-1:0]                                                 bam_readdata_i, 
       input logic                                                                        bam_readdatavalid_i, 
       output logic                                                                       bam_write_o, 
       output logic [data_width_hwtcl-1:0]                                                bam_writedata_o, 
       output logic [burst_width_hwtcl-1:0]                                               bam_burstcount_o, 

       output logic [2:0]                                                                 usr_hip_tl_cfg_func_o,
       output logic [4:0]                                                                 usr_hip_tl_cfg_add_o, 
       output logic [15:0]                                                                usr_hip_tl_cfg_ctl_o, 
  
  
       // MSI-X Request interface from application/user side    !enable_user_msix_hwtcl
       input logic                                                                        usr_event_msix_valid_i,
       output logic                                                                       usr_event_msix_ready_o,
       input logic [15:0]                                                                 usr_event_msix_data_i,
       //FLR interface to application/user side   !enable_user_flr_hwtcl
       output logic                                                                       usr_flr_rcvd_val_o,
       output logic [10:0]                                                                usr_flr_rcvd_chan_num_o,
       input logic                                                                        usr_flr_completed_i,
       // BAS interface   "(!enable_bursting_slave_hwtcl)"
       input logic                                                                        bas_vfactive_i,
       input logic [pfnum_width_hwtcl-1:0]                                                bas_pfnum_i,
       input logic [vfnum_width_hwtcl-1:0]                                                bas_vfnum_i,
       input logic [bas_address_width_hwtcl-1:0]                                          bas_address_i,
       input logic [data_width_hwtcl/8-1:0]                                               bas_byteenable_i,
       input logic                                                                        bas_read_i,
       input logic                                                                        bas_write_i,
       input logic [data_width_hwtcl-1:0]                                                 bas_writedata_i,
       input logic [burst_width_hwtcl-1:0]                                                bas_burstcount_i,
       output logic                                                                       bas_waitrequest_o,
       output logic [data_width_hwtcl-1:0]                                                bas_readdata_o,
       output logic                                                                       bas_readdatavalid_o,
       output logic [1:0]                                                                 bas_response_o,
       // Usr Reconfig interface   "(!enable_user_hip_reconfig_hwtcl)"
       output logic                                                                       usr_hip_reconfig_rst_n_o,
       output logic                                                                       usr_hip_reconfig_clk_o,
       input logic [20:0]                                                                 usr_hip_reconfig_address_i,
       input logic                                                                        usr_hip_reconfig_read_i,
       input logic                                                                        usr_hip_reconfig_write_i,
       input logic [7:0]                                                                  usr_hip_reconfig_writedata_i,
       output logic [7:0]                                                                 usr_hip_reconfig_readdata_o,
       output logic                                                                       usr_hip_reconfig_readdatavalid_o,
       output logic                                                                       usr_hip_reconfig_waitrequest_o,
       //CS AVMM slave interface   "(!enable_cs_hwtcl)"
       output logic                                                                       cs_waitrequest_o,
       input logic [cs_address_width_hwtcl-1:0]                                           cs_address_i,
       input logic [3:0]                                                                  cs_byteenable_i,
       input logic                                                                        cs_read_i,
       output logic [31:0]                                                                cs_readdata_o,
       output logic                                                                       cs_readdatavalid_o,
       input logic                                                                        cs_write_i,
       input logic [31:0]                                                                 cs_writedata_i,
       output logic [1:0]                                                                 cs_response_o, 
       output logic                                                                       cs_writeresponsevalid_o,


       //MSI interface to user
       input  logic                                                                       msi_req_i,
       input  logic [pfnum_width_hwtcl-1:0]                                               msi_func_num_i,
       input  logic [4:0]                                                                 msi_num_i,
       output logic                                                                       msi_ack_o,
       output logic [1:0]                                                                 msi_status_o,




 
       //p0 _int_ ports
       input [7:0]                                                                        p0_app_int_i,
       output                                                                             p0_int_status_o,
       //p0 reset interface  
       input                                                                              p0_pld_warm_rst_rdy_i, 
       output                                                                             p0_pld_link_req_rst_o, 


       //soft logic needs to control input
       output                                                                             p0_surprise_down_err_o,
       input [7:0]                                                                        p0_apps_pm_xmt_pme_i,
       output                                                                             p0_dl_up_o,
       input                                                                              p0_app_xfer_pending_i,
       input                                                                              p0_app_init_rst_i,
       output [2:0]                                                                       p0_pm_state_o,
       output [31:0]                                                                      p0_pm_dstate_o,
       output [5:0]                                                                       p0_ltssm_state_o,
       output                                                                             p0_link_up_o,


       //p0 pld_initialization ports
       //soft logic to control
       input [7:0]                                                                        p0_app_req_retry_en_i,
       //p0 sys_ ports
       input                                                                              p0_sys_aux_pwr_det_i,
       //p0 cii_ ports
       //export as it is
       output                                                                             p0_cii_hdr_poisoned_o,
       input                                                                              p0_cii_override_en_i,
       output [3:0]                                                                       p0_cii_hdr_first_be_o,
       output [2:0]                                                                       p0_cii_func_num_o,
       output [31:0]                                                                      p0_cii_dout_o,
       input                                                                              p0_cii_halt_i, //default to 0
       output                                                                             p0_cii_wr_vf_active_o,
       output                                                                             p0_cii_req_o,
       output [9:0]                                                                       p0_cii_addr_o,
       output [10:0]                                                                      p0_cii_vf_num_o,
       output                                                                             p0_cii_wr_o,
       input [31:0]                                                                       p0_cii_override_din_i,

       input                                                                              p0_pld_clrpcs_n_i, //   (for x16, x8, x4 mode)
       output                                                                             p0_dtk_hip_reconfig_clk,

   //p0 prs_event ports
   input   [1:0]                                       p0_prs_event_i,
   input   [2:0]                                       p0_prs_event_func_i,
   input                                               p0_prs_event_valid_i,

       input                                                                              i_gpio_perst0_n,
       input                                                                              i_gpio_perst1_n,
       input                                                                              i_gpio_perst2_n,
       input                                                                              i_gpio_perst3_n,

	input 										ptm_manual_update_i,
	output										ptm_clk_updated_o,  
	output [rxbuf_features_enablement_full ? 0 : 63:0]				ptm_local_clock_o,  
	output										ptm_context_valid_o,
        output                                              				ptm_clock_correction_o,


       //p1 _int_ ports
       input  [7:0]                                                                       p1_app_int_i,
       output                                                                             p1_int_status_o,
       //p1 reset interface  
       input                                                                              p1_pld_warm_rst_rdy_i, 
       output                                                                             p1_pld_link_req_rst_o,
       
       //p1 power_mgmt ports                                                       
       output  [31:0]                                                                     p1_pm_dstate_o,
       output  [2:0]                                                                      p1_pm_state_o,
       output  [5:0]                                                                      p1_ltssm_state_o,
       output                                                                             p1_surprise_down_err_o,
       input  [7:0]                                                                       p1_apps_pm_xmt_pme_i,
       input                                                                              p1_app_init_rst_i,
       output                                                                             p1_link_up_o,
       input                                                                              p1_app_xfer_pending_i,
       output                                                                             p1_dl_up_o,
       //p1 user_ ports                                                            
       input    [7:0]                                                                     p1_app_req_retry_en_i,
       //p1 sys_ ports
       input                                                                              p1_sys_aux_pwr_det_i,

       //p1 cii_ ports                                                             
       input                                                                              p1_cii_override_en_i,
       output  [3:0]                                                                      p1_cii_hdr_first_be_o,
       input                                                                              p1_cii_halt_i,
       output                                                                             p1_cii_wr_o,
       output                                                                             p1_cii_req_o,
       output  [2:0]                                                                      p1_cii_func_num_o,
       output  [31:0]                                                                     p1_cii_dout_o,
       output                                                                             p1_cii_wr_vf_active_o,
       output                                                                             p1_cii_hdr_poisoned_o,
       output  [10:0]                                                                     p1_cii_vf_num_o,
       input  [31:0]                                                                      p1_cii_override_din_i,
       output  [9:0]                                                                      p1_cii_addr_o,

       input                                                                              p1_pld_clrpcs_n_i, //   (for x8, x4 mode) in Type D it is tied OFF to 1 in avst top wrapper
       output                                                                             p1_dtk_hip_reconfig_clk,

   //p1 prs_event ports
   input   [1:0]                                       p1_prs_event_i,
   input   [2:0]                                       p1_prs_event_func_i,
   input                                               p1_prs_event_valid_i,
       //p2 _int_ ports
       input  [7:0]                                                                       p2_app_int_i,
       output                                                                             p2_int_status_o,
       //p2 reset interface  
       input                                                                              p2_pld_warm_rst_rdy_i, 
       output                                                                             p2_pld_link_req_rst_o,
       
       //p2 power_mgmt ports                                                       
       output  [31:0]                                                                     p2_pm_dstate_o,
       output  [2:0]                                                                      p2_pm_state_o,
       output  [5:0]                                                                      p2_ltssm_state_o,
       output                                                                             p2_surprise_down_err_o,
       input  [7:0]                                                                       p2_apps_pm_xmt_pme_i,
       input                                                                              p2_app_init_rst_i,
       output                                                                             p2_link_up_o,
       input                                                                              p2_app_xfer_pending_i,
       output                                                                             p2_dl_up_o,
       //p2 user_ ports                                                            
       input    [7:0]                                                                     p2_app_req_retry_en_i,
       //p2 sys_ ports
       input                                                                              p2_sys_aux_pwr_det_i,

       //p2 cii_ ports                                                             
       input                                                                              p2_cii_override_en_i,
       output  [3:0]                                                                      p2_cii_hdr_first_be_o,
       input                                                                              p2_cii_halt_i,
       output                                                                             p2_cii_wr_o,
       output                                                                             p2_cii_req_o,
       output  [2:0]                                                                      p2_cii_func_num_o,
       output  [31:0]                                                                     p2_cii_dout_o,
       output                                                                             p2_cii_wr_vf_active_o,
       output                                                                             p2_cii_hdr_poisoned_o,
       output  [10:0]                                                                     p2_cii_vf_num_o,
       input  [31:0]                                                                      p2_cii_override_din_i,
       output  [9:0]                                                                      p2_cii_addr_o,

       input                                                                              p2_pld_clrpcs_n_i, //   (for x8, x4 mode) in Type D it is tied OFF to 1 in avst top wrapper
       output                                                                        	  p2_dtk_hip_reconfig_clk,

       //p3 _int_ ports
       input  [7:0]                                                                       p3_app_int_i,
       output                                                                             p3_int_status_o,
       //p3 reset interface  
       input                                                                              p3_pld_warm_rst_rdy_i, 
       output                                                                             p3_pld_link_req_rst_o,
       
       //p3 power_mgmt ports                                                       
       output  [31:0]                                                                     p3_pm_dstate_o,
       output  [2:0]                                                                      p3_pm_state_o,
       output  [5:0]                                                                      p3_ltssm_state_o,
       output                                                                             p3_surprise_down_err_o,
       input  [7:0]                                                                       p3_apps_pm_xmt_pme_i,
       input                                                                              p3_app_init_rst_i,
       output                                                                             p3_link_up_o,
       input                                                                              p3_app_xfer_pending_i,
       output                                                                             p3_dl_up_o,
       //p3 user_ ports                                                            
       input    [7:0]                                                                     p3_app_req_retry_en_i,
       //p3 sys_ ports
       input                                                                              p3_sys_aux_pwr_det_i,

       //p3 cii_ ports                                                             
       input                                                                              p3_cii_override_en_i,
       output  [3:0]                                                                      p3_cii_hdr_first_be_o,
       input                                                                              p3_cii_halt_i,
       output                                                                             p3_cii_wr_o,
       output                                                                             p3_cii_req_o,
       output  [2:0]                                                                      p3_cii_func_num_o,
       output  [31:0]                                                                     p3_cii_dout_o,
       output                                                                             p3_cii_wr_vf_active_o,
       output                                                                             p3_cii_hdr_poisoned_o,
       output  [10:0]                                                                     p3_cii_vf_num_o,
       input  [31:0]                                                                      p3_cii_override_din_i,
       output  [9:0]                                                                      p3_cii_addr_o,

       input                                                                              p3_pld_clrpcs_n_i, //   (for x8, x4 mode) in Type D it is tied OFF to 1 in avst top wrapper
       output                                                                        	  p3_dtk_hip_reconfig_clk,

       input                                                                              dummy_user_avmm_rst,

       //  PHY Reconfig Interface
       //shared among all cores
       input                                                                              xcvr_reconfig_clk,
       input                                                                              xcvr_reconfig_write,
       input                                                                              xcvr_reconfig_read,
       input [24:0]                                                                       xcvr_reconfig_address,
       input [7:0]                                                                        xcvr_reconfig_writedata,
       output [7:0]                                                                       xcvr_reconfig_readdata,
       output                                                                             xcvr_reconfig_readdatavalid,
       output                                                                             xcvr_reconfig_waitrequest,
       // Link Inspector Interface
       input                                                                              pli_avmm_master_write,
       input                                                                              pli_avmm_master_read,
       input [23:0]                                                                       pli_avmm_master_address,
       input [31:0]                                                                       pli_avmm_master_writedata,
       output [31:0]                                                                      pli_avmm_master_readdata,
       output                                                                             pli_avmm_master_readdatavalid,
       output                                                                             pli_avmm_master_waitrequest, 

       input                                                                              pin_perst_n
       );
   
   logic                                                                                  p0_reset_status_n;                         
   logic                                                                                  p0_slow_reset_status_n;                         
   logic                                                                                  p0_pin_perst_n;
   logic                                                                                  coreclkout_hip;                     
   logic                                                                                  slow_clk;                     
   
   // Interface to the Streaming ports of HIP.
   //RX Ports
   logic                                                                                  p0_rx_st_ready_i       ; 
   logic [double_width_integer_hwtcl-1:0]                                                 p0_rx_st_valid_o       ; 
   logic [double_width_integer_hwtcl-1:0]                                                 p0_rx_st_sop_o         ; 
   logic [double_width_integer_hwtcl-1:0]                                                 p0_rx_st_eop_o         ; 
   logic [hdr_width_integer_hwtcl-1:0]                                                    p0_rx_st_hdr_o         ; 
   logic [payload_width_integer_hwtcl-1:0]                                                p0_rx_st_data_o        ; 
   logic [double_width_integer_hwtcl-1:0]                                                 p0_rx_st_vf_active_o   ; 
   logic [double_width_integer_hwtcl*3-1:0]                                               p0_rx_st_func_num_o    ; 
   logic [double_width_integer_hwtcl*11-1:0]                                              p0_rx_st_vf_num_o      ; 
   logic [double_width_integer_hwtcl*3-1:0]                                               p0_rx_st_bar_range_o   ; 
   logic                                                                                  p0_rx_par_err_o        ; 
   logic [double_width_integer_hwtcl*3 -1 :0]                                             p0_rx_st_empty_o       ;
   logic [pfx_width_integer_hwtcl-1:0]                                                    p0_rx_st_tlp_prfx_o    ; 
   logic [double_width_integer_hwtcl -1:0]                                                p0_rx_st_tlp_abort_o   ; 
   logic [payload_width_integer_hwtcl/8-1:0]                                              p0_rx_st_data_par_o    ; 
   logic [hdr_width_integer_hwtcl/8-1:0]                                                  p0_rx_st_hdr_par_o     ; 
   logic [pfx_width_integer_hwtcl/8-1:0]                                                  p0_rx_st_tlp_prfx_par_o; 

   
   //TX Ports
   logic                                                                                  p0_tx_st_ready_o      ; 
   logic                                                                                  p0_tx_par_err_o       ; 
   logic [double_width_integer_hwtcl-1:0]                                                 p0_tx_st_valid_i      ; 
   logic [double_width_integer_hwtcl-1:0]                                                 p0_tx_st_sop_i        ; 
   logic [double_width_integer_hwtcl-1:0]                                                 p0_tx_st_eop_i        ; 
   logic [double_width_integer_hwtcl-1:0]                                                 p0_tx_st_err_i        ; 
   logic [hdr_width_integer_hwtcl-1:0]                                                    p0_tx_st_hdr_i        ; 
   logic [payload_width_integer_hwtcl-1:0]                                                p0_tx_st_data_i       ; 
   //logic [double_width_integer_hwtcl? 1:0:0] /.tx_st_vf_active_o   ; 
   logic [pfx_width_integer_hwtcl-1:0]                                                    p0_tx_st_tlp_prfx_i   ; 
   logic [payload_width_integer_hwtcl/8-1:0]                                              p0_tx_st_data_par_i   ; 
   logic [hdr_width_integer_hwtcl/8-1:0]                                                  p0_tx_st_hdr_par_i    ; 
   logic [pfx_width_integer_hwtcl/8-1:0]                                                  p0_tx_st_tlp_prfx_par_i;

   logic                                                                                  p0_dl_timer_update_o ;

   // Streaming Packets HIP Credit Interface.
   // TX Ports
   logic [15:0]                                                                           p0_tx_cdts_limit_o;           //C2p NA      C2e  NA             WHR [15:0]
   logic [2:0]                                                                            p0_tx_cdts_limit_tdm_idx_o;   //C2p NA      C2e  NA             WHR [2:0]
   
   // RX Ports                                       
   logic [11:0]                                                                           p0_rx_buffer_limit_i; //C2p NA      C2e  NA             WHR [11:0]
   logic [1:0]                                                                            p0_rx_buffer_limit_tdm_idx_i; //C2p NA      C2e  NA             WHR [1:0]

   // Config Interface
   logic [2:0]                                                                            p0_tl_cfg_func_o ;              //C2p[1:0]    C2e  [1:0]          WHR [2:0]
   logic [4:0]                                                                            p0_tl_cfg_add_o  ;              //C2p[4:0]    C2e  [3:0]          WHR [4:0]
   logic [15:0]                                                                           p0_tl_cfg_ctl_o  ;              //C2p[31:0]   C2e  [31:0]         WHR [15:0]
   
   // HIP Reconfig interface
   logic                                                                                  p0_hip_reconfig_read;
   logic [20:0]                                                                           p0_hip_reconfig_address;
   logic                                                                                  p0_hip_reconfig_write;
   logic [7:0]                                                                            p0_hip_reconfig_writedata;
   logic                                                                                  p0_hip_reconfig_clk;
   logic                                                                                  p0_hip_reconfig_readdatavalid;
   logic [7:0]                                                                            p0_hip_reconfig_readdata;
   logic                                                                                  p0_hip_reconfig_waitrequest;

   // FLR interface from HIP
   logic [7:0]                                                                            p0_flr_rcvd_pf_o       ;   
   logic                                                                                  p0_flr_rcvd_vf_o       ;   
   logic [2:0]                                                                            p0_flr_rcvd_pf_num_o   ;  
   logic [10:0]                                                                           p0_flr_rcvd_vf_num_o   ;   
   logic [7:0]                                                                            p0_flr_completed_pf_i  ;   
   logic                                                                                  p0_flr_completed_vf_i  ;   
   logic [2:0]                                                                            p0_flr_completed_pf_num_i ;
   logic [10:0]                                                                           p0_flr_completed_vf_num_i ;

   //  Completion Timeout Interface (only in P-tile)
   logic                                                                                  p0_cpl_timeout_o                  ; 

   // Error interface to HIP
   logic                                                                                  p0_app_err_valid_i    ;   
   logic [31:0]                                                                           p0_app_err_hdr_i      ;   
   logic [12:0]                                                                           p0_app_err_info_i     ;   
   logic [pfnum_width_hwtcl-1:0]                                                          p0_app_err_func_num_i ;   //"(enable_multi_func_hwtcl == 0)"
   logic                                                                                  p0_serr_out_o         ;   
   logic                                                                                  p0_hip_enter_err_mode_o  ;
   
   //10 bit tag interface
   logic [7:0]                                                                            p0_10bits_tag_req_en_o;

   //MSI pending bits interface
      logic [2:0]                                                                         p0_msi_pnd_func_i;
      logic [7:0]                                                                         p0_msi_pnd_byte_i;
      logic [1:0]                                                                         p0_msi_pnd_addr_i;

   //p0 vf_err_ ports
   logic                                                                                  p0_vf_err_ur_posted_s0_o;
   logic                                                                                  p0_vf_err_ur_posted_s1_o;
   logic                                                                                  p0_vf_err_ur_posted_s2_o;
   logic                                                                                  p0_vf_err_ur_posted_s3_o;
   logic [2:0]                                                                            p0_vf_err_func_num_s0_o;
   logic [2:0]                                                                            p0_vf_err_func_num_s1_o;
   logic [2:0]                                                                            p0_vf_err_func_num_s2_o;
   logic [2:0]                                                                            p0_vf_err_func_num_s3_o;
   logic                                                                                  p0_vf_err_ca_postedreq_s0_o;
   logic                                                                                  p0_vf_err_ca_postedreq_s1_o;
   logic                                                                                  p0_vf_err_ca_postedreq_s3_o;
   logic                                                                                  p0_vf_err_ca_postedreq_s2_o;
   logic [10:0]                                                                           p0_vf_err_vf_num_s0_o;
   logic [10:0]                                                                           p0_vf_err_vf_num_s1_o;
   logic [10:0]                                                                           p0_vf_err_vf_num_s2_o;
   logic [10:0]                                                                           p0_vf_err_vf_num_s3_o;
   logic                                                                                  p0_vf_err_poisonedwrreq_s0_o;
   logic                                                                                  p0_vf_err_poisonedwrreq_s1_o;
   logic                                                                                  p0_vf_err_poisonedwrreq_s2_o;
   logic                                                                                  p0_vf_err_poisonedwrreq_s3_o;
   logic                                                                                  p0_vf_err_poisonedcompl_s0_o;
   logic                                                                                  p0_vf_err_poisonedcompl_s1_o;
   logic                                                                                  p0_vf_err_poisonedcompl_s2_o;
   logic                                                                                  p0_vf_err_poisonedcompl_s3_o;
   logic [2:0]                                                                            p0_user_vfnonfatalmsg_func_num_i;
   logic [10:0]                                                                           p0_user_vfnonfatalmsg_vfnum_i;
   logic                                                                                  p0_user_sent_vfnonfatalmsg_i;
   logic                                                                                  p0_vf_err_overflow_o;

   logic [double_width_integer_hwtcl-1:0]                                                 p0_rx_st_vf_active_wire   ; 
   logic [double_width_integer_hwtcl*3-1:0]                                               p0_rx_st_func_num_wire    ; 
   logic [double_width_integer_hwtcl*11-1:0]                                              p0_rx_st_vf_num_wire      ;


 // PIPEMODE sim signal;
	logic [5:0]	i_rxpipe0_dirfeedback;
	logic [7:0]	i_rxpipe0_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe0_localfs;
	logic [5:0]	i_rxpipe0_locallf;
	logic 	i_rxpipe0_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe0_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe0_p2m_bus;
	logic 	i_rxpipe0_pclkchangeok;
	logic 	i_rxpipe0_phystatus;
	logic [39:0]	i_rxpipe0_rxdata;
	logic [3:0]	i_rxpipe0_rxdatak;
	logic 	i_rxpipe0_rxdatavalid;
	logic 	i_rxpipe0_rxelecidlea;
	logic 	i_rxpipe0_rxstandbystatus;
	logic [0:0]	i_rxpipe0_rxstartblock;
	logic [2:0]	i_rxpipe0_rxstatus;
	logic [3:0]	i_rxpipe0_rxsyncheader;
	logic 	i_rxpipe0_rxvalid;
	logic [5:0]	i_rxpipe1_dirfeedback;
	logic [7:0]	i_rxpipe1_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe1_localfs;
	logic [5:0]	i_rxpipe1_locallf;
	logic 	i_rxpipe1_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe1_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe1_p2m_bus;
	logic 	i_rxpipe1_pclkchangeok;
	logic 	i_rxpipe1_phystatus;
	logic [39:0]	i_rxpipe1_rxdata;
	logic [3:0]	i_rxpipe1_rxdatak;
	logic 	i_rxpipe1_rxdatavalid;
	logic 	i_rxpipe1_rxelecidlea;
	logic 	i_rxpipe1_rxstandbystatus;
	logic [0:0]	i_rxpipe1_rxstartblock;
	logic [2:0]	i_rxpipe1_rxstatus;
	logic [3:0]	i_rxpipe1_rxsyncheader;
	logic 	i_rxpipe1_rxvalid;
	logic [5:0]	i_rxpipe2_dirfeedback;
	logic [7:0]	i_rxpipe2_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe2_localfs;
	logic [5:0]	i_rxpipe2_locallf;
	logic 	i_rxpipe2_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe2_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe2_p2m_bus;
	logic 	i_rxpipe2_pclkchangeok;
	logic 	i_rxpipe2_phystatus;
	logic [39:0]	i_rxpipe2_rxdata;
	logic [3:0]	i_rxpipe2_rxdatak;
	logic 	i_rxpipe2_rxdatavalid;
	logic 	i_rxpipe2_rxelecidlea;
	logic 	i_rxpipe2_rxstandbystatus;
	logic [0:0]	i_rxpipe2_rxstartblock;
	logic [2:0]	i_rxpipe2_rxstatus;
	logic [3:0]	i_rxpipe2_rxsyncheader;
	logic 	i_rxpipe2_rxvalid;
	logic [5:0]	i_rxpipe3_dirfeedback;
	logic [7:0]	i_rxpipe3_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe3_localfs;
	logic [5:0]	i_rxpipe3_locallf;
	logic 	i_rxpipe3_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe3_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe3_p2m_bus;
	logic 	i_rxpipe3_pclkchangeok;
	logic 	i_rxpipe3_phystatus;
	logic [39:0]	i_rxpipe3_rxdata;
	logic [3:0]	i_rxpipe3_rxdatak;
	logic 	i_rxpipe3_rxdatavalid;
	logic 	i_rxpipe3_rxelecidlea;
	logic 	i_rxpipe3_rxstandbystatus;
	logic [0:0]	i_rxpipe3_rxstartblock;
	logic [2:0]	i_rxpipe3_rxstatus;
	logic [3:0]	i_rxpipe3_rxsyncheader;
	logic 	i_rxpipe3_rxvalid;
	logic [5:0]	i_rxpipe4_dirfeedback;
	logic [7:0]	i_rxpipe4_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe4_localfs;
	logic [5:0]	i_rxpipe4_locallf;
	logic 	i_rxpipe4_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe4_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe4_p2m_bus;
	logic 	i_rxpipe4_pclkchangeok;
	logic 	i_rxpipe4_phystatus;
	logic [39:0]	i_rxpipe4_rxdata;
	logic [3:0]	i_rxpipe4_rxdatak;
	logic 	i_rxpipe4_rxdatavalid;
	logic 	i_rxpipe4_rxelecidlea;
	logic 	i_rxpipe4_rxstandbystatus;
	logic [0:0]	i_rxpipe4_rxstartblock;
	logic [2:0]	i_rxpipe4_rxstatus;
	logic [3:0]	i_rxpipe4_rxsyncheader;
	logic 	i_rxpipe4_rxvalid;
	logic [5:0]	i_rxpipe5_dirfeedback;
	logic [7:0]	i_rxpipe5_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe5_localfs;
	logic [5:0]	i_rxpipe5_locallf;
	logic 	i_rxpipe5_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe5_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe5_p2m_bus;
	logic 	i_rxpipe5_pclkchangeok;
	logic 	i_rxpipe5_phystatus;
	logic [39:0]	i_rxpipe5_rxdata;
	logic [3:0]	i_rxpipe5_rxdatak;
	logic 	i_rxpipe5_rxdatavalid;
	logic 	i_rxpipe5_rxelecidlea;
	logic 	i_rxpipe5_rxstandbystatus;
	logic [0:0]	i_rxpipe5_rxstartblock;
	logic [2:0]	i_rxpipe5_rxstatus;
	logic [3:0]	i_rxpipe5_rxsyncheader;
	logic 	i_rxpipe5_rxvalid;
	logic [5:0]	i_rxpipe6_dirfeedback;
	logic [7:0]	i_rxpipe6_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe6_localfs;
	logic [5:0]	i_rxpipe6_locallf;
	logic 	i_rxpipe6_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe6_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe6_p2m_bus;
	logic 	i_rxpipe6_pclkchangeok;
	logic 	i_rxpipe6_phystatus;
	logic [39:0]	i_rxpipe6_rxdata;
	logic [3:0]	i_rxpipe6_rxdatak;
	logic 	i_rxpipe6_rxdatavalid;
	logic 	i_rxpipe6_rxelecidlea;
	logic 	i_rxpipe6_rxstandbystatus;
	logic [0:0]	i_rxpipe6_rxstartblock;
	logic [2:0]	i_rxpipe6_rxstatus;
	logic [3:0]	i_rxpipe6_rxsyncheader;
	logic 	i_rxpipe6_rxvalid;
	logic [5:0]	i_rxpipe7_dirfeedback;
	logic [7:0]	i_rxpipe7_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe7_localfs;
	logic [5:0]	i_rxpipe7_locallf;
	logic 	i_rxpipe7_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe7_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe7_p2m_bus;
	logic 	i_rxpipe7_pclkchangeok;
	logic 	i_rxpipe7_phystatus;
	logic [39:0]	i_rxpipe7_rxdata;
	logic [3:0]	i_rxpipe7_rxdatak;
	logic 	i_rxpipe7_rxdatavalid;
	logic 	i_rxpipe7_rxelecidlea;
	logic 	i_rxpipe7_rxstandbystatus;
	logic [0:0]	i_rxpipe7_rxstartblock;
	logic [2:0]	i_rxpipe7_rxstatus;
	logic [3:0]	i_rxpipe7_rxsyncheader;
	logic 	i_rxpipe7_rxvalid;
	logic [5:0]	i_rxpipe8_dirfeedback;
	logic [7:0]	i_rxpipe8_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe8_localfs;
	logic [5:0]	i_rxpipe8_locallf;
	logic 	i_rxpipe8_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe8_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe8_p2m_bus;
	logic 	i_rxpipe8_pclkchangeok;
	logic 	i_rxpipe8_phystatus;
	logic [39:0]	i_rxpipe8_rxdata;
	logic [3:0]	i_rxpipe8_rxdatak;
	logic 	i_rxpipe8_rxdatavalid;
	logic 	i_rxpipe8_rxelecidlea;
	logic 	i_rxpipe8_rxstandbystatus;
	logic [0:0]	i_rxpipe8_rxstartblock;
	logic [2:0]	i_rxpipe8_rxstatus;
	logic [3:0]	i_rxpipe8_rxsyncheader;
	logic 	i_rxpipe8_rxvalid;
	logic [5:0]	i_rxpipe9_dirfeedback;
	logic [7:0]	i_rxpipe9_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe9_localfs;
	logic [5:0]	i_rxpipe9_locallf;
	logic 	i_rxpipe9_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe9_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe9_p2m_bus;
	logic 	i_rxpipe9_pclkchangeok;
	logic 	i_rxpipe9_phystatus;
	logic [39:0]	i_rxpipe9_rxdata;
	logic [3:0]	i_rxpipe9_rxdatak;
	logic 	i_rxpipe9_rxdatavalid;
	logic 	i_rxpipe9_rxelecidlea;
	logic 	i_rxpipe9_rxstandbystatus;
	logic [0:0]	i_rxpipe9_rxstartblock;
	logic [2:0]	i_rxpipe9_rxstatus;
	logic [3:0]	i_rxpipe9_rxsyncheader;
	logic 	i_rxpipe9_rxvalid;
	logic [5:0]	i_rxpipe10_dirfeedback;
	logic [7:0]	i_rxpipe10_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe10_localfs;
	logic [5:0]	i_rxpipe10_locallf;
	logic 	i_rxpipe10_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe10_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe10_p2m_bus;
	logic 	i_rxpipe10_pclkchangeok;
	logic 	i_rxpipe10_phystatus;
	logic [39:0]	i_rxpipe10_rxdata;
	logic [3:0]	i_rxpipe10_rxdatak;
	logic 	i_rxpipe10_rxdatavalid;
	logic 	i_rxpipe10_rxelecidlea;
	logic 	i_rxpipe10_rxstandbystatus;
	logic [0:0]	i_rxpipe10_rxstartblock;
	logic [2:0]	i_rxpipe10_rxstatus;
	logic [3:0]	i_rxpipe10_rxsyncheader;
	logic 	i_rxpipe10_rxvalid;
	logic [5:0]	i_rxpipe11_dirfeedback;
	logic [7:0]	i_rxpipe11_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe11_localfs;
	logic [5:0]	i_rxpipe11_locallf;
	logic 	i_rxpipe11_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe11_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe11_p2m_bus;
	logic 	i_rxpipe11_pclkchangeok;
	logic 	i_rxpipe11_phystatus;
	logic [39:0]	i_rxpipe11_rxdata;
	logic [3:0]	i_rxpipe11_rxdatak;
	logic 	i_rxpipe11_rxdatavalid;
	logic 	i_rxpipe11_rxelecidlea;
	logic 	i_rxpipe11_rxstandbystatus;
	logic [0:0]	i_rxpipe11_rxstartblock;
	logic [2:0]	i_rxpipe11_rxstatus;
	logic [3:0]	i_rxpipe11_rxsyncheader;
	logic 	i_rxpipe11_rxvalid;
	logic [5:0]	i_rxpipe12_dirfeedback;
	logic [7:0]	i_rxpipe12_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe12_localfs;
	logic [5:0]	i_rxpipe12_locallf;
	logic 	i_rxpipe12_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe12_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe12_p2m_bus;
	logic 	i_rxpipe12_pclkchangeok;
	logic 	i_rxpipe12_phystatus;
	logic [39:0]	i_rxpipe12_rxdata;
	logic [3:0]	i_rxpipe12_rxdatak;
	logic 	i_rxpipe12_rxdatavalid;
	logic 	i_rxpipe12_rxelecidlea;
	logic 	i_rxpipe12_rxstandbystatus;
	logic [0:0]	i_rxpipe12_rxstartblock;
	logic [2:0]	i_rxpipe12_rxstatus;
	logic [3:0]	i_rxpipe12_rxsyncheader;
	logic 	i_rxpipe12_rxvalid;
	logic [5:0]	i_rxpipe13_dirfeedback;
	logic [7:0]	i_rxpipe13_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe13_localfs;
	logic [5:0]	i_rxpipe13_locallf;
	logic 	i_rxpipe13_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe13_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe13_p2m_bus;
	logic 	i_rxpipe13_pclkchangeok;
	logic 	i_rxpipe13_phystatus;
	logic [39:0]	i_rxpipe13_rxdata;
	logic [3:0]	i_rxpipe13_rxdatak;
	logic 	i_rxpipe13_rxdatavalid;
	logic 	i_rxpipe13_rxelecidlea;
	logic 	i_rxpipe13_rxstandbystatus;
	logic [0:0]	i_rxpipe13_rxstartblock;
	logic [2:0]	i_rxpipe13_rxstatus;
	logic [3:0]	i_rxpipe13_rxsyncheader;
	logic 	i_rxpipe13_rxvalid;
	logic [5:0]	i_rxpipe14_dirfeedback;
	logic [7:0]	i_rxpipe14_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe14_localfs;
	logic [5:0]	i_rxpipe14_locallf;
	logic 	i_rxpipe14_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe14_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe14_p2m_bus;
	logic 	i_rxpipe14_pclkchangeok;
	logic 	i_rxpipe14_phystatus;
	logic [39:0]	i_rxpipe14_rxdata;
	logic [3:0]	i_rxpipe14_rxdatak;
	logic 	i_rxpipe14_rxdatavalid;
	logic 	i_rxpipe14_rxelecidlea;
	logic 	i_rxpipe14_rxstandbystatus;
	logic [0:0]	i_rxpipe14_rxstartblock;
	logic [2:0]	i_rxpipe14_rxstatus;
	logic [3:0]	i_rxpipe14_rxsyncheader;
	logic 	i_rxpipe14_rxvalid;
	logic [5:0]	i_rxpipe15_dirfeedback;
	logic [7:0]	i_rxpipe15_linkevaluationfeedbackfiguremerit;
	logic [5:0]	i_rxpipe15_localfs;
	logic [5:0]	i_rxpipe15_locallf;
	logic 	i_rxpipe15_localtxcoefficientsvalid;
	logic [17:0]	i_rxpipe15_localtxpresetcoefficients;
	logic [7:0]	i_rxpipe15_p2m_bus;
	logic 	i_rxpipe15_pclkchangeok;
	logic 	i_rxpipe15_phystatus;
	logic [39:0]	i_rxpipe15_rxdata;
	logic [3:0]	i_rxpipe15_rxdatak;
	logic 	i_rxpipe15_rxdatavalid;
	logic 	i_rxpipe15_rxelecidlea;
	logic 	i_rxpipe15_rxstandbystatus;
	logic [0:0]	i_rxpipe15_rxstartblock;
	logic [2:0]	i_rxpipe15_rxstatus;
	logic [3:0]	i_rxpipe15_rxsyncheader;
	logic 	i_rxpipe15_rxvalid;
	logic 		o_txpipe0_asyncpowerchangeack;
	logic 		o_txpipe0_blockaligncontrol;
	logic 		o_txpipe0_cfg_hw_auto_sp_dis;
	logic 		o_txpipe0_dirchange;
	logic 		o_txpipe0_ebuf_mode;
	logic 		o_txpipe0_encodedecodebypass;
	logic  [5:0]	o_txpipe0_fs;
	logic 		o_txpipe0_getlocalpresetcoefficients;
	logic 		o_txpipe0_invalidrequest;
	logic  [5:0]	o_txpipe0_lf;
	logic  [4:0]	o_txpipe0_localpresetindex;
//	logic 		o_txpipe0_lowpin_nt;
	logic  [7:0]	o_txpipe0_m2p_bus;
	logic  [2:0]	o_txpipe0_pclk_rate;
	logic 		o_txpipe0_pclkchangeack;
//	logic  [3:0]	o_txpipe0_phy_mode_nt;
	logic  [3:0]	o_txpipe0_powerdown;
	logic  [2:0]	o_txpipe0_rate;
	logic 		o_txpipe0_rxelecidle_disable_a;
//	logic 		o_txpipe0_rxeqclr;
	logic 		o_txpipe0_rxeqeval;
	logic 		o_txpipe0_rxeqinprogress;
	logic 		o_txpipe0_rxeqtraining;
	logic 		o_txpipe0_rxpolarity;
	logic  [2:0]	o_txpipe0_rxpresethint;
	logic 		o_txpipe0_rxstandby;
	logic 		o_txpipe0_rxtermination;
	logic 		o_txpipe0_srisenable;
	logic 		o_txpipe0_txcmnmode_disable_a;
	logic 		o_txpipe0_txcompliance;
	logic  [39:0]	o_txpipe0_txdata;
	logic  [3:0]	o_txpipe0_txdatak;
	logic 		o_txpipe0_txdatavalid;
	logic  [17:0]	o_txpipe0_txdeemph;
	logic 		o_txpipe0_txdtctrx_lb;
	logic 		o_txpipe0_txelecidle;
	logic  [2:0]	o_txpipe0_txmargin;
	logic 		o_txpipe0_txoneszeros;
	logic  [0:0]	o_txpipe0_txstartblock;
	logic 		o_txpipe0_txswing;
	logic  [3:0]	o_txpipe0_txsyncheader;
	logic  [2:0]	o_txpipe0_width;
	logic 		o_txpipe1_asyncpowerchangeack;
	logic 		o_txpipe1_blockaligncontrol;
	logic 		o_txpipe1_cfg_hw_auto_sp_dis;
	logic 		o_txpipe1_dirchange;
	logic 		o_txpipe1_ebuf_mode;
	logic 		o_txpipe1_encodedecodebypass;
	logic  [5:0]	o_txpipe1_fs;
	logic 		o_txpipe1_getlocalpresetcoefficients;
	logic 		o_txpipe1_invalidrequest;
	logic  [5:0]	o_txpipe1_lf;
	logic  [4:0]	o_txpipe1_localpresetindex;
//	logic 		o_txpipe1_lowpin_nt;
	logic  [7:0]	o_txpipe1_m2p_bus;
	logic  [2:0]	o_txpipe1_pclk_rate;
	logic 		o_txpipe1_pclkchangeack;
//	logic  [3:0]	o_txpipe1_phy_mode_nt;
	logic  [3:0]	o_txpipe1_powerdown;
	logic  [2:0]	o_txpipe1_rate;
	logic 		o_txpipe1_rxelecidle_disable_a;
//	logic 		o_txpipe1_rxeqclr;
	logic 		o_txpipe1_rxeqeval;
	logic 		o_txpipe1_rxeqinprogress;
	logic 		o_txpipe1_rxeqtraining;
	logic 		o_txpipe1_rxpolarity;
	logic  [2:0]	o_txpipe1_rxpresethint;
	logic 		o_txpipe1_rxstandby;
	logic 		o_txpipe1_rxtermination;
	logic 		o_txpipe1_srisenable;
	logic 		o_txpipe1_txcmnmode_disable_a;
	logic 		o_txpipe1_txcompliance;
	logic  [39:0]	o_txpipe1_txdata;
	logic  [3:0]	o_txpipe1_txdatak;
	logic 		o_txpipe1_txdatavalid;
	logic  [17:0]	o_txpipe1_txdeemph;
	logic 		o_txpipe1_txdtctrx_lb;
	logic 		o_txpipe1_txelecidle;
	logic  [2:0]	o_txpipe1_txmargin;
	logic 		o_txpipe1_txoneszeros;
	logic  [0:0]	o_txpipe1_txstartblock;
	logic 		o_txpipe1_txswing;
	logic  [3:0]	o_txpipe1_txsyncheader;
	logic  [2:0]	o_txpipe1_width;
	logic 		o_txpipe2_asyncpowerchangeack;
	logic 		o_txpipe2_blockaligncontrol;
	logic 		o_txpipe2_cfg_hw_auto_sp_dis;
	logic 		o_txpipe2_dirchange;
	logic 		o_txpipe2_ebuf_mode;
	logic 		o_txpipe2_encodedecodebypass;
	logic  [5:0]	o_txpipe2_fs;
	logic 		o_txpipe2_getlocalpresetcoefficients;
	logic 		o_txpipe2_invalidrequest;
	logic  [5:0]	o_txpipe2_lf;
	logic  [4:0]	o_txpipe2_localpresetindex;
//	logic 		o_txpipe2_lowpin_nt;
	logic  [7:0]	o_txpipe2_m2p_bus;
	logic  [2:0]	o_txpipe2_pclk_rate;
	logic 		o_txpipe2_pclkchangeack;
//	logic  [3:0]	o_txpipe2_phy_mode_nt;
	logic  [3:0]	o_txpipe2_powerdown;
	logic  [2:0]	o_txpipe2_rate;
	logic 		o_txpipe2_rxelecidle_disable_a;
//	logic 		o_txpipe2_rxeqclr;
	logic 		o_txpipe2_rxeqeval;
	logic 		o_txpipe2_rxeqinprogress;
	logic 		o_txpipe2_rxeqtraining;
	logic 		o_txpipe2_rxpolarity;
	logic  [2:0]	o_txpipe2_rxpresethint;
	logic 		o_txpipe2_rxstandby;
	logic 		o_txpipe2_rxtermination;
	logic 		o_txpipe2_srisenable;
	logic 		o_txpipe2_txcmnmode_disable_a;
	logic 		o_txpipe2_txcompliance;
	logic  [39:0]	o_txpipe2_txdata;
	logic  [3:0]	o_txpipe2_txdatak;
	logic 		o_txpipe2_txdatavalid;
	logic  [17:0]	o_txpipe2_txdeemph;
	logic 		o_txpipe2_txdtctrx_lb;
	logic 		o_txpipe2_txelecidle;
	logic  [2:0]	o_txpipe2_txmargin;
	logic 		o_txpipe2_txoneszeros;
	logic  [0:0]	o_txpipe2_txstartblock;
	logic 		o_txpipe2_txswing;
	logic  [3:0]	o_txpipe2_txsyncheader;
	logic  [2:0]	o_txpipe2_width;
	logic 		o_txpipe3_asyncpowerchangeack;
	logic 		o_txpipe3_blockaligncontrol;
	logic 		o_txpipe3_cfg_hw_auto_sp_dis;
	logic 		o_txpipe3_dirchange;
	logic 		o_txpipe3_ebuf_mode;
	logic 		o_txpipe3_encodedecodebypass;
	logic  [5:0]	o_txpipe3_fs;
	logic 		o_txpipe3_getlocalpresetcoefficients;
	logic 		o_txpipe3_invalidrequest;
	logic  [5:0]	o_txpipe3_lf;
	logic  [4:0]	o_txpipe3_localpresetindex;
//	logic 		o_txpipe3_lowpin_nt;
	logic  [7:0]	o_txpipe3_m2p_bus;
	logic  [2:0]	o_txpipe3_pclk_rate;
	logic 		o_txpipe3_pclkchangeack;
//	logic  [3:0]	o_txpipe3_phy_mode_nt;
	logic  [3:0]	o_txpipe3_powerdown;
	logic  [2:0]	o_txpipe3_rate;
	logic 		o_txpipe3_rxelecidle_disable_a;
//	logic 		o_txpipe3_rxeqclr;
	logic 		o_txpipe3_rxeqeval;
	logic 		o_txpipe3_rxeqinprogress;
	logic 		o_txpipe3_rxeqtraining;
	logic 		o_txpipe3_rxpolarity;
	logic  [2:0]	o_txpipe3_rxpresethint;
	logic 		o_txpipe3_rxstandby;
	logic 		o_txpipe3_rxtermination;
	logic 		o_txpipe3_srisenable;
	logic 		o_txpipe3_txcmnmode_disable_a;
	logic 		o_txpipe3_txcompliance;
	logic  [39:0]	o_txpipe3_txdata;
	logic  [3:0]	o_txpipe3_txdatak;
	logic 		o_txpipe3_txdatavalid;
	logic  [17:0]	o_txpipe3_txdeemph;
	logic 		o_txpipe3_txdtctrx_lb;
	logic 		o_txpipe3_txelecidle;
	logic  [2:0]	o_txpipe3_txmargin;
	logic 		o_txpipe3_txoneszeros;
	logic  [0:0]	o_txpipe3_txstartblock;
	logic 		o_txpipe3_txswing;
	logic  [3:0]	o_txpipe3_txsyncheader;
	logic  [2:0]	o_txpipe3_width;
	logic 		o_txpipe4_asyncpowerchangeack;
	logic 		o_txpipe4_blockaligncontrol;
	logic 		o_txpipe4_cfg_hw_auto_sp_dis;
	logic 		o_txpipe4_dirchange;
	logic 		o_txpipe4_ebuf_mode;
	logic 		o_txpipe4_encodedecodebypass;
	logic  [5:0]	o_txpipe4_fs;
	logic 		o_txpipe4_getlocalpresetcoefficients;
	logic 		o_txpipe4_invalidrequest;
	logic  [5:0]	o_txpipe4_lf;
	logic  [4:0]	o_txpipe4_localpresetindex;
//	logic 		o_txpipe4_lowpin_nt;
	logic  [7:0]	o_txpipe4_m2p_bus;
	logic  [2:0]	o_txpipe4_pclk_rate;
	logic 		o_txpipe4_pclkchangeack;
//	logic  [3:0]	o_txpipe4_phy_mode_nt;
	logic  [3:0]	o_txpipe4_powerdown;
	logic  [2:0]	o_txpipe4_rate;
	logic 		o_txpipe4_rxelecidle_disable_a;
//	logic 		o_txpipe4_rxeqclr;
	logic 		o_txpipe4_rxeqeval;
	logic 		o_txpipe4_rxeqinprogress;
	logic 		o_txpipe4_rxeqtraining;
	logic 		o_txpipe4_rxpolarity;
	logic  [2:0]	o_txpipe4_rxpresethint;
	logic 		o_txpipe4_rxstandby;
	logic 		o_txpipe4_rxtermination;
	logic 		o_txpipe4_srisenable;
	logic 		o_txpipe4_txcmnmode_disable_a;
	logic 		o_txpipe4_txcompliance;
	logic  [39:0]	o_txpipe4_txdata;
	logic  [3:0]	o_txpipe4_txdatak;
	logic 		o_txpipe4_txdatavalid;
	logic  [17:0]	o_txpipe4_txdeemph;
	logic 		o_txpipe4_txdtctrx_lb;
	logic 		o_txpipe4_txelecidle;
	logic  [2:0]	o_txpipe4_txmargin;
	logic 		o_txpipe4_txoneszeros;
	logic  [0:0]	o_txpipe4_txstartblock;
	logic 		o_txpipe4_txswing;
	logic  [3:0]	o_txpipe4_txsyncheader;
	logic  [2:0]	o_txpipe4_width;
	logic 		o_txpipe5_asyncpowerchangeack;
	logic 		o_txpipe5_blockaligncontrol;
	logic 		o_txpipe5_cfg_hw_auto_sp_dis;
	logic 		o_txpipe5_dirchange;
	logic 		o_txpipe5_ebuf_mode;
	logic 		o_txpipe5_encodedecodebypass;
	logic  [5:0]	o_txpipe5_fs;
	logic 		o_txpipe5_getlocalpresetcoefficients;
	logic 		o_txpipe5_invalidrequest;
	logic  [5:0]	o_txpipe5_lf;
	logic  [4:0]	o_txpipe5_localpresetindex;
//	logic 		o_txpipe5_lowpin_nt;
	logic  [7:0]	o_txpipe5_m2p_bus;
	logic  [2:0]	o_txpipe5_pclk_rate;
	logic 		o_txpipe5_pclkchangeack;
//	logic  [3:0]	o_txpipe5_phy_mode_nt;
	logic  [3:0]	o_txpipe5_powerdown;
	logic  [2:0]	o_txpipe5_rate;
	logic 		o_txpipe5_rxelecidle_disable_a;
//	logic 		o_txpipe5_rxeqclr;
	logic 		o_txpipe5_rxeqeval;
	logic 		o_txpipe5_rxeqinprogress;
	logic 		o_txpipe5_rxeqtraining;
	logic 		o_txpipe5_rxpolarity;
	logic  [2:0]	o_txpipe5_rxpresethint;
	logic 		o_txpipe5_rxstandby;
	logic 		o_txpipe5_rxtermination;
	logic 		o_txpipe5_srisenable;
	logic 		o_txpipe5_txcmnmode_disable_a;
	logic 		o_txpipe5_txcompliance;
	logic  [39:0]	o_txpipe5_txdata;
	logic  [3:0]	o_txpipe5_txdatak;
	logic 		o_txpipe5_txdatavalid;
	logic  [17:0]	o_txpipe5_txdeemph;
	logic 		o_txpipe5_txdtctrx_lb;
	logic 		o_txpipe5_txelecidle;
	logic  [2:0]	o_txpipe5_txmargin;
	logic 		o_txpipe5_txoneszeros;
	logic  [0:0]	o_txpipe5_txstartblock;
	logic 		o_txpipe5_txswing;
	logic  [3:0]	o_txpipe5_txsyncheader;
	logic  [2:0]	o_txpipe5_width;
	logic 		o_txpipe6_asyncpowerchangeack;
	logic 		o_txpipe6_blockaligncontrol;
	logic 		o_txpipe6_cfg_hw_auto_sp_dis;
	logic 		o_txpipe6_dirchange;
	logic 		o_txpipe6_ebuf_mode;
	logic 		o_txpipe6_encodedecodebypass;
	logic  [5:0]	o_txpipe6_fs;
	logic 		o_txpipe6_getlocalpresetcoefficients;
	logic 		o_txpipe6_invalidrequest;
	logic  [5:0]	o_txpipe6_lf;
	logic  [4:0]	o_txpipe6_localpresetindex;
//	logic 		o_txpipe6_lowpin_nt;
	logic  [7:0]	o_txpipe6_m2p_bus;
	logic  [2:0]	o_txpipe6_pclk_rate;
	logic 		o_txpipe6_pclkchangeack;
//	logic  [3:0]	o_txpipe6_phy_mode_nt;
	logic  [3:0]	o_txpipe6_powerdown;
	logic  [2:0]	o_txpipe6_rate;
	logic 		o_txpipe6_rxelecidle_disable_a;
//	logic 		o_txpipe6_rxeqclr;
	logic 		o_txpipe6_rxeqeval;
	logic 		o_txpipe6_rxeqinprogress;
	logic 		o_txpipe6_rxeqtraining;
	logic 		o_txpipe6_rxpolarity;
	logic  [2:0]	o_txpipe6_rxpresethint;
	logic 		o_txpipe6_rxstandby;
	logic 		o_txpipe6_rxtermination;
	logic 		o_txpipe6_srisenable;
	logic 		o_txpipe6_txcmnmode_disable_a;
	logic 		o_txpipe6_txcompliance;
	logic  [39:0]	o_txpipe6_txdata;
	logic  [3:0]	o_txpipe6_txdatak;
	logic 		o_txpipe6_txdatavalid;
	logic  [17:0]	o_txpipe6_txdeemph;
	logic 		o_txpipe6_txdtctrx_lb;
	logic 		o_txpipe6_txelecidle;
	logic  [2:0]	o_txpipe6_txmargin;
	logic 		o_txpipe6_txoneszeros;
	logic  [0:0]	o_txpipe6_txstartblock;
	logic 		o_txpipe6_txswing;
	logic  [3:0]	o_txpipe6_txsyncheader;
	logic  [2:0]	o_txpipe6_width;
	logic 		o_txpipe7_asyncpowerchangeack;
	logic 		o_txpipe7_blockaligncontrol;
	logic 		o_txpipe7_cfg_hw_auto_sp_dis;
	logic 		o_txpipe7_dirchange;
	logic 		o_txpipe7_ebuf_mode;
	logic 		o_txpipe7_encodedecodebypass;
	logic  [5:0]	o_txpipe7_fs;
	logic 		o_txpipe7_getlocalpresetcoefficients;
	logic 		o_txpipe7_invalidrequest;
	logic  [5:0]	o_txpipe7_lf;
	logic  [4:0]	o_txpipe7_localpresetindex;
//	logic 		o_txpipe7_lowpin_nt;
	logic  [7:0]	o_txpipe7_m2p_bus;
	logic  [2:0]	o_txpipe7_pclk_rate;
	logic 		o_txpipe7_pclkchangeack;
//	logic  [3:0]	o_txpipe7_phy_mode_nt;
	logic  [3:0]	o_txpipe7_powerdown;
	logic  [2:0]	o_txpipe7_rate;
	logic 		o_txpipe7_rxelecidle_disable_a;
//	logic 		o_txpipe7_rxeqclr;
	logic 		o_txpipe7_rxeqeval;
	logic 		o_txpipe7_rxeqinprogress;
	logic 		o_txpipe7_rxeqtraining;
	logic 		o_txpipe7_rxpolarity;
	logic  [2:0]	o_txpipe7_rxpresethint;
	logic 		o_txpipe7_rxstandby;
	logic 		o_txpipe7_rxtermination;
	logic 		o_txpipe7_srisenable;
	logic 		o_txpipe7_txcmnmode_disable_a;
	logic 		o_txpipe7_txcompliance;
	logic  [39:0]	o_txpipe7_txdata;
	logic  [3:0]	o_txpipe7_txdatak;
	logic 		o_txpipe7_txdatavalid;
	logic  [17:0]	o_txpipe7_txdeemph;
	logic 		o_txpipe7_txdtctrx_lb;
	logic 		o_txpipe7_txelecidle;
	logic  [2:0]	o_txpipe7_txmargin;
	logic 		o_txpipe7_txoneszeros;
	logic  [0:0]	o_txpipe7_txstartblock;
	logic 		o_txpipe7_txswing;
	logic  [3:0]	o_txpipe7_txsyncheader;
	logic  [2:0]	o_txpipe7_width;
	logic 		o_txpipe8_asyncpowerchangeack;
	logic 		o_txpipe8_blockaligncontrol;
	logic 		o_txpipe8_cfg_hw_auto_sp_dis;
	logic 		o_txpipe8_dirchange;
	logic 		o_txpipe8_ebuf_mode;
	logic 		o_txpipe8_encodedecodebypass;
	logic  [5:0]	o_txpipe8_fs;
	logic 		o_txpipe8_getlocalpresetcoefficients;
	logic 		o_txpipe8_invalidrequest;
	logic  [5:0]	o_txpipe8_lf;
	logic  [4:0]	o_txpipe8_localpresetindex;
//	logic 		o_txpipe8_lowpin_nt;
	logic  [7:0]	o_txpipe8_m2p_bus;
	logic  [2:0]	o_txpipe8_pclk_rate;
	logic 		o_txpipe8_pclkchangeack;
//	logic  [3:0]	o_txpipe8_phy_mode_nt;
	logic  [3:0]	o_txpipe8_powerdown;
	logic  [2:0]	o_txpipe8_rate;
	logic 		o_txpipe8_rxelecidle_disable_a;
//	logic 		o_txpipe8_rxeqclr;
	logic 		o_txpipe8_rxeqeval;
	logic 		o_txpipe8_rxeqinprogress;
	logic 		o_txpipe8_rxeqtraining;
	logic 		o_txpipe8_rxpolarity;
	logic  [2:0]	o_txpipe8_rxpresethint;
	logic 		o_txpipe8_rxstandby;
	logic 		o_txpipe8_rxtermination;
	logic 		o_txpipe8_srisenable;
	logic 		o_txpipe8_txcmnmode_disable_a;
	logic 		o_txpipe8_txcompliance;
	logic  [39:0]	o_txpipe8_txdata;
	logic  [3:0]	o_txpipe8_txdatak;
	logic 		o_txpipe8_txdatavalid;
	logic  [17:0]	o_txpipe8_txdeemph;
	logic 		o_txpipe8_txdtctrx_lb;
	logic 		o_txpipe8_txelecidle;
	logic  [2:0]	o_txpipe8_txmargin;
	logic 		o_txpipe8_txoneszeros;
	logic  [0:0]	o_txpipe8_txstartblock;
	logic 		o_txpipe8_txswing;
	logic  [3:0]	o_txpipe8_txsyncheader;
	logic  [2:0]	o_txpipe8_width;
	logic 		o_txpipe9_asyncpowerchangeack;
	logic 		o_txpipe9_blockaligncontrol;
	logic 		o_txpipe9_cfg_hw_auto_sp_dis;
	logic 		o_txpipe9_dirchange;
	logic 		o_txpipe9_ebuf_mode;
	logic 		o_txpipe9_encodedecodebypass;
	logic  [5:0]	o_txpipe9_fs;
	logic 		o_txpipe9_getlocalpresetcoefficients;
	logic 		o_txpipe9_invalidrequest;
	logic  [5:0]	o_txpipe9_lf;
	logic  [4:0]	o_txpipe9_localpresetindex;
//	logic 		o_txpipe9_lowpin_nt;
	logic  [7:0]	o_txpipe9_m2p_bus;
	logic  [2:0]	o_txpipe9_pclk_rate;
	logic 		o_txpipe9_pclkchangeack;
//	logic  [3:0]	o_txpipe9_phy_mode_nt;
	logic  [3:0]	o_txpipe9_powerdown;
	logic  [2:0]	o_txpipe9_rate;
	logic 		o_txpipe9_rxelecidle_disable_a;
//	logic 		o_txpipe9_rxeqclr;
	logic 		o_txpipe9_rxeqeval;
	logic 		o_txpipe9_rxeqinprogress;
	logic 		o_txpipe9_rxeqtraining;
	logic 		o_txpipe9_rxpolarity;
	logic  [2:0]	o_txpipe9_rxpresethint;
	logic 		o_txpipe9_rxstandby;
	logic 		o_txpipe9_rxtermination;
	logic 		o_txpipe9_srisenable;
	logic 		o_txpipe9_txcmnmode_disable_a;
	logic 		o_txpipe9_txcompliance;
	logic  [39:0]	o_txpipe9_txdata;
	logic  [3:0]	o_txpipe9_txdatak;
	logic 		o_txpipe9_txdatavalid;
	logic  [17:0]	o_txpipe9_txdeemph;
	logic 		o_txpipe9_txdtctrx_lb;
	logic 		o_txpipe9_txelecidle;
	logic  [2:0]	o_txpipe9_txmargin;
	logic 		o_txpipe9_txoneszeros;
	logic  [0:0]	o_txpipe9_txstartblock;
	logic 		o_txpipe9_txswing;
	logic  [3:0]	o_txpipe9_txsyncheader;
	logic  [2:0]	o_txpipe9_width;
	logic 		o_txpipe10_asyncpowerchangeack;
	logic 		o_txpipe10_blockaligncontrol;
	logic 		o_txpipe10_cfg_hw_auto_sp_dis;
	logic 		o_txpipe10_dirchange;
	logic 		o_txpipe10_ebuf_mode;
	logic 		o_txpipe10_encodedecodebypass;
	logic  [5:0]	o_txpipe10_fs;
	logic 		o_txpipe10_getlocalpresetcoefficients;
	logic 		o_txpipe10_invalidrequest;
	logic  [5:0]	o_txpipe10_lf;
	logic  [4:0]	o_txpipe10_localpresetindex;
//	logic 		o_txpipe10_lowpin_nt;
	logic  [7:0]	o_txpipe10_m2p_bus;
	logic  [2:0]	o_txpipe10_pclk_rate;
	logic 		o_txpipe10_pclkchangeack;
//	logic  [3:0]	o_txpipe10_phy_mode_nt;
	logic  [3:0]	o_txpipe10_powerdown;
	logic  [2:0]	o_txpipe10_rate;
	logic 		o_txpipe10_rxelecidle_disable_a;
//	logic 		o_txpipe10_rxeqclr;
	logic 		o_txpipe10_rxeqeval;
	logic 		o_txpipe10_rxeqinprogress;
	logic 		o_txpipe10_rxeqtraining;
	logic 		o_txpipe10_rxpolarity;
	logic  [2:0]	o_txpipe10_rxpresethint;
	logic 		o_txpipe10_rxstandby;
	logic 		o_txpipe10_rxtermination;
	logic 		o_txpipe10_srisenable;
	logic 		o_txpipe10_txcmnmode_disable_a;
	logic 		o_txpipe10_txcompliance;
	logic  [39:0]	o_txpipe10_txdata;
	logic  [3:0]	o_txpipe10_txdatak;
	logic 		o_txpipe10_txdatavalid;
	logic  [17:0]	o_txpipe10_txdeemph;
	logic 		o_txpipe10_txdtctrx_lb;
	logic 		o_txpipe10_txelecidle;
	logic  [2:0]	o_txpipe10_txmargin;
	logic 		o_txpipe10_txoneszeros;
	logic  [0:0]	o_txpipe10_txstartblock;
	logic 		o_txpipe10_txswing;
	logic  [3:0]	o_txpipe10_txsyncheader;
	logic  [2:0]	o_txpipe10_width;
	logic 		o_txpipe11_asyncpowerchangeack;
	logic 		o_txpipe11_blockaligncontrol;
	logic 		o_txpipe11_cfg_hw_auto_sp_dis;
	logic 		o_txpipe11_dirchange;
	logic 		o_txpipe11_ebuf_mode;
	logic 		o_txpipe11_encodedecodebypass;
	logic  [5:0]	o_txpipe11_fs;
	logic 		o_txpipe11_getlocalpresetcoefficients;
	logic 		o_txpipe11_invalidrequest;
	logic  [5:0]	o_txpipe11_lf;
	logic  [4:0]	o_txpipe11_localpresetindex;
//	logic 		o_txpipe11_lowpin_nt;
	logic  [7:0]	o_txpipe11_m2p_bus;
	logic  [2:0]	o_txpipe11_pclk_rate;
	logic 		o_txpipe11_pclkchangeack;
//	logic  [3:0]	o_txpipe11_phy_mode_nt;
	logic  [3:0]	o_txpipe11_powerdown;
	logic  [2:0]	o_txpipe11_rate;
	logic 		o_txpipe11_rxelecidle_disable_a;
//	logic 		o_txpipe11_rxeqclr;
	logic 		o_txpipe11_rxeqeval;
	logic 		o_txpipe11_rxeqinprogress;
	logic 		o_txpipe11_rxeqtraining;
	logic 		o_txpipe11_rxpolarity;
	logic  [2:0]	o_txpipe11_rxpresethint;
	logic 		o_txpipe11_rxstandby;
	logic 		o_txpipe11_rxtermination;
	logic 		o_txpipe11_srisenable;
	logic 		o_txpipe11_txcmnmode_disable_a;
	logic 		o_txpipe11_txcompliance;
	logic  [39:0]	o_txpipe11_txdata;
	logic  [3:0]	o_txpipe11_txdatak;
	logic 		o_txpipe11_txdatavalid;
	logic  [17:0]	o_txpipe11_txdeemph;
	logic 		o_txpipe11_txdtctrx_lb;
	logic 		o_txpipe11_txelecidle;
	logic  [2:0]	o_txpipe11_txmargin;
	logic 		o_txpipe11_txoneszeros;
	logic  [0:0]	o_txpipe11_txstartblock;
	logic 		o_txpipe11_txswing;
	logic  [3:0]	o_txpipe11_txsyncheader;
	logic  [2:0]	o_txpipe11_width;
	logic 		o_txpipe12_asyncpowerchangeack;
	logic 		o_txpipe12_blockaligncontrol;
	logic 		o_txpipe12_cfg_hw_auto_sp_dis;
	logic 		o_txpipe12_dirchange;
	logic 		o_txpipe12_ebuf_mode;
	logic 		o_txpipe12_encodedecodebypass;
	logic  [5:0]	o_txpipe12_fs;
	logic 		o_txpipe12_getlocalpresetcoefficients;
	logic 		o_txpipe12_invalidrequest;
	logic  [5:0]	o_txpipe12_lf;
	logic  [4:0]	o_txpipe12_localpresetindex;
//	logic 		o_txpipe12_lowpin_nt;
	logic  [7:0]	o_txpipe12_m2p_bus;
	logic  [2:0]	o_txpipe12_pclk_rate;
	logic 		o_txpipe12_pclkchangeack;
//	logic  [3:0]	o_txpipe12_phy_mode_nt;
	logic  [3:0]	o_txpipe12_powerdown;
	logic  [2:0]	o_txpipe12_rate;
	logic 		o_txpipe12_rxelecidle_disable_a;
//	logic 		o_txpipe12_rxeqclr;
	logic 		o_txpipe12_rxeqeval;
	logic 		o_txpipe12_rxeqinprogress;
	logic 		o_txpipe12_rxeqtraining;
	logic 		o_txpipe12_rxpolarity;
	logic  [2:0]	o_txpipe12_rxpresethint;
	logic 		o_txpipe12_rxstandby;
	logic 		o_txpipe12_rxtermination;
	logic 		o_txpipe12_srisenable;
	logic 		o_txpipe12_txcmnmode_disable_a;
	logic 		o_txpipe12_txcompliance;
	logic  [39:0]	o_txpipe12_txdata;
	logic  [3:0]	o_txpipe12_txdatak;
	logic 		o_txpipe12_txdatavalid;
	logic  [17:0]	o_txpipe12_txdeemph;
	logic 		o_txpipe12_txdtctrx_lb;
	logic 		o_txpipe12_txelecidle;
	logic  [2:0]	o_txpipe12_txmargin;
	logic 		o_txpipe12_txoneszeros;
	logic  [0:0]	o_txpipe12_txstartblock;
	logic 		o_txpipe12_txswing;
	logic  [3:0]	o_txpipe12_txsyncheader;
	logic  [2:0]	o_txpipe12_width;
	logic 		o_txpipe13_asyncpowerchangeack;
	logic 		o_txpipe13_blockaligncontrol;
	logic 		o_txpipe13_cfg_hw_auto_sp_dis;
	logic 		o_txpipe13_dirchange;
	logic 		o_txpipe13_ebuf_mode;
	logic 		o_txpipe13_encodedecodebypass;
	logic  [5:0]	o_txpipe13_fs;
	logic 		o_txpipe13_getlocalpresetcoefficients;
	logic 		o_txpipe13_invalidrequest;
	logic  [5:0]	o_txpipe13_lf;
	logic  [4:0]	o_txpipe13_localpresetindex;
//	logic 		o_txpipe13_lowpin_nt;
	logic  [7:0]	o_txpipe13_m2p_bus;
	logic  [2:0]	o_txpipe13_pclk_rate;
	logic 		o_txpipe13_pclkchangeack;
//	logic  [3:0]	o_txpipe13_phy_mode_nt;
	logic  [3:0]	o_txpipe13_powerdown;
	logic  [2:0]	o_txpipe13_rate;
	logic 		o_txpipe13_rxelecidle_disable_a;
//	logic 		o_txpipe13_rxeqclr;
	logic 		o_txpipe13_rxeqeval;
	logic 		o_txpipe13_rxeqinprogress;
	logic 		o_txpipe13_rxeqtraining;
	logic 		o_txpipe13_rxpolarity;
	logic  [2:0]	o_txpipe13_rxpresethint;
	logic 		o_txpipe13_rxstandby;
	logic 		o_txpipe13_rxtermination;
	logic 		o_txpipe13_srisenable;
	logic 		o_txpipe13_txcmnmode_disable_a;
	logic 		o_txpipe13_txcompliance;
	logic  [39:0]	o_txpipe13_txdata;
	logic  [3:0]	o_txpipe13_txdatak;
	logic 		o_txpipe13_txdatavalid;
	logic  [17:0]	o_txpipe13_txdeemph;
	logic 		o_txpipe13_txdtctrx_lb;
	logic 		o_txpipe13_txelecidle;
	logic  [2:0]	o_txpipe13_txmargin;
	logic 		o_txpipe13_txoneszeros;
	logic  [0:0]	o_txpipe13_txstartblock;
	logic 		o_txpipe13_txswing;
	logic  [3:0]	o_txpipe13_txsyncheader;
	logic  [2:0]	o_txpipe13_width;
	logic 		o_txpipe14_asyncpowerchangeack;
	logic 		o_txpipe14_blockaligncontrol;
	logic 		o_txpipe14_cfg_hw_auto_sp_dis;
	logic 		o_txpipe14_dirchange;
	logic 		o_txpipe14_ebuf_mode;
	logic 		o_txpipe14_encodedecodebypass;
	logic  [5:0]	o_txpipe14_fs;
	logic 		o_txpipe14_getlocalpresetcoefficients;
	logic 		o_txpipe14_invalidrequest;
	logic  [5:0]	o_txpipe14_lf;
	logic  [4:0]	o_txpipe14_localpresetindex;
//	logic 		o_txpipe14_lowpin_nt;
	logic  [7:0]	o_txpipe14_m2p_bus;
	logic  [2:0]	o_txpipe14_pclk_rate;
	logic 		o_txpipe14_pclkchangeack;
//	logic  [3:0]	o_txpipe14_phy_mode_nt;
	logic  [3:0]	o_txpipe14_powerdown;
	logic  [2:0]	o_txpipe14_rate;
	logic 		o_txpipe14_rxelecidle_disable_a;
//	logic 		o_txpipe14_rxeqclr;
	logic 		o_txpipe14_rxeqeval;
	logic 		o_txpipe14_rxeqinprogress;
	logic 		o_txpipe14_rxeqtraining;
	logic 		o_txpipe14_rxpolarity;
	logic  [2:0]	o_txpipe14_rxpresethint;
	logic 		o_txpipe14_rxstandby;
	logic 		o_txpipe14_rxtermination;
	logic 		o_txpipe14_srisenable;
	logic 		o_txpipe14_txcmnmode_disable_a;
	logic 		o_txpipe14_txcompliance;
	logic  [39:0]	o_txpipe14_txdata;
	logic  [3:0]	o_txpipe14_txdatak;
	logic 		o_txpipe14_txdatavalid;
	logic  [17:0]	o_txpipe14_txdeemph;
	logic 		o_txpipe14_txdtctrx_lb;
	logic 		o_txpipe14_txelecidle;
	logic  [2:0]	o_txpipe14_txmargin;
	logic 		o_txpipe14_txoneszeros;
	logic  [0:0]	o_txpipe14_txstartblock;
	logic 		o_txpipe14_txswing;
	logic  [3:0]	o_txpipe14_txsyncheader;
	logic  [2:0]	o_txpipe14_width;
	logic 		o_txpipe15_asyncpowerchangeack;
	logic 		o_txpipe15_blockaligncontrol;
	logic 		o_txpipe15_cfg_hw_auto_sp_dis;
	logic 		o_txpipe15_dirchange;
	logic 		o_txpipe15_ebuf_mode;
	logic 		o_txpipe15_encodedecodebypass;
	logic  [5:0]	o_txpipe15_fs;
	logic 		o_txpipe15_getlocalpresetcoefficients;
	logic 		o_txpipe15_invalidrequest;
	logic  [5:0]	o_txpipe15_lf;
	logic  [4:0]	o_txpipe15_localpresetindex;
//	logic 		o_txpipe15_lowpin_nt;
	logic  [7:0]	o_txpipe15_m2p_bus;
	logic  [2:0]	o_txpipe15_pclk_rate;
	logic 		o_txpipe15_pclkchangeack;
//	logic  [3:0]	o_txpipe15_phy_mode_nt;
	logic  [3:0]	o_txpipe15_powerdown;
	logic  [2:0]	o_txpipe15_rate;
	logic 		o_txpipe15_rxelecidle_disable_a;
//	logic 		o_txpipe15_rxeqclr;
	logic 		o_txpipe15_rxeqeval;
	logic 		o_txpipe15_rxeqinprogress;
	logic 		o_txpipe15_rxeqtraining;
	logic 		o_txpipe15_rxpolarity;
	logic  [2:0]	o_txpipe15_rxpresethint;
	logic 		o_txpipe15_rxstandby;
	logic 		o_txpipe15_rxtermination;
	logic 		o_txpipe15_srisenable;
	logic 		o_txpipe15_txcmnmode_disable_a;
	logic 		o_txpipe15_txcompliance;
	logic  [39:0]	o_txpipe15_txdata;
	logic  [3:0]	o_txpipe15_txdatak;
	logic 		o_txpipe15_txdatavalid;
	logic  [17:0]	o_txpipe15_txdeemph;
	logic 		o_txpipe15_txdtctrx_lb;
	logic 		o_txpipe15_txelecidle;
	logic  [2:0]	o_txpipe15_txmargin;
	logic 		o_txpipe15_txoneszeros;
	logic  [0:0]	o_txpipe15_txstartblock;
	logic 		o_txpipe15_txswing;
	logic  [3:0]	o_txpipe15_txsyncheader;
	logic  [2:0]	o_txpipe15_width;
	logic 	i_pclk_x4_l4;
	logic 	i_pclk_x4_l12;
	logic 	i_pclk_x8_l8;
	logic 	i_pclk_x16_l0;


      generate if (device_family == "Agilex 7") begin : gen_agilex
         tennm_clk_divider pcie_clk_divider_inst (
               .inclk      (coreclkout_hip),
               .clock_div1 (),
               .clock_div2 (),
               .clock_div4 (slow_clk)
               );    
      end else begin : gen_s10
         fourteennm_clk_divider pcie_clk_divider_inst (
               .inclk      (coreclkout_hip),
               .clock_div1 (),
               .clock_div2 (),
               .clock_div4 (slow_clk)
               );    
      end endgenerate
      altera_std_synchronizer_nocut #(
            .depth     (3),
            .rst_value (0)
      ) p0_slow_reset_status_n_sync_inst (
            .clk     (slow_clk),
            .reset_n (1'b1), // Active low rst
            .din     (p0_reset_status_n),
            .dout    (p0_slow_reset_status_n)
      );
      assign p0_hip_reconfig_clk = slow_clk;

   assign p0_user_vfnonfatalmsg_func_num_i   = 3'b000;
   assign p0_user_vfnonfatalmsg_vfnum_i      = 11'b00000000000;
   assign p0_user_sent_vfnonfatalmsg_i       = 1'b0;

   if (core16_enable_sriov_hwtcl == 1) begin
      assign  p0_rx_st_vf_active_wire =  p0_rx_st_vf_active_o; 
      assign  p0_rx_st_vf_num_wire    =  p0_rx_st_vf_num_o   ;
   end
   else begin
      assign  p0_rx_st_vf_active_wire =  0; 
      assign  p0_rx_st_vf_num_wire    =  0; 
   end
   
   if (core16_total_pf_count_hwtcl != 1) begin
      assign  p0_rx_st_func_num_wire  =  p0_rx_st_func_num_o ; 
   end
   else begin
      assign  p0_rx_st_func_num_wire  =  0;   
   end




   
   intel_pcie_mcdma_ftile_wrapper #(

                                    .total_pf_count_width_hwtcl                     (total_pf_count_width_hwtcl                   ),    
                                    .total_vf_count_width_hwtcl                     (total_vf_count_width_hwtcl                   ),
                                    .total_vf_count_hwtcl                           (total_vf_count_hwtcl                         ),
                                    .total_pf_count_hwtcl                           (total_pf_count_hwtcl                         ),
                                    .payload_width_integer_hwtcl                    (payload_width_integer_hwtcl                  ),
                                    .hdr_width_integer_hwtcl                        (hdr_width_integer_hwtcl                      ),
                                    .pfx_width_integer_hwtcl                        (pfx_width_integer_hwtcl                      ),
                                    .double_width_integer_hwtcl                     (double_width_integer_hwtcl                   ),
                                    .device_family                                  (device_family                                ),
                                    .data_width_hwtcl                               (data_width_hwtcl                             ),
                                    .empty_width_hwtcl                              (empty_width_hwtcl                            ),
                                    .burst_width_hwtcl                              (burst_width_hwtcl                            ),
                                    .pfnum_hwtcl                                    (pfnum_hwtcl                                  ),
                                    .pfnum_width_hwtcl                              (pfnum_width_hwtcl                            ),
                                    .vfnum_width_hwtcl                              (vfnum_width_hwtcl                            ),
                                    .pio_address_width_hwtcl                        (pio_address_width_hwtcl                      ),
                                    .cs_address_width_hwtcl                         (cs_address_width_hwtcl                       ),
                                    .att_en_for_bas_cs_hwtcl                        (att_en_for_bas_cs_hwtcl                      ),  
                                    .mapping_table_address_width_hwtcl              (mapping_table_address_width_hwtcl            ), 
                                    .mapping_window_address_width_hwtcl             (mapping_window_address_width_hwtcl           ),
                                    .msi_enable_hwtcl                               ( msi_enable_hwtcl                            ),
                                    .per_vec_mask_capable_hwtcl                     ( per_vec_mask_capable_hwtcl                  ),
                                    .addr_64bit_capable_hwtcl                       ( addr_64bit_capable_hwtcl                    ),
                                    .multi_msg_capable_hwtcl                        ( multi_msg_capable_hwtcl                     ),
                                    .ext_msg_data_capable_hwtcl                     ( ext_msg_data_capable_hwtcl                  ),      
                                    .pio_data_width_hwtcl                           (pio_data_width_hwtcl                         ),
                                    .uport_type_h2d_hwtcl                           (uport_type_h2d_hwtcl                         ),
                                    .uport_type_d2h_hwtcl                           (uport_type_d2h_hwtcl                         ),
                                    .tile_hwtcl                                     (tile_hwtcl                                   ),
                                    .core_index_hwtcl                               (0                                            ),
                                    .enable_cpl_timeout_hwtcl                       (core16_enable_cpl_timeout_hwtcl              ),
                                    .pf0_enable_sriov_hwtcl                         (pf0_enable_sriov_hwtcl                       ),
                                    .pf1_enable_sriov_hwtcl                         (pf1_enable_sriov_hwtcl                       ),
                                    .pf2_enable_sriov_hwtcl                         (pf2_enable_sriov_hwtcl                       ),
                                    .pf3_enable_sriov_hwtcl                         (pf3_enable_sriov_hwtcl                       ),
                                    .pf4_enable_sriov_hwtcl                         (pf4_enable_sriov_hwtcl                       ),
                                    .pf5_enable_sriov_hwtcl                         (pf5_enable_sriov_hwtcl                       ),
                                    .pf6_enable_sriov_hwtcl                         (pf6_enable_sriov_hwtcl                       ),
                                    .pf7_enable_sriov_hwtcl                         (pf7_enable_sriov_hwtcl                       ),
                                    .pf0_num_vf_per_pf_hwtcl                        (pf0_num_vf_per_pf_hwtcl                      ),
                                    .pf1_num_vf_per_pf_hwtcl                        (pf1_num_vf_per_pf_hwtcl                      ),
                                    .pf2_num_vf_per_pf_hwtcl                        (pf2_num_vf_per_pf_hwtcl                      ),
                                    .pf3_num_vf_per_pf_hwtcl                        (pf3_num_vf_per_pf_hwtcl                      ),
                                    .pf4_num_vf_per_pf_hwtcl                        (pf4_num_vf_per_pf_hwtcl                      ),
                                    .pf5_num_vf_per_pf_hwtcl                        (pf5_num_vf_per_pf_hwtcl                      ),
                                    .pf6_num_vf_per_pf_hwtcl                        (pf6_num_vf_per_pf_hwtcl                      ),
                                    .pf7_num_vf_per_pf_hwtcl                        (pf7_num_vf_per_pf_hwtcl                      ),
                                    .pf0_num_dma_chan_pf_hwtcl                      (pf0_num_dma_chan_pf_hwtcl                    ),
                                    .pf1_num_dma_chan_pf_hwtcl                      (pf1_num_dma_chan_pf_hwtcl                    ),
                                    .pf2_num_dma_chan_pf_hwtcl                      (pf2_num_dma_chan_pf_hwtcl                    ),
                                    .pf3_num_dma_chan_pf_hwtcl                      (pf3_num_dma_chan_pf_hwtcl                    ),
                                    .pf4_num_dma_chan_pf_hwtcl                      (pf4_num_dma_chan_pf_hwtcl                    ),
                                    .pf5_num_dma_chan_pf_hwtcl                      (pf5_num_dma_chan_pf_hwtcl                    ),
                                    .pf6_num_dma_chan_pf_hwtcl                      (pf6_num_dma_chan_pf_hwtcl                    ),
                                    .pf7_num_dma_chan_pf_hwtcl                      (pf7_num_dma_chan_pf_hwtcl                    ),
                                    .pf0_num_dma_chan_per_vf_hwtcl                  (pf0_num_dma_chan_per_vf_hwtcl                ),
                                    .pf1_num_dma_chan_per_vf_hwtcl                  (pf1_num_dma_chan_per_vf_hwtcl                ),
                                    .pf2_num_dma_chan_per_vf_hwtcl                  (pf2_num_dma_chan_per_vf_hwtcl                ),
                                    .pf3_num_dma_chan_per_vf_hwtcl                  (pf3_num_dma_chan_per_vf_hwtcl                ),
                                    .pf4_num_dma_chan_per_vf_hwtcl                  (pf4_num_dma_chan_per_vf_hwtcl                ),
                                    .pf5_num_dma_chan_per_vf_hwtcl                  (pf5_num_dma_chan_per_vf_hwtcl                ),
                                    .pf6_num_dma_chan_per_vf_hwtcl                  (pf6_num_dma_chan_per_vf_hwtcl                ),
                                    .pf7_num_dma_chan_per_vf_hwtcl                  (pf7_num_dma_chan_per_vf_hwtcl                ),
                                    .enable_user_msix_hwtcl                         (enable_user_msix_hwtcl                       ),
                                    .enable_user_flr_hwtcl                          (enable_user_flr_hwtcl                        ),
                                    .num_h2d_uport_hwtcl                            (num_h2d_uport_hwtcl                          ),
                                    .num_d2h_uport_hwtcl                            (num_d2h_uport_hwtcl                          ),
                                    .d2h_num_active_channel_hwtcl                   (d2h_num_active_channel_hwtcl                 ),
                                    .d2h_max_num_desc_fetch_hwtcl                   (d2h_max_num_desc_fetch_hwtcl                 ),
                                    .en_metadata_8_hwtcl                            (en_metadata_8_hwtcl                          ),
                                    .en_10bit_tag_hwtcl                             (en_10bit_tag_hwtcl                           ),
                                    .pio_bar2_size_per_f_hwtcl                      (pio_bar2_size_per_f_hwtcl                    ),
                                    .enable_bursting_master_hwtcl                   (enable_bursting_master_hwtcl                 ),
                                    .enable_bursting_slave_hwtcl                    (enable_bursting_slave_hwtcl                  ),
                                    .enable_mcdma_hwtcl                             (enable_mcdma_hwtcl                           ),
                                    .enable_byte_aligned_txfr_hwtcl                 (enable_byte_aligned_txfr_hwtcl               ),
                                    .enable_data_mover_hwtcl                        (enable_data_mover_hwtcl                      ),
                                    .pfcnt_w_hwtcl                                  (pfcnt_w_hwtcl                                ),
                                    .vfcnt_w_hwtcl                                  (vfcnt_w_hwtcl                                ),
                                    .bas_address_width_hwtcl                        (bas_address_width_hwtcl                      ),
                                    .max_bar_address_width_hwtcl                    (max_bar_address_width_hwtcl                  ),
                                    .enable_cs_hwtcl                                (enable_cs_hwtcl                              ),
                                    .core16_pf0_bar0_address_width_hwtcl            (core16_pf0_bar0_address_width_hwtcl          ),
                                    .core16_pf0_bar1_address_width_hwtcl            (core16_pf0_bar1_address_width_hwtcl          ),
                                    .core16_pf0_bar2_address_width_hwtcl            (core16_pf0_bar2_address_width_hwtcl          ),
                                    .core16_pf0_bar3_address_width_hwtcl            (core16_pf0_bar3_address_width_hwtcl          ),
                                    .core16_pf0_bar4_address_width_hwtcl            (core16_pf0_bar4_address_width_hwtcl          ),
                                    .core16_pf0_bar5_address_width_hwtcl            (core16_pf0_bar5_address_width_hwtcl          ),
                                    .core16_pf1_bar0_address_width_hwtcl            (core16_pf1_bar0_address_width_hwtcl          ),
                                    .core16_pf1_bar1_address_width_hwtcl            (core16_pf1_bar1_address_width_hwtcl          ),
                                    .core16_pf1_bar2_address_width_hwtcl            (core16_pf1_bar2_address_width_hwtcl          ),
                                    .core16_pf1_bar3_address_width_hwtcl            (core16_pf1_bar3_address_width_hwtcl          ),
                                    .core16_pf1_bar4_address_width_hwtcl            (core16_pf1_bar4_address_width_hwtcl          ),
                                    .core16_pf1_bar5_address_width_hwtcl            (core16_pf1_bar5_address_width_hwtcl          ),
                                    .core16_pf2_bar0_address_width_hwtcl            (core16_pf2_bar0_address_width_hwtcl          ),
                                    .core16_pf2_bar1_address_width_hwtcl            (core16_pf2_bar1_address_width_hwtcl          ),
                                    .core16_pf2_bar2_address_width_hwtcl            (core16_pf2_bar2_address_width_hwtcl          ),
                                    .core16_pf2_bar3_address_width_hwtcl            (core16_pf2_bar3_address_width_hwtcl          ),
                                    .core16_pf2_bar4_address_width_hwtcl            (core16_pf2_bar4_address_width_hwtcl          ),
                                    .core16_pf2_bar5_address_width_hwtcl            (core16_pf2_bar5_address_width_hwtcl          ),
                                    .core16_pf3_bar0_address_width_hwtcl            (core16_pf3_bar0_address_width_hwtcl          ),
                                    .core16_pf3_bar1_address_width_hwtcl            (core16_pf3_bar1_address_width_hwtcl          ),
                                    .core16_pf3_bar2_address_width_hwtcl            (core16_pf3_bar2_address_width_hwtcl          ),
                                    .core16_pf3_bar3_address_width_hwtcl            (core16_pf3_bar3_address_width_hwtcl          ),
                                    .core16_pf3_bar4_address_width_hwtcl            (core16_pf3_bar4_address_width_hwtcl          ),
                                    .core16_pf3_bar5_address_width_hwtcl            (core16_pf3_bar5_address_width_hwtcl          ),
                                    .core16_pf4_bar0_address_width_hwtcl            (core16_pf4_bar0_address_width_hwtcl          ),
                                    .core16_pf4_bar1_address_width_hwtcl            (core16_pf4_bar1_address_width_hwtcl          ),
                                    .core16_pf4_bar2_address_width_hwtcl            (core16_pf4_bar2_address_width_hwtcl          ),
                                    .core16_pf4_bar3_address_width_hwtcl            (core16_pf4_bar3_address_width_hwtcl          ),
                                    .core16_pf4_bar4_address_width_hwtcl            (core16_pf4_bar4_address_width_hwtcl          ),
                                    .core16_pf4_bar5_address_width_hwtcl            (core16_pf4_bar5_address_width_hwtcl          ),
                                    .core16_pf5_bar0_address_width_hwtcl            (core16_pf5_bar0_address_width_hwtcl          ),
                                    .core16_pf5_bar1_address_width_hwtcl            (core16_pf5_bar1_address_width_hwtcl          ),
                                    .core16_pf5_bar2_address_width_hwtcl            (core16_pf5_bar2_address_width_hwtcl          ),
                                    .core16_pf5_bar3_address_width_hwtcl            (core16_pf5_bar3_address_width_hwtcl          ),
                                    .core16_pf5_bar4_address_width_hwtcl            (core16_pf5_bar4_address_width_hwtcl          ),
                                    .core16_pf5_bar5_address_width_hwtcl            (core16_pf5_bar5_address_width_hwtcl          ),
                                    .core16_pf6_bar0_address_width_hwtcl            (core16_pf6_bar0_address_width_hwtcl          ),
                                    .core16_pf6_bar1_address_width_hwtcl            (core16_pf6_bar1_address_width_hwtcl          ),
                                    .core16_pf6_bar2_address_width_hwtcl            (core16_pf6_bar2_address_width_hwtcl          ),
                                    .core16_pf6_bar3_address_width_hwtcl            (core16_pf6_bar3_address_width_hwtcl          ),
                                    .core16_pf6_bar4_address_width_hwtcl            (core16_pf6_bar4_address_width_hwtcl          ),
                                    .core16_pf6_bar5_address_width_hwtcl            (core16_pf6_bar5_address_width_hwtcl          ),
                                    .core16_pf7_bar0_address_width_hwtcl            (core16_pf7_bar0_address_width_hwtcl          ),
                                    .core16_pf7_bar2_address_width_hwtcl            (core16_pf7_bar2_address_width_hwtcl          ),
                                    .core16_pf7_bar3_address_width_hwtcl            (core16_pf7_bar3_address_width_hwtcl          ),
                                    .core16_pf7_bar4_address_width_hwtcl            (core16_pf7_bar4_address_width_hwtcl          ),
                                    .core16_pf7_bar5_address_width_hwtcl            (core16_pf7_bar5_address_width_hwtcl          ),
                                    .core16_pf7_bar1_address_width_hwtcl            (core16_pf7_bar1_address_width_hwtcl          ),
                                    .core16_pf0_sriov_vf_bar0_address_width_hwtcl   (core16_pf0_sriov_vf_bar0_address_width_int_hwtcl ),
                                    .core16_pf0_sriov_vf_bar1_address_width_hwtcl   (core16_pf0_sriov_vf_bar1_address_width_int_hwtcl ),
                                    .core16_pf0_sriov_vf_bar2_address_width_hwtcl   (core16_pf0_sriov_vf_bar2_address_width_int_hwtcl ),
                                    .core16_pf0_sriov_vf_bar3_address_width_hwtcl   (core16_pf0_sriov_vf_bar3_address_width_int_hwtcl ),
                                    .core16_pf0_sriov_vf_bar4_address_width_hwtcl   (core16_pf0_sriov_vf_bar4_address_width_int_hwtcl ),
                                    .core16_pf0_sriov_vf_bar5_address_width_hwtcl   (core16_pf0_sriov_vf_bar5_address_width_int_hwtcl ),
                                    .core16_pf1_sriov_vf_bar0_address_width_hwtcl   (core16_pf1_sriov_vf_bar0_address_width_int_hwtcl ),
                                    .core16_pf1_sriov_vf_bar1_address_width_hwtcl   (core16_pf1_sriov_vf_bar1_address_width_int_hwtcl ),
                                    .core16_pf1_sriov_vf_bar2_address_width_hwtcl   (core16_pf1_sriov_vf_bar2_address_width_int_hwtcl ),
                                    .core16_pf1_sriov_vf_bar3_address_width_hwtcl   (core16_pf1_sriov_vf_bar3_address_width_int_hwtcl ),
                                    .core16_pf1_sriov_vf_bar4_address_width_hwtcl   (core16_pf1_sriov_vf_bar4_address_width_int_hwtcl ),
                                    .core16_pf1_sriov_vf_bar5_address_width_hwtcl   (core16_pf1_sriov_vf_bar5_address_width_int_hwtcl ),
                                    .core16_pf2_sriov_vf_bar0_address_width_hwtcl   (core16_pf2_sriov_vf_bar0_address_width_int_hwtcl ),
                                    .core16_pf2_sriov_vf_bar1_address_width_hwtcl   (core16_pf2_sriov_vf_bar1_address_width_int_hwtcl ),
                                    .core16_pf2_sriov_vf_bar2_address_width_hwtcl   (core16_pf2_sriov_vf_bar2_address_width_int_hwtcl ),
                                    .core16_pf2_sriov_vf_bar3_address_width_hwtcl   (core16_pf2_sriov_vf_bar3_address_width_int_hwtcl ),
                                    .core16_pf2_sriov_vf_bar4_address_width_hwtcl   (core16_pf2_sriov_vf_bar4_address_width_int_hwtcl ),
                                    .core16_pf2_sriov_vf_bar5_address_width_hwtcl   (core16_pf2_sriov_vf_bar5_address_width_int_hwtcl ),
                                    .core16_pf3_sriov_vf_bar0_address_width_hwtcl   (core16_pf3_sriov_vf_bar0_address_width_int_hwtcl ),
                                    .core16_pf3_sriov_vf_bar1_address_width_hwtcl   (core16_pf3_sriov_vf_bar1_address_width_int_hwtcl ),
                                    .core16_pf3_sriov_vf_bar2_address_width_hwtcl   (core16_pf3_sriov_vf_bar2_address_width_int_hwtcl ),
                                    .core16_pf3_sriov_vf_bar3_address_width_hwtcl   (core16_pf3_sriov_vf_bar3_address_width_int_hwtcl ),
                                    .core16_pf3_sriov_vf_bar4_address_width_hwtcl   (core16_pf3_sriov_vf_bar4_address_width_int_hwtcl ),
                                    .core16_pf3_sriov_vf_bar5_address_width_hwtcl   (core16_pf3_sriov_vf_bar5_address_width_int_hwtcl ),
                                    .core16_pf4_sriov_vf_bar0_address_width_hwtcl   (core16_pf4_sriov_vf_bar0_address_width_int_hwtcl ),
                                    .core16_pf4_sriov_vf_bar1_address_width_hwtcl   (core16_pf4_sriov_vf_bar1_address_width_int_hwtcl ),
                                    .core16_pf4_sriov_vf_bar2_address_width_hwtcl   (core16_pf4_sriov_vf_bar2_address_width_int_hwtcl ),
                                    .core16_pf4_sriov_vf_bar3_address_width_hwtcl   (core16_pf4_sriov_vf_bar3_address_width_int_hwtcl ),
                                    .core16_pf4_sriov_vf_bar4_address_width_hwtcl   (core16_pf4_sriov_vf_bar4_address_width_int_hwtcl ),
                                    .core16_pf4_sriov_vf_bar5_address_width_hwtcl   (core16_pf4_sriov_vf_bar5_address_width_int_hwtcl ),
                                    .core16_pf5_sriov_vf_bar0_address_width_hwtcl   (core16_pf5_sriov_vf_bar0_address_width_int_hwtcl ),
                                    .core16_pf5_sriov_vf_bar1_address_width_hwtcl   (core16_pf5_sriov_vf_bar1_address_width_int_hwtcl ),
                                    .core16_pf5_sriov_vf_bar2_address_width_hwtcl   (core16_pf5_sriov_vf_bar2_address_width_int_hwtcl ),
                                    .core16_pf5_sriov_vf_bar3_address_width_hwtcl   (core16_pf5_sriov_vf_bar3_address_width_int_hwtcl ),
                                    .core16_pf5_sriov_vf_bar4_address_width_hwtcl   (core16_pf5_sriov_vf_bar4_address_width_int_hwtcl ),
                                    .core16_pf5_sriov_vf_bar5_address_width_hwtcl   (core16_pf5_sriov_vf_bar5_address_width_int_hwtcl ),
                                    .core16_pf6_sriov_vf_bar0_address_width_hwtcl   (core16_pf6_sriov_vf_bar0_address_width_int_hwtcl ),
                                    .core16_pf6_sriov_vf_bar1_address_width_hwtcl   (core16_pf6_sriov_vf_bar1_address_width_int_hwtcl ),
                                    .core16_pf6_sriov_vf_bar2_address_width_hwtcl   (core16_pf6_sriov_vf_bar2_address_width_int_hwtcl ),
                                    .core16_pf6_sriov_vf_bar3_address_width_hwtcl   (core16_pf6_sriov_vf_bar3_address_width_int_hwtcl ),
                                    .core16_pf6_sriov_vf_bar4_address_width_hwtcl   (core16_pf6_sriov_vf_bar4_address_width_int_hwtcl ),
                                    .core16_pf6_sriov_vf_bar5_address_width_hwtcl   (core16_pf6_sriov_vf_bar5_address_width_int_hwtcl ),
                                    .core16_pf7_sriov_vf_bar0_address_width_hwtcl   (core16_pf7_sriov_vf_bar0_address_width_int_hwtcl ),
                                    .core16_pf7_sriov_vf_bar1_address_width_hwtcl   (core16_pf7_sriov_vf_bar1_address_width_int_hwtcl ),
                                    .core16_pf7_sriov_vf_bar2_address_width_hwtcl   (core16_pf7_sriov_vf_bar2_address_width_int_hwtcl ),
                                    .core16_pf7_sriov_vf_bar3_address_width_hwtcl   (core16_pf7_sriov_vf_bar3_address_width_int_hwtcl ),
                                    .core16_pf7_sriov_vf_bar4_address_width_hwtcl   (core16_pf7_sriov_vf_bar4_address_width_int_hwtcl ),
                                    .core16_pf7_sriov_vf_bar5_address_width_hwtcl   (core16_pf7_sriov_vf_bar5_address_width_int_hwtcl )
      
                                    ) 
   mcdma (
          .clk                                  ( coreclkout_hip                    ), 
          .rst_n                                ( p0_reset_status_n                 ),
          // Slow clock and reset from HIP
          .slow_clk                             ( slow_clk                          ),
          .slow_rst_n                           ( p0_slow_reset_status_n            ),

          .rx_st_ready_o                        (  p0_rx_st_ready_i                 ), 
          .rx_st_valid_i                        (  p0_rx_st_valid_o                 ),
          .rx_st_sop_i                          (  p0_rx_st_sop_o                   ),
          .rx_st_eop_i                          (  p0_rx_st_eop_o                   ),
          .rx_st_hdr_i                          (  p0_rx_st_hdr_o                   ),
          .rx_st_data_i                         (  p0_rx_st_data_o                  ),
          .rx_st_vf_active_i                    (  p0_rx_st_vf_active_wire          ),
          .rx_st_func_num_i                     (  p0_rx_st_func_num_wire           ),
          .rx_st_vf_num_i                       (  p0_rx_st_vf_num_wire             ),
          .rx_st_bar_range_i                    (  p0_rx_st_bar_range_o             ),
          .rx_par_err_i                         (  p0_rx_par_err_o                  ),
          .rx_st_empty_i                        (  p0_rx_st_empty_o                 ),
          .rx_st_tlp_prfx_i                     (  p0_rx_st_tlp_prfx_o              ),
          .rx_st_tlp_abort_i                    (  p0_rx_st_tlp_abort_o             ),
          .rx_st_data_par_i                     (  '0                               ),
          .rx_st_hdr_par_i                      (  '0                               ),
          .rx_st_tlp_prfx_par_i                 (  '0                               ),


          .tx_st_ready_i                        (  p0_tx_st_ready_o                ),
          .tx_par_err_i                         (  p0_tx_par_err_o                 ),
          .tx_st_valid_o                        (  p0_tx_st_valid_i                ),
          .tx_st_sop_o                          (  p0_tx_st_sop_i                  ),
          .tx_st_eop_o                          (  p0_tx_st_eop_i                  ),
          .tx_st_err_o                          (  p0_tx_st_err_i                  ),
          .tx_st_hdr_o                          (  p0_tx_st_hdr_i                  ),
          .tx_st_data_o                         (  p0_tx_st_data_i                 ),
          //.tx_st_vf_active_o                    (/.tx_st_vf_active_o               ),
          .tx_st_tlp_prfx_o                     (  p0_tx_st_tlp_prfx_i             ),
          .tx_st_data_par_o                     (  p0_tx_st_data_par_i             ),
          .tx_st_hdr_par_o                      (  p0_tx_st_hdr_par_i              ),
          .tx_st_tlp_prfx_par_o                 (  p0_tx_st_tlp_prfx_par_i         ),

          .dl_timer_update_i                    ( p0_dl_timer_update_o              ),
          .dl_up_i                              ( p0_dl_up_o                        ), // signal indicates the Data Link (DL) Layer is active
          .link_up_i                            ( p0_link_up_o                      ), // signal indicates the link is up
      
          .tx_cdts_limit_i                      ( p0_tx_cdts_limit_o              ),
          .tx_cdts_limit_tdm_idx_i              ( p0_tx_cdts_limit_tdm_idx_o      ),
      
          .rx_buffer_limit_o                    ( p0_rx_buffer_limit_i            ),
          .rx_buffer_limit_tdm_idx_o            ( p0_rx_buffer_limit_tdm_idx_i    ),
      
          .tl_cfg_func_i                        ( p0_tl_cfg_func_o            ),
          .tl_cfg_add_i                         ( p0_tl_cfg_add_o             ),
          .tl_cfg_ctl_i                         ( p0_tl_cfg_ctl_o             ),

          .usr_hip_tl_cfg_func_o                (usr_hip_tl_cfg_func_o        ),       
          .usr_hip_tl_cfg_add_o                 (usr_hip_tl_cfg_add_o         ),        
          .usr_hip_tl_cfg_ctl_o                 (usr_hip_tl_cfg_ctl_o         ),        
      
          .hip_reconfig_read_o                  ( p0_hip_reconfig_read               ),
          .hip_reconfig_address_o               ( p0_hip_reconfig_address            ),
          .hip_reconfig_write_o                 ( p0_hip_reconfig_write              ),
          .hip_reconfig_writedata_o             ( p0_hip_reconfig_writedata          ),
          .hip_reconfig_readdatavalid_i         ( core16_hip_reconfig_hwtcl ? p0_hip_reconfig_readdatavalid : '0 ),
          .hip_reconfig_readdata_i              ( core16_hip_reconfig_hwtcl ? p0_hip_reconfig_readdata      : '0 ),
          .hip_reconfig_waitrequest_i           ( core16_hip_reconfig_hwtcl ? p0_hip_reconfig_waitrequest   : '0 ),
      
          .flr_rcvd_pf_i                        ( core16_flr_cap_hwtcl ? p0_flr_rcvd_pf_o : '0     ),
          .flr_rcvd_vf_i                        ( (core16_flr_cap_hwtcl & core16_enable_sriov_hwtcl) ? p0_flr_rcvd_vf_o : '0     ),
          .flr_rcvd_pf_num_i                    ( (core16_flr_cap_hwtcl & core16_enable_sriov_hwtcl) ? 3'(p0_flr_rcvd_pf_num_o) : 3'b0 ),
          .flr_rcvd_vf_num_i                    ( (core16_flr_cap_hwtcl & core16_enable_sriov_hwtcl) ? 11'(p0_flr_rcvd_vf_num_o) : 11'b0  ),
          .flr_completed_pf_o                   ( p0_flr_completed_pf_i                 ),
          .flr_completed_vf_o                   ( p0_flr_completed_vf_i                 ),
          .flr_completed_pf_num_o               ( p0_flr_completed_pf_num_i             ),
          .flr_completed_vf_num_o               ( p0_flr_completed_vf_num_i             ),
      
          .cpl_timeout_i                        ( core16_enable_cpl_timeout_hwtcl ? p0_cpl_timeout_o : '0 ),
      
          .app_err_valid_o                      ( p0_app_err_valid_i                     ),
          .app_err_hdr_o                        ( p0_app_err_hdr_i                       ),
          .app_err_info_o                       ( p0_app_err_info_i                      ),
          .app_err_func_num_o                   ( p0_app_err_func_num_i                  ),
          .serr_i                               ( p0_serr_out_o                          ),
          .hip_enter_err_mode_i                 ( p0_hip_enter_err_mode_o                ),
      
          .app_rst_n                            ( app_rst_n                       ),
          .pin_perst_n                          ( p0_pin_perst_n                  ),
          .app_clk                              ( app_clk                         ),

          .hip_10bits_tag_req_en_i              ( en_10bit_tag_hwtcl ? p0_10bits_tag_req_en_o : '0 ),

          .hip_msi_pnd_func_o                   ( p0_msi_pnd_func_i ),
          .hip_msi_pnd_addr_o                   ( p0_msi_pnd_addr_i ),
          .hip_msi_pnd_byte_o                   ( p0_msi_pnd_byte_i ),

          .msi_req_i                        ( msi_req_i                        ),
          .msi_func_num_i                   ( msi_func_num_i                   ),
          .msi_num_i                        ( msi_num_i                        ),
          .msi_ack_o                        ( msi_ack_o                        ),
          .msi_status_o                     ( msi_status_o                     ), 

          .bam_waitrequest_i                (bam_waitrequest_i),   
          .bam_address_o                    (bam_address_o),       
          .bam_byteenable_o                 (bam_byteenable_o),    
          .bam_read_o                       (bam_read_o),          
          .bam_readdata_i                   (bam_readdata_i),      
          .bam_readdatavalid_i              (bam_readdatavalid_i), 
          .bam_write_o                      (bam_write_o),         
          .bam_writedata_o                  (bam_writedata_o),     
          .bam_burstcount_o                 (bam_burstcount_o),

          .rx_pio_address_o                 (     rx_pio_address_o             ),  
          .rx_pio_byteenable_o              (     rx_pio_byteenable_o          ),  
          .rx_pio_read_o                    (     rx_pio_read_o                ), 
          .rx_pio_write_o                   (     rx_pio_write_o               ), 
          .rx_pio_writedata_o               (     rx_pio_writedata_o           ), 
          .rx_pio_burstcount_o              (     rx_pio_burstcount_o          ), 
          .rx_pio_waitrequest_i             (     rx_pio_waitrequest_i         ), 
          .rx_pio_readdata_i                (     rx_pio_readdata_i            ), 
          .rx_pio_readdatavalid_i           (     rx_pio_readdatavalid_i       ), 
          .rx_pio_response_i                (     rx_pio_response_i            ), 
          .rx_pio_writeresponsevalid_i      (     rx_pio_writeresponsevalid_i   ), 
      
          .h2d_st_sof_0_o                   (    h2d_st_sof_0_o                ), 
          .h2d_st_eof_0_o                   (    h2d_st_eof_0_o                ), 
          .h2d_st_empty_0_o                 (    h2d_st_empty_0_o              ), 
          .h2d_st_ready_0_i                 (    h2d_st_ready_0_i              ), 
          .h2d_st_valid_0_o                 (    h2d_st_valid_0_o              ), 
          .h2d_st_data_0_o                  (    h2d_st_data_0_o               ), 
          .h2d_st_channel_0_o               (    h2d_st_channel_0_o            ), 
      
          .h2d_st_sof_1_o                   (    h2d_st_sof_1_o                ), 
          .h2d_st_eof_1_o                   (    h2d_st_eof_1_o                ), 
          .h2d_st_empty_1_o                 (    h2d_st_empty_1_o              ), 
          .h2d_st_ready_1_i                 (    h2d_st_ready_1_i              ), 
          .h2d_st_valid_1_o                 (    h2d_st_valid_1_o              ), 
          .h2d_st_data_1_o                  (    h2d_st_data_1_o               ), 
          .h2d_st_channel_1_o               (    h2d_st_channel_1_o            ), 

          .h2d_st_sof_2_o                   (    h2d_st_sof_2_o                ), 
          .h2d_st_eof_2_o                   (    h2d_st_eof_2_o                ), 
          .h2d_st_empty_2_o                 (    h2d_st_empty_2_o              ), 
          .h2d_st_ready_2_i                 (    h2d_st_ready_2_i              ), 
          .h2d_st_valid_2_o                 (    h2d_st_valid_2_o              ), 
          .h2d_st_data_2_o                  (    h2d_st_data_2_o               ), 
          .h2d_st_channel_2_o               (    h2d_st_channel_2_o            ), 

          .h2d_st_sof_3_o                   (    h2d_st_sof_3_o                ), 
          .h2d_st_eof_3_o                   (    h2d_st_eof_3_o                ), 
          .h2d_st_empty_3_o                 (    h2d_st_empty_3_o              ), 
          .h2d_st_ready_3_i                 (    h2d_st_ready_3_i              ), 
          .h2d_st_valid_3_o                 (    h2d_st_valid_3_o              ), 
          .h2d_st_data_3_o                  (    h2d_st_data_3_o               ), 
          .h2d_st_channel_3_o               (    h2d_st_channel_3_o            ), 
      
          .h2ddm_waitrequest_i              (    h2ddm_waitrequest_i           ), 
          .h2ddm_writeresponsevalid_i       (    h2ddm_writeresponsevalid_i    ), 
          .h2ddm_write_o                    (    h2ddm_write_o                 ), 
          .h2ddm_address_o                  (    h2ddm_address_o               ), 
          .h2ddm_burstcount_o               (    h2ddm_burstcount_o            ), 
          .h2ddm_byteenable_o               (    h2ddm_byteenable_o            ), 
          .h2ddm_writedata_o                (    h2ddm_writedata_o             ), 
      
          .d2h_st_sof_0_i                   (    d2h_st_sof_0_i                ), 
          .d2h_st_eof_0_i                   (    d2h_st_eof_0_i                ), 
          .d2h_st_empty_0_i                 (    d2h_st_empty_0_i              ), 
          .d2h_st_channel_0_i               (    d2h_st_channel_0_i            ), 
          .d2h_st_valid_0_i                 (    d2h_st_valid_0_i              ), 
          .d2h_st_data_0_i                  (    d2h_st_data_0_i               ), 
          .d2h_st_ready_0_o                 (    d2h_st_ready_0_o              ), 
      
          .d2h_st_sof_1_i                   (    d2h_st_sof_1_i                ), 
          .d2h_st_eof_1_i                   (    d2h_st_eof_1_i                ), 
          .d2h_st_empty_1_i                 (    d2h_st_empty_1_i              ), 
          .d2h_st_channel_1_i               (    d2h_st_channel_1_i            ), 
          .d2h_st_valid_1_i                 (    d2h_st_valid_1_i              ), 
          .d2h_st_data_1_i                  (    d2h_st_data_1_i               ), 
          .d2h_st_ready_1_o                 (    d2h_st_ready_1_o              ), 
      
          .d2h_st_sof_2_i                   (    d2h_st_sof_2_i                ), 
          .d2h_st_eof_2_i                   (    d2h_st_eof_2_i                ), 
          .d2h_st_empty_2_i                 (    d2h_st_empty_2_i              ), 
          .d2h_st_channel_2_i               (    d2h_st_channel_2_i            ), 
          .d2h_st_valid_2_i                 (    d2h_st_valid_2_i              ), 
          .d2h_st_data_2_i                  (    d2h_st_data_2_i               ), 
          .d2h_st_ready_2_o                 (    d2h_st_ready_2_o              ), 
      
          .d2h_st_sof_3_i                   (    d2h_st_sof_3_i                ), 
          .d2h_st_eof_3_i                   (    d2h_st_eof_3_i                ), 
          .d2h_st_empty_3_i                 (    d2h_st_empty_3_i              ), 
          .d2h_st_channel_3_i               (    d2h_st_channel_3_i            ), 
          .d2h_st_valid_3_i                 (    d2h_st_valid_3_i              ), 
          .d2h_st_data_3_i                  (    d2h_st_data_3_i               ), 
          .d2h_st_ready_3_o                 (    d2h_st_ready_3_o              ), 
      
          .d2hdm_address_o                  (    d2hdm_address_o               ), 
          .d2hdm_byteenable_o               (    d2hdm_byteenable_o            ), 
          .d2hdm_read_o                     (    d2hdm_read_o                  ), 
          .d2hdm_burstcount_o               (    d2hdm_burstcount_o            ), 
          .d2hdm_waitrequest_i              (    d2hdm_waitrequest_i           ), 
          .d2hdm_readdata_i                 (    d2hdm_readdata_i              ), 
          .d2hdm_readdatavalid_i            (    d2hdm_readdatavalid_i         ), 
          .d2hdm_response_i                 (    d2hdm_response_i              ), 

          .h2ddm_desc_ready_o               ( h2ddm_desc_ready_o                ),
          .h2ddm_desc_valid_i               ( h2ddm_desc_valid_i                ), 
          .h2ddm_desc_data_i                ( h2ddm_desc_data_i                 ), // h2d_desc_bypass_t

          .h2ddm_desc_status_data_o         ( h2ddm_desc_status_data_o          ), // h2d_desc_status_t
          .h2ddm_desc_status_valid_o        ( h2ddm_desc_status_valid_o         ),

          .h2ddm_desc_cmpl_data_o           ( h2ddm_desc_cmpl_data_o            ), // h2d_desc_cmpl_t
          .h2ddm_desc_cmpl_empty_o          ( h2ddm_desc_cmpl_empty_o           ), 
          .h2ddm_desc_cmpl_sop_o            ( h2ddm_desc_cmpl_sop_o             ), 
          .h2ddm_desc_cmpl_eop_o            ( h2ddm_desc_cmpl_eop_o             ), 
          .h2ddm_desc_cmpl_valid_o          ( h2ddm_desc_cmpl_valid_o           ), 
          .h2ddm_desc_cmpl_ready_i          ( h2ddm_desc_cmpl_ready_i           ),

          .d2hdm_desc_ready_o               ( d2hdm_desc_ready_o                ), 
          .d2hdm_desc_valid_i               ( d2hdm_desc_valid_i                ), 
          .d2hdm_desc_data_i                ( d2hdm_desc_data_i                 ), // d2h_desc_bypass_t

          .d2hdm_desc_status_data_o         ( d2hdm_desc_status_data_o          ), // d2h_desc_status_t
          .d2hdm_desc_status_valid_o        ( d2hdm_desc_status_valid_o         ),

          .usr_event_msix_valid_i           (    usr_event_msix_valid_i        ), 
          .usr_event_msix_ready_o           (    usr_event_msix_ready_o        ), 
          .usr_event_msix_data_i            (    usr_event_msix_data_i         ), 
      
          .usr_flr_rcvd_val_o               (    usr_flr_rcvd_val_o            ), 
          .usr_flr_rcvd_chan_num_o          (    usr_flr_rcvd_chan_num_o       ), 
          .usr_flr_completed_i              (    usr_flr_completed_i           ), 
      
          .bas_vfactive_i                   (    bas_vfactive_i                ), 
          .bas_pfnum_i                      (    bas_pfnum_i                   ), 
          .bas_vfnum_i                      (    bas_vfnum_i                   ), 
          .bas_address_i                    (    bas_address_i                 ), 
          .bas_byteenable_i                 (    bas_byteenable_i              ), 
          .bas_read_i                       (    bas_read_i                    ), 
          .bas_write_i                      (    bas_write_i                   ), 
          .bas_writedata_i                  (    bas_writedata_i               ), 
          .bas_burstcount_i                 (    bas_burstcount_i              ), 
          .bas_waitrequest_o                (    bas_waitrequest_o             ), 
          .bas_readdata_o                   (    bas_readdata_o                ), 
          .bas_readdatavalid_o              (    bas_readdatavalid_o           ), 
          .bas_response_o                   (    bas_response_o                ), 

      
          .usr_hip_reconfig_address_i       (    usr_hip_reconfig_address_i    ), 
          .usr_hip_reconfig_read_i          (    usr_hip_reconfig_read_i       ), 
          .usr_hip_reconfig_write_i         (    usr_hip_reconfig_write_i      ), 
          .usr_hip_reconfig_writedata_i     (    usr_hip_reconfig_writedata_i  ), 
          .usr_hip_reconfig_readdata_o      (    usr_hip_reconfig_readdata_o   ), 
          .usr_hip_reconfig_readdatavalid_o ( usr_hip_reconfig_readdatavalid_o ), 
          .usr_hip_reconfig_waitrequest_o   ( usr_hip_reconfig_waitrequest_o   ), 
      
          .cs_waitrequest_o                 (    cs_waitrequest_o              ), 
          .cs_address_i                     (    cs_address_i                  ), 
          .cs_byteenable_i                  (    cs_byteenable_i               ), 
          .cs_read_i                        (    cs_read_i                     ), 
          .cs_readdata_o                    (    cs_readdata_o                 ), 
          .cs_readdatavalid_o               (    cs_readdatavalid_o            ), 
          .cs_write_i                       (    cs_write_i                    ), 
          .cs_writedata_i                   (    cs_writedata_i                ), 
          .cs_response_o                    (    cs_response_o                 ), 
          .cs_writeresponsevalid_o          (    cs_writeresponsevalid_o       ) 
          );
     assign usr_hip_reconfig_rst_n_o   = p0_slow_reset_status_n;
     assign usr_hip_reconfig_clk_o     = slow_clk;




   pcie_ftile_mcdma_intel_pcie_ftile_mcdma_pcie_avst_f_800_sfummay 
     ast_hip (
              .*
              );

endmodule



