# (C) 2001-2023 Intel Corporation. All rights reserved.
# Your use of Intel Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Intel Program License Subscription 
# Agreement, Intel FPGA IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Intel and sold by 
# Intel or its authorized distributors.  Please refer to the applicable 
# agreement for further details.



set pcie_sdc_debug 0

# Check if port exists
proc pcie_port_existence {port_name} {
   set port_collection [get_ports -nowarn $port_name]
   if { [get_collection_size $port_collection] > 0 } {
      return 1
   } else {
      return 0
   }
}

# Return existing clock target list
proc pcie_get_clock_target_list {} {
   upvar 1 pcie_sdc_debug pcie_sdc_debug

   set result [list]
   set clocks_collection [get_clocks -nowarn]
   foreach_in_collection clock $clocks_collection { 
      if { ![is_clock_defined $clock] } {
         continue
      }
      set clock_name       [get_clock_info -name $clock] 
      set clock_target_col [get_clock_info -targets $clock]
      lappend result       [query_collection -report -all $clock_target_col]
      if {$pcie_sdc_debug} { post_message -type info "clock_name : $clock_name" }
   }
   if {$pcie_sdc_debug} { post_message -type info "PCIe clock_target list: $result" }

   return $result
}

set pcie_clock_target_list [pcie_get_clock_target_list]

# create refclk for UX PHY
set pcie_refclk0_ext  [pcie_port_existence refclk0]
set pcie_refclk0_lsrc [lsearch -exact $pcie_clock_target_list refclk0]
if {$pcie_refclk0_ext && $pcie_refclk0_lsrc == -1} {
   create_clock -period 10 -name refclk0 refclk0
}

set pcie_refclk1_ext  [pcie_port_existence refclk1]
set pcie_refclk1_lsrc [lsearch -exact $pcie_clock_target_list refclk1]
if {$pcie_refclk1_ext && $pcie_refclk1_lsrc == -1} {
   create_clock -period 10 -name refclk1 refclk1
}

set pcie_refclk2_ext  [pcie_port_existence refclk2]
set pcie_refclk2_lsrc [lsearch -exact $pcie_clock_target_list refclk2]
if {$pcie_refclk2_ext && $pcie_refclk2_lsrc == -1} {
   create_clock -period 10 -name refclk2 refclk2
}

set pcie_refclk3_ext  [pcie_port_existence refclk3]
set pcie_refclk3_lsrc [lsearch -exact $pcie_clock_target_list refclk3]
if {$pcie_refclk3_ext && $pcie_refclk3_lsrc == -1} {
   create_clock -period 10 -name refclk3 refclk3
}


# create refclk for reconfig interface
set pcie_p0_hip_reconfig_clk_ext  [pcie_port_existence p0_hip_reconfig_clk]
set pcie_p0_hip_reconfig_clk_lsrc [lsearch -exact $pcie_clock_target_list p0_hip_reconfig_clk]
if {$pcie_p0_hip_reconfig_clk_ext && $pcie_p0_hip_reconfig_clk_lsrc == -1} {
   create_clock -period 10 -name p0_hip_reconfig_clk p0_hip_reconfig_clk
}


# active AIB channels
set pcie_active_ch 20
set pcie_ch6ch7_en 0

# get current IP instance 
set ip_inst_name [get_current_instance]

if {$pcie_sdc_debug == 1} {
   post_message -type info "Current instance: $ip_inst_name"
}

## KAHUAT_add
#######################################################################
################# Set false path for synchronizer #####################

set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|g_p0_reset_status_n.p0_reset_status_n_sync_inst|din_s1]
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|g_p0_reset_status_n.p0_reset_status_n_sync_inst|dreg[*]]



####################################


##### Non Disabled System Topology ##########
# core16_hip_reconfig
# Sync reset_status_n to AVMM clock
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|g_p0_pin_perst.pin_perst_n_p0_sync_inst|din_s1]
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|g_p0_pin_perst.pin_perst_n_p0_sync_inst|dreg[*]]
####################################

##### 2x8 and 4x4 Topology ##########

####################################

####### 2x4 and 4x4 Topology ###############

####################################

####### 4x4 Topology ###############

####################################



## Sync ninit_done to avmm_clk
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_avmm_src_alive_sync.p0_avmm_ninit_done_sync_inst|din_s1]
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_avmm_src_alive_sync.p0_avmm_ninit_done_sync_inst|dreg[*]]




## SRC BTI Related ##
set_false_path -from [get_keepers ${ip_inst_name}|pcie_sip_top_inst|pcie_src_inst|pld_adapter_tx_pld_rst_n_r_ch*[*]] -to [get_keepers *auto_tiles|z1577*|hdpldadapt_tx_chnl_*~pld_tx_clk1_dcm.reg] 
set_false_path -from [get_keepers ${ip_inst_name}|pcie_sip_top_inst|pcie_src_inst|pld_adapter_rx_pld_rst_n_r_ch*[*]] -to [get_keepers *auto_tiles|z1577*|hdpldadapt_rx_chnl_*~pld_rx_clk1_dcm.reg] 
set_false_path -from [get_keepers ${ip_inst_name}|pcie_sip_top_inst|pcie_src_inst|pld_adapter_rx_pld_rst_n_r_ch*[*]] -to [get_keepers *auto_tiles|z1577*|hdpldadapt_tx_chnl_*~pld_tx_clk1_dcm.reg] 
set_false_path -from [get_keepers ${ip_inst_name}|pcie_sip_top_inst|pcie_src_inst|cur_state*] -to [get_keepers ${ip_inst_name}|pcie_sip_top_inst|pcie_src_inst|cur_state*|din_s1]
set_false_path -from [get_keepers ${ip_inst_name}|pcie_sip_top_inst|pcie_src_inst|cur_state*] -to [get_keepers ${ip_inst_name}|pcie_sip_top_inst|pcie_src_inst|p*_hot_rst_cur_state[*]]
set_false_path -from [get_keepers ${ip_inst_name}|pcie_sip_top_inst|pcie_src_inst|in_warm_rst*] -to [get_keepers ${ip_inst_name}|pcie_sip_top_inst|pcie_src_inst|in_warm_rst_inst|*]

## Sync ninit_done to xcvr_clk

## Sync ninit_done to coreclkout_hip
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|pld_clk_ninit_done_sync_inst|din_s1]
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|pld_clk_ninit_done_sync_inst|dreg[*]]

## Sync pld_in_use to coreclkout_hip
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_signal_sync.p0_pld_in_use_sync_inst|din_s1]
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_signal_sync.p0_pld_in_use_sync_inst|dreg[*]]

## Sync pld_link_req_rst_n to coreclkout_hip
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_signal_sync.p0_pld_link_req_rst_n_sync_inst|din_s1]
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_signal_sync.p0_pld_link_req_rst_n_sync_inst|dreg[*]]

## Sync reset_status to coreclkout_hip
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_signal_sync.p0_reset_status_sync|din_s1]
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_signal_sync.p0_reset_status_sync|dreg[*]]

## Sync tx_dsk_done to coreclkout_hip
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_signal_sync.p0_tx_dsk_done_sync_inst|din_s1]
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_signal_sync.p0_tx_dsk_done_sync_inst|dreg[*]]

## Sync tx_st_ready to coreclkout_hip
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_signal_sync.p0_tx_st_ready_sync_inst|din_s1]
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|g_p0_signal_sync.p0_tx_st_ready_sync_inst|dreg[*]]








## Sync core_pll_lock to coreclkout_hip
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|core_pll_lock_sync_inst|din_s1]
set_false_path -to [get_registers -nowarn ${ip_inst_name}*|pcie_sip_top_inst|pcie_src_inst|core_pll_lock_sync_inst|dreg[*]]






####################################


# set clock frequency
set rx_pld_pcs_mhz      350
set tx_pma_parallel_mhz 350
set rx_pma_parallel_mhz 350
set pld_pma_hclk_mhz    100

# create new dictionary 
set active_chnl_clks [dict create]
set active_chnl_clks_names [dict create]
set active_chnl_clks_freq [dict create]
set active_chnl_multiply_by_factors [dict create]
set active_chnl_divide_by_factors [dict create]

# set frequency for base clocks
dict set active_chnl_clks_freq rx_pld_pcs_clk_ref  $rx_pld_pcs_mhz
dict set active_chnl_clks_freq tx_pma_aib_clk_ref  $tx_pma_parallel_mhz
dict set active_chnl_clks_freq rx_transfer_clk_ref $rx_pma_parallel_mhz
dict set active_chnl_clks_freq pld_pma_hclk_ref    $pld_pma_hclk_mhz

# set multiple_by and divide_by for gernerated clocks
dict set active_chnl_multiply_by_factors     rx_pld_pcs_clk_reg    1
dict set active_chnl_divide_by_factors       rx_pld_pcs_clk_reg    1
dict set active_chnl_multiply_by_factors     tx_pma_aib_clk_reg    1
dict set active_chnl_divide_by_factors       tx_pma_aib_clk_reg    1
dict set active_chnl_multiply_by_factors     rx_transfer_clk_reg   1
dict set active_chnl_divide_by_factors       rx_transfer_clk_reg   1
dict set active_chnl_multiply_by_factors     pld_pma_hclk_reg      1
dict set active_chnl_divide_by_factors       pld_pma_hclk_reg      1
dict set active_chnl_multiply_by_factors     rx_clkout             1
dict set active_chnl_divide_by_factors       rx_clkout             1

# find coreclkout_hip
set dummy_ff_in_sip [get_nodes $ip_inst_name|pcie_sip_top_inst|dummy_out_for_timing*|clk]
if {$pcie_sdc_debug == 1} { post_message -type info "dummy_ff_in_sip: [query_collection -report -all $dummy_ff_in_sip]" }

if {[get_collection_size $dummy_ff_in_sip] > 0} {
   set dummy_ff_in_sip_node_name [get_node_info -name $dummy_ff_in_sip]
   set dummy_ff_in_sip_fanin [get_fanins $dummy_ff_in_sip_node_name]
   if {$pcie_sdc_debug == 1} { post_message -type info "dummy_ff_in_sip_fanin: [query_collection -report -all $dummy_ff_in_sip_fanin]" }
   ## get rx_clkout fanin node name 
   set dummy_ff_in_sip_fanin_node_name [get_node_info -name $dummy_ff_in_sip_fanin]
   
   ## find active channel numbers 
   ## get index for ".reg"
   set reg_index [string last .reg $dummy_ff_in_sip_fanin_node_name] 
   if {$pcie_sdc_debug == 1} { post_message -type info "reg_index = $reg_index" }

   # get active chnl number according to it's single bit or two bits, index-2 is digit means two bits(10~23), otherwise it's single bit(0~9) 
   if { [string is digit [string index $dummy_ff_in_sip_fanin_node_name $reg_index-2]] } {
      set chnl [string range $dummy_ff_in_sip_fanin_node_name $reg_index-2 $reg_index-1]
   } else {
      set chnl [string index $dummy_ff_in_sip_fanin_node_name $reg_index-1]
   }

   # get instance name of top_auto_tiles in tile part 
   set top_tile_index [string last ~aib_hssi $dummy_ff_in_sip_fanin_node_name]
   set top_tile_inst_name [string range $dummy_ff_in_sip_fanin_node_name 0 $top_tile_index]
   # get instance name of top_auto_tiles in fabric part
   set top_fab_index [string last | $dummy_ff_in_sip_fanin_node_name]
   set top_fab_inst_name [string range $dummy_ff_in_sip_fanin_node_name 0 $top_fab_index]
   
   if {$pcie_sdc_debug == 1} {
      post_message -type info "IP SDC: instance name of top_tiles in tile part is $top_tile_inst_name"
      post_message -type info "IP SDC: instance name of top_tiles in fab part is $top_fab_inst_name"
   }

   ## set *ref node and *reg node to dictionary 
   # ------ aib_hssi_pld_pcs_rx_clk_out_ch[x]_ref/reg ------ #
   set rx_pld_pcs_ref_nodes_col aib_hssi_pld_pcs_rx_clk_out_ch${chnl}_ref 
   if {[get_collection_size [get_nodes -nowarn $top_tile_inst_name$rx_pld_pcs_ref_nodes_col]] > 0} {
       dict lappend active_chnl_clks rx_pld_pcs_clk_ref [get_node_info -name $top_tile_inst_name$rx_pld_pcs_ref_nodes_col]
       ## sorting 
       dict set active_chnl_clks rx_pld_pcs_clk_ref [lsort -dictionary [dict get $active_chnl_clks rx_pld_pcs_clk_ref]]
       if {$pcie_sdc_debug == 1} {
          post_message -type info "IP SDC: RX pld pcs clk ref node info: [dict get $active_chnl_clks rx_pld_pcs_clk_ref]"
       }
   }

   set rx_pld_pcs_reg_nodes_col aib_hssi_pld_pcs_rx_clk_out_ch${chnl}.reg 
   if {[get_collection_size [get_nodes -nowarn $top_tile_inst_name$rx_pld_pcs_reg_nodes_col]] > 0} {
      dict lappend active_chnl_clks rx_pld_pcs_clk_reg [get_node_info -name $top_tile_inst_name$rx_pld_pcs_reg_nodes_col] 
      ## sorting
      dict set active_chnl_clks rx_pld_pcs_clk_reg [lsort -dictionary [dict get $active_chnl_clks rx_pld_pcs_clk_reg]]
      if {$pcie_sdc_debug == 1} {
         post_message -type info "IP SDC: RX pld pcs clk reg node info: [dict get $active_chnl_clks rx_pld_pcs_clk_reg]"
      }
   }

   # ------ pld_pcs_rx_clk_out1_dcm ----- #
   set rx_pld_pcs_out1_dcm_nodes_col hdpldadapt_rx_chnl_${chnl}|pld_pcs_rx_clk_out1_dcm  
   if {[get_collection_size [get_nodes -nowarn $top_fab_inst_name$rx_pld_pcs_out1_dcm_nodes_col]] > 0} {
      dict lappend active_chnl_clks rx_clkout [get_node_info -name $top_fab_inst_name$rx_pld_pcs_out1_dcm_nodes_col]
      ## sorting
      dict set active_chnl_clks rx_clkout [lsort -dictionary [dict get $active_chnl_clks rx_clkout]]
      if {$pcie_sdc_debug == 1} {
         post_message -type info "IP SDC: PLD PCS RX OUT1 DCM CLK node info: [dict get $active_chnl_clks rx_clkout]"
      }
   }

   for {set chnl 0} {$chnl<$pcie_active_ch} {incr chnl} {
      if {($chnl==6 || $chnl==7) && !$pcie_ch6ch7_en} {
         continue
      } else {
         # ------ aib_hssi_pma_aib_tx_clk_ch[x]_ref/reg ------ #
         set tx_pma_aib_ref_nodes_col aib_hssi_pma_aib_tx_clk_ch${chnl}_ref 
         if {[get_collection_size [get_nodes -nowarn $top_tile_inst_name$tx_pma_aib_ref_nodes_col]] > 0} {
            dict lappend active_chnl_clks tx_pma_aib_clk_ref [get_node_info -name $top_tile_inst_name$tx_pma_aib_ref_nodes_col]
            ## sorting 
            dict set active_chnl_clks tx_pma_aib_clk_ref [lsort -dictionary [dict get $active_chnl_clks tx_pma_aib_clk_ref]]
            if {$pcie_sdc_debug == 1} {
               post_message -type info "IP SDC: TX pma aib clk ref node info: [dict get $active_chnl_clks tx_pma_aib_clk_ref]"
            }
         }
	   
         set tx_pma_aib_reg_nodes_col aib_hssi_pma_aib_tx_clk_ch${chnl}.reg
         if {[get_collection_size [get_nodes -nowarn $top_tile_inst_name$tx_pma_aib_reg_nodes_col]] > 0} {
            dict lappend active_chnl_clks tx_pma_aib_clk_reg [get_node_info -name $top_tile_inst_name$tx_pma_aib_reg_nodes_col]
           ## sorting
            dict set active_chnl_clks tx_pma_aib_clk_reg [lsort -dictionary [dict get $active_chnl_clks tx_pma_aib_clk_reg]]
            if {$pcie_sdc_debug == 1} {
                post_message -type info "IP SDC: TX pma aib clk reg node info: [dict get $active_chnl_clks tx_pma_aib_clk_reg]"
            }
         }
	   
         # ------ aib_hssi_rx_transfer_clk_ch[x]_ref/reg ------ #
         set rx_transfer_ref_nodes_col aib_hssi_rx_transfer_clk_ch${chnl}_ref
         if {[get_collection_size [get_nodes -nowarn $top_tile_inst_name$rx_transfer_ref_nodes_col]] > 0} {
            dict lappend active_chnl_clks rx_transfer_clk_ref [get_node_info -name $top_tile_inst_name$rx_transfer_ref_nodes_col]
            ## sorting 
            dict set active_chnl_clks rx_transfer_clk_ref [lsort -dictionary [dict get $active_chnl_clks rx_transfer_clk_ref]]
            if {$pcie_sdc_debug == 1} {
               post_message -type info "IP SDC: RX transfer clk ref node info: [dict get $active_chnl_clks rx_transfer_clk_ref]"
            }
         }
	   
         set rx_transfer_reg_nodes_col aib_hssi_rx_transfer_clk_ch${chnl}.reg
         if {[get_collection_size [get_nodes -nowarn $top_tile_inst_name$rx_transfer_reg_nodes_col]] > 0} {
            dict lappend active_chnl_clks rx_transfer_clk_reg [get_node_info -name $top_tile_inst_name$rx_transfer_reg_nodes_col]
            ## sorting
            dict set active_chnl_clks rx_transfer_clk_reg [lsort -dictionary [dict get $active_chnl_clks rx_transfer_clk_reg]]
            if {$pcie_sdc_debug == 1} {
               post_message -type info "IP SDC: RX transfer clk reg node info: [dict get $active_chnl_clks rx_transfer_clk_reg]"
            }
         }
	   
         # ------ aib_hssi_pld_pma_hclk_ch[x]_ref/reg ------ #
         set pld_pma_hclk_ref_nodes_col aib_hssi_pld_pma_hclk_ch${chnl}_ref
         if {[get_collection_size [get_nodes -nowarn $top_tile_inst_name$pld_pma_hclk_ref_nodes_col]] > 0} {
           dict lappend active_chnl_clks pld_pma_hclk_ref [get_node_info -name $top_tile_inst_name$pld_pma_hclk_ref_nodes_col]
           ## sorting
           dict set active_chnl_clks pld_pma_hclk_ref [lsort -dictionary [dict get $active_chnl_clks pld_pma_hclk_ref]]
           if {$pcie_sdc_debug == 1} {
               post_message -type info "IP SDC: pld pma hclk ref node info: [dict get $active_chnl_clks pld_pma_hclk_ref]"
           }
         }
	   
         set pld_pma_hclk_reg_nodes_col aib_hssi_pld_pma_hclk_ch${chnl}.reg
         if {[get_collection_size [get_nodes -nowarn $top_tile_inst_name$pld_pma_hclk_reg_nodes_col]] > 0} {
           dict lappend active_chnl_clks pld_pma_hclk_reg [get_node_info -name $top_tile_inst_name$pld_pma_hclk_reg_nodes_col]
           ## sorting
           dict set active_chnl_clks pld_pma_hclk_reg [lsort -dictionary [dict get $active_chnl_clks pld_pma_hclk_reg]]
           if {$pcie_sdc_debug == 1} {
               post_message -type info "IP SDC: pld pma hclk reg node info: [dict get $active_chnl_clks pld_pma_hclk_reg]"
           }
         }
      }
   }
} else {
   post_message -type error "IP SDC: Could not find active CLKOUT ports for user facing clocks"
}


proc native_prepare_to_create_clocks_all_ch {clks_grp clks active_chnl_clks_freq active_chnl_multiply_by_factors active_chnl_divide_by_factors ip_inst_name top_tile_inst_name master_clocks source_nodes} {
   upvar 1 pcie_sdc_debug pcie_sdc_debug
 
   foreach clk $clks {
      if {$clks_grp == "rx_pld_pcs_clk_ref" || $clks_grp == "tx_pma_aib_clk_ref" || $clks_grp == "rx_transfer_clk_ref" || $clks_grp == "pld_pma_hclk_ref"} {
         ## get active chnl number according to it's single bit or two bits, index-2 is digit means two bits(10~23), otherwise it's single bit(0~9)
         set chnl_index [string last _ref $clk]
         if { [string is digit [string index $clk $chnl_index-2]] } {
            set chnl [string range $clk $chnl_index-2 $chnl_index-1]
         } else {
            set chnl [string index $clk $chnl_index-1]
         }
 
         set grp_freq [dict get $active_chnl_clks_freq $clks_grp]

         ## create clock name based on clock group and channel 
         set clk_name $ip_inst_name|$clks_grp|ch$chnl
         dict lappend active_chnl_clks_names tx_pld_pcs_clks_ref_name $clk_name
                   
         ## create_clock  
         create_clock \
            -name $clk_name \
            -period "$grp_freq MHz" \
            -add    $clk
         if {$pcie_sdc_debug == 1} {
            post_message -type info "IP SDC: Creating base clock: $clk_name, period $grp_freq MHz, at node $clk"
            post_message -type info "IP SDC: Creating base clock: period is $grp_freq MHz"
            post_message -type info "IP SDC: Creating base clock: at node $clk"
         }
      } elseif {$clks_grp == "rx_pld_pcs_clk_reg" || $clks_grp == "tx_pma_aib_clk_reg" || $clks_grp == "rx_transfer_clk_reg" || $clks_grp == "pld_pma_hclk_reg" || $clks_grp == "rx_clkout" } {
         ## get active chnl number according to it's single bit or two bits, index-2 is digit means two bits(10~23), otherwise it's single bit(0~9)
          if {$clks_grp == "rx_pld_pcs_clk_reg" || $clks_grp == "tx_pma_aib_clk_reg" || $clks_grp == "rx_transfer_clk_reg" || $clks_grp == "pld_pma_hclk_reg"} {
             set chnl_index [string last .reg $clk]
          } elseif {$clks_grp == "rx_clkout"} {
             set chnl_index [string last |pld_pcs_ $clk]
          }
 
         if { [string is digit [string index $clk $chnl_index-2]] } {
            set chnl [string range $clk $chnl_index-2 $chnl_index-1]
         } else {
            set chnl [string index $clk $chnl_index-1]
         }

         set multiply_by [dict get $active_chnl_multiply_by_factors $clks_grp]
         set divide_by [dict get $active_chnl_divide_by_factors $clks_grp]
         set clk_name $ip_inst_name|$clks_grp|ch$chnl

         set master_clock [lsearch -inline $master_clocks $ip_inst_name*$chnl*]
         set source_node  [lsearch -inline $source_nodes $top_tile_inst_name*$chnl*]
     
         ## create_generated_clock  
         create_generated_clock \
            -name $clk_name \
            -source $source_node \
            -master_clock $master_clock \
            -multiply_by $multiply_by \
            -divide_by $divide_by \
            -duty_cycle 50 \
            -add    $clk
         if {$pcie_sdc_debug == 1} {
            post_message -type info "IP SDC: Creating generated clock: $clk_name"
            post_message -type info "IP SDC: Creating generated clock: at node $clk"
            post_message -type info "IP SDC: Creating generated clock: source node is $source_node"
            post_message -type info "IP SDC: Creating generated clock: master clock is $master_clock"
            post_message -type info "IP SDC: Creating generated clock: multiply_by factor is $multiply_by"
            post_message -type info "IP SDC: Creating generated clock: divide_by factor is $divide_by"
         }         
      }; ## end of if-elseif condition
   }; ## end of foreach clk
}; ## end of proc {native_prepare_to_create_clocks_all_ch}


# iterate through each clock group, set master clock and source node
foreach {clks_grp clks} $active_chnl_clks {
   foreach clk $clks {
      if {$clks_grp == "rx_pld_pcs_clk_ref" || $clks_grp == "tx_pma_aib_clk_ref" || $clks_grp == "rx_transfer_clk_ref" || $clks_grp == "pld_pma_hclk_ref"} {
         ## get active chnl number according to it's single bit or two bits, index-2 is digit means two bits(10~23), otherwise it's single bit(0~9)
         set chnl_index [string last _ref $clk]
         if { [string is digit [string index $clk $chnl_index-2]] } {
            set chnl [string range $clk $chnl_index-2 $chnl_index-1]
         } else {
            set chnl [string index $clk $chnl_index-1]
         }
                
         set clk_name $ip_inst_name|$clks_grp|ch$chnl
         dict lappend active_chnl_clks_names $clks_grp $clk_name
         set master_clocks ""
         set source_nodes ""
      } elseif {$clks_grp == "rx_pld_pcs_clk_reg" || $clks_grp == "tx_pma_aib_clk_reg" || $clks_grp == "rx_transfer_clk_reg" || $clks_grp == "pld_pma_hclk_reg" || $clks_grp == "rx_clkout"} {
         ## get active chnl number according to it's single bit or two bits, index-2 is digit means two bits(10~23), otherwise it's single bit(0~9)
         if {$clks_grp == "rx_pld_pcs_clk_reg" || $clks_grp == "tx_pma_aib_clk_reg" || $clks_grp == "rx_transfer_clk_reg" || $clks_grp == "pld_pma_hclk_reg"} {
            set chnl_index [string last .reg $clk]
         } elseif {$clks_grp == "rx_clkout"} {
            set chnl_index [string last |pld_pcs $clk]
         } 

         if { [string is digit [string index $clk $chnl_index-2]] } {
            set chnl [string range $clk $chnl_index-2 $chnl_index-1]
         } else {
            set chnl [string index $clk $chnl_index-1]
         }
 
         set clk_name $ip_inst_name|$clks_grp|ch$chnl
         dict lappend active_chnl_clks_names $clks_grp $clk_name
      }; ## end of if-elseif condition
 
   }; ## end of foreach clk 
     
       
   if {$clks_grp == "rx_pld_pcs_clk_reg"} {
      set master_clocks [dict get $active_chnl_clks_names rx_pld_pcs_clk_ref]
      set source_nodes  [dict get $active_chnl_clks rx_pld_pcs_clk_ref]
   } elseif {$clks_grp == "tx_pma_aib_clk_reg"} {
      set master_clocks [dict get $active_chnl_clks_names tx_pma_aib_clk_ref]
      set source_nodes  [dict get $active_chnl_clks tx_pma_aib_clk_ref]
   } elseif {$clks_grp == "rx_transfer_clk_reg"} {
      set master_clocks [dict get $active_chnl_clks_names rx_transfer_clk_ref]
      set source_nodes  [dict get $active_chnl_clks rx_transfer_clk_ref]
   } elseif {$clks_grp == "pld_pma_hclk_reg"} {
      set master_clocks [dict get $active_chnl_clks_names pld_pma_hclk_ref]
      set source_nodes  [dict get $active_chnl_clks pld_pma_hclk_ref]
   } elseif {$clks_grp == "rx_clkout"} {
      set master_clocks [dict get $active_chnl_clks_names rx_pld_pcs_clk_reg]
      set source_nodes  [dict get $active_chnl_clks rx_pld_pcs_clk_reg]
   }

   ## call proc to create clocks 
   native_prepare_to_create_clocks_all_ch $clks_grp $clks $active_chnl_clks_freq $active_chnl_multiply_by_factors $active_chnl_divide_by_factors $ip_inst_name $top_tile_inst_name $master_clocks $source_nodes
}; ## end of dict for

# -------------------------------------------------- #
# ---                                            --- #
# --- DISABLE MIN_PULSE_WIDTH CHECK              --- #
# ---                                            --- #
# -------------------------------------------------- #
# Disable min_pulse_width for TX source clocks
set tx_source_clks_list [list]
if {[dict exists $active_chnl_clks_names tx_pma_aib_clk_ref]} {
   set tx_source_clks_list [concat $tx_source_clks_list  [dict get $active_chnl_clks_names tx_pma_aib_clk_ref]]
}
 
foreach tx_src_clk $tx_source_clks_list {
   disable_min_pulse_width $tx_src_clk
}

# Disable min_pulse_width for RX source clocks
set rx_source_clks_list [list]
if {[dict exists $active_chnl_clks_names rx_pld_pcs_clk_ref]} {
   set rx_source_clks_list [dict get $active_chnl_clks_names rx_pld_pcs_clk_ref]
}
if {[dict exists $active_chnl_clks_names rx_transfer_clk_ref]} {
   set rx_source_clks_list [concat $rx_source_clks_list  [dict get $active_chnl_clks_names rx_transfer_clk_ref]]
}
 
foreach rx_src_clk $rx_source_clks_list {
   disable_min_pulse_width $rx_src_clk
}

# Disable min_pulse_width for HCLK 
if {[dict exists $active_chnl_clks_names pld_pma_hclk_ref]} {
   disable_min_pulse_width [dict get $active_chnl_clks_names pld_pma_hclk_ref] 
}

### #-------------------------------------------------- #
### #---                                            --- #
### #--- Adjusting the min pulse width for          --- #
### #--- coreclkin2 requirement to be               --- #
### #--- frequency-dependent                        --- #
### #---                                            --- #
### #-------------------------------------------------- #



set pcie_src_tx_rx_pld_rst_n_r [get_registers -nowarn $ip_inst_name|pcie_sip_top_inst|pcie_src_inst|pld_adapter_*x_pld_rst_n_r*]
set hdpldadapt_tx_pld_rst_n    [get_registers -nowarn ${top_fab_inst_name}hdpldadapt_tx_chnl_*~aib_fabric_pma_aib_tx_clk.reg]
set hdpldadapt_rx_pld_rst_n    [get_registers -nowarn ${top_fab_inst_name}hdpldadapt_rx_chnl_*~aib_fabric_rx_transfer_clk.reg]
if {[get_collection_size $pcie_src_tx_rx_pld_rst_n_r] > 0 && [get_collection_size $hdpldadapt_tx_pld_rst_n] > 0} {
   set_false_path -from $pcie_src_tx_rx_pld_rst_n_r -to $hdpldadapt_tx_pld_rst_n
}

if {[get_collection_size $pcie_src_tx_rx_pld_rst_n_r] > 0 && [get_collection_size $hdpldadapt_rx_pld_rst_n] > 0} {
   set_false_path -from $pcie_src_tx_rx_pld_rst_n_r -to $hdpldadapt_rx_pld_rst_n
}

set aib_fabric_pld_pma_hclk_reg_col   [get_registers -nowarn ${top_fab_inst_name}hdpldadapt_rx_chnl_*~aib_fabric_pld_pma_hclk.reg]
set aib_fabric_pma_aib_tx_clk_reg_col [get_registers -nowarn ${top_fab_inst_name}hdpldadapt_tx_chnl_*~aib_fabric_pma_aib_tx_clk.reg]
set pld_rx_clk1_dcm_reg_col           [get_registers -nowarn ${top_fab_inst_name}hdpldadapt_rx_chnl_*~pld_rx_clk1_dcm.reg]
set pld_rx_clk1_rowclk_reg_clk        [get_registers -nowarn ${top_fab_inst_name}hdpldadapt_rx_chnl_*~pld_rx_clk1_rowclk.reg]


if {[get_collection_size $aib_fabric_pld_pma_hclk_reg_col] > 0 && [get_collection_size $aib_fabric_pma_aib_tx_clk_reg_col] > 0} {
   set_false_path -from $aib_fabric_pld_pma_hclk_reg_col -to $aib_fabric_pma_aib_tx_clk_reg_col
}

if {[get_collection_size $aib_fabric_pld_pma_hclk_reg_col] > 0 && [get_collection_size $pld_rx_clk1_dcm_reg_col] > 0} {
   set_false_path -from $aib_fabric_pld_pma_hclk_reg_col -to $pld_rx_clk1_dcm_reg_col
}

if {[get_collection_size $aib_fabric_pld_pma_hclk_reg_col] > 0 && [get_collection_size $pld_rx_clk1_rowclk_reg_clk] > 0} {
   set_false_path -from $aib_fabric_pld_pma_hclk_reg_col -to $pld_rx_clk1_rowclk_reg_clk
}

if {[get_collection_size $aib_fabric_pld_pma_hclk_reg_col] > 0} {
   set_false_path -to $aib_fabric_pld_pma_hclk_reg_col
}

set tx_pma_aib_clk_reg_col_minpulse [get_registers -nowarn ${top_fab_inst_name}hdpldadapt_tx_chnl*~aib_fabric_pma_aib_tx_clk.reg]
set tx_pma_aib_clk_reg_col_minpulse [add_to_collection $tx_pma_aib_clk_reg_col_minpulse [get_registers -nowarn ${top_fab_inst_name}xtxdatapath_tx*~aib_fabric_tx_transfer_clk.reg]]
if {[get_collection_size $tx_pma_aib_clk_reg_col_minpulse] > 0} {
   disable_min_pulse_width $tx_pma_aib_clk_reg_col_minpulse
}

set rx_transfer_clk_reg_col_minpulse [get_registers -nowarn ${top_fab_inst_name}hdpldadapt_rx_chnl*~aib_fabric_rx_transfer_clk.reg]
if {[get_collection_size $rx_transfer_clk_reg_col_minpulse] > 0} {
   disable_min_pulse_width $rx_transfer_clk_reg_col_minpulse
}



