
module SDI_A7SK (
  input  fpga_resetn , 
  input  tx_system_pll_clk,//900MHZ
  input  tx_pll_refclk ,   //148.5MHZ
  input  rx_system_pll_clk,//900MHZ
  input  rx_cdr_refclk,    //148.5MHZ
  input  gpio_clk_148M5,   //148.5MHZ
  
  output sdi_3g_tx_p0,
  output sdi_3g_tx_n0,  
  input  sdi_3g_rx_p0,
  input  sdi_3g_rx_n0,
  output sdi_3g_tx_p1,
  output sdi_3g_tx_n1,
  input  sdi_3g_rx_p1,
  input  sdi_3g_rx_n1,  
  
  output sdi_12g_tx_p0,  
  output sdi_12g_tx_n0,  
  input  sdi_12g_rx_p0,  
  input  sdi_12g_rx_n0,  
  output sdi_12g_tx_p1,  
  output sdi_12g_tx_n1,  
  input  sdi_12g_rx_p1,  
  input  sdi_12g_rx_n1,    
  output [3:0] LED 


);


///---------------------------------------------------------
localparam NUM_STREAMS = 4;
localparam NUM_DR_HOST = 4; //4port dr
localparam DR_AVMM_ADDR_WIDTH = 10;
localparam DR_AVMM_DATA_WIDTH = 32;

// --------------------------------------------
// Signal Declaration
// --------------------------------------------
logic [7:0]                                 user_led;
logic                                       sgpio_reset_sync;
logic                                       device_ready;
logic                                       sys_resetn;

logic                                       sdi_rx_clkout;
logic                                       sdi_rx_clkout1;
logic                                       sdi_rx_clkout2;
logic                                       sdi_rx_clkout3;
logic                                       sdi_tx_clkout;
logic                                       sdi_tx_clkout1;
logic                                       sdi_tx_clkout2;
logic                                       sdi_tx_clkout3;

logic                                       sdi_tx_dataout_valid;
logic [NUM_STREAMS*20-1:0]                  sdi_tx_datain;
logic                                       sdi_tx_datain_valid;
logic                                       sdi_tx_trs;
logic [2:0]                                 sdi_tx_std;
logic [NUM_STREAMS*11-1:0]                  sdi_tx_ln;
logic [NUM_STREAMS*11-1:0]                  sdi_tx_ln_b;
logic [2:0]                                 sdi_rx_std;
logic [2:0]                                 sdi_rx_std1;
logic [2:0]                                 sdi_rx_std2;
logic [2:0]                                 sdi_rx_std3;


logic [NUM_STREAMS-1:0]                     sdi_rx_trs_locked;
logic [NUM_STREAMS-1:0]                     sdi_rx_trs_locked1;
logic [NUM_STREAMS-1:0]                     sdi_rx_trs_locked2;
logic [NUM_STREAMS-1:0]                     sdi_rx_trs_locked3;
logic                                       sdi_rx_align_locked;
logic                                       sdi_rx_align_locked1;
logic                                       sdi_rx_align_locked2;
logic                                       sdi_rx_align_locked3;

logic                                       sdi_rx_frame_locked;
logic                                       sdi_rx_frame_locked1;
logic                                       sdi_rx_frame_locked2;
logic                                       sdi_rx_frame_locked3;

logic                                       gxb_tx_ready;
logic [NUM_DR_HOST-1:0]                     cdr_reconfig_busy;
logic [NUM_DR_HOST-1:0]                     rcfg_new_cfg_applied_ch;
logic [NUM_DR_HOST-1:0]                     rcfg_new_cfg_applied_ack_ch;
logic [NUM_DR_HOST-1:0]                     rcfg_avmm_read_ch;
logic [NUM_DR_HOST-1:0]                     rcfg_avmm_write_ch;
logic [NUM_DR_HOST-1:0]                     rcfg_avmm_readdata_valid_ch;
logic [NUM_DR_HOST-1:0]                     rcfg_avmm_waitrequest_ch;
logic [NUM_DR_HOST*DR_AVMM_ADDR_WIDTH-1:0]  rcfg_avmm_address_ch;
logic [NUM_DR_HOST*DR_AVMM_DATA_WIDTH-1:0]  rcfg_avmm_readdata_ch;
logic [NUM_DR_HOST*DR_AVMM_DATA_WIDTH-1:0]  rcfg_avmm_writedata_ch;
logic                                       dr_new_cfg_applied;
logic                                       dr_new_cfg_applied_ack;
logic                                       dr_host_avmm_read;
logic                                       dr_host_avmm_write;
logic                                       dr_host_avmm_readdata_valid;
logic                                       dr_host_avmm_waitrequest;
logic [DR_AVMM_ADDR_WIDTH-1:0]              dr_host_avmm_address;
logic [DR_AVMM_DATA_WIDTH-1:0]              dr_host_avmm_readdata;
logic [DR_AVMM_DATA_WIDTH-1:0]              dr_host_avmm_writedata;
logic                                       pattgen_pio_rst;
logic                                       pattgen_rst;
logic                                       pattgen_patho;
logic                                       pattgen_sgmt_frame;
logic                                       pattgen_dl_mapping;
logic                                       pattgen_ntsc_paln;
logic [3:0]                                 pattgen_tx_format;
logic                                       tx_clkout_hb_rate;
logic                                       rx_clkout_hb_rate;
logic                                       trs_locked_led;
logic                                       trs_locked_led1;
logic                                       trs_locked_led2;
logic                                       trs_locked_led3;

//------------------------------------------------------------------------------
// Output pins assignment
//------------------------------------------------------------------------------
wire [31:0] probe ; 
wire [7:0] rx_probe0;
wire [7:0] rx_probe1;
wire [7:0] rx_probe2;
wire [7:0] rx_probe3;

//---3G port RX0 locked probe
assign rx_probe0 = {2'h0,sdi_rx_frame_locked,sdi_rx_align_locked  ,1'b0,sdi_rx_std[2:0]};

//---3G port RX1 locked probe
assign rx_probe1 = {2'h0,sdi_rx_frame_locked1,sdi_rx_align_locked1,1'b0,sdi_rx_std1[2:0]};

//---12G port RX0 locked probe
assign rx_probe2 = {2'h0,sdi_rx_frame_locked2,sdi_rx_align_locked2,1'b0,sdi_rx_std2[2:0]};

//---12G port RX1 locked probe
assign rx_probe3 = {2'h0,sdi_rx_frame_locked3,sdi_rx_align_locked3,1'b0,sdi_rx_std3[2:0]};


//----4 PORT RX locked probe -------
iss ss(
		//output wire [0:0]  source, /
		.probe({rx_probe3,rx_probe2,rx_probe1,rx_probe0 })   
	);

	
assign LED[0] = ~trs_locked_led ; 
assign LED[1] = ~trs_locked_led1 ; 
assign LED[2] = ~trs_locked_led2 ;
assign LED[3] = ~trs_locked_led3 ;
	
//----3G port RX0 locked LED-----------------------------------------------------
assign trs_locked_led = (sdi_rx_std[2:1] == 2'b11) ? &sdi_rx_trs_locked[3:0] :
                        (sdi_rx_std[2:1] == 2'b10) ? &sdi_rx_trs_locked[1:0] :
                                                      sdi_rx_trs_locked[0];																		
//----3G port RX1 locked LED-----------------------------------------------------
assign trs_locked_led1 = (sdi_rx_std1[2:1] == 2'b11) ? &sdi_rx_trs_locked1[3:0] :
                         (sdi_rx_std1[2:1] == 2'b10) ? &sdi_rx_trs_locked1[1:0] :
                                                      sdi_rx_trs_locked1[0];
																		
//----12G port RX0 locked LED----------------------------------------------------
assign trs_locked_led2 = (sdi_rx_std2[2:1] == 2'b11) ? &sdi_rx_trs_locked2[3:0] :
                         (sdi_rx_std2[2:1] == 2'b10) ? &sdi_rx_trs_locked2[1:0] :
                                                      sdi_rx_trs_locked2[0];
																		
//----12G port RX1 locked LED----------------------------------------------------
assign trs_locked_led3 = (sdi_rx_std3[2:1] == 2'b11) ? &sdi_rx_trs_locked3[3:0] :
                         (sdi_rx_std3[2:1] == 2'b10) ? &sdi_rx_trs_locked3[1:0] :
                                                 		  sdi_rx_trs_locked3[0];

//-----system reset 
assign sys_resetn = fpga_resetn & device_ready;


//-------------------------------------------------------------------------------
// Wait for device ready
//-------------------------------------------------------------------------------
device_init #(
    .CNTR_BITS                      (16)
) device_init_inst (
    .clk                            (gpio_clk_148M5),//CLK_148M5_p ),//clk_3a_gpio_p_2),
    .init_done                      (device_ready)
);



//---------------------------------------------------------------------------------------------------------
// SDI Pattgen with Control
// To run pattern gen, open System Console from Quartus and type "source ../hwtest/tpg_ctrl.tcl"
//---------------------------------------------------------------------------------------------------------
pattgen_ctrl    pattgen_ctrl_inst (
    // Clocks and resets
    .avmm_clk_in_clk_clk                            (gpio_clk_148M5),
    .tx_clkout_in_clk_clk                           (sdi_tx_clkout),
    .avmm_rst_in_reset_reset_n                      (sys_resetn),
    .pattgen_rst_reset_in0_reset                    (~gxb_tx_ready),
    .pattgen_rst_reset_in1_reset                    (pattgen_pio_rst),
    .pattgen_rst_reset_out_reset                    (pattgen_rst),

    // Outputs
    .pattgen_ctrl_pio_external_connection_export    ({pattgen_pio_rst, pattgen_patho, pattgen_ntsc_paln, pattgen_dl_mapping, pattgen_sgmt_frame, sdi_tx_std, pattgen_tx_format})
);

sdi_ii_ed_vid_pattgen #(
    .OUTW_MULTP                     (NUM_STREAMS),
    .SD_BIT_WIDTH                   (10),
    .TEST_GEN_ANC                   (1),
    .TEST_GEN_VPID                  (1),
    .TEST_VPID_PKT_COUNT            (1),
    .TEST_ERR_VPID                  (0),
    .TEST_VPID_OVERWRITE            (1)
) pattgen (
    // Clocks and resets
    .clk                            (sdi_tx_clkout),
    .rst                            (pattgen_rst),

    // Inputs
    .enable                         (sdi_tx_dataout_valid),
    .tx_std                         (sdi_tx_std),
    .tx_format                      (pattgen_tx_format),
    .dl_mapping                     (pattgen_dl_mapping),
    .bar_100_75n                    (1'b0),
    .patho                          (pattgen_patho),
    .blank                          (1'b0),
    .no_color                       (1'b0),
    .sgmt_frame                     (pattgen_sgmt_frame),
    .ntsc_paln                      (pattgen_ntsc_paln),

    // Outputs
    .ln                             (sdi_tx_ln),
    .ln_b                           (sdi_tx_ln_b),
    .line_f0                        (),
    .line_f1                        (),
    .vpid_byte1                     (),
    .vpid_byte2                     (),
    .vpid_byte3                     (),
    .vpid_byte4                     (),
    .vpid_byte1_b                   (),
    .vpid_byte2_b                   (),
    .vpid_byte3_b                   (),
    .vpid_byte4_b                   (),
    .trs                            (sdi_tx_trs),
    .dout                           (sdi_tx_datain),
    .dout_valid                     (sdi_tx_datain_valid)
);

// ======================3G TX======================
// ------------------3G PORT TX0--------------------------------------------
tx_mr_top #(
    .NUM_STREAMS                    (NUM_STREAMS)
) tx_inst (
// Clocks and reset
    .sdi_tx_pclk                    (sdi_tx_clkout),
    .system_pll_clk                 (tx_system_pll_clk),
    .tx_pll_refclk                  (tx_pll_refclk    ),
    .sdi_tx_resetn                  (sys_resetn & ~pattgen_pio_rst),
    .tx_phy_resetn                  (sys_resetn & ~pattgen_pio_rst),	 
	 
	 

// Inputs
    .tx_vid_data                    (sdi_tx_datain),
    .tx_vid_datavalid               (sdi_tx_datain_valid),
    .tx_vid_std                     (sdi_tx_std),
    .tx_vid_trs                     (sdi_tx_trs),
    .sdi_tx_enable_crc              (1'b1),
    .sdi_tx_enable_ln               (1'b1),
    .sdi_tx_ln                      (sdi_tx_ln),
    .sdi_tx_ln_b                    (sdi_tx_ln_b),

// Outputs
    .tx_vid_clkout                  (sdi_tx_clkout),
    .tx_pll_locked                  (),
    .gxb_tx_serial_data             (sdi_3g_tx_p0),
    .gxb_tx_serial_data_n           (sdi_3g_tx_n0),
    .gxb_tx_ready                   (gxb_tx_ready),
    .sdi_tx_datavalid               (sdi_tx_dataout_valid)
);
// ------------------3G PORT TX1--------------------------------------------
tx_mr_top #(
    .NUM_STREAMS                    (NUM_STREAMS)
) tx_inst0 (
// Clocks and reset
    .sdi_tx_pclk                    (sdi_tx_clkout1),
    .system_pll_clk                 (tx_system_pll_clk),
    .tx_pll_refclk                  (tx_pll_refclk    ),
    .sdi_tx_resetn                  (sys_resetn & ~pattgen_pio_rst),
    .tx_phy_resetn                  (sys_resetn & ~pattgen_pio_rst),	 
// Inputs
    .tx_vid_data                    (sdi_tx_datain),
    .tx_vid_datavalid               (sdi_tx_datain_valid),
    .tx_vid_std                     (sdi_tx_std),
    .tx_vid_trs                     (sdi_tx_trs),
    .sdi_tx_enable_crc              (1'b1),
    .sdi_tx_enable_ln               (1'b1),
    .sdi_tx_ln                      (sdi_tx_ln),
    .sdi_tx_ln_b                    (sdi_tx_ln_b),

// Outputs
    .tx_vid_clkout                  (sdi_tx_clkout1),
    .tx_pll_locked                  (),
    .gxb_tx_serial_data             (sdi_3g_tx_p1),
    .gxb_tx_serial_data_n           (sdi_3g_tx_n1)
//    .gxb_tx_ready                   (gxb_tx_ready),
//    .sdi_tx_datavalid               (sdi_tx_dataout_valid)
);

// ======================12G TX======================
// ------------------12G PORT TX0--------------------------------------------
tx_mr_top #(
    .NUM_STREAMS                    (NUM_STREAMS)
) tx_inst1 (
// Clocks and reset
    .sdi_tx_pclk                    (sdi_tx_clkout2),
    .system_pll_clk                 (tx_system_pll_clk),
    .tx_pll_refclk                  (tx_pll_refclk   ),
    .sdi_tx_resetn                  (sys_resetn & ~pattgen_pio_rst),
    .tx_phy_resetn                  (sys_resetn & ~pattgen_pio_rst),	 
	 
// Inputs
    .tx_vid_data                    (sdi_tx_datain),
    .tx_vid_datavalid               (sdi_tx_datain_valid),
    .tx_vid_std                     (sdi_tx_std),
    .tx_vid_trs                     (sdi_tx_trs),
    .sdi_tx_enable_crc              (1'b1),
    .sdi_tx_enable_ln               (1'b1),
    .sdi_tx_ln                      (sdi_tx_ln),
    .sdi_tx_ln_b                    (sdi_tx_ln_b),

// Outputs
    .tx_vid_clkout                  (sdi_tx_clkout2),
    .tx_pll_locked                  (),
    .gxb_tx_serial_data             (sdi_12g_tx_p0),
    .gxb_tx_serial_data_n           (sdi_12g_tx_n0)
    //.gxb_tx_ready                   (gxb_tx_ready),
    //.sdi_tx_datavalid               (sdi_tx_dataout_valid)
);

// ------------------12G PORT TX1--------------------------------------------
tx_mr_top #(
    .NUM_STREAMS                    (NUM_STREAMS)
) tx_inst2 (
// Clocks and reset
    .sdi_tx_pclk                    (sdi_tx_clkout3),
    .system_pll_clk                 (tx_system_pll_clk),
    .tx_pll_refclk                  (tx_pll_refclk   ),
    .sdi_tx_resetn                  (sys_resetn & ~pattgen_pio_rst),
    .tx_phy_resetn                  (sys_resetn & ~pattgen_pio_rst),	 

// Inputs
    .tx_vid_data                    (sdi_tx_datain),
    .tx_vid_datavalid               (sdi_tx_datain_valid),
    .tx_vid_std                     (sdi_tx_std),
    .tx_vid_trs                     (sdi_tx_trs),
    .sdi_tx_enable_crc              (1'b1),
    .sdi_tx_enable_ln               (1'b1),
    .sdi_tx_ln                      (sdi_tx_ln),
    .sdi_tx_ln_b                    (sdi_tx_ln_b),

// Outputs
    .tx_vid_clkout                  (sdi_tx_clkout3),
    .tx_pll_locked                  (),
    .gxb_tx_serial_data             (sdi_12g_tx_p1),
    .gxb_tx_serial_data_n           (sdi_12g_tx_n1)
    //.gxb_tx_ready                   (gxb_tx_ready),
    //.sdi_tx_datavalid               (sdi_tx_dataout_valid)
);
// -------------------------------------------------------------------------
// Receiver IP Top Level
//
// FOR TRIPLE-RATE AND MULTI-RATE DESIGN:
// The following assignments must be included in the project's .qsf file to
// set the appropriate value to Dynamic Reconfiguration IP:
//      set_instance_assignment -name IP_COLOCATE F_TILE -from <Dynamic Reconfig IP instance> -to <Multi-rate PHY Base Profile Instance>
//      set_instance_assignment -name IP_RECONFIG_ID <Your Desired Base Profile ID> -to <Multi-rate PHY Base Profile Instance>
//
// Your base profile reconfig ID must be unique for every instance and cannot be conflict with others reconfig ID including non-base profile.
// For triple-rate design there is 1 more reconfig ID in addition to the base profile ID.
// For multi-rate design there is 3 more reconfig ID in addition to the base profile ID.
//
// To validate your reconfig ID for each profile, you can go to quartus/support_logic/ folder
// after Support-Logic Generation stage and check the sdi_ii_agi_demo__ip_insts_<tile_label>.h file.
//
// There is a "MRPHY_RX_BASE_PROFILE" parameter below which the value must match with the IP_RECONFIG_ID's value which was set in .qsf
// I.e .MRPHY_RX_BASE_PROFILE       (<Your Desired Base Profile ID>),
//
// For the exact example of the .qsf assignment, please refer to this project qsf file in quartus folder.
// -------------------------------------------------------------------------

// ======================3G RX======================
// ------------------3G PORT RX0--------------------------------------------
rx_mr_top #(
    .MRPHY_RX_BASE_PROFILE          (15'd1),
    .NUM_STREAMS                    (NUM_STREAMS)
) rx_inst (
// Clock and reset
    .system_pll_clk                 (rx_system_pll_clk),
    .rx_cdr_refclk                  (rx_cdr_refclk   ),//outclk_148m5_rx      ),
    .rx_core_refclk                 (gpio_clk_148M5),  //CLK_148M5_p),//clk_3a_gpio_p_2),
    .rx_rcfg_mgmt_clk               (gpio_clk_148M5 ), //CLK_148M5_p),//clk_3a_gpio_p_2),
    .rx_rcfg_mgmt_resetn            (sys_resetn),
    .rx_resetn                      (sys_resetn),
    
// Inputs
    .gxb_rx_serial_data             (sdi_3g_rx_p0),//fmc_a_rx_p_2),
    .gxb_rx_serial_data_n           (sdi_3g_rx_n0),//fmc_a_rx_n_2),
    .dr_rx_new_cfg_applied          (rcfg_new_cfg_applied_ch[0]),
    .dr_rx_avmm_readdata_valid      (rcfg_avmm_readdata_valid_ch[0]),
    .dr_rx_avmm_waitrequest         (rcfg_avmm_waitrequest_ch[0]),
    .dr_rx_avmm_readdata            (rcfg_avmm_readdata_ch[0*DR_AVMM_DATA_WIDTH+:DR_AVMM_DATA_WIDTH]),

// Outputs
    .rx_vid_clkout                  (sdi_rx_clkout),
    .rx_vid_data                    (),
    .rx_vid_datavalid               (),
    .rx_vid_std                     (sdi_rx_std),
    .rx_vid_locked                  (sdi_rx_frame_locked),
    .rx_vid_hsync                   (),
    .rx_vid_vsync                   (),
    .rx_vid_f                       (),
    .rx_vid_trs                     (),
    .sdi_rx_rst_proto_out           (),
    .sdi_rx_align_locked            (sdi_rx_align_locked),
    .sdi_rx_trs_locked              (sdi_rx_trs_locked),
    .sdi_rx_clkout_is_ntsc_paln     (),
    .sdi_rx_format                  (),
    .sdi_rx_ap                      (),
    .sdi_rx_eav                     (),
    .sdi_rx_ln                      (),
    .sdi_rx_ln_b                    (),
    .sdi_rx_line_f0                 (),
    .sdi_rx_line_f1                 (),
    .sdi_rx_vpid_byte1              (),
    .sdi_rx_vpid_byte2              (),
    .sdi_rx_vpid_byte3              (),
    .sdi_rx_vpid_byte4              (),
    .sdi_rx_vpid_checksum_error     (),
    .sdi_rx_vpid_valid              (),
    .sdi_rx_vpid_byte1_b            (),
    .sdi_rx_vpid_byte2_b            (),
    .sdi_rx_vpid_byte3_b            (),
    .sdi_rx_vpid_byte4_b            (),
    .sdi_rx_vpid_checksum_error_b   (),
    .sdi_rx_vpid_valid_b            (),
    .cdr_reconfig_busy              (cdr_reconfig_busy[0]),
    .dr_rx_new_cfg_applied_ack      (rcfg_new_cfg_applied_ack_ch[0]),
    .dr_rx_avmm_write               (rcfg_avmm_write_ch[0]),
    .dr_rx_avmm_read                (rcfg_avmm_read_ch[0]),
    .dr_rx_avmm_writedata           (rcfg_avmm_writedata_ch[0*DR_AVMM_DATA_WIDTH+:DR_AVMM_DATA_WIDTH]),
    .dr_rx_avmm_address             (rcfg_avmm_address_ch[0*DR_AVMM_ADDR_WIDTH+:DR_AVMM_ADDR_WIDTH]),
    .gxb_rx_reset_ack               (),
    .gxb_rx_ready                   ()
);

// ------------------3G PORT RX1--------------------------------------------
rx_mr_top #(
    .MRPHY_RX_BASE_PROFILE          (15'd5),
    .NUM_STREAMS                    (NUM_STREAMS)
) rx_inst0 (
// Clock and reset
    .system_pll_clk                 (rx_system_pll_clk),
    .rx_cdr_refclk                  (rx_cdr_refclk   ),
    .rx_core_refclk                 (gpio_clk_148M5),
    .rx_rcfg_mgmt_clk               (gpio_clk_148M5 ),
    .rx_rcfg_mgmt_resetn            (sys_resetn),
    .rx_resetn                      (sys_resetn),
    
// Inputs
    .gxb_rx_serial_data             (sdi_3g_rx_p1),
    .gxb_rx_serial_data_n           (sdi_3g_rx_n1),
    .dr_rx_new_cfg_applied          (rcfg_new_cfg_applied_ch[1]),
    .dr_rx_avmm_readdata_valid      (rcfg_avmm_readdata_valid_ch[1]),
    .dr_rx_avmm_waitrequest         (rcfg_avmm_waitrequest_ch[1]),
    .dr_rx_avmm_readdata            (rcfg_avmm_readdata_ch[1*DR_AVMM_DATA_WIDTH+:DR_AVMM_DATA_WIDTH]),

// Outputs
    .rx_vid_clkout                  (sdi_rx_clkout1),
    .rx_vid_data                    (),
    .rx_vid_datavalid               (),
    .rx_vid_std                     (sdi_rx_std1),
    .rx_vid_locked                  (sdi_rx_frame_locked1),
    .rx_vid_hsync                   (),
    .rx_vid_vsync                   (),
    .rx_vid_f                       (),
    .rx_vid_trs                     (),
    .sdi_rx_rst_proto_out           (),
    .sdi_rx_align_locked            (sdi_rx_align_locked1),
    .sdi_rx_trs_locked              (sdi_rx_trs_locked1),
    .sdi_rx_clkout_is_ntsc_paln     (),
    .sdi_rx_format                  (),
    .sdi_rx_ap                      (),
    .sdi_rx_eav                     (),
    .sdi_rx_ln                      (),
    .sdi_rx_ln_b                    (),
    .sdi_rx_line_f0                 (),
    .sdi_rx_line_f1                 (),
    .sdi_rx_vpid_byte1              (),
    .sdi_rx_vpid_byte2              (),
    .sdi_rx_vpid_byte3              (),
    .sdi_rx_vpid_byte4              (),
    .sdi_rx_vpid_checksum_error     (),
    .sdi_rx_vpid_valid              (),
    .sdi_rx_vpid_byte1_b            (),
    .sdi_rx_vpid_byte2_b            (),
    .sdi_rx_vpid_byte3_b            (),
    .sdi_rx_vpid_byte4_b            (),
    .sdi_rx_vpid_checksum_error_b   (),
    .sdi_rx_vpid_valid_b            (),
    .cdr_reconfig_busy              (cdr_reconfig_busy[1]),
    .dr_rx_new_cfg_applied_ack      (rcfg_new_cfg_applied_ack_ch[1]),
    .dr_rx_avmm_write               (rcfg_avmm_write_ch[1]),
    .dr_rx_avmm_read                (rcfg_avmm_read_ch[1]),
    .dr_rx_avmm_writedata           (rcfg_avmm_writedata_ch[1*DR_AVMM_DATA_WIDTH+:DR_AVMM_DATA_WIDTH]),
    .dr_rx_avmm_address             (rcfg_avmm_address_ch[1*DR_AVMM_ADDR_WIDTH+:DR_AVMM_ADDR_WIDTH]),
    .gxb_rx_reset_ack               (),
    .gxb_rx_ready                   ()
);

// ======================12G RX======================
// ------------------12G PORT RX0--------------------------------------------
rx_mr_top #(
    .MRPHY_RX_BASE_PROFILE          (15'd9),
    .NUM_STREAMS                    (NUM_STREAMS)
) rx_inst1 (
// Clock and reset
    .system_pll_clk                 (rx_system_pll_clk),
    .rx_cdr_refclk                  (rx_cdr_refclk   ),
    .rx_core_refclk                 (gpio_clk_148M5), 
    .rx_rcfg_mgmt_clk               (gpio_clk_148M5 ),
    .rx_rcfg_mgmt_resetn            (sys_resetn),
    .rx_resetn                      (sys_resetn),
    
// Inputs
    .gxb_rx_serial_data             (sdi_12g_rx_p0),
    .gxb_rx_serial_data_n           (sdi_12g_rx_n0),
    .dr_rx_new_cfg_applied          (rcfg_new_cfg_applied_ch[2]),
    .dr_rx_avmm_readdata_valid      (rcfg_avmm_readdata_valid_ch[2]),
    .dr_rx_avmm_waitrequest         (rcfg_avmm_waitrequest_ch[2]),
    .dr_rx_avmm_readdata            (rcfg_avmm_readdata_ch[2*DR_AVMM_DATA_WIDTH+:DR_AVMM_DATA_WIDTH]),

// Outputs
    .rx_vid_clkout                  (sdi_rx_clkout2),
    .rx_vid_data                    (),
    .rx_vid_datavalid               (),
    .rx_vid_std                     (sdi_rx_std2),
    .rx_vid_locked                  (sdi_rx_frame_locked2),
    .rx_vid_hsync                   (),
    .rx_vid_vsync                   (),
    .rx_vid_f                       (),
    .rx_vid_trs                     (),
    .sdi_rx_rst_proto_out           (),
    .sdi_rx_align_locked            (sdi_rx_align_locked2),
    .sdi_rx_trs_locked              (sdi_rx_trs_locked2),
    .sdi_rx_clkout_is_ntsc_paln     (),
    .sdi_rx_format                  (),
    .sdi_rx_ap                      (),
    .sdi_rx_eav                     (),
    .sdi_rx_ln                      (),
    .sdi_rx_ln_b                    (),
    .sdi_rx_line_f0                 (),
    .sdi_rx_line_f1                 (),
    .sdi_rx_vpid_byte1              (),
    .sdi_rx_vpid_byte2              (),
    .sdi_rx_vpid_byte3              (),
    .sdi_rx_vpid_byte4              (),
    .sdi_rx_vpid_checksum_error     (),
    .sdi_rx_vpid_valid              (),
    .sdi_rx_vpid_byte1_b            (),
    .sdi_rx_vpid_byte2_b            (),
    .sdi_rx_vpid_byte3_b            (),
    .sdi_rx_vpid_byte4_b            (),
    .sdi_rx_vpid_checksum_error_b   (),
    .sdi_rx_vpid_valid_b            (),
    .cdr_reconfig_busy              (cdr_reconfig_busy[2]),
    .dr_rx_new_cfg_applied_ack      (rcfg_new_cfg_applied_ack_ch[2]),
    .dr_rx_avmm_write               (rcfg_avmm_write_ch[2]),
    .dr_rx_avmm_read                (rcfg_avmm_read_ch[2]),
    .dr_rx_avmm_writedata           (rcfg_avmm_writedata_ch[2*DR_AVMM_DATA_WIDTH+:DR_AVMM_DATA_WIDTH]),
    .dr_rx_avmm_address             (rcfg_avmm_address_ch[2*DR_AVMM_ADDR_WIDTH+:DR_AVMM_ADDR_WIDTH]),
    .gxb_rx_reset_ack               (),
    .gxb_rx_ready                   ()
);

// ------------------12G PORT RX1--------------------------------------------
rx_mr_top #(
    .MRPHY_RX_BASE_PROFILE          (15'd13),
    .NUM_STREAMS                    (NUM_STREAMS)
) rx_inst2 (
// Clock and reset
    .system_pll_clk                 (rx_system_pll_clk),
    .rx_cdr_refclk                  (rx_cdr_refclk  ),
    .rx_core_refclk                 (gpio_clk_148M5),
    .rx_rcfg_mgmt_clk               (gpio_clk_148M5 ),
    .rx_rcfg_mgmt_resetn            (sys_resetn),
    .rx_resetn                      (sys_resetn),
    
// Inputs
    .gxb_rx_serial_data             (sdi_12g_rx_p1),
    .gxb_rx_serial_data_n           (sdi_12g_rx_n1),
    .dr_rx_new_cfg_applied          (rcfg_new_cfg_applied_ch[3]),
    .dr_rx_avmm_readdata_valid      (rcfg_avmm_readdata_valid_ch[3]),
    .dr_rx_avmm_waitrequest         (rcfg_avmm_waitrequest_ch[3]),
    .dr_rx_avmm_readdata            (rcfg_avmm_readdata_ch[3*DR_AVMM_DATA_WIDTH+:DR_AVMM_DATA_WIDTH]),

// Outputs
    .rx_vid_clkout                  (sdi_rx_clkout3),
    .rx_vid_data                    (),
    .rx_vid_datavalid               (),
    .rx_vid_std                     (sdi_rx_std3),
    .rx_vid_locked                  (sdi_rx_frame_locked3),
    .rx_vid_hsync                   (),
    .rx_vid_vsync                   (),
    .rx_vid_f                       (),
    .rx_vid_trs                     (),
    .sdi_rx_rst_proto_out           (),
    .sdi_rx_align_locked            (sdi_rx_align_locked3),
    .sdi_rx_trs_locked              (sdi_rx_trs_locked3),
    .sdi_rx_clkout_is_ntsc_paln     (),
    .sdi_rx_format                  (),
    .sdi_rx_ap                      (),
    .sdi_rx_eav                     (),
    .sdi_rx_ln                      (),
    .sdi_rx_ln_b                    (),
    .sdi_rx_line_f0                 (),
    .sdi_rx_line_f1                 (),
    .sdi_rx_vpid_byte1              (),
    .sdi_rx_vpid_byte2              (),
    .sdi_rx_vpid_byte3              (),
    .sdi_rx_vpid_byte4              (),
    .sdi_rx_vpid_checksum_error     (),
    .sdi_rx_vpid_valid              (),
    .sdi_rx_vpid_byte1_b            (),
    .sdi_rx_vpid_byte2_b            (),
    .sdi_rx_vpid_byte3_b            (),
    .sdi_rx_vpid_byte4_b            (),
    .sdi_rx_vpid_checksum_error_b   (),
    .sdi_rx_vpid_valid_b            (),
    .cdr_reconfig_busy              (cdr_reconfig_busy[3]),
    .dr_rx_new_cfg_applied_ack      (rcfg_new_cfg_applied_ack_ch[3]),
    .dr_rx_avmm_write               (rcfg_avmm_write_ch[3]),
    .dr_rx_avmm_read                (rcfg_avmm_read_ch[3]),
    .dr_rx_avmm_writedata           (rcfg_avmm_writedata_ch[3*DR_AVMM_DATA_WIDTH+:DR_AVMM_DATA_WIDTH]),
    .dr_rx_avmm_address             (rcfg_avmm_address_ch[3*DR_AVMM_ADDR_WIDTH+:DR_AVMM_ADDR_WIDTH]),
    .gxb_rx_reset_ack               (),
    .gxb_rx_ready                   ()
);

//---------RX-PHY Dynamic Reconfigure -------------------
dr_f    dr_inst  (
    .i_csr_clk                      (gpio_clk_148M5),
    .i_cpu_clk                      (gpio_clk_148M5),
    .i_rst_n                        (sys_resetn),

//User Interface status
    .o_dr_curr_profile_id           (),
    .o_dr_new_cfg_applied           (dr_new_cfg_applied),
    .o_dr_in_progress               (),
    .i_dr_new_cfg_applied_ack       (dr_new_cfg_applied_ack),

// Master 1 (Host software interface)
    .i_dr_host_avmm_writedata       (dr_host_avmm_writedata),
    .i_dr_host_avmm_read            (dr_host_avmm_read),
    .i_dr_host_avmm_address         (dr_host_avmm_address),
    .i_dr_host_avmm_write           (dr_host_avmm_write),
    .o_dr_host_avmm_readdata        (dr_host_avmm_readdata),
    .o_dr_host_avmm_waitrequest     (dr_host_avmm_waitrequest),
    .o_dr_host_avmm_readdata_valid  (dr_host_avmm_readdata_valid)
);

// -------------------------------------------------------------------------
// DR Arbiter
// -------------------------------------------------------------------------
vid_conn_dr_arbiter #(
    .NUM_DR_HOST                        (NUM_DR_HOST),
    .PIPELINE_ENA                       (0),
    .AVMM_ADDRESS_WIDTH                 (DR_AVMM_ADDR_WIDTH), 
    .AVMM_DATA_WIDTH                    (DR_AVMM_DATA_WIDTH)
) dr_arb_inst (
    .clk                                (gpio_clk_148M5),
    .reset                              (~sys_resetn),
    .reconfig_en                        (cdr_reconfig_busy),

    .rcfg_mgmt_write_ch                 (rcfg_avmm_write_ch),
    .rcfg_mgmt_read_ch                  (rcfg_avmm_read_ch),
    .rcfg_mgmt_address_ch               (rcfg_avmm_address_ch),
    .rcfg_mgmt_writedata_ch             (rcfg_avmm_writedata_ch),
    .rcfg_mgmt_readdata_ch              (rcfg_avmm_readdata_ch),
    .rcfg_mgmt_waitrequest_ch           (rcfg_avmm_waitrequest_ch),
    .rcfg_mgmt_readdata_valid_ch        (rcfg_avmm_readdata_valid_ch),
    .rcfg_mgmt_new_cfg_applied_ch       (rcfg_new_cfg_applied_ch),
    .rcfg_mgmt_new_cfg_applied_ack_ch   (rcfg_new_cfg_applied_ack_ch),

    .dr_avmm_write                      (dr_host_avmm_write),
    .dr_avmm_read                       (dr_host_avmm_read),
    .dr_avmm_address                    (dr_host_avmm_address),
    .dr_avmm_writedata                  (dr_host_avmm_writedata),
    .dr_avmm_readdata                   (dr_host_avmm_readdata),
    .dr_avmm_waitrequest                (dr_host_avmm_waitrequest),
    .dr_avmm_readdata_valid             (dr_host_avmm_readdata_valid),
    .dr_new_cfg_applied                 (dr_new_cfg_applied),
    .dr_new_cfg_applied_ack             (dr_new_cfg_applied_ack)
);

// -------------------------------------------------------------------------
// Clock heartbeat for LED for debug purpose
// Uncomment these blocks to instantiate the module.
// -------------------------------------------------------------------------
clock_heartbeat  tx_clkout_hb_inst (
    .clk_in                      (sdi_tx_clkout),
    .clk_out                     (tx_clkout_hb_rate)
);

clock_heartbeat  rx_clkout_hb_inst (
    .clk_in                      (sdi_rx_clkout),
    .clk_out                     (rx_clkout_hb_rate)
);

endmodule