module si5340a_freq_prameter_selector (

input         [3:0]          iPLL_OUT_FREQ_SEL,

//output   reg  [23:0]         RX_REG,
output   reg                 OUTX_OE,
output   reg  [43:0]         NX_NUM,
output   reg  [31:0]         NX_DEN       

);
//------XCVR


//`define SI5340A_FREQ_644M53125     4'h0  
//`define SI5340A_FREQ_625M          4'h1  
//`define SI5340A_FREQ_322M265625    4'h2  
//`define SI5340A_FREQ_312M5         4'h3  
//`define SI5340A_FREQ_250M          4'h4  
//`define SI5340A_FREQ_184M32        4'h5  
//`define SI5340A_FREQ_156M25        4'h6  
//`define SI5340A_FREQ_148M5         4'h7  
//`define SI5340A_FREQ_125M          4'h8  
//`define SI5340A_FREQ_100M          4'h9  


//---N_Num---
//23622320128 
//24360517632 
//47244640256 
//48721035264 
//60901294080 
//82602666667 <----
//97442070528 
//102527431111  //148.5
//121802588160 
//152253235200 
//







always @(*)
  begin
     case(iPLL_OUT_FREQ_SEL[3:0])
	  
      4'h0 :   //644.53125MHz
        begin
          OUTX_OE <= 1'b1 ;
          NX_NUM  <= 44'd23622320128;
        end
      4'h1 :   //625MHz
        begin
          OUTX_OE <= 1'b1 ;
          NX_NUM  <= 44'd24360517632;
        end
      4'h2 :   //322.265625MHz
        begin
          OUTX_OE <= 1'b1;
          NX_NUM  <= 44'd47244640256;

        end
      4'h3 :   //312.5MHz
        begin
          OUTX_OE <= 1'b1;
          NX_NUM  <= 44'd48721035264;
        end                     
      4'h4 :   //250MHz
        begin
          OUTX_OE <= 1'b1;
          NX_NUM  <= 44'd60901294080;
        end                
      4'h5 :   //184.32MHZ
        begin
          OUTX_OE <= 1'b1;
          NX_NUM  <= 44'd82602666667;
        end               
      4'h6 :   //156.25MHZ
        begin
          OUTX_OE <= 1'b1;
          NX_NUM  <= 44'd97442070528;
        end   

      4'h7 :   //148.5MHZ
        begin
          OUTX_OE <= 1'b1;
          NX_NUM  <= 44'd102527431111;
        end   

		  
      4'h8 :   //125MHz
        begin
          OUTX_OE <= 1'b1;
          NX_NUM  <= 44'd121802588160;
        end               
      4'h9 :   //100MHz
        begin
          OUTX_OE <= 1'b1;
          NX_NUM  <= 44'd152253235200;
        end               
		  	  
      4'ha :   //-------power down
         begin
          OUTX_OE = 1'b0;
          NX_NUM  = 44'd0;
         end                 
      default :   //100Mhz
        begin
          OUTX_OE = 1'b1;
          NX_NUM  = 44'd152253235200;
        end                         
      endcase
  end
  

endmodule
