// sdi_ii_agi_demo is the module specified by the QSF setting TOP_LEVEL_ENTITY
// QUARTUS_TLG generates a module called sdi_ii_agi_demo_auto_tiles specified by the QSF setting SECONDARY_TOP_LEVEL_ENTITY
// Both sdi_ii_agi_demo and sdi_ii_agi_demo_auto_tiles are instantiated in the user simulation
// testbench but not necessarily at the same level of hierarchy
// The testbench filelist can set a +define+TOP_LEVEL_ENTITY_INSTANCE_PATH
// to indicate the fully qualified instance name of the sdi_ii_agi_demo relative to the
// hierarchy node common to both sdi_ii_agi_demo and sdi_ii_agi_demo_auto_tiles.
//
// In the simplest case, the following is true
// * Both sdi_ii_agi_demo and sdi_ii_agi_demo_auto_tiles are instantiated in the same testbench module
// * The instance name of sdi_ii_agi_demo is sdi_ii_agi_demo
// For the above the defaults are sufficient and so the +define+TOP_LEVEL_ENTITY_INSTANCE_PATH
// is not required.
//
// A more complicated situation is as follows:
//
// top_testbench
// |
// + -- foo
//      |
//      + -- xxx
//      |    |
//      |    |
//      |    + -- x_sdi_ii_agi_demo (Instance of sdi_ii_agi_demo)
//      |
//      + -- bar
//           |
//           + -- sdi_ii_agi_demo_auto_tiles
//
// For the above we need
// +define+TOP_LEVEL_ENTITY_INSTANCE_PATH+foo.xxx.x_sdi_ii_agi_demo

`begin_keywords "1364-2005"
`ifndef TOP_LEVEL_ENTITY_INSTANCE_PATH
`define QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH sdi_ii_agi_demo
`else	//!TOP_LEVEL_ENTITY_INSTANCE_PATH
`define QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH `TOP_LEVEL_ENTITY_INSTANCE_PATH
`endif	//TOP_LEVEL_ENTITY_INSTANCE_PATH

// Copyright Intel Corporation, 2021 and beyond
// Source: quartus/common/misc/hssi/tileip/ftile_preamble.vh
`define special_handling_for_dr_ed_simulation(dr_ctrl_instance_hpath, tile_atom_hpath) \
    `ifndef ALTERA_RESERVED_QIS \
        `ifdef DR_F_GAVMM_SPEEDUP \
            initial begin \
                force dr_ctrl_instance_hpath.i_csr_clk = tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_clk.cfg_avmm_clk_div; \
                force tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_glocal.o_global_read = dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.master_read; \
                force tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_glocal.o_global_write = dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.master_write; \
                force tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_glocal.o_global_addr = dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.master_address[24:0]; \
                force tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_glocal.o_global_wdata = dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.master_write_data; \
                force tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_glocal.o_global_byte_en = dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.master_byte_enable; \
                force dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.master_read_valid = tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_glocal.i_global_rdatavld; \
                force dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.master_wait = tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_glocal.i_global_waitreq; \
                force dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.master_read_data = tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_glocal.i_global_rdata; \
                force tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_glocal.usr_en = dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.master_read_write_combined; \
                force tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_glocal.sm_arb = 3'h0; \
                force dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.state = 32'h0; \
                force dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.slave_read = 1'b0; \
                force dr_ctrl_instance_hpath.dr_ctrl_sip_inst.dr_gavmm_32to8_inst.slave_write = 1'b0; \
                force tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_clk.cfg_avmm_clk_div = tile_atom_hpath.z1577b.z1577b_inst.u_ctrl.u_clk.cnocdn_clkp; \
                force tile_atom_hpath.z1577b.dyn_rcfg_ctrl_in_progress_wire = dr_ctrl_instance_hpath.o_dr_in_progress; \
            end \
        `endif \
    `endif // ifndef ALTERA_RESERVED_QIS 


// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// Copyright Intel Corporation, 2021 and beyond
// One call to this macro is inserted for each unique set of parameters
`define special_handling_for_anlt_simulation(anlt_ip_instance_hpath, eth_ip_instance_hpath, tile_atom_hpath, anlt_port_id, ux_quad_id, chan_in_quad_id) \
`ifndef ALTERA_RESERVED_QIS \
    always @(*) begin \
        if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 1 /* 25G-1 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
        end else if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 1 /* 25G-1 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
            ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03005753E8; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03005753E8; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03005753E8; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
        end \
        if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 0 /* 10G-1 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
        end else if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 0 /* 10G-1 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
            ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h0266AC4320; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h0266AC4320; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h0266AC4320; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
        end \
		if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 12 /* 1G-1 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
        end else if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 12 /* 1G-1 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
            ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2540BE400; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2540BE400; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2540BE400; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
        end \
        if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 3 /* 50G-1 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
        end else if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 3 /* 50G-1 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
            ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
        end \
        if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 4 /* 50G-2 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
        end else if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 4 /* 50G-2 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
            ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03005753E8; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03005753E8; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03005753E8; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
        end \
        if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 6 /* 100G-2 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
        end else if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 6 /* 100G-2 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
            ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
        end \
        if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 7 /* 100G-4 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
        end else if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 7 /* 100G-4 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
            ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03005753E8; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03005753E8; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03005753E8; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
        end \
        if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 9 /* 200G-4 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
        end else if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 9 /* 200G-4 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
            ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
        end \
        if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 2 /* 40G-4 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
        end else if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 2 /* 40G-4 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
            ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h0266AC4320; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h0266AC4320; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h0266AC4320; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
        end \
        if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 11 /* 400G-8 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
        end else if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 11 /* 400G-8 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
            ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03179FCAD0; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
        end \
    end \
`endif // ifndef ALTERA_RESERVED_QIS

`define special_handling_for_anlt_simulation_for_dr(anlt_ip_instance_hpath, eth_ip_instance_hpath, tile_atom_hpath, anlt_port_id, ux_quad_id, chan_in_quad_id, eth_ip_instance_enabled) \
`ifndef ALTERA_RESERVED_QIS \
    always @(*) begin \
        if(eth_ip_instance_enabled) begin \
		    if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 1 /* 25G-1 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
                ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
            end else if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 1 /* 25G-1 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
                ) begin \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03005753E8; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03005753E8; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03005753E8; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
            end \
            if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 12 /* 1G-1 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
        end else if ( \
                ( anlt_ip_instance_hpath.ETHMODE == 12 /* 1G-1 */ ) \
                && \
                ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                && \
                ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                && \
                ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
            ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2540BE400; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2540BE400; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2540BE400; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
            end \
            if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 0 /* 10G-1 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
                ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
            end else if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 0 /* 10G-1 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
                ) begin \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h0266AC4320; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h0266AC4320; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h0266AC4320; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
            end \
            if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 3 /* 50G-1 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
                ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
            end else if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 3 /* 50G-1 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
                ) begin \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
            end \
            if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 4 /* 50G-2 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
                ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
            end else if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 4 /* 50G-2 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
                ) begin \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03005753E8; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03005753E8; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03005753E8; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
            end \
            if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 6 /* 100G-2 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
                ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
            end else if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 6 /* 100G-2 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
                ) begin \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
            end \
            if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 7 /* 100G-4 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
                ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
            end else if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 7 /* 100G-4 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
                ) begin \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03005753E8; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03005753E8; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03005753E8; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
            end \
            if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 9 /* 200G-4 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
                ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
            end else if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 9 /* 200G-4 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
                ) begin \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
            end \
            if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 2 /* 40G-4 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
                ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
            end else if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 2 /* 40G-4 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
                ) begin \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h0266AC4320; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h0266AC4320; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h0266AC4320; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
            end \
            if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 11 /* 400G-8 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd0 ) \
                ) begin \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h2E90EDD00; \
                force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2E90EDD00; \
            end else if ( \
                    ( anlt_ip_instance_hpath.ETHMODE == 11 /* 400G-8 */ ) \
                    && \
                    ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
                    && \
                    ( anlt_ip_instance_hpath.XCVRTYPE == 0 /* UX */ ) \
                    && \
                    ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd2 && anlt_ip_instance_hpath.OVRD_AN_TEC_FEC_ABL == 0) \
                ) begin \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = 40'h03179FCAD0; \
                    force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = 40'h2540BE400; \
            end \
		end \
    end \
`endif // ifndef ALTERA_RESERVED_QIS

`define special_handling_for_anlt_simulation_for_data_mode(anlt_ip_instance_hpath, eth_ip_instance_hpath, tile_atom_hpath, anlt_port_id, ux_quad_id, chan_in_quad_id, eth_ip_instance_enabled_dr, cdr_f_vco_hz_real, synth_lc_fast_f_vco_hz_real, synth_lc_med_f_vco_hz_real, synth_lc_slow_f_vco_hz_real) \
`ifndef ALTERA_RESERVED_QIS \
    always @(*) begin \
         if ( \
            ( eth_ip_instance_enabled_dr) \
            && \
            ( eth_ip_instance_hpath.ENABLE_ANLT == 1 ) \
            && \
            ( anlt_ip_instance_hpath.sip_inst.u_eth_anlt_f_csr_top.CSR.PORT[``anlt_port_id``].u_eth_anlt_f_csr.port0_kr_debug_7_csr_scratch == 32'd1 ) \
            ) begin \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_cdr_f_vco_hz_real = cdr_f_vco_hz_real; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_fast_f_vco_hz_real = synth_lc_fast_f_vco_hz_real; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_med_f_vco_hz_real = synth_lc_med_f_vco_hz_real; \
            force tile_atom_hpath.z1577b.u_ux_quad_``ux_quad_id``__ux``chan_in_quad_id``_synth_lc_slow_f_vco_hz_real = synth_lc_slow_f_vco_hz_real; \
            end \
      end \
`endif // ifndef ALTERA_RESERVED_QIS
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "Qodn92PFIS1NEh13XaZN6q+iOfr7scpYGeJtJSmDDlNyDqIgdJCZaOc07+YaA1v+FODTkrAAaLl7jsqkoxpL2hIqXePVfmCVZJZYRG1PYeGptXX2ooHXVk28meUW4F52zclBQ13CTLyb4rd021Y+G0r78rDrrBCdKfsqt3k5pKAbq10b2VAfVm7uxfzHRn6jbQrY3IxOlZyfv3UV9uzXeoRLUgey1eADIaWmqBjzA5yvlj2azYcCqQkKa7mNoieAWncgQDSY8L8GSdYFs1w44G6fbQnC8LlBqzKubcE/VVpQomzBp5LbHwoaie7AwUlUVDuTU104XP5tLXRZpBen/1W9g7HFXNZAS2AcNH8j+u1wofSIRYBPEK7K13K5p5qRYEBahPbsMcV2/mIpeAUDPi8aiZqmYPyqsdX3ovYJAzSjjpZOwya9rdcj1BFmLMEe74HAWET/ttn/WxPa0omkWdo8SnTRxk5fE5JcGJf8+f9JAz+R+pgTs5MSbZ4qHqshnuiU0LJThauM4eE4eD9L61qsXnLlfDbgunG4V0mzdZWQJjttJ4yd9tOL5U0stTiSTZXe7surCiOUGq7/tUmsQ7bww32QEtVNsdjy97GYed2QOxyLZPSEfbvZcs9P34Q53mT1NFY/csbCMWYj4Z0ACW4JsxJ0rB9wLqkPFxbiGhPqy+rWug4VK7rIpVELLfgFcaSZ5ciVYemDI1oIwQcsaZxnDDWoUmZzYtZitgK1dBZpK4OcvxkqKdpSz67/obVoCkAP4hT2yB879ExBp7Bihu3XoboPOHMK1nRYZ/aoFDD+hroEyBo75Pbn4v5Q8kj26Jb3O4Q3rgYLqAQ27iuoPD7yq+Wvh4vvixeHJ6GjdXNBi7oskB0pZLbknD65LQSRByg1Scqk9Y3s88Q+9nKsGojLVUqsLIkGDTByR8IlF9dsMB6qP+ZrNL0UA6KeNjITM7Zns5pP7R8GMGZLnncTWjE8qwNvKqQLKiEjh6WfyNyZjkaDJ+1zddzVWtBrcdEo"
`endif
// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// example macro calling:

//`define special_handling_for_ptp_simulation(ptp_mux_ip_instance_hpath, eth_ip_instance_hpath, eth_ip_sip_instance_hpath, tile_atom_hpath, aib_id, one_hot_selector) \
// special_handling_for_ptp_simulation( <ptp_mux not required>,
//                                      basic_avl_tb_top.eth_f_hw.IP_INST[0].hw_ip_top.dut.eth_f_0,
//                                      basic_avl_tb_top.eth_f_hw.IP_INST[0].hw_ip_top.dut.eth_f_0.sip_inst,
//                                      basic_avl_tb_top.eth_f_hw_auto_tiles.z1577a_x0_y0_n0.z1577a.z1577a_inst,
//                                      23, 
//                                      dr_ptp_ip_one_hot_selector)
// dr_ptp_ip_one_hot_selector is expected to have rising/falling edge to trigger/release force.
// PTP DEFINE MACRO BEGINS
`define special_handling_for_ptp_simulation_force_mr(ptp_hip_path,ptp_hip_ch,eth_sip_hpath,sip_port) \
    force ptp_hip_path.tx_mac.ptp_tx.am_exit_adj_ld[ptp_hip_ch]        = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_tx_tam_adj_load[sip_port];     \
    force ptp_hip_path.tx_mac.ptp_tx.am_exit_adj   [ptp_hip_ch][31:0]  = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_tx_tam_adj[sip_port];          \
    force ptp_hip_path.tx_mac.ptp_tx.am_exit_tod_ld[ptp_hip_ch]        = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_tx_tam_load[sip_port];         \
    force ptp_hip_path.tx_mac.ptp_tx.am_exit_tod   [ptp_hip_ch][95:0]  = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_tx_tam[sip_port];              \
    force ptp_hip_path.rx_mac.ptp_rx.am_exit_adj_ld[ptp_hip_ch]        = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_rx_tam_adj_load[sip_port];     \
    force ptp_hip_path.rx_mac.ptp_rx.am_exit_adj   [ptp_hip_ch][31:0]  = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_rx_tam_adj[sip_port];          \
    force ptp_hip_path.rx_mac.ptp_rx.am_exit_tod_ld[ptp_hip_ch]        = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_rx_tam_load[sip_port];         \
    force ptp_hip_path.rx_mac.ptp_rx.am_exit_tod   [ptp_hip_ch][95:0]  = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_rx_tam[sip_port];           

`define special_handling_for_ptp_simulation_force(ptp_hip_path,ptp_hip_ch,eth_sip_hpath) \
    force ptp_hip_path.tx_mac.ptp_tx.am_exit_adj_ld[ptp_hip_ch]        = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_tx_tam_adj_load[0];     \
    force ptp_hip_path.tx_mac.ptp_tx.am_exit_adj   [ptp_hip_ch][31:0]  = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_tx_tam_adj[0];          \
    force ptp_hip_path.tx_mac.ptp_tx.am_exit_tod_ld[ptp_hip_ch]        = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_tx_tam_load[0];         \
    force ptp_hip_path.tx_mac.ptp_tx.am_exit_tod   [ptp_hip_ch][95:0]  = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_tx_tam[0];              \
    force ptp_hip_path.rx_mac.ptp_rx.am_exit_adj_ld[ptp_hip_ch]        = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_rx_tam_adj_load[0];     \
    force ptp_hip_path.rx_mac.ptp_rx.am_exit_adj   [ptp_hip_ch][31:0]  = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_rx_tam_adj[0];          \
    force ptp_hip_path.rx_mac.ptp_rx.am_exit_tod_ld[ptp_hip_ch]        = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_rx_tam_load[0];         \
    force ptp_hip_path.rx_mac.ptp_rx.am_exit_tod   [ptp_hip_ch][95:0]  = eth_sip_hpath.PTP_SOFT_GEN.soft_ptp.sim_rx_tam[0];              

`define special_handling_for_ptp_simulation_release(ptp_hip_path,ptp_hip_ch) \
   release ptp_hip_path.tx_mac.ptp_tx.am_exit_adj_ld[ptp_hip_ch]      ;   \
   release ptp_hip_path.tx_mac.ptp_tx.am_exit_adj   [ptp_hip_ch][31:0];   \
   release ptp_hip_path.tx_mac.ptp_tx.am_exit_tod_ld[ptp_hip_ch]      ;   \
   release ptp_hip_path.tx_mac.ptp_tx.am_exit_tod   [ptp_hip_ch][95:0];   \
   release ptp_hip_path.rx_mac.ptp_rx.am_exit_adj_ld[ptp_hip_ch]      ;   \
   release ptp_hip_path.rx_mac.ptp_rx.am_exit_adj   [ptp_hip_ch][31:0];   \
   release ptp_hip_path.rx_mac.ptp_rx.am_exit_tod_ld[ptp_hip_ch]      ;   \
   release ptp_hip_path.rx_mac.ptp_rx.am_exit_tod   [ptp_hip_ch][95:0];

`define special_handling_for_ptp_simulation_mr(eth_ip_instance_hpath, eth_ip_sip_instance_hpath, tile_atom_hpath, aib_id, one_hot_selector) \
    // For PTP channel base at AIB23: 25g/50g,100g/200g,400g \
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 23) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk1.ehip_mac_50g_0,0,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk1.ehip_mac_50g_0,1,eth_ip_sip_instance_hpath, 0)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,0,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,1,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,2,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,3,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,4,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,5,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,6,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,7,eth_ip_sip_instance_hpath, 0)\
            // 400g hip reg \
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,0,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,1,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,2,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,3,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,4,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,5,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,6,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,7,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,8,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,9,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,10,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,11,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,12,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,13,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,14,eth_ip_sip_instance_hpath, 0)\
            `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,15,eth_ip_sip_instance_hpath, 0)\
        end\
        else begin \
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk1.ehip_mac_50g_0,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk1.ehip_mac_50g_0,1)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,1)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,2)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,3)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,4)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,5)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,6)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,7)\
            // 400g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,1)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,2)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,3)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,4)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,5)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,6)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,7)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,8)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,9)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,10)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,11)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,12)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,13)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,14)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,15)\
        end \
    end // aib23 \
    // For PTP channel base at AIB22: 25g\
    if ( // UMR3 10/25GE-1 or BMR2 25GE-1\
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 22) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 1 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk1.ehip_mac_50g_0,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk1.ehip_mac_50g_0,1,eth_ip_sip_instance_hpath, 1)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "25G-1") begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk1.ehip_mac_50g_0,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk1.ehip_mac_50g_0,1,eth_ip_sip_instance_hpath, 0)\
            end\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk1.ehip_mac_50g_0,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk1.ehip_mac_50g_0,1)\
        end\
    end // aib22 \
    // For PTP channel base at AIB20: 25g\
    if ( // UMR3 10/25GE-1 or BMR2 25GE-1 \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 20) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 3 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk2.ehip_mac_50g_1,0,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk2.ehip_mac_50g_1,1,eth_ip_sip_instance_hpath, 3)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "25G-1") begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk2.ehip_mac_50g_1,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk2.ehip_mac_50g_1,1,eth_ip_sip_instance_hpath, 0)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk2.ehip_mac_50g_1,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk2.ehip_mac_50g_1,1)\
        end\
    end // aib20 \
    // For PTP channel base at AIB18: 25g\
    if ( // UMR3 10/25GE-1 or BMR2 25GE-1\
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 18) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 1 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk3.ehip_mac_50g_2,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk3.ehip_mac_50g_2,1,eth_ip_sip_instance_hpath, 1)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "25G-1") begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk3.ehip_mac_50g_2,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk3.ehip_mac_50g_2,1,eth_ip_sip_instance_hpath, 0)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk3.ehip_mac_50g_2,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk3.ehip_mac_50g_2,1)\
        end\
    end // aib18 \
    // For PTP channel base at AIB16: 25g\
    if ( // UMR3 10/25GE-1 or BMR2 25GE-1\
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 16) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 3 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk4.ehip_mac_50g_3,0,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk4.ehip_mac_50g_3,1,eth_ip_sip_instance_hpath, 3)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "25G-1") begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk4.ehip_mac_50g_3,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk4.ehip_mac_50g_3,1,eth_ip_sip_instance_hpath, 0)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk4.ehip_mac_50g_3,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk4.ehip_mac_50g_3,1)\
        end\
    end // aib16 \
    // For PTP channel base at AIB14: 25g\
    if ( // UMR3 10/25GE-1 or BMR2 25GE-1\
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 14) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 1 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk5.ehip_mac_50g_4,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk5.ehip_mac_50g_4,1,eth_ip_sip_instance_hpath, 1)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "25G-1") begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk5.ehip_mac_50g_4,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk5.ehip_mac_50g_4,1,eth_ip_sip_instance_hpath, 0)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk5.ehip_mac_50g_4,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk5.ehip_mac_50g_4,1)\
        end\
    end // aib14 \
    // For PTP channel base at AIB12: 25g\
    if ( // UMR3 10/25GE-1 or BMR2 25GE-1\
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 12) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 3 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk6.ehip_mac_50g_5,0,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk6.ehip_mac_50g_5,1,eth_ip_sip_instance_hpath, 3)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "25G-1") begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk6.ehip_mac_50g_5,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk6.ehip_mac_50g_5,1,eth_ip_sip_instance_hpath, 0)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk6.ehip_mac_50g_5,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk6.ehip_mac_50g_5,1)\
        end\
    end// aib12 \
    // For PTP channel base at AIB10: 25g\
    if ( // UMR3 10/25GE-1 or BMR2 25GE-1\
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 10) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 1 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk7.ehip_mac_50g_6,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk7.ehip_mac_50g_6,1,eth_ip_sip_instance_hpath, 1)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "25G-1") begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk7.ehip_mac_50g_6,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk7.ehip_mac_50g_6,1,eth_ip_sip_instance_hpath, 0)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk7.ehip_mac_50g_6,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk7.ehip_mac_50g_6,1)\
        end\
    end// aib10 \
    // For PTP channel base at AIB08: 25g\
    if ( // UMR3 10/25GE-1 or BMR2 25GE-1\
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 8) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 3 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk8.ehip_mac_50g_7,0,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk8.ehip_mac_50g_7,1,eth_ip_sip_instance_hpath, 3)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "25G-1") begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk8.ehip_mac_50g_7,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk8.ehip_mac_50g_7,1,eth_ip_sip_instance_hpath, 0)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk8.ehip_mac_50g_7,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk8.ehip_mac_50g_7,1)\
        end\
    end// aib08 \
    // For PTP channel base at AIB21: 25g,50g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 21) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if ((eth_ip_instance_hpath.RCFG_GRP == "25G-1") || (eth_ip_instance_hpath.RCFG_GRP == "50G-1")) begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,1,eth_ip_sip_instance_hpath, 0)\
            end else if ((eth_ip_instance_hpath.RCFG_GRP == "100G-2") || (eth_ip_instance_hpath.RCFG_GRP == "200G-4")) begin // port 1 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,1,eth_ip_sip_instance_hpath, 1)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 2 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,0,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,1,eth_ip_sip_instance_hpath, 2)\
            end\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,1)\
        end\
    end // aib21 \
    // For PTP channel base at AIB17: 25g,50g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 17) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if ((eth_ip_instance_hpath.RCFG_GRP == "25G-1") || (eth_ip_instance_hpath.RCFG_GRP == "50G-1")) begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,1,eth_ip_sip_instance_hpath, 0)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "100G-2") begin // port 1 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,1,eth_ip_sip_instance_hpath, 1)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 2 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,0,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,1,eth_ip_sip_instance_hpath, 2)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "200G-4") begin // port 3 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,0,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,1,eth_ip_sip_instance_hpath, 3)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,1)\
        end\
    end // aib17 \
    // For PTP channel base at AIB13: 25g,50g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 13) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if ((eth_ip_instance_hpath.RCFG_GRP == "25G-1") || (eth_ip_instance_hpath.RCFG_GRP == "50G-1")) begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,1,eth_ip_sip_instance_hpath, 0)\
            end else if ((eth_ip_instance_hpath.RCFG_GRP == "100G-2") || (eth_ip_instance_hpath.RCFG_GRP == "200G-4")) begin // port 1 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,1,eth_ip_sip_instance_hpath, 1)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 2 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,0,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,1,eth_ip_sip_instance_hpath, 2)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,1)\
        end\
    end // aib13 \
    // For PTP channel base at AIB09: 25g,50g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 9) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            if ((eth_ip_instance_hpath.RCFG_GRP == "25G-1") || (eth_ip_instance_hpath.RCFG_GRP == "50G-1")) begin // port 0 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,1,eth_ip_sip_instance_hpath, 0)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "100G-2") begin // port 1 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,1,eth_ip_sip_instance_hpath, 1)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "100G-4") begin // port 2 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,0,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,1,eth_ip_sip_instance_hpath, 2)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "200G-4") begin // port 3 \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,0,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,1,eth_ip_sip_instance_hpath, 3)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,1)\
        end\
    end // aib09 \
    // For PTP channel base at AIB19: 25g,50g,100g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 19) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25GE-1/50GE-1/100G-4/100G-2/100G-1 \
            if ((eth_ip_instance_hpath.RCFG_GRP == "25G-1") || (eth_ip_instance_hpath.RCFG_GRP == "50G-1") || (eth_ip_instance_hpath.RCFG_GRP == "100G-4") || (eth_ip_instance_hpath.RCFG_GRP == "100G-2") || (eth_ip_instance_hpath.RCFG_GRP == "100G-1")) begin // port 0 \
                // 25g/50g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,1,eth_ip_sip_instance_hpath, 0)\
                // 100g/200g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,1,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,2,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,3,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,4,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,5,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,6,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,7,eth_ip_sip_instance_hpath, 0)\
            end else if ((eth_ip_instance_hpath.RCFG_GRP == "400G-8") || (eth_ip_instance_hpath.RCFG_GRP == "400G-4") || (eth_ip_instance_hpath.RCFG_GRP == "200G-2")) begin // port 1 \
                // 25g/50g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,1,eth_ip_sip_instance_hpath, 1)\
                // 100g/200g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,1,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,2,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,3,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,4,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,5,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,6,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,7,eth_ip_sip_instance_hpath, 1)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "200G-4") begin // port 2 \
                // 25g/50g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,0,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,1,eth_ip_sip_instance_hpath, 2)\
                // 100g/200g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,0,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,1,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,2,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,3,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,4,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,5,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,6,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,7,eth_ip_sip_instance_hpath, 2)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,1)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,1)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,2)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,3)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,4)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,5)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,6)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,7)\
        end\
    end // aib19 \
    // For PTP channel base at AIB11: 25g,50g,100g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 11) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25GE-1/50GE-1/100G-4/100G-2/100G-1 \
            if ((eth_ip_instance_hpath.RCFG_GRP == "25G-1") || (eth_ip_instance_hpath.RCFG_GRP == "50G-1") || (eth_ip_instance_hpath.RCFG_GRP == "100G-4") || (eth_ip_instance_hpath.RCFG_GRP == "100G-2") || (eth_ip_instance_hpath.RCFG_GRP == "100G-1")) begin // port 0 \
                // 25g/50g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,1,eth_ip_sip_instance_hpath, 0)\
                // 100g/200g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,1,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,2,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,3,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,4,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,5,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,6,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,7,eth_ip_sip_instance_hpath, 0)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "200G-2") begin // port 1 \
                // 25g/50g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,1,eth_ip_sip_instance_hpath, 1)\
                // 100g/200g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,0,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,1,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,2,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,3,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,4,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,5,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,6,eth_ip_sip_instance_hpath, 1)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,7,eth_ip_sip_instance_hpath, 1)\
            end else if (eth_ip_instance_hpath.RCFG_GRP == "200G-4") begin // port 2 \
                // 25g/50g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,0,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,1,eth_ip_sip_instance_hpath, 2)\
                // 100g/200g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,0,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,1,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,2,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,3,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,4,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,5,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,6,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,7,eth_ip_sip_instance_hpath, 2)\
            end else if ((eth_ip_instance_hpath.RCFG_GRP == "400G-8") || (eth_ip_instance_hpath.RCFG_GRP == "400G-4")) begin // port 3 \
                // 25g/50g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,0,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,1,eth_ip_sip_instance_hpath, 3)\
                // 100g/200g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,0,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,1,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,2,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,3,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,4,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,5,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,6,eth_ip_sip_instance_hpath, 3)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,7,eth_ip_sip_instance_hpath, 3)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,1)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,1)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,2)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,3)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,4)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,5)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,6)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,7)\
        end\
    end // aib11 \
    // For PTP channel base at AIB15: 25g,50g,100g,200g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    (aib_id == 15) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25GE-1/50GE-1/100G-4/100G-2/100G-1/200G-2/200G-4 \
            if ((eth_ip_instance_hpath.RCFG_GRP == "25G-1") || (eth_ip_instance_hpath.RCFG_GRP == "50G-1") || (eth_ip_instance_hpath.RCFG_GRP == "100G-4") || (eth_ip_instance_hpath.RCFG_GRP == "200G-4") || (eth_ip_instance_hpath.RCFG_GRP == "100G-2") || (eth_ip_instance_hpath.RCFG_GRP == "100G-1") || (eth_ip_instance_hpath.RCFG_GRP == "200G-2")) begin // port 0 \
                // 25g/50g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk5.ehip_mac_50g_4,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk5.ehip_mac_50g_4,1,eth_ip_sip_instance_hpath, 0)\
                // 100g/200g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,0,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,1,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,2,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,3,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,4,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,5,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,6,eth_ip_sip_instance_hpath, 0)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,7,eth_ip_sip_instance_hpath, 0)\
            end else if ((eth_ip_instance_hpath.RCFG_GRP == "400G-8") || (eth_ip_instance_hpath.RCFG_GRP == "400G-4")) begin // port 2 \
                // 25g/50g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk5.ehip_mac_50g_4,0,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk5.ehip_mac_50g_4,1,eth_ip_sip_instance_hpath, 2)\
                // 100g/200g hip reg \
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,0,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,1,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,2,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,3,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,4,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,5,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,6,eth_ip_sip_instance_hpath, 2)\
                `special_handling_for_ptp_simulation_force_mr(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,7,eth_ip_sip_instance_hpath, 2)\
            end \
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk5.ehip_mac_50g_4,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk5.ehip_mac_50g_4,1)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,1)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,2)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,3)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,4)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,5)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,6)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,7)\
        end\
    end // aib15 \
// end

`define special_handling_for_ptp_simulation_sr(eth_ip_instance_hpath, eth_ip_sip_instance_hpath, tile_atom_hpath, aib_id, one_hot_selector) \
`ifndef ALTERA_RESERVED_QIS \
    // For PTP channel base at AIB23: 25g/50g,100g/200g,400g \
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE != "40G")) && \
    (aib_id == 23) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk1.ehip_mac_50g_0,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk1.ehip_mac_50g_0,1,eth_ip_sip_instance_hpath)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,1,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,2,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,3,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,4,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,5,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,6,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,7,eth_ip_sip_instance_hpath)\
            // 400g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,1,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,2,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,3,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,4,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,5,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,6,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,7,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,8,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,9,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,10,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,11,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,12,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,13,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,14,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,15,eth_ip_sip_instance_hpath)\
        end\
        else begin \
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk1.ehip_mac_50g_0,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk1.ehip_mac_50g_0,1)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,1)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,2)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,3)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,4)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,5)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,6)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk1.ehip_mac_200g_0,7)\
            // 400g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,1)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,2)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,3)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,4)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,5)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,6)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,7)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,8)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,9)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,10)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,11)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,12)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,13)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,14)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_400g_0.genblk1.ehip_mac_400g_0,15)\
        end \
    end // aib23 \
    // For PTP channel base at AIB22: 25g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G")) && \
    (aib_id == 22) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk1.ehip_mac_50g_0,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk1.ehip_mac_50g_0,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk1.ehip_mac_50g_0,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk1.ehip_mac_50g_0,1)\
        end\
    end // aib22 \
    // For PTP channel base at AIB20: 25g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G")) && \
    (aib_id == 20) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk2.ehip_mac_50g_1,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk2.ehip_mac_50g_1,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk2.ehip_mac_50g_1,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk2.ehip_mac_50g_1,1)\
        end\
    end // aib20 \
    // For PTP channel base at AIB18: 25g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G")) && \
    (aib_id == 18) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk3.ehip_mac_50g_2,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk3.ehip_mac_50g_2,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk3.ehip_mac_50g_2,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk3.ehip_mac_50g_2,1)\
        end\
    end // aib18 \
    // For PTP channel base at AIB16: 25g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G")) && \
    (aib_id == 16) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk4.ehip_mac_50g_3,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk4.ehip_mac_50g_3,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk4.ehip_mac_50g_3,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk4.ehip_mac_50g_3,1)\
        end\
    end // aib16 \
    // For PTP channel base at AIB14: 25g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G")) && \
    (aib_id == 14) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk5.ehip_mac_50g_4,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk5.ehip_mac_50g_4,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk5.ehip_mac_50g_4,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk5.ehip_mac_50g_4,1)\
        end\
    end // aib14 \
    // For PTP channel base at AIB12: 25g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G")) && \
    (aib_id == 12) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk6.ehip_mac_50g_5,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk6.ehip_mac_50g_5,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk6.ehip_mac_50g_5,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk6.ehip_mac_50g_5,1)\
        end\
    end // aib12 \
    // For PTP channel base at AIB10: 25g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G")) && \
    (aib_id == 10) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk7.ehip_mac_50g_6,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk7.ehip_mac_50g_6,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk7.ehip_mac_50g_6,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk7.ehip_mac_50g_6,1)\
        end\
    end // aib10 \
    // For PTP channel base at AIB08: 25g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G")) && \
    (aib_id == 8) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk8.ehip_mac_50g_7,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk8.ehip_mac_50g_7,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk8.ehip_mac_50g_7,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_1.genblk8.ehip_mac_50g_7,1)\
        end\
    end // aib08 \
    // For PTP channel base at AIB21: 25g,50g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G") || (eth_ip_instance_hpath.EHIP_RATE == "50G")) && \
    (aib_id == 21) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk2.ehip_mac_50g_1,1)\
        end\
    end // aib21 \
    // For PTP channel base at AIB17: 25g,50g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G") || (eth_ip_instance_hpath.EHIP_RATE == "50G")) && \
    (aib_id == 17) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk4.ehip_mac_50g_3,1)\
        end\
    end // aib17 \
    // For PTP channel base at AIB13: 25g,50g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G") || (eth_ip_instance_hpath.EHIP_RATE == "50G")) && \
    (aib_id == 13) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk6.ehip_mac_50g_5,1)\
        end\
    end // aib13 \
    // For PTP channel base at AIB09: 25g,50g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G") || (eth_ip_instance_hpath.EHIP_RATE == "50G")) && \
    (aib_id == 9) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,1,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk8.ehip_mac_50g_7,1)\
        end\
    end // aib09 \
    // For PTP channel base at AIB19: 25g,50g,100g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G") || (eth_ip_instance_hpath.EHIP_RATE == "50G") || (eth_ip_instance_hpath.EHIP_RATE == "100G")) && \
    (aib_id == 19) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,1,eth_ip_sip_instance_hpath)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,1,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,2,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,3,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,4,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,5,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,6,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,7,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk3.ehip_mac_50g_2,1)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,1)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,2)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,3)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,4)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,5)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,6)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk1.ehip_mac_200g_0,7)\
        end\
    end // aib19 \
    // For PTP channel base at AIB11: 25g,50g,100g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G") || (eth_ip_instance_hpath.EHIP_RATE == "50G") || (eth_ip_instance_hpath.EHIP_RATE == "100G")) && \
    (aib_id == 11) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,1,eth_ip_sip_instance_hpath)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,1,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,2,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,3,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,4,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,5,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,6,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,7,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk7.ehip_mac_50g_6,1)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,1)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,2)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,3)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,4)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,5)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,6)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_1.genblk2.ehip_mac_200g_1,7)\
        end\
    end // aib11 \
    // For PTP channel base at AIB15: 25g,50g,100g,200g\
    if ( \
    (eth_ip_instance_hpath.ENABLE_PTP == 1'b1)   && \
    ((eth_ip_instance_hpath.EHIP_RATE == "10G") || (eth_ip_instance_hpath.EHIP_RATE == "25G") || (eth_ip_instance_hpath.EHIP_RATE == "50G") || (eth_ip_instance_hpath.EHIP_RATE == "100G") || (eth_ip_instance_hpath.EHIP_RATE == "200G")) && \
    (aib_id == 15) \
    ) begin \
        if (one_hot_selector == 1) begin\
            #6000ps;\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk5.ehip_mac_50g_4,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk5.ehip_mac_50g_4,1,eth_ip_sip_instance_hpath)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,0,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,1,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,2,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,3,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,4,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,5,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,6,eth_ip_sip_instance_hpath)\
            `special_handling_for_ptp_simulation_force(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,7,eth_ip_sip_instance_hpath)\
        end\
        else begin\
            // 25g/50g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk5.ehip_mac_50g_4,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar1.ehip_par_50g_0.genblk5.ehip_mac_50g_4,1)\
            // 100g/200g hip reg \
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,0)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,1)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,2)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,3)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,4)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,5)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,6)\
            `special_handling_for_ptp_simulation_release(tile_atom_hpath.u_e400g_top.u_e4hip_top.gdr_e4hip_mac.gdr_ehip_mac.gdr_e4hip_macpar0.ehip_par_200g_0.genblk2.ehip_mac_200g_1,7)\
        end\
    end // aib15 \
`endif // ifndef ALTERA_RESERVED_QIS

`define special_handling_for_ptp_simulation(ptp_mux_ip_instance_hpath, eth_ip_instance_hpath, eth_ip_sip_instance_hpath, tile_atom_hpath, aib_id, one_hot_selector) \
`ifndef ALTERA_RESERVED_QIS \
    `ifndef SKIP_SIM_MODEL_LOG2_MRK \
        always @ (one_hot_selector) begin \
            #6000ps;\
            if (eth_ip_instance_hpath.PTP_MRIP_DEBUG == 0)\
                `special_handling_for_ptp_simulation_sr (eth_ip_instance_hpath, eth_ip_sip_instance_hpath, tile_atom_hpath.z1577b.z1577b_inst, aib_id, one_hot_selector)\
            else if (eth_ip_instance_hpath.PTP_MRIP_DEBUG == 1)\
                `special_handling_for_ptp_simulation_mr (eth_ip_instance_hpath, eth_ip_sip_instance_hpath, tile_atom_hpath.z1577b.z1577b_inst, aib_id, one_hot_selector)\
            end \
    `endif // ifndef SKIP_SIM_MODEL_LOG2MRK  \
`endif // ifndef ALTERA_RESERVED_QIS
// PTP DEFINE MACRO ENDS
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "p0vPiwpAXADYRz80VvmsyeuDhmJJD2lJN1Yl+SgHf3oOXrsSTW3shEAEXEqO81PWdKYq9Ie52QIVR7dYGxQwEKoz1V5qSWZ2G71UR3imqwBwazZtVmQMQsyPUQ1S8MBrwXYK/J5Bw6zFRgMmrx/nXh6bUHv2KG2P4l3C89ouQLsu3rPCCVUBwJlznve+wukBdtOnAIylD1nY+mzCtWoaJwCO45l4T/GBrEnpi+O9MVjCPzEJ1TT/G2xTwp0KKptSRB5hznZz+fHY8+6bOe3DdobUZ0VInaAfDb+Pqz+qanJlFj3DpBYommRxnXaiCzhyNjwoYKXLzVy4Xo0SLDP06JL516twI3sldBTbvmb0vKkX4ATWfoFhypclvzJO4YbOAshmaj091gdc4FeZrb8ObZPr53zlUYw5rE+A5KptETvfdc1FIuFCK0JSzVlxX005+zj9RWMkUF6BExPUp0IlXZ5U2Y9E+VlUBP4mJNeZbDunei+pUCu5/P2FGO7xj/HaDgSQytSIIrfjHwWymz2XHUpKUv6Hd3w5IkNllRZm1orGHOwBYn3vgXz0jA6fRnhAqsqv61ccaspxp9UegT5STnArF5S6/953tP5j8RwmVDALjianwh3i6ziuAoY/FyThdcE/EIKW20517czRb6yhp3T03NR4FHGJlSnboIYMbbnC/8Cm4IYnZfjps2270AJbhzfgrcquGkRBX3OwA/h5Siummybx28AtREGYoqYvAb7RJ0JsfunDaKxG806dYX/5pSPaq9dqrECCFbbhOU/j1acG4/0sgUzQqGqeGvG+9OEKkCRTDHrhV6KXvNJYI5L1lhgw7Hwz9lPa5HPaB90CT1fi40yQEb+rqq6No+AShYYVyaAeukX0tAF83tDdlp66bIAGg5/x0Si2mvy//3u7Vn3Jvvy/xs1HXOQcY7/E/hFFk/dVY7r8xDE/GGF/Zv/Wfqj7bRa6TyhF3shY6EDXzW3/rE/yWPztRske/BjU73JWDbV8U4ty/pArug/QDKb1"
`endif
// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`define special_handling_for_pcie_simulation(pcie_qhip_instance_hpath, tile_atom_hpath) \
    `ifndef ALTERA_RESERVED_QIS \
        `ifdef gdrb_GDR_PCIE_SS_DV \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe0_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe0_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__localfs					 = pcie_qhip_instance_hpath.i_rxpipe0_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__locallf					 = pcie_qhip_instance_hpath.i_rxpipe0_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe0_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe0_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe0_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe0_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe0_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe0_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe0_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe0_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe0_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe0_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe0_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe0_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe0_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe0__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe0_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe1_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe1_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__localfs					 = pcie_qhip_instance_hpath.i_rxpipe1_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__locallf					 = pcie_qhip_instance_hpath.i_rxpipe1_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe1_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe1_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe1_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe1_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe1_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe1_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe1_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe1_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe1_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe1_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe1_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe1_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe1_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe1__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe1_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe2_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe2_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__localfs					 = pcie_qhip_instance_hpath.i_rxpipe2_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__locallf					 = pcie_qhip_instance_hpath.i_rxpipe2_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe2_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe2_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe2_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe2_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe2_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe2_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe2_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe2_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe2_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe2_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe2_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe2_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe2_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe2__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe2_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe3_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe3_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__localfs					 = pcie_qhip_instance_hpath.i_rxpipe3_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__locallf					 = pcie_qhip_instance_hpath.i_rxpipe3_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe3_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe3_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe3_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe3_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe3_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe3_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe3_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe3_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe3_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe3_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe3_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe3_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe3_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe3__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe3_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe4_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe4_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__localfs					 = pcie_qhip_instance_hpath.i_rxpipe4_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__locallf					 = pcie_qhip_instance_hpath.i_rxpipe4_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe4_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe4_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe4_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe4_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe4_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe4_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe4_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe4_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe4_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe4_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe4_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe4_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe4_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe4__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe4_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe5_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe5_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__localfs					 = pcie_qhip_instance_hpath.i_rxpipe5_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__locallf					 = pcie_qhip_instance_hpath.i_rxpipe5_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe5_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe5_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe5_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe5_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe5_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe5_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe5_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe5_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe5_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe5_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe5_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe5_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe5_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe5__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe5_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe6_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe6_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__localfs					 = pcie_qhip_instance_hpath.i_rxpipe6_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__locallf					 = pcie_qhip_instance_hpath.i_rxpipe6_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe6_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe6_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe6_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe6_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe6_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe6_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe6_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe6_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe6_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe6_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe6_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe6_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe6_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe6__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe6_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe7_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe7_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__localfs					 = pcie_qhip_instance_hpath.i_rxpipe7_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__locallf					 = pcie_qhip_instance_hpath.i_rxpipe7_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe7_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe7_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe7_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe7_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe7_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe7_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe7_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe7_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe7_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe7_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe7_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe7_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe7_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe7__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe7_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe8_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe8_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__localfs					 = pcie_qhip_instance_hpath.i_rxpipe8_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__locallf					 = pcie_qhip_instance_hpath.i_rxpipe8_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe8_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe8_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe8_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe8_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe8_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe8_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe8_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe8_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe8_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe8_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe8_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe8_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe8_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe8__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe8_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe9_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe9_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__localfs					 = pcie_qhip_instance_hpath.i_rxpipe9_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__locallf					 = pcie_qhip_instance_hpath.i_rxpipe9_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe9_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe9_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe9_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe9_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe9_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe9_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe9_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe9_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe9_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe9_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe9_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe9_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe9_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe9__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe9_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe10_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe10_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__localfs					 = pcie_qhip_instance_hpath.i_rxpipe10_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__locallf					 = pcie_qhip_instance_hpath.i_rxpipe10_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe10_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe10_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe10_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe10_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe10_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe10_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe10_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe10_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe10_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe10_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe10_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe10_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe10_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe10__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe10_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe11_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe11_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__localfs					 = pcie_qhip_instance_hpath.i_rxpipe11_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__locallf					 = pcie_qhip_instance_hpath.i_rxpipe11_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe11_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe11_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe11_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe11_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe11_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe11_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe11_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe11_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe11_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe11_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe11_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe11_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe11_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe11__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe11_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe12_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe12_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__localfs					 = pcie_qhip_instance_hpath.i_rxpipe12_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__locallf					 = pcie_qhip_instance_hpath.i_rxpipe12_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe12_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe12_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe12_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe12_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe12_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe12_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe12_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe12_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe12_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe12_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe12_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe12_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe12_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe12__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe12_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe13_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe13_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__localfs					 = pcie_qhip_instance_hpath.i_rxpipe13_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__locallf					 = pcie_qhip_instance_hpath.i_rxpipe13_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe13_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe13_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe13_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe13_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe13_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe13_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe13_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe13_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe13_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe13_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe13_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe13_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe13_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe13__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe13_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe14_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe14_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__localfs					 = pcie_qhip_instance_hpath.i_rxpipe14_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__locallf					 = pcie_qhip_instance_hpath.i_rxpipe14_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe14_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe14_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe14_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe14_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe14_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe14_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe14_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe14_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe14_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe14_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe14_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe14_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe14_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe14__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe14_rxvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__dirfeedback				 = pcie_qhip_instance_hpath.i_rxpipe15_dirfeedback; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__linkevaluationfeedbackfiguremerit		 = pcie_qhip_instance_hpath.i_rxpipe15_linkevaluationfeedbackfiguremerit; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__localfs					 = pcie_qhip_instance_hpath.i_rxpipe15_localfs; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__locallf					 = pcie_qhip_instance_hpath.i_rxpipe15_locallf; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__localtxcoefficientsvalid			 = pcie_qhip_instance_hpath.i_rxpipe15_localtxcoefficientsvalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__localtxpresetcoefficients			 = pcie_qhip_instance_hpath.i_rxpipe15_localtxpresetcoefficients; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__p2m_bus					 = pcie_qhip_instance_hpath.i_rxpipe15_p2m_bus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__pclkchangeok				 = pcie_qhip_instance_hpath.i_rxpipe15_pclkchangeok; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__phystatus					 = pcie_qhip_instance_hpath.i_rxpipe15_phystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__rxdata					 = pcie_qhip_instance_hpath.i_rxpipe15_rxdata; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__rxdatak					 = pcie_qhip_instance_hpath.i_rxpipe15_rxdatak; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__rxdatavalid				 = pcie_qhip_instance_hpath.i_rxpipe15_rxdatavalid; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__rxelecidlea				 = pcie_qhip_instance_hpath.i_rxpipe15_rxelecidlea; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__rxstandbystatus				 = pcie_qhip_instance_hpath.i_rxpipe15_rxstandbystatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__rxstartblock				 = pcie_qhip_instance_hpath.i_rxpipe15_rxstartblock; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__rxstatus					 = pcie_qhip_instance_hpath.i_rxpipe15_rxstatus; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__rxsyncheader				 = pcie_qhip_instance_hpath.i_rxpipe15_rxsyncheader; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_rxpipe15__rxvalid					 = pcie_qhip_instance_hpath.i_rxpipe15_rxvalid; \
	    assign pcie_qhip_instance_hpath.o_p1_prot_f2t_ssr				         = tile_atom_hpath.z1577b.z1577b_inst.o_p1__prot_f2t_ssr; \
            assign pcie_qhip_instance_hpath.o_txpipe0_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe0_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe0_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe0_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe0_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe0_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe0_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe0_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe0_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe0_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe0_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe0_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe0_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe0_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe0_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe0_rate						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe0_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe0_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe0_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe0_rxeqtraining					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe0_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe0_rxpresethint					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe0_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe0_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe0_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txcompliance					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txstartblock					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe0_txsyncheader					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe0_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe0__width; \
            assign pcie_qhip_instance_hpath.o_txpipe1_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe1_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe1_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe1_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe1_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe1_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe1_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe1_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe1_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe1_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe1_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe1_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe1_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe1_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe1_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe1_rate						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe1_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe1_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe1_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe1_rxeqtraining					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe1_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe1_rxpresethint					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe1_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe1_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe1_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txcompliance					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txstartblock					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe1_txsyncheader					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe1_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe1__width; \
            assign pcie_qhip_instance_hpath.o_txpipe2_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe2_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe2_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe2_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe2_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe2_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe2_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe2_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe2_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe2_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe2_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe2_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe2_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe2_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe2_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe2_rate						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe2_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe2_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe2_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe2_rxeqtraining					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe2_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe2_rxpresethint					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe2_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe2_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe2_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txcompliance					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txstartblock					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe2_txsyncheader					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe2_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe2__width; \
            assign pcie_qhip_instance_hpath.o_txpipe3_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe3_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe3_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe3_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe3_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe3_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe3_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe3_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe3_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe3_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe3_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe3_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe3_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe3_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe3_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe3_rate						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe3_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe3_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe3_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe3_rxeqtraining					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe3_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe3_rxpresethint					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe3_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe3_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe3_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txcompliance					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txstartblock					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe3_txsyncheader					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe3_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe3__width; \
            assign pcie_qhip_instance_hpath.o_txpipe4_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe4_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe4_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe4_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe4_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe4_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe4_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe4_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe4_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe4_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe4_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe4_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe4_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe4_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe4_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe4_rate						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe4_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe4_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe4_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe4_rxeqtraining					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe4_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe4_rxpresethint					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe4_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe4_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe4_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txcompliance					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txstartblock					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe4_txsyncheader					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe4_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe4__width; \
            assign pcie_qhip_instance_hpath.o_txpipe5_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe5_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe5_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe5_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe5_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe5_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe5_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe5_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe5_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe5_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe5_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe5_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe5_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe5_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe5_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe5_rate						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe5_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe5_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe5_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe5_rxeqtraining					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe5_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe5_rxpresethint					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe5_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe5_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe5_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txcompliance					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txstartblock					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe5_txsyncheader					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe5_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe5__width; \
            assign pcie_qhip_instance_hpath.o_txpipe6_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe6_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe6_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe6_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe6_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe6_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe6_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe6_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe6_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe6_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe6_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe6_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe6_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe6_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe6_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe6_rate						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe6_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe6_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe6_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe6_rxeqtraining					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe6_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe6_rxpresethint					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe6_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe6_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe6_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txcompliance					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txstartblock					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe6_txsyncheader					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe6_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe6__width; \
            assign pcie_qhip_instance_hpath.o_txpipe7_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe7_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe7_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe7_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe7_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe7_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe7_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe7_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe7_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe7_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe7_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe7_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe7_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe7_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe7_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe7_rate						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe7_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe7_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe7_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe7_rxeqtraining					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe7_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe7_rxpresethint					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe7_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe7_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe7_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txcompliance					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txstartblock					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe7_txsyncheader					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe7_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe7__width; \
            assign pcie_qhip_instance_hpath.o_txpipe8_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe8_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe8_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe8_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe8_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe8_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe8_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe8_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe8_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe8_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe8_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe8_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe8_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe8_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe8_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe8_rate						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe8_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe8_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe8_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe8_rxeqtraining					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe8_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe8_rxpresethint					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe8_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe8_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe8_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txcompliance					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txstartblock					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe8_txsyncheader					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe8_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe8__width; \
            assign pcie_qhip_instance_hpath.o_txpipe9_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe9_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe9_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe9_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe9_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe9_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe9_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe9_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe9_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe9_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe9_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe9_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe9_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe9_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe9_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe9_rate						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe9_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe9_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe9_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe9_rxeqtraining					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe9_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe9_rxpresethint					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe9_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe9_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe9_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txcompliance					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txstartblock					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe9_txsyncheader					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe9_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe9__width; \
            assign pcie_qhip_instance_hpath.o_txpipe10_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe10_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe10_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe10_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe10_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe10_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe10_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe10_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe10_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe10_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe10_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe10_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe10_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe10_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe10_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe10_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe10_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe10_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe10_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe10_rxeqtraining				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe10_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe10_rxpresethint				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe10_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe10_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe10_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txcompliance				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txstartblock				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe10_txsyncheader				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe10_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe10__width; \
            assign pcie_qhip_instance_hpath.o_txpipe11_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe11_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe11_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe11_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe11_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe11_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe11_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe11_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe11_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe11_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe11_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe11_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe11_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe11_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe11_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe11_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe11_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe11_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe11_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe11_rxeqtraining				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe11_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe11_rxpresethint				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe11_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe11_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe11_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txcompliance				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txstartblock				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe11_txsyncheader				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe11_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe11__width; \
            assign pcie_qhip_instance_hpath.o_txpipe12_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe12_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe12_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe12_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe12_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe12_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe12_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe12_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe12_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe12_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe12_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe12_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe12_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe12_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe12_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe12_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe12_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe12_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe12_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe12_rxeqtraining				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe12_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe12_rxpresethint				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe12_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe12_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe12_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txcompliance				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txstartblock				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe12_txsyncheader				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe12_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe12__width; \
            assign pcie_qhip_instance_hpath.o_txpipe13_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe13_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe13_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe13_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe13_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe13_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe13_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe13_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe13_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe13_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe13_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe13_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe13_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe13_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe13_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe13_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe13_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe13_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe13_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe13_rxeqtraining				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe13_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe13_rxpresethint				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe13_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe13_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe13_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txcompliance				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txstartblock				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe13_txsyncheader				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe13_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe13__width; \
            assign pcie_qhip_instance_hpath.o_txpipe14_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe14_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe14_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe14_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe14_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe14_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe14_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe14_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe14_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe14_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe14_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe14_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe14_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe14_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe14_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe14_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe14_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe14_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe14_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe14_rxeqtraining				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe14_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe14_rxpresethint				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe14_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe14_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe14_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txcompliance				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txstartblock				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe14_txsyncheader				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe14_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe14__width; \
            assign pcie_qhip_instance_hpath.o_txpipe15_asyncpowerchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__asyncpowerchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe15_blockaligncontrol				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__blockaligncontrol; \
            assign pcie_qhip_instance_hpath.o_txpipe15_cfg_hw_auto_sp_dis				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__cfg_hw_auto_sp_dis; \
            assign pcie_qhip_instance_hpath.o_txpipe15_dirchange					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__dirchange; \
            assign pcie_qhip_instance_hpath.o_txpipe15_ebuf_mode					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__ebuf_mode; \
            assign pcie_qhip_instance_hpath.o_txpipe15_encodedecodebypass				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__encodedecodebypass; \
            assign pcie_qhip_instance_hpath.o_txpipe15_fs						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__fs; \
            assign pcie_qhip_instance_hpath.o_txpipe15_getlocalpresetcoefficients				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__getlocalpresetcoefficients; \
            assign pcie_qhip_instance_hpath.o_txpipe15_invalidrequest				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__invalidrequest; \
            assign pcie_qhip_instance_hpath.o_txpipe15_lf						 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__lf; \
            assign pcie_qhip_instance_hpath.o_txpipe15_localpresetindex				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__localpresetindex; \
            assign pcie_qhip_instance_hpath.o_txpipe15_m2p_bus					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__m2p_bus; \
            assign pcie_qhip_instance_hpath.o_txpipe15_pclk_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__pclk_rate; \
            assign pcie_qhip_instance_hpath.o_txpipe15_pclkchangeack				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__pclkchangeack; \
            assign pcie_qhip_instance_hpath.o_txpipe15_powerdown					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__powerdown; \
            assign pcie_qhip_instance_hpath.o_txpipe15_rate					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__rate; \
            assign pcie_qhip_instance_hpath.o_txpipe15_rxelecidle_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__rxelecidle_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe15_rxeqeval					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__rxeqeval; \
            assign pcie_qhip_instance_hpath.o_txpipe15_rxeqinprogress				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__rxeqinprogress; \
            assign pcie_qhip_instance_hpath.o_txpipe15_rxeqtraining				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__rxeqtraining; \
            assign pcie_qhip_instance_hpath.o_txpipe15_rxpolarity					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__rxpolarity; \
            assign pcie_qhip_instance_hpath.o_txpipe15_rxpresethint				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__rxpresethint; \
            assign pcie_qhip_instance_hpath.o_txpipe15_rxstandby					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__rxstandby; \
            assign pcie_qhip_instance_hpath.o_txpipe15_rxtermination				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__rxtermination; \
            assign pcie_qhip_instance_hpath.o_txpipe15_srisenable					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__srisenable; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txcmnmode_disable_a				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txcmnmode_disable_a; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txcompliance				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txcompliance; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txdata					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txdata; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txdatak					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txdatak; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txdatavalid					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txdatavalid; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txdeemph					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txdeemph; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txdtctrx_lb					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txdtctrx_lb; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txelecidle					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txelecidle; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txmargin					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txmargin; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txoneszeros					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txoneszeros; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txstartblock				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txstartblock; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txswing					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txswing; \
            assign pcie_qhip_instance_hpath.o_txpipe15_txsyncheader				 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__txsyncheader; \
            assign pcie_qhip_instance_hpath.o_txpipe15_width					 = tile_atom_hpath.z1577b.z1577b_inst.o_txpipe15__width; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_pclk__x4_l4						 = pcie_qhip_instance_hpath.i_pclk_x4_l4; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_pclk__x4_l12					 = pcie_qhip_instance_hpath.i_pclk_x4_l12; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_pclk__x8_l8						 = pcie_qhip_instance_hpath.i_pclk_x8_l8; \
            assign tile_atom_hpath.z1577b.z1577b_inst.i_pclk__x16_l0					 = pcie_qhip_instance_hpath.i_pclk_x16_l0; \
        `endif \
    `endif // ifndef ALTERA_RESERVED_QIS 
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "IT6yQt+KW2LWSOPHX0e9DV1szqWforfwHqfTEg+o0yE5GWvzlHigbIz/YQ7CxHPBw8UIm5Ih33SB5fPaMkigCxN/YkOZBozpwzR0gNJTgQNLmq8ePNSotzJ8WaMAlylQluzML3oANYse0T0puQ4xS/PVUWJBJ7KqpdmmfIub+hSAEMxlxhDin7enjb8PKxTMC0/MiEzldV+Ey/p05fKf2Yt4oiEf3wfDki6SaNXLNz3onvK+sOWRDsiXBrm1/QgmVd/r6R5gB9LkBqTgNZFcrjsq+O1rxUZn0/v5sKf2gDalFoTPZLN+joKi+kwDIm2CbmsJN1vFEm3sUV2Ofq4yaTlHMmbyv14u1QcNMUL/9boukpeJ4x1vWoRVZB3WSCgw1DeUuynzcBf8YCRzhoquG1inn6CE4Ayg5/8jxNRLn9VR7NzhX/5LbN2H2WUskynvNO9DcP5y7ZUpC36VZbj0M04ub1xLFlQ6LdcoBkUE98j6xPabau4cbHVs55pj0/AMftmBxpvHlApZ239Vb8Le6i7vrf1p4Be3X0x5PdBj3eIN4clTbacz6BeXrQx6rRGDNuWcRkDA+IXKFkH1Jh5E7F4WEVJtqPuIGNvu7/kGunfu7MtkwcwK8Qb4msuaaPKmfDWufQ1sR3aqVIosYzx6SssiHzek76qD/u2W+6Hld0S1jqVY92EQQkT+Phy2C3q1A40ZoSMyoxWm261dGn7dUZQKHWwi5i+LqXmiWDbdonAjAY1mRTjIMlDepgBYx/3e0tsdyidgBQU/sBYDOq0eRvULDCJ/wIsVLHP6fZdElxJ3oFOCaWd1jfFY3NrCIzNjN/9NU4yrCTkz25ESPh+0GifLflNd4f0Bfyv8zO3N22Vhq6we33JE91obxSErayzDaQ+m3ki1dYr0QCUh/jjFhFL9g5Qzmbb1TRPZyCyQReO1AH0SrpTFBYQoVBCe/HrGaUkKRN6Q5ZfNPp8tPjZZ3snhfi1THOaA1BvcMyYMWdex57npk9+IkNnUiDdBR6R2"
`endif
// altera message_off 16788
module sdi_ii_agi_demo_auto_tiles();

f_tile_soft_reset_ctlr_ip_v1 #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.init_fname(
`ifdef ALTERA_RESERVED_QIS
	"support_logic/sdi_ii_agi_demo__z1577b_x393_y0_n0.mif"
`else
	"sdi_ii_agi_demo__z1577b_x393_y0_n0.mif"
`endif
	)
) z1577b_x393_y0_n0__reset_controller();

wire z1577b_x393_y0_n0__avmm1_0__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_0__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_0__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_0__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_0__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_0__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_0__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_0__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_0__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_0__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_0__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_0__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_0__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_0__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_0__pld_hssi_osc_transfer_en_real;
wire sdi_ii_agi_demo__xcvr_ref_sysclk_inst2__xcvr_ref_sysclk__one_hot_selector;
wire sdi_ii_agi_demo__xcvr_ref_sysclk_inst__xcvr_ref_sysclk__one_hot_selector;
wire z1577b_x393_y0_n0__reset_controller__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(0),
	.num_ip_on_intfc_00(3),
	.num_ip_on_intfc_01(4)
) z1577b_x393_y0_n0__avmm1_0(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_0__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_0__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_0__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real({sdi_ii_agi_demo__xcvr_ref_sysclk_inst2__xcvr_ref_sysclk__one_hot_selector,sdi_ii_agi_demo__xcvr_ref_sysclk_inst__xcvr_ref_sysclk__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_00_pld_chnl_cal_done_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_chnl_cal_done,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_chnl_cal_done,
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[0]}),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__xcvr_ref_sysclk_inst2__xcvr_ref_sysclk__one_hot_selector,sdi_ii_agi_demo__xcvr_ref_sysclk_inst__xcvr_ref_sysclk__one_hot_selector,sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_busy,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_busy,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[0]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_clk_rowclk,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_clk_rowclk,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[0]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_full,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_full,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[0]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_pfull,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_pfull,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[0]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_read,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_read,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[0]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[0][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[0][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[0][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[0][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdatavalid,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdatavalid,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[0]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[0][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[0][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[0][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[0][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[0][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[0][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_request,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_request,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[0]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[0][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[0][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[0][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[0][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[0][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[0][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_write,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_write,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[0]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[0][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[0][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[0][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[0][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_hssi_osc_transfer_en,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_hssi_osc_transfer_en,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[0]}));

wire z1577b_x393_y0_n0__avmm1_1__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_1__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_1__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_1__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_1__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_1__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_1__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_1__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_1__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_1__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_1__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_1__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_1__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_1__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_1__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(1),
	.num_ip_on_intfc_00(3),
	.num_ip_on_intfc_01(4)
) z1577b_x393_y0_n0__avmm1_1(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_1__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_1__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_1__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real({sdi_ii_agi_demo__xcvr_ref_sysclk_inst2__xcvr_ref_sysclk__one_hot_selector,sdi_ii_agi_demo__xcvr_ref_sysclk_inst__xcvr_ref_sysclk__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_00_pld_chnl_cal_done_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_chnl_cal_done_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_chnl_cal_done_ref_0,
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[1]}),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__xcvr_ref_sysclk_inst2__xcvr_ref_sysclk__one_hot_selector,sdi_ii_agi_demo__xcvr_ref_sysclk_inst__xcvr_ref_sysclk__one_hot_selector,sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_busy_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_busy_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[1]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_clk_rowclk_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_clk_rowclk_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[1]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_full_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_full_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[1]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_pfull_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_pfull_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[1]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_read_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_read_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[1]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_0[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[15],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[14],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[13],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[12],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[11],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[10],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[1][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[1][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[1][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[1][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdatavalid_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdatavalid_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[1]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_0[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[19],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[18],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[17],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[16],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[15],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[14],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[13],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[12],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[11],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[1][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[1][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[1][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[1][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[1][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[1][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_request_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_request_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[1]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_0[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[17],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[16],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[15],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[14],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[13],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[12],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[11],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[10],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[1][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[1][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[1][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[1][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[1][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_0[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_0[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_0[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_0[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_0[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_0[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[1][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_write_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_write_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[1]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_0[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[15],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[14],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[13],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[12],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[11],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[10],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[1][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[1][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[1][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[1][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_hssi_osc_transfer_en_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_hssi_osc_transfer_en_ref_0,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[1]}));

wire z1577b_x393_y0_n0__avmm1_10__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_10__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_10__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_10__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_10__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_10__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_10__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_10__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_10__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_10__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_10__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_10__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_10__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_10__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_10__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(10),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_10(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_10__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_10__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_10__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[10]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[10]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[10]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[10]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[10]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[10]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[87],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[86],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[85],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[84],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[83],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[82],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[81],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[80],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[10][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[10][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[10][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[10][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[10]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[109],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[108],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[107],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[106],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[105],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[104],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[103],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[102],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[101],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[100],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[10][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[10][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[10][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[10][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[10][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[10][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[10]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[98],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[97],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[96],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[95],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[94],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[93],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[92],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[91],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[90],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[10][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[10][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[10][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[10][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[10][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[32],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[31],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[30],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[10][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[10]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[87],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[86],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[85],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[84],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[83],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[82],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[81],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[80],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[10][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[10][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[10][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[10][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[10]}));

wire z1577b_x393_y0_n0__avmm1_11__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_11__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_11__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_11__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_11__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_11__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_11__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_11__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_11__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_11__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_11__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_11__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_11__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_11__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_11__pld_hssi_osc_transfer_en_real;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst0__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst0__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector_shared;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst0__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile1__sec_profile_1__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst0__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile2__sec_profile_2__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst0__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile3__sec_profile_3__one_hot_selector;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(11),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(6),
	.intfc_01_arbiter_clk_src_s_ndx(2)
) z1577b_x393_y0_n0__avmm1_11(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_11__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_11__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_11__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[11]),
	.intfc_01_one_hot_selector_real({1'b0,1'b0,1'b0,sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst0__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector_shared,sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[11]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[11]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[11]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[11]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[11]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[95],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[94],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[93],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[92],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[91],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[90],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[89],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[88],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[11][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[11][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[11][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[11][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[11]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[119],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[118],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[117],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[116],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[115],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[114],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[113],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[112],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[111],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[110],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[11][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[11][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[11][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[11][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[11][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[11][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[11]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[107],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[106],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[105],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[104],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[103],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[102],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[101],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[100],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[99],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[11][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[11][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[11][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[11][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[11][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[35],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[34],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[33],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[11][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[11]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[95],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[94],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[93],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[92],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[91],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[90],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[89],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[88],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[11][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[11][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[11][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[11][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst0.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[11]}));

wire z1577b_x393_y0_n0__avmm1_12__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_12__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_12__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_12__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_12__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_12__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_12__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_12__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_12__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_12__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_12__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_12__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_12__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_12__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_12__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(12),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_12(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_12__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_12__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_12__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[12]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[12]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[12]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[12]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[12]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[12]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[103],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[102],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[101],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[100],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[99],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[98],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[97],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[96],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[12][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[12][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[12][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[12][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[12]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[129],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[128],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[127],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[126],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[125],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[124],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[123],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[122],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[121],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[120],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[12][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[12][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[12][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[12][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[12][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[12][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[12]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[116],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[115],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[114],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[113],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[112],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[111],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[110],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[109],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[108],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[12][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[12][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[12][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[12][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[12][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[38],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[37],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[36],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[12][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[12]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[103],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[102],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[101],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[100],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[99],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[98],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[97],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[96],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[12][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[12][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[12][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[12][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[12]}));

wire z1577b_x393_y0_n0__avmm1_13__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_13__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_13__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_13__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_13__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_13__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_13__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_13__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_13__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_13__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_13__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_13__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_13__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_13__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_13__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(13),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_13(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_13__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_13__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_13__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[13]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[13]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[13]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[13]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[13]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[13]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[111],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[110],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[109],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[108],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[107],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[106],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[105],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[104],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[13][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[13][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[13][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[13][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[13]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[139],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[138],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[137],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[136],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[135],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[134],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[133],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[132],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[131],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[130],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[13][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[13][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[13][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[13][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[13][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[13][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[13]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[125],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[124],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[123],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[122],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[121],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[120],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[119],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[118],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[117],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[13][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[13][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[13][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[13][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[13][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[41],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[40],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[39],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[13][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[13]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[111],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[110],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[109],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[108],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[107],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[106],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[105],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[104],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[13][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[13][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[13][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[13][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[13]}));

wire z1577b_x393_y0_n0__avmm1_14__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_14__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_14__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_14__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_14__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_14__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_14__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_14__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_14__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_14__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_14__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_14__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_14__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_14__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_14__pld_hssi_osc_transfer_en_real;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst2__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst2__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector_shared;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst2__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile1__sec_profile_1__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst2__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile2__sec_profile_2__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst2__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile3__sec_profile_3__one_hot_selector;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(14),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(6),
	.intfc_01_arbiter_clk_src_s_ndx(2)
) z1577b_x393_y0_n0__avmm1_14(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_14__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_14__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_14__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[14]),
	.intfc_01_one_hot_selector_real({1'b0,1'b0,1'b0,sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst2__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector_shared,sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[14]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[14]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[14]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[14]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[14]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[119],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[118],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[117],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[116],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[115],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[114],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[113],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[112],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[14][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[14][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[14][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[14][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[14]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[149],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[148],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[147],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[146],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[145],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[144],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[143],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[142],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[141],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[140],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[14][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[14][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[14][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[14][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[14][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[14][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[14]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[134],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[133],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[132],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[131],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[130],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[129],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[128],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[127],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[126],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[14][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[14][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[14][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[14][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[14][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[44],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[43],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[42],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[14][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[14]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[119],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[118],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[117],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[116],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[115],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[114],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[113],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[112],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[14][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[14][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[14][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[14][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst2.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[14]}));

wire z1577b_x393_y0_n0__avmm1_15__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_15__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_15__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_15__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_15__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_15__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_15__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_15__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_15__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_15__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_15__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_15__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_15__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_15__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_15__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(15),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_15(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_15__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_15__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_15__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[15]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[15]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[15]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[15]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[15]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[15]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[127],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[126],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[125],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[124],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[123],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[122],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[121],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[120],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[15][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[15][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[15][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[15][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[15]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[159],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[158],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[157],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[156],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[155],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[154],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[153],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[152],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[151],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[150],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[15][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[15][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[15][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[15][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[15][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[15][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[15]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[143],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[142],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[141],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[140],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[139],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[138],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[137],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[136],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[135],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[15][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[15][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[15][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[15][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[15][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[47],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[46],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[45],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[15][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[15]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[127],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[126],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[125],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[124],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[123],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[122],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[121],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[120],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[15][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[15][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[15][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[15][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[15]}));

wire z1577b_x393_y0_n0__avmm1_16__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_16__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_16__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_16__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_16__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_16__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_16__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_16__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_16__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_16__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_16__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_16__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_16__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_16__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_16__pld_hssi_osc_transfer_en_real;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst1__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst1__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector_shared;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst1__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile1__sec_profile_1__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst1__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile2__sec_profile_2__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst1__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile3__sec_profile_3__one_hot_selector;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(16),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(6),
	.intfc_01_arbiter_clk_src_s_ndx(2)
) z1577b_x393_y0_n0__avmm1_16(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_16__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_16__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_16__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[16]),
	.intfc_01_one_hot_selector_real({1'b0,1'b0,1'b0,sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst1__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector_shared,sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[16]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[16]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[16]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[16]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[16]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[135],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[134],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[133],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[132],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[131],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[130],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[129],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[128],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[16][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[16][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[16][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[16][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[16]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[169],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[168],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[167],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[166],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[165],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[164],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[163],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[162],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[161],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[160],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[16][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[16][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[16][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[16][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[16][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[16][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[16]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[152],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[151],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[150],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[149],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[148],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[147],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[146],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[145],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[144],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[16][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[16][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[16][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[16][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[16][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[50],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[49],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[48],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[16][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[16]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[135],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[134],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[133],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[132],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[131],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[130],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[129],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[128],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[16][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[16][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[16][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[16][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst1.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[16]}));

wire z1577b_x393_y0_n0__avmm1_17__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_17__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_17__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_17__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_17__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_17__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_17__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_17__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_17__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_17__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_17__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_17__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_17__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_17__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_17__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(17),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_17(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_17__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_17__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_17__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[17]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[17]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[17]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[17]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[17]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[17]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[143],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[142],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[141],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[140],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[139],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[138],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[137],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[136],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[17][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[17][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[17][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[17][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[17]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[179],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[178],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[177],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[176],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[175],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[174],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[173],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[172],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[171],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[170],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[17][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[17][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[17][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[17][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[17][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[17][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[17]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[161],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[160],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[159],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[158],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[157],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[156],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[155],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[154],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[153],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[17][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[17][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[17][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[17][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[17][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[53],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[52],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[51],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[17][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[17]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[143],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[142],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[141],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[140],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[139],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[138],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[137],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[136],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[17][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[17][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[17][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[17][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[17]}));

wire z1577b_x393_y0_n0__avmm1_18__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_18__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_18__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_18__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_18__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_18__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_18__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_18__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_18__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_18__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_18__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_18__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_18__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_18__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_18__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(18),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_18(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_18__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_18__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_18__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[18]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[18]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[18]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[18]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[18]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[18]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[151],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[150],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[149],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[148],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[147],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[146],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[145],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[144],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[18][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[18][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[18][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[18][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[18]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[189],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[188],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[187],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[186],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[185],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[184],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[183],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[182],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[181],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[180],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[18][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[18][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[18][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[18][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[18][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[18][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[18]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[170],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[169],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[168],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[167],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[166],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[165],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[164],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[163],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[162],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[18][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[18][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[18][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[18][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[18][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[56],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[55],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[54],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[18][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[18]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[151],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[150],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[149],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[148],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[147],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[146],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[145],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[144],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[18][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[18][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[18][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[18][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[18]}));

wire z1577b_x393_y0_n0__avmm1_19__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_19__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_19__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_19__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_19__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_19__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_19__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_19__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_19__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_19__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_19__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_19__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_19__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_19__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_19__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(19),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_19(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_19__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_19__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_19__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[19]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[19]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[19]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[19]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[19]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[19]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[159],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[158],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[157],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[156],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[155],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[154],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[153],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[152],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[19][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[19][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[19][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[19][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[19]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[199],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[198],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[197],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[196],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[195],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[194],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[193],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[192],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[191],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[190],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[19][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[19][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[19][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[19][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[19][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[19][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[19]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[179],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[178],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[177],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[176],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[175],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[174],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[173],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[172],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[171],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[19][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[19][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[19][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[19][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[19][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[59],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[58],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[57],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[19][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[19]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[159],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[158],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[157],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[156],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[155],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[154],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[153],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[152],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[19][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[19][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[19][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[19][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[19]}));

wire z1577b_x393_y0_n0__avmm1_2__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_2__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_2__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_2__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_2__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_2__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_2__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_2__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_2__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_2__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_2__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_2__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_2__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_2__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_2__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(2),
	.num_ip_on_intfc_00(3),
	.num_ip_on_intfc_01(4)
) z1577b_x393_y0_n0__avmm1_2(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_2__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_2__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_2__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real({sdi_ii_agi_demo__xcvr_ref_sysclk_inst2__xcvr_ref_sysclk__one_hot_selector,sdi_ii_agi_demo__xcvr_ref_sysclk_inst__xcvr_ref_sysclk__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_00_pld_chnl_cal_done_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_chnl_cal_done_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_chnl_cal_done_ref_1,
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[2]}),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__xcvr_ref_sysclk_inst2__xcvr_ref_sysclk__one_hot_selector,sdi_ii_agi_demo__xcvr_ref_sysclk_inst__xcvr_ref_sysclk__one_hot_selector,sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_busy_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_busy_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[2]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_clk_rowclk_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_clk_rowclk_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[2]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_full_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_full_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[2]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_pfull_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_cmdfifo_wr_pfull_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[2]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_read_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_read_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[2]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdata_ref_1[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[23],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[22],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[21],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[20],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[19],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[18],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[17],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[2][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[2][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[2][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[2][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[2][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[2][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[2][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[2][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_readdatavalid_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_readdatavalid_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[2]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reg_addr_ref_1[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[29],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[28],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[27],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[26],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[25],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[24],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[23],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[22],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[21],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[2][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[2][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[2][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[2][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[2][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[2][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[2][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[2][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[2][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[2][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_request_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_request_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[2]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_in_ref_1[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[26],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[25],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[24],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[23],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[22],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[21],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[20],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[19],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[2][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[2][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[2][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[2][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[2][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[2][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[2][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[2][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[2][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_1[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_1[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_1[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_1[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_1[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_reserved_out_ref_1[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[2][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[2][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[2][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_write_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_write_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[2]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_avmm1_writedata_ref_1[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[23],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[22],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[21],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[20],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[19],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[18],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[17],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[2][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[2][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[2][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[2][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[2][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[2][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[2][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[2][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst2.xcvr_ref_sysclk.x_hip.pld_hssi_osc_transfer_en_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.xcvr_ref_sysclk_inst.xcvr_ref_sysclk.x_hip.pld_hssi_osc_transfer_en_ref_1,
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[2]}));

wire z1577b_x393_y0_n0__avmm1_20__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_20__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_20__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_20__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_20__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_20__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_20__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_20__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_20__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_20__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_20__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_20__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_20__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_20__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_20__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(20),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_20(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_20__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_20__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_20__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[20]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[20]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[20]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[20]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[20]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[20]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[167],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[166],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[165],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[164],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[163],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[162],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[161],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[160],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[20][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[20][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[20][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[20][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[20][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[20][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[20][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[20][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[20]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[209],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[208],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[207],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[206],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[205],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[204],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[203],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[202],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[201],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[200],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[20][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[20][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[20][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[20][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[20][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[20][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[20][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[20][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[20][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[20][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[20]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[188],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[187],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[186],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[185],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[184],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[183],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[182],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[181],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[180],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[20][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[20][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[20][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[20][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[20][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[20][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[20][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[20][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[20][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[62],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[61],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[60],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[20][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[20][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[20][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[20]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[167],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[166],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[165],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[164],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[163],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[162],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[161],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[160],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[20][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[20][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[20][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[20][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[20][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[20][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[20][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[20][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[20]}));

wire z1577b_x393_y0_n0__avmm1_21__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_21__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_21__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_21__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_21__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_21__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_21__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_21__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_21__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_21__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_21__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_21__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_21__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_21__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_21__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(21),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_21(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_21__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_21__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_21__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[21]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[21],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[21]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[21],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[21]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[21],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[21]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[21],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[21]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[21],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[21]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[175],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[174],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[173],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[172],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[171],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[170],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[169],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[168],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[21][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[21][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[21][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[21][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[21][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[21][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[21][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[21][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[21],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[21]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[219],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[218],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[217],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[216],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[215],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[214],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[213],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[212],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[211],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[210],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[21][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[21][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[21][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[21][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[21][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[21][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[21][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[21][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[21][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[21][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[21],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[21]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[197],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[196],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[195],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[194],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[193],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[192],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[191],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[190],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[189],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[21][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[21][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[21][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[21][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[21][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[21][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[21][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[21][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[21][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[65],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[64],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[63],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[21][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[21][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[21][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[21],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[21]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[175],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[174],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[173],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[172],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[171],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[170],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[169],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[168],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[21][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[21][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[21][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[21][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[21][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[21][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[21][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[21][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[21],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[21]}));

wire z1577b_x393_y0_n0__avmm1_22__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_22__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_22__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_22__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_22__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_22__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_22__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_22__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_22__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_22__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_22__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_22__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_22__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_22__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_22__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(22),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_22(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_22__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_22__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_22__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[22]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[22],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[22]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[22],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[22]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[22],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[22]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[22],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[22]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[22],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[22]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[183],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[182],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[181],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[180],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[179],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[178],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[177],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[176],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[22][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[22][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[22][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[22][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[22][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[22][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[22][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[22][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[22],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[22]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[229],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[228],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[227],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[226],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[225],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[224],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[223],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[222],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[221],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[220],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[22][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[22][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[22][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[22][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[22][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[22][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[22][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[22][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[22][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[22][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[22],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[22]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[206],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[205],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[204],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[203],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[202],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[201],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[200],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[199],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[198],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[22][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[22][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[22][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[22][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[22][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[22][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[22][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[22][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[22][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[68],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[67],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[66],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[22][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[22][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[22][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[22],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[22]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[183],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[182],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[181],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[180],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[179],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[178],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[177],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[176],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[22][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[22][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[22][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[22][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[22][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[22][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[22][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[22][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[22],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[22]}));

wire z1577b_x393_y0_n0__avmm1_23__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_23__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_23__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_23__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_23__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_23__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_23__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_23__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_23__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_23__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_23__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_23__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_23__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_23__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_23__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(23),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_23(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_23__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_23__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_23__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[23]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[23],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[23]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[23],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[23]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[23],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[23]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[23],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[23]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[23],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[23]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[191],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[190],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[189],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[188],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[187],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[186],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[185],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[184],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[23][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[23][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[23][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[23][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[23][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[23][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[23][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[23][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[23],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[23]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[239],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[238],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[237],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[236],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[235],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[234],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[233],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[232],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[231],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[230],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[23][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[23][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[23][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[23][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[23][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[23][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[23][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[23][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[23][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[23][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[23],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[23]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[215],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[214],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[213],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[212],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[211],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[210],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[209],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[208],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[207],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[23][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[23][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[23][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[23][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[23][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[23][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[23][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[23][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[23][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[71],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[70],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[69],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[23][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[23][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[23][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[23],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[23]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[191],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[190],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[189],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[188],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[187],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[186],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[185],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[184],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[23][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[23][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[23][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[23][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[23][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[23][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[23][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[23][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[23],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[23]}));

wire z1577b_x393_y0_n0__avmm1_3__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_3__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_3__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_3__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_3__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_3__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_3__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_3__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_3__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_3__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_3__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_3__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_3__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_3__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_3__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(3),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_3(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_3__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_3__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_3__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[3]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[3]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[3]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[3]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[3]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[3]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[31],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[30],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[29],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[28],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[27],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[26],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[25],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[24],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[3][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[3][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[3][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[3][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[3][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[3][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[3][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[3][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[3]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[39],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[38],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[37],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[36],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[35],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[34],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[33],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[32],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[31],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[30],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[3][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[3][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[3][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[3][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[3][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[3][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[3][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[3][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[3][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[3][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[3]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[35],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[34],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[33],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[32],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[31],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[30],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[29],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[28],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[27],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[3][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[3][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[3][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[3][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[3][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[3][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[3][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[3][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[3][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[11],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[10],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[3][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[3][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[3][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[3]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[31],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[30],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[29],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[28],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[27],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[26],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[25],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[24],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[3][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[3][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[3][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[3][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[3][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[3][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[3][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[3][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[3]}));

wire z1577b_x393_y0_n0__avmm1_4__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_4__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_4__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_4__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_4__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_4__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_4__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_4__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_4__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_4__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_4__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_4__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_4__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_4__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_4__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(4),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_4(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_4__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_4__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_4__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[4]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[4]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[4]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[4]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[4]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[4]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[39],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[38],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[37],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[36],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[35],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[34],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[33],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[32],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[4][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[4][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[4][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[4][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[4][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[4][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[4][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[4][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[4]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[49],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[48],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[47],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[46],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[45],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[44],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[43],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[42],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[41],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[40],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[4][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[4][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[4][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[4][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[4][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[4][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[4][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[4][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[4][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[4][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[4]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[44],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[43],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[42],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[41],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[40],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[39],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[38],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[37],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[36],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[4][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[4][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[4][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[4][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[4][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[4][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[4][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[4][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[4][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[14],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[13],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[4][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[4][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[4][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[4]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[39],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[38],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[37],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[36],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[35],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[34],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[33],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[32],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[4][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[4][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[4][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[4][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[4][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[4][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[4][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[4][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[4]}));

wire z1577b_x393_y0_n0__avmm1_5__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_5__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_5__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_5__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_5__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_5__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_5__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_5__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_5__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_5__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_5__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_5__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_5__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_5__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_5__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(5),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_5(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_5__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_5__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_5__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[5]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[5]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[5]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[5]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[5]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[5]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[47],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[46],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[45],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[44],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[43],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[42],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[41],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[40],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[5][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[5][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[5][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[5][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[5][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[5][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[5][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[5][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[5]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[59],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[58],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[57],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[56],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[55],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[54],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[53],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[52],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[51],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[50],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[5][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[5][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[5][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[5][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[5][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[5][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[5][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[5][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[5][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[5][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[5]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[53],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[52],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[51],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[50],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[49],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[48],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[47],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[46],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[45],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[5][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[5][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[5][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[5][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[5][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[5][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[5][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[5][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[5][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[17],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[16],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[5][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[5][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[5][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[5]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[47],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[46],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[45],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[44],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[43],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[42],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[41],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[40],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[5][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[5][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[5][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[5][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[5][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[5][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[5][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[5][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[5]}));

wire z1577b_x393_y0_n0__avmm1_6__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_6__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_6__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_6__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_6__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_6__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_6__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_6__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_6__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_6__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_6__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_6__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_6__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_6__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_6__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(6),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_6(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_6__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_6__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_6__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[6]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[6]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[6]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[6]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[6]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[6]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[55],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[54],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[53],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[52],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[51],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[50],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[49],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[48],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[6][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[6][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[6][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[6][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[6][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[6][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[6][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[6][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[6]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[69],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[68],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[67],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[66],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[65],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[64],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[63],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[62],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[61],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[60],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[6][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[6][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[6][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[6][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[6][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[6][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[6][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[6][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[6][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[6][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[6]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[62],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[61],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[60],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[59],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[58],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[57],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[56],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[55],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[54],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[6][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[6][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[6][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[6][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[6][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[6][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[6][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[6][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[6][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[20],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[19],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[6][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[6][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[6][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[6]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[55],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[54],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[53],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[52],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[51],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[50],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[49],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[48],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[6][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[6][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[6][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[6][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[6][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[6][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[6][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[6][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[6]}));

wire z1577b_x393_y0_n0__avmm1_7__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_7__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_7__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_7__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_7__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_7__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_7__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_7__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_7__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_7__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_7__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_7__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_7__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_7__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_7__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(7),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_7(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_7__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_7__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_7__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[7]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[7]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[7]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[7]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[7]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[7]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[63],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[62],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[61],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[60],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[59],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[58],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[57],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[56],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[7][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[7][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[7][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[7][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[7][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[7][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[7][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[7][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[7]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[79],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[78],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[77],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[76],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[75],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[74],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[73],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[72],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[71],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[70],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[7][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[7][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[7][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[7][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[7][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[7][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[7][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[7][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[7][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[7][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[7]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[71],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[70],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[69],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[68],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[67],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[66],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[65],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[64],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[63],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[7][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[7][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[7][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[7][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[7][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[7][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[7][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[7][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[7][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[23],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[22],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[21],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[7][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[7][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[7][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[7]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[63],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[62],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[61],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[60],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[59],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[58],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[57],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[56],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[7][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[7][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[7][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[7][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[7][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[7][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[7][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[7][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[7]}));

wire z1577b_x393_y0_n0__avmm1_8__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_8__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_8__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_8__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_8__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_8__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_8__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_8__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_8__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_8__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_8__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_8__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_8__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_8__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_8__pld_hssi_osc_transfer_en_real;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector_shared;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile1__sec_profile_1__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile2__sec_profile_2__one_hot_selector;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_sec_profile3__sec_profile_3__one_hot_selector;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(8),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(6),
	.intfc_01_arbiter_clk_src_s_ndx(2)
) z1577b_x393_y0_n0__avmm1_8(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_8__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_8__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_8__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[8]),
	.intfc_01_one_hot_selector_real({1'b0,1'b0,1'b0,sdi_ii_agi_demo__SDI_A7SK_inst0__rx_inst__sdi_mr_rx_sys_inst__rx_phy__rx_phy__U_base_profile__directphy_f_0__one_hot_selector_shared,sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_busy[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[8]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_clk_rowclk[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[8]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_cmdfifo_wr_full[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[8]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_cmdfifo_wr_pfull[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[8]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_read[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[8]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[71],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[70],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[69],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[68],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[67],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[66],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[65],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[64],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[8][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[8][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[8][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[8][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[8][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[8][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[8][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[8][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_readdatavalid[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[8]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[9],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reg_addr[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[89],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[88],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[87],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[86],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[85],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[84],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[83],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[82],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[81],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[80],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[8][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[8][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[8][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[8][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[8][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[8][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[8][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[8][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[8][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[8][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_request[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[8]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[8],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_in[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[80],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[79],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[78],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[77],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[76],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[75],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[74],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[73],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[72],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[8][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[8][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[8][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[8][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[8][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[8][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[8][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[8][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[8][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_reserved_out[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[26],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[25],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[24],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[8][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[8][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[8][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_write[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[8]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[7],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[6],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[5],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[4],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[3],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[2],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[1],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_avmm1_writedata[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[71],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[70],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[69],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[68],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[67],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[66],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[65],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[64],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[8][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[8][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[8][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[8][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[8][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[8][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[8][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[8][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile3.sec_profile_3.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile2.sec_profile_2.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_sec_profile1.sec_profile_1.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.rx_inst.sdi_mr_rx_sys_inst.rx_phy.rx_phy.U_base_profile.directphy_f_0.dphy_hip_inst.pld_hssi_osc_transfer_en[0],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[8]}));

wire z1577b_x393_y0_n0__avmm1_9__pld_avmm1_busy_real;
wire z1577b_x393_y0_n0__avmm1_9__pld_avmm1_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm1_9__pld_avmm1_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm1_9__pld_avmm1_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm1_9__pld_avmm1_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_9__pld_avmm1_readdata_real;
wire z1577b_x393_y0_n0__avmm1_9__pld_avmm1_readdatavalid_real;
wire [9:0] z1577b_x393_y0_n0__avmm1_9__pld_avmm1_reg_addr_real;
wire z1577b_x393_y0_n0__avmm1_9__pld_avmm1_request_real;
wire [8:0] z1577b_x393_y0_n0__avmm1_9__pld_avmm1_reserved_in_real;
wire [2:0] z1577b_x393_y0_n0__avmm1_9__pld_avmm1_reserved_out_real;
wire z1577b_x393_y0_n0__avmm1_9__pld_avmm1_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm1_9__pld_avmm1_writedata_real;
wire z1577b_x393_y0_n0__avmm1_9__pld_chnl_cal_done_real;
wire z1577b_x393_y0_n0__avmm1_9__pld_hssi_osc_transfer_en_real;
intfc_m_hdpldadapt_avmm1_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(9),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(2)
) z1577b_x393_y0_n0__avmm1_9(
	.pld_avmm1_busy_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_busy_real),
	.pld_avmm1_clk_rowclk_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_clk_rowclk_real),
	.pld_avmm1_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_cmdfifo_wr_full_real),
	.pld_avmm1_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_cmdfifo_wr_pfull_real),
	.pld_avmm1_read_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_read_real),
	.pld_avmm1_readdata_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_readdata_real),
	.pld_avmm1_readdatavalid_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_readdatavalid_real),
	.pld_avmm1_reg_addr_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_reg_addr_real),
	.pld_avmm1_request_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_request_real),
	.pld_avmm1_reserved_in_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_reserved_in_real),
	.pld_avmm1_reserved_out_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_reserved_out_real),
	.pld_avmm1_write_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_write_real),
	.pld_avmm1_writedata_real(z1577b_x393_y0_n0__avmm1_9__pld_avmm1_writedata_real),
	.pld_chnl_cal_done_real(z1577b_x393_y0_n0__avmm1_9__pld_chnl_cal_done_real),
	.pld_hssi_osc_transfer_en_real(z1577b_x393_y0_n0__avmm1_9__pld_hssi_osc_transfer_en_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_chnl_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_chnl_cal_done_real[9]),
	.intfc_01_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__dr_inst__dr_f__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_01_pld_avmm1_busy_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_busy[9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_busy_real[9]}),
	.s_intfc_01_pld_avmm1_clk_rowclk_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_clk_rowclk[9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_clk_rowclk_real[9]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_full_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_full[9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_full_real[9]}),
	.s_intfc_01_pld_avmm1_cmdfifo_wr_pfull_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_cmdfifo_wr_pfull[9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_cmdfifo_wr_pfull_real[9]}),
	.s_intfc_01_pld_avmm1_read_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_read[9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_read_real[9]}),
	.s_intfc_01_pld_avmm1_readdata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[79],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[78],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[77],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[76],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[75],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[74],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[73],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdata[72],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[9][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[9][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[9][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[9][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[9][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[9][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[9][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdata_real[9][0]}),
	.s_intfc_01_pld_avmm1_readdatavalid_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_readdatavalid[9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_readdatavalid_real[9]}),
	.s_intfc_01_pld_avmm1_reg_addr_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[99],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[98],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[97],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[96],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[95],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[94],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[93],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[92],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[91],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reg_addr[90],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[9][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[9][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[9][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[9][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[9][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[9][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[9][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[9][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[9][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reg_addr_real[9][0]}),
	.s_intfc_01_pld_avmm1_request_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_request[9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_request_real[9]}),
	.s_intfc_01_pld_avmm1_reserved_in_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[89],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[88],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[87],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[86],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[85],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[84],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[83],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[82],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_in[81],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[9][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[9][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[9][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[9][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[9][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[9][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[9][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[9][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_in_real[9][0]}),
	.s_intfc_01_pld_avmm1_reserved_out_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[29],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[28],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_reserved_out[27],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[9][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[9][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_reserved_out_real[9][0]}),
	.s_intfc_01_pld_avmm1_write_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_write[9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_write_real[9]}),
	.s_intfc_01_pld_avmm1_writedata_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[79],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[78],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[77],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[76],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[75],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[74],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[73],
		`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_avmm1_writedata[72],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[9][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[9][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[9][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[9][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[9][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[9][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[9][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_avmm1_writedata_real[9][0]}),
	.s_intfc_01_pld_hssi_osc_transfer_en_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.dr_inst.dr_f.dr_ctrl_hip_inst.pld_hssi_osc_transfer_en[9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm1__pld_hssi_osc_transfer_en_real[9]}));

wire z1577b_x393_y0_n0__avmm2_0__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_0__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_0__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_0__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_0__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_0__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_0__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_0__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_0__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_0__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_0__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_0__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_0__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_0__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_0__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_0__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_0__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_0__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_0__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_0__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_0__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_0__pld_pll_cal_done_real;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__tx_inst__sdi_mr_tx_sys_inst__tx_phy__tx_phy__one_hot_selector;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(0),
	.num_ip_on_intfc_00(2),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_0(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_0__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_0__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_0__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_0__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_0__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_0__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_0__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_0__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_0__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_0__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real({sdi_ii_agi_demo__SDI_A7SK_inst0__tx_inst__sdi_mr_tx_sys_inst__tx_phy__tx_phy__one_hot_selector,z1577b_x393_y0_n0__reset_controller__one_hot_selector}),
	.s_intfc_00_pld_pll_cal_done_real({`QUARTUS_TLG__TOP_LEVEL_ENTITY_INSTANCE_PATH.SDI_A7SK_inst0.tx_inst.sdi_mr_tx_sys_inst.tx_phy.tx_phy.dphy_hip_inst.octl_pcs_txstatus_lx_a[0],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[0]}),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[0]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[0][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[0][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[0][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[0][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[0]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[0][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[0][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[0]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[0][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[0][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[0][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[0][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[0]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[0]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[0]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[0]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[0]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[0]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[0][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[0][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[0][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[0][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[0]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[0][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[0][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[0][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[0][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[0][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[0]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[0][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[0][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[0]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[0]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[0][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[0][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[0][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[0][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[0][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[0][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[0][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[0][0]}));

wire z1577b_x393_y0_n0__avmm2_1__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_1__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_1__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_1__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_1__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_1__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_1__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_1__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_1__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_1__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_1__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_1__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_1__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_1__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_1__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_1__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_1__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_1__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_1__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_1__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_1__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_1__pld_pll_cal_done_real;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(1),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_1(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_1__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_1__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_1__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_1__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_1__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_1__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_1__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_1__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_1__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_1__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_pll_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[1]),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[1]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[1][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[1][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[1][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[1][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[1]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[1][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[1][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[1]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[1][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[1][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[1][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[1][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[1]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[1]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[1]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[1]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[1]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[1]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[1][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[1][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[1][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[1][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[1]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[1][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[1][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[1][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[1][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[1][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[1]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[1][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[1][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[1]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[1]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[1][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[1][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[1][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[1][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[1][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[1][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[1][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[1][0]}));

wire z1577b_x393_y0_n0__avmm2_10__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_10__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_10__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_10__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_10__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_10__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_10__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_10__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_10__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_10__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_10__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_10__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_10__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_10__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_10__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_10__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_10__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_10__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_10__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_10__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_10__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_10__pld_pll_cal_done_real;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(10),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_10(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_10__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_10__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_10__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_10__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_10__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_10__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_10__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_10__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_10__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_10__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_pll_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[10]),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[10]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[10][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[10][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[10][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[10][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[10]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[10][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[10][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[10]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[10][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[10][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[10][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[10][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[10]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[10]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[10]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[10]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[10]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[10]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[10][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[10][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[10][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[10][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[10]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[10][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[10][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[10][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[10][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[10][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[10]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[10][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[10][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[10]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[10]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[10][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[10][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[10][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[10][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[10][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[10][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[10][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[10][0]}));

wire z1577b_x393_y0_n0__avmm2_11__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_11__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_11__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_11__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_11__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_11__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_11__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_11__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_11__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_11__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_11__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_11__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_11__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_11__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_11__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_11__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_11__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_11__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_11__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_11__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_11__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_11__pld_pll_cal_done_real;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(11),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_11(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_11__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_11__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_11__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_11__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_11__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_11__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_11__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_11__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_11__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_11__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_pll_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[11]),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[11]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[11][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[11][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[11][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[11][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[11]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[11][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[11][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[11]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[11][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[11][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[11][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[11][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[11]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[11]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[11]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[11]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[11]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[11]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[11][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[11][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[11][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[11][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[11]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[11][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[11][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[11][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[11][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[11][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[11]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[11][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[11][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[11]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[11]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[11][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[11][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[11][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[11][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[11][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[11][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[11][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[11][0]}));

wire z1577b_x393_y0_n0__avmm2_12__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_12__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_12__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_12__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_12__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_12__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_12__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_12__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_12__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_12__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_12__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_12__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_12__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_12__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_12__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_12__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_12__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_12__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_12__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_12__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_12__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_12__pld_pll_cal_done_real;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(12),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_12(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_12__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_12__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_12__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_12__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_12__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_12__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_12__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_12__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_12__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_12__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_pll_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[12]),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[12]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[12][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[12][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[12][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[12][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[12]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[12][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[12][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[12]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[12][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[12][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[12][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[12][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[12]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[12]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[12]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[12]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[12]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[12]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[12][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[12][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[12][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[12][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[12]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[12][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[12][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[12][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[12][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[12][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[12]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[12][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[12][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[12]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[12]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[12][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[12][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[12][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[12][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[12][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[12][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[12][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[12][0]}));

wire z1577b_x393_y0_n0__avmm2_13__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_13__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_13__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_13__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_13__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_13__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_13__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_13__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_13__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_13__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_13__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_13__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_13__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_13__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_13__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_13__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_13__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_13__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_13__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_13__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_13__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_13__pld_pll_cal_done_real;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(13),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_13(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_13__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_13__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_13__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_13__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_13__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_13__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_13__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_13__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_13__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_13__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_pll_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[13]),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[13]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[13][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[13][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[13][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[13][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[13]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[13][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[13][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[13]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[13][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[13][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[13][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[13][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[13]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[13]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[13]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[13]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[13]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[13]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[13][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[13][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[13][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[13][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[13]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[13][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[13][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[13][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[13][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[13][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[13]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[13][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[13][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[13]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[13]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[13][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[13][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[13][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[13][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[13][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[13][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[13][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[13][0]}));

wire z1577b_x393_y0_n0__avmm2_14__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_14__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_14__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_14__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_14__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_14__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_14__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_14__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_14__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_14__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_14__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_14__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_14__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_14__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_14__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_14__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_14__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_14__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_14__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_14__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_14__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_14__pld_pll_cal_done_real;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(14),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_14(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_14__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_14__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_14__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_14__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_14__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_14__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_14__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_14__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_14__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_14__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_pll_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[14]),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[14]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[14][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[14][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[14][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[14][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[14]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[14][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[14][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[14]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[14][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[14][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[14][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[14][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[14]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[14]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[14]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[14]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[14]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[14]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[14][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[14][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[14][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[14][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[14]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[14][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[14][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[14][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[14][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[14][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[14]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[14][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[14][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[14]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[14]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[14][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[14][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[14][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[14][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[14][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[14][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[14][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[14][0]}));

wire z1577b_x393_y0_n0__avmm2_15__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_15__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_15__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_15__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_15__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_15__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_15__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_15__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_15__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_15__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_15__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_15__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_15__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_15__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_15__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_15__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_15__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_15__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_15__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_15__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_15__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_15__pld_pll_cal_done_real;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(15),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_15(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_15__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_15__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_15__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_15__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_15__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_15__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_15__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_15__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_15__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_15__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_pll_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[15]),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[15]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[15][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[15][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[15][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[15][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[15]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[15][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[15][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[15]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[15][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[15][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[15][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[15][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[15]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[15]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[15]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[15]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[15]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[15]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[15][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[15][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[15][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[15][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[15]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[15][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[15][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[15][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[15][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[15][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[15]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[15][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[15][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[15]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[15]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[15][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[15][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[15][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[15][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[15][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[15][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[15][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[15][0]}));

wire z1577b_x393_y0_n0__avmm2_16__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_16__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_16__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_16__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_16__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_16__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_16__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_16__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_16__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_16__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_16__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_16__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_16__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_16__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_16__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_16__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_16__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_16__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_16__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_16__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_16__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_16__pld_pll_cal_done_real;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(16),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_16(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_16__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_16__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_16__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_16__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_16__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_16__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_16__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_16__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_16__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_16__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_pll_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[16]),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[16]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[16][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[16][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[16][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[16][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[16]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[16][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[16][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[16]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[16][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[16][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[16][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[16][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[16]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[16]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[16]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[16]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[16]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[16]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[16][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[16][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[16][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[16][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[16]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[16][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[16][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[16][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[16][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[16][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[16]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[16][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[16][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[16]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[16]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[16][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[16][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[16][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[16][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[16][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[16][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[16][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[16][0]}));

wire z1577b_x393_y0_n0__avmm2_17__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_17__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_17__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_17__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_17__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_17__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_17__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_17__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_17__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_17__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_17__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_17__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_17__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_17__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_17__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_17__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_17__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_17__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_17__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_17__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_17__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_17__pld_pll_cal_done_real;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(17),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_17(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_17__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_17__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_17__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_17__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_17__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_17__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_17__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_17__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_17__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_17__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_pll_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[17]),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[17]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[17][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[17][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[17][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[17][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[17]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[17][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[17][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[17]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[17][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[17][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[17][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[17][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[17]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[17]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[17]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[17]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[17]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[17]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[17][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[17][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[17][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[17][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[17]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[17][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[17][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[17][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[17][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[17][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[17]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[17][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[17][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[17]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[17]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[17][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[17][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[17][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[17][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[17][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[17][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[17][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[17][0]}));

wire z1577b_x393_y0_n0__avmm2_18__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_18__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_18__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_18__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_18__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_18__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_18__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_18__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_18__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_18__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_18__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_18__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_18__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_18__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_18__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_18__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_18__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_18__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_18__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_18__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_18__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_18__pld_pll_cal_done_real;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(18),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_18(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_18__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_18__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_18__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_18__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_18__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_18__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_18__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_18__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_18__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_18__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_pll_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[18]),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[18]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[18][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[18][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[18][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[18][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[18]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[18][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[18][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[18]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[18][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[18][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[18][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[18][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[18]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[18]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[18]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[18]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[18]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[18]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[18][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[18][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[18][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[18][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[18]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[18][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[18][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[18][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[18][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[18][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[18]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[18][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[18][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[18]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[18]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[18][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[18][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[18][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[18][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[18][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[18][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[18][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[18][0]}));

wire z1577b_x393_y0_n0__avmm2_19__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_19__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_19__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_19__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_19__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_19__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_19__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_19__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_19__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_19__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_19__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_19__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_19__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_19__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_19__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_19__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_19__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_19__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_19__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_19__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_19__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_19__pld_pll_cal_done_real;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(19),
	.num_ip_on_intfc_00(1),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_19(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_19__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_19__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_19__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_19__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_19__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_19__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_19__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_19__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_19__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_19__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_00_pld_pll_cal_done_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_pll_cal_done_real[19]),
	.intfc_01_one_hot_selector_real(z1577b_x393_y0_n0__reset_controller__one_hot_selector),
	.s_intfc_01_hip_avmm_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_read_real[19]),
	.s_intfc_01_hip_avmm_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[19][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[19][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[19][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdata_real[19][0]}),
	.s_intfc_01_hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_readdatavalid_real[19]),
	.s_intfc_01_hip_avmm_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][20],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][19],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][18],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][17],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][16],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][15],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][14],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][13],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][12],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][11],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][10],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][9],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reg_addr_real[19][0]}),
	.s_intfc_01_hip_avmm_reserved_out_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_reserved_out_real[19][0]}),
	.s_intfc_01_hip_avmm_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_write_real[19]),
	.s_intfc_01_hip_avmm_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[19][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[19][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[19][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedata_real[19][0]}),
	.s_intfc_01_hip_avmm_writedone_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__hip_avmm_writedone_real[19]),
	.s_intfc_01_pld_avmm2_busy_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_busy_real[19]),
	.s_intfc_01_pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_clk_rowclk_real[19]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_full_real[19]),
	.s_intfc_01_pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_cmdfifo_wr_pfull_real[19]),
	.s_intfc_01_pld_avmm2_read_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_read_real[19]),
	.s_intfc_01_pld_avmm2_readdata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[19][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[19][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[19][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdata_real[19][0]}),
	.s_intfc_01_pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_readdatavalid_real[19]),
	.s_intfc_01_pld_avmm2_reg_addr_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[19][8],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[19][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[19][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[19][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reg_addr_real[19][0]}),
	.s_intfc_01_pld_avmm2_request_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_request_real[19]),
	.s_intfc_01_pld_avmm2_reserved_in_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[19][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_in_real[19][0]}),
	.s_intfc_01_pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_reserved_out_real[19]),
	.s_intfc_01_pld_avmm2_write_real(z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_write_real[19]),
	.s_intfc_01_pld_avmm2_writedata_real({z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[19][7],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[19][6],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[19][5],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[19][4],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[19][3],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[19][2],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[19][1],
		z1577b_x393_y0_n0__reset_controller.x_f_tile_soft_reset_ctlr_hip_v1.x_bb_m_hdpldadapt_avmm2__pld_avmm2_writedata_real[19][0]}));

wire z1577b_x393_y0_n0__avmm2_2__hip_avmm_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_2__hip_avmm_readdata_real;
wire z1577b_x393_y0_n0__avmm2_2__hip_avmm_readdatavalid_real;
wire [20:0] z1577b_x393_y0_n0__avmm2_2__hip_avmm_reg_addr_real;
wire [4:0] z1577b_x393_y0_n0__avmm2_2__hip_avmm_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_2__hip_avmm_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_2__hip_avmm_writedata_real;
wire z1577b_x393_y0_n0__avmm2_2__hip_avmm_writedone_real;
wire z1577b_x393_y0_n0__avmm2_2__pld_avmm2_busy_real;
wire z1577b_x393_y0_n0__avmm2_2__pld_avmm2_clk_rowclk_real;
wire z1577b_x393_y0_n0__avmm2_2__pld_avmm2_cmdfifo_wr_full_real;
wire z1577b_x393_y0_n0__avmm2_2__pld_avmm2_cmdfifo_wr_pfull_real;
wire z1577b_x393_y0_n0__avmm2_2__pld_avmm2_read_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_2__pld_avmm2_readdata_real;
wire z1577b_x393_y0_n0__avmm2_2__pld_avmm2_readdatavalid_real;
wire [8:0] z1577b_x393_y0_n0__avmm2_2__pld_avmm2_reg_addr_real;
wire z1577b_x393_y0_n0__avmm2_2__pld_avmm2_request_real;
wire [5:0] z1577b_x393_y0_n0__avmm2_2__pld_avmm2_reserved_in_real;
wire z1577b_x393_y0_n0__avmm2_2__pld_avmm2_reserved_out_real;
wire z1577b_x393_y0_n0__avmm2_2__pld_avmm2_write_real;
wire [7:0] z1577b_x393_y0_n0__avmm2_2__pld_avmm2_writedata_real;
wire z1577b_x393_y0_n0__avmm2_2__pld_pll_cal_done_real;
wire sdi_ii_agi_demo__SDI_A7SK_inst0__tx_inst1__sdi_mr_tx_sys_inst__tx_phy__tx_phy__one_hot_selector;
intfc_m_hdpldadapt_avmm2_mux #(
	.topology("UX16E400GPTP_XX_DISABLED_XX_DISABLED"),
	.maib_id(2),
	.num_ip_on_intfc_00(2),
	.num_ip_on_intfc_01(1)
) z1577b_x393_y0_n0__avmm2_2(
	.hip_avmm_read_real(z1577b_x393_y0_n0__avmm2_2__hip_avmm_read_real),
	.hip_avmm_readdata_real(z1577b_x393_y0_n0__avmm2_2__hip_avmm_readdata_real),
	.hip_avmm_readdatavalid_real(z1577b_x393_y0_n0__avmm2_2__hip_avmm_readdatavalid_real),
	.hip_avmm_reg_addr_real(z1577b_x393_y0_n0__avmm2_2__hip_avmm_reg_addr_real),
	.hip_avmm_reserved_out_real(z1577b_x393_y0_n0__avmm2_2__hip_avmm_reserved_out_real),
	.hip_avmm_write_real(z1577b_x393_y0_n0__avmm2_2__hip_avmm_write_real),
	.hip_avmm_writedata_real(z1577b_x393_y0_n0__avmm2_2__hip_avmm_writedata_real),
	.hip_avmm_writedone_real(z1577b_x393_y0_n0__avmm2_2__hip_avmm_writedone_real),
	.pld_avmm2_busy_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_busy_real),
	.pld_avmm2_clk_rowclk_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_clk_rowclk_real),
	.pld_avmm2_cmdfifo_wr_full_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_cmdfifo_wr_full_real),
	.pld_avmm2_cmdfifo_wr_pfull_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_cmdfifo_wr_pfull_real),
	.pld_avmm2_read_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_read_real),
	.pld_avmm2_readdata_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_readdata_real),
	.pld_avmm2_readdatavalid_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_readdatavalid_real),
	.pld_avmm2_reg_addr_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_reg_addr_real),
	.pld_avmm2_request_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_request_real),
	.pld_avmm2_reserved_in_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_reserved_in_real),
	.pld_avmm2_reserved_out_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_reserved_out_real),
	.pld_avmm2_write_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_write_real),
	.pld_avmm2_writedata_real(z1577b_x393_y0_n0__avmm2_2__pld_avmm2_writedata_real),
	.pld_pll_cal_done_real(z1577b_x393_y0_n0__avmm2_2__pld_pll_cal_done_real),
	.intfc_00_one_hot_selector_real({s