module SPI_12G_2CH (
   input           CLK,
   output          SPI_CS_n , 
   output          SPI_SDI,
   output          SPI_SCLK,
   input           SPI_SDO,	
   input           RESET_N,
	input           MUTE, // 0: MUTE  ,1: NO MUTE   
   input   [1:0]   FMC_SDI_12G_RC_LOS,
	input   [1:0]   FMC_SDI_12G_RX_LOS,
   input   [1:0]   FMC_SDI_12G_RC_ALARM_n,
   input   [1:0]   FMC_SDI_12G_RX_SD_xHD,
   input   [1:0]   FMC_SDI_12G_RX_ALARM_n,
	
   output wire          SPI_SYS_CLK ,
   output reg 	[7:0]   TIME
	

)  ;
//=======================================================
//  REG/WIRE declarations
//=======================================================
//wire          SPI_SYS_CLK ;
//reg 	[7:0]   TIME;
wire [15:0 ]  R_D11;
wire [15:0 ]  R_D10;
wire [15:0 ]  R_D10_;
wire [15:0 ]  R_D09;
wire          REG_CK;
wire   [4:0]  REG_ADDRESS;

//=======================================================
//  Structural coding
//=======================================================

//---time scale 
always @(posedge CLK ) 	TIME<=TIME+1;

//----SPI SYSTEM-CLOCK
assign      SPI_SYS_CLK =TIME[4]; 
	
//---RAM TABLE 	

RRAM_D9 rd9(// Re Clock      M23145_Cable Reclocker.pdf 18
	//.data   (     0        ),
	.address( REG_ADDRESS ),
	//.wren   ( 0         ),
	.clock  ( REG_CK      ) ,
	.q      ( R_D09       ) 
	);
	
RRAM_D10 rd10(// Cable Driver  M23428_Cable Driver.pdf   7  
	//.data   (     0        ),
	.address( REG_ADDRESS ),
	//.wren   ( 0          ),
	.clock  ( REG_CK      ) ,
	.q      ( R_D10_      )   // test  cabler mute 
	);

	
RRAM_D11 rd11(// Equal  M23544_Equalizer.pdf       18 
	//.data   (    0        ),
	.address( REG_ADDRESS ),
	//.wren   ( 0         ),
	.clock  ( REG_CK      ) ,
	.q      ( R_D11       ) 
	);

	
assign R_D10[7:0 ] =  ( R_D10_[15:8]==8'h20 )? { R_D10_[7:1]  , ~MUTE } : R_D10_[7:0] ; 
assign R_D10[15:8] =  R_D10_[15:8]  ; 
	
//---
	
 SPI_CTRL_J 	spi (	// dainsy chain 
	.oDIN    ( SPI_SDI  ),
	.oCS_n   ( SPI_CS_n ), 
	.oSCLK   ( SPI_SCLK ),
	.iDOUT   ( SPI_SDO  ), 
	.iCLK    ( SPI_SYS_CLK ),
	.RESET_N ( RESET_N )  ,   
	.iR_D05  ( R_D11 ), 
	.iR_D04  ( R_D10 ), 
	.iR_D03  ( R_D09 ), 
	.iR_D02  ( R_D11 ), 
	.iR_D01  ( R_D10 ), 
	.iR_D00  ( R_D09 ),	
	.oSPI_D  (),
   .REG_CK  (REG_CK     ),
   .REG_ADDRESS (REG_ADDRESS)
				);
				
						
				
				
endmodule 				
				