module SPI_3G_2CH (
 input        RESET_N,
 input        CLK,
 output [1:0] SPI_SS_n,	 
 output       SPI_SCLK,	 
 output       SPI_MOSI,	 
 input        SPI_MISO,	 
 input [1:0]  CH_POWERDN , 
 
 input  [1:0] CD_n    
);


parameter Auto_sleep   = 2'b01 ;  //bit 4:3
parameter Force_sleep  = 2'b10 ; 
	
//=======================================================
//  REG/WIRE declarations
//=======================================================
wire          SPI_SYS_CLK ;
reg 	[7:0]   TIME;
wire          REG_CK;
wire   [4:0]  REG_ADDRESS;

//=======================================================
//  Structural coding
//=======================================================

//---time scale 
always @(posedge CLK ) 	TIME<=TIME+1;

//----SPI SYSTEM-CLOCK
assign      SPI_SYS_CLK =TIME[4]; 
		

wire [7:0] CH0_POWER;
wire [7:0] CH1_POWER;

wire [1:0] POWER_BIT0 ; 
wire [1:0] POWER_BIT1 ; 

assign  POWER_BIT0= CH_POWERDN[0]?  Force_sleep : Auto_sleep  ;   // 1:force spleep 
assign  POWER_BIT1= CH_POWERDN[1]?  Force_sleep : Auto_sleep  ;   // 1:force spleep ; 



assign  CH0_POWER={8'h00,3'h0,POWER_BIT0,3'h0 }  ;
assign  CH1_POWER={8'h00,3'h0,POWER_BIT1,3'h0 }  ;
		
		
//---
 SPI_3G_CTRL 	spi (	// 2CH 3G SPI 
	.RESET_N ( RESET_N       )  ,    
 	.iCLK    ( SPI_SYS_CLK   ),
 	.oCS_n   ( SPI_SS_n[1:0] ), 
	.oSCLK   ( SPI_SCLK      ),
	.oDIN    ( SPI_MOSI  ),
	.iDOUT   ( SPI_MISO  ),
	.iR_D00  ( CH0_POWER) , 
	.iR_D01  ( CH1_POWER)
);
					
				
endmodule 				
				