module SPI_3G_CTRL 	(	
input              RESET_N , 
input				    iCLK,
input	       [15:0]iCREG,
output	reg [15:0]oSPI_D, 
output	reg	    oDIN,
output	reg [1:0] oCS_n,
output	reg	    oSCLK,
input				    iDOUT,
input    [15:0]    iR_D00  ,     
input    [15:0]    iR_D01  ,     

//--test 
output reg [7:0]  ST,
output reg [15:0] COUNTER , 
output reg [15:0] DEV_NUN,
output reg        READ_VAILD


				);
					
parameter  DEIVE          = 2 ;
				 
reg [15:0] CREG ;
reg [15:0] SPI_DATA;
reg [31:0] DELAY ;  



always@( negedge RESET_N or posedge iCLK )
   if ( !RESET_N) begin 
	   ST         <=0; 
		DEV_NUN    <=DEIVE ; //2
		oCS_n      <=3; 
		oSCLK      <=0;
		oDIN       <=0;  
		READ_VAILD <=0; 
		
	end 
else 
begin
case (ST)
0:begin 
      ST     <=1;
		oSCLK  <=0;
		COUNTER<=16;
		
		     if  (DEV_NUN ==2)  CREG   <=  { READ_VAILD,iR_D01[14:0]} ;
		else if  (DEV_NUN ==1)  CREG   <=  { READ_VAILD,iR_D00[14:0]} ;

		{ oSPI_D[15:0] , SPI_DATA[15:0] } <= { SPI_DATA[15:0] ,16'h0};
  end 
1:begin 
              if ( DEV_NUN==1)  oCS_n   <=  2'b10 ; 
			else if ( DEV_NUN==2)  oCS_n   <=  2'b01 ; 
       ST<=2;
  end 
2:begin 
      {oDIN,CREG[15:0]} <= {CREG[15:0], 1'b0} ;
       ST<=3;
  end 
3:begin 
      oSCLK  <=1;
      COUNTER<=COUNTER-1;
      ST<=4;
  end 
4:begin 
        oSCLK  <=0;
        if    ( COUNTER!=0)  ST<=10 ; 
        else  begin 
		    ST<=5; 
		  end 
  end 
5:begin 
		  DEV_NUN  <=DEV_NUN  -1 ; 		    
        ST<=6 ;		  
end
6: begin
          DELAY <=0;       
			 if ( DEV_NUN==0 )  begin 
			     oCS_n      <= 2'b11 ;  
				  DEV_NUN    <=DEIVE ; //2  
				  if  ( READ_VAILD ==0 ) begin 
				       READ_VAILD  <= 1 ;
				  end 
				  else  begin 
				       READ_VAILD  <= 0 ;
				  end   
			end
		   else 	begin oCS_n <= oCS_n ; 
			     ST<=7;
			end 
end
7: begin
         if  ( DELAY ==5 )   begin 
			     ST<=0;  
			 end 
			else  DELAY <= DELAY  +1; 

   end 
//---read shifter 

10: begin 
	  SPI_DATA[15:0]   <= {SPI_DATA[14:0], iDOUT} ; 
	  ST<=2;  
end 	   
	
endcase
end

endmodule
