module SPI_CTRL_J 	(	
input              RESET_N , 
input				    iCLK,
input	       [15:0]iCREG,

input	       [15:0]iR_D05,
input	       [15:0]iR_D04,
input	       [15:0]iR_D03,
input	       [15:0]iR_D02,
input	       [15:0]iR_D01,
input	       [15:0]iR_D00,
output	reg [15:0]oSPI_D, 

output	reg	   oDIN,
output	reg 	   oCS_n,
output	reg	   oSCLK,
input				   iDOUT,
output	reg	   REG_CK,
output	reg	   [4:0] REG_ADDRESS ,


//--test 
output     [31:0]  EYE,
output reg [7:0]  ST,
output reg [15:0] COUNTER , 
output reg [15:0] DEV_NUN,
output reg        READ_VAILD,
output reg        DEV_CK , 
output  [15:0]    EQ_DAT ,
output  TR  

				);
					
parameter  DEIVE          = 6;//12 ; 
parameter  RAM_MAXADDRESS = 31 ; 
				 
reg [15:0] CREG ;
reg [15:0] SPI_DATA;
reg [31:0] DELAY ;  

	
assign  EYE = ( oSPI_D[15:8]==8'h0B ) ?    (oSPI_D[7:0] * 10000) /48 :0;  // 1000/48 	  
assign  TR =  ((oSPI_D[15:8]==8'h0B)  &&   (oSPI_D[7:0]!= 0 )) ? 1:0; 

always@( negedge RESET_N or posedge iCLK )
   if ( !RESET_N) begin 
	   ST <=0; 
		DEV_NUN <=DEIVE ; //12
		oCS_n   <=1; 
		oSCLK   <=0;
		oDIN    <=0;  
		READ_VAILD <=0; 
		REG_CK  <= 0 ;
		REG_ADDRESS  <= 0;
		
	end 
else 
begin
case (ST)
0:begin 
      DEV_CK  <=  1 ; 
      ST     <=1;
		oSCLK  <=0;
		COUNTER<=16;
		
		     if  (DEV_NUN ==6)  CREG   <=  { READ_VAILD,iR_D05[14:0]} ;//rx1 eq
		else if  (DEV_NUN ==5)  CREG   <=  { READ_VAILD,iR_D04[14:0]} ;//tx1 cd
		else if  (DEV_NUN ==4)  CREG   <=  { READ_VAILD,iR_D03[14:0]} ;//tx1 rk
		else if  (DEV_NUN ==3)  CREG   <=  { READ_VAILD,iR_D02[14:0]} ;//rx0 eq
		else if  (DEV_NUN ==2)  CREG   <=  { READ_VAILD,iR_D01[14:0]} ;//tx0 cd
		else if  (DEV_NUN ==1)  CREG   <=  { READ_VAILD,iR_D00[14:0]} ;//tx0 rk

		{ oSPI_D[15:0] , SPI_DATA[15:0] } <= { SPI_DATA[15:0] ,16'h0};
  end 
1:begin 
       DEV_CK  <=  0 ; 
       oCS_n  <= 0; 
       ST<=2;
  end 
2:begin 
      {oDIN,CREG[15:0]} <= {CREG[15:0], 1'b0} ;
       ST<=3;
  end 
3:begin 
      oSCLK  <=1;
      COUNTER<=COUNTER-1;
      ST<=4;
  end 
4:begin 
        oSCLK  <=0;
        if    ( COUNTER!=0)  ST<=10 ; 
        else  begin 
		    ST<=5; 
		  end 
  end 
5:begin 
		  DEV_NUN  <=DEV_NUN  -1 ; 		    
        ST<=6 ;		  
end
6: begin
          DELAY <=0;       
			 if ( DEV_NUN==0 )  begin 
			     oCS_n  <= 1;    
				  if  ( READ_VAILD ==0 ) begin 
				       READ_VAILD   <= 1 ;
						 if ( REG_ADDRESS == RAM_MAXADDRESS)  REG_ADDRESS  <= 0;
					    else REG_ADDRESS  <= REG_ADDRESS +1 ;  
				  end 
				  else  begin 
				       READ_VAILD <= 0 ;
						 REG_CK  <= 1 ; 
				  end   
				  DEV_NUN    <=   DEIVE  ; 				
			end
		   else 	begin oCS_n <= oCS_n ; 
			ST<=7;
			end 
end
7: begin
         REG_CK  <= 0 ;   
         if  ( DELAY ==20 )   begin 
			     ST<=0;  
			 end 
			else  DELAY <= DELAY  +1; 

   end 
//---read shifter 

10: begin 
	  SPI_DATA[15:0]   <= {SPI_DATA[14:0], iDOUT} ; 
	  ST<=2;  
end 	   
	
endcase
end

endmodule
