// (C) 2001-2022 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module  device_init #(
    parameter   CNTR_BITS = 16
)(
    input   clk,
    output  init_done
);

wire    ninit_done;

// ----------------------------------------------------------------------------------
// Reset Release IP for S10
// - This IP outputs nINIT_DONE after finishing device initalization.
// - User mode initialization can begin as soon as the nINIT_DONE signal de-asserts.
// ----------------------------------------------------------------------------------
reset_release s10_rst_release_inst (
    .ninit_done (ninit_done)
);

// ----------------------------------------------------------------------------------
// Delay the ready signal after a programmable delay
// ----------------------------------------------------------------------------------
alt_reset_delay #(
    .CNTR_BITS  (CNTR_BITS)
) rst_delay_inst (
    .clk        (clk),
    .ready_in   (~ninit_done),
    .ready_out  (init_done)
);

endmodule
