// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



//----------------------------------------------------------------------------- 
//  Project Name:  GDR Dynamic Reconfiguration (F-tile)                                  
//  Module Name :  dr_f_avmm_decoder                                  
//  Author ID   :  hafeezmu                                   
//  Date        :  Fri Feb 21 09:18:46 2020   
//  Version     :  v1.0 (Initial Draft)                               
//  Description :  GDR DR AVMM interconnect is to split single AVMM to multiple    
//                 AVMM slave interfaces. This component is part of DR SIP.This  
//                 commponent use to access local AVMM1 24CH (TDO),Global AVMM,
//                 SRC memory reconfig space and DR CSR address space                                             
//-----------------------------------------------------------------------------  
// synthesis translate_off
`timescale 1 ps / 1 fs
// synthesis translate_on
module dr_f_avmm_decoder #(
    parameter SLAVE_NUM     = 4,
    parameter DWIDTH        = 32,
    parameter AWIDTH        = 26
) 
(
   input   logic                   csr_clk,
   input   logic                   rst_n,
   input   logic   [31:0]          avmm_timeout,
   
   input   logic   [DWIDTH-1:0]    i_avmm_mst_writedata,
   input   logic                   i_avmm_mst_read,
   input   logic   [AWIDTH-1:0]    i_avmm_mst_address,
   input   logic                   i_avmm_mst_write,
   output  logic   [DWIDTH-1:0]    o_avmm_mst_readdata,
   output  logic                   o_avmm_mst_waitrequest,
   output  logic                   o_avmm_mst_readdata_valid,
          
   // GLOBAL_AVMM_SVIF Slave Interface AVMM Ports
   output  logic  [24:0]           o_dr_global_avmm_ictrl_addr,
   output  logic                   o_dr_global_avmm_ictrl_write,
   output  logic                   o_dr_global_avmm_ictrl_read,
   output  logic  [31:0]           o_dr_global_avmm_ictrl_wdata,
   output  logic  [3:0]            o_dr_global_avmm_ictrl_byte_en,
   input   logic  [31:0]           i_dr_global_avmm_ictrl_rdata,
   input   logic                   i_dr_global_avmm_ictrl_rdatavld,
   input   logic                   i_dr_global_avmm_ictrl_waitreq,

   // MAIB_AVMM1_SVIF Slave Interface AVMM Ports
   output  logic  [22:0]           o_maib_avmm32b_addr,
   output  logic                   o_maib_avmm32b_write,
   output  logic                   o_maib_avmm32b_read,
   output  logic  [31:0]           o_maib_avmm32b_wdata,
   output  logic  [3:0]            o_maib_avmm32b_byte_en,
   input   logic  [31:0]           i_maib_avmm32b_rdata,
   input   logic                   i_maib_avmm32b_rdatavld,
   input   logic                   i_maib_avmm32b_waitreq,
       
   // DR CSR Slave Interface AVMM Ports
   output  logic  [AWIDTH-1:0]     o_dr_csr_avmm_addr,
   output  logic                   o_dr_csr_avmm_write,
   output  logic                   o_dr_csr_avmm_read,
   output  logic  [31:0]           o_dr_csr_avmm_wdata,
   output  logic  [3:0]            o_dr_csr_avmm_byte_en,
   input   logic  [31:0]           i_dr_csr_avmm_rdata,
   input   logic                   i_dr_csr_avmm_rdatavld,
   input   logic                   i_dr_csr_avmm_waitrequest,
   
   // SRC Slave Interface AVMM Ports
   output  logic  [31:0]           o_dr_src_avmm_writedata,
   output  logic                   o_dr_src_avmm_read,
   output  logic  [15:0]           o_dr_src_avmm_address,
   output  logic                   o_dr_src_avmm_write,
   input   logic  [31:0]           i_dr_src_avmm_readdata,
   input   logic                   i_dr_src_avmm_waitrequest,
   input   logic                   i_dr_src_avmm_readdata_valid
 );
 
//-----------------------------------------------------------------------------
//Declarations
//-----------------------------------------------------------------------------
   
   logic  [SLAVE_NUM-1:0]      slave_sel;
   logic  [31:0]               avmm_slv_address;
   logic  [SLAVE_NUM-1:0]      avmm_slv_read;
   logic  [SLAVE_NUM-1:0]      avmm_slv_write;
   logic  [31:0]               avmm_slv_writedata;
   logic  [(SLAVE_NUM*32)-1:0] avmm_slv_readdata;
   logic  [SLAVE_NUM-1:0]      avmm_slv_waitrequest;
   logic  [SLAVE_NUM-1:0]      avmm_slv_readdata_valid;

   //////////////////////////////////////   DECODING   ////////////////////////////////////////////
   //DR CSR SLAVE
   assign o_dr_csr_avmm_addr               = avmm_slv_address[25:0];
   assign o_dr_csr_avmm_write              = avmm_slv_write[0]; 
   assign o_dr_csr_avmm_read               = avmm_slv_read[0];
   assign o_dr_csr_avmm_wdata              = avmm_slv_writedata;
   assign o_dr_csr_avmm_byte_en            = 4'hf;
   assign avmm_slv_readdata[31:0]          = i_dr_csr_avmm_rdata;
   assign avmm_slv_readdata_valid[0]       = i_dr_csr_avmm_rdatavld;
   assign avmm_slv_waitrequest[0]          = i_dr_csr_avmm_waitrequest;

   //GLOBAL AVMM SLAVE
   assign o_dr_global_avmm_ictrl_addr      = avmm_slv_address[24:0];
   assign o_dr_global_avmm_ictrl_write     = avmm_slv_write[1]; 
   assign o_dr_global_avmm_ictrl_read      = avmm_slv_read[1];
   assign o_dr_global_avmm_ictrl_wdata     = avmm_slv_writedata;
   assign o_dr_global_avmm_ictrl_byte_en   = 4'hf;
   assign avmm_slv_readdata[63:32]         = i_dr_global_avmm_ictrl_rdata;
   assign avmm_slv_readdata_valid[1]       = i_dr_global_avmm_ictrl_rdatavld;
   assign avmm_slv_waitrequest[1]          = i_dr_global_avmm_ictrl_waitreq;
  
   //SRC AVMM SLAVE
   assign o_dr_src_avmm_address            = avmm_slv_address[17:2];
   assign o_dr_src_avmm_write              = avmm_slv_write[2]; 
   assign o_dr_src_avmm_read               = avmm_slv_read[2];
   assign o_dr_src_avmm_writedata          = avmm_slv_writedata;
   assign avmm_slv_readdata[95:64]         = i_dr_src_avmm_readdata;
   assign avmm_slv_readdata_valid[2]       = i_dr_src_avmm_readdata_valid;
   assign avmm_slv_waitrequest[2]          = i_dr_src_avmm_waitrequest;
  
   // MAIB_AVMM1_SVIF Slave
   assign o_maib_avmm32b_addr              = avmm_slv_address[22:0];
   assign o_maib_avmm32b_write             = avmm_slv_write[3];
   assign o_maib_avmm32b_read              = avmm_slv_read[3];
   assign o_maib_avmm32b_wdata             = avmm_slv_writedata;
   assign o_maib_avmm32b_byte_en           = 4'hf;
   assign avmm_slv_readdata[127:96]        = i_maib_avmm32b_rdata;
   assign avmm_slv_readdata_valid[3]       = i_maib_avmm32b_rdatavld;
   assign avmm_slv_waitrequest[3]          = i_maib_avmm32b_waitreq; 
   
//-----------------------------------------------------------------------------
// Instantiation of blocks
//-----------------------------------------------------------------------------  
    
   //decoder instance
   dr_f_avmm_interconnect #(
        .NUM_SLAVE(SLAVE_NUM)
     ) dr_f_avmm_interconnect_inst (
        .clk                       (csr_clk),
        .rst_n                     (rst_n),
        .avmm_timeout              (avmm_timeout),
        //master ports
        .avmm_mst_address          ({6'h0,i_avmm_mst_address}),
        .avmm_mst_read             (i_avmm_mst_read),
        .avmm_mst_write            (i_avmm_mst_write),
        .avmm_mst_writedata        (i_avmm_mst_writedata),
        .avmm_mst_readdata         (o_avmm_mst_readdata),
        .avmm_mst_readdata_valid   (o_avmm_mst_readdata_valid),
        .avmm_mst_waitrequest      (o_avmm_mst_waitrequest),	
        //slave ports
        .avmm_slv_address          (avmm_slv_address),
        .avmm_slv_read             (avmm_slv_read),
        .avmm_slv_write            (avmm_slv_write),
        .avmm_slv_writedata        (avmm_slv_writedata),
        .avmm_slv_readdata         (avmm_slv_readdata),
        .avmm_slv_readdata_valid   (avmm_slv_readdata_valid),
        .avmm_slv_waitrequest      (avmm_slv_waitrequest),
        .slave_sel                 (slave_sel)
     );

endmodule //DR_F_AVMM_DECODER

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "79ztKTnV2ny/eHpgZYepe9G9wwwdeg9hTOdIyLdh4JTuZZ1DT50cJOPNpZ0w+c5aVHkra3Tx9+PMlDB4omAPannbtZoJG9ZekMCcgtPHzQ4GWiJfmhYoHZqap4yb9/uKlHSl9TpAcV1FKEwkrctIKziGBKSQ0S70p/jW9wD4CtM3X7P+ggV0x7Prg108lDSsdB1kGvgcQN/5kLCIPO6i12claBXdWuhbdU7Bm3JHKTrj675qwlUkjOCH65R3x8v/YlT/3x4LFbmNfoekyU3pOet7W8p1Fgls55TkeSh7yjOVXg+7pYh69U1uwIPq1NbiLa9p9nMKJdHnXlHBaX9yMSZlPGFA/I4BU50dF33WAJey4RN22NU97+veJd29LHt1JI9CwaclfDM0HDOnRqIJKhLLtKWavrpSQFUkT/mA7Goyp6H/vdJoFdwupsNpw481WasbFcWVR1uyEc05TF3H+7flAUYPa8vh1LePDmW568JM1jMlDx8ljq09+kZR9hid6xkEwa9d/bElqpgwVYUAciBzqYCD6q6Z5SDyRRYJ4RtShnMpqqOwOJKazSfcSZBIQhyArc2dRNnYnAzdqXuAS3I6XkXdsG4NIhyN2Oukx/YmYOQzzNhtFEpmU9k9XrQ94yvntHnU6yVigifhbzaqaoNV9YzHG3dIrC4voIekGI8/VeXdJ1lqMgFrsYeY4z+7cgbHJ16c3K4ZvlJrMdmAei90h4jZ8n46BCury3tz1LwsxBqPBFbARTB7V+Jg66eLFNf7WCR6K6zHxnoHkEuWmNe3jEe/SJI61RgPLvtPq1FSs4W8uAZnnWnqf/wRyimKYFcJpBDnwRdD9kUqKXxzhlcksL2qUNdvq5C9nRi0OiWbhsVuPlds35G59Vfd3ZnkN8wdiaR8cLAonfqxjqzdzZPvbsKw9mZSyjhy44WOm9vJsotct3/2VzR2v3L3GJ0NiSNFCaIo/8BmTKMQeAznEWheLS3syeWbx9CsXVmQu6Bnfl8rE+qARrp0AhFG43cQ"
`endif