// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



//----------------------------------------------------------------------------- 
//  Project Name:  GDR Dynamic Reconfiguration (F-tile)                                  
//  Module Name :  dr_f_csr                                  
//  Author ID   :  hafeezmu                                   
//  Date        :  Fri Feb 07 10:25:35 2020   
//  Version     :  v1.0 (Initial Draft)                               
//  Description :  GDR DR CSR for F-tile. This component is use to control DR 
//                 SIP profiles configuration and status through AVMM.
//                 Control access is through Host and Status update is through
//                 GDR DR Controller (NIOS)                                             
//-----------------------------------------------------------------------------  
// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

module dr_f_csr #(
    parameter DEFAULT_PROFILE_ID    = 32'h0
) (
    
    input   logic                   csr_clk,
    input   logic                   rst_n,

    //AVMM Bus Reconfig Interface
    input   logic [31:0]            writedata,
    input   logic                   read,
    input   logic                   write,
    input   logic [3:0]             byteenable,
    output  logic [31:0]            readdata,
    output  logic                   readdatavalid,
    output  logic                   waitrequest,
    input   logic [25:0]            address,

    //User Interface control/status
    output  logic [14:0]            o_dr_curr_profile_id,
    output  logic                   o_dr_new_cfg_applied, 
    input   logic                   i_dr_new_cfg_applied_ack, 
    output  logic                   o_dr_in_progress,
    
    // DR Controller (NIOS) interface control/status
    output  logic                   o_dr_trigger_intr,
    input   logic                   i_dr_trigger_intr_ack,
    input   logic                   i_dr_cpu_new_cfg_applied,
    output  logic                   o_dr_cpu_new_cfg_applied_ack, 
    
    // DR HIP interface control/status
    input   logic [31:0]            i_dr_tx_rst_ack,
    input   logic [31:0]            i_dr_rx_rst_ack,
    input   logic [31:0]            i_dr_tx_operational,
    input   logic [31:0]            i_dr_rx_operational,
    input   logic [31:0]            i_dr_tx_reset_init,
    input   logic [31:0]            i_dr_rx_reset_init,
    input   logic                   i_dr_src_pause_grant,
    output  logic                   o_dr_src_pause_request,
    output  logic [31:0]            o_dr_src_tx_lane_desired_state,
    output  logic [31:0]            o_dr_src_rx_lane_desired_state, 
    input   logic [31:0]            i_dr_src_tx_alarm,
    output  logic [31:0]            o_dr_src_tx_clear_alarm,
    input   logic [31:0]            i_dr_src_rx_alarm,
    output  logic [31:0]            o_dr_src_rx_clear_alarm,    
    output  logic [31:0]            o_dr_src_tx_soft_mux_sel,
    output  logic [31:0]            o_dr_src_rx_soft_mux_sel,
    
    // DR SIP internal control/status
    output  logic [23:0][31:0]      o_dr_profile_1hot_sel,
    output  logic                   o_dr_error_status,
    input   logic                   i_dr_avmm1_maib_error,
    input   logic                   i_dr_gavmm_error,
    output  logic [31:0]            o_avmm_time_out
);

  localparam AVMM_TIMEOUT_RSTVAL   = 20'd20;
  localparam AVMM_TIMEOUT_TICKS    = 9'd256;
  localparam ACK_TIMEOUT_TICKS     = 6'd32;
   
  wire       dyn_rcfg_local_apply_reset_mux_sel_reg_apply_reset;
  wire       dyn_rcfg_local_apply_reset_mux_sel_reg_apply_mux_sel;
  wire       dyn_rcfg_local_apply_reset_mux_sel_reg_apply_1hot_mux_sel;
  wire       dr_clear_status_pulse;
  reg        dr_reset_done;
  
  // Protocol management
  // combinatorial read data signal declaration
  reg        read_edge;
  reg        write_edge;
 
  // read data is always returned on the next cycle
  always @( posedge csr_clk) begin
     if (!rst_n) 
       readdatavalid <= 1'b0; 
     else 
       readdatavalid <= read & ~read_edge;
  end

  always @( posedge csr_clk) begin
     if (!rst_n) 
       read_edge <= 1'b0; 
     else 
       read_edge <= read;
  end
  
  always @( posedge csr_clk) begin
     if (!rst_n) 
       write_edge <= 1'b0; 
     else 
       write_edge <= write;
  end
  
  assign waitrequest = (write & !write_edge) | (read & ~read_edge);

  //
  //  Protocol specific assignment to inside signals
  //
  wire        we   = write & ((address[25:23] == 3'h0) & (address[22:10] == 13'h0));
  wire        re   = read  & ((address[25:23] == 3'h0) & (address[22:10] == 13'h0));
  wire [9:0]  addr = {address[9:2], 2'b00};

  /* Control Logic of REGISTER "dyn_rcfg_dr_trigger_reg" */
  
  reg        dr_trigger_busy_pulse;
  reg        dr_trigger_intr_r;
  reg [11:0] time_count_config_ack;
  reg        dr_cpu_new_cfg_applied_ack_r;
  reg        dr_ready;
  
  wire       i_we_dr_trigger;
  wire       i_we_dr_next_trigger;
  wire       hw_we_hwset_dyn_rcfg_dr_trigger_reg_dr_next_trigger;
  wire       dr_trigger_intr_pulse;
  wire       dyn_rcfg_dr_trigger_reg_dr_next_trigger;
  wire [4:0] dyn_rcfg_local_error_stat_ctrl_reg_ack_timeout;
  wire       dyn_rcfg_dr_trigger_reg_dr_trigger;
  
  assign i_we_dr_trigger = writedata[0] & dyn_rcfg_dr_trigger_reg_dr_next_trigger;
  assign i_we_dr_next_trigger = writedata[1] & ~dr_trigger_intr_pulse;
  assign hw_we_hwset_dyn_rcfg_dr_trigger_reg_dr_next_trigger = o_dr_cpu_new_cfg_applied_ack & o_dr_new_cfg_applied;
  
  // Ready for new trigger
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dr_ready <= 1'b0;
    end
    else begin
      dr_ready <= dyn_rcfg_dr_trigger_reg_dr_next_trigger;
    end
  end
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      o_dr_new_cfg_applied  <= 1'b0;
    end
    else begin
      o_dr_new_cfg_applied  <= i_dr_cpu_new_cfg_applied ? 1'b1 : 1'b0;
    end
  end
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dr_trigger_intr_r <= 1'b0;
    end
    else begin 
      dr_trigger_intr_r <= dyn_rcfg_dr_trigger_reg_dr_trigger & ~i_dr_cpu_new_cfg_applied;
    end
  end

  assign dr_trigger_intr_pulse = dyn_rcfg_dr_trigger_reg_dr_trigger & ~dr_trigger_intr_r;
  assign dr_trigger_busy_pulse = ~dyn_rcfg_dr_trigger_reg_dr_trigger & dr_trigger_intr_r;
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      o_dr_trigger_intr <= 1'b0;
    end
    else if (dr_trigger_intr_pulse) begin 
      o_dr_trigger_intr <= 1'b1;
    end
    else if (i_dr_trigger_intr_ack) begin
      o_dr_trigger_intr <= 1'b0;
    end
  end

  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      o_dr_cpu_new_cfg_applied_ack <= 1'b0;
    end
    else if (dr_trigger_intr_pulse | ~o_dr_new_cfg_applied) begin 
      o_dr_cpu_new_cfg_applied_ack <= 1'b0;
    end
    else if ((i_dr_new_cfg_applied_ack & i_dr_cpu_new_cfg_applied) | ((|dyn_rcfg_local_error_stat_ctrl_reg_ack_timeout) & (time_count_config_ack == (ACK_TIMEOUT_TICKS*dyn_rcfg_local_error_stat_ctrl_reg_ack_timeout)))) begin
      o_dr_cpu_new_cfg_applied_ack <= 1'b1;
    end
    else begin
      o_dr_cpu_new_cfg_applied_ack <= dr_cpu_new_cfg_applied_ack_r;
    end
  end
 
  // To fix X-prop issue on o_dr_cpu_new_cfg_applied_ack
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dr_cpu_new_cfg_applied_ack_r <= 1'b0;
    end
    else if (o_dr_cpu_new_cfg_applied_ack) begin
      dr_cpu_new_cfg_applied_ack_r <= 1'b1;
    end
    else begin
      dr_cpu_new_cfg_applied_ack_r <= 1'b0;
    end
  end

  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      time_count_config_ack <= 12'h000;
    end
    else if (dr_trigger_intr_pulse | i_dr_new_cfg_applied_ack) begin 
      time_count_config_ack <= 12'h000;
    end
    else if (o_dr_new_cfg_applied) begin
      time_count_config_ack <= (time_count_config_ack < (dyn_rcfg_local_error_stat_ctrl_reg_ack_timeout*ACK_TIMEOUT_TICKS)) ? (time_count_config_ack + 1'b1) : time_count_config_ack;
    end
  end 

  /* Control Logic of REGISTER "dyn_rcfg_dr_avmm_timeout_reg" */

  wire [19:0] dyn_rcfg_dr_avmm_timeout_reg_avmm_timeout;
  
  always @( posedge csr_clk) begin
    o_avmm_time_out <= dyn_rcfg_dr_avmm_timeout_reg_avmm_timeout * AVMM_TIMEOUT_TICKS;
  end

  /* Control Logic of REGISTER "dyn_rcfg_dr_txch2reconfig_busy_reg" */

  reg  [19:0] dyn_rcfg_dr_txch2reconfig_busy_reg_txch2reconfig_busy_i;
  reg  [19:0] dyn_rcfg_local_txch2reconfig_reg_snap;
  wire [19:0] dyn_rcfg_dr_txch2reconfig_busy_reg_txch2reconfig_busy;
  wire [19:0] dyn_rcfg_local_txch2reconfig_reg_TXChannel2Reconfigure;
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dyn_rcfg_dr_txch2reconfig_busy_reg_txch2reconfig_busy_i <= 20'h00000;
    end
    else begin
      if (~dr_reset_done) begin 
         dyn_rcfg_dr_txch2reconfig_busy_reg_txch2reconfig_busy_i <= (~i_dr_tx_operational[19:0]) & dyn_rcfg_local_txch2reconfig_reg_snap;
      end
    end
  end

  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dyn_rcfg_local_txch2reconfig_reg_snap <= 20'h00000;
    end
    else begin
      if (~dr_ready) begin 
        dyn_rcfg_local_txch2reconfig_reg_snap <= dyn_rcfg_local_txch2reconfig_reg_TXChannel2Reconfigure;
      end
    end
  end 

  /* Control Logic of REGISTER "dyn_rcfg_dr_rxch2reconfig_busy_reg" */

  reg  [19:0] dyn_rcfg_dr_rxch2reconfig_busy_reg_rxch2reconfig_busy_i;
  reg  [19:0] dyn_rcfg_local_rxch2reconfig_reg_snap;
  wire [19:0] dyn_rcfg_dr_rxch2reconfig_busy_reg_rxch2reconfig_busy;
  wire [19:0] dyn_rcfg_local_rxch2reconfig_reg_RXChannel2Reconfigure;
    
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dyn_rcfg_dr_rxch2reconfig_busy_reg_rxch2reconfig_busy_i <= 20'h00000;
    end
    else begin
      if (~dr_reset_done) begin 
         dyn_rcfg_dr_rxch2reconfig_busy_reg_rxch2reconfig_busy_i <= (~i_dr_rx_operational[19:0]) & dyn_rcfg_local_rxch2reconfig_reg_snap;
      end
    end
  end

  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dyn_rcfg_local_rxch2reconfig_reg_snap <= 20'h00000;
    end
    else begin
      if (~dr_ready) begin 
        dyn_rcfg_local_rxch2reconfig_reg_snap <= dyn_rcfg_local_rxch2reconfig_reg_RXChannel2Reconfigure;
      end
    end
  end 
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      o_dr_in_progress <= 1'b0;
    end
    else begin
      o_dr_in_progress <= (~dr_ready) || (|dyn_rcfg_dr_txch2reconfig_busy_reg_txch2reconfig_busy) 
                                      || (|dyn_rcfg_dr_rxch2reconfig_busy_reg_rxch2reconfig_busy);
    end
  end
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dr_reset_done <= 1'b1;
    end
    else if (dr_trigger_busy_pulse) begin 
      dr_reset_done <= 1'b0;
    end
    else if (~o_dr_in_progress) begin
      dr_reset_done <= 1'b1;
    end
  end
  

//////////////////////////// Local Facing CONTROL/STATUS REGISTERS ///////////////////////////////
  
  /* Control Logic of REGISTER "dyn_rcfg_local_tx_clear_alarm_reg" */

  wire [19:0] dyn_rcfg_local_tx_clear_alarm_reg_clear_alarm;

  assign o_dr_src_tx_clear_alarm = {12'h0,dyn_rcfg_local_tx_clear_alarm_reg_clear_alarm[19:0]};
  
  /* Control Logic of REGISTER "dyn_rcfg_local_rx_clear_alarm_reg" */
  
  wire [19:0] dyn_rcfg_local_rx_clear_alarm_reg_clear_alarm;

  assign o_dr_src_rx_clear_alarm = {12'h0,dyn_rcfg_local_rx_clear_alarm_reg_clear_alarm[19:0]};
   
  /* Control Logic of REGISTER "dyn_rcfg_local_tx_reset_reg" */

  wire [19:0] dyn_rcfg_local_tx_reset_reg_channel_reset;
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      o_dr_src_tx_lane_desired_state <= 32'h00000000;
    end
    else begin
      if (dyn_rcfg_local_apply_reset_mux_sel_reg_apply_reset) begin 
        o_dr_src_tx_lane_desired_state <= {12'h0,dyn_rcfg_local_tx_reset_reg_channel_reset[19:0]};
      end
    end
  end 

  /* Control Logic of REGISTER "dyn_rcfg_local_rx_reset_reg" */

  wire [19:0] dyn_rcfg_local_rx_reset_reg_channel_reset;
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      o_dr_src_rx_lane_desired_state <= 32'h00000000;
    end
    else begin
      if (dyn_rcfg_local_apply_reset_mux_sel_reg_apply_reset) begin 
        o_dr_src_rx_lane_desired_state <= {12'h0,dyn_rcfg_local_rx_reset_reg_channel_reset[19:0]};
      end
    end
  end 

  /* Control Logic of Onehot selector snap */

  wire [31:0] dyn_rcfg_local_mux_sel_0_reg_m0;
  wire [31:0] dyn_rcfg_local_mux_sel_1_reg_m1;
  wire [31:0] dyn_rcfg_local_mux_sel_2_reg_m2;
  wire [31:0] dyn_rcfg_local_mux_sel_3_reg_m3;
  wire [31:0] dyn_rcfg_local_mux_sel_4_reg_m4;
  wire [31:0] dyn_rcfg_local_mux_sel_5_reg_m5;
  wire [31:0] dyn_rcfg_local_mux_sel_6_reg_m6;
  wire [31:0] dyn_rcfg_local_mux_sel_7_reg_m7;
  wire [31:0] dyn_rcfg_local_mux_sel_8_reg_m8;
  wire [31:0] dyn_rcfg_local_mux_sel_9_reg_m9;
  wire [31:0] dyn_rcfg_local_mux_sel_10_reg_m10;
  wire [31:0] dyn_rcfg_local_mux_sel_11_reg_m11;
  wire [31:0] dyn_rcfg_local_mux_sel_12_reg_m12;
  wire [31:0] dyn_rcfg_local_mux_sel_13_reg_m13;
  wire [31:0] dyn_rcfg_local_mux_sel_14_reg_m14;
  wire [31:0] dyn_rcfg_local_mux_sel_15_reg_m15;
  wire [31:0] dyn_rcfg_local_mux_sel_16_reg_m16;
  wire [31:0] dyn_rcfg_local_mux_sel_17_reg_m17;
  wire [31:0] dyn_rcfg_local_mux_sel_18_reg_m18;
  wire [31:0] dyn_rcfg_local_mux_sel_19_reg_m19;
  wire [31:0] dyn_rcfg_local_mux_sel_20_reg_m20;
  wire [31:0] dyn_rcfg_local_mux_sel_21_reg_m21;
  wire [31:0] dyn_rcfg_local_mux_sel_22_reg_m22;
  wire [31:0] dyn_rcfg_local_mux_sel_23_reg_m23;
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      o_dr_profile_1hot_sel <= {24{32'h0000_0000}};
    end
    else begin
      if (dyn_rcfg_local_apply_reset_mux_sel_reg_apply_1hot_mux_sel) begin
        o_dr_profile_1hot_sel[0]  <= dyn_rcfg_local_mux_sel_0_reg_m0[31:0];
        o_dr_profile_1hot_sel[1]  <= dyn_rcfg_local_mux_sel_1_reg_m1[31:0];
        o_dr_profile_1hot_sel[2]  <= dyn_rcfg_local_mux_sel_2_reg_m2[31:0];
        o_dr_profile_1hot_sel[3]  <= dyn_rcfg_local_mux_sel_3_reg_m3[31:0];
        o_dr_profile_1hot_sel[4]  <= dyn_rcfg_local_mux_sel_4_reg_m4[31:0];
        o_dr_profile_1hot_sel[5]  <= dyn_rcfg_local_mux_sel_5_reg_m5[31:0];
        o_dr_profile_1hot_sel[6]  <= dyn_rcfg_local_mux_sel_6_reg_m6[31:0];
        o_dr_profile_1hot_sel[7]  <= dyn_rcfg_local_mux_sel_7_reg_m7[31:0];
        o_dr_profile_1hot_sel[8]  <= dyn_rcfg_local_mux_sel_8_reg_m8[31:0];
        o_dr_profile_1hot_sel[9]  <= dyn_rcfg_local_mux_sel_9_reg_m9[31:0];
        o_dr_profile_1hot_sel[10] <= dyn_rcfg_local_mux_sel_10_reg_m10[31:0];
        o_dr_profile_1hot_sel[11] <= dyn_rcfg_local_mux_sel_11_reg_m11[31:0];
        o_dr_profile_1hot_sel[12] <= dyn_rcfg_local_mux_sel_12_reg_m12[31:0];
        o_dr_profile_1hot_sel[13] <= dyn_rcfg_local_mux_sel_13_reg_m13[31:0];
        o_dr_profile_1hot_sel[14] <= dyn_rcfg_local_mux_sel_14_reg_m14[31:0];
        o_dr_profile_1hot_sel[15] <= dyn_rcfg_local_mux_sel_15_reg_m15[31:0];
        o_dr_profile_1hot_sel[16] <= dyn_rcfg_local_mux_sel_16_reg_m16[31:0];
        o_dr_profile_1hot_sel[17] <= dyn_rcfg_local_mux_sel_17_reg_m17[31:0];
        o_dr_profile_1hot_sel[18] <= dyn_rcfg_local_mux_sel_18_reg_m18[31:0];
        o_dr_profile_1hot_sel[19] <= dyn_rcfg_local_mux_sel_19_reg_m19[31:0];
        o_dr_profile_1hot_sel[20] <= dyn_rcfg_local_mux_sel_20_reg_m20[31:0];
        o_dr_profile_1hot_sel[21] <= dyn_rcfg_local_mux_sel_21_reg_m21[31:0];
        o_dr_profile_1hot_sel[22] <= dyn_rcfg_local_mux_sel_22_reg_m22[31:0];
        o_dr_profile_1hot_sel[23] <= dyn_rcfg_local_mux_sel_23_reg_m23[31:0];
      end
      else begin
        o_dr_profile_1hot_sel <= o_dr_profile_1hot_sel;
      end
    end
  end  


  /* Control Logic of REGISTER "dyn_rcfg_local_error_stat_ctrl_reg" */

  reg       dr_clear_status; 
  reg [7:0] dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error_i;
  
  wire [7:0] dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error;
  wire [7:0] dyn_rcfg_local_error_stat_ctrl_reg_firmware_error_state;
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error_i <= 8'h00;
    end
    else begin
      if (dr_clear_status_pulse) begin 
        dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error_i  <= 8'h00;
      end
      else begin
        if (i_dr_gavmm_error & ~dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error[0]) begin 
          dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error_i[0] <= 1'b1;
        end
        if (i_dr_avmm1_maib_error & ~dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error[1]) begin 
          dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error_i[1] <= 1'b1;
        end
      end
    end
  end

  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dr_clear_status <= 1'b0;
      o_dr_error_status <= 1'b0;
    end
    else begin
      dr_clear_status <= ~dr_ready;
      o_dr_error_status <= (|dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error[7:0]) | (|dyn_rcfg_local_error_stat_ctrl_reg_firmware_error_state[7:0]);
    end
  end
  
  assign dr_clear_status_pulse = ~(dr_clear_status | dr_ready);
  
  /* Control Logic of REGISTER "dyn_rcfg_local_tx_src_mux_sel_reg" */

  reg  [19:0] dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel_i;
  reg  [19:0] dyn_rcfg_dr_tx_fully_out_reset_reg_r;
  reg  [19:0] clear_tx_soft_mux_sel_pulse;
  
  wire [19:0] dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel;
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel_i <= 20'h00000;
      o_dr_src_tx_soft_mux_sel <= 32'h0000_0000;
    end
    else begin
      if (dyn_rcfg_local_apply_reset_mux_sel_reg_apply_mux_sel) begin
        o_dr_src_tx_soft_mux_sel[19:0] <= dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel;
      end
      else if (|clear_tx_soft_mux_sel_pulse) begin
        o_dr_src_tx_soft_mux_sel[19:0] <= o_dr_src_tx_soft_mux_sel[19:0] & ~clear_tx_soft_mux_sel_pulse;
      end
      if (|clear_tx_soft_mux_sel_pulse)  begin
        dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel_i <= dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel & ~clear_tx_soft_mux_sel_pulse;
      end
      else begin
        dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel_i <= dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel;
      end
    end
  end
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dyn_rcfg_dr_tx_fully_out_reset_reg_r <= 20'h00000;
    end
    else begin
      dyn_rcfg_dr_tx_fully_out_reset_reg_r[19:0] <= i_dr_tx_operational[19:0];
    end
  end

  assign clear_tx_soft_mux_sel_pulse = i_dr_tx_operational[19:0] & ~dyn_rcfg_dr_tx_fully_out_reset_reg_r;
  
  /* Control Logic of REGISTER "dyn_rcfg_local_rx_src_mux_sel_reg" */

  reg  [19:0] dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel_i;
  reg  [19:0] dyn_rcfg_dr_rx_fully_out_reset_reg_r;
  reg  [19:0] clear_rx_soft_mux_sel_pulse;
  
  wire [19:0] dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel;
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel_i <= 20'h00000;
      o_dr_src_rx_soft_mux_sel <= 32'h0000_0000;
    end
    else begin
      if (dyn_rcfg_local_apply_reset_mux_sel_reg_apply_mux_sel) begin
        o_dr_src_rx_soft_mux_sel[19:0] <= dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel;
      end
      else if (|clear_rx_soft_mux_sel_pulse) begin
        o_dr_src_rx_soft_mux_sel[19:0] <= o_dr_src_rx_soft_mux_sel[19:0] & ~clear_rx_soft_mux_sel_pulse;
      end
      if (|clear_rx_soft_mux_sel_pulse)  begin
        dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel_i <= dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel & ~clear_rx_soft_mux_sel_pulse;
      end
      else begin
        dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel_i <= dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel;
      end
    end
  end
  
  always @( posedge csr_clk) begin
    if (!rst_n)  begin
      dyn_rcfg_dr_rx_fully_out_reset_reg_r <= 20'h00000;
    end
    else begin
      dyn_rcfg_dr_rx_fully_out_reset_reg_r[19:0] <= i_dr_rx_operational[19:0];
    end
  end

  assign clear_rx_soft_mux_sel_pulse = i_dr_rx_operational[19:0] & ~dyn_rcfg_dr_rx_fully_out_reset_reg_r;
  
//-----------------------------------------------------------------------------
// Instantiation of DR SIP CSR registers definition block
//-----------------------------------------------------------------------------
  dr_f_sip_reg dr_f_sip_reg_inst (
      .i_we_dr_trigger                                           (i_we_dr_trigger),
      .i_clr_dr_trigger                                          (i_dr_trigger_intr_ack),
      .dyn_rcfg_dr_trigger_reg_dr_trigger                        (dyn_rcfg_dr_trigger_reg_dr_trigger),
      .i_we_dr_next_trigger                                      (i_we_dr_next_trigger),
      .hw_we_hwset_dyn_rcfg_dr_trigger_reg_dr_next_trigger       (hw_we_hwset_dyn_rcfg_dr_trigger_reg_dr_next_trigger),
      .i_clr_dr_next_trigger                                     (dr_trigger_intr_pulse),
      .dyn_rcfg_dr_trigger_reg_dr_next_trigger                   (dyn_rcfg_dr_trigger_reg_dr_next_trigger),
      .i_dr_ready                                                (dr_ready),
      .dyn_rcfg_dr_avmm_timeout_reg_avmm_timeout                 (dyn_rcfg_dr_avmm_timeout_reg_avmm_timeout),
      .dyn_rcfg_dr_txch2reconfig_busy_reg_txch2reconfig_busy_i   (dyn_rcfg_dr_txch2reconfig_busy_reg_txch2reconfig_busy_i),
      .dyn_rcfg_dr_txch2reconfig_busy_reg_txch2reconfig_busy     (dyn_rcfg_dr_txch2reconfig_busy_reg_txch2reconfig_busy),
      .dyn_rcfg_dr_rxch2reconfig_busy_reg_rxch2reconfig_busy_i   (dyn_rcfg_dr_rxch2reconfig_busy_reg_rxch2reconfig_busy_i),
      .dyn_rcfg_dr_rxch2reconfig_busy_reg_rxch2reconfig_busy     (dyn_rcfg_dr_rxch2reconfig_busy_reg_rxch2reconfig_busy),
      .dyn_rcfg_dr_tx_fully_reset_ack_reg_reset_ack_i            (i_dr_tx_rst_ack[19:0]),
      .dyn_rcfg_dr_tx_fully_out_reset_reg_reset_operational_i    (i_dr_tx_operational[19:0]),
      .dyn_rcfg_dr_tx_reset_initial_reg_reset_init_i             (i_dr_tx_reset_init[19:0]),
      .dyn_rcfg_dr_tx_src_alarm_reg_src_alarm_i                  (i_dr_src_tx_alarm[19:0]),
      .dyn_rcfg_dr_rx_fully_reset_ack_reg_reset_ack_i            (i_dr_rx_rst_ack[19:0]),
      .dyn_rcfg_dr_rx_fully_out_reset_reg_reset_operational_i    (i_dr_rx_operational[19:0]),
      .dyn_rcfg_dr_rx_reset_initial_reg_reset_init_i             (i_dr_rx_reset_init[19:0]),
      .dyn_rcfg_dr_rx_src_alarm_reg_src_alarm_i                  (i_dr_src_rx_alarm[19:0]),
      .dyn_rcfg_local_txch2reconfig_reg_TXChannel2Reconfigure    (dyn_rcfg_local_txch2reconfig_reg_TXChannel2Reconfigure),
      .dyn_rcfg_local_rxch2reconfig_reg_RXChannel2Reconfigure    (dyn_rcfg_local_rxch2reconfig_reg_RXChannel2Reconfigure),
      .dyn_rcfg_local_tx_clear_alarm_reg_clear_alarm             (dyn_rcfg_local_tx_clear_alarm_reg_clear_alarm),
      .dyn_rcfg_local_rx_clear_alarm_reg_clear_alarm             (dyn_rcfg_local_rx_clear_alarm_reg_clear_alarm),
      .dyn_rcfg_local_apply_reset_mux_sel_reg_apply_reset        (dyn_rcfg_local_apply_reset_mux_sel_reg_apply_reset),
      .dyn_rcfg_local_apply_reset_mux_sel_reg_apply_mux_sel      (dyn_rcfg_local_apply_reset_mux_sel_reg_apply_mux_sel),
      .dyn_rcfg_local_apply_reset_mux_sel_reg_apply_1hot_mux_sel (dyn_rcfg_local_apply_reset_mux_sel_reg_apply_1hot_mux_sel),
      .dyn_rcfg_local_src_pause_request_reg_pause_request        (o_dr_src_pause_request),
      .dyn_rcfg_local_src_pause_request_reg_pause_grant_i        (i_dr_src_pause_grant),
      .dyn_rcfg_local_tx_reset_reg_channel_reset                 (dyn_rcfg_local_tx_reset_reg_channel_reset),
      .dyn_rcfg_local_rx_reset_reg_channel_reset                 (dyn_rcfg_local_rx_reset_reg_channel_reset),
      .dyn_rcfg_local_mux_sel_0_reg_m0                           (dyn_rcfg_local_mux_sel_0_reg_m0),
      .dyn_rcfg_local_mux_sel_1_reg_m1                           (dyn_rcfg_local_mux_sel_1_reg_m1),
      .dyn_rcfg_local_mux_sel_2_reg_m2                           (dyn_rcfg_local_mux_sel_2_reg_m2),
      .dyn_rcfg_local_mux_sel_3_reg_m3                           (dyn_rcfg_local_mux_sel_3_reg_m3),
      .dyn_rcfg_local_mux_sel_4_reg_m4                           (dyn_rcfg_local_mux_sel_4_reg_m4),
      .dyn_rcfg_local_mux_sel_5_reg_m5                           (dyn_rcfg_local_mux_sel_5_reg_m5),
      .dyn_rcfg_local_mux_sel_6_reg_m6                           (dyn_rcfg_local_mux_sel_6_reg_m6),
      .dyn_rcfg_local_mux_sel_7_reg_m7                           (dyn_rcfg_local_mux_sel_7_reg_m7),
      .dyn_rcfg_local_mux_sel_8_reg_m8                           (dyn_rcfg_local_mux_sel_8_reg_m8),
      .dyn_rcfg_local_mux_sel_9_reg_m9                           (dyn_rcfg_local_mux_sel_9_reg_m9),
      .dyn_rcfg_local_mux_sel_10_reg_m10                         (dyn_rcfg_local_mux_sel_10_reg_m10),
      .dyn_rcfg_local_mux_sel_11_reg_m11                         (dyn_rcfg_local_mux_sel_11_reg_m11),
      .dyn_rcfg_local_mux_sel_12_reg_m12                         (dyn_rcfg_local_mux_sel_12_reg_m12),
      .dyn_rcfg_local_mux_sel_13_reg_m13                         (dyn_rcfg_local_mux_sel_13_reg_m13),
      .dyn_rcfg_local_mux_sel_14_reg_m14                         (dyn_rcfg_local_mux_sel_14_reg_m14),
      .dyn_rcfg_local_mux_sel_15_reg_m15                         (dyn_rcfg_local_mux_sel_15_reg_m15),
      .dyn_rcfg_local_mux_sel_16_reg_m16                         (dyn_rcfg_local_mux_sel_16_reg_m16),
      .dyn_rcfg_local_mux_sel_17_reg_m17                         (dyn_rcfg_local_mux_sel_17_reg_m17),
      .dyn_rcfg_local_mux_sel_18_reg_m18                         (dyn_rcfg_local_mux_sel_18_reg_m18),
      .dyn_rcfg_local_mux_sel_19_reg_m19                         (dyn_rcfg_local_mux_sel_19_reg_m19),
      .dyn_rcfg_local_mux_sel_20_reg_m20                         (dyn_rcfg_local_mux_sel_20_reg_m20),
      .dyn_rcfg_local_mux_sel_21_reg_m21                         (dyn_rcfg_local_mux_sel_21_reg_m21),
      .dyn_rcfg_local_mux_sel_22_reg_m22                         (dyn_rcfg_local_mux_sel_22_reg_m22),
      .dyn_rcfg_local_mux_sel_23_reg_m23                         (dyn_rcfg_local_mux_sel_23_reg_m23),
      .dyn_rcfg_local_error_stat_ctrl_reg_ack_timeout            (dyn_rcfg_local_error_stat_ctrl_reg_ack_timeout),
      .dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error_i   (dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error_i),
      .dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error     (dyn_rcfg_local_error_stat_ctrl_reg_avmm_timeout_error),
      .i_clr_dr_firmware_state                                   (dr_clear_status_pulse),
      .dyn_rcfg_local_error_stat_ctrl_reg_firmware_error_state   (dyn_rcfg_local_error_stat_ctrl_reg_firmware_error_state),
      .dyn_rcfg_local_curr_profile_reg_current_profile           (o_dr_curr_profile_id),
      .dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel_i               (dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel_i),
      .dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel                 (dyn_rcfg_local_tx_src_mux_sel_reg_mux_sel),
      .dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel_i               (dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel_i),
      .dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel                 (dyn_rcfg_local_rx_src_mux_sel_reg_mux_sel),

      .clk                                                       (csr_clk),
      .reset                                                     (~rst_n),
      .writedata                                                 (writedata),
      .read                                                      (re),
      .write                                                     (we),
      .byteenable                                                (byteenable),
      .readdata                                                  (readdata),
      .readdatavalid                                             (),
      .address                                                   (addr)
);

endmodule //DR_F_CSR

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "wuj6SUN+CWUHl7X/28Op4/b/clpjqbLY1GA2Z3hIF6AQ/N7zu6Fwoye5cSVZtCMjzq7zVIP70Vz25qwBBwoIUIbppOYuSWAZCOtwfVezNqtYswQ62n/3Hi6fWGVfeSbJS3aJs8eFyk/7NahU2OTeak7iTUPHQndN4oB5O1gSp87DXZC4zl72BeNdhBCD27/XMw5oUpTkQ1qs22Ma/P0Qj3KuL2yUnt0fdnpvUGYwREyQLq3cooc+U/dcS5Alo09HgEvKhKjx9CGIFvQ52Qs2yeFHmpATfwkgTUiAf34BkqIGBKWFLq5IW8C+PiFv+HatbzjZrdJ1VTXAmI3oyR8ZSOidCIDxh8hA8vqpKqS9dZMfY0OjarqpT3LKxUfLRdSbzq9C1EtnfPASABS/Kvq4q8Pcvx8SZL5T9+rGnRmW5AOVVVaW11XmHj9noPjTtkJIp1/GP5+B3nArujNLhxvwQk28PV9s4/gMvBJpccAf37VqOdj+JdbIE3ZFd5rQ18vrneYzQ6uOpRTNHuqIV/G5otDA0Juf/Yzl6uK/1D6pCqhqipAn1HgmDCXRzdFeUKV+m5CMerlKJlTVW8fKJZe+pjRPZXv4CtvjInNesaa034XsMgUyjSAaTWy2vwnaK0KW4P/+OSAjAgeWsr/RY24bYStCtRWiSOkW92UqCdfeTpGWoVlf2eYClCaYc3TZPj74vJ7L3aVOK8So28WHkRKuDufPfpTV8XoOVSffVlcVZogWWcLcOGNhSFIRYFeC9roozgNnmbopVAQmnXX0N/WcmgthEbSpECqwcJ5fxuy0jT6QkRN6FyO9Z1tPVLgyQfho9Hbcat9Ti7ah21FsSc+wVNu3SQNlyJ/avg98ZzvTe0QRLdTJsI/jvhCTseY1o0O9kCZ4KO1uLrH6Dz9LwD2o3HNkZmfayAprfnVliG69bYZ52RvlSbNc86y46Dy1drsNm68kP7pUd87lCjRmyN7b7d/AOX8pkD0jEqr/LFrRn9geEtYJtf48SKv2mmdeeJD8"
`endif