// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

module dr_f_data_sync #(
    parameter WIDTH = 32
) (
    input   logic               aclr,

    input   logic               clk_in,
    input   logic   [WIDTH-1:0] data_in,
    input   logic               clk_out,
    output  logic   [WIDTH-1:0] data_out
);

    logic   reset_in;
    logic   valid;
    logic   valid_last;
    logic   valid_sync;

    logic   ack;
    logic   ack_last;
    logic   ack_sync;

    logic   [WIDTH-1:0] din_reg;

    always_ff @(posedge clk_in) begin
        valid_last  <= valid;
        if (reset_in) begin
            valid   <= 1'b0;
        end else begin
            valid   <= ~ack_sync;
        end

        if (valid && !valid_last) begin
            din_reg <= data_in;
        end else begin
            din_reg <= din_reg;
        end
    end

    always_ff @(posedge clk_out) begin
        ack         <= valid_sync;
        ack_last    <= ack;

        if (ack && !ack_last) begin
            data_out <= din_reg;
        end
    end

    dr_f_reset_synchronizer rst_sync_0 (
        .aclr       (aclr),
        .clk        (clk_in),
        .aclr_sync  (reset_in)
    );

    dr_f_altera_std_synchronizer_nocut valid_sync_0 (
        .clk     (clk_out),
        .reset_n (1'b1),
        .din     (valid),
        .dout    (valid_sync)
    );

    dr_f_altera_std_synchronizer_nocut ack_sync_0 (
        .clk     (clk_in),
        .reset_n (1'b1),
        .din     (ack),
        .dout    (ack_sync)
    );
    
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "79ztKTnV2ny/eHpgZYepe9G9wwwdeg9hTOdIyLdh4JTuZZ1DT50cJOPNpZ0w+c5aVHkra3Tx9+PMlDB4omAPannbtZoJG9ZekMCcgtPHzQ4GWiJfmhYoHZqap4yb9/uKlHSl9TpAcV1FKEwkrctIKziGBKSQ0S70p/jW9wD4CtM3X7P+ggV0x7Prg108lDSsdB1kGvgcQN/5kLCIPO6i12claBXdWuhbdU7Bm3JHKTpsw5HCXIYxjxmOPXBO9kSH6KTnsSHzNOdHqXBfRGOwOrY2UmRTkMzz1+i50FCBF0DfTmmvM4PE5NuIECPQkaj9ock5lLZ6YxxqNjDMK3YUSOvamoFdcMSyTdqLK59RE3dyACphyC03gOPD7siGl2C/Ct/JXNpgpH5+XYOupBycNneUvFqhhJLvXkzz/XaCHXlcfS/cGka7eTkfZbqm8b7XSxanenzAMLo7jyN/JIhHbjQiaDRbpwP3CTEb33P3gkpqnPp1vzCTPyAEAgZqQqWuUh0crPmZjh1PZrhZj83KGlBZtMuLYDtw5rl4VOUCqct+4BVHxXiQaXuJrdj+TULg/XPu8D/KQ8RQKWbmepvLCHhupnKJC0CQ+inWGKJOZr/wSUhMh44emxAr/0yKAdrYz7GdtqdBmjSVlNJ5qKLGZ75iDxUXkAa+TzHthXVJU+h3XYEgiI+oiYP3tfDwZ7AcAzmZlxZNavKPJqIIwKK/+GjbiSSgakAUqeg3XPT6k/a9ebOUJk5GAJNmEusT9gZPN9tZrvXNLxUl3E6LLDpMUhMcztidsrh5o6Bujm6cyR1k+3P0tNj2s5+Sch6Vni8Bz8EzYn1k8VbASmXsg4lHnqEJjawAhcKKOegV66+QJY1t8KgeNTRgcEPos6t/oXT3vJsNeHTy8l6MrGpKmHck28JisQ9I3iqG7ZtvJQn88xRDrhFz8BBHHiurdAHhyo7cEVhvSc8MeUsmQ1IDQkZsL9QtGe+dRw3ATDCBEc5GDbmyL88uPYZtEqOvWSnsI1eV"
`endif