// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


//----------------------------------------------------------------------------- 
//  Project Name:  GDR Dynamic Reconfiguration (F-tile)                                  
//  Module Name :  dr_f_hip                                  
//  Author ID   :  hafeezmu                                   
//  Date        :  Wed Mar 4 16:07:44 2020   
//  Version     :  v1.0 (Initial Draft)                               
//  Description :  GDR DR HIP BB access for for F-tile. This component is top
//                 of DR HIP that integrate all sub components BB's like Global 
//                 AVMM.                                            
//-----------------------------------------------------------------------------
(* tile_ip_hip *)
module dr_f_hip
  #(
    parameter bb_silicon_rev = "FM6",
    parameter bb_m_hdpldadapt_pld_avmm1_clk_rowclk_hz = 31'd100000000
  )  (
   input                   hip_avmm_read_real,
   output  [7:0]           hip_avmm_readdata_real,
   output                  hip_avmm_readdatavalid_real,
   input   [20:0]          hip_avmm_reg_addr_real,
   output  [4:0]           hip_avmm_reserved_out_real,
   input                   hip_avmm_write_real,
   input   [7:0]           hip_avmm_writedata_real,
   output                  hip_avmm_writedone_real,
   output                  pld_avmm2_busy_real,
   input                   pld_avmm2_clk_rowclk_real,
   output                  pld_avmm2_cmdfifo_wr_full_real,
   output                  pld_avmm2_cmdfifo_wr_pfull_real,
   input                   pld_avmm2_request_real,
   output                  pld_pll_cal_done_real,
   // below are unused ports in hip mode
   input                   pld_avmm2_write_real,
   input                   pld_avmm2_read_real,
   input   [8:0]           pld_avmm2_reg_addr_real,
   output  [7:0]           pld_avmm2_readdata_real,
   input   [7:0]           pld_avmm2_writedata_real,
   output                  pld_avmm2_readdatavalid_real,
   input   [5:0]           pld_avmm2_reserved_in_real,
   output                  pld_avmm2_reserved_out_real,
   //  for AVMM1 bb ports
   output  [23:0]          pld_avmm1_busy,
   input   [23:0]          pld_avmm1_clk_rowclk,
   output  [23:0]          pld_avmm1_cmdfifo_wr_full,
   output  [23:0]          pld_avmm1_cmdfifo_wr_pfull,
   input   [23:0]          pld_avmm1_read,
   output  [(24*8)-1:0]    pld_avmm1_readdata,
   output  [23:0]          pld_avmm1_readdatavalid,
   input   [(24*10)-1:0]   pld_avmm1_reg_addr,
   input   [23:0]          pld_avmm1_request,
   input   [(24*9)-1:0]    pld_avmm1_reserved_in,
   output  [(24*3)-1:0]    pld_avmm1_reserved_out,
   input   [23:0]          pld_avmm1_write,
   input   [(24*8)-1:0]    pld_avmm1_writedata,
   output  [23:0]          pld_hssi_osc_transfer_en
  );
 
 
`ifdef __TILE_IP__
   bb_m_hdpldadapt_avmm2 #(
     .location                       ("MAIB3"), 
     .silicon_rev                    (bb_silicon_rev),
     .auto_profile_id                ("__\${ip_inst_d}__") )
   dr_f_global_avmm2_inst 
   (
     .hip_avmm_read_real             (hip_avmm_read_real),
     .hip_avmm_readdata_real         (hip_avmm_readdata_real),
     .hip_avmm_readdatavalid_real    (hip_avmm_readdatavalid_real),
     .hip_avmm_reg_addr_real         (hip_avmm_reg_addr_real),
     .hip_avmm_reserved_out_real     (hip_avmm_reserved_out_real),
     .hip_avmm_write_real            (hip_avmm_write_real),
     .hip_avmm_writedata_real        (hip_avmm_writedata_real),
     .hip_avmm_writedone_real        (hip_avmm_writedone_real),
     .pld_avmm2_busy_real            (pld_avmm2_busy_real),
     .pld_avmm2_clk_rowclk_real      (pld_avmm2_clk_rowclk_real),
     .pld_avmm2_cmdfifo_wr_full_real (pld_avmm2_cmdfifo_wr_full_real),
     .pld_avmm2_cmdfifo_wr_pfull_real(pld_avmm2_cmdfifo_wr_pfull_real),
     .pld_avmm2_read_real            (pld_avmm2_read_real),
     .pld_avmm2_readdata_real        (pld_avmm2_readdata_real),
     .pld_avmm2_readdatavalid_real   (pld_avmm2_readdatavalid_real),
     .pld_avmm2_reg_addr_real        (pld_avmm2_reg_addr_real),
     .pld_avmm2_request_real         (pld_avmm2_request_real),
     .pld_avmm2_reserved_in_real     (pld_avmm2_reserved_in_real),
     .pld_avmm2_reserved_out_real    (pld_avmm2_reserved_out_real),
     .pld_avmm2_write_real           (pld_avmm2_write_real), 
     .pld_avmm2_writedata_real       (pld_avmm2_writedata_real),
     .pld_pll_cal_done_real          (pld_pll_cal_done_real),
     .avmm2_link                     ()
    );
    
    genvar j;
    generate 
      for (j = 0; j < 24; j = j+1) begin: DR_AVMM1   
        bb_m_hdpldadapt_avmm1 #(
	    	.hdpldadapt_pld_avmm1_clk_rowclk_hz (bb_m_hdpldadapt_pld_avmm1_clk_rowclk_hz), 
            .silicon_rev                    (bb_silicon_rev),
            .auto_profile_id                ("__\${ip_inst_d}__")
        )
        dr_f_maib_avmm1_inst (
          .pld_avmm1_busy_real              (pld_avmm1_busy[j]), 
          .pld_avmm1_clk_rowclk_real        (pld_avmm1_clk_rowclk[j]),
          .pld_avmm1_cmdfifo_wr_full_real   (pld_avmm1_cmdfifo_wr_full[j]),
          .pld_avmm1_cmdfifo_wr_pfull_real  (pld_avmm1_cmdfifo_wr_pfull[j]),
          .pld_avmm1_read_real              (pld_avmm1_read[j]),
          .pld_avmm1_readdata_real          (pld_avmm1_readdata[j*8+:8]),
          .pld_avmm1_readdatavalid_real     (pld_avmm1_readdatavalid[j]),
          .pld_avmm1_reg_addr_real          (pld_avmm1_reg_addr[j*10+:10]),
          .pld_avmm1_request_real           (pld_avmm1_request[j]),
          .pld_avmm1_reserved_in_real       (pld_avmm1_reserved_in[j*9+:9]),
          .pld_avmm1_reserved_out_real      (pld_avmm1_reserved_out[j*3+:3]),
          .pld_avmm1_write_real             (pld_avmm1_write[j]),
          .pld_avmm1_writedata_real         (pld_avmm1_writedata[j*8+:8]),
           // .pld_chnl_cal_done_real          ( pld_chnl_cal_done ),
          .pld_hssi_osc_transfer_en_real    (pld_hssi_osc_transfer_en[j]),
          .avmm1_link                       ()
        );
      end: DR_AVMM1
    endgenerate
    defparam DR_AVMM1[0].dr_f_maib_avmm1_inst.location  = "MAIB0";
    defparam DR_AVMM1[1].dr_f_maib_avmm1_inst.location  = "MAIB1";
    defparam DR_AVMM1[2].dr_f_maib_avmm1_inst.location  = "MAIB2";
    defparam DR_AVMM1[3].dr_f_maib_avmm1_inst.location  = "MAIB3";
    defparam DR_AVMM1[4].dr_f_maib_avmm1_inst.location  = "MAIB4";
    defparam DR_AVMM1[5].dr_f_maib_avmm1_inst.location  = "MAIB5";
    defparam DR_AVMM1[6].dr_f_maib_avmm1_inst.location  = "MAIB6";
    defparam DR_AVMM1[7].dr_f_maib_avmm1_inst.location  = "MAIB7";
    defparam DR_AVMM1[8].dr_f_maib_avmm1_inst.location  = "MAIB8";
    defparam DR_AVMM1[9].dr_f_maib_avmm1_inst.location  = "MAIB9";
    defparam DR_AVMM1[10].dr_f_maib_avmm1_inst.location = "MAIB10";
    defparam DR_AVMM1[11].dr_f_maib_avmm1_inst.location = "MAIB11";
    defparam DR_AVMM1[12].dr_f_maib_avmm1_inst.location = "MAIB12";
    defparam DR_AVMM1[13].dr_f_maib_avmm1_inst.location = "MAIB13";
    defparam DR_AVMM1[14].dr_f_maib_avmm1_inst.location = "MAIB14";
    defparam DR_AVMM1[15].dr_f_maib_avmm1_inst.location = "MAIB15";
    defparam DR_AVMM1[16].dr_f_maib_avmm1_inst.location = "MAIB16";
    defparam DR_AVMM1[17].dr_f_maib_avmm1_inst.location = "MAIB17";
    defparam DR_AVMM1[18].dr_f_maib_avmm1_inst.location = "MAIB18";
    defparam DR_AVMM1[19].dr_f_maib_avmm1_inst.location = "MAIB19";
    defparam DR_AVMM1[20].dr_f_maib_avmm1_inst.location = "MAIB20";
    defparam DR_AVMM1[21].dr_f_maib_avmm1_inst.location = "MAIB21";
    defparam DR_AVMM1[22].dr_f_maib_avmm1_inst.location = "MAIB22";
    defparam DR_AVMM1[23].dr_f_maib_avmm1_inst.location = "MAIB23";
`endif
    
endmodule //DR_F_HIP





`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "wuj6SUN+CWUHl7X/28Op4/b/clpjqbLY1GA2Z3hIF6AQ/N7zu6Fwoye5cSVZtCMjzq7zVIP70Vz25qwBBwoIUIbppOYuSWAZCOtwfVezNqtYswQ62n/3Hi6fWGVfeSbJS3aJs8eFyk/7NahU2OTeak7iTUPHQndN4oB5O1gSp87DXZC4zl72BeNdhBCD27/XMw5oUpTkQ1qs22Ma/P0Qj3KuL2yUnt0fdnpvUGYwREyfqQ4oa6jiX81iuHIJLH9neN2vOQe+IvvaMdz8m89hcJcWJbzVJYg1+6nAWrncqyfFo0ZmX94LnZzWHGmLEJK3EvkOioMYwXA2W+XH4HGnMVxKkDdWQuo/sY0Vir4h/SVllQE8LNqJbAoZzLEUhYSEyQ0P+CcCo5isD3KyFFL4i1SnV9YgkFKfiQZrKIk4WUwmWqWXzymeqnfdFfp4hUUKxulUKzNi9gkMbDFKS7ATr0xKPmWc7uE6UTN6HKS7EzaoC6Cpo8BRqUwJ+s1Su3UgF3V5JOkcvYOIf/rySTFh6vEDg3audCjgBiWsYjGCq6xnSVUKQD41OfDGyIjnxdQkLqXKOeKuT7jFB5w8m4tPFJVUgPS6DQwc7J1pib1WqEcvYK0bImXkAw2hOtrWsQEfuvHRoJNDwiIdhBLzDNUY3MfIXeG32gUZn0MrD0y5U0vZX54oLHUQ+csWdc1E0cwFELmCpP4qeNjXZ98dHmJN36x0miIRF0kybEhgpRGl7FmORb/WoxweHGmceK/rFr9vKTOAtA5jHQZGZ+oSH5HV5cCoEQeDaJto5BnlvyzdVe/l/DWjPYURRq7VxvK5AgFEmq3L6aB6hEwngZPsOEcEWxm4AECKiILvCpA9ctQgkX+JNXnYzyCH4KTm6KWdDb7CkoXa/G/LPFaEFeScFJ7P8GC34ipWGH3HSKgIKbY54aMyytPTC18jLp6QskuwHojta7TNuD0qO4Rnmdmce8ZATSkEhX49VJ9lh5Qbfw3nNankZGNf2O1NL9lhhupWPirN"
`endif