// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps

// DESCRIPTION
//
// This is a small register circuit for synchronizing aclr signals to produce asynchronous attack and
// synchronous release across clock domains.
//
// CONFIDENCE
// This component has significant hardware test coverage in reference designs and Altera IP cores.
//

module dr_f_reset_synchronizer (
    input   aclr_n, // no domain
    input   clk,
    output wire aclr_sync_n
);

    dr_f_altera_std_synchronizer_nocut #(
                    .depth(3),
                    .rst_value(1'b0)
         )  synchronizer_nocut_inst  (
                    .clk(clk),
                    .reset_n(aclr_n),
                    .din(1'b1),
                    .dout(aclr_sync_n)
    );

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "79ztKTnV2ny/eHpgZYepe9G9wwwdeg9hTOdIyLdh4JTuZZ1DT50cJOPNpZ0w+c5aVHkra3Tx9+PMlDB4omAPannbtZoJG9ZekMCcgtPHzQ4GWiJfmhYoHZqap4yb9/uKlHSl9TpAcV1FKEwkrctIKziGBKSQ0S70p/jW9wD4CtM3X7P+ggV0x7Prg108lDSsdB1kGvgcQN/5kLCIPO6i12claBXdWuhbdU7Bm3JHKTq2SwMx8lRh8vrkMNCPKRNZbOPF6UMXFGS2R5V5uFznACnpWe/WGuvAdZLajLDHdwgi3o/DFN6Fepk7NtmoNq/v2dotOLg8qY+72hTN89MnBeqixFhmzJdv9DWxQZp7uvNagR3o9PTFWk6V6ak4+ksPwRukVAiEZJZosn41gAQNO4RecEuo7Kpsfn71FtV4euHwmy6X64LUFvEo+zxPt0EzvOuASdNabMTacsFjt6kF9FebNFGL/3zI9cTIWCBq/bsu99Tsj3Dai+yLyLEL22QsymqPPf+um7c3vvZ9vawjS4k4Zb3fE/sxXpdLf5qnt8SopjvXubIhCutn3wODx7RouBPZEg9G5rphokJ/u1WCSY5nkrq/qLVqHkd6RXeMYFIraMRgoY6roiGY6n9Dgzv/sPtnsRZL3xIMNGDxHcySvzAnQ2mWdNH1SR9d3xTRqCZOdWKAXzGYPMxgW662zhGXcYZjdli9Q4z4Ewja04tbt0ZY6yo6feFWrp0+rCtpwnWu8g8DxXSFwFVXzRDNLPd9wVf6zObDOsDhVWGLE8ncod4ytFrnuTW95PMFShpWbw98JxZbqnt3jDMviqBiYJaDlH7aghuiLhk36P6J49vb3G1NKvRUR0PexshN13fi+SAd5iQj3Hr7Chf4is4KcNBh4wW9Ei1f31qDL5klus2sCd/me/x3HQ3CiGWgUKthqDHuNP99jIhb/rQdmant+BCD46aWZo07A1FK9I561+9zuZOfhkCJ4w+7KzivvbUpe+/gmlsLzReumbceuMrpbTZn"
`endif