# (C) 2001-2023 Intel Corporation. All rights reserved.
# Your use of Intel Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Intel Program License Subscription 
# Agreement, Intel FPGA IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Intel and sold by 
# Intel or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


# ----------------------------------------------------------------------------- #
# Timequest JTAG clock definition
#   Uncommenting the following lines will define the JTAG
#   clock in TimeQuest Timing Analyzer
# ----------------------------------------------------------------------------- #
#create_clock -period 10MHz {altera_reserved_tck}
#set_clock_groups -asynchronous -group {altera_reserved_tck}

# ----------------------------------------------------------------------------- #
# --- DR Synchronizer / Clock Crosser constraint                            --- #
# ----------------------------------------------------------------------------- #

proc dr_f_constraint_net_delay {from_reg to_reg max_net_delay {check_exist 0} {get_pins 1}} {
    # Check for instances
    set inst [get_registers -nowarn ${to_reg}]
    
    # Check number of instances
    set inst_num [llength [query_collection -report -all $inst]]
    if {$inst_num > 0} {
        # Uncomment line below for debug purpose
        #puts "${inst_num} ${to_reg} instance(s) found"
    } else {
        # Uncomment line below for debug purpose
        #puts "No ${to_reg} instance found"
    }
    
    if {($check_exist == 0) || ($inst_num > 0)} {
        if { [string equal "quartus_sta" $::TimeQuestInfo(nameofexecutable)] } {
            set_max_delay -from [get_registers ${from_reg}] -to [get_registers ${to_reg}] 200ns
            set_min_delay -from [get_registers ${from_reg}] -to [get_registers ${to_reg}] -200ns
        } else {
            if {$get_pins == 0} {
                set_net_delay -from [get_registers ${from_reg}] -to [get_registers ${to_reg}] -max $max_net_delay
            } else {
                set_net_delay -from [get_pins -compatibility_mode ${from_reg}|q] -to [get_registers ${to_reg}] -max $max_net_delay
            }
            
            # Relax the fitter effort
            set_max_delay -from [get_registers ${from_reg}] -to [get_registers ${to_reg}] 200ns
            set_min_delay -from [get_registers ${from_reg}] -to [get_registers ${to_reg}] -200ns
        }
    }
}
# --------------------------------------------------------------------
# soft_dr_csr: synchronizer
dr_f_constraint_net_delay  * \
                            *|dr_ctrl_sip_inst|dr_rst_*|resync_chains[0].synchronizer_nocut|din_s1 \
                            2.2ns 1 0
dr_f_constraint_net_delay  * \
                            *|dr_ctrl_sip_inst|*dr_sync[*].dr_synchronizer_nocut_inst|din_s1 \
                            2.2ns 1 0
dr_f_constraint_net_delay  * \
                            *|dr_ctrl_sip_inst|*dr_sync*|din_s1 \
                            2.2ns 1 0
dr_f_constraint_net_delay  * \
                            *|dr_ctrl_sip_inst|*src_sync[*].dr_synchronizer_nocut_inst|din_s1 \
                            2.2ns 1 0
dr_f_constraint_net_delay  * \
                            *|dr_ctrl_sip_inst|*src_sync*|din_s1 \
                            2.2ns 1 0               
dr_f_constraint_net_delay  * \
                            *|dr_ctrl_sip_inst|ctf_avmm1_soft_logic_inst|avmm_if_soft_logic[*].ctf_avmm_maib_if_inst|avmm_* \
                            2.2ns 1 0
dr_f_constraint_net_delay  * \
                            *|dr_ctrl_sip_inst|dr_avmm2_cl_inst|avmm_sip_insts[*].agx_xcvr_avmm_soft_logic_inst|avmm_* \
                            2.2ns 1 0	
                            
# --------------------------------------------------------------------
# soft_dr: clock crosser - synchronizer, data_buffer
dr_f_constraint_net_delay  * \
                            *|dr_ctrl_sip_inst|*|in_to_out_synchronizer|resync_chains[0].synchronizer_nocut|din_s1 \
                            2.2ns 1 0
dr_f_constraint_net_delay  * \
                            *|dr_ctrl_sip_inst|*|out_to_in_synchronizer|resync_chains[0].synchronizer_nocut|din_s1 \
                            2.2ns 1 0
dr_f_constraint_net_delay  *|dr_ctrl_sip_inst|*|in_data_buffer[*] \
                            *|dr_ctrl_sip_inst|*|out_data_buffer[*] \
                            2.2ns 1 0

# --------------------------------------------------------------------
# Constraints between CPU clock and CSR clock Nodes 

dr_f_constraint_net_delay  * \
                            *|dr_cpu_new_cfg_applied_sync_inst|resync_chains[0].synchronizer_nocut|din_s1 \
                            2.2ns 1 0
dr_f_constraint_net_delay  * \
                            *|dr_ctrl_sip_inst|dr_csr_inst|o_dr_trigger_intr \
                            2.2ns 1 0			 									 
dr_f_constraint_net_delay  * \
                            *|dr_ctrl_sip_inst|dr_csr_inst|dyn_rcfg_dr_trigger_reg[0] \
                            2.2ns 1 0
dr_f_constraint_net_delay  * \
                            *|dr_cpu_ctrl_inst|dr_f_cpu_ctrl|ctrl_c1|readdata[*] \
                            2.2ns 1 0
dr_f_constraint_net_delay  *|dr_cpu_ctrl_inst|dr_f_cpu_ctrl|stat_s1|data_out[*] \
                            * \
                            2.2ns 1 0

# --------------------------------------------------------------------
# Set false path on onehot selector of all DR MUXes                            
set dr_f_1hot_sel_col_fp [get_keepers -nowarn {*|dr_ctrl_sip_inst|dr_csr_inst|o_dr_profile_1hot_sel[*][*]}]
set dr_f_src_int_col_fp [get_keepers -nowarn {*|dr_ctrl_sip_inst|*_src_sync|sync[*].dr_synchronizer_nocut_inst|dreg[1]}]
set_false_path -no_synchronizer -from $dr_f_1hot_sel_col_fp
set_false_path -no_synchronizer -from $dr_f_src_int_col_fp
# Fixes CDC-50002 & CDC-50101 DA violations
set dr_f_src_desired_state_col_fp [get_keepers -nowarn {*|x_ftile_reset|rst_ctrl_sync|*_lane_desired_state_inst[*]|din_s1}]
set_false_path -no_synchronizer -to $dr_f_src_desired_state_col_fp
