// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



`ifndef FTILE_TOP_PATH
`define QUARTUS_TOP_LEVEL_ENTITY_SRC_INSTANCE_PATH dr_f_top_auto_tiles.z1577a_x0_y0_n0
`else
`define QUARTUS_TOP_LEVEL_ENTITY_SRC_INSTANCE_PATH `FTILE_TOP_PATH
`endif

//Temporary for SIP Lint/CDC
(* dr_ip *)
module dr_f_dr_f_800_5d2okvq #(
    parameter silicon_revision  = "10nm8agdrb",
    parameter device_revision   = "10nm8agdrb",
    parameter bb_placeholder    = "dontcare",
    parameter INIT_FILE         = "dr_f_cpu_ctrl_dmem.hex",
    parameter XCVR_TYPE_SIP     = 0,
    parameter avmm_data_width   = 32,
    parameter avmm_addr_width   = 26
) (
    // User interface clocks and reset
    input   logic                            i_csr_clk,
    input   logic                            i_cpu_clk, // NIOS_EN
    input   logic                            i_rst_n,

    //User Interface control/status
    output  logic   [14:0]                   o_dr_curr_profile_id,
    output  logic                            o_dr_new_cfg_applied, 
    input   logic                            i_dr_new_cfg_applied_ack, 
    output  logic                            o_dr_in_progress,
    output  logic                            o_dr_fast_sim_clk_sel,
    output  logic                            o_dr_error_status,
    output  logic   [767:0]                  o_dr_ip_1hot_selector,
    // NIOS II Debug PIO ports
    input   logic   [31:0]                   i_dr_cpu_c4_debug,             
    input   logic   [31:0]                   i_dr_cpu_c5_debug, 
    output  logic   [31:0]                   o_dr_cpu_s4_debug,           
    output  logic   [31:0]                   o_dr_cpu_s5_debug,
 
    // Master 1 (Host user/software interface)
    input   logic   [avmm_data_width-1:0]    i_dr_host_avmm_writedata,
    input   logic                            i_dr_host_avmm_read,
    input   logic   [9:0]                    i_dr_host_avmm_address,
    input   logic                            i_dr_host_avmm_write,
    output  logic   [avmm_data_width-1:0]    o_dr_host_avmm_readdata,
    output  logic                            o_dr_host_avmm_waitrequest,
    output  logic                            o_dr_host_avmm_readdata_valid
);

//-----------------------------------------------------------------------------
//Declarations
//-----------------------------------------------------------------------------

    // DR AIB MUX selection for profile
    //logic   [767:0]         o_dr_ip_1hot_selector;
 
    // MUX selector to take over control of SRC interface from SIP's 
    //logic   [31:0]          dr_tx_soft_mux_sel;  
    //logic   [31:0]          dr_rx_soft_mux_sel;
    
    // logical lane numbers are [31:20] reserved [19:4] ux [3:0] barak
    //logic  [31:0]           dr_tx_lane_desired_state;     // 0:operate  1:reset
            // note that initial reset is implied, hard wiring this
            // to 0 completely appropriate. If forced off a lock
            // (e.g. cable pull) the system will signal an alarm and
            // attempt self-recovery
    //logic  [31-1:0][2:0]    dr_tx_lane_current_state;
                        // 000 - in a transitional state
                        // 001 - in the full reset state
                        // 010 - in the normal operational state
    //logic  [31:0]           dr_tx_alarm;
    //logic  [31:0]           dr_tx_clear_alarm;
    //logic  [31:0]           dr_rx_lane_desired_state;     // 0:operate  1:reset
    //logic  [31-1:0][2:0]    dr_rx_lane_current_state;
                        // 000 - in a transitional state
                        // 001 - in the full reset state
                        // 010 - in the normal operational state
    //logic   [31:0]          dr_rx_alarm;
    //logic   [31:0]          dr_rx_clear_alarm;
    //logic   [31:0]          dr_sip_am_gen_start;
    //logic   [31:0]          dr_sip_am_gen_2x_ack;

    // SRC Reconfiguration Control Interface
    logic                   pause_request;  // req=1 until grant=1 to pause reset service
    logic                   pause_grant;    // if necessary to dynamically edit grouping info for example
    // SRC Memory Reconfiguration Interface 
    logic                   src_clk;
    logic   [15:0]          group_ram_addr;
    logic                   group_ram_we;
    logic   [31:0]          group_ram_wdata;
    logic   [31:0]          group_ram_rdata;

    // AVMM2/Global AVMM ports to/from hip
    logic                   hip_avmm_read_real;
    logic   [7:0]           hip_avmm_readdata_real;
    logic                   hip_avmm_readdatavalid_real;
    logic   [20:0]          hip_avmm_reg_addr_real;
    logic   [4:0]           hip_avmm_reserved_out_real;
    logic                   hip_avmm_write_real;
    logic   [7:0]           hip_avmm_writedata_real;
    logic                   hip_avmm_writedone_real;
    logic                   pld_avmm2_busy_real;
    logic                   pld_avmm2_clk_rowclk_real;
    logic                   pld_avmm2_cmdfifo_wr_full_real;
    logic                   pld_avmm2_cmdfifo_wr_pfull_real;
    logic                   pld_avmm2_request_real;
    logic                   pld_pll_cal_done_real;
    logic                   pld_avmm2_write_real;
    logic                   pld_avmm2_read_real;
    logic   [8:0]           pld_avmm2_reg_addr_real;
    logic   [7:0]           pld_avmm2_readdata_real;
    logic   [7:0]           pld_avmm2_writedata_real;
    logic                   pld_avmm2_readdatavalid_real;
    logic   [5:0]           pld_avmm2_reserved_in_real;
    logic                   pld_avmm2_reserved_out_real;

    // Master 0 (DR Controller - NIOS subsystem interface)
    logic   [31:0]          dr_cpu_avmm_writedata;
    logic                   dr_cpu_avmm_read;
    logic   [31:0]          dr_cpu_avmm_address;
    logic                   dr_cpu_avmm_write;
    logic   [31:0]          dr_cpu_avmm_readdata;
    logic                   dr_cpu_avmm_waitrequest;
    logic                   dr_cpu_avmm_readdata_valid;

    // DR Controller (NIOS) interface control/status
    logic                   dr_trigger_intr;
    logic                   dr_trigger_intr_ack;
    logic                   dr_cpu_new_cfg_applied_sync;
    logic                   dr_cpu_new_cfg_applied_ack;

    logic   [21:0]          dr_cpu_s1_reserved;
    logic   [30:0]          dr_cpu_s6_reserved;
    logic   [30:0]          dr_cpu_s7_reserved;
    logic                   dr_f_cpu_avmmif_m1_burstcount;
    logic   [3:0]           dr_f_cpu_avmmif_m1_byteenable;
    logic                   dr_f_cpu_avmmif_m1_debugaccess;

   logic    [23:0]          pld_avmm1_busy;
   logic    [23:0]          pld_avmm1_clk_rowclk;
   logic    [23:0]          pld_avmm1_cmdfifo_wr_full;
   logic    [23:0]          pld_avmm1_cmdfifo_wr_pfull;
   logic    [23:0]          pld_avmm1_read;
   logic    [(24*8)-1:0]    pld_avmm1_readdata;
   logic    [23:0]          pld_avmm1_readdatavalid;
   logic    [(24*10)-1:0]   pld_avmm1_reg_addr;
   logic    [23:0]          pld_avmm1_request;
   logic    [(24*9)-1:0]    pld_avmm1_reserved_in;
   logic    [(24*3)-1:0]    pld_avmm1_reserved_out;
   logic    [23:0]          pld_avmm1_write;
   logic    [(24*8)-1:0]    pld_avmm1_writedata;
   logic    [23:0]          pld_hssi_osc_transfer_en;
   
//-----------------------------------------------------------------------------
// Instantiation of DR SIP interface block
//-----------------------------------------------------------------------------
    dr_f_sip #(
       .DWIDTH  (avmm_data_width),
       .AWIDTH  (avmm_addr_width)
    ) dr_ctrl_sip_inst (
       .csr_clk                          (i_csr_clk),
       .rst_n                            (i_rst_n),
    
       //User Interface status
       .o_dr_curr_profile_id             (o_dr_curr_profile_id),
       .o_dr_new_cfg_applied             (o_dr_new_cfg_applied), 
       .i_dr_new_cfg_applied_ack         (i_dr_new_cfg_applied_ack), 
       .o_dr_in_progress                 (o_dr_in_progress),
       .o_dr_error_status                (o_dr_error_status),
       
       // DR Controller (NIOS) interface control/status
       .o_dr_trigger_intr                (dr_trigger_intr),
       .i_dr_trigger_intr_ack            (dr_trigger_intr_ack),
       .i_dr_cpu_new_cfg_applied         (dr_cpu_new_cfg_applied_sync),
       .o_dr_cpu_new_cfg_applied_ack     (dr_cpu_new_cfg_applied_ack),

       // DR AIB MUX selection for profile - Interface to Top Tile
       .o_dr_ip_1hot_selector            (o_dr_ip_1hot_selector),
       
       // SRC Reconfiguration Control Interface - Interface to Top Tile
`ifdef DR_SIP_WITH_DR_SRC_MUX_MANUAL_INTC
       .dr_tx_soft_mux_sel         (),
       .dr_tx_lane_desired_state       (),        
       .dr_tx_lane_current_state       ({32{3'b000}}),       
       .dr_tx_alarm                    (32'h0),
       .dr_tx_clear_alarm              (),
       .dr_rx_soft_mux_sel             (),
       .dr_rx_lane_desired_state       (),    
       .dr_rx_lane_current_state       ({32{3'b000}}),
       .dr_rx_alarm                    (32'h0),
       .dr_rx_clear_alarm              (),
       .dr_sip_am_gen_start            (32'h0),
       .dr_sip_am_gen_2x_ack           (),
       .dr_sip_pcs_rx_sf               (32'h0),
       .dr_sip_rx_pcs_fully_aligned    (32'h0),
       .dr_sip_ehip_signal_ok          (),
       .dr_sip_rx_ignore_lock2data     (),
       .dr_sip_freeze_tx_src           (),
       .dr_sip_freeze_rx_src           (),
       .dr_sip_freeze_tx_src_ack       (32'h0),
       .dr_sip_freeze_rx_src_ack       (32'h0),
       .dr_i_dphy_iflux_ingress_input  (),
       .dr_sip_lavmm1_block_req        (),
       .dr_sip_lavmm1_block_ack        (),
`endif
       // SRC AVMM Reconfiguration Interface - Interface to Top Tile
`ifdef DR_SIP_WITH_DR_SRC_MEM_MANUAL_INTC
       .src_clk                          (src_clk),
       .pause_request                    (pause_request), 
       .pause_grant                      (pause_grant),
       .group_ram_addr                   (group_ram_addr),
       .group_ram_we                     (group_ram_we),
       .group_ram_wdata                  (group_ram_wdata),
       .group_ram_rdata                  (group_ram_rdata),
`endif
       // Master 0
       .i_dr_cpu_avmm_read               (dr_cpu_avmm_read),
       .i_dr_cpu_avmm_write              (dr_cpu_avmm_write),
       .i_dr_cpu_avmm_address            (dr_cpu_avmm_address[25:0]),
       .i_dr_cpu_avmm_writedata          (dr_cpu_avmm_writedata),
       .o_dr_cpu_avmm_readdata           (dr_cpu_avmm_readdata),
       .o_dr_cpu_avmm_readdata_valid     (dr_cpu_avmm_readdata_valid),
       .o_dr_cpu_avmm_waitrequest        (dr_cpu_avmm_waitrequest),

       // Master 1
       .i_dr_host_avmm_read              (i_dr_host_avmm_read),
       .i_dr_host_avmm_write             (i_dr_host_avmm_write),
       .i_dr_host_avmm_address           ({16'h0000,i_dr_host_avmm_address}),
       .i_dr_host_avmm_writedata         (i_dr_host_avmm_writedata),
       .o_dr_host_avmm_readdata          (o_dr_host_avmm_readdata),
       .o_dr_host_avmm_readdata_valid    (o_dr_host_avmm_readdata_valid),
       .o_dr_host_avmm_waitrequest       (o_dr_host_avmm_waitrequest),
       // AVMM2/Global AVMM interface ports
       .pld_avmm2_clk_rowclk_real        (pld_avmm2_clk_rowclk_real),
       .hip_avmm_read_real               (hip_avmm_read_real),
       .hip_avmm_readdata_real           (hip_avmm_readdata_real),
       .hip_avmm_readdatavalid_real      (hip_avmm_readdatavalid_real),
       .hip_avmm_reg_addr_real           (hip_avmm_reg_addr_real),
       .hip_avmm_write_real              (hip_avmm_write_real),
       .hip_avmm_writedata_real          (hip_avmm_writedata_real),
       .hip_avmm_writedone_real          (hip_avmm_writedone_real),
       .pld_avmm2_busy_real              (pld_avmm2_busy_real),
       .pld_avmm2_cmdfifo_wr_full_real   (pld_avmm2_cmdfifo_wr_full_real),
       .hip_avmm_reserved_out_real       (hip_avmm_reserved_out_real),
       .pld_avmm2_cmdfifo_wr_pfull_real  (pld_avmm2_cmdfifo_wr_pfull_real),
       .pld_avmm2_request_real           (pld_avmm2_request_real),
       .pld_pll_cal_done_real            (pld_pll_cal_done_real),
       .pld_avmm2_write_real             (pld_avmm2_write_real),
       .pld_avmm2_read_real              (pld_avmm2_read_real),
       .pld_avmm2_reg_addr_real          (pld_avmm2_reg_addr_real),
       .pld_avmm2_readdata_real          (pld_avmm2_readdata_real),
       .pld_avmm2_writedata_real         (pld_avmm2_writedata_real),
       .pld_avmm2_readdatavalid_real     (pld_avmm2_readdatavalid_real),
       .pld_avmm2_reserved_in_real       (pld_avmm2_reserved_in_real),
       .pld_avmm2_reserved_out_real      (pld_avmm2_reserved_out_real),
       // AVMM1/MAIB AVMM interface ports
       .pld_avmm1_busy                   (pld_avmm1_busy),
       .pld_avmm1_clk_rowclk             (pld_avmm1_clk_rowclk),
       .pld_avmm1_cmdfifo_wr_full        (pld_avmm1_cmdfifo_wr_full),
       .pld_avmm1_cmdfifo_wr_pfull       (pld_avmm1_cmdfifo_wr_pfull),
       .pld_avmm1_read                   (pld_avmm1_read),
       .pld_avmm1_readdata               (pld_avmm1_readdata),
       .pld_avmm1_readdatavalid          (pld_avmm1_readdatavalid),
       .pld_avmm1_reg_addr               (pld_avmm1_reg_addr),
       .pld_avmm1_request                (pld_avmm1_request),
       .pld_avmm1_reserved_in            (pld_avmm1_reserved_in),
       .pld_avmm1_reserved_out           (pld_avmm1_reserved_out),
       .pld_avmm1_write                  (pld_avmm1_write),
       .pld_avmm1_writedata              (pld_avmm1_writedata),
       .pld_chnl_cal_done                ({24{1'b0}}),
       .pld_hssi_osc_transfer_en         (pld_hssi_osc_transfer_en)
    ); //dr_ctrl_sip_inst


//-----------------------------------------------------------------------------
// Instantiation of DR HIP interface block
//-----------------------------------------------------------------------------
`ifndef DR_SIP_ONLY
(* tile_ip_hip *)  dr_f_hip #(
       .bb_silicon_rev (silicon_revision)
    ) dr_ctrl_hip_inst (
       // AVMM2/Global AVMM interface ports
       .pld_avmm2_clk_rowclk_real        (pld_avmm2_clk_rowclk_real),
       .hip_avmm_read_real               (hip_avmm_read_real),
       .hip_avmm_readdata_real           (hip_avmm_readdata_real),
       .hip_avmm_readdatavalid_real      (hip_avmm_readdatavalid_real),
       .hip_avmm_reg_addr_real           (hip_avmm_reg_addr_real),
       .hip_avmm_write_real              (hip_avmm_write_real),
       .hip_avmm_writedata_real          (hip_avmm_writedata_real),
       .hip_avmm_writedone_real          (hip_avmm_writedone_real),
       .pld_avmm2_busy_real              (pld_avmm2_busy_real),
       .pld_avmm2_cmdfifo_wr_full_real   (pld_avmm2_cmdfifo_wr_full_real),
       .hip_avmm_reserved_out_real       (hip_avmm_reserved_out_real),
       .pld_avmm2_cmdfifo_wr_pfull_real  (pld_avmm2_cmdfifo_wr_pfull_real),
       .pld_avmm2_request_real           (pld_avmm2_request_real),
       .pld_pll_cal_done_real            (pld_pll_cal_done_real),
       .pld_avmm2_write_real             (pld_avmm2_write_real),
       .pld_avmm2_read_real              (pld_avmm2_read_real),
       .pld_avmm2_reg_addr_real          (pld_avmm2_reg_addr_real),
       .pld_avmm2_readdata_real          (pld_avmm2_readdata_real),
       .pld_avmm2_writedata_real         (pld_avmm2_writedata_real),
       .pld_avmm2_readdatavalid_real     (pld_avmm2_readdatavalid_real),
       .pld_avmm2_reserved_in_real       (pld_avmm2_reserved_in_real),
       .pld_avmm2_reserved_out_real      (pld_avmm2_reserved_out_real),
       // AVMM1/MAIB AVMM interface ports
       .pld_avmm1_busy                   (pld_avmm1_busy),
       .pld_avmm1_clk_rowclk             (pld_avmm1_clk_rowclk),
       .pld_avmm1_cmdfifo_wr_full        (pld_avmm1_cmdfifo_wr_full),
       .pld_avmm1_cmdfifo_wr_pfull       (pld_avmm1_cmdfifo_wr_pfull),
       .pld_avmm1_read                   (pld_avmm1_read),
       .pld_avmm1_readdata               (pld_avmm1_readdata),
       .pld_avmm1_readdatavalid          (pld_avmm1_readdatavalid),
       .pld_avmm1_reg_addr               (pld_avmm1_reg_addr),
       .pld_avmm1_request                (pld_avmm1_request),
       .pld_avmm1_reserved_in            (pld_avmm1_reserved_in),
       .pld_avmm1_reserved_out           (pld_avmm1_reserved_out),
       .pld_avmm1_write                  (pld_avmm1_write),
       .pld_avmm1_writedata              (pld_avmm1_writedata),
       .pld_hssi_osc_transfer_en         (pld_hssi_osc_transfer_en)
    ); //dr_ctrl_hip_inst 
    

/////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////// Manual connections between SRC and DR SIP /////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////
`ifdef DR_SIP_WITH_DR_SRC_MEM_MANUAL_INTC
//the ifndef blocks below excludes the below SRC<->XMR connections during QTLG step and 
//later includes them during Synthesis or Simulation after XMR is generated 
//ALTERA_RESERVED_QIS_QUICK_ELAB_MODE - Defined only during Quick Synthesis step of QTLG
`ifndef ALTERA_RESERVED_QIS_QUICK_ELAB_MODE

//__TILE_IP__ - Defined only during Tile IP Generation step of QTLG
`ifndef __TILE_IP__

    `define src_dr_if_src_clk         _src_dr_if_src_clk
    `define src_dr_if_pause_request   _src_dr_if_pause_request
    `define src_dr_if_pause_grant     _src_dr_if_pause_grant
    `define src_dr_if_group_ram_addr  _src_dr_if_group_ram_addr
    `define src_dr_if_group_ram_we    _src_dr_if_group_ram_we
    `define src_dr_if_group_ram_wdata _src_dr_if_group_ram_wdata
    `define src_dr_if_group_ram_rdata _src_dr_if_group_ram_rdata

    `define SRC_INSTANCE_PATH_src_dr_if_src_clk         `QUARTUS_TOP_LEVEL_ENTITY_SRC_INSTANCE_PATH```src_dr_if_src_clk
    `define SRC_INSTANCE_PATH_src_dr_if_pause_request   `QUARTUS_TOP_LEVEL_ENTITY_SRC_INSTANCE_PATH```src_dr_if_pause_request
    `define SRC_INSTANCE_PATH_src_dr_if_pause_grant     `QUARTUS_TOP_LEVEL_ENTITY_SRC_INSTANCE_PATH```src_dr_if_pause_grant
    `define SRC_INSTANCE_PATH_src_dr_if_group_ram_addr  `QUARTUS_TOP_LEVEL_ENTITY_SRC_INSTANCE_PATH```src_dr_if_group_ram_addr
    `define SRC_INSTANCE_PATH_src_dr_if_group_ram_we    `QUARTUS_TOP_LEVEL_ENTITY_SRC_INSTANCE_PATH```src_dr_if_group_ram_we
    `define SRC_INSTANCE_PATH_src_dr_if_group_ram_wdata `QUARTUS_TOP_LEVEL_ENTITY_SRC_INSTANCE_PATH```src_dr_if_group_ram_wdata
    `define SRC_INSTANCE_PATH_src_dr_if_group_ram_rdata `QUARTUS_TOP_LEVEL_ENTITY_SRC_INSTANCE_PATH```src_dr_if_group_ram_rdata
    
    assign  src_clk = `SRC_INSTANCE_PATH_src_dr_if_src_clk;
    assign  `SRC_INSTANCE_PATH_src_dr_if_pause_request = pause_request; 
    assign  pause_grant = `SRC_INSTANCE_PATH_src_dr_if_pause_grant; 
    assign  `SRC_INSTANCE_PATH_src_dr_if_group_ram_addr = group_ram_addr;
    assign  `SRC_INSTANCE_PATH_src_dr_if_group_ram_we = group_ram_we; 
    assign  `SRC_INSTANCE_PATH_src_dr_if_group_ram_wdata = group_ram_wdata;
    assign  group_ram_rdata = `SRC_INSTANCE_PATH_src_dr_if_group_ram_rdata; 

`endif
`endif
`endif
`endif


//-----------------------------------------------------------------------------
// Syncronization of Async reset with DR CSR clock
//-----------------------------------------------------------------------------
    logic cpu_rst_sync;
    dr_f_altera_std_synchronizer_nocut #(
                    .depth(3),
                    .rst_value(1'b1)
         )  cpu_rst_sync_inst  (
                    .clk(i_cpu_clk),
                    .reset_n(i_rst_n),
                    .din(1'b0),
                    .dout(cpu_rst_sync)
    );

    logic dr_cpu_new_cfg_applied;
    dr_f_xcvr_resync_std #(
        .SYNC_CHAIN_LENGTH  (3),
        .WIDTH              (1),
        .INIT_VALUE         (0)
    ) dr_cpu_new_cfg_applied_sync_inst (
        .clk                (i_csr_clk),
        .reset              (1'b0),
        .d                  (dr_cpu_new_cfg_applied),
        .q                  (dr_cpu_new_cfg_applied_sync)
    );

//-----------------------------------------------------------------------------
// Instantiation of DR Controller (NIOS Subsystem) interface block
//-----------------------------------------------------------------------------
    
    dr_f_cpu_ctrl #(
       .DMEM_INIT_FILE (INIT_FILE) 
    ) dr_cpu_ctrl_inst (
       .clk_clk                          (i_cpu_clk),           
       .reset_reset                      (cpu_rst_sync),
       .i_dr_cpu_c1_export               ({30'h0,dr_cpu_new_cfg_applied_ack,dr_trigger_intr}),               
       .i_dr_cpu_c2_export               (32'h2),              
       .i_dr_cpu_c3_export               (32'h3),          
       .i_dr_cpu_c4_export               (i_dr_cpu_c4_debug),             
       .i_dr_cpu_c5_export               (i_dr_cpu_c5_debug),            
       .i_dr_cpu_c6_export               ({26'h0,dr_f_cpu_avmmif_m1_debugaccess,dr_f_cpu_avmmif_m1_byteenable,dr_f_cpu_avmmif_m1_burstcount}), 
       .dr_f_cpu_avmmif_m1_clk_clk       (i_csr_clk),   
       .dr_f_cpu_avmmif_m1_rst_reset     (~i_rst_n), 
       .dr_f_cpu_avmmif_m1_waitrequest   (dr_cpu_avmm_waitrequest),   
       .dr_f_cpu_avmmif_m1_readdata      (dr_cpu_avmm_readdata),   
       .dr_f_cpu_avmmif_m1_readdatavalid (dr_cpu_avmm_readdata_valid),
       .dr_f_cpu_avmmif_m1_burstcount    (dr_f_cpu_avmmif_m1_burstcount),                          
       .dr_f_cpu_avmmif_m1_writedata     (dr_cpu_avmm_writedata),    
       .dr_f_cpu_avmmif_m1_address       (dr_cpu_avmm_address[19:0]), 
       .dr_f_cpu_avmmif_m1_write         (dr_cpu_avmm_write),        
       .dr_f_cpu_avmmif_m1_read          (dr_cpu_avmm_read),         
       .dr_f_cpu_avmmif_m1_byteenable    (dr_f_cpu_avmmif_m1_byteenable),                        
       .dr_f_cpu_avmmif_m1_debugaccess   (dr_f_cpu_avmmif_m1_debugaccess),                        
       .o_dr_cpu_s1_export               ({dr_cpu_avmm_address[31:20],dr_cpu_s1_reserved[19:0]}),            
       .o_dr_cpu_s2_export               (),               
       .o_dr_cpu_s3_export               (),           
       .o_dr_cpu_s4_export               (o_dr_cpu_s4_debug),           
       .o_dr_cpu_s5_export               (o_dr_cpu_s5_debug),               
       .o_dr_cpu_s6_export               ({dr_cpu_s6_reserved[30:0],dr_cpu_new_cfg_applied}),    
       .o_dr_cpu_s7_export               ({dr_cpu_s7_reserved[30:0],dr_trigger_intr_ack})                         
    );

assign o_dr_fast_sim_clk_sel = o_dr_in_progress && !(dr_cpu_avmm_waitrequest && (dr_cpu_avmm_write || dr_cpu_avmm_read));

endmodule //DR_F_TOP

