// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps
// baeckler - 01-20-2010
// weak meta hardening intended for low toggle rate / low priority status signals

module dr_f_multibit_sync #(
	parameter WIDTH = 32
)(
	input clk,
	input reset_n,
	input [WIDTH-1:0] din,
	output [WIDTH-1:0] dout
);

generate
genvar i;
for (i=0; i<WIDTH; i=i+1)
begin : sync
           dr_f_altera_std_synchronizer_nocut #(
                .depth(3),
                .rst_value({WIDTH{1'b0}})
            )  dr_synchronizer_nocut_inst  (
                .clk(clk),
                .reset_n(reset_n),
                .din(din[i]),
                .dout(dout[i])
            );
end
endgenerate

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "79ztKTnV2ny/eHpgZYepe9G9wwwdeg9hTOdIyLdh4JTuZZ1DT50cJOPNpZ0w+c5aVHkra3Tx9+PMlDB4omAPannbtZoJG9ZekMCcgtPHzQ4GWiJfmhYoHZqap4yb9/uKlHSl9TpAcV1FKEwkrctIKziGBKSQ0S70p/jW9wD4CtM3X7P+ggV0x7Prg108lDSsdB1kGvgcQN/5kLCIPO6i12claBXdWuhbdU7Bm3JHKTrXaUwqCVuEcdUzWVnOn3q25czL1unfnu8wpolHpDg2GsREvo5f7HjgiU9qj7Gvo+k2S7qNiDwzSlSQx4zYfula/69xtMXIV6IUweXl6G//9UoT1mvSJ6SFES76tq/Gh3AbabB/8Et8vAnSXKRFfhLrbRQorl9w6hBuJbi8dGguljnLbFVa8OnBsA3zBwfJ1LkKpBR5O9EQSymt0e8lDXAAdB44fuL61ChGhEOxtpstMb6LVEbuB5KrjLnxkhsLQuZd910onG+hgOOtpLK+CHsh988P4tbvppjE7v/aVQW5yJXUG5WqVHLWxznbBnJKHVjpaEu5yims/buozRHkrNkqEvezAK1cuJPa8uWxL5B2dV7BFQE5yeJIG5DC/B13m4FVt6riEOG6RNOOwcoU+KQdNINz/nvyC1OokBdmczTdXuFVK2PuDX/uChdiFLCoBdRl7T215y0qCFiJhbdRVGXchd14e6XwAzvf+EikiySqMiYoqS+sBc2Stx7YxLcXUSu0VXKWdz/zmRyMpfUN+W3xz2+q5T2re/Pfc94B3oaxCOogdGJwfB7u8Pc9aFslnb4nXmYkU7a7yYjiLGAkgLyIlqnwXNg1QDpdp0nxgrK6ZlgD1md5uraARXmKJrb5e/32IhBD67CaVyF0Iqs8NhGBwaJe6NNfPOjGJHLRlmylyy+l+Tk9n9VeYh3h5vUk2H/2zkQMRcMk3FSnaeww9MgFQB/bB5hmf3WqXbWMp6BYDYER7xUJsowQ0M70SONR9AhgZpBvCTElEvo+vXH62H73"
`endif