// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


//----------------------------------------------------------------------------- 
//  Project Name:  GDR Dynamic Reconfiguration (F-tile)                                  
//  Module Name :  dr_f_mux_decoder                                  
//  Author ID   :  hafeezmu                                   
//  Date        :  Tue Feb 18 15:18:57 2020   
//  Version     :  v1.0 (Initial Draft)                               
//  Description :  GDR DR decoder for one hot selection for scalable mux for F-tile.   
//                 This component is part of DR SIP. This DR multiplexer decoder  
//                 is used between DR MUX and and DR CSR selection space.                                             
//-----------------------------------------------------------------------------  

module dr_f_mux_decoder #(
    parameter int unsigned SWIDTH       = 6,               // MUX selection width 
    parameter int unsigned S_CHANNELS   = 24,              // Number of MAIB channels 
    parameter int unsigned MUX_SWIDTH   = (2 ** SWIDTH),   // Number of one-hot mux select bits default 5to32 decoder
    parameter int unsigned PIPELINE_EN  = 0                // To add pipeline stages for better timing (limitation upto 1)
)
(
    input   logic                                  csr_clk,
    input   logic                                  rst_n,

    input   logic [S_CHANNELS-1:0][SWIDTH-1:0]     i_dr_profile_sel,

    output  logic [S_CHANNELS-1:0][MUX_SWIDTH-1:0] o_dr_profile_1hot_sel
);

//-----------------------------------------------------------------------------
//Declarations
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//Main Body of Code
//-----------------------------------------------------------------------------

    // Scalable DECODER 
    always @ (posedge csr_clk) begin: DR_MUX_SEL_DECODER
      if (!rst_n) begin
        for (int unsigned i = 0; i < S_CHANNELS; i = i+1) begin
          o_dr_profile_1hot_sel[i] <= {MUX_SWIDTH{1'b0}};
        end
      end
      else begin
        for (int unsigned i = 0; i < S_CHANNELS; i = i+1) begin
         o_dr_profile_1hot_sel[i] <= {MUX_SWIDTH{1'b0}} | 1<<i_dr_profile_sel[i];
        end
      end
    end: DR_MUX_SEL_DECODER

endmodule //DR_F_MUX_DECODER

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "wuj6SUN+CWUHl7X/28Op4/b/clpjqbLY1GA2Z3hIF6AQ/N7zu6Fwoye5cSVZtCMjzq7zVIP70Vz25qwBBwoIUIbppOYuSWAZCOtwfVezNqtYswQ62n/3Hi6fWGVfeSbJS3aJs8eFyk/7NahU2OTeak7iTUPHQndN4oB5O1gSp87DXZC4zl72BeNdhBCD27/XMw5oUpTkQ1qs22Ma/P0Qj3KuL2yUnt0fdnpvUGYwRExc4dVcbUXljCV/2jDkODIv+j1gn2eOARa7iv56Tbd6dDqNnnYYFH4nT07zGxbg4z48irlxp4B/n7BCHevIq6H4hn12K7HKy1mdyPg6ILFnHdlnSN1YVjA6IMXs9pGJGh6ce0ZsTPTNv7/FHcMObJqbSWyC8rFJnIfyScecyiBApS6R6CTdTtK8ySINZ4qii0R91RCqE46cbifqoMrBzWbv5OCOgl5qvK4DSzoRDj0sf5rMR0MsF7Sv3Arof1qZN942YIdnyYY+8Ny5ad/ujkV0haABA0TdLqlT/7rmV6MxMgnV/VviveqQwJCcna1LjO4yx2kHrfXAFJGxti4IPvrmP/l2ufCGHjxu+FcMBg49jXtit/huKSBnatpoGq+i7qw2/Q2tG0VF6hrfACLOlt9e+JfNA7cCJ4rT8ZB6OmgKNOjzwEQF2/n/NDqtS3/ol1EBD5rySotxL4E4qO0GQhfTJm6IJxn75XUolZHwwQG6To6HplGKKQtOhHCj6GIhgfZH7lZ0/FL1zcj0bmdCpjJT0t2TmRVIl4xUz8K2bk6I9SKzRu1WJbyf4sVOUPkgDInfIND6//btoKD8iJzjg/ZgJneQ+AU7MyWtgWkrPINObDOcw9JEIbS0hJxnWjO7fcngLVJ94L6HDmJtMCw83jRqsaOOpy/VCtRaxts+itGyEpXU/XbxcrN/GBG9cNle3irPsec0BCO6w/1ipyb7HVAFA6MJXinc3GzmFEEZZpOXDQlNWy7V2wwRbRylmI4p4VjZvHK1ZctrhUTSAot+7l7I"
`endif