module dr_f (
		input  wire        i_csr_clk,                     //                i_csr_clk.clk,                      Reconfiguration clock
		input  wire        i_cpu_clk,                     //                i_cpu_clk.clk,                      CPU clock
		input  wire        i_rst_n,                       //                  i_rst_n.reset_n,                  Async Reconfig reset
		output wire [14:0] o_dr_curr_profile_id,          //     o_dr_curr_profile_id.o_dr_curr_profile_id,     Current Profile ID
		output wire        o_dr_new_cfg_applied,          //     o_dr_new_cfg_applied.o_dr_new_cfg_applied,     New Configuration applied settings status
		input  wire        i_dr_new_cfg_applied_ack,      // i_dr_new_cfg_applied_ack.i_dr_new_cfg_applied_ack, New Configuration applied settings acknowledge from Host
		output wire        o_dr_in_progress,              //         o_dr_in_progress.o_dr_in_progress,         Overall DR switching status
		output wire        o_dr_fast_sim_clk_sel,         //    o_dr_fast_sim_clk_sel.o_dr_fast_sim_clk_sel,    cpu_clk_sel for optional simulatio speedup
		output wire        o_dr_error_status,             //        o_dr_error_status.o_dr_error_status,        Overall DR SIP and firmware error status out
		input  wire [9:0]  i_dr_host_avmm_address,        //      host_reconfig_slave.address,                  Address for DR CSRs
		output wire        o_dr_host_avmm_readdata_valid, //                         .readdatavalid,            Read data from DR CSRs is valid
		input  wire        i_dr_host_avmm_read,           //                         .read,                     Read command for DR CSRs
		input  wire        i_dr_host_avmm_write,          //                         .write,                    Write command for DR CSRs
		output wire [31:0] o_dr_host_avmm_readdata,       //                         .readdata,                 Read data from reads to DR CSRs
		input  wire [31:0] i_dr_host_avmm_writedata,      //                         .writedata,                Data for writes to DR CSRs
		output wire        o_dr_host_avmm_waitrequest     //                         .waitrequest,              AVMM stall signal for operation on DR CSRs
	);
endmodule

