	component dr_f is
		port (
			i_csr_clk                     : in  std_logic                     := 'X';             -- clk
			i_cpu_clk                     : in  std_logic                     := 'X';             -- clk
			i_rst_n                       : in  std_logic                     := 'X';             -- reset_n
			o_dr_curr_profile_id          : out std_logic_vector(14 downto 0);                    -- o_dr_curr_profile_id
			o_dr_new_cfg_applied          : out std_logic;                                        -- o_dr_new_cfg_applied
			i_dr_new_cfg_applied_ack      : in  std_logic                     := 'X';             -- i_dr_new_cfg_applied_ack
			o_dr_in_progress              : out std_logic;                                        -- o_dr_in_progress
			o_dr_fast_sim_clk_sel         : out std_logic;                                        -- o_dr_fast_sim_clk_sel
			o_dr_error_status             : out std_logic;                                        -- o_dr_error_status
			i_dr_host_avmm_address        : in  std_logic_vector(9 downto 0)  := (others => 'X'); -- address
			o_dr_host_avmm_readdata_valid : out std_logic;                                        -- readdatavalid
			i_dr_host_avmm_read           : in  std_logic                     := 'X';             -- read
			i_dr_host_avmm_write          : in  std_logic                     := 'X';             -- write
			o_dr_host_avmm_readdata       : out std_logic_vector(31 downto 0);                    -- readdata
			i_dr_host_avmm_writedata      : in  std_logic_vector(31 downto 0) := (others => 'X'); -- writedata
			o_dr_host_avmm_waitrequest    : out std_logic                                         -- waitrequest
		);
	end component dr_f;

	u0 : component dr_f
		port map (
			i_csr_clk                     => CONNECTED_TO_i_csr_clk,                     --                i_csr_clk.clk
			i_cpu_clk                     => CONNECTED_TO_i_cpu_clk,                     --                i_cpu_clk.clk
			i_rst_n                       => CONNECTED_TO_i_rst_n,                       --                  i_rst_n.reset_n
			o_dr_curr_profile_id          => CONNECTED_TO_o_dr_curr_profile_id,          --     o_dr_curr_profile_id.o_dr_curr_profile_id
			o_dr_new_cfg_applied          => CONNECTED_TO_o_dr_new_cfg_applied,          --     o_dr_new_cfg_applied.o_dr_new_cfg_applied
			i_dr_new_cfg_applied_ack      => CONNECTED_TO_i_dr_new_cfg_applied_ack,      -- i_dr_new_cfg_applied_ack.i_dr_new_cfg_applied_ack
			o_dr_in_progress              => CONNECTED_TO_o_dr_in_progress,              --         o_dr_in_progress.o_dr_in_progress
			o_dr_fast_sim_clk_sel         => CONNECTED_TO_o_dr_fast_sim_clk_sel,         --    o_dr_fast_sim_clk_sel.o_dr_fast_sim_clk_sel
			o_dr_error_status             => CONNECTED_TO_o_dr_error_status,             --        o_dr_error_status.o_dr_error_status
			i_dr_host_avmm_address        => CONNECTED_TO_i_dr_host_avmm_address,        --      host_reconfig_slave.address
			o_dr_host_avmm_readdata_valid => CONNECTED_TO_o_dr_host_avmm_readdata_valid, --                         .readdatavalid
			i_dr_host_avmm_read           => CONNECTED_TO_i_dr_host_avmm_read,           --                         .read
			i_dr_host_avmm_write          => CONNECTED_TO_i_dr_host_avmm_write,          --                         .write
			o_dr_host_avmm_readdata       => CONNECTED_TO_o_dr_host_avmm_readdata,       --                         .readdata
			i_dr_host_avmm_writedata      => CONNECTED_TO_i_dr_host_avmm_writedata,      --                         .writedata
			o_dr_host_avmm_waitrequest    => CONNECTED_TO_o_dr_host_avmm_waitrequest     --                         .waitrequest
		);

