// dr_f_mm_ccb_st_dc_fifo_1921_zm7cluy.v

// Generated using ACDS version 23.4 79

`timescale 1 ps / 1 ps
module dr_f_mm_ccb_st_dc_fifo_1921_zm7cluy #(
		parameter SYMBOLS_PER_BEAT          = 1,
		parameter BITS_PER_SYMBOL           = 60,
		parameter FIFO_DEPTH                = 8,
		parameter CHANNEL_WIDTH             = 0,
		parameter ERROR_WIDTH               = 0,
		parameter USE_PACKETS               = 0,
		parameter USE_IN_FILL_LEVEL         = 0,
		parameter USE_OUT_FILL_LEVEL        = 0,
		parameter WR_SYNC_DEPTH             = 2,
		parameter RD_SYNC_DEPTH             = 2,
		parameter BACKPRESSURE_DURING_RESET = 1,
		parameter USE_SPACE_AVAIL_IF        = 0,
		parameter PIPELINE_POINTERS         = 0,
		parameter SYNC_RESET                = 0,
		parameter retiming_reg_en           = 0
	) (
		input  wire                                          in_clk,      //        in_clk.clk
		input  wire                                          in_reset_n,  //  in_clk_reset.reset_n
		input  wire                                          out_clk,     //       out_clk.clk
		input  wire                                          out_reset_n, // out_clk_reset.reset_n
		input  wire [(SYMBOLS_PER_BEAT*BITS_PER_SYMBOL)-1:0] in_data,     //            in.data
		input  wire                                          in_valid,    //              .valid
		output wire                                          in_ready,    //              .ready
		output wire [(SYMBOLS_PER_BEAT*BITS_PER_SYMBOL)-1:0] out_data,    //           out.data
		output wire                                          out_valid,   //              .valid
		input  wire                                          out_ready    //              .ready
	);

	generate
		// If any of the display statements (or deliberately broken
		// instantiations) within this generate block triggers then this module
		// has been instantiated this module with a set of parameters different
		// from those it was generated for.  This will usually result in a
		// non-functioning system.
		if (SYNC_RESET != 0)
		begin
		// synthesis translate_off
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
		// synthesis translate_on
			instantiated_with_wrong_parameters_error_see_comment_above
					sync_reset_check ( .error(1'b1) );
		end
		if (retiming_reg_en != 0)
		begin
		// synthesis translate_off
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
		// synthesis translate_on
			instantiated_with_wrong_parameters_error_see_comment_above
					retiming_reg_en_check ( .error(1'b1) );
		end
	endgenerate

	dr_f_st_dc_fifo_1950_w4zc75y #(
		.SYMBOLS_PER_BEAT          (SYMBOLS_PER_BEAT),
		.BITS_PER_SYMBOL           (BITS_PER_SYMBOL),
		.FIFO_DEPTH                (FIFO_DEPTH),
		.CHANNEL_WIDTH             (CHANNEL_WIDTH),
		.ERROR_WIDTH               (ERROR_WIDTH),
		.USE_PACKETS               (USE_PACKETS),
		.USE_IN_FILL_LEVEL         (USE_IN_FILL_LEVEL),
		.USE_OUT_FILL_LEVEL        (USE_OUT_FILL_LEVEL),
		.WR_SYNC_DEPTH             (WR_SYNC_DEPTH),
		.RD_SYNC_DEPTH             (RD_SYNC_DEPTH),
		.BACKPRESSURE_DURING_RESET (BACKPRESSURE_DURING_RESET),
		.USE_SPACE_AVAIL_IF        (USE_SPACE_AVAIL_IF),
		.PIPELINE_POINTERS         (PIPELINE_POINTERS),
		.SYNC_RESET                (0),
		.retiming_reg_en           (0)
	) my_altera_avalon_dc_fifo_cmd_fifo (
		.in_clk             (in_clk),                               //   input,                                   width = 1,        in_clk.clk
		.in_reset_n         (in_reset_n),                           //   input,                                   width = 1,  in_clk_reset.reset_n
		.out_clk            (out_clk),                              //   input,                                   width = 1,       out_clk.clk
		.out_reset_n        (out_reset_n),                          //   input,                                   width = 1, out_clk_reset.reset_n
		.in_data            (in_data),                              //   input,  width = (SYMBOLS_PER_BEAT*BITS_PER_SYMBOL),            in.data
		.in_valid           (in_valid),                             //   input,                                   width = 1,              .valid
		.in_ready           (in_ready),                             //  output,                                   width = 1,              .ready
		.out_data           (out_data),                             //  output,  width = (SYMBOLS_PER_BEAT*BITS_PER_SYMBOL),           out.data
		.out_valid          (out_valid),                            //  output,                                   width = 1,              .valid
		.out_ready          (out_ready),                            //   input,                                   width = 1,              .ready
		.in_csr_address     (1'b0),                                 // (terminated),                                                            
		.in_csr_read        (1'b0),                                 // (terminated),                                                            
		.in_csr_write       (1'b0),                                 // (terminated),                                                            
		.in_csr_readdata    (),                                     // (terminated),                                                            
		.in_csr_writedata   (32'b00000000000000000000000000000000), // (terminated),                                                            
		.out_csr_address    (1'b0),                                 // (terminated),                                                            
		.out_csr_read       (1'b0),                                 // (terminated),                                                            
		.out_csr_write      (1'b0),                                 // (terminated),                                                            
		.out_csr_readdata   (),                                     // (terminated),                                                            
		.out_csr_writedata  (32'b00000000000000000000000000000000), // (terminated),                                                            
		.in_startofpacket   (1'b0),                                 // (terminated),                                                            
		.in_endofpacket     (1'b0),                                 // (terminated),                                                            
		.out_startofpacket  (),                                     // (terminated),                                                            
		.out_endofpacket    (),                                     // (terminated),                                                            
		.in_empty           (1'b0),                                 // (terminated),                                                            
		.out_empty          (),                                     // (terminated),                                                            
		.in_error           (1'b0),                                 // (terminated),                                                            
		.out_error          (),                                     // (terminated),                                                            
		.in_channel         (1'b0),                                 // (terminated),                                                            
		.out_channel        (),                                     // (terminated),                                                            
		.space_avail_data   (),                                     // (terminated),                                                            
		.almost_full_valid  (),                                     // (terminated),                                                            
		.almost_full_data   (),                                     // (terminated),                                                            
		.almost_empty_valid (),                                     // (terminated),                                                            
		.almost_empty_data  ()                                      // (terminated),                                                            
	);

endmodule
