
namespace eval dr_f {
  proc get_design_libraries {} {
    set libraries [dict create]
    dict set libraries altera_avalon_pio_1923             1
    dict set libraries intel_onchip_memory_147            1
    dict set libraries altera_avalon_onchip_memory2_1938  1
    dict set libraries altera_reset_controller_1922       1
    dict set libraries intel_niosv_m_unit_2210            1
    dict set libraries intel_niosv_timer_msip_120         1
    dict set libraries altera_irq_mapper_2001             1
    dict set libraries intel_niosv_m_2310                 1
    dict set libraries altera_avalon_jtag_uart_1924       1
    dict set libraries st_dc_fifo_1950                    1
    dict set libraries mm_ccb_1921                        1
    dict set libraries altera_merlin_slave_translator_191 1
    dict set libraries altera_merlin_axi_master_ni_1962   1
    dict set libraries altera_merlin_slave_agent_1921     1
    dict set libraries altera_avalon_sc_fifo_1931         1
    dict set libraries altera_merlin_router_1921          1
    dict set libraries altera_merlin_demultiplexer_1921   1
    dict set libraries altera_merlin_multiplexer_1922     1
    dict set libraries altera_mm_interconnect_1920        1
    dict set libraries dr_f_cpu_ctrl_10                   1
    dict set libraries dr_f_800                           1
    dict set libraries dr_f                               1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR} {
    set memory_files [list]
    lappend memory_files "[normalize_path "$QSYS_SIMDIR/../intel_onchip_memory_147/sim/dr_f_cpu_ctrl_dmem.hex"]"
    lappend memory_files "[normalize_path "$QSYS_SIMDIR/../altera_avalon_onchip_memory2_1938/sim/dr_f_cpu_ctrl_imem.hex"]"
    return $memory_files
  }
  
  proc get_common_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [dict create]
    return $design_files
  }
  
  proc get_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [list]
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_pio_1923/sim/dr_f_altera_avalon_pio_1923_amlq3xy.v"]\"  -work altera_avalon_pio_1923"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_onchip_memory_147/sim/dr_f_intel_onchip_memory_147_zyrpn5i.sv"]\"  -work intel_onchip_memory_147"                                  
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_onchip_memory2_1938/sim/dr_f_altera_avalon_onchip_memory2_1938_up3c7di.v"]\"  -work altera_avalon_onchip_memory2_1938"
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1922/sim/altera_reset_controller.v"]\"  -work altera_reset_controller_1922"                                 
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1922/sim/altera_reset_synchronizer.v"]\"  -work altera_reset_controller_1922"                               
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/niosv_reset_controller.v"]\"  -work intel_niosv_m_unit_2210"                                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_opcode_def.sv"]\"  -work intel_niosv_m_unit_2210"                                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_mem_op_state.sv"]\"  -work intel_niosv_m_unit_2210"                                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_ram.sv"]\"  -work intel_niosv_m_unit_2210"                                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_reg_file.sv"]\"  -work intel_niosv_m_unit_2210"                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_csr.sv"]\"  -work intel_niosv_m_unit_2210"                                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_interrupt_handler.sv"]\"  -work intel_niosv_m_unit_2210"                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_instr_buffer.sv"]\"  -work intel_niosv_m_unit_2210"                                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_bus_req.sv"]\"  -work intel_niosv_m_unit_2210"                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_shift.sv"]\"  -work intel_niosv_m_unit_2210"                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_c_alu.sv"]\"  -work intel_niosv_m_unit_2210"                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_c_decoder.sv"]\"  -work intel_niosv_m_unit_2210"                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_c_lsu.sv"]\"  -work intel_niosv_m_unit_2210"                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_c_core.sv"]\"  -work intel_niosv_m_unit_2210"                                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_c_csr.sv"]\"  -work intel_niosv_m_unit_2210"                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_m_top.sv"]\"  -work intel_niosv_m_unit_2210"                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_m_alu.sv"]\"  -work intel_niosv_m_unit_2210"                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_m_decoder.sv"]\"  -work intel_niosv_m_unit_2210"                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_m_lsu.sv"]\"  -work intel_niosv_m_unit_2210"                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_m_core.sv"]\"  -work intel_niosv_m_unit_2210"                                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_m_instr_prefetch.sv"]\"  -work intel_niosv_m_unit_2210"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_unit_2210/sim/aldec/niosv_m_shift_module.sv"]\"  -work intel_niosv_m_unit_2210"                                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_timer_msip_120/sim/aldec/niosv_timer_msip.sv"]\"  -work intel_niosv_timer_msip_120"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_irq_mapper_2001/sim/dr_f_altera_irq_mapper_2001_i625tnq.sv"]\"  -work altera_irq_mapper_2001"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_irq_mapper_2001/sim/dr_f_altera_irq_mapper_2001_3jqx4ly.sv"]\"  -work altera_irq_mapper_2001"                                     
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_niosv_m_2310/sim/dr_f_intel_niosv_m_2310_64smmgq.v"]\"  -work intel_niosv_m_2310"                                             
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_jtag_uart_1924/sim/dr_f_altera_avalon_jtag_uart_1924_2abh6yy.v"]\"  -work altera_avalon_jtag_uart_1924"               
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../st_dc_fifo_1950/sim/dr_f_st_dc_fifo_1950_w4zc75y.v"]\"  -work st_dc_fifo_1950"                                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../st_dc_fifo_1950/sim/altera_reset_synchronizer.v"]\"  -work st_dc_fifo_1950"                                                              
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../st_dc_fifo_1950/sim/altera_dcfifo_synchronizer_bundle.v"]\"  -work st_dc_fifo_1950"                                                 
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../st_dc_fifo_1950/sim/altera_std_synchronizer_nocut.v"]\"  -work st_dc_fifo_1950"                                                     
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../mm_ccb_1921/sim/dr_f_mm_ccb_st_dc_fifo_1921_zm7cluy.v"]\"  -work mm_ccb_1921"                                                       
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../mm_ccb_1921/sim/dr_f_mm_ccb_st_dc_fifo_1921_uipcaoa.v"]\"  -work mm_ccb_1921"                                                       
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../mm_ccb_1921/sim/dr_f_mm_ccb_1921_lcsq4ni.v"]\"  -work mm_ccb_1921"                                                                  
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_pio_1923/sim/dr_f_altera_avalon_pio_1923_cwe3bra.v"]\"  -work altera_avalon_pio_1923"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_translator_191/sim/dr_f_altera_merlin_slave_translator_191_x56fcki.sv"]\"  -work altera_merlin_slave_translator_191" 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_master_ni_1962/sim/altera_merlin_address_alignment.sv"]\"  -work altera_merlin_axi_master_ni_1962"                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_master_ni_1962/sim/dr_f_altera_merlin_axi_master_ni_1962_2kryw2a.sv"]\"  -work altera_merlin_axi_master_ni_1962"       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_agent_1921/sim/dr_f_altera_merlin_slave_agent_1921_b6r3djy.sv"]\"  -work altera_merlin_slave_agent_1921"             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_agent_1921/sim/altera_merlin_burst_uncompressor.sv"]\"  -work altera_merlin_slave_agent_1921"                        
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_sc_fifo_1931/sim/dr_f_altera_avalon_sc_fifo_1931_fzgstwy.v"]\"  -work altera_avalon_sc_fifo_1931"                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/dr_f_altera_merlin_router_1921_5rzu3eq.sv"]\"  -work altera_merlin_router_1921"                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/dr_f_altera_merlin_router_1921_zqritoa.sv"]\"  -work altera_merlin_router_1921"                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/dr_f_altera_merlin_router_1921_54nwtia.sv"]\"  -work altera_merlin_router_1921"                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/dr_f_altera_merlin_router_1921_6xiwnwi.sv"]\"  -work altera_merlin_router_1921"                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/dr_f_altera_merlin_demultiplexer_1921_u3wpova.sv"]\"  -work altera_merlin_demultiplexer_1921"       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/dr_f_altera_merlin_demultiplexer_1921_fz3k6qa.sv"]\"  -work altera_merlin_demultiplexer_1921"       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/dr_f_altera_merlin_multiplexer_1922_jxty3bi.sv"]\"  -work altera_merlin_multiplexer_1922"             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/dr_f_altera_merlin_multiplexer_1922_3dp34ly.sv"]\"  -work altera_merlin_multiplexer_1922"             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/dr_f_altera_merlin_demultiplexer_1921_tmki3xa.sv"]\"  -work altera_merlin_demultiplexer_1921"       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/dr_f_altera_merlin_demultiplexer_1921_ehk3buq.sv"]\"  -work altera_merlin_demultiplexer_1921"       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/dr_f_altera_merlin_multiplexer_1922_giox42a.sv"]\"  -work altera_merlin_multiplexer_1922"             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/dr_f_altera_merlin_multiplexer_1922_3eez3ny.sv"]\"  -work altera_merlin_multiplexer_1922"             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_mm_interconnect_1920/sim/dr_f_altera_mm_interconnect_1920_kdc5gci.v"]\"  -work altera_mm_interconnect_1920"                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_irq_mapper_2001/sim/dr_f_altera_irq_mapper_2001_sfbnk2i.sv"]\"  -work altera_irq_mapper_2001"                                     
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_cpu_ctrl_10/sim/dr_f_dr_f_cpu_ctrl_10_pocd4ry.v"]\"  -work dr_f_cpu_ctrl_10"                                                   
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_cpu_ctrl.v"]\"  -work dr_f_800"                                                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_dr_f_800_5d2okvq.sv"]\"  -work dr_f_800"                                                                               
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_altera_std_synchronizer_nocut.v"]\"  -work dr_f_800"                                                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_data_sync.sv"]\"  -work dr_f_800"                                                                                      
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_multibit_sync.v"]\"  -work dr_f_800"                                                                              
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_reset_synchronizer.v"]\"  -work dr_f_800"                                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_xcvr_resync_std.sv"]\"  -work dr_f_800"                                                                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_avmm2mem_cc_bridge.sv"]\"  -work dr_f_800"                                                                             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_avmm_32to8.sv"]\"  -work dr_f_800"                                                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_avmm_arbiter_2to1.sv"]\"  -work dr_f_800"                                                                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_avmm_decoder.sv"]\"  -work dr_f_800"                                                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_avmm_interconnect.sv"]\"  -work dr_f_800"                                                                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_clock_crosser.sv"]\"  -work dr_f_800"                                                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_csr.sv"]\"  -work dr_f_800"                                                                                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_gavmm_32to8.sv"]\"  -work dr_f_800"                                                                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_hip.sv"]\"  -work dr_f_800"                                                                                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_mux_decoder.sv"]\"  -work dr_f_800"                                                                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_scalable_decoder.sv"]\"  -work dr_f_800"                                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_sip.sv"]\"  -work dr_f_800"                                                                                            
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../dr_f_800/sim/dr_f_sip_reg.v"]\"  -work dr_f_800"                                                                                    
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/dr_f.v"]\"  -work dr_f"                                                                                                                
    return $design_files
  }
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    
    return $libraries
  }
  
}
