// dr_f.v

// Generated using ACDS version 23.4 79

`timescale 1 ps / 1 ps
module dr_f (
		input  wire        i_csr_clk,                     //                i_csr_clk.clk,                      Reconfiguration clock
		input  wire        i_cpu_clk,                     //                i_cpu_clk.clk,                      CPU clock
		input  wire        i_rst_n,                       //                  i_rst_n.reset_n,                  Async Reconfig reset
		output wire [14:0] o_dr_curr_profile_id,          //     o_dr_curr_profile_id.o_dr_curr_profile_id,     Current Profile ID
		output wire        o_dr_new_cfg_applied,          //     o_dr_new_cfg_applied.o_dr_new_cfg_applied,     New Configuration applied settings status
		input  wire        i_dr_new_cfg_applied_ack,      // i_dr_new_cfg_applied_ack.i_dr_new_cfg_applied_ack, New Configuration applied settings acknowledge from Host
		output wire        o_dr_in_progress,              //         o_dr_in_progress.o_dr_in_progress,         Overall DR switching status
		output wire        o_dr_fast_sim_clk_sel,         //    o_dr_fast_sim_clk_sel.o_dr_fast_sim_clk_sel,    cpu_clk_sel for optional simulatio speedup
		output wire        o_dr_error_status,             //        o_dr_error_status.o_dr_error_status,        Overall DR SIP and firmware error status out
		input  wire [9:0]  i_dr_host_avmm_address,        //      host_reconfig_slave.address,                  Address for DR CSRs
		output wire        o_dr_host_avmm_readdata_valid, //                         .readdatavalid,            Read data from DR CSRs is valid
		input  wire        i_dr_host_avmm_read,           //                         .read,                     Read command for DR CSRs
		input  wire        i_dr_host_avmm_write,          //                         .write,                    Write command for DR CSRs
		output wire [31:0] o_dr_host_avmm_readdata,       //                         .readdata,                 Read data from reads to DR CSRs
		input  wire [31:0] i_dr_host_avmm_writedata,      //                         .writedata,                Data for writes to DR CSRs
		output wire        o_dr_host_avmm_waitrequest     //                         .waitrequest,              AVMM stall signal for operation on DR CSRs
	);

	dr_f_dr_f_800_5d2okvq dr_f (
		.i_csr_clk                     (i_csr_clk),                            //   input,   width = 1,                i_csr_clk.clk
		.i_cpu_clk                     (i_cpu_clk),                            //   input,   width = 1,                i_cpu_clk.clk
		.i_rst_n                       (i_rst_n),                              //   input,   width = 1,                  i_rst_n.reset_n
		.o_dr_curr_profile_id          (o_dr_curr_profile_id),                 //  output,  width = 15,     o_dr_curr_profile_id.o_dr_curr_profile_id
		.o_dr_new_cfg_applied          (o_dr_new_cfg_applied),                 //  output,   width = 1,     o_dr_new_cfg_applied.o_dr_new_cfg_applied
		.i_dr_new_cfg_applied_ack      (i_dr_new_cfg_applied_ack),             //   input,   width = 1, i_dr_new_cfg_applied_ack.i_dr_new_cfg_applied_ack
		.o_dr_in_progress              (o_dr_in_progress),                     //  output,   width = 1,         o_dr_in_progress.o_dr_in_progress
		.o_dr_fast_sim_clk_sel         (o_dr_fast_sim_clk_sel),                //  output,   width = 1,    o_dr_fast_sim_clk_sel.o_dr_fast_sim_clk_sel
		.o_dr_error_status             (o_dr_error_status),                    //  output,   width = 1,        o_dr_error_status.o_dr_error_status
		.i_dr_host_avmm_address        (i_dr_host_avmm_address),               //   input,  width = 10,      host_reconfig_slave.address
		.o_dr_host_avmm_readdata_valid (o_dr_host_avmm_readdata_valid),        //  output,   width = 1,                         .readdatavalid
		.i_dr_host_avmm_read           (i_dr_host_avmm_read),                  //   input,   width = 1,                         .read
		.i_dr_host_avmm_write          (i_dr_host_avmm_write),                 //   input,   width = 1,                         .write
		.o_dr_host_avmm_readdata       (o_dr_host_avmm_readdata),              //  output,  width = 32,                         .readdata
		.i_dr_host_avmm_writedata      (i_dr_host_avmm_writedata),             //   input,  width = 32,                         .writedata
		.o_dr_host_avmm_waitrequest    (o_dr_host_avmm_waitrequest),           //  output,   width = 1,                         .waitrequest
		.o_dr_ip_1hot_selector         (),                                     // (terminated),                                       
		.i_dr_cpu_c4_debug             (32'b00000000000000000000000000000000), // (terminated),                                       
		.i_dr_cpu_c5_debug             (32'b00000000000000000000000000000000), // (terminated),                                       
		.o_dr_cpu_s4_debug             (),                                     // (terminated),                                       
		.o_dr_cpu_s5_debug             ()                                      // (terminated),                                       
	);

endmodule
