// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps/1 ps 
module dphy_f_dr_avmm1 #(
    parameter          num_sys_cop                                              = 1,
    parameter          num_subsys_cop                                           = 1,
    parameter   [4:0]  l_sys_xcvrs                                              = 1,
    parameter   [4:0]  num_xcvr_per_sys                                         = 1,
    parameter          l_num_aib_per_xcvr                                       = 1,
    parameter   [4:0]  l_sys_aibs                                               = 1,
    parameter          l_tx_enable                                              = 1,
    parameter          l_rx_enable                                              = 1,
    parameter          fec_enable                                               = 1'b0,
    parameter          l_soft_csr_enable                                        = 0,
    parameter          l_soft_dr_csr_enable                                     = 0,
    parameter          reconfig_pdp_address_width                               = 14, 
    parameter [11:0]   l_line_rate_p1ghz                                        = 12'd250,
    parameter          xcvr_type                                                = 1'b0,
    parameter          modulation_type                                          = 1'b0,
    parameter          avmm1_ready_enable                                      = 0,
    parameter          avmm1_enable                                             = 0,
    parameter          l_av1_aib_enable                                         = 0,
    parameter          l_num_avmm1                                              = 1,
    parameter          l_av1_ifaces                                             = 1,
    parameter          l_av1_addr_bits                                          = 14,
    parameter          DATA_WIDTH                                               = 32,
    parameter          rcfg_group                                                 = "25G-1",
    parameter [13:0]   STARTUP_RECONFIG_GRP_VALUE                               = 0,
    parameter [31:0]   STARTUP_FEC_GRP1_VALUE                                   = 0,
    parameter [31:0]   STARTUP_FEC_GRP2_VALUE                                   = 0,
    parameter [23:0]   STARTUP_MODULATION_TYPE                                   = 0,
    parameter [23:0]   STARTUP_LINE_RATE_P1GHZ_FRAC1_FRAC0                       = 0,
    parameter [23:0]   STARTUP_LINE_RATE_P1GHZ_FRAC3_FRAC2                       = 0,
    parameter [23:0]   STARTUP_LINE_RATE_P1GHZ_FRAC5_FRAC4                       = 0,
    parameter [23:0]   STARTUP_LINE_RATE_P1GHZ_FRAC7_FRAC6                       = 0,
    parameter [23:0]   STARTUP_LINE_RATE_P1GHZ_FRAC9_FRAC8                       = 0,
    parameter [23:0]   STARTUP_LINE_RATE_P1GHZ_FRAC11_FRAC10                     = 0
    ) (  

  input           reconfig_pdp_clk,         //   reconfig_pdp_clk.clk
  input           reconfig_pdp_reset,       // reconfig_pdp_reset.reset
  input           reconfig_pdp_write,       //  reconfig_pdp_avmm.write
  input           reconfig_pdp_read,        //                   .read
  input  [reconfig_pdp_address_width-1:0]   reconfig_pdp_address,     //                   .address // T=Ceiling(log2(N)) // N= Number of streams
  input  [DATA_WIDTH/8-1:0] reconfig_pdp_byteenable,  //                   .byteenable
  input  [DATA_WIDTH-1:0]   reconfig_pdp_writedata,   //                   .writedata
  output [num_subsys_cop-1:0][DATA_WIDTH-1:0]   reconfig_pdp_readdata,    //                   .readdata
  output [num_subsys_cop-1:0]         reconfig_pdp_waitrequest, //                   .waitrequest
  output [num_subsys_cop-1:0]         reconfig_pdp_readdatavalid, //                 .readdatavalid

  //  for AVMM1 bb ports
  input   wire  [l_sys_aibs-1:0]      pld_avmm1_busy,
  input   wire  [l_sys_aibs-1:0]      pld_avmm1_cmdfifo_wr_full,
  input   wire  [l_sys_aibs-1:0]      pld_avmm1_cmdfifo_wr_pfull,
  input   wire  [8*l_sys_aibs-1:0]    pld_avmm1_readdata,
  input   wire  [l_sys_aibs-1:0]      pld_avmm1_readdatavalid,
  input   wire  [3*l_sys_aibs-1:0]    pld_avmm1_reserved_out,
  input   wire  [l_sys_aibs-1:0]      pld_chnl_cal_done,
  input   wire  [l_sys_aibs-1:0]      pld_hssi_osc_transfer_en,
  output  wire  [num_subsys_cop-1:0] [l_sys_aibs-1:0]      pld_avmm1_clk_rowclk,
  output  wire  [num_subsys_cop-1:0] [l_sys_aibs-1:0]      pld_avmm1_read,
  output  wire  [num_subsys_cop-1:0] [10*l_sys_aibs-1:0]   pld_avmm1_reg_addr,
  output  wire  [num_subsys_cop-1:0] [l_sys_aibs-1:0]      pld_avmm1_request,
  output  wire  [num_subsys_cop-1:0] [9*l_sys_aibs-1:0]    pld_avmm1_reserved_in,
  output  wire  [num_subsys_cop-1:0] [l_sys_aibs-1:0]      pld_avmm1_write,
  output  wire  [num_subsys_cop-1:0] [8*l_sys_aibs-1:0]    pld_avmm1_writedata,

  // ctrl and status signals
  output   [num_subsys_cop-1:0]                     dphy_reset_soft_tx_rst,
  output   [num_subsys_cop-1:0]                     dphy_reset_soft_rx_rst,
  output   [num_subsys_cop-1:0]                     dphy_reset_tx_rst_ovr,
  output   [num_subsys_cop-1:0]                     dphy_reset_rx_rst_ovr,
  input    [num_subsys_cop-1:0]                     dphy_reset_status_tx_rst_ack_n_i,
  input    [num_subsys_cop-1:0]                     dphy_reset_status_rx_rst_ack_n_i,
  input    [num_subsys_cop-1:0]                     dphy_reset_status_tx_ready_i,
  input    [num_subsys_cop-1:0]                     dphy_reset_status_rx_ready_i,
  input    [l_sys_xcvrs-1:0]                     phy_tx_pll_locked_tx_pll_locked_i_int [num_subsys_cop-1:0],
  input    [l_sys_xcvrs-1:0]                     phy_rx_cdr_locked_rx_cdr_locked_i_int [num_subsys_cop-1:0],
  input    [l_sys_xcvrs-1:0]                     phy_rx_cdr_locked_rx_cdr_locked2data_i_int [num_subsys_cop-1:0],
  output   [num_subsys_cop-1:0]                     src_ctrl_rx_ignore_locked2data,

  //Reconfiguration register signals
  output wire [13:0]      reconfig_group,
  output wire [31:0]      fec_mode_group1,
  output wire [31:0]      fec_mode_group2

);

logic   [11:0]   soft_csr_dr_sel;
logic   [11:0]   soft_csrDrOr_sel;
logic   [num_subsys_cop-1:0]   soft_csr_dr_sel_reg;
logic   [num_subsys_cop-1:0]   soft_csrDrOr_sel_reg;
wire    [DATA_WIDTH-1:0]    soft_csr_dr_readdata    [num_subsys_cop-1:0];
wire    [num_subsys_cop-1:0]   soft_csr_dr_readdatavalid;
wire    [num_subsys_cop-1:0]   soft_csr_dr_waitrequest;


  //\TODO  TEMPORARILY COPIED FUNCTION UNTIL TILE_IP HANDLES PACKAGES PROPERLY
    localparam integer MAX_CHARS_ALT_XCVR_NATIVE_S10 = 86; // To accomodate LONG parameter lists.
  ////////////////////////////////////////////////////////////////////
  // Convert an integer to a string
  function [MAX_CHARS_ALT_XCVR_NATIVE_S10*8-1:0] int2str_alt_xcvr_native_s10(
    input integer in_int
  );
    integer i;
    integer this_char;
    i = 0;
    int2str_alt_xcvr_native_s10 = "";
    do
    begin
      this_char = (in_int % 10) + 48;
      int2str_alt_xcvr_native_s10[i*8+:8] = this_char[7:0];
      i=i+1;
      in_int = in_int / 10; 
    end
    while(in_int > 0);
  endfunction

    localparam integer MAX_BIT_MASK_LENTGH = 32; 
  ////////////////////////////////////////////////////////////////////
  //  Count previouly marked bits before index 
  function integer pre_marked_count_dphy_f(
    input bit [MAX_BIT_MASK_LENTGH-1:0] bit_mask,
    input integer index
  );
    pre_marked_count_dphy_f = 0;
    for (integer i = 0; i<index; i++) if (bit_mask[i]) pre_marked_count_dphy_f = pre_marked_count_dphy_f + 1;
  endfunction

localparam  AV1_UNIT_AW = 14;       // AVMM1 user unit interface word Address Width    
//localparam  aib_pif     = num_xcvr_per_sys*l_num_aib_per_xcvr;
localparam aib_pif = l_sys_aibs;
localparam  ch_sel_bits = l_av1_addr_bits-AV1_UNIT_AW;
// to calculate number of enabled and disabled aibs per system
localparam  BE_WIDTH    = DATA_WIDTH/8;
localparam  [15:0] aib_used_flag = (l_av1_aib_enable)? 16'hffff : (fec_enable)? 16'h0001 : (l_num_aib_per_xcvr==4)? 16'h1111 : (l_num_aib_per_xcvr==2)? 16'h5555 : 16'hffff;
localparam  [1:0] duplex_mode = (l_tx_enable)? ( l_rx_enable? 2'b11: 2'b10) : (l_rx_enable? 2'b01 : 2'b00);


wire    [DATA_WIDTH-1:0]      m32_mux_readdata    [num_subsys_cop-1:0];

logic   [11:0]     soft_csr_select;
logic   [num_subsys_cop-1:0]     soft_csr_select_reg;
wire    [DATA_WIDTH-1:0]      soft_csr_readdata    [num_subsys_cop-1:0];
wire    [DATA_WIDTH-1:0]      soft_RcMux_readdata [num_subsys_cop-1:0];
wire    [num_subsys_cop-1:0]     soft_csr_readdatavalid;
wire    [num_subsys_cop-1:0]     soft_RcMux_readdatavalid;
wire    [num_subsys_cop-1:0]     soft_csr_waitrequest;
wire    [num_subsys_cop-1:0]     soft_RcMux_waitrequest;

wire    [DATA_WIDTH-1:0]      m32_writedata   [num_subsys_cop-1:0];
wire    [DATA_WIDTH-1:0]      m32_readdata    [num_subsys_cop-1:0];
wire    [l_av1_addr_bits-1:0] m32_address     [num_subsys_cop-1:0];
wire    [l_av1_addr_bits+2:0] m32_address_exp [num_subsys_cop-1:0];  // add bit [16, 1:0] for physical(expanded) addr
wire    [3:0]                 m32_byteenable  [num_subsys_cop-1:0];


wire    [7:0]                 m8_writedata   [num_subsys_cop-1:0];
wire    [7:0]                 m8_readdata    [num_subsys_cop-1:0];
wire    [l_av1_addr_bits+3:0] m8_addr        [num_subsys_cop-1:0];  // from coverter, as <Dword Access>, <ch_sel>, [16:0]
wire    [num_subsys_cop-1:0]    m8_addr_av1_b9 ;                    // maib indication
wire    [l_av1_addr_bits+4:0] m8_addr_av1    [num_subsys_cop-1:0];  // arranged as <ch_sel>, [16:8] <maib> <maib/da>, [7:0]

wire    [num_subsys_cop -1:0] m32_mux_waitrequest;
wire    [num_subsys_cop -1:0] m32_mux_readdatavalid;
wire    [num_subsys_cop -1:0] m32_read;
wire    [num_subsys_cop -1:0] m32_write;
wire    [num_subsys_cop -1:0] m32_waitrequest;
wire    [num_subsys_cop -1:0] m32_readdatavalid;
wire    [num_subsys_cop -1:0] m8_read;
wire    [num_subsys_cop -1:0] m8_write;
wire    [num_subsys_cop -1:0] m8_waitrequest;
wire    [num_subsys_cop -1:0] m8_addr_av1_b8;

logic   [num_subsys_cop -1:0] m32_gdr_select;
logic   [num_subsys_cop -1:0] m32_maib_select;


wire [11:0]   fracture_active_i;
wire [4:0]    fracture_cnt ;
wire [3:0]    rate_per_xcvr;
wire [4:0]    xcvr_cnt_per_fracture ;
wire [4:0]    num_aibs_per_sys;
wire [num_subsys_cop-1:0]   fracture_active_o;
wire [15:0] rsfec_on ;
wire [143:0] startup_line_rate_p1ghz;
wire [11:0] startup_modulation_type;

assign fracture_cnt          =  reconfig_group[13:9];
assign rate_per_xcvr             =  reconfig_group[3:0];
assign xcvr_cnt_per_fracture     =  reconfig_group[8:4];

assign startup_line_rate_p1ghz   = {STARTUP_LINE_RATE_P1GHZ_FRAC11_FRAC10,STARTUP_LINE_RATE_P1GHZ_FRAC9_FRAC8,STARTUP_LINE_RATE_P1GHZ_FRAC7_FRAC6,STARTUP_LINE_RATE_P1GHZ_FRAC5_FRAC4,STARTUP_LINE_RATE_P1GHZ_FRAC3_FRAC2,STARTUP_LINE_RATE_P1GHZ_FRAC1_FRAC0}; 
assign startup_modulation_type   = {(|STARTUP_MODULATION_TYPE[23:22]),(|STARTUP_MODULATION_TYPE[21:20]),(|STARTUP_MODULATION_TYPE[19:18]),(|STARTUP_MODULATION_TYPE[17:16]),(|STARTUP_MODULATION_TYPE[15:14]),(|STARTUP_MODULATION_TYPE[13:12]),(|STARTUP_MODULATION_TYPE[11:10]),(|STARTUP_MODULATION_TYPE[9:8]),(|STARTUP_MODULATION_TYPE[7:6]),(|STARTUP_MODULATION_TYPE[5:4]),(|STARTUP_MODULATION_TYPE[3:2]),(|STARTUP_MODULATION_TYPE[1:0])};

assign fracture_active_i = ((fracture_cnt == 1)  ? 12'b0000_0000_0001 :
                           ((fracture_cnt == 2)  ? 12'b0000_0000_0011 :
                           ((fracture_cnt == 3)  ? 12'b0000_0000_0111 :
                           ((fracture_cnt == 4)  ? 12'b0000_0000_1111 :
                           ((fracture_cnt == 5)  ? 12'b0000_0001_1111 :
                           ((fracture_cnt == 6)  ? 12'b0000_0011_1111 :
                           ((fracture_cnt == 7)  ? 12'b0000_0111_1111 :
                           ((fracture_cnt == 8)  ? 12'b0000_1111_1111 :
	                   ((fracture_cnt == 9)  ? 12'b0001_1111_1111 :
                           ((fracture_cnt == 10) ? 12'b0011_1111_1111 :
                           ((fracture_cnt == 11) ? 12'b0111_1111_1111 :
                           ((fracture_cnt == 12) ? 12'b1111_1111_1111 : 12'd0 ))))))))))));
											
assign num_aibs_per_sys = ((rate_per_xcvr == 1 && xcvr_cnt_per_fracture == 1)  ? 1  :
	                  ((rate_per_xcvr == 2 && xcvr_cnt_per_fracture == 1)  ? 2  :
	                  ((rate_per_xcvr == 1 && xcvr_cnt_per_fracture == 2)  ? 2  :
	                  ((rate_per_xcvr == 3 && xcvr_cnt_per_fracture == 1)  ? 4  :
	                  ((rate_per_xcvr == 2 && xcvr_cnt_per_fracture == 2)  ? 4  :
	                  ((rate_per_xcvr == 1 && xcvr_cnt_per_fracture == 4)  ? 4  :
	                  ((rate_per_xcvr == 1 && xcvr_cnt_per_fracture == 6)  ? 6  :
	                  ((rate_per_xcvr == 3 && xcvr_cnt_per_fracture == 2)  ? 8  :
	                  ((rate_per_xcvr == 2 && xcvr_cnt_per_fracture == 4)  ? 8  :
	                  ((rate_per_xcvr == 1 && xcvr_cnt_per_fracture == 8)  ? 8  :
	                  ((rate_per_xcvr == 1 && xcvr_cnt_per_fracture == 12) ? 12 :
	                  ((rate_per_xcvr == 3 && xcvr_cnt_per_fracture == 4)  ? 16 :
	                  ((rate_per_xcvr == 2 && xcvr_cnt_per_fracture == 8)  ? 16 : 'h1 )))))))))))));

assign soft_csr_select[0]  = (avmm1_enable ? ((rcfg_group == "25G-1") ? (reconfig_pdp_address[13:8] == 6'h2) : 
	                                     ((rcfg_group == "50G-1" ||rcfg_group == "50G-2") ? (reconfig_pdp_address[14:8] == 7'h2) : 
					     ((rcfg_group == "100G-1" || rcfg_group == "100G-2" || rcfg_group == "100G-4") ? (reconfig_pdp_address[15:8] == 8'h2) : 
					     ((rcfg_group == "150G-6" || rcfg_group == "200G-2" || rcfg_group == "200G-4" || rcfg_group == "200G-8") ? (reconfig_pdp_address[16:8] == 9'h2) :
					     (reconfig_pdp_address[17:8] == 10'h2))))) : 'h0 );

assign soft_csr_select[1]  = (avmm1_enable ? ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "100G-1") ? 1'b0 : 
	                                     ((rcfg_group == "50G-2") ? (reconfig_pdp_address[14:8] == 7'h42) :
					     ((rcfg_group == "100G-2" || rcfg_group == "100G-4") ? (reconfig_pdp_address[15:8] == 8'h42) :
					     ((rcfg_group == "150G-6" || rcfg_group == "200G-2" || rcfg_group == "200G-4" || rcfg_group == "200G-8") ? (reconfig_pdp_address[16:8] == 9'h42) :
					     (reconfig_pdp_address[17:8] == 10'h42))))) : 'h0 );
					     
assign soft_csr_select[2]  = (avmm1_enable ? ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "50G-2" || rcfg_group == "100G-1" || rcfg_group == "100G-2" || rcfg_group == "200G-2") ? 1'b0 : 
	                                     ((rcfg_group == "100G-4") ? (reconfig_pdp_address[15:8] == 8'h82) : 
					     ((rcfg_group == "150G-6" || rcfg_group == "200G-4" || rcfg_group == "200G-8") ? (reconfig_pdp_address[16:8] == 9'h82) :
					     (reconfig_pdp_address[17:8] == 10'h82)))) : 'h0);

assign soft_csr_select[3]  = (avmm1_enable ? ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "50G-2" || rcfg_group == "100G-1" || rcfg_group == "100G-2" || rcfg_group == "200G-2") ? 1'b0 : 
	                                     ((rcfg_group == "100G-4") ? (reconfig_pdp_address[15:8] == 8'hC2) : 
					     ((rcfg_group == "150G-6" || rcfg_group == "200G-4" || rcfg_group == "200G-8") ? (reconfig_pdp_address[16:8] == 9'hC2) :
					     (reconfig_pdp_address[17:8] == 10'hC2)))) : 'h0);

assign soft_csr_select[4]  = (avmm1_enable ? ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "50G-2" || rcfg_group == "100G-1" || rcfg_group == "100G-2" || rcfg_group == "100G-4" || rcfg_group == "200G-2" || rcfg_group == "200G-4" || rcfg_group == "400G-4") ? 1'b0 : 
	                                     ((rcfg_group == "150G-6" || rcfg_group == "200G-8") ? (reconfig_pdp_address[16:8] == 9'h102) : 
					     (reconfig_pdp_address[17:8] == 10'h102))) : 'h0);

assign soft_csr_select[5]  = (avmm1_enable ? ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "50G-2" || rcfg_group == "100G-1" || rcfg_group == "100G-2" || rcfg_group == "100G-4" || rcfg_group == "200G-2" || rcfg_group == "200G-4" || rcfg_group == "400G-4") ? 1'b0 : 
	                                     ((rcfg_group == "150G-6" || rcfg_group == "200G-8") ? (reconfig_pdp_address[16:8] == 9'h142) : 
					     (reconfig_pdp_address[17:8] == 10'h142))) : 'h0);

assign soft_csr_select[6]  = (avmm1_enable ? ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "50G-2" || rcfg_group == "100G-1" || rcfg_group == "100G-2" || rcfg_group == "100G-4" || rcfg_group == "200G-2" || rcfg_group == "200G-4" || rcfg_group == "400G-4" || rcfg_group == "150G-6") ? 1'b0 : 
	                                     ((rcfg_group == "200G-8") ? (reconfig_pdp_address[16:8] == 9'h182) : 
					     (reconfig_pdp_address[17:8] == 10'h182))) : 'h0);

assign soft_csr_select[7]  = (avmm1_enable ? ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "50G-2" || rcfg_group == "100G-1" || rcfg_group == "100G-2" || rcfg_group == "100G-4" || rcfg_group == "200G-2" || rcfg_group == "200G-4" || rcfg_group == "400G-4" || rcfg_group == "150G-6") ? 1'b0 : 
	                                     ((rcfg_group == "200G-8") ? (reconfig_pdp_address[16:8] == 9'h1C2) : 
					     (reconfig_pdp_address[17:8] == 10'h1C2))) : 'h0);

assign soft_csr_select[8]  = (avmm1_enable ? ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "50G-2" || rcfg_group == "100G-1" || rcfg_group == "100G-2" || rcfg_group == "100G-4" || rcfg_group == "150G-6" || rcfg_group == "200G-2" || rcfg_group == "200G-4" || rcfg_group == "200G-8" || rcfg_group == "400G-4" || rcfg_group == "400G-8") ? 1'b0 : (reconfig_pdp_address[17:8] == 10'h202)) : 'h0);
assign soft_csr_select[9]  = (avmm1_enable ? ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "50G-2" || rcfg_group == "100G-1" || rcfg_group == "100G-2" || rcfg_group == "100G-4" || rcfg_group == "150G-6" || rcfg_group == "200G-2" || rcfg_group == "200G-4" || rcfg_group == "200G-8" || rcfg_group == "400G-4" || rcfg_group == "400G-8") ? 1'b0 : (reconfig_pdp_address[17:8] == 10'h242)) : 'h0);
assign soft_csr_select[10] = (avmm1_enable ? ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "50G-2" || rcfg_group == "100G-1" || rcfg_group == "100G-2" || rcfg_group == "100G-4" || rcfg_group == "150G-6" || rcfg_group == "200G-2" || rcfg_group == "200G-4" || rcfg_group == "200G-8" || rcfg_group == "400G-4" || rcfg_group == "400G-8") ? 1'b0 : (reconfig_pdp_address[17:8] == 10'h282)) : 'h0);
assign soft_csr_select[11] = (avmm1_enable ? ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "50G-2" || rcfg_group == "100G-1" || rcfg_group == "100G-2" || rcfg_group == "100G-4" || rcfg_group == "150G-6" || rcfg_group == "200G-2" || rcfg_group == "200G-4" || rcfg_group == "200G-8" || rcfg_group == "400G-4" || rcfg_group == "400G-8") ? 1'b0 : (reconfig_pdp_address[17:8] == 10'h2C2)) : 'h0);


assign rsfec_on = {(|fec_mode_group2[31:28]),(|fec_mode_group2[27:24]),(|fec_mode_group2[23:20]),(|fec_mode_group2[19:16]),(|fec_mode_group2[15:12]),(|fec_mode_group2[11:8]),(|fec_mode_group2[7:4]),(|fec_mode_group2[3:0]),(|fec_mode_group1[31:28]),(|fec_mode_group1[27:24]),(|fec_mode_group1[23:20]),(|fec_mode_group1[19:16]),(|fec_mode_group1[15:12]),(|fec_mode_group1[11:8]),(|fec_mode_group1[7:4]),(|fec_mode_group1[3:0])};

assign soft_csrDrOr_sel_reg = soft_csr_dr_sel_reg | soft_csr_select_reg ;
assign soft_csrDrOr_sel[0] = soft_csr_dr_sel[0] | soft_csr_select[0] ;
assign soft_csrDrOr_sel[11:1] = soft_csr_select[11:1] ;

genvar ig, ifs_idx, aib_idx;
generate
  if (avmm1_enable) begin:av1_ena
    for(ig=0;ig<num_subsys_cop;ig=ig+1) begin: av1_sys 
	localparam  av1_idx  = ig*aib_pif;
	// per xcvr read/write signals for soft csr and avmm port
	wire [aib_pif-1:0] ch_write, ch_read, ch_waitrequest;
	wire [aib_pif-1:0] [7:0] ch_readdata;

	     assign reconfig_pdp_readdata[ig]      = m32_mux_readdata[ig];
             assign reconfig_pdp_waitrequest[ig]  = m32_mux_waitrequest[ig];
	     assign reconfig_pdp_readdatavalid[ig] = m32_mux_readdatavalid[ig];
             
	     assign m32_read[ig]         = reconfig_pdp_read;
             assign m32_write[ig]        = reconfig_pdp_write;
             assign m32_address[ig]      = reconfig_pdp_address;
             assign m32_byteenable[ig]   = reconfig_pdp_byteenable;
             assign m32_writedata[ig]    = reconfig_pdp_writedata;

    // CSR selection logic 
       assign m32_mux_waitrequest[ig]   = (soft_csrDrOr_sel[ig])? soft_RcMux_waitrequest[ig] : m32_waitrequest[ig];
       assign m32_mux_readdatavalid[ig] = ((avmm1_ready_enable)? soft_csrDrOr_sel_reg[ig] : soft_csrDrOr_sel[ig])? soft_RcMux_readdatavalid[ig] : m32_readdatavalid[ig];
       assign m32_mux_readdata[ig]  = ((avmm1_ready_enable)? soft_csrDrOr_sel_reg[ig] : soft_csrDrOr_sel[ig])? soft_RcMux_readdata[ig] : m32_readdata[ig];

       assign soft_RcMux_readdata[ig]      = ((avmm1_ready_enable)? soft_csr_dr_sel_reg[ig] :soft_csr_dr_sel[ig]) ? soft_csr_dr_readdata[ig] : soft_csr_readdata[ig];
       assign soft_RcMux_readdatavalid[ig] = ((avmm1_ready_enable)? soft_csr_dr_sel_reg[ig] :soft_csr_dr_sel[ig]) ? soft_csr_dr_readdatavalid[ig] : soft_csr_readdatavalid[ig];
       assign soft_RcMux_waitrequest[ig]   = (soft_csr_dr_sel[ig])? soft_csr_dr_waitrequest[ig] : soft_csr_waitrequest[ig];

       // soft csr, each fracture in a system has the soft CSR
	if (l_soft_csr_enable) begin : w_scsr
  
           always_comb begin
		m32_maib_select[ig]      = 1'b0;
		m32_gdr_select[ig]       = 1'b0;
		case (m32_address_exp[ig][16:0]) inside 
                    [17'h00400:17'h007ff] : begin
			 if (l_av1_aib_enable) m32_maib_select[ig] = 1'b1;
		       	 m32_gdr_select[ig]  = 1'b1;
	            end
		    [17'h00800:17'h00fff] : m32_gdr_select[ig]    = 1'b0;
	            default: m32_gdr_select[ig]  = 1'b1;
		endcase
	    end

            always_ff @(posedge reconfig_pdp_clk) begin
                soft_csr_select_reg[ig] <= soft_csr_select[ig];
	    end

            dphy_f_dr_csr_wrap1 # (
               .enable_ready              (avmm1_ready_enable),
               .line_rate_p1ghz            (l_line_rate_p1ghz),
               .xcvr_type                  (xcvr_type),
               .modulation_type            (modulation_type),
               .num_xcvr                   (num_xcvr_per_sys),
               .num_aib                    (l_num_aib_per_xcvr*num_xcvr_per_sys),
               .fec_enable                 (fec_enable),
               .duplex_mode                (duplex_mode)  
               ) dphy_f_dr_csr_wrap1_inst (
	       .rsfec_on                                           (rsfec_on[ig]),
	       .startup_line_rate_p1ghz                            (startup_line_rate_p1ghz[ig*12+:12]),
	       .startup_modulation_type                            (startup_modulation_type[ig]),
	       .num_aibs_per_sys                                   (num_aibs_per_sys),
	       .xcvr_cnt_per_fracture                              (xcvr_cnt_per_fracture),
               .dphy_reset_soft_tx_rst                             (dphy_reset_soft_tx_rst[ig]),
               .dphy_reset_soft_rx_rst                             (dphy_reset_soft_rx_rst[ig]),
               .dphy_reset_tx_rst_ovr                              (dphy_reset_tx_rst_ovr[ig]),
               .dphy_reset_rx_rst_ovr                              (dphy_reset_rx_rst_ovr[ig]),
               .dphy_reset_status_tx_rst_ack_n_i                   (dphy_reset_status_tx_rst_ack_n_i[ig]),
               .dphy_reset_status_rx_rst_ack_n_i                   (dphy_reset_status_rx_rst_ack_n_i[ig]),
               .dphy_reset_status_tx_ready_i                       (dphy_reset_status_tx_ready_i[ig]),
               .dphy_reset_status_rx_ready_i                       (dphy_reset_status_rx_ready_i[ig]),
               .dphy_reset_status_avmm_ready_i                     (~&pld_avmm1_busy[ig]),
	       .phy_tx_pll_locked_tx_pll_locked_i                  (phy_tx_pll_locked_tx_pll_locked_i_int[ig]),
               .phy_rx_cdr_locked_rx_cdr_locked_i                  (phy_rx_cdr_locked_rx_cdr_locked_i_int[ig]),
	       .phy_rx_cdr_locked_rx_cdr_locked2data_i             (phy_rx_cdr_locked_rx_cdr_locked2data_i_int[ig]),
               .src_ctrl_rx_ignore_locked2data                     (src_ctrl_rx_ignore_locked2data[ig]),
               .fracture_status_fracture_active_i                  (fracture_active_i[ig]),
               .fracture_status_fracture_active                    (fracture_active_o[ig]),
               .clk                                                (reconfig_pdp_clk),
               .reset                                              (reconfig_pdp_reset),
               .writedata                                          (m32_writedata[ig]),
               .read                                               (m32_read[ig] & soft_csr_select[ig]),
               .write                                              (m32_write[ig] & soft_csr_select[ig]),
              .byteenable                                         (m32_byteenable[ig]),
               .readdata                                           (soft_csr_readdata[ig]),
               .readdatavalid                                      (soft_csr_readdatavalid[ig]),
               .waitrequest                                        (soft_csr_waitrequest[ig]),
               .address                                            ({m32_address[ig][9:0], 2'b00})  

                );
            

	    // TODO : coonect ports, parameter, and data/valid, waitrequest
	    // back to main I/F
	end   else begin : no_scsr
            assign m32_maib_select[ig] = ( l_av1_aib_enable && (m32_address_exp[ig][16:0] >= 17'h00400) && (m32_address_exp[ig][16:0]<=17'h007ff) )? 1'b1 : 1'b0;
	    assign m32_gdr_select[ig] = 1'b1;
            assign soft_csr_waitrequest[ig]    = 'h0;
            assign soft_csr_readdatavalid[ig]  = 'h0;
            assign soft_csr_readdata[ig]       = 'h0;
            assign soft_csr_select_reg[ig]         = 'h0; 
            assign fracture_active_o[ig]       = 'h0;
	end


       // soft dr csr, only the fracture 1 in a system has the soft DR CSR
	if (l_soft_dr_csr_enable && (ig==0)) begin : w_dr_scsr
 
           always_comb begin
                soft_csr_dr_sel[ig] = 1'b0;	
		case (m32_address_exp[ig][16:0]) inside 
		    [17'h00820:17'h0082C] : soft_csr_dr_sel[ig] = 1'b1;
		endcase
	    end

            always_ff @(posedge reconfig_pdp_clk) begin
	        soft_csr_dr_sel_reg[ig] <= soft_csr_dr_sel[ig];
	    end

           
            dphy_f_dr_csr_wrap2 # (
	       .rcfg_group              (rcfg_group),
               .enable_ready              (avmm1_ready_enable),
               .startup_reconfig_grp_value   (STARTUP_RECONFIG_GRP_VALUE), 
               .startup_fec_grp1_value       (STARTUP_FEC_GRP1_VALUE), 
               .startup_fec_grp2_value       (STARTUP_FEC_GRP2_VALUE) 
                ) dphy_f_dr_csr_wrap2_inst (
               .reconfig_group                             (reconfig_group),
               .fec_mode_group1                            (fec_mode_group1),
               .fec_mode_group2                            (fec_mode_group2),
               .clk                                                (reconfig_pdp_clk),
               .reset                                              (reconfig_pdp_reset),
               .writedata                                          (m32_writedata[ig]),
               .read                                               (m32_read[ig] & soft_csr_dr_sel[ig]),
               .write                                              (m32_write[ig] & soft_csr_dr_sel[ig]),
               .byteenable                                         (m32_byteenable[ig]),
               .readdata                                           (soft_csr_dr_readdata[ig]),
               .readdatavalid                                      (soft_csr_dr_readdatavalid[ig]),
               .waitrequest                                        (soft_csr_dr_waitrequest[ig]),
               .address                                            ({m32_address[ig][9:0], 2'b00})  
         
               );

	    // TODO : coonect ports, parameter, and data/valid, waitrequest
	    // back to main I/F
	end else begin : no_dr_scsr
            assign soft_csr_dr_waitrequest[ig]    =  'h0;
            assign soft_csr_dr_readdatavalid[ig]  =  'h0;
            assign soft_csr_dr_readdata[ig]       =  'h0;
            assign soft_csr_dr_sel[ig]            =  'h0;
            assign soft_csr_dr_sel_reg[ig]        =  'h0;
	end

	// 32 to 8 conversion
        ft_avmm_32to8_bridge 
             #(   .ADDR_WIDTH ( l_av1_addr_bits+1 ),  // expand to 17-bit physical address
	          .READ_PIPELINE_ENABLE ( avmm1_ready_enable )
	  )
          avmm_32to8_inst (
           // AVMM slave Port
           .i_clk                   ( reconfig_pdp_clk), 
           .i_rst                   ( reconfig_pdp_reset ),
           
           .i_avmm_s32_addr         ( m32_address_exp[ig][l_av1_addr_bits+2:2] ),  
           .i_avmm_s32_wdata        ( m32_writedata[ig] ), 
           .i_avmm_s32_write        ( m32_write[ig] & m32_gdr_select[ig] ), 
           .i_avmm_s32_read         ( m32_read[ig] & m32_gdr_select[ig] ), 
           .i_avmm_s32_byte_enable  ( m32_byteenable[ig] ),
           .o_avmm_s32_readdata     ( m32_readdata[ig] ), 
           .o_avmm_s32_waitrequest  ( m32_waitrequest[ig] ),
           .o_avmm_s32_readdatavalid( m32_readdatavalid[ig]),

           // Master Port
           .o_avmm_m8_addr          ( m8_addr[ig] ),
           .o_avmm_m8_wdata         ( m8_writedata[ig] ), 
           .o_avmm_m8_write         ( m8_write[ig] ), 
           .o_avmm_m8_read          ( m8_read[ig] ), 
           .i_avmm_m8_readdata      ( m8_readdata[ig] ), 
           .i_avmm_m8_waitrequest   ( m8_waitrequest[ig] )   
          );
	
        // form the address to avmm1 ports	  
	assign m8_addr_av1_b9[ig]  = (((l_av1_aib_enable & m32_maib_select[ig])) ? 1'b1 : 1'b0 );
	assign m8_addr_av1_b8[ig]  = ((l_av1_aib_enable)? (m32_maib_select[ig] | m8_addr[ig][l_av1_addr_bits+3]) : m8_addr[ig][l_av1_addr_bits+3]);

        //  expand the avmm1 address to 17-bit for each AIB I/F from 14 bit 
	//  form maib pld_avmm1_addr
	//  decoding multi-aib 
        if (ch_sel_bits==0)  begin: sin
            assign m8_addr_av1[ig] = {m8_addr[ig][16:8], m8_addr_av1_b9[ig], m8_addr_av1_b9[ig], m8_addr[ig][7:0]};
	    assign m32_address_exp[ig] = {1'b0,m32_address[ig], 2'b00};
	    assign ch_write     [0]                          = m8_write[ig];
            assign ch_read      [0]                          = m8_read[ig] ;
	    assign m8_readdata[ig]                  = ch_readdata[0];
	    assign m8_waitrequest[ig]                   = ch_waitrequest[0];
	end   else begin: mul
            wire [ch_sel_bits-1:0]             ch_sel;
            assign m32_address_exp[ig] = {m32_address[ig][l_av1_addr_bits-1:AV1_UNIT_AW], 1'b0, m32_address[ig][AV1_UNIT_AW-1:0], 2'b00} ;
            assign m8_addr_av1[ig] = {m8_addr[ig][l_av1_addr_bits+2-:ch_sel_bits], m8_addr[ig][16:8], m8_addr_av1_b9[ig], m8_addr_av1_b8[ig], m8_addr[ig][7:0]};
	    assign ch_sel  = m8_addr_av1[ig][l_av1_addr_bits+4-:ch_sel_bits];
	    assign m8_readdata[ig]                  = ch_readdata[ch_sel];
	    assign m8_waitrequest[ig]                   = ch_waitrequest[ch_sel];

	    for (aib_idx=0;aib_idx<aib_pif; aib_idx=aib_idx+1) begin: g_ch
	        localparam used_ch = pre_marked_count_dphy_f(.bit_mask(aib_used_flag), .index(aib_idx)); 
	        if (aib_used_flag[aib_idx]) begin: ch_en
	            assign ch_write     [used_ch]                   =  m8_write[ig] & (ch_sel == used_ch);
                    assign ch_read      [used_ch]                   =  m8_read[ig]  & (ch_sel == used_ch);
	        end
            end
	end     // mul
	
	// connect to avmm1 port soft logic 
	for (aib_idx=0;aib_idx<aib_pif; aib_idx=aib_idx+1) begin: g_aib
	    localparam used_ch = pre_marked_count_dphy_f(.bit_mask(aib_used_flag), .index(aib_idx)); 
	    localparam av1_cur_idx = av1_idx + aib_idx;
            if (aib_used_flag[aib_idx]) begin: g_aib_en
                ctf_avmm1_soft_logic
                #(  .avmm_interfaces(1),                                    //Number of AVMM interfaces required - one for each AIB Adapter
                    .rcfg_enable (avmm1_enable)                             //Enable/disable reconfig interface 
                 ) avmm1_ena_inst   (
                // AVMM slave interface signals (user)
                 .avmm_clk (reconfig_pdp_clk) ,
                 .avmm_reset (reconfig_pdp_reset),
                 .avmm_writedata (m8_writedata[ig]), 
                 .avmm_address (m8_addr_av1[ig][9:0]), 
                 .avmm_reservedin ( m8_addr_av1[ig][18:10] ),   
                 .avmm_write (ch_write[used_ch]),
                 .avmm_read (ch_read[used_ch]),
                 .avmm_readdata (ch_readdata[used_ch]), 
                 .avmm_waitrequest (ch_waitrequest[used_ch]),
                   
                // Signals from AVMM1 building block
                 .pld_avmm1_busy_real             ( pld_avmm1_busy[aib_idx] ),
                 .pld_avmm1_cmdfifo_wr_full_real  ( pld_avmm1_cmdfifo_wr_full[aib_idx]  ),
                 .pld_avmm1_cmdfifo_wr_pfull_real ( pld_avmm1_cmdfifo_wr_pfull[aib_idx] ),
                 .pld_avmm1_readdata_real         ( pld_avmm1_readdata[aib_idx*8+:8]     ),
                 .pld_avmm1_readdatavalid_real    ( pld_avmm1_readdatavalid[aib_idx]    ),
                 .pld_avmm1_reserved_out_real     ( pld_avmm1_reserved_out[aib_idx*3+:3] ),
                 .pld_chnl_cal_done_real          ( pld_chnl_cal_done[aib_idx]  ),        
                 .pld_hssi_osc_transfer_en_real   ( pld_hssi_osc_transfer_en[aib_idx]   ),
                // Signals to AVMM1 building block
                 .pld_avmm1_clk_rowclk_real       ( pld_avmm1_clk_rowclk[ig][aib_idx] ),
                 .pld_avmm1_read_real             ( pld_avmm1_read[ig][aib_idx] ),
                 .pld_avmm1_reg_addr_real         ( pld_avmm1_reg_addr[ig][aib_idx*10+:10] ),
                 .pld_avmm1_request_real          ( pld_avmm1_request[ig][aib_idx] ),
                 .pld_avmm1_reserved_in_real      ( pld_avmm1_reserved_in[ig][aib_idx*9+:9] ),
                 .pld_avmm1_write_real            ( pld_avmm1_write[ig][aib_idx] ),
                 .pld_avmm1_writedata_real        ( pld_avmm1_writedata[ig][aib_idx*8+:8] )

                );
	    end   else begin: g_aib_dis
                ctf_avmm1_soft_logic
                #(  .avmm_interfaces(1),                                    //Number of AVMM interfaces required - one for each AIB Adapter
                    .rcfg_enable (1'b0)                                     //Enable/disable reconfig interface 
                ) avmm1_dis_inst1   (
               // AVMM slave interface signals (user)
                .avmm_clk (1'b0) ,
                .avmm_reset (1'b0 ),
                .avmm_writedata (8'h0), 
                .avmm_address (10'h0), 
                .avmm_reservedin ( 9'h0 ),
                .avmm_write (1'b0),
                .avmm_read (1'b0),
                .avmm_readdata (), 
                .avmm_waitrequest (),

               // Signals from AVMM1 building block
                .pld_avmm1_busy_real             ( 1'b0 ),
                .pld_avmm1_cmdfifo_wr_full_real  ( 1'b0 ),
                .pld_avmm1_cmdfifo_wr_pfull_real ( 1'b0 ),
                .pld_avmm1_readdata_real         ( 8'h0 ),
                .pld_avmm1_readdatavalid_real    ( 1'b0 ),
                .pld_avmm1_reserved_out_real     ( 3'h0 ),
                .pld_chnl_cal_done_real          ( 1'b0 ),
                .pld_hssi_osc_transfer_en_real   ( 1'b0 ),
               // Signals to AVMM1 building block
                .pld_avmm1_clk_rowclk_real       ( pld_avmm1_clk_rowclk[ig][aib_idx] ),
                .pld_avmm1_read_real             ( pld_avmm1_read[ig][aib_idx] ),
                .pld_avmm1_reg_addr_real         ( pld_avmm1_reg_addr[ig][aib_idx*10+:10] ),
                .pld_avmm1_request_real          ( pld_avmm1_request[ig][aib_idx] ),
                .pld_avmm1_reserved_in_real      ( pld_avmm1_reserved_in[ig][aib_idx*9+:9] ),
                .pld_avmm1_write_real            ( pld_avmm1_write[ig][aib_idx] ),
                .pld_avmm1_writedata_real        ( pld_avmm1_writedata[ig][aib_idx*8+:8] )
               );
	    end

        end   // g_aib

    end   // av1_sys
  end   // av1_ena
  else begin:av1_dis
      assign  reconfig_pdp_readdata        = 'h0;
      assign  reconfig_pdp_waitrequest     = 'h0;
      assign  reconfig_pdp_readdatavalid   = 'h0;
      assign  pld_avmm1_clk_rowclk         = 'h0;
      assign  pld_avmm1_read               = 'h0;
      assign  pld_avmm1_reg_addr           = 'h0;
      assign  pld_avmm1_request            = 'h0;
      assign  pld_avmm1_reserved_in        = 'h0;
      assign  pld_avmm1_write              = 'h0;
      assign  pld_avmm1_writedata          = 'h0; 
      assign soft_csr_select_reg           = 'h0;
      assign soft_csr_dr_sel               =  'h0;
      assign soft_csr_dr_sel_reg           =  'h0;
  end                                      
                                           
    if (!avmm1_enable || !l_soft_csr_enable  ) begin: g_nocsr
        assign  dphy_reset_soft_tx_rst = 'h0; 
        assign  dphy_reset_soft_rx_rst = 'h0; 
        assign  dphy_reset_tx_rst_ovr  = 'h0; 
        assign  dphy_reset_rx_rst_ovr  = 'h0; 
        assign  src_ctrl_rx_ignore_locked2data = 'h0; 
    end

    if (!avmm1_enable || !l_soft_dr_csr_enable  ) begin: g_no_dr_csr
	    assign reconfig_group    = 'h0;
	    assign fec_mode_group1   = 'h0;
	    assign fec_mode_group2   = 'h0;
       end	    
endgenerate

endmodule



`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "wMvh5WeSJ4yGK5fzlSHQo33trUbIGPuu6AAZ1Jw1HX5bCWCgWjwOo63MpQJb+tyuuoVl1sY1EE2DpgUFbb2nZcELI6w3Dq8aadyjb3RnpdVKr48biETVE8F96I9Tryb/L/IQERkMvDdQg0U5k2cn23HZ40RNq2jNyS5tFpmDEAXaRVqHKNpKT+oJ1S8m/MT3Nd2fNSfGbw48ZXJo0gQiVatAerzeuRwUZtvBwHQkHrsnuMYRJp2UDFwZNMRiaDsmoCvkyVbVHqmV8XENgHb+p9iOp8xjc2HfQHdsXyX9RRikBU/gjbpFakoawZphocJDcxyyUSa8vvSjbiAbYbTenBMugTRov6PufqCN6rtpnOdovfrtzy+vziZXQdk1MKl/QAuo9F3VusKvDMGUUPgH3s8dnizuWR3h+EPcBA+Rkh4C7P2B19aENYOcvuN4yhYxfMpqewntT+BlJHfDVHCXck/NR0QrJ4tsyUixBx7+YvUemEOvXO3ossTJ+8OGN7m9y2DpSYNiJWmg/pDAtcsDLwLCfPgV/gsc+0VuYZjzdWrX2ZwQjpiHBFLp3HXS191WOBns7MNIy8ub3UCuiUBZeY2trbWYqZe1S/+QAbv8XSdnyzIGmBsKKC5iW+VfoVhR7oCpGKz9x6TMAj9ApgT3ffwMOT91aK3EtSQ0W4ahSUF/k7Cv/c9xXtdxjSdYm/iaXKSlW1D9k5ddxn6VX5qzJ5HQDj9GxoEf6rzwmRUwENAOmIMd5r16Dx4Y6UMX2E6p6Ai553wsBFz8lmc23pW4rdzJ8GeENWHmIOHJox2YBib8Opx/IVZM4pT1nr1Td2e18xJAmxDzdrRdwZYesMVbt17y1TRG0ex3Pw62mGsbgdsIXWaoIAjUaNyRoG5HwX9EJ+bA7T8oYlORcZ8410eJAGW6XzKrxwJ1hIGwcmAUQ8yfMtbzdv22aW4V97LcLet0ow3XmSfLG9v5JDX3XWmYMs+xdhUcZ3R82lYx4MrtaFb2PZg+c4AQuMzFcJ/TVIxG"
`endif