// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps/1 ps
module dphy_f_dr_avmm2 #(
    parameter          num_sys_cop                                           = 1,
    parameter          num_subsys_cop                                           = 1,
    parameter          num_xcvr_per_sys                                         = 1,
    parameter          l_num_aib_per_xcvr                                       = 1,
    parameter          l_sys_xcvrs                                              = 1,
    parameter          l_tx_enable                                              = 1,
    parameter          l_rx_enable                                              = 1,
    parameter          reconfig_xcvr_address_width                              = 18, 
    parameter          avmm2_ready_enable                                      = 0,
    parameter          avmm2_enable                                             = 0,
    parameter          l_num_avmm2                                              = 1,
    parameter          l_av2_ifaces                                             = 1,
    parameter          l_av2_addr_bits                                          = 18,
    parameter          DATA_WIDTH                                               = 32

    ) (  

  input               reconfig_clk,             //       reconfig_clk.clk
  input               reconfig_reset,           //     reconfig_reset.reset
  input               reconfig_write,           //      reconfig_avmm.write
  input               reconfig_read,            //                   .read
  input   [reconfig_xcvr_address_width-1:0]      reconfig_address,         //                   .address
  input   [DATA_WIDTH/8-1:0]    reconfig_byteenable,       //                   .byteenable
  input   [DATA_WIDTH-1:0]      reconfig_writedata,       //                   .writedata
  output  [num_subsys_cop-1:0][DATA_WIDTH-1:0]      reconfig_readdata,        //                   .readdata
  output  [num_subsys_cop-1:0]         reconfig_waitrequest,     //                   .waitrequest
  output  [num_subsys_cop-1:0]         reconfig_readdatavalid,   //                   .readdatavalid

  //  for AVMM2 bb ports
  input   wire  [8*l_sys_xcvrs-1:0]    hip_avmm_readdata,
  input   wire  [l_sys_xcvrs-1:0]      hip_avmm_readdatavalid,
  input   wire  [5*l_sys_xcvrs-1:0]    hip_avmm_reserved_out,
  input   wire  [l_sys_xcvrs-1:0]      hip_avmm_writedone,
  input   wire  [l_sys_xcvrs-1:0]      pld_avmm2_busy,
  input   wire  [l_sys_xcvrs-1:0]      pld_avmm2_cmdfifo_wr_full,
  input   wire  [l_sys_xcvrs-1:0]      pld_avmm2_cmdfifo_wr_pfull,
  input   wire  [l_sys_xcvrs-1:0]      pld_pll_cal_done,
  output  wire  [num_subsys_cop-1:0] [21*l_sys_xcvrs-1:0]   hip_avmm_reg_addr,
  output  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      hip_avmm_read,
  output  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      hip_avmm_write,
  output  wire  [num_subsys_cop-1:0] [8*l_sys_xcvrs-1:0]    hip_avmm_writedata,
  output  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      pld_avmm2_clk_rowclk,
  output  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      pld_avmm2_request,
          // below are unused ports in hip mode
  input   wire  [8*l_sys_xcvrs-1:0]    pld_avmm2_readdata,
  input   wire  [l_sys_xcvrs-1:0]      pld_avmm2_readdatavalid,
  input   wire  [l_sys_xcvrs-1:0]      pld_avmm2_reserved_out,
  output  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      pld_avmm2_write,
  output  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      pld_avmm2_read,
  output  wire  [num_subsys_cop-1:0] [9*l_sys_xcvrs-1:0]    pld_avmm2_reg_addr,
  output  wire  [num_subsys_cop-1:0] [8*l_sys_xcvrs-1:0]    pld_avmm2_writedata,
  output  wire  [num_subsys_cop-1:0] [6*l_sys_xcvrs-1:0]    pld_avmm2_reserved_in
);


  //\TODO  TEMPORARILY COPIED FUNCTION UNTIL TILE_IP HANDLES PACKAGES PROPERLY
    localparam integer MAX_CHARS_ALT_XCVR_NATIVE_S10 = 86; // To accomodate LONG parameter lists.
  ////////////////////////////////////////////////////////////////////
  // Convert an integer to a string
  function [MAX_CHARS_ALT_XCVR_NATIVE_S10*8-1:0] int2str_alt_xcvr_native_s10(
    input integer in_int
  );
    integer i;
    integer this_char;
    i = 0;
    int2str_alt_xcvr_native_s10 = "";
    do
    begin
      this_char = (in_int % 10) + 48;
      int2str_alt_xcvr_native_s10[i*8+:8] = this_char[7:0];
      i=i+1;
      in_int = in_int / 10; 
    end
    while(in_int > 0);
  endfunction

localparam  xcvr_pif    = l_sys_xcvrs;
localparam  ch_sel_bits = l_av2_addr_bits-18;
localparam  BE_WIDTH    = DATA_WIDTH/8;

wire    [DATA_WIDTH-1:0]      m32_writedata   [num_subsys_cop-1:0];
wire    [DATA_WIDTH-1:0]      m32_readdata    [num_subsys_cop-1:0];
wire    [l_av2_addr_bits-1:0] m32_address     [num_subsys_cop-1:0];
wire    [3:0]                 m32_byteenable  [num_subsys_cop-1:0];

wire    [7:0]                 m8_writedata   [num_subsys_cop-1:0];
wire    [7:0]                 m8_readdata    [num_subsys_cop-1:0];
wire    [l_av2_addr_bits+2:0] m8_addr        [num_subsys_cop-1:0];  // from coverter, as <Dword Access>, <ch_sel>, [19:0]
wire    [l_av2_addr_bits+2:0] m8_addr_av2    [num_subsys_cop-1:0];  // arranged as <ch_sel>, <Dword Access>,  [19:0]


wire    [num_subsys_cop -1:0] m32_read;
wire    [num_subsys_cop -1:0] m32_write;
wire    [num_subsys_cop -1:0] m32_waitrequest;
wire    [num_subsys_cop -1:0] m32_readdatavalid;
wire    [num_subsys_cop -1:0] m8_read;
wire    [num_subsys_cop -1:0] m8_write;
wire    [num_subsys_cop -1:0] m8_waitrequest;




genvar ig, ifs_idx, xcvr_idx;
generate
  if (avmm2_enable) begin: av2_ena
    for(ig=0;ig<num_subsys_cop;ig=ig+1) begin: av2_sys 
	localparam  av2_idx     = ig*xcvr_pif;
	// per xcvr read/write signals for soft csr and avmm port
	wire [xcvr_pif-1:0] ch_write, ch_read, ch_waitrequest;
	wire [xcvr_pif-1:0] csr_write, csr_read, csr_waitrequest;
	wire [xcvr_pif-1:0] [7:0] ch_readdata, csr_readdata ;

             assign reconfig_readdata[ig]      = m32_readdata[ig];
             assign reconfig_waitrequest[ig] = m32_waitrequest[ig];
	     assign reconfig_readdatavalid[ig] = m32_readdatavalid[ig];
             
	     assign m32_read[ig]         = reconfig_read;
             assign m32_write[ig]        = reconfig_write;
             assign m32_address[ig]      = reconfig_address;
             assign m32_byteenable[ig]   = reconfig_byteenable;
             assign m32_writedata[ig]    = reconfig_writedata;


    	    // 32 to 8 conversion
        ft_avmm_32to8_bridge 
             #(   .ADDR_WIDTH ( l_av2_addr_bits ),
	          .READ_PIPELINE_ENABLE ( avmm2_ready_enable )
	     )
          avmm_32to8_inst (
           // AVMM slave Port
           .i_clk                   ( reconfig_clk ), 
           .i_rst                   ( reconfig_reset ),
           
           .i_avmm_s32_addr         ( m32_address[ig] ),  
           .i_avmm_s32_wdata        ( m32_writedata[ig] ), 
           .i_avmm_s32_write        ( m32_write[ig] ), 
           .i_avmm_s32_read         ( m32_read[ig] ), 
           .i_avmm_s32_byte_enable  ( m32_byteenable[ig] ),
           .o_avmm_s32_readdata     ( m32_readdata[ig] ), 
           .o_avmm_s32_waitrequest  ( m32_waitrequest[ig] ),
           .o_avmm_s32_readdatavalid ( m32_readdatavalid[ig] ),

           // Master Port
           .o_avmm_m8_addr          ( m8_addr[ig] ),
           .o_avmm_m8_wdata         ( m8_writedata[ig] ), 
           .o_avmm_m8_write         ( m8_write[ig] ), 
           .o_avmm_m8_read          ( m8_read[ig] ), 
           .i_avmm_m8_readdata      ( m8_readdata[ig] ), 
           .i_avmm_m8_waitrequest   ( m8_waitrequest[ig] )   
          );
	
        //  form the hip_avmm2_addr
	//  decoding multi-xcvr 
        if (ch_sel_bits==0)  begin: sin
             assign m8_addr_av2[ig] = m8_addr[ig] ;
	     assign ch_write     [0]                          = m8_write[ig];
             assign ch_read      [0]                          = m8_read[ig] ;
	     assign m8_readdata[ig]                  = ch_readdata[0];
	     assign m8_waitrequest[ig]                   = ch_waitrequest[0];
	end   else begin: mul
             wire [ch_sel_bits-1:0]             ch_sel;
             assign m8_addr_av2[ig] = {m8_addr[ig][l_av2_addr_bits+1:20], m8_addr[ig][l_av2_addr_bits+2], m8_addr[ig][19:0]};

	     assign ch_sel  = m8_addr_av2[ig][l_av2_addr_bits+2-:ch_sel_bits];

	     for(xcvr_idx=0;xcvr_idx<xcvr_pif; xcvr_idx=xcvr_idx+1) begin: g_xcvr
	             assign ch_write     [xcvr_idx]                   = m8_write[ig] & (ch_sel == xcvr_idx);
                     assign ch_read      [xcvr_idx]                   = m8_read[ig]  & (ch_sel == xcvr_idx);
             end

	     assign m8_readdata[ig]                  = ch_readdata[ch_sel];
	     assign m8_waitrequest[ig]                   = ch_waitrequest[ch_sel];
	end     // mul

	// connect to avmm2 port soft logic 
        ctf_avmm2_soft_logic
        #(  .avmm_interfaces       (xcvr_pif),                 //Number of AVMM ports required - one for each xcvr channel or PCIe HIP
            .rcfg_enable           (avmm2_enable)               //Enable/disable reconfig interface in the XCVR PMA or PCIe IPs
         ) avmm2_cl_inst   (
        // AVMM slave interface signals (user)
         .avmm_clk                 ( {xcvr_pif{reconfig_clk}} ) ,
         .avmm_reset               ( {xcvr_pif{reconfig_reset}} ),
         .avmm_writedata           ( {xcvr_pif{m8_writedata[ig]}}), 
         .avmm_address             ( {xcvr_pif{m8_addr_av2[ig][0+:21]}} ), 
         .avmm_write               ( ch_write ),
         .avmm_read                ( ch_read ),
         .avmm_readdata            ( ch_readdata ), 
         .avmm_waitrequest         ( ch_waitrequest ),
        //AVMM interface busy with calibration
         .avmm_busy (),
           
        // Expose clkchnl to wire up with pld_adapt avmmclk for Place and Route in Fitter
        .avmm_clkchnl (),

        // ports to/from hip ports of building block
         .hip_avmm_read_real             ( hip_avmm_read[ig][xcvr_pif-1:0] ),
         .hip_avmm_readdata_real         ( hip_avmm_readdata[xcvr_pif*8-1:0] ),
         .hip_avmm_readdatavalid_real    ( hip_avmm_readdatavalid[xcvr_pif-1:0] ),
         .hip_avmm_reg_addr_real         ( hip_avmm_reg_addr[ig][xcvr_pif*21-1:0] ),
         .hip_avmm_reserved_out_real     ( hip_avmm_reserved_out[xcvr_pif*5-1:0] ),
         .hip_avmm_write_real            ( hip_avmm_write[ig][xcvr_pif-1:0] ),
         .hip_avmm_writedata_real        ( hip_avmm_writedata[ig][xcvr_pif*8-1:0] ),
         .hip_avmm_writedone_real        ( hip_avmm_writedone[xcvr_pif-1:0] ),
         .pld_avmm2_busy_real            ( pld_avmm2_busy[xcvr_pif-1:0] ),
         .pld_avmm2_clk_rowclk_real      ( pld_avmm2_clk_rowclk[ig][xcvr_pif-1:0] ),
         .pld_avmm2_cmdfifo_wr_full_real ( pld_avmm2_cmdfifo_wr_full[xcvr_pif-1:0] ),
         .pld_avmm2_cmdfifo_wr_pfull_real( pld_avmm2_cmdfifo_wr_pfull[xcvr_pif-1:0] ),
         .pld_avmm2_request_real         ( pld_avmm2_request[ig][xcvr_pif-1:0] ),
         .pld_pll_cal_done_real          ( pld_pll_cal_done[xcvr_pif-1:0] ),
        // below are unused ports in hip mode
         .pld_avmm2_write_real           ( pld_avmm2_write[ig][xcvr_pif-1:0] ),
         .pld_avmm2_read_real            ( pld_avmm2_read[ig][xcvr_pif-1:0] ),
         .pld_avmm2_reg_addr_real        ( pld_avmm2_reg_addr[ig][xcvr_pif*9-1:0] ),
         .pld_avmm2_readdata_real        ( pld_avmm2_readdata[xcvr_pif*8-1:0] ),
         .pld_avmm2_writedata_real       ( pld_avmm2_writedata[ig][xcvr_pif*8-1:0] ),
         .pld_avmm2_readdatavalid_real   ( pld_avmm2_readdatavalid[xcvr_pif-1:0] ),
         .pld_avmm2_reserved_in_real     ( pld_avmm2_reserved_in[ig][xcvr_pif*6-1:0] ),
         .pld_avmm2_reserved_out_real    ( pld_avmm2_reserved_out[xcvr_pif-1:0] )
         );


    end   // av2_sys
  end   // av2_ena
  else begin: av2_dis
      assign  reconfig_readdata           = 'h0;
      assign  reconfig_waitrequest        = 'h0;
      assign  reconfig_readdatavalid      = 'h0;
      assign  hip_avmm_read               = 'h0;
      assign  hip_avmm_reg_addr           = 'h0;
      assign  hip_avmm_write              = 'h0;
      assign  hip_avmm_writedata          = 'h0; 
      assign  pld_avmm2_clk_rowclk        = 'h0;
      assign  pld_avmm2_request           = 'h0;
      assign  pld_avmm2_reserved_in       = 'h0;
      assign  pld_avmm2_read              = 'h0;
      assign  pld_avmm2_reg_addr          = 'h0;
      assign  pld_avmm2_write             = 'h0;
      assign  pld_avmm2_writedata         = 'h0; 
  end                                      
endgenerate

endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRxyQux7SmmH6nGrurLRsLR4OGOuecpjPLrR5MR0igJV/tDQxAlXRCyaX1qF9Eg3VWQ/EGqEA++hI/adNd2EDBLtAkBIfx7fIW8f4rwCbi43nP6/1q8cgsBX+6vOxWyQW8j5XfuuZlOmbhOoR/66A3/UWHqfN96yY/OCwQPaq/9QcgFwjqFdWCKbf0UrS+g1JLXNx96BFh+rcGg2t9+P197iqk/2uGSJVWmIscMq1ror+iTe6KhW4Al4uKFakNcyjsek0Q2rzbGZGe9nTSZdZqfad4twhMyOlr7ejislqh9xwuFh5gWNMdWgZmXvV+q6zBjsnlMbKYsg9zy3J35rkROD0S4ygHQXkrXmS1ixx7ZGv2kLxuT6knry/BSIruztcecx3IBvni7snO/epr0pWhbSkqJiqatt9UbAQqOnzWb4B0pofKxlkyJOgakQooNvsS9Oec+CFczsv7Ojo5gzA4xyOmun/5okb1e9cTElgBaSZZLjNyRr5VlBVovnCsDePikYQ6EtVimclG81EEM8TBpfMpQfmo/VCYFHJ4uJxLJ8gdJaQ8h3Ug2pejXkzB3A6Ow9GPZLrfNazVrLBLibR8eptbRuDf7UPuU5EvFqk7aNA/lPkAk6cl2LbnQJipVg2gDNLEIGOWnis4oM7Eybm7nsdLpj8YK2OL60vSqrVvs4fnMEHcxuj8gz5wzMgyEG+F0GbU599gtWNENf712qoSjaRWGmfr6qhGPA7kheYJPRSMT6nxFT75lkMSY4iEcb533ykn7XPjgdeU48qVh8HO1S"
`endif