// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


//-----------------------------------------------------------------------------------------------//
//   dphy_f_csr_wrap                                   
//   convert parameters to register inputs, generate waitrequest     
//   synchronizers for signals from different clock domains
//-----------------------------------------------------------------------------------------------//


`timescale 1 ps/1 ps 
module dphy_f_dr_csr_wrap1 # (
parameter enable_ready = 0,
parameter [11:0] line_rate_p1ghz = 12'd250,
parameter [0:0] xcvr_type     = 1'b0,
parameter [0:0] modulation_type = 1'b0,
parameter [4:0] num_xcvr      = 5'h01,
parameter [4:0] num_aib       = 5'h01,
parameter [0:0] fec_enable    = 1'b0,
parameter [1:0] duplex_mode   = 2'b11
) (
// register offset : 0x808, field offset : 0, access : RW, dphy_reset.soft_tx_rst
output  wire dphy_reset_soft_tx_rst,
// register offset : 0x808, field offset : 1, access : RW, dphy_reset.soft_rx_rst
output  wire dphy_reset_soft_rx_rst,
// register offset : 0x808, field offset : 4, access : RW, dphy_reset.tx_rst_ovr
output  wire dphy_reset_tx_rst_ovr,
// register offset : 0x808, field offset : 5, access : RW, dphy_reset.rx_rst_ovr
output  wire dphy_reset_rx_rst_ovr,
// register offset : 0x80c, field offset : 0, access : RO, dphy_reset_status.tx_rst_ack_n
input   dphy_reset_status_tx_rst_ack_n_i,
// register offset : 0x80c, field offset : 1, access : RO, dphy_reset_status.rx_rst_ack_n
input   dphy_reset_status_rx_rst_ack_n_i,
// register offset : 0x80c, field offset : 4, access : RO, dphy_reset_status.tx_ready
input   dphy_reset_status_tx_ready_i,
// register offset : 0x80c, field offset : 5, access : RO, dphy_reset_status.rx_ready
input   dphy_reset_status_rx_ready_i,
// register offset : 0x80c, field offset : 7, access : RO, dphy_reset_status.avmm_ready
input   dphy_reset_status_avmm_ready_i,
// register offset : 0x810, field offset : 0, access : RO, phy_tx_pll_locked.tx_pll_locked
input  [num_xcvr-1:0] phy_tx_pll_locked_tx_pll_locked_i,
// register offset : 0x814, field offset : 0, access : RO, phy_rx_cdr_locked.rx_cdr_locked
input  [num_xcvr-1:0] phy_rx_cdr_locked_rx_cdr_locked_i,
// register offset : 0x814, field offset : 16, access : RO, phy_rx_cdr_locked.rx_cdr_locked2data
input  [num_xcvr-1:0] phy_rx_cdr_locked_rx_cdr_locked2data_i,
// register offset : 0x818, field offset : 0, access : RW, src_ctrl.rx_ignore_locked2data
output  wire src_ctrl_rx_ignore_locked2data,
// register offset : 0x81c, field offset : 0, access : RO, fracture_status.fracture_active
input   fracture_status_fracture_active_i,
output wire  fracture_status_fracture_active,
input rsfec_on,
input [4:0] num_aibs_per_sys,
input [4:0] xcvr_cnt_per_fracture,
input [11:0] startup_line_rate_p1ghz,
input startup_modulation_type,

//Bus Interface
input clk,
input reset,
input [31:0] writedata,
input read,
input write,
input [3:0] byteenable,
output wire [31:0] readdata,
output wire readdatavalid,
output wire waitrequest,
input [11:0] address  

);

wire       reset_sync;

wire rx_rst_ack_n_sync;
wire rx_ready_sync;
wire [15:0] rx_cdr_locked_sync;
wire [15:0] rx_cdr_locked2data_sync;

wire tx_rst_ack_n_sync;
wire tx_ready_sync;
wire [15:0] tx_pll_locked_sync;

assign waitrequest = ~ ( write | ((enable_ready)? readdatavalid : readdatavalid) );


dphy_f_dr_soft_csr1     dphy_f_dr_soft_csr1_inst (

    .gui_option_line_rate_p1ghz_i                               (startup_line_rate_p1ghz),
    .gui_option_xcvr_type_i                                     (xcvr_type),
    .gui_option_modulation_type_i                               (startup_modulation_type),
    .gui_option_num_xcvr_i                                      (xcvr_cnt_per_fracture),
    .gui_option_fec_enable_i                                    (rsfec_on),
    .gui_option_num_aib_i                                       (num_aibs_per_sys),
    .gui_option_duplex_mode_i                                   (duplex_mode),
    .dphy_reset_soft_tx_rst                                     (dphy_reset_soft_tx_rst),
    .dphy_reset_soft_rx_rst                                     (dphy_reset_soft_rx_rst),
    .dphy_reset_tx_rst_ovr                                      (dphy_reset_tx_rst_ovr),
    .dphy_reset_rx_rst_ovr                                      (dphy_reset_rx_rst_ovr),
    .dphy_reset_status_tx_rst_ack_n_i                           (tx_rst_ack_n_sync),
    .dphy_reset_status_rx_rst_ack_n_i                           (rx_rst_ack_n_sync),
    .dphy_reset_status_tx_ready_i                               (tx_ready_sync),
    .dphy_reset_status_rx_ready_i                               (rx_ready_sync),
    .dphy_reset_status_avmm_ready_i                             (dphy_reset_status_avmm_ready_i),
    .phy_tx_pll_locked_tx_pll_locked_i                          (tx_pll_locked_sync),
    .phy_rx_cdr_locked_rx_cdr_locked_i                          (rx_cdr_locked_sync),
    .phy_rx_cdr_locked_rx_cdr_locked2data_i                     (rx_cdr_locked2data_sync),
    .src_ctrl_rx_ignore_locked2data                             (src_ctrl_rx_ignore_locked2data),
    .fracture_status_fracture_active_i                          (fracture_status_fracture_active_i),
    .fracture_status_fracture_active                            (fracture_status_fracture_active),
    .clk                                                        (clk),
    .reset                                                      (reset_sync),
    .writedata                                                  (writedata),
    .read                                                       (read),
    .write                                                      (write),
    .byteenable                                                 (byteenable),
    .readdata                                                   (readdata),
    .readdatavalid                                              (readdatavalid),
    .address                                                    (address)
);

    alt_xcvr_resync_etile #(
        .SYNC_CHAIN_LENGTH (3),
        .WIDTH(1)
    )
      reset_sync_inst  (
        .clk   (clk),
        .reset (1'b0),
        .d     ( reset ),
        .q     ( reset_sync )
      );    


generate if (duplex_mode[1]) begin: tx_enabled
    alt_xcvr_resync_etile #(
        .SYNC_CHAIN_LENGTH (3),
        .WIDTH(num_xcvr+2)
    )
      rst_txpll_xfr_sync_inst  (
        .clk   (clk),
        .reset (1'b0),
        .d     ( { phy_tx_pll_locked_tx_pll_locked_i, dphy_reset_status_tx_rst_ack_n_i, dphy_reset_status_tx_ready_i} ),
        .q     ( { tx_pll_locked_sync[0+:num_xcvr], tx_rst_ack_n_sync, tx_ready_sync} )
      );    
    if (num_xcvr<16) begin: fill_xcvr_tx_slot
        assign tx_pll_locked_sync[15:num_xcvr] = 'h0;
    end
end else begin: tx_disabled
    assign tx_rst_ack_n_sync = 1'b1;
    assign tx_ready_sync     = 1'b0;
    assign tx_pll_locked_sync = 16'h0;
end
endgenerate

generate if (duplex_mode[0]) begin: rx_enabled
    alt_xcvr_resync_etile #(
        .SYNC_CHAIN_LENGTH (3),
        .WIDTH(num_xcvr*2+2)
    )
      rst_rxpll_xfr_sync_inst  (
        .clk   (clk),
        .reset (1'b0),
        .d     ( { phy_rx_cdr_locked_rx_cdr_locked2data_i, phy_rx_cdr_locked_rx_cdr_locked_i, dphy_reset_status_rx_rst_ack_n_i, dphy_reset_status_rx_ready_i} ),
        .q     ( { rx_cdr_locked2data_sync[0+:num_xcvr], rx_cdr_locked_sync[0+:num_xcvr], rx_rst_ack_n_sync, rx_ready_sync} )
      );    
    if (num_xcvr<16) begin: fill_xcvr_rx_slot
        assign rx_cdr_locked_sync[15:num_xcvr] = 'h0;
        assign rx_cdr_locked2data_sync[15:num_xcvr] = 'h0;
    end
end else begin: rx_disabled
    assign rx_rst_ack_n_sync = 1'b1;
    assign rx_ready_sync     = 1'b0;
    assign rx_cdr_locked_sync = 16'h0;
    assign rx_cdr_locked2data_sync = 16'h0;
end
endgenerate



endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRxXIBu4qj0FrBYxlG5M91MefAei3OckvUTFBK03ibKWUyz+v2DC+0GW7fZplCR3rLA5uiJxSLeCnbtVyx3Ew143/WOjlxh0z2+ZG3Ox8MNtJrXhVJmjyySlPnUEAiTMZYG2UPXHD+qKLw8nOaDG33frYu42+aaZe7iRXiqvCbVBbGik1oMeuvsyzDhOeeKd5uDlxBdkG+99FfWgcE9zcqMEIDlb0HAaYq/GtNsIytuIYhoiEBOa9AsXGtwHitFs/qXlmz2JnliavGgaNjAHeGyaGUMjp9bJU34FbJiTPZSIOKdSH8kJvKC5o2qnd5/3OgrUxUmlF9kL3ekfnMYYFS91LHI5y3wpcUD35Fe7pDI7h0jz8DhIkx6XBQoJqHU4W5+aP1S5OMOEOjSHKw/g9K1xlXkxrBOI4IYlicK+2CkuJ9bQU+8XPUHrISQQKzHA9NOsG4LQFoz/GI8/IEcuvdEwWfy0j8vEKNNBWaVPQwW5RNxpvYh3hH1L+6FRiA9twcoJB7JvhhmspJV99lK6TZhQjB8gjbrnjR0pDdJYr5+j34yWgEB6H9wZdhWPEnA3lhRRhn4HybSG8qiC2qPEQYMgqnT1zWEdjwUQkYbl+tTNd8ZRNDyOgLg4poA8SSCqYVOEsPINE5hVUVzAV2QgxSgCvmVpTdXEeW9Odm1XhVpd1pwhW6rU3a9OD2I3ZV24XmbbHwP2Le+JTT44XGn/OsDwUWqtASe7vYLvaFRw3JLcnsMQ+pNiG50sr29beBXIB4SzszGpEzHbEUbYcsE45Yvi"
`endif