// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


//-----------------------------------------------------------------------------------------------//
//   dphy_f_csr_wrap                                   
//   convert parameters to register inputs, generate waitrequest     
//   synchronizers for signals from different clock domains
//-----------------------------------------------------------------------------------------------//


`timescale 1 ps/1 ps 
module dphy_f_dr_csr_wrap2 # (
parameter rcfg_group = "25G-1",
parameter enable_ready = 0,
parameter [13:0] startup_reconfig_grp_value = 0,
parameter [31:0] startup_fec_grp1_value = 0,
parameter [31:0] startup_fec_grp2_value = 0
) (
// DR Registers	
output  reg[13:0] reconfig_group,
output  reg[31:0] fec_mode_group1,
output  reg[31:0] fec_mode_group2,
//Bus Interface
input clk,
input reset,
input [31:0] writedata,
input read,
input write,
input [3:0] byteenable,
output wire [31:0] readdata,
output wire readdatavalid,
output wire waitrequest,
input [11:0] address  

);

wire       reset_sync;
wire [31:0]      fec_mode_group1_w;
wire [31:0]      fec_mode_group2_w;
wire [13:0]      reconfig_group_w;
assign waitrequest = ~ ( write | ((enable_ready)? readdatavalid : readdatavalid) );

wire [3:0]    error_status_i;
wire [4:0]    fracture_cnt ;
wire [4:0]    xcvr_cnt_per_fracture;
wire [3:0]    rate_per_xcvr;
wire [47:0]   fec_on;
wire [3:0]    error_status_o;

assign fracture_cnt          =  reconfig_group_w[13:9];
assign xcvr_cnt_per_fracture =  reconfig_group_w[8:4];
assign rate_per_xcvr         =  reconfig_group_w[3:0];
assign fec_on  = {fec_mode_group2[15:0],fec_mode_group1};

			
assign 	error_status_i[0] =  ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "100G-1") && (fracture_cnt > 1)) ? 1'b1 :
                             ((rcfg_group == "50G-2" || rcfg_group == "100G-2" || rcfg_group == "200G-2") && (fracture_cnt > 2)) ? 1'b1 :
		             ((rcfg_group == "100G-4" || rcfg_group == "200G-4" || rcfg_group == "400G-4") && (fracture_cnt > 4 || fracture_cnt == 3)) ? 1'b1 :
		             ((rcfg_group == "200G-8" || rcfg_group == "400G-8") && (fracture_cnt > 8 || fracture_cnt == 3 || fracture_cnt == 5 || fracture_cnt == 6 || fracture_cnt == 7)) ? 1'b1 :
		             ((rcfg_group == "150G-6") && (fracture_cnt > 6 || fracture_cnt == 2 || fracture_cnt == 4 || fracture_cnt == 5)) ? 1'b1 :
		             ((rcfg_group == "300G-12") && (fracture_cnt > 12 || fracture_cnt == 4 || fracture_cnt == 5 || fracture_cnt == 7 || fracture_cnt == 8 || fracture_cnt == 9 || fracture_cnt == 10 || fracture_cnt == 11)) ? 1'b1 : 1'b0;

assign 	error_status_i[1] =  ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "100G-1") && (xcvr_cnt_per_fracture > 1)) ? 1'b1 :
                             ((rcfg_group == "50G-2" || rcfg_group == "100G-2" || rcfg_group == "200G-2") && (xcvr_cnt_per_fracture > 2)) ? 1'b1 :
		             ((rcfg_group == "100G-4" || rcfg_group == "200G-4" || rcfg_group == "400G-4") && (xcvr_cnt_per_fracture > 4 || xcvr_cnt_per_fracture == 3)) ? 1'b1 :
		             ((rcfg_group == "200G-8" || rcfg_group == "400G-8") && (xcvr_cnt_per_fracture > 8 || xcvr_cnt_per_fracture == 3 || xcvr_cnt_per_fracture == 5 || xcvr_cnt_per_fracture == 6 || xcvr_cnt_per_fracture == 7)) ? 1'b1 :
		             ((rcfg_group == "150G-6") && (xcvr_cnt_per_fracture > 6 || xcvr_cnt_per_fracture == 3 || xcvr_cnt_per_fracture == 4 || xcvr_cnt_per_fracture == 5)) ? 1'b1 :
		             ((rcfg_group == "300G-12") && (xcvr_cnt_per_fracture > 12 || xcvr_cnt_per_fracture == 3 || xcvr_cnt_per_fracture == 5 || xcvr_cnt_per_fracture == 7 || xcvr_cnt_per_fracture == 8 || xcvr_cnt_per_fracture == 9 || xcvr_cnt_per_fracture == 10 || xcvr_cnt_per_fracture == 11)) ? 1'b1 : 1'b0;

assign  error_status_i[2] =  ((rcfg_group == "25G-1" || rcfg_group == "50G-2" || rcfg_group == "100G-4" || rcfg_group == "150G-6" || rcfg_group == "200G-8" || rcfg_group == "300G-12") && (rate_per_xcvr > 1)) ? 1'b1 :   
		             ((rcfg_group == "50G-1" || rcfg_group == "100G-2" || rcfg_group == "200G-4" || rcfg_group == "400G-8") && (rate_per_xcvr > 2)) ? 1'b1 : 
			     ((rcfg_group == "100G-1" || rcfg_group == "200G-2" || rcfg_group == "400G-4") && (rate_per_xcvr > 3)) ? 1'b1 : 1'b0;   

assign  error_status_i[3] =  ((rcfg_group == "25G-1" || rcfg_group == "50G-1" || rcfg_group == "100G-1") && (fec_on[47:4] >= 1)) ? 1'b1 :   
                             ((rcfg_group == "50G-2" || rcfg_group == "100G-2" || rcfg_group == "200G-2") && (fec_on[47:8] >= 1)) ? 1'b1 :  
			     ((rcfg_group == "100G-4" || rcfg_group == "200G-4" || rcfg_group == "400G-4") && (fec_on[47:16] >= 1)) ? 1'b1 :
			     ((rcfg_group == "200G-8" || rcfg_group == "400G-8") && (fec_on[47:32] >= 1)) ? 1'b1 : 
			     ((rcfg_group == "150G-6") && (fec_on[47:24] >= 1)) ? 1'b1 : 1'b0; 


always@(posedge clk or posedge reset) begin
if(reset)
  reconfig_group <= startup_reconfig_grp_value;
else if(error_status_i[2:0] == 0 )
  reconfig_group <= reconfig_group_w;
else 
  reconfig_group <= reconfig_group;
end
 
always@(posedge clk or posedge reset) begin
if(reset) begin
  fec_mode_group1 <= startup_fec_grp1_value;
  fec_mode_group2 <= startup_fec_grp2_value;
end else if(error_status_i[3] == 0 ) begin
  fec_mode_group1 <= fec_mode_group1_w;
  fec_mode_group2 <= fec_mode_group2_w;
 end else  begin 
  fec_mode_group1 <= fec_mode_group1;
  fec_mode_group2 <= fec_mode_group2;
 end
end


dphy_f_dr_soft_csr2     dphy_f_dr_soft_csr2_inst (
    .reconfig_group_startup_value                               (startup_reconfig_grp_value),
    .reconfig_group_reconfig_group                              (reconfig_group_w),
    .fec_mode_group1_startup_value                              (startup_fec_grp1_value),
    .fec_mode_group1_fec_mode_group1                            (fec_mode_group1_w),
    .fec_mode_group2_startup_value                              (startup_fec_grp2_value),
    .fec_mode_group2_fec_mode_group2                            (fec_mode_group2_w),
    .error_status_error_status_i                                (error_status_i),
    .error_status_error_status                                  (error_status_o),
    .clk                                                        (clk),
    .reset                                                      (reset_sync),
    .writedata                                                  (writedata),
    .read                                                       (read),
    .write                                                      (write),
    .byteenable                                                 (byteenable),
    .readdata                                                   (readdata),
    .readdatavalid                                              (readdatavalid),
    .address                                                    (address)
);

    alt_xcvr_resync_etile #(
        .SYNC_CHAIN_LENGTH (3),
        .WIDTH(1)
     ) 
      reset_sync_inst  (
        .clk   (clk),
        .reset (1'b0),
        .d     ( reset ),
        .q     ( reset_sync )
      );    


endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRwPWIpX5INsIoNpq2iVOfQwKo5bDkPR2KkyXXWybfqJh41geA/aNK9YZ9nNaFCV06JvnFziLrmowV1l/v+TbhhYbtzf+32qPbCebNwzC9JBmpYl9U/YNXO1m8NG+9g4XTGSIQLmQWAhXCAhY9IVZZX3kCtCBLMgjtgPjClagUr74AZVr09Rp72unvaI4lywU0ww6j+ww6TH94m+ikel8jdsFVO9a24ht6DEr+KhLOnVIhROnVcWFc0Cx08sB0APV5rBOgKMQz+iYzQlvBPM0K5oiFJ7qbvYhHhi2+Bmc+rFfqbCex+Ue5XveIPxe99DDURKYst/ZZvpjSaT9D8L4DZskp12lxXbaYHbBArW7kpAdsZsdp6y/mpBOvTR/hk0tPSMyPd1ZSUwEJMjXFLNXFa/VGE9w23izHL+/LNnMXKw8gOhr8vTEJZ4e1iJa28DBAWdWkZwAk72Kid0ul1XyTmfk4vSaJ5WHuqkGmNhtZKJt+cmN3vqR4sUkqZUCLzfnOwVV/agMzk/aW6viO21dJNbvRdnx29+oyPtpWZt4Q4FsF1KUz7xtTMEwF9w7DY698ik06naWaefIC9ZVfIcRL1QLMJ9BEQAT3QdW9njfAC6zGWsBO5aidjsrVCjw5wN7JiCr+M35ntzqTYeIq4Czgm6bOdMST2XUwOFA26YDG7PpSTd1fWS+o4t7Yuh7oTA+6t/PHXGteRNMLoUf82HSMuPTL2XiiO1bdsCY9DJxaoX+llAwQnR9Lx5kUbkeXhQ2aFCfhNhx2e7+w2mqz/z/vCc"
`endif