// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps/1 ps
module dphy_f_dr_delay_wrapper #(
        parameter WIDTH = 8,
	parameter l_sys_aibs  = 1
    )
    (
        input   i_reset,
        input   i_clk,
        input   [l_sys_aibs-1:0][WIDTH-1:0] i_rx_skewed_data,
        input    [l_sys_aibs-1:0] i_rx_skewed_pulse_pre_dly,
        output wire  [l_sys_aibs-1:0][WIDTH-1:0] o_rx_skewed_data,
        output wire  [l_sys_aibs-1:0] o_rx_skewed_pulse
    );



genvar j;
generate
`ifdef SIM_SKEW_INSERT_DPHY_MRIP
begin : sim_skew
     for (j = 0; j < l_sys_aibs; j=j+1) begin : dly_lane_loop

       directphy_f_word_delay #(
           .WIDTH       (WIDTH+1),
           .SIM_EMULATE (1)
       ) lane_delay (
           .i_clk       (i_clk),
           .i_reset     (i_reset),
           .i_delay     ($urandom_range(32'h6,32'h1)),
           .i_data      ({i_rx_skewed_pulse_pre_dly[j],i_rx_skewed_data[j]}),
           .o_data      ({o_rx_skewed_pulse[j],o_rx_skewed_data[j]})
      );
end
end
`else
begin : no_skew
       assign o_rx_skewed_pulse = i_rx_skewed_pulse_pre_dly;
       assign o_rx_skewed_data = i_rx_skewed_data;
end
`endif
endgenerate

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRypjxf2Za2gbHNU5bUVoyvKFHCOTI8X3ipldrT5PTE/4qS74rJeQjt9aV8J9y6qRZ/PlNCOLrWTK6GMWyqW+xdUtI1pb6tPL46JGE7RFED+DIy3Ufg5Hp8/xf910K0I9VbVDS4LWuxs+IowC1j1t298I3pgdZbFRjwWvI4MDFBv0uWIC04CLWUid96zNhmRrYwA2v3tml/GEoFqWmK9O/L2wV6JbzPcj/84Wig36xW/qUfmP1ZJHMwzxs91PLpFbJ+4fJpfMoDNmE1LtVwCOyQlitA272hXdT0KaNRWZ5qL8OxfuMBQFgv65ex3mH3+cFqBQhlDDgTZTm1QGsRmvmnaLHG8ASbKmonntpNuBQN4H7WZ/W8p889jEdX7gH6SzFxuWaAotxhseFhKnAYHBPeyIQhOLdbC0O94MWzja6gKl6dzTD+gD8l3393N+acTP+kwTWbOdXRqNNid+X8fOFQxFTirP9DI+YVP7qk7sSpZFDJpm7T/XTKbFWIvuZOM0LFMQM+c4YJaAcmLJ3GW67tu/0YcLwWkLkbzy/Pzg8bIO7JD4Hr6bkLaYtOt0qOQDybJTfhblDiHDlKG0zEa0Zo+8pMiOVjnfTeGoG4CFQNvMQ7LtsmpvYbyGRxO7ldSsNABQKsGy3VWDx4MmGVym3bYAbhmeOGP+6L0eP4k02um3pfPEAdmrGqKj/zUehkdfjooPueREY1sJ4uZaurMMewJj8mCxnCIjTZeLG01gkCnk3sD3LqrnEdjmcfkslXYu9fUugKKRS49EQpucfJBmbkm"
`endif