// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps/1 ps
module dphy_f_dr_deskew #(
        parameter LANES = 1,
        parameter DATA_WIDTH = 8,
        parameter PIPELINING = 0,
        parameter DESKEW_VARIATION = 4             //this value should be factor of repetetion period
                                                   //of i_deskew_pulse upto 1/2 of the period. 
                                                   //For e.g. when deskew pulse period is 32,
                                                   //this param can be set to 4 or 8 or 16
    )
    (
        input   i_rst_n,
        input   i_clk,
        input   i_bypass,                          //available when LANES=1 only. To dynamically bypass
                                                           //input data when only one LANE is used
        input   i_ref_deskew_pulse,                //Reference deskew pulse to which all lanes need to 
                                                           //be aligned to
        input   [LANES-1:0] i_deskew_pulse,
        input   [LANES-1:0][DATA_WIDTH-1:0] i_data,
        output  logic [LANES-1:0][DATA_WIDTH-1:0] o_data,
        output  logic [LANES-1:0] o_deskew_pulse,
        output  logic o_deskew_done
    );

localparam FIFO_DEPTH = DESKEW_VARIATION*2;
localparam FIFO_AW = $clog2(FIFO_DEPTH);

logic [LANES-1:0][FIFO_AW-1:0] raddr, waddr;
logic [LANES-1:0][DATA_WIDTH-1:0] data_tmp;
logic [LANES-1:0] deskew_pulse_tmp;



genvar i;

generate
 for(i=0;i<LANES;i=i+1)
    begin: loop_lane
        always @ (posedge i_clk or negedge i_rst_n)
	begin
            if(~i_rst_n)
                waddr[i] <= 0;
            else if(i_deskew_pulse[i] | waddr[i]==FIFO_DEPTH-1)
                waddr[i] <= 0;
            else
                waddr[i] <= waddr[i]+1'b1;
        end

        always @ (posedge i_clk or negedge i_rst_n)
        begin
            if(~i_rst_n)
                raddr[i] <= 0;
            else if(i_ref_deskew_pulse)
                raddr[i] <= FIFO_DEPTH/2;
            else if(raddr[i]==FIFO_DEPTH-1)
                raddr[i] <= 0;
            else 
                raddr[i] <= raddr[i]+1'b1;
        end

        directphy_f_dr_mlab #(
            .WIDTH (DATA_WIDTH + 1),
            .ADDR_WIDTH         (FIFO_AW)
        ) U_deskew_fifo (
            .wclk               (i_clk),
            .wena  (1'b1),
            .waddr_reg          (waddr[i]),
            .wdata_reg  ({i_deskew_pulse[i],i_data[i]}),
            .raddr  (raddr[i]),
            .rdata  ({deskew_pulse_tmp[i],data_tmp[i]})
        );

    end //end for loop
endgenerate

    always @(posedge i_clk or negedge i_rst_n)
    begin
        if(~i_rst_n)
            o_deskew_done <= 0;
        else
            if (i_bypass == 1) begin
               if (o_deskew_pulse[0] == 1)
                o_deskew_done <= 1;
            end
            else if(&o_deskew_pulse == 1)
                o_deskew_done <= 1;
        end

    if(PIPELINING==1)
    begin             
always @(posedge i_clk)
        begin
            o_data          <= (i_bypass==1)? i_data : data_tmp;
            o_deskew_pulse  <= (i_bypass==1)? i_deskew_pulse : deskew_pulse_tmp;
        end
         end
           else 
    begin
        assign o_data         = (i_bypass==1)? i_data : data_tmp;
        assign o_deskew_pulse = (i_bypass==1)? i_deskew_pulse : deskew_pulse_tmp;
    end //end pipelining block
        

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRwTVMNOgYTYY70ynSi8iI1SoDpSZ9T4pnbkPwak4JLEAgrVmyTP8UUhX7A9sNuEIIyjKSzgFIlmVMfRJ7T0CDVTiPBYwiRmGjS2xfLTn1P07+sxhhaABoa/e1pk1AD7xAmNtgv8+dnoF/QZTEj0Nuvqea21HLV77hXUInsYHRUZYkS1vJihpFsJtmmSmx0QJ+SuJUC9lJOoeOnaJQf/QMIFVe0i2wpT5Wc4VSQT6/UBqtmWhAe2lelRM+XuNCJsNZZdLnmUDQ3fv+O/ENdwVojzib16Gzy8gokmYZplWSaOcPJJ0AMpuY0UMPQKKWYnAaW1rZAJgTc3fcHtmHbnkceFGxsuZeW+YdISJnHFAMyRgAJZKwB6bQah68QfhwGZygQuon3pV39dFvHVKmMa1t9mk9U8h1+kTw6vt0JWk5xmwnpDwOea+GGhV/rpxTpBdEaszKFW0PoKLVRJZ0fhXf/X9bwFK3ZuVoQn1eSi428FziYntSgs7tax1Pnr5n4yXHUcJxqbFmB4GnLGUsTwQSEzst9Po10tLdse5CyvF0QnwciSMuTq1N6F187gGyhyCUk8jpQ7x0dnLIGmWUNmQRq7P5ibRcIiOwbXK7k2UaMUnhxpNQrx3019gwwI9LRTkxie+KoST+u3mgLaZNTazV2ZnNAGfj0gkzFL/31Bmxw4Mvhij8BswMe84KVo1b4AaKsoy9CrGs9i3IGXmoo1jX3tNIYnDNjVbK4d4wzEIl5aC8xg94HXcmB6S3VEj0Wq+3XmNw/VSPu/P3vHfS/P/4qj"
`endif