// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


//-----------------------------------------------------------------------------------------------//
//   Generated with Magillem S.A. MRV generator.                                  
//   MRV generator version : 0.2
//   Protocol :  AVALON
//   Wait State : WS1_OUTPUT                                         
//   Date : Wed Feb 09 09:21:53 PST 2022           
//-----------------------------------------------------------------------------------------------//


//-----------------------------------------------------------------------------------------------//
//   Verilog Register Bank
//   Component Name: dphy_f_dr_soft_csr2
//   File Ref: /nfs/sc/disks/swuser_work_nbodigex/NB22p1/p4/ip/alt_xcvr/altera_xcvr_native_phy/directphy_f_dr/csr_gen/csr2gen_output/_workspace_mrv_gen_py_/xmlProject/_local_copy_Vendor_Library_dphy_f_dr_soft_csr2_1.0.xml                                             
//   Magillem Version :   5.11.2.1                                                                         
//-----------------------------------------------------------------------------------------------//
// 
module dphy_f_dr_soft_csr2 (
// register offset : 0x820, field offset : 0, access : RW, reconfig_group.reconfig_group
input  [13:0] reconfig_group_startup_value,
output  reg[13:0] reconfig_group_reconfig_group,
// register offset : 0x824, field offset : 0, access : RW, fec_mode_group1.fec_mode_group1
input  [31:0] fec_mode_group1_startup_value,
output  reg[31:0] fec_mode_group1_fec_mode_group1,
// register offset : 0x828, field offset : 0, access : RW, fec_mode_group2.fec_mode_group2
input  [31:0] fec_mode_group2_startup_value,
output  reg[31:0] fec_mode_group2_fec_mode_group2,
// register offset : 0x82c, field offset : 0, access : RO, error_status.error_status
input  [3:0] error_status_error_status_i,
output  reg[3:0] error_status_error_status,
//Bus Interface
input clk,
input reset,
input [31:0] writedata,
input read,
input write,
input [3:0] byteenable,
output reg [31:0] readdata,
output reg readdatavalid,
input [11:0] address

);


wire reset_n = !reset;	
// Protocol management
// combinatorial read data signal declaration
reg [31:0] rdata_comb;

// synchronous process for the read
always @(negedge reset_n ,posedge clk)  
   if (!reset_n) readdata[31:0] <= 32'h0; else readdata[31:0] <= rdata_comb[31:0];

// read data is always returned on the next cycle
always @(negedge reset_n , posedge clk)
   if (!reset_n) readdatavalid <= 1'b0; else readdatavalid <= read;
//
//  Protocol specific assignment to inside signals
//
wire  we = write;
wire  re = read;
wire [11:0] addr = address[11:0];
wire [31:0] din  = writedata [31:0];
// A write byte enable for each register
// register reconfig_group with  writeType: write
wire	[1:0]  we_reconfig_group		=	we  & (addr[11:0]  == 12'h820)	?	byteenable[1:0]	:	{2{1'b0}};
// register fec_mode_group1 with  writeType: write
wire	[3:0]  we_fec_mode_group1		=	we  & (addr[11:0]  == 12'h824)	?	byteenable[3:0]	:	{4{1'b0}};
// register fec_mode_group2 with  writeType: write
wire	[3:0]  we_fec_mode_group2		=	we  & (addr[11:0]  == 12'h828)	?	byteenable[3:0]	:	{4{1'b0}};

// A read byte enable for each register

/* Definitions of REGISTER "reconfig_group" */

// reconfig_group_reconfig_group
// bitfield description: This register indicates the sum of bandwidth(BW) of all active ports and number of XCVR lanes & number of fractures in a selected profile.
// customType:  RW
// hwAccess: RO 
// reset Value signal:  "reconfig_group_startup_value" 


always @( negedge  reset_n,  posedge clk)
   if (!reset_n)  begin
      reconfig_group_reconfig_group <= reconfig_group_startup_value;
   end
   else begin
   if (we_reconfig_group[0]) begin 
      reconfig_group_reconfig_group[7:0]   <=  din[7:0];  //
   end
   if (we_reconfig_group[1]) begin 
      reconfig_group_reconfig_group[13:8]   <=  din[13:8];  //
   end
end
/* Definitions of REGISTER "fec_mode_group1" */

// fec_mode_group1_fec_mode_group1
// bitfield description: This register indicates the FEC Type selected based on the bits set by user for the active ports in the selected profile
// customType:  RW
// hwAccess: RO 
// reset Value signal:  "fec_mode_group1_startup_value" 


always @( negedge  reset_n,  posedge clk)
   if (!reset_n)  begin
      fec_mode_group1_fec_mode_group1 <= fec_mode_group1_startup_value;
   end
   else begin
   if (we_fec_mode_group1[0]) begin 
      fec_mode_group1_fec_mode_group1[7:0]   <=  din[7:0];  //
   end
   if (we_fec_mode_group1[1]) begin 
      fec_mode_group1_fec_mode_group1[15:8]   <=  din[15:8];  //
   end
   if (we_fec_mode_group1[2]) begin 
      fec_mode_group1_fec_mode_group1[23:16]   <=  din[23:16];  //
   end
   if (we_fec_mode_group1[3]) begin 
      fec_mode_group1_fec_mode_group1[31:24]   <=  din[31:24];  //
   end
end
/* Definitions of REGISTER "fec_mode_group2" */

// fec_mode_group2_fec_mode_group2
// bitfield description: This register indicates the FEC Type selected based on the bits set by user for the active ports in the selected profile
// customType:  RW
// hwAccess: RO 
// reset Value signal:  "fec_mode_group2_startup_value" 


always @( negedge  reset_n,  posedge clk)
   if (!reset_n)  begin
      fec_mode_group2_fec_mode_group2 <= fec_mode_group2_startup_value;
   end
   else begin
   if (we_fec_mode_group2[0]) begin 
      fec_mode_group2_fec_mode_group2[7:0]   <=  din[7:0];  //
   end
   if (we_fec_mode_group2[1]) begin 
      fec_mode_group2_fec_mode_group2[15:8]   <=  din[15:8];  //
   end
   if (we_fec_mode_group2[2]) begin 
      fec_mode_group2_fec_mode_group2[23:16]   <=  din[23:16];  //
   end
   if (we_fec_mode_group2[3]) begin 
      fec_mode_group2_fec_mode_group2[31:24]   <=  din[31:24];  //
   end
end
/* Definitions of REGISTER "error_status" */

// error_status_error_status
// bitfield description: This register indicates the Error status of fracture count , xcvr,data rate and fec status
// customType:  RO
// hwAccess: RW 
// reset value : 0x0 
// inputPort: error_status_error_status_i 
// outputPort:  "" 



always @( negedge  reset_n,  posedge clk)
   if (!reset_n)  begin
      error_status_error_status <= 4'h0;
   end
   else begin
      error_status_error_status[3:0]   <=  error_status_error_status_i[3:0] ;
end


// read process
always @ (*)
begin
rdata_comb = 32'h00000000;
   if(re) begin
      case (addr)  
	12'h820 : begin
		rdata_comb [13:0]	= reconfig_group_reconfig_group [13:0] ;		// readType = read   writeType =write
	end
	12'h824 : begin
		rdata_comb [31:0]	= fec_mode_group1_fec_mode_group1 [31:0] ;		// readType = read   writeType =write
	end
	12'h828 : begin
		rdata_comb [31:0]	= fec_mode_group2_fec_mode_group2 [31:0] ;		// readType = read   writeType =write
	end
	12'h82c : begin
		rdata_comb [3:0]	= error_status_error_status [3:0] ;		// readType = read   writeType =illegal
	end
	default : begin
		rdata_comb = 32'h00000000;
	end
      endcase
   end
end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRzAJUcipqPcUN4Bw3lItBcysyDiLG5i+Bc41loIE7nqsK/euNBK84iXnJQ3Pkj/9XQI3JWDCzCvhwZQD7Sf0j/OI2D76y4gAt9RcGE+fUbSxTXq5tXe5rI+5+t81ajRL8wH1gAKIACyNbi1px7YkbyPk3Dgck/eQNvLC7vzDKg1uZ84lMOrHsrd2RlGe2f7g6Ii5hCTnucjjkzyKimfIpgWi1I8U+JDHgtTCjy7LXjvXYT0LX/h3FHKksE9krzsHfoo5xuFsBLDahnyWKuSZZFklQ5wt7fCtN7IA7lho85iRwUufLsoBxC/sB42faA+BAgrOxOeoIi+6ZvIOuWt/HFiYtnMjSm2gJ7YRHw2LcVU9kwMPtRZ+IhOArVuVG8vJpp7iUyoAIVqoAYLpgx6NdXXEeVCTkphYLnjHYVnfeR82KtRkvtcFbCbGE7hlsULsi+Pk1TptcK8MhdxUdMTyxPJIMrALHhqQaSkJxKv7Y0Q163AV5huBq57znAk2cd3LdA415knxxk7VD3vxOpD3zDtPCsJKip4QzBk8yMqIFYtEVaWltE5DVZxdi2f81/HXOPJemSWyo1JEf12BxtFt1jOxq3PwUOWf+88Sdh/zcLJid0jTPjHtT2ycKs0/d6zrWo9rBkDD7EX9MrZEEsJr4WFa4BXEG8MwNOQjId5Td87EXCnBNG9l4rkV/V0sz0MV8BwsSd3llkIbAG9S48MzhhG5A0b2QycwYJ2u09xo1UD9LzgQivNhfexLyJTN0bSfET36qb92cR2DS8nB3hir0AK"
`endif