// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps/1 ps
module dphy_f_dr_tx_dsk_gen_fec #(
    parameter LANES         = 2
)(
    input   logic                            i_clk,
    input   logic [3:0]                      fec_mode,
    input   logic                            pulse_1in16,// one in 16 enables
    input   logic                            pulse_1in32,// one in 32 enables
    input   logic [LANES*80-1:0]             i_data,
    output  logic [LANES*80-1:0]             o_data
);
//For RSFEC patterns, tx deskew pulses are matching with the valid counts for
//each RSFEC mode. It's either 32 or 16 based on modes.
// 16 -> LLFEC or KP(544,514), tx deskew pulses are toggling every 16 cycles
// 32 -> KR(528,514),tx deskew pulses are toggling every 32 cycles.
// 16 means counter counts up to 15, so [3:0], WIDTH_CNT = 4.
// 32 means counter counts up to 31, so [4:0], WIDTH_CNT = 5
//
// For PMA patterns, tx deskew pulses are generated every 32 cycles.
                      
wire  [3:0] fec_mode_sync;

alt_xcvr_resync_etile #(
                           .SYNC_CHAIN_LENGTH (3),
                           .WIDTH(4),
                           .INIT_VALUE(0)
                           ) U_fec_mode_sync_inst (
           	           .clk   (i_clk),
           	           .reset (1'b0),
           	           .d     (fec_mode[3:0]),
           	           .q     (fec_mode_sync[3:0])
           		  );   


reg    tx_dsk_pulse_copy1=1'b0;
reg    tx_dsk_pulse_copy2=1'b0;
wire    tx_dsk_pulse;
always @(posedge i_clk) begin
tx_dsk_pulse_copy1 <= ((fec_mode_sync== 4'd2) || (fec_mode_sync == 4'd3) || (fec_mode_sync == 4'd5) || 
                         (fec_mode_sync == 4'd6) || (fec_mode_sync == 4'd7) || (fec_mode_sync == 4'd9)) ? pulse_1in16 : pulse_1in32;
tx_dsk_pulse_copy2 <= tx_dsk_pulse_copy1;                         
end                         

assign tx_dsk_pulse = tx_dsk_pulse_copy2;                         

generate
   genvar l;
   for(l=0;l<LANES;l=l+1)  begin:lane
          assign o_data[l*80+:80] =  {i_data[l*80+79], tx_dsk_pulse, i_data[l*80+:78]}; 
   end

endgenerate












endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRzaQbOQV6sWvXwB0afCgGICZTi1tljUGX5+oL6XT1oMC4uCSFHaiwAPYewhI++Xq1qOjCEgGVfC50ee60UHxzYp4mbjiG9cOfBEQ0KQulOwdScdkR/VRy//mt/Zm51P+653i+OepOEbbqVx7OGNYmIspMOvIp5E6qk2U4YRKWub4MBcrbvJahUeovlPrb2ZjyFkwLrcJJaaAIF0rGwTFlfO1Rfb13leLUFMXrxNhi+348bRE651ifXpRRq/OBTap1W/el8a3F32mIH35Ytjr5JacNV/DfMsUo+A+4TnouVoOV0e45YnyCQhx3QqTrOFYkKF7hNshxyV6ZfYAwfCRWX5dYXAeYtqg5XOKaEJUZzENXli3fGzGggZ0xsnzt965epBa0LX3n7Eu6oop7TtfhM6i4U+Hqe85DCJ/9Mn+22kIK719hdmkoM9ojKYOARKjQiOUOh3p9jbchPdQR5RusGQudPXCZ5N6oKELTSNo0MsfZrZApEPS11LeNGDGPIBnkidZLh+1GCvjL/NAAgSgw2Q37WSq3jJDsQ521VYFXebWISUohwlg9AbyVZ8hnNE+914bL++aQV7h6nvFzrjri2j80F8dn8fHyQGJqxROXG+A5kGxlZ0y3ArWpuJ16lIvPA5qewOusyVyliSe7+I0APK7G0aLWo0x+zMBqnTLAryxnXOUNdkek+SQ4Kx3zfVRW7moKxZ+2bVnH6Cdp7U1gofWwNBQ8/PUMnM7EPtzeVWaFjkPBpEIwvDYrw8pQrDy5yipkYSwuKnZWzVHpDrQjmr"
`endif