// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1ps/1ps

module gray_cntr_3 #(
	parameter INIT_VAL = 4'h0
)(
	input clk,
	input ena,
	input aclr,
	output reg [2:0] cntr
);

initial cntr = INIT_VAL;

always @(posedge clk or posedge aclr) begin
	if (aclr) cntr <= INIT_VAL;
	else begin
		if (ena) begin
			case (cntr) 
				3'h0 : cntr <= 3'h1;
				3'h1 : cntr <= 3'h3;
				3'h2 : cntr <= 3'h6;
				3'h3 : cntr <= 3'h2;
				3'h4 : cntr <= 3'h0;
				3'h5 : cntr <= 3'h4;
				3'h6 : cntr <= 3'h7;
				3'h7 : cntr <= 3'h5;
			endcase
		end
	end
end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRzQKQqAcQS7lAxSdSybmsSxZsFt/Hn6Pd1g0WtVm7mDbJ+Z7CV97EFjS+mAVIShnWMOeXtB2Tk9V6alC9B9E8jnMUA4RyY35XO6fBEVLiNBqaL5DSjy4Nm1TdvVf9r+f6avuGkVxHatJ7fRVKE+hqhNLc90pbwqrLoH/I6tbnwcKEia82vHdcLzNWiUjkV6N4nujRazBxNLJdlXAjBxU+h0telpN1DbB97CkRC/Z7VZF4PPZDm683nHuDE9Yxfrw5nt8S9BjNyj9fMuF0dF+WUzfS/FbwJRKyccisxIAMpqH8kjRGI2A0yQFuxee1Evf9M/SySDXaDsFxIMvukyZB/8sFON7htTR5sK2nfjm2eaRn2VqWlpZ9QnQJdVYIXnOCZIVUHl9usbaMWNqx4gR8j9popMmMI4og7v4YmtPQnbr9iJrD/YABF7KDbQtMD3uCXsvAIi/gJvoTzNqfd0BxeXD7ETTmCrw+1XG54ieWPIpJ5+tPFu0ve1IxUHHGUBeuBMC7MEjVpmE5FMU99yDsSsO/j0Urw6JtJ0kJGctwN4oSjf7Z6lcGsBs4ThRig3cpusuvJMYdL4GEA3wtpQpnh8hOP+bMX8n89pE4CkVdTkroB1A0B1UdYiJ9R6XJm/z0zs2SmQCbGzeJsX1WN4aU4LJkAdoi/vi5bQfefZnNcioh0xp1aEPnFX6KsAVU7Np+2MzCrvSk++5Ukr0UHh+kZ3lW3WFwA3tGJF4z6rcvzAB5mHYrOYBcRTZjS5y4ywv7Js7hFCsJNMTohrw9RXnfIV"
`endif