// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps
// Copyright 2012 Intel Corporation. All rights reserved.  
// Intel products are protected under numerous U.S. and foreign patents, 
// maskwork rights, copyrights and other intellectual property laws.  
//
// This reference design file, and your use thereof, is subject to and governed
// by the terms and conditions of the applicable Intel Reference Design 
// License Agreement (either as signed by you or found at www.altera.com).  By
// using this reference design file, you indicate your acceptance of such terms
// and conditions between you and Intel Corporation.  In the event that you do
// not agree with such terms and conditions, you may not use the reference 
// design file and please promptly destroy any copies you have made.
//
// This reference design file is being provided on an "as-is" basis and as an 
// accommodation and therefore all warranties, representations or guarantees of 
// any kind (whether express, implied or statutory) including, without 
// limitation, warranties of merchantability, non-infringement, or fitness for
// a particular purpose, are specifically disclaimed.  By making this reference
// design file available, Intel expressly does not recommend, suggest or 
// require that this reference design file be used in combination with any 
// other product not provided by Intel.
/////////////////////////////////////////////////////////////////////////////

// baeckler - 01-25-2012
// force the decomposition of 5 bit FIFO pointer compare with enable

module neq_5_ena #(
 	parameter TARGET_CHIP = 1   // 0 generic, 1 S4, 2 S5
)(
	input [4:0] da,
	input [4:0] db,
	input ena,
	output eq
);

wire w0_o;
wys_lut w0 (
	.a(da[0]),
	.b(da[1]),
	.c(da[2]),
	.d(db[0]),
	.e(db[1]),
	.f(db[2]),
	.out (w0_o)
);
defparam w0 .TARGET_CHIP = TARGET_CHIP;
defparam w0 .MASK = 64'h8040201008040201; // {a,b,c} == {d,e,f}
	
wys_lut w1 (
	.a(ena),
	.b(da[3]),
	.c(da[4]),
	.d(db[3]),
	.e(db[4]),
	.f(w0_o),
	.out (eq)
);
defparam w1 .TARGET_CHIP = TARGET_CHIP;
defparam w1 .MASK = 64'h2a8aa2a8aaaaaaaa; // (!({b,c} == {d,e}) || !f) && a;
	

endmodule
// BENCHMARK INFO :  10AX115R2F40I2SGES
// BENCHMARK INFO :  Quartus II 64-Bit Version 13.1a10.0 Build 343 10/23/2013 SJ Full Version
// BENCHMARK INFO :  Total registers : 0
// BENCHMARK INFO :  Total pins : 12
// BENCHMARK INFO :  Total virtual pins : 0
// BENCHMARK INFO :  Total block memory bits : 0
// BENCHMARK INFO :  Comb ALUTs :  3              
// BENCHMARK INFO :  ALMs : 3 / 427,200 ( < 1 % )
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRwPf2YIcTmmyjnGGNeZ+fO6VBo7uAjCSlNC2WLBpeDtysE9jZwnLeQy5f+REgNr4K/JZwUG502kQn36R1TQ2EeqeTpLC2e4ZwWtXOijRGtWUlU9PP1ZtpO+j3+mKhCbzs7eMTx97l63zjQKMhjJoZ8TKmA9IfqcvyBlcU830taRyI78QLuZZOfFTMzgI+ikRuxv2rJluu8wf9Hamfqv4Sv01CF6mFWYUZTNn3CYwKdHszrQoPdSiOVJBNqrMZ/IJ3IGC+JrFbNCbLQvdPgJAjEoKWVikgGcNEsZg0lWUy2V81MsOSiIvZ0s0gbafQPQS3v7IWco21iCSrs93x+o7veFF+2vpPBpwHA0DxLxQloAwaIylgTmYOPTVyyjPr32UuxAAEdri3mJotU2LX9nM9l+tjvCW00ZpLfXOGUqGdN23kXKtmvDNuVzwWb0iq6Ofp/lhFwmJoPtMdIab1bb9mjsTaqddp+PFPR2hkFGSCZDlnSd9FrSvmZqz56S/tVw+PT58jIxto1JQ18FMm4FX0OWVz/nP2k3HPzqk+KjejImxObpQCohi4XzetygJs+s7+YJyLdPmhJM4+jqJrZyBWKCDcGMIBLBa0y/baTCNOIbp6w7jMG/uVq/28lqNCGp3GPsqJUponeIrDw8EkIDNxSF1o02WCLWxfsd1Qi8NI9izzF1uAiIxJCTbnVku3dnYFu/VMTRSY8hFadZF3MyXwnONPYigi78MTjBswL+tWw5jAqF5guIgTRWZmBYiUnlx7DWjTucId82XebEonzg8v8q"
`endif