// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps/1 ps 
(* altera_attribute = "-name UNCONNECTED_OUTPUT_PORT_MESSAGE_LEVEL OFF" *)
`ifndef __MB__
 `define __MB__ (* intfc_name="soft_reset_ctlr", intfc_type_key="slot", intfc_subtype_key="spoke" *)
`endif

`ifndef __MC__
 `define __MC__ (* intfc_name="soft_reset_ctlr", intfc_type_key="slot", intfc_subtype_key="soft_reset_ctlr_link" *)
`endif
(* tile_ip_sip  *)
module sdi_mr_rx_sys_rx_phy_base_profile_dr_sip  #(
    parameter          num_sys_cop                                              = 1,
    parameter          num_subsys_cop                                              = 1,
    parameter          num_xcvr_per_sys                                         = 1,
    parameter          num_fec_ch                                               = 1,
    parameter          l_num_aib_per_xcvr                                       = 1,
    parameter          l_sys_xcvrs                                              = 1,
    parameter          l_sys_aibs                                               = 1,
    parameter          l_tx_enable                                              = 1,
    parameter          l_rx_enable                                              = 1,
    parameter          tx_custom_cadence_enable                                 = 0,
    parameter          enable_port_tx_cadence_slow_clk_locked                   = 0,
    parameter          fec_on                                                   = 0,
    parameter          bb_f_ehip_xcvr_type                                      = "XCVR_TYPE_UX",
    parameter          bb_f_ehip_xcvr_mode                                      = "XCVR_MODE_NRZ",
    parameter          l_soft_csr_enable                                        = 0,
    parameter          l_soft_dr_csr_enable                                       = 0,
    parameter          rcfg_group                                                 = "25G-1",
    parameter          STARTUP_RECONFIG_GRP_VALUE                               = 0,
    parameter          STARTUP_FEC_GRP1_VALUE                                   = 0,
    parameter          STARTUP_FEC_GRP2_VALUE                                   = 0,
    parameter          STARTUP_MODULATION_TYPE                                   = 0,
    parameter          STARTUP_LINE_RATE_P1GHZ_FRAC1_FRAC0                       = 0,
    parameter          STARTUP_LINE_RATE_P1GHZ_FRAC3_FRAC2                       = 0,
    parameter          STARTUP_LINE_RATE_P1GHZ_FRAC5_FRAC4                       = 0,
    parameter          STARTUP_LINE_RATE_P1GHZ_FRAC7_FRAC6                       = 0,
    parameter          STARTUP_LINE_RATE_P1GHZ_FRAC9_FRAC8                       = 0,
    parameter          STARTUP_LINE_RATE_P1GHZ_FRAC11_FRAC10                     = 0,
    parameter          reconfig_pdp_address_width                               = 14, 
    parameter          reconfig_xcvr_address_width                              = 18, 
    parameter          l_line_rate_p1ghz                                        = 250,   
    parameter          avmm1_jtag_enable                                        = 0,
    parameter          avmm1_ready_enable                                      = 0,
    parameter          avmm1_enable                                             = 0,
    parameter          l_av1_aib_enable                                         = 0,
    parameter          l_num_avmm1                                              = 1,
    parameter          l_av1_ifaces                                             = 1,
    parameter          l_av1_addr_bits                                          = 14,
    parameter          avmm2_jtag_enable                                        = 0,
    parameter          avmm2_ready_enable                                      = 0,
    parameter          avmm2_enable                                             = 0,
    parameter          l_num_avmm2                                              = 1,
    parameter          l_av2_ifaces                                             = 1,
    parameter          l_av2_addr_bits                                          = 18
    ) (
  // User interface for XCVR (FGT/FHT)
     input   wire   [l_sys_xcvrs-1:0]   tx_enable_xcvr,         // Each channel or only 1 bit for ALL?

    output   wire   [l_sys_xcvrs-1:0]   pll_locked_xcvr,

  // User interface for UX/BK bb   
    output          [l_sys_xcvrs-1:0]   fgt_rx_signal_detect,    
    output          [l_sys_xcvrs-1:0]   fgt_rx_signal_detect_lfps,    
    output          [l_sys_xcvrs-1:0]   fht_rx_energy_detect,    
    output          [l_sys_xcvrs-1:0]   tx_pll_locked,                 
    output          [l_sys_xcvrs-1:0]   rx_is_lockedtodata,          
    output          [l_sys_xcvrs-1:0]   rx_is_lockedtoref,          
    input           [l_sys_xcvrs-1:0]   fgt_rx_set_locktoref,
    input           [l_sys_xcvrs-1:0]   fgt_rx_set_locktodata,
    input           [l_sys_xcvrs-1:0]   fgt_rx_cdr_freeze, 
    input           [l_sys_xcvrs-1:0]   fgt_tx_beacon,
    input           [l_sys_xcvrs-1:0]   fgt_rx_cdr_fast_freeze_sel, 
    input           [l_sys_xcvrs-1:0]   fgt_rx_cdr_set_locktoref,

  // User interface for FEC
    output   wire   [num_subsys_cop-1:0] rsfec_status_rx_not_deskew,
    output   wire   [num_subsys_cop-1:0] rsfec_status_rx_not_locked,
    output   wire   [num_subsys_cop-1:0] rsfec_status_rx_not_align,
    output   wire   [num_subsys_cop-1:0] rsfec_sf,
    input   wire    [l_sys_aibs-1:0]  fec_snapshot,

  // Custom Cadence 
     input          [num_subsys_cop-1:0]   tx_cadence_fast_clk,
     input          [num_subsys_cop-1:0]   tx_cadence_slow_clk,
     output         [num_subsys_cop-1:0]   tx_cadence,

  // User interface for XCVR-IF
    output   wire   [l_sys_aibs-1:0]  xcvrif_rxfifo_empty,
    output   wire   [l_sys_aibs-1:0]  xcvrif_rxfifo_pempty,
    output   wire   [l_sys_aibs-1:0]  xcvrif_rxfifo_pfull,

    output   wire   [l_sys_aibs-1:0]  xcvrif_txfifo_empty,
    output   wire   [l_sys_aibs-1:0]  xcvrif_txfifo_pempty,
    output   wire   [l_sys_aibs-1:0]  xcvrif_txfifo_pfull,

    output   wire   [l_sys_aibs-1:0]  xcvrif_hold_interrupt,

  // Interface to ux bb
     input          [l_sys_xcvrs-1:0]   oct_pcs_rxsignaldetect_lx_a,    
     input          [l_sys_xcvrs-1:0]   octl_pcs_rxsignaldetect_lfps_lx_a, 
     input          [l_sys_xcvrs-1:0]   oct_pcs_all_synthlockstatus,                 
     input          [l_sys_xcvrs-1:0]   oct_pcs_rxcdrlock2data_lx_a,          
     input          [l_sys_xcvrs-1:0]   oct_pcs_rxcdrlockstatus_lx_a,       
     input          [l_sys_xcvrs-1:0]   octl_pcs_txstatus_lx_a,    
     input          [l_sys_xcvrs-1:0]   octl_pcs_rxstatus_lx_a,           
    output          [l_sys_xcvrs-1:0]   ictl_pcs_rxovrcdrlock2dataen_lx_a,  
    output          [l_sys_xcvrs-1:0]   ictl_pcs_rxovrcdrlock2data_lx_a,
    output          [l_sys_xcvrs-1:0]   ictl_pcs_txbeacon_lx_a,
    output          [l_sys_xcvrs-1:0]   flux_top__iflux_ingress_direct__231,
    output          [num_xcvr_per_sys*num_sys_cop-1:0]   i_xcvrrc_fsrssr_xcvr_ux_ds_0__xcvr_f2t,
    output          [num_xcvr_per_sys*num_sys_cop-1:0]   ictl_pcs_rxeiosdetectstat_lx_a,

  // Interface to BK BB
    output  wire    [l_sys_xcvrs*8-1:0]                  fht_ingress_direct,  
     input  wire    [l_sys_xcvrs*8-1:0]                  fht_rx_direct,           
     input  wire    [l_sys_xcvrs-1:0]                    fht_rxsrds_rdy,           

  // Interface to directphy_f_hip
    output   wire   [l_sys_aibs*4-1:0]    hip_aib_fsr_in,
    input    wire   [l_sys_aibs*4-1:0]    hip_aib_fsr_out,
    output   wire   [l_sys_aibs*40-1:0]   hip_aib_ssr_in,
    input    wire   [l_sys_aibs*8-1:0]    hip_aib_ssr_out,
    input    wire   [l_sys_aibs-1:0]      pld_10g_krfec_rx_blk_lock,
    output   wire   [l_sys_aibs-1:0]      pld_10g_krfec_rx_clr_errblk_cnt,
    input    wire   [l_sys_aibs*2-1:0]    pld_10g_krfec_rx_diag_data_status,
    input    wire   [l_sys_aibs-1:0]      pld_10g_krfec_rx_frame,
    input    wire   [l_sys_aibs-1:0]      pld_10g_rx_crc32_err,
    input    wire   [l_sys_aibs-1:0]      pld_10g_rx_frame_lock,
    input    wire   [l_sys_aibs-1:0]      pld_10g_rx_hi_ber,
    output   wire   [l_sys_aibs*7-1:0]    pld_10g_tx_bitslip,
    input    wire   [l_sys_aibs*4-1:0]    pld_8g_a1a2_k1k2_flag,
    output   wire   [l_sys_aibs-1:0]      pld_8g_bitloc_rev_en,
    output   wire   [l_sys_aibs-1:0]      pld_8g_byte_rev_en,
    output   wire   [l_sys_aibs*3-1:0]    pld_8g_eidleinfersel,
    input    wire   [l_sys_aibs-1:0]      pld_8g_empty_rmf,
    output   wire   [l_sys_aibs-1:0]      pld_8g_encdt,
    input    wire   [l_sys_aibs-1:0]      pld_8g_full_rmf,
    output   wire   [l_sys_aibs*5-1:0]    pld_8g_tx_boundary_sel,
    input    wire   [l_sys_aibs*5-1:0]    pld_8g_wa_boundary,
    input    wire   [l_sys_aibs-1:0]      pld_krfec_tx_alignment,
    input    wire   [l_sys_aibs-1:0]      pld_pma_adapt_done,
    output   wire   [l_sys_aibs-1:0]      pld_pma_adapt_start,
    output   wire   [l_sys_aibs-1:0]      pld_pma_csr_test_dis,
    output   wire   [l_sys_aibs-1:0]      pld_pma_early_eios,
    output   wire   [l_sys_aibs*6-1:0]    pld_pma_eye_monitor,
    input    wire   [l_sys_aibs-1:0]      pld_pma_fpll_clk0bad,
    input    wire   [l_sys_aibs-1:0]      pld_pma_fpll_clk1bad,
    input    wire   [l_sys_aibs-1:0]      pld_pma_fpll_clksel,
    output   wire   [l_sys_aibs*4-1:0]    pld_pma_fpll_cnt_sel,
    output   wire   [l_sys_aibs-1:0]      pld_pma_fpll_extswitch,
    output   wire   [l_sys_aibs*3-1:0]    pld_pma_fpll_num_phase_shifts,
    output   wire   [l_sys_aibs-1:0]      pld_pma_fpll_pfden,
    input    wire   [l_sys_aibs-1:0]      pld_pma_fpll_phase_done,
    output   wire   [l_sys_aibs-1:0]      pld_pma_fpll_up_dn_lc_lf_rstn,
    output   wire   [l_sys_aibs-1:0]      pld_pma_nrpi_freeze,
    input    wire   [l_sys_aibs*2-1:0]    pld_pma_pcie_sw_done,
    output   wire   [l_sys_aibs-1:0]      pld_pma_ppm_lock,
    input    wire   [l_sys_aibs*5-1:0]    pld_pma_reserved_in,
    output   wire   [l_sys_aibs*5-1:0]    pld_pma_reserved_out,
    output   wire   [l_sys_aibs-1:0]      pld_pma_rs_lpbk_b,
    input    wire   [l_sys_aibs-1:0]      pld_pma_rx_detect_valid,
    input    wire   [l_sys_aibs-1:0]      pld_pma_rx_found,
    input    wire   [l_sys_aibs-1:0]      pld_pma_signal_ok,
    output   wire   [l_sys_aibs-1:0]      pld_pma_tx_bitslip,
    output   wire   [l_sys_aibs-1:0]      pld_pma_tx_qpi_pulldn,
    output   wire   [l_sys_aibs-1:0]      pld_pma_tx_qpi_pullup,
    input    wire   [l_sys_aibs-1:0]      pld_pmaif_mask_tx_pll,
    output   wire   [l_sys_aibs-1:0]      pld_pmaif_rxclkslip,
    output   wire   [l_sys_aibs-1:0]      pld_polinv_rx,
    output   wire   [l_sys_aibs-1:0]      pld_polinv_tx,
    input    wire   [l_sys_aibs-1:0]      pld_rx_hssi_fifo_empty,
    input    wire   [l_sys_aibs-1:0]      pld_rx_hssi_fifo_full,
    input    wire   [l_sys_aibs-1:0]      pld_rx_prbs_done,
    input    wire   [l_sys_aibs-1:0]      pld_rx_prbs_err,
    output   wire   [l_sys_aibs-1:0]      pld_rx_prbs_err_clr,
    output   wire   [l_sys_aibs-1:0]      pld_syncsm_en,
    input    wire   [l_sys_aibs*20-1:0]   pld_test_data,
    input    wire   [l_sys_aibs-1:0]      pld_tx_hssi_fifo_empty,
    input    wire   [l_sys_aibs-1:0]      pld_tx_hssi_fifo_full,
    input    wire   [l_sys_aibs-1:0]      pld_txelecidle,
    input    wire   [l_sys_aibs-1:0]      pld_pma_rxpll_lock,
    input    wire   [l_sys_aibs-1:0]      pld_8g_rxelecidle,


  input  [l_sys_aibs*80-1:0] tx_parallel_data,
  output [l_sys_aibs*80-1:0] rx_parallel_data,
  input  [l_sys_aibs*80-1:0] sync_data_from_aib,
  output [l_sys_aibs*80-1:0] sync_data_to_aib,

      // Virtual placement link ports for connection to HIP module - necessary for soft reset controller instantiation
`__MC__ input wire [l_sys_xcvrs-1:0] placement_virtual_rx_xcvr,
`__MC__ input wire [l_sys_xcvrs-1:0] placement_virtual_tx_xcvr,
`__MC__ input wire [l_sys_xcvrs-1:0] placement_virtual_fht_xcvr,       

  // Reconfiguration:
  input   [l_av2_ifaces-1:0]       reconfig_clk,
  input   [l_av2_ifaces-1:0]       reconfig_reset,
  input   [l_av2_ifaces-1:0]       reconfig_write,
  input   [l_av2_ifaces-1:0]       reconfig_read,
  input   [l_av2_addr_bits*l_av2_ifaces-1:0]   reconfig_address,
  input   [l_av2_ifaces*4-1:0]     reconfig_byteenable,
  input   [l_av2_ifaces*32-1:0]    reconfig_writedata,
  output  [l_av2_ifaces*32-1:0]    reconfig_readdata,
  output  [l_av2_ifaces-1:0]       reconfig_waitrequest,
  output  [l_av2_ifaces-1:0]       reconfig_readdatavalid,

  input   [l_av1_ifaces-1:0]       reconfig_pdp_clk,
  input   [l_av1_ifaces-1:0]       reconfig_pdp_reset,
  input   [l_av1_ifaces-1:0]       reconfig_pdp_write,
  input   [l_av1_ifaces-1:0]       reconfig_pdp_read,
  input   [l_av1_addr_bits*l_av1_ifaces-1:0]  reconfig_pdp_address,
  input   [l_av1_ifaces*4-1:0]     reconfig_pdp_byteenable,
  input   [l_av1_ifaces*32-1:0]    reconfig_pdp_writedata,
  output  [l_av1_ifaces*32-1:0]    reconfig_pdp_readdata,
  output  [l_av1_ifaces-1:0]       reconfig_pdp_waitrequest,
  output  [l_av1_ifaces-1:0]       reconfig_pdp_readdatavalid,

  //  for AVMM1 bb ports
  input   wire  [l_num_avmm1-1:0]      pld_avmm1_busy,
  output  wire  [l_num_avmm1-1:0]      pld_avmm1_clk_rowclk,
  input   wire  [l_num_avmm1-1:0]      pld_avmm1_cmdfifo_wr_full,
  input   wire  [l_num_avmm1-1:0]      pld_avmm1_cmdfifo_wr_pfull,
  output  wire  [l_num_avmm1-1:0]      pld_avmm1_read,
  input   wire  [8*l_num_avmm1-1:0]    pld_avmm1_readdata,
  input   wire  [l_num_avmm1-1:0]      pld_avmm1_readdatavalid,
  output  wire  [10*l_num_avmm1-1:0]   pld_avmm1_reg_addr,
  output  wire  [l_num_avmm1-1:0]      pld_avmm1_request,
  output  wire  [9*l_num_avmm1-1:0]    pld_avmm1_reserved_in,
  input   wire  [3*l_num_avmm1-1:0]    pld_avmm1_reserved_out,
  output  wire  [l_num_avmm1-1:0]      pld_avmm1_write,
  output  wire  [8*l_num_avmm1-1:0]    pld_avmm1_writedata,
  input   wire  [l_num_avmm1-1:0]      pld_chnl_cal_done,
  input   wire  [l_num_avmm1-1:0]      pld_hssi_osc_transfer_en,
  //  for AVMM2 bb ports
  output  wire  [l_num_avmm2-1:0]      hip_avmm_read,
  input   wire  [8*l_num_avmm2-1:0]    hip_avmm_readdata,
  input   wire  [l_num_avmm2-1:0]      hip_avmm_readdatavalid,
  output  wire  [21*l_num_avmm2-1:0]   hip_avmm_reg_addr,
  input   wire  [5*l_num_avmm2-1:0]    hip_avmm_reserved_out,
  output  wire  [l_num_avmm2-1:0]      hip_avmm_write,
  output  wire  [8*l_num_avmm2-1:0]    hip_avmm_writedata,
  input   wire  [l_num_avmm2-1:0]      hip_avmm_writedone,
  input   wire  [l_num_avmm2-1:0]      pld_avmm2_busy,
  output  wire  [l_num_avmm2-1:0]      pld_avmm2_clk_rowclk,
  input   wire  [l_num_avmm2-1:0]      pld_avmm2_cmdfifo_wr_full,
  input   wire  [l_num_avmm2-1:0]      pld_avmm2_cmdfifo_wr_pfull,
  output  wire  [l_num_avmm2-1:0]      pld_avmm2_request,
  input   wire  [l_num_avmm2-1:0]      pld_pll_cal_done,
          // below are unused ports in hip mode
  output  wire  [l_num_avmm2-1:0]      pld_avmm2_write,
  output  wire  [l_num_avmm2-1:0]      pld_avmm2_read,
  output  wire  [9*l_num_avmm2-1:0]    pld_avmm2_reg_addr,
  input   wire  [8*l_num_avmm2-1:0]    pld_avmm2_readdata,
  output  wire  [8*l_num_avmm2-1:0]    pld_avmm2_writedata,
  input   wire  [l_num_avmm2-1:0]      pld_avmm2_readdatavalid,
  output  wire  [6*l_num_avmm2-1:0]    pld_avmm2_reserved_in,
  input   wire  [l_num_avmm2-1:0]      pld_avmm2_reserved_out,

       // Connections to the IP top level for reset and AM generation
  input wire  [num_subsys_cop-1:0]    tx_reset,	     
  input wire  [num_subsys_cop-1:0]    rx_reset,	     
  output wire [num_subsys_cop-1:0]    tx_reset_ack,    
  output wire [num_subsys_cop-1:0]    rx_reset_ack,
  // JRJ 10-15-2020 - Change to single wire interface for all lanes for tx_am_gen_start and tx_am_gen_2x_ack for each system copy.    
  // There is one tx_am_gen_start output for each system copy, all lanes, and one tx_am_gen_start_2x_ack input for each
  // system copy, all lanes.
  output wire [num_subsys_cop-1:0]    tx_am_gen_start, 
  input wire  [num_subsys_cop-1:0]    tx_am_gen_2x_ack,
  output wire [num_subsys_cop-1:0]    tx_ready,	     
  output wire [num_subsys_cop-1:0]    rx_ready,
  // connection to the IP top level for RX de-skew reset
  output wire [l_sys_xcvrs-1:0] rx_lane_out_of_reset_int,
       // Soft reset controller:
       // Replaced the parameter l_sys_xcvrs with l_sys_xcvrs to make it more explicit that the soft reset controller operates
       // on each transceiver lane in a system copy, or reset group, but each reset group is tied to a single system copy
       // The number of ports is unchanged.  The ports with the '__MB__ markup are not brought out to the top level in the IP, but are
       // connected at the qtlg step using cross-module references.
       // TX outputs are present only if the tx is enabled
       // RX outputs are present only if the rx is enabled
`__MB__  output wire [l_sys_xcvrs-1:0]       rx_lane_desired_state, // 0:operate  1:reset
`__MB__  output wire [l_sys_xcvrs-1:0]       rx_clear_alarm,
`__MB__  output wire [l_sys_xcvrs-1:0]       sip_rx_ignore_lock2data,
`__MB__   input wire [l_sys_xcvrs-1:0]       sip_am_gen_start,
`__MB__   input wire [l_sys_xcvrs-1:0]       tx_alarm,
`__MB__   input wire [l_sys_xcvrs-1:0]       rx_alarm,
`__MB__   input wire [l_sys_xcvrs-1:0][2:0]  tx_lane_current_state,
       // 100 - in a transitional state
       // 101 - in the full reset state
       // 110 - in the normal operational state
`__MB__   input wire [l_sys_xcvrs-1:0][2:0]  rx_lane_current_state,
       // 100 - in a transitional state
       // 101 - in the full reset state
       // 110 - in the normal operational state
output wire [15:0] rsfec_on,
output wire [47:0] rsfec_type,
output wire [4:0] fracture_cnt,
output wire [3:0] rate_per_xcvr, 
output wire [13:0] profile_sel,
output wire [4:0] xcvr_cnt_per_fracture,
output wire [num_subsys_cop-1:0] rx_reset_subsys,
output wire [num_subsys_cop-1:0] tx_reset_subsys,
output wire [num_subsys_cop-1:0] tx_ready_subsys
);

 
   wire [num_subsys_cop-1:0]   w_src_ctrl_rx_ignore_locked2data;

   // Status lines from the soft reset controller - JRJ
 //  wire [l_sys_xcvrs-1:0] tx_lane_is_in_reset;
 //  wire [l_sys_xcvrs-1:0] rx_lane_is_in_reset;
 //  wire [l_sys_xcvrs-1:0] tx_lane_out_of_reset;
  // wire [l_sys_xcvrs-1:0] rx_lane_out_of_reset; // make it as connection to the IP top level for RX de-skew reset
   wire [l_sys_xcvrs-1:0] tx_per_lane_sip_am_gen_start;
   wire [l_sys_xcvrs-1:0] tx_per_lane_sip_am_gen_2x_ack;

   // UX PMA status 
   wire [l_sys_xcvrs-1:0]   fgt_tx_pll_locked;                 
   wire [l_sys_xcvrs-1:0]   fgt_rx_is_lockedtodata;          
   wire [l_sys_xcvrs-1:0]   fgt_rx_is_lockedtoref;          

   // BK PMA status
   wire [l_sys_xcvrs-1:0]   fht_tx_pll_locked;                 
   wire [l_sys_xcvrs-1:0]   fht_rx_is_lockedtodata;          
   wire [l_sys_xcvrs-1:0]   fht_rx_is_lockedtoref;  

  // ctrl  signals from and and status signals to soft CSR
  wire    [num_subsys_cop-1:0]                     dphy_reset_soft_tx_rst;
  wire    [num_subsys_cop-1:0]                     dphy_reset_tx_rst_ovr;
  wire    [num_subsys_cop-1:0]                     dphy_reset_soft_rx_rst;
  wire    [num_subsys_cop-1:0]                     dphy_reset_rx_rst_ovr;
 
// from AVMM1
wire [31:0] fec_mode_group1;
wire [31:0] fec_mode_group2;
reg  [13:0] profile_sel_reg; 

assign profile_sel = profile_sel_reg;

  // Wires for EHIP
   wire  [l_sys_aibs-1:0]  w_ehip__i_clear_internal;
   wire  [l_sys_aibs-1:0]  w_ehip__i_pld_ready;
   wire  [l_sys_aibs-1:0]  w_ehip__i_signal_ok;                  // Driven by Reset Controller
   wire  [l_sys_aibs-1:0]  w_ehip__o_hi_ber;
   wire  [l_sys_aibs-1:0]  w_ehip__o_hip_ready;
   wire  [l_sys_aibs-1:0]  w_ehip__o_local_fault;
   wire  [l_sys_aibs-1:0]  w_ehip__o_rx_am_lock;
   wire  [l_sys_aibs-1:0]  w_ehip__o_rx_block_lock;
   wire  [l_sys_aibs-1:0]  w_ehip__o_rx_dsk_done;
   wire  [l_sys_aibs-1:0]  w_ehip__o_rx_pcs_fully_aligned;
   wire  [l_sys_aibs-1:0]  w_ehip__o_rx_pcs_internal_err;
   wire  [l_sys_aibs-1:0]  w_ehip__o_rx_rst_n;
   wire  [l_sys_aibs-1:0]  w_ehip__o_tx_rst_n;
   wire  [l_sys_aibs-1:0]  w_ehip__o_txfifo_pfull;
   wire  [l_sys_aibs-1:0]  w_ehip__i_sfreeze[3:0];
   wire  [l_sys_aibs-1:0]  w_ehip__i_tx_pause;
   wire  [l_sys_aibs-1:0]  w_ehip__i_tx_pfc[7:0];
   wire  [l_sys_aibs-1:0]  w_ehip__o_remote_fault;
   wire  [l_sys_aibs-1:0]  w_ehip__o_rx_pause;
   wire  [l_sys_aibs-1:0]  w_ehip__o_rx_pfc[7:0];

  // Wires for GDR Ctrol:  FEC, XCVRIF
   wire  [l_sys_aibs-1:0]  w_gdrctrl__xcvrif_hold_inter;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__rx_lane_hold_inter;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__rx_aggr_hold_inter;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__o_pcs_rx_sf;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__fec_not_align;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__fec_not_deskew;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__fec_not_locked;

                 // unverified:
   wire  [l_sys_aibs-1:0]  w_gdrctrl__i_lphy_signal_ok;           // Driven by Reset Controller
   wire  [l_sys_aibs-1:0]  w_gdrctrl__i_rx_async_pulseTBD;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__i_rx_reset_sfreeze_fec;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__i_rx_reset_sfreeze_xcvrif;  // Driven by Reset Controller
   wire  [l_sys_aibs-1:0]  w_gdrctrl__i_tx_async_pulseTBD;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__i_tx_reset_sfreeze_fec;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__i_tx_reset_sfreeze_xcvrif;  // Driven by Reset Controller
   wire  [l_sys_aibs-1:0]  w_gdrctrl__o_xcvrif_rxfifo_empty;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__o_xcvrif_rxfifo_pempty;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__o_xcvrif_rxfifo_pfull;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__o_xcvrif_txfifo_empty;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__o_xcvrif_txfifo_pempty;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__o_xcvrif_txfifo_pfull;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__rx_gb_resync;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__tx_gb_resync;
   wire  [l_sys_aibs-1:0]  w_gdrctrl__tx_lane_hold_interrupt;


  // Wires for FHTs 
   wire [l_sys_xcvrs-1:0] w_fht__obrk_rx_direct_lane1[7:0];



  // Wires for FGTs 
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_rxbist_en_lx_a;
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_rxbitslip_lx_a;
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_rxeiosdetectstat_lx_a;
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_rxeq_clr_lx_a;
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_rxeq_precal_code_sel_lx_nt_[2:0];
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_rxeq_start_lx_a;
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_rxeq_static_en_lx_a;
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_rxeyediag_start_lx_a;
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_rxrate_lx_[3:0];
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_rxterm_hiz_en_lx_a;
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_txdrv_levnm1_lx_[4:0];
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_txdrv_levnm2_lx_[2:0];
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_txdrv_levnp1_lx_[4:0];
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_txdrv_slew_lx_[3:0];
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_txenable;
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_txrate_lx_[3:0];
   wire [l_sys_xcvrs-1:0] w_fgt__ictl_pcs_txwidth_lx_[2:0];
   wire [l_sys_xcvrs-1:0] w_fgt__octl_pcs_rxeq_done_lx_a;
   wire [l_sys_xcvrs-1:0] w_fgt__octl_pcs_synthlcslow_ready_a;
   wire [l_sys_xcvrs-1:0] w_fgt__octl_pcs_txdetectrx_ack_lx_a;
   wire [l_sys_xcvrs-1:0] w_fgt__octl_pcs_txdetectrx_stat_lx_ct;
   wire [l_sys_xcvrs-1:0] w_fgt__octl_pcs_cmn_ready_a;


//-----------------------------------------------------------------------------
//   Interface mapping:  XCVR FGT/FHT
//-----------------------------------------------------------------------------
if (bb_f_ehip_xcvr_type=="XCVR_TYPE_UX") begin:mapping_fgt
    // Does  l_sys_xcvrs == l_sys_aibs for UX case?
   assign               w_fgt__ictl_pcs_txenable = tx_enable_xcvr;
end



//-----------------------------------------------------------------------------
//   Interface mapping:  XCVR IF
//-----------------------------------------------------------------------------
   assign  xcvrif_rxfifo_empty = w_gdrctrl__o_xcvrif_rxfifo_empty;
   assign xcvrif_rxfifo_pempty = w_gdrctrl__o_xcvrif_rxfifo_pempty;
   assign  xcvrif_rxfifo_pfull = w_gdrctrl__o_xcvrif_rxfifo_pfull;

   assign  xcvrif_txfifo_empty = w_gdrctrl__o_xcvrif_txfifo_empty;
   assign xcvrif_txfifo_pempty = w_gdrctrl__o_xcvrif_txfifo_pempty;
   assign  xcvrif_txfifo_pfull = w_gdrctrl__o_xcvrif_txfifo_pfull;

   assign xcvrif_hold_interrupt = w_gdrctrl__xcvrif_hold_inter;



//-----------------------------------------------------------------------------
//    HW Block <-> Soft-IP
//-----------------------------------------------------------------------------
   assign    pld_pma_ppm_lock = fec_snapshot;

genvar idx_aib;
generate
  for(idx_aib=0;idx_aib<l_sys_aibs;idx_aib=idx_aib+1) begin: pld_intf

   // EHIP
   assign    w_gdrctrl__o_xcvrif_rxfifo_empty[idx_aib] = pld_rx_prbs_done[idx_aib];
   assign    w_gdrctrl__o_xcvrif_rxfifo_pempty[idx_aib] = pld_10g_rx_frame_lock[idx_aib];
   assign    w_gdrctrl__o_xcvrif_rxfifo_pfull[idx_aib] = pld_10g_rx_hi_ber[idx_aib];
   assign    w_gdrctrl__o_xcvrif_txfifo_empty[idx_aib] = pld_rx_prbs_err[idx_aib];
   assign    w_gdrctrl__rx_gb_resync[idx_aib] = pld_rx_hssi_fifo_full[idx_aib];
   assign    w_gdrctrl__tx_gb_resync[idx_aib] = pld_tx_hssi_fifo_empty[idx_aib];
   assign    w_gdrctrl__tx_lane_hold_interrupt[idx_aib] = pld_tx_hssi_fifo_full[idx_aib];
   assign    { w_ehip__o_txfifo_pfull[idx_aib], w_gdrctrl__o_xcvrif_txfifo_pfull[idx_aib], w_gdrctrl__o_xcvrif_txfifo_pempty[idx_aib]  } = hip_aib_fsr_out[4*idx_aib+:3];
   assign    { w_gdrctrl__xcvrif_hold_inter[idx_aib],w_gdrctrl__fec_not_align[idx_aib],w_gdrctrl__fec_not_deskew[idx_aib],w_gdrctrl__fec_not_locked[idx_aib],w_gdrctrl__rx_aggr_hold_inter[idx_aib],w_gdrctrl__o_pcs_rx_sf[idx_aib],w_gdrctrl__rx_lane_hold_inter[idx_aib] } = hip_aib_ssr_out[8*idx_aib+:7];

// assign    hip_aib_fsr_in[4*idx_aib] = w_gdrctrl__i_lphy_signal_ok[idx_aib];  -- Driven by Reset Controller
//                                       w_gdrctrl__i_rx_reset_sfreeze_xcvrif   -- Driven by Reset Controller
//                                       w_gdrctrl__i_tx_reset_sfreeze_xcvrif   -- Driven by Reset Controller
//                                       w_ehip__i_signal_ok                    -- Driven by Reset Controller
//TODO assign    hip_aib_ssr_in[40*idx_aib+:40] = { w_fgt__ictl_pcs_txdrv_levnp1_lx_[1][idx_aib], w_fgt__ictl_pcs_txdrv_levnp1_lx_[2][idx_aib], w_fgt__ictl_pcs_txdrv_levnp1_lx_[3][idx_aib], w_fgt__ictl_pcs_txdrv_levnp1_lx_[4][idx_aib], w_fgt__ictl_pcs_txdrv_slew_lx_[0][idx_aib], w_fgt__ictl_pcs_txdrv_slew_lx_[1][idx_aib], w_fgt__ictl_pcs_txdrv_slew_lx_[2][idx_aib], w_fgt__ictl_pcs_txdrv_slew_lx_[3][idx_aib], w_fgt__ictl_pcs_rxeq_start_lx_a[idx_aib], w_fgt__ictl_pcs_rxeq_precal_code_sel_lx_nt_[0][idx_aib], w_fgt__ictl_pcs_rxeq_precal_code_sel_lx_nt_[1][idx_aib], w_fgt__ictl_pcs_rxeq_precal_code_sel_lx_nt_[2][idx_aib], w_fgt__ictl_pcs_rxeq_clr_lx_a[idx_aib], w_fgt__ictl_pcs_txenable[idx_aib], w_fgt__ictl_pcs_rxeyediag_start_lx_a[idx_aib], w_fgt__ictl_pcs_rxbist_en_lx_a[idx_aib], w_ehip__i_tx_pfc[0][idx_aib], w_ehip__i_tx_pfc[1][idx_aib], w_ehip__i_tx_pfc[2][idx_aib], w_ehip__i_tx_pfc[3][idx_aib], w_ehip__i_tx_pfc[4][idx_aib], w_ehip__i_tx_pfc[5][idx_aib], w_ehip__i_tx_pfc[6][idx_aib], w_ehip__i_tx_pfc[7][idx_aib], w_ehip__i_tx_pause[idx_aib], w_ehip__i_clear_internal[idx_aib], w_ehip__i_signal_ok[idx_aib], w_ehip__i_pld_ready[idx_aib], w_ehip__i_sfreeze[0][idx_aib], w_ehip__i_sfreeze[1][idx_aib], w_ehip__i_sfreeze[2][idx_aib], w_ehip__i_sfreeze[3][idx_aib],,, w_gdrctrl__i_tx_async_pulseTBD[idx_aib], w_gdrctrl__i_rx_async_pulseTBD[idx_aib], w_gdrctrl__i_tx_reset_sfreeze_fec[idx_aib], w_gdrctrl__i_rx_reset_sfreeze_fec[idx_aib], w_gdrctrl__i_tx_reset_sfreeze_xcvrif[idx_aib], w_gdrctrl__i_rx_reset_sfreeze_xcvrif[idx_aib] };


  end // end for idx_aib
endgenerate

 wire [l_sys_xcvrs-1:0] tx_lane_is_in_reset;
 wire [l_sys_xcvrs-1:0] rx_lane_is_in_reset;
 wire [l_sys_xcvrs-1:0] tx_lane_out_of_reset;
 wire [l_sys_xcvrs-1:0] rx_lane_out_of_reset;

 wire [l_sys_xcvrs-1:0] tx_lane_is_in_reset_int;
 wire [l_sys_xcvrs-1:0] rx_lane_is_in_reset_int;
 wire [l_sys_xcvrs-1:0] tx_lane_out_of_reset_int;
// wire [l_sys_xcvrs-1:0] rx_lane_out_of_reset_int;
 wire [l_sys_xcvrs-1:0] tx_per_lane_sip_am_gen_start_int;


 wire [l_sys_xcvrs-1:0] tx_pll_locked_avmm1_int;
 assign tx_pll_locked_avmm1_int = tx_pll_locked;

  wire [l_sys_xcvrs-1:0] rx_cdr_locked_avmm1_int;
 assign rx_cdr_locked_avmm1_int = rx_is_lockedtoref;
 
 
 wire [l_sys_xcvrs-1:0] rx_cdr_locked2data_avmm1_int;
 assign rx_cdr_locked2data_avmm1_int = rx_is_lockedtodata;


/////// from avmm1
 
 
reg [l_sys_xcvrs-1:0] phy_tx_pll_locked_tx_pll_locked_i_int [num_subsys_cop-1:0];
reg [l_sys_xcvrs-1:0] phy_rx_cdr_locked_rx_cdr_locked_i_int [num_subsys_cop-1:0];
reg [l_sys_xcvrs-1:0] phy_rx_cdr_locked_rx_cdr_locked2data_i_int [num_subsys_cop-1:0];



////////

reg [num_subsys_cop-1 : 0] tx_pll_lock_int ;
reg [num_subsys_cop-1 : 0] w_gdrctrl__fec_not_deskew_int;
reg [num_subsys_cop-1 : 0] w_gdrctrl__fec_not_locked_int;
reg [num_subsys_cop-1 : 0] w_gdrctrl__fec_not_align_int;
reg [num_subsys_cop-1 : 0] w_gdrctrl__o_pcs_rx_sf_int;


assign tx_lane_is_in_reset_int          = tx_lane_is_in_reset;
assign rx_lane_is_in_reset_int          = rx_lane_is_in_reset;
assign tx_lane_out_of_reset_int         = tx_lane_out_of_reset;
assign rx_lane_out_of_reset_int         = rx_lane_out_of_reset;
assign tx_per_lane_sip_am_gen_start_int = tx_per_lane_sip_am_gen_start;

reg [l_sys_xcvrs-1 : 0]    tx_per_lane_sip_am_gen_2x_ack_int;
reg [l_sys_xcvrs-1 : 0]    sip_rx_ignore_lock2data_int;

reg [num_subsys_cop-1 : 0] tx_reset_int;
reg [num_subsys_cop-1 : 0] rx_reset_int;
reg [num_subsys_cop-1 : 0] tx_am_gen_start_int;

reg [num_subsys_cop-1:0] tx_reset_ack_int;
reg [num_subsys_cop-1:0] rx_reset_ack_int;

reg [num_subsys_cop-1:0] tx_ready_int;
reg [num_subsys_cop-1:0] rx_ready_int;

assign rx_reset_subsys = rx_reset_int;
assign tx_reset_subsys = tx_reset_int;
assign tx_ready_subsys = tx_ready_int;
assign tx_reset_ack    = tx_reset_ack_int;
assign rx_reset_ack    = rx_reset_ack_int;
assign tx_ready        = tx_ready_int;
assign rx_ready        = rx_ready_int;
assign tx_am_gen_start = tx_am_gen_start_int;


always @ (*) begin

case ( profile_sel_reg )   // 25G-1
14'b00001_00001_0001 : begin // 1x25g_1
                               tx_pll_lock_int                                = tx_pll_locked;
                               w_gdrctrl__fec_not_deskew_int                  = w_gdrctrl__fec_not_deskew;
                               w_gdrctrl__fec_not_locked_int                  = w_gdrctrl__fec_not_locked;
                               w_gdrctrl__fec_not_align_int                   = w_gdrctrl__fec_not_align;
                               w_gdrctrl__o_pcs_rx_sf_int                     = w_gdrctrl__o_pcs_rx_sf;
                               tx_reset_int                                   = tx_reset;
                               rx_reset_int                                   = rx_reset;
                               tx_reset_ack_int                               = tx_lane_is_in_reset_int;  
                               rx_reset_ack_int                               = rx_lane_is_in_reset_int;  
                               tx_ready_int                                   = tx_lane_out_of_reset_int;  
                               rx_ready_int                                   = rx_lane_out_of_reset_int;
                               tx_am_gen_start_int                            = tx_per_lane_sip_am_gen_start_int; 
                               tx_per_lane_sip_am_gen_2x_ack_int              = tx_am_gen_2x_ack;
                               sip_rx_ignore_lock2data_int             = w_src_ctrl_rx_ignore_locked2data;
                               phy_tx_pll_locked_tx_pll_locked_i_int[0]       = tx_pll_locked_avmm1_int[0];
                               phy_rx_cdr_locked_rx_cdr_locked_i_int[0]       = rx_cdr_locked_avmm1_int[0];
                               phy_rx_cdr_locked_rx_cdr_locked2data_i_int[0]  = rx_cdr_locked2data_avmm1_int[0];
                       end
             default : begin
                               tx_pll_lock_int                                = 'h0;
                               w_gdrctrl__fec_not_deskew_int                  = 'h0;
			       w_gdrctrl__fec_not_locked_int                  = 'h0;
                               w_gdrctrl__fec_not_align_int                   = 'h0;
                               w_gdrctrl__o_pcs_rx_sf_int                     = 'h0;
			       tx_reset_int                                   = 'h0;
		               rx_reset_int                                   = 'h0;
			       tx_reset_ack_int                               = 'h0;
			       rx_reset_ack_int                               = 'h0;
			       tx_ready_int                                   = 'h0;
                               rx_ready_int                                   = 'h0;
                               tx_am_gen_start_int                            = 'h0; 
                               tx_per_lane_sip_am_gen_2x_ack_int              = 'h0;
                               sip_rx_ignore_lock2data_int             = 'h0;
                               phy_tx_pll_locked_tx_pll_locked_i_int[0]       = 'h0;
                               phy_rx_cdr_locked_rx_cdr_locked_i_int[0]       = 'h0;
                               phy_rx_cdr_locked_rx_cdr_locked2data_i_int[0]  = 'h0;
                       end
endcase
end

genvar idx_sys_cop;
generate
for(idx_sys_cop=0;idx_sys_cop<num_subsys_cop;idx_sys_cop=idx_sys_cop+1) begin: persystem

     assign sip_rx_ignore_lock2data[idx_sys_cop] = sip_rx_ignore_lock2data_int[idx_sys_cop];

   //-----------------------------------------------------------------------------
   //   Instantiations of soft custom cadence generation (CCG)
   //-----------------------------------------------------------------------------
       // custom cadence controller with it's ram disabled
       // follows example in regtest/ip/efifo_f/hsl_dcfifo_v3_ext_ram/test/dut.sv
       dphy_f_dr_ccg # (
          .WIDTH       (80),
          .DISABLE_RAM (1),
          .ADDR_WIDTH (5)
        ) ccg (
          .aclr   (tx_reset[idx_sys_cop] | ~tx_pll_lock_int[idx_sys_cop]),
          .wclk   (tx_cadence_slow_clk[idx_sys_cop]),
          .wreq   (1'b1),  
          .rclk   (tx_cadence_fast_clk[idx_sys_cop]),
          .rreq   (1'b1),
          .rempty (),
          .data_valid (tx_cadence[idx_sys_cop])
        );
		  

   //-----------------------------------------------------------------------------
   //   Interface mapping:  RSFEC
   //-----------------------------------------------------------------------------
   if (num_fec_ch>0) begin:mapping_rsfec
       assign  rsfec_status_rx_not_deskew[idx_sys_cop] = w_gdrctrl__fec_not_deskew_int[idx_sys_cop];
       assign  rsfec_status_rx_not_locked[idx_sys_cop] = w_gdrctrl__fec_not_locked_int[idx_sys_cop];
       assign   rsfec_status_rx_not_align[idx_sys_cop] =  w_gdrctrl__fec_not_align_int[idx_sys_cop];
       assign                    rsfec_sf[idx_sys_cop] =    w_gdrctrl__o_pcs_rx_sf_int[idx_sys_cop];
   end


       if (bb_f_ehip_xcvr_type=="XCVR_TYPE_UX") begin:fgt
         // Shared bits
	 
       end  // end if bb_f_ehip_xcvr_type=FGT
       else begin:fht
	 //map BK PMA status 
           assign fht_rx_energy_detect[idx_sys_cop]   = fht_rx_direct[idx_sys_cop*8+2];    //TODO: energy detect = signal detect?
           assign fht_tx_pll_locked[idx_sys_cop]      = fht_rx_direct[idx_sys_cop*8];      //TODO: control bits?           
           assign fht_rx_is_lockedtodata[idx_sys_cop] = fht_rxsrds_rdy[idx_sys_cop];          
           assign fht_rx_is_lockedtoref[idx_sys_cop]  = fht_rx_direct[idx_sys_cop*8+1];  
       end  // end if bb_f_ehip_xcvr_type=FHT

     // Connect soft reset controller desired lane state inputs
     // For right now, there is a single tx_reset and a single rx_reset input - JRJ
      assign rx_lane_desired_state[idx_sys_cop] = ((dphy_reset_rx_rst_ovr[idx_sys_cop])? dphy_reset_soft_rx_rst[idx_sys_cop] : rx_reset_int[idx_sys_cop]);

      // Connect soft reset controller current lane state outputs
      assign tx_lane_is_in_reset[idx_sys_cop]  = tx_lane_current_state[idx_sys_cop][0];
      assign rx_lane_is_in_reset[idx_sys_cop]  = rx_lane_current_state[idx_sys_cop][0];
      assign tx_lane_out_of_reset[idx_sys_cop] = tx_lane_current_state[idx_sys_cop][1];
      assign rx_lane_out_of_reset[idx_sys_cop] = rx_lane_current_state[idx_sys_cop][1];

      // Connect soft reset controller sip_am_gen_start and sip_am_gen_2x_ack ports for each transceiver
      assign tx_per_lane_sip_am_gen_start[idx_sys_cop] = sip_am_gen_start[idx_sys_cop];

 //  end // end for perxcvr

 
end // end for persystem

endgenerate
   

//-----------------------------------------------------------------------------
//   Interface mapping:  UX BB
//-----------------------------------------------------------------------------
   assign fgt_rx_signal_detect = oct_pcs_rxsignaldetect_lx_a;
   assign fgt_rx_signal_detect_lfps = octl_pcs_rxsignaldetect_lfps_lx_a;
   assign fgt_tx_pll_locked = oct_pcs_all_synthlockstatus & octl_pcs_txstatus_lx_a;//status signal is more like pma ready hence anding them to make it similar to previous tiles                
   assign fgt_rx_is_lockedtodata = oct_pcs_rxcdrlock2data_lx_a;        
   assign fgt_rx_is_lockedtoref = oct_pcs_rxcdrlockstatus_lx_a;
   assign ictl_pcs_rxovrcdrlock2dataen_lx_a = fgt_rx_set_locktoref;
   assign ictl_pcs_rxovrcdrlock2data_lx_a = fgt_rx_set_locktodata;//setting mode to always locktoref and reflecting functionality on enable disable.
   assign ictl_pcs_txbeacon_lx_a = fgt_tx_beacon;
   assign flux_top__iflux_ingress_direct__231 = fgt_rx_cdr_freeze;
   assign i_xcvrrc_fsrssr_xcvr_ux_ds_0__xcvr_f2t = fgt_rx_cdr_fast_freeze_sel;
   assign ictl_pcs_rxeiosdetectstat_lx_a         = fgt_rx_cdr_set_locktoref;

   assign tx_pll_locked      = (bb_f_ehip_xcvr_type=="XCVR_TYPE_UX")? fgt_tx_pll_locked       : fht_tx_pll_locked     ;  
   assign rx_is_lockedtoref  = (bb_f_ehip_xcvr_type=="XCVR_TYPE_UX")? fgt_rx_is_lockedtoref   : fht_rx_is_lockedtoref ; 
   assign rx_is_lockedtodata = (bb_f_ehip_xcvr_type=="XCVR_TYPE_UX")? fgt_rx_is_lockedtodata  : fht_rx_is_lockedtodata;   

//-----------------------------------------------------------------------------
//   Interface mapping:  Clocks and Data
//-----------------------------------------------------------------------------
     // TO DO, map the parallel data in simplified data bus
     // for now, just pass through
  assign sync_data_to_aib   = tx_parallel_data;
  assign rx_parallel_data   = sync_data_from_aib;

//-----------------------------------------------------------------------------
//   Interface mapping:  Instantiations of soft AVMM1/2 modules
//-----------------------------------------------------------------------------
// TO DO: add AVMM soft logic, shared I/F, 32 to 8 conversion, and ADME

//AVMM1 signals
  wire  [num_subsys_cop-1:0] [l_sys_aibs-1:0]      pld_avmm1_clk_rowclk_int;
  wire  [num_subsys_cop-1:0] [l_sys_aibs-1:0]      pld_avmm1_read_int;
  wire  [num_subsys_cop-1:0] [10*l_sys_aibs-1:0]   pld_avmm1_reg_addr_int;
  wire  [num_subsys_cop-1:0] [l_sys_aibs-1:0]      pld_avmm1_request_int;
  wire  [num_subsys_cop-1:0] [9*l_sys_aibs-1:0]    pld_avmm1_reserved_in_int;
  wire  [num_subsys_cop-1:0] [l_sys_aibs-1:0]      pld_avmm1_write_int;
  wire  [num_subsys_cop-1:0] [8*l_sys_aibs-1:0]    pld_avmm1_writedata_int;
 
//AVMM2 signals
  wire  [num_subsys_cop-1:0] [21*l_sys_xcvrs-1:0]   hip_avmm_reg_addr_int;
  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      hip_avmm_write_int;
  wire  [num_subsys_cop-1:0] [8*l_sys_xcvrs-1:0]    hip_avmm_writedata_int; 
  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      pld_avmm2_clk_rowclk_int;
  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      pld_avmm2_request_int;
  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      hip_avmm_read_int;
  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      pld_avmm2_write_int;
  wire  [num_subsys_cop-1:0] [l_sys_xcvrs-1:0]      pld_avmm2_read_int;
  wire  [num_subsys_cop-1:0] [9*l_sys_xcvrs-1:0]    pld_avmm2_reg_addr_int;
  wire  [num_subsys_cop-1:0] [8*l_sys_xcvrs-1:0]    pld_avmm2_writedata_int;
  wire  [num_subsys_cop-1:0] [6*l_sys_xcvrs-1:0]    pld_avmm2_reserved_in_int;

assign pld_avmm1_clk_rowclk   = pld_avmm1_clk_rowclk_int[0] ;
assign pld_avmm1_read         = pld_avmm1_read_int[0] ;
assign pld_avmm1_reg_addr     = pld_avmm1_reg_addr_int[0] ;								
assign pld_avmm1_request      = pld_avmm1_request_int[0] ;
assign pld_avmm1_reserved_in  = pld_avmm1_reserved_in_int[0] ;
assign pld_avmm1_write        = pld_avmm1_write_int[0];
assign pld_avmm1_writedata    = pld_avmm1_writedata_int[0];
 
assign hip_avmm_reg_addr      = hip_avmm_reg_addr_int[0] ;
assign hip_avmm_write         = hip_avmm_write_int[0];
assign hip_avmm_writedata     = hip_avmm_writedata_int[0] ;							
assign pld_avmm2_clk_rowclk   = pld_avmm2_clk_rowclk_int[0] ;
assign pld_avmm2_request      = pld_avmm2_request_int[0]  ;
assign hip_avmm_read          = hip_avmm_read_int[0];
assign pld_avmm2_write        = pld_avmm2_write_int[0] ;
assign pld_avmm2_read         = pld_avmm2_read_int[0] ;
assign pld_avmm2_reg_addr     = pld_avmm2_reg_addr_int[0] ;
assign pld_avmm2_writedata    = pld_avmm2_writedata_int[0] ;	
assign pld_avmm2_reserved_in  = pld_avmm2_reserved_in_int[0] ;



localparam DATA_WIDTH = 32 ;
localparam BE_WIDTH   = DATA_WIDTH/8 ;

   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm1_clk;
   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm1_reset;
   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm1_write;
   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm1_read;
   wire  [num_sys_cop*l_av1_addr_bits-1:0]  ftile_dphy_adme_avmm1_address;
   wire  [num_sys_cop*4-1:0]  ftile_dphy_adme_avmm1_byteenable;
   wire  [num_sys_cop*32-1:0] ftile_dphy_adme_avmm1_writedata;
   wire  [num_sys_cop*32-1:0] ftile_dphy_adme_avmm1_readdata;
   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm1_waitrequest;
   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm1_readdatavalid;

   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm2_clk;
   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm2_reset;
   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm2_write;
   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm2_read;
   wire  [num_sys_cop*l_av2_addr_bits-1:0]  ftile_dphy_adme_avmm2_address;
   wire  [num_sys_cop*4-1:0]  ftile_dphy_adme_avmm2_byteenable;
   wire  [num_sys_cop*32-1:0] ftile_dphy_adme_avmm2_writedata;
   wire  [num_sys_cop*32-1:0] ftile_dphy_adme_avmm2_readdata;
   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm2_waitrequest;
   wire  [num_sys_cop-1:0]    ftile_dphy_adme_avmm2_readdatavalid;

   reg  [l_av1_ifaces*32-1:0] dphy_avmm1_readdata;
   reg  [l_av1_ifaces-1:0]    dphy_avmm1_waitrequest;
   reg  [l_av1_ifaces-1:0]    dphy_avmm1_readdatavalid;

   reg  [l_av2_ifaces*32-1:0] dphy_avmm2_readdata;
   reg  [l_av2_ifaces-1:0]    dphy_avmm2_waitrequest;
   reg  [l_av2_ifaces-1:0]    dphy_avmm2_readdatavalid;

wire    [num_subsys_cop-1:0][DATA_WIDTH-1:0] dphy_avmm1_readdata_int;
wire    [num_subsys_cop-1:0]                 dphy_avmm1_waitrequest_int;
wire    [num_subsys_cop-1:0]                 dphy_avmm1_readdatavalid_int;

wire    [num_subsys_cop-1:0][DATA_WIDTH-1:0] dphy_avmm2_readdata_int;
wire    [num_subsys_cop-1:0]                 dphy_avmm2_waitrequest_int;
wire    [num_subsys_cop-1:0]                 dphy_avmm2_readdatavalid_int;

						
reg    [reconfig_xcvr_address_width-1:0]address;
logic  [reconfig_xcvr_address_width-1:0]avmm2_address;
reg    [reconfig_pdp_address_width-1:0]av1_address;
logic  [reconfig_pdp_address_width-1:0]avmm1_address;


always @(posedge reconfig_pdp_clk or posedge reconfig_pdp_reset)  begin
 if(reconfig_pdp_reset)
   av1_address <= 'h0;
 else if((|reconfig_pdp_write) || (|reconfig_pdp_read))
   av1_address <= reconfig_pdp_address;
end

assign avmm1_address = av1_address;

always_comb begin
      dphy_avmm1_waitrequest   = dphy_avmm1_waitrequest_int[0] ;
      dphy_avmm1_readdata      = dphy_avmm1_readdata_int[0] ;
      dphy_avmm1_readdatavalid = dphy_avmm1_readdatavalid_int[0] ;
end


always_comb begin
     address                 = 'h0;
     avmm2_address           = 'h0;
     dphy_avmm2_readdata       = 'h0;
     dphy_avmm2_waitrequest    = 'h0;
     dphy_avmm2_readdatavalid  = 'h0;
  end
 


    genvar ig;
     for(ig=0;ig<num_sys_cop;ig=ig+1) begin:f_dphy_adme

        sdi_mr_rx_sys_rx_phy_directphy_f_dr_ftile_adme_400_iidi67y #(
           .avmm1_addr_width   (l_av1_addr_bits),
           .avmm2_addr_width   (l_av2_addr_bits)
        ) f_dphy_adme_inst (

           .avmm1_clk_user                ( reconfig_pdp_clk[ig] ),
           .avmm1_reset_user              ( reconfig_pdp_reset[ig] ),
           .avmm1_address_user            ( reconfig_pdp_address[ig*l_av1_addr_bits+:l_av1_addr_bits] ),
           .avmm1_byte_enable_user        ( reconfig_pdp_byteenable[ig*4+:4] ),     
           .avmm1_write_user              ( reconfig_pdp_write[ig] ),           
           .avmm1_read_user               ( reconfig_pdp_read[ig] ),            
           .avmm1_write_data_user         ( reconfig_pdp_writedata[ig*32+:32] ),      
           .avmm1_read_data_user          ( ftile_dphy_adme_avmm1_readdata[ig*32+:32] ),       
           .avmm1_waitrequest_user        ( ftile_dphy_adme_avmm1_waitrequest[ig] ),     
           .avmm1_read_data_valid_user    ( ftile_dphy_adme_avmm1_readdatavalid[ig] ), 

           .avmm1_clk_tile                ( ftile_dphy_adme_avmm1_clk[ig] ),
           .avmm1_reset_tile              ( ftile_dphy_adme_avmm1_reset[ig] ),
           .avmm1_address_tile            ( ftile_dphy_adme_avmm1_address[ig*l_av1_addr_bits+:l_av1_addr_bits] ),
           .avmm1_byte_enable_tile        ( ftile_dphy_adme_avmm1_byteenable[ig*4+:4] ),     
           .avmm1_write_tile              ( ftile_dphy_adme_avmm1_write[ig] ),           
           .avmm1_read_tile               ( ftile_dphy_adme_avmm1_read[ig] ),            
           .avmm1_write_data_tile         ( ftile_dphy_adme_avmm1_writedata[ig*32+:32] ),      
           .avmm1_read_data_tile          ( dphy_avmm1_readdata[ig*32+:32] ),       
           .avmm1_waitrequest_tile        ( dphy_avmm1_waitrequest[ig] ),     
           .avmm1_read_data_valid_tile    ( dphy_avmm1_readdatavalid[ig] ), 

           .avmm2_clk_user                ( reconfig_clk[ig] ),
           .avmm2_reset_user              ( reconfig_reset[ig] ),
           .avmm2_address_user            ( reconfig_address[ig*l_av2_addr_bits+:l_av2_addr_bits] ),
           .avmm2_byte_enable_user        ( reconfig_byteenable[ig*4+:4] ),     
           .avmm2_write_user              ( reconfig_write[ig] ),           
           .avmm2_read_user               ( reconfig_read[ig] ),            
           .avmm2_write_data_user         ( reconfig_writedata[ig*32+:32] ),      
           .avmm2_read_data_user          ( ftile_dphy_adme_avmm2_readdata[ig*32+:32] ),       
           .avmm2_waitrequest_user        ( ftile_dphy_adme_avmm2_waitrequest[ig] ),     
           .avmm2_read_data_valid_user    ( ftile_dphy_adme_avmm2_readdatavalid[ig] ), 

           .avmm2_clk_tile                ( ftile_dphy_adme_avmm2_clk[ig] ),
           .avmm2_reset_tile              ( ftile_dphy_adme_avmm2_reset[ig] ),
           .avmm2_address_tile            ( ftile_dphy_adme_avmm2_address[ig*l_av2_addr_bits+:l_av2_addr_bits] ),
           .avmm2_byte_enable_tile        ( ftile_dphy_adme_avmm2_byteenable[ig*4+:4] ),     
           .avmm2_write_tile              ( ftile_dphy_adme_avmm2_write[ig] ),           
           .avmm2_read_tile               ( ftile_dphy_adme_avmm2_read[ig] ),            
           .avmm2_write_data_tile         ( ftile_dphy_adme_avmm2_writedata[ig*32+:32] ),      
           .avmm2_read_data_tile          ( dphy_avmm2_readdata[ig*32+:32] ),       
           .avmm2_waitrequest_tile        ( dphy_avmm2_waitrequest[ig] ),     
           .avmm2_read_data_valid_tile    ( dphy_avmm2_readdatavalid[ig] )
	);
     end 
 
    assign  reconfig_pdp_readdata       = ( (avmm1_jtag_enable) ? ftile_dphy_adme_avmm1_readdata      : dphy_avmm1_readdata);       
    assign  reconfig_pdp_waitrequest    = ( (avmm1_jtag_enable) ? ftile_dphy_adme_avmm1_waitrequest   : dphy_avmm1_waitrequest);     
    assign  reconfig_pdp_readdatavalid  = ( (avmm1_jtag_enable) ? ftile_dphy_adme_avmm1_readdatavalid : dphy_avmm1_readdatavalid); 
    assign  reconfig_readdata           = ( (avmm2_jtag_enable) ? ftile_dphy_adme_avmm2_readdata      : dphy_avmm2_readdata);       
    assign  reconfig_waitrequest        = ( (avmm2_jtag_enable) ? ftile_dphy_adme_avmm2_waitrequest   : dphy_avmm2_waitrequest);     
    assign  reconfig_readdatavalid      = ( (avmm2_jtag_enable) ? ftile_dphy_adme_avmm2_readdatavalid : dphy_avmm2_readdatavalid); 



  dphy_f_dr_avmm1 #(
	.num_sys_cop                               (num_sys_cop),
	.num_subsys_cop                            (num_subsys_cop),
	.num_xcvr_per_sys                          (num_xcvr_per_sys),
	.l_num_aib_per_xcvr                        (l_num_aib_per_xcvr),
	.l_sys_aibs                                (l_sys_aibs),
	.l_sys_xcvrs                               (l_sys_xcvrs),
        .l_tx_enable                               (l_tx_enable),
	.l_rx_enable                               (l_rx_enable),
        .xcvr_type                                 ((bb_f_ehip_xcvr_type=="XCVR_TYPE_UX"? 1'b0 : 1'b1)),
        .modulation_type                           ((bb_f_ehip_xcvr_mode=="XCVR_MODE_NRZ")? 1'b0: 1'b1),
        .l_soft_csr_enable                         (l_soft_csr_enable),
        .l_soft_dr_csr_enable                      (l_soft_dr_csr_enable),
        .rcfg_group                                (rcfg_group),
  	.STARTUP_RECONFIG_GRP_VALUE                (STARTUP_RECONFIG_GRP_VALUE),
  	.STARTUP_FEC_GRP1_VALUE                    (STARTUP_FEC_GRP1_VALUE),
  	.STARTUP_FEC_GRP2_VALUE                    (STARTUP_FEC_GRP2_VALUE),
  	.STARTUP_MODULATION_TYPE                   (STARTUP_MODULATION_TYPE),
  	.STARTUP_LINE_RATE_P1GHZ_FRAC1_FRAC0       (STARTUP_LINE_RATE_P1GHZ_FRAC1_FRAC0),
  	.STARTUP_LINE_RATE_P1GHZ_FRAC3_FRAC2       (STARTUP_LINE_RATE_P1GHZ_FRAC3_FRAC2),
  	.STARTUP_LINE_RATE_P1GHZ_FRAC5_FRAC4       (STARTUP_LINE_RATE_P1GHZ_FRAC5_FRAC4),
  	.STARTUP_LINE_RATE_P1GHZ_FRAC7_FRAC6       (STARTUP_LINE_RATE_P1GHZ_FRAC7_FRAC6),
  	.STARTUP_LINE_RATE_P1GHZ_FRAC9_FRAC8       (STARTUP_LINE_RATE_P1GHZ_FRAC9_FRAC8),
  	.STARTUP_LINE_RATE_P1GHZ_FRAC11_FRAC10     (STARTUP_LINE_RATE_P1GHZ_FRAC11_FRAC10),
        .reconfig_pdp_address_width                (reconfig_pdp_address_width),
        .l_line_rate_p1ghz                         (l_line_rate_p1ghz),
        .avmm1_ready_enable                        (avmm1_ready_enable),
	.fec_enable                                (fec_on),
	.avmm1_enable                              (avmm1_enable),
	.l_av1_aib_enable                          (l_av1_aib_enable),
	.l_num_avmm1                               (l_num_avmm1),
	.l_av1_ifaces                              (l_av1_ifaces),
	.l_av1_addr_bits                           (l_av1_addr_bits)
  ) dphy_f_dr_avmm1_inst (
    .reconfig_pdp_clk                              ( (avmm1_jtag_enable) ? ftile_dphy_adme_avmm1_clk           : reconfig_pdp_clk),
    .reconfig_pdp_reset                            ( (avmm1_jtag_enable) ? ftile_dphy_adme_avmm1_reset         : reconfig_pdp_reset),
    .reconfig_pdp_write                            ( (avmm1_jtag_enable) ? ftile_dphy_adme_avmm1_write         : reconfig_pdp_write),           
    .reconfig_pdp_read                             ( (avmm1_jtag_enable) ? ftile_dphy_adme_avmm1_read          : reconfig_pdp_read),            
    .reconfig_pdp_address                          ( (avmm1_jtag_enable) ? ftile_dphy_adme_avmm1_address       : reconfig_pdp_address),
    .reconfig_pdp_byteenable                       ( (avmm1_jtag_enable) ? ftile_dphy_adme_avmm1_byteenable    : reconfig_pdp_byteenable),     
    .reconfig_pdp_writedata                        ( (avmm1_jtag_enable) ? ftile_dphy_adme_avmm1_writedata     : reconfig_pdp_writedata),      
    .reconfig_pdp_readdata                         ( dphy_avmm1_readdata_int      ),       
    .reconfig_pdp_waitrequest                      ( dphy_avmm1_waitrequest_int   ),     
    .reconfig_pdp_readdatavalid                    ( dphy_avmm1_readdatavalid_int ), 
// AVMM1 ports
    .pld_avmm1_busy                                ( pld_avmm1_busy ),
    .pld_avmm1_clk_rowclk                          ( pld_avmm1_clk_rowclk_int ),
    .pld_avmm1_cmdfifo_wr_full                     ( pld_avmm1_cmdfifo_wr_full ),
    .pld_avmm1_cmdfifo_wr_pfull                    ( pld_avmm1_cmdfifo_wr_pfull ),
    .pld_avmm1_read                                ( pld_avmm1_read_int ),
    .pld_avmm1_readdata                            ( pld_avmm1_readdata ),
    .pld_avmm1_readdatavalid                       ( pld_avmm1_readdatavalid ),
    .pld_avmm1_reg_addr                            ( pld_avmm1_reg_addr_int),
    .pld_avmm1_request                             ( pld_avmm1_request_int),
    .pld_avmm1_reserved_in                         ( pld_avmm1_reserved_in_int ),
    .pld_avmm1_reserved_out                        ( pld_avmm1_reserved_out ),
    .pld_avmm1_write                               ( pld_avmm1_write_int ),
    .pld_avmm1_writedata                           ( pld_avmm1_writedata_int ),
    .pld_chnl_cal_done                             ( pld_chnl_cal_done ),
    .pld_hssi_osc_transfer_en                      ( pld_hssi_osc_transfer_en ),  
// ctrl/status
    .dphy_reset_soft_tx_rst                        (dphy_reset_soft_tx_rst),
    .dphy_reset_tx_rst_ovr                         (dphy_reset_tx_rst_ovr),
    .dphy_reset_soft_rx_rst                        (dphy_reset_soft_rx_rst),
    .dphy_reset_rx_rst_ovr                         (dphy_reset_rx_rst_ovr),
    .dphy_reset_status_tx_rst_ack_n_i              (tx_reset_ack),
    .dphy_reset_status_rx_rst_ack_n_i              (rx_reset_ack),
    .dphy_reset_status_tx_ready_i                  (tx_ready),
    .dphy_reset_status_rx_ready_i                  (rx_ready),
    .phy_tx_pll_locked_tx_pll_locked_i_int         ( phy_tx_pll_locked_tx_pll_locked_i_int),
    .phy_rx_cdr_locked_rx_cdr_locked_i_int         (phy_rx_cdr_locked_rx_cdr_locked_i_int),
    .phy_rx_cdr_locked_rx_cdr_locked2data_i_int    (phy_rx_cdr_locked_rx_cdr_locked2data_i_int),
    .src_ctrl_rx_ignore_locked2data                (w_src_ctrl_rx_ignore_locked2data),
    .reconfig_group                                (profile_sel_reg),
    .fec_mode_group1                               (fec_mode_group1),
    .fec_mode_group2                               (fec_mode_group2)
  );


    dphy_f_dr_avmm2 #(
	.num_sys_cop                               (num_sys_cop),
	.num_subsys_cop                            (num_subsys_cop),
	.num_xcvr_per_sys                          (num_xcvr_per_sys),
	.l_num_aib_per_xcvr                        (l_num_aib_per_xcvr),
	.l_sys_xcvrs                               (l_sys_xcvrs),
        .l_tx_enable                               (l_tx_enable),
	.l_rx_enable                               (l_rx_enable),
        .reconfig_xcvr_address_width               (reconfig_xcvr_address_width),
        .avmm2_ready_enable                        (avmm2_ready_enable),
	.avmm2_enable                              (avmm2_enable),
	.l_num_avmm2                               (l_num_avmm2),
	.l_av2_ifaces                              (l_av2_ifaces),
	.l_av2_addr_bits                           (l_av2_addr_bits)
  ) dphy_f_dr_avmm2_inst (
  
    .reconfig_clk                                  ( (avmm2_jtag_enable) ? ftile_dphy_adme_avmm2_clk         : reconfig_clk),
    .reconfig_reset                                ( (avmm2_jtag_enable) ? ftile_dphy_adme_avmm2_reset       : reconfig_reset),
    .reconfig_write                                ( (avmm2_jtag_enable) ? ftile_dphy_adme_avmm2_write       : reconfig_write),           
    .reconfig_read                                 ( (avmm2_jtag_enable) ? ftile_dphy_adme_avmm2_read        : reconfig_read),            
    .reconfig_address                              ( (avmm2_jtag_enable) ? ftile_dphy_adme_avmm2_address     : reconfig_address),
    .reconfig_byteenable                           ( (avmm2_jtag_enable) ? ftile_dphy_adme_avmm2_byteenable  : reconfig_byteenable),     
    .reconfig_writedata                            ( (avmm2_jtag_enable) ? ftile_dphy_adme_avmm2_writedata   : reconfig_writedata),      
    .reconfig_readdata                             ( dphy_avmm2_readdata_int      ),       
    .reconfig_waitrequest                          ( dphy_avmm2_waitrequest_int   ),     
    .reconfig_readdatavalid                        ( dphy_avmm2_readdatavalid_int ), 
  //  for AVMM2 bb ports
    .hip_avmm_read                                 ( hip_avmm_read_int              ),   
    .hip_avmm_readdata                             ( hip_avmm_readdata              ),
    .hip_avmm_readdatavalid                        ( hip_avmm_readdatavalid         ),
    .hip_avmm_reg_addr                             ( hip_avmm_reg_addr_int          ),
    .hip_avmm_reserved_out                         ( hip_avmm_reserved_out          ),
    .hip_avmm_write                                ( hip_avmm_write_int             ),
    .hip_avmm_writedata                            ( hip_avmm_writedata_int         ),
    .hip_avmm_writedone                            ( hip_avmm_writedone             ),
    .pld_avmm2_busy                                ( pld_avmm2_busy                 ),
    .pld_avmm2_clk_rowclk                          ( pld_avmm2_clk_rowclk_int       ),
    .pld_avmm2_cmdfifo_wr_full                     ( pld_avmm2_cmdfifo_wr_full      ),
    .pld_avmm2_cmdfifo_wr_pfull                    ( pld_avmm2_cmdfifo_wr_pfull     ),
    .pld_avmm2_request                             ( pld_avmm2_request_int          ),
    .pld_pll_cal_done                              ( pld_pll_cal_done               ),
    .pld_avmm2_write                               ( pld_avmm2_write_int            ),
    .pld_avmm2_read                                ( pld_avmm2_read_int             ),
    .pld_avmm2_reg_addr                            ( pld_avmm2_reg_addr_int         ),
    .pld_avmm2_readdata                            ( pld_avmm2_readdata             ),
    .pld_avmm2_writedata                           ( pld_avmm2_writedata_int        ),
    .pld_avmm2_readdatavalid                       ( pld_avmm2_readdatavalid        ),
    .pld_avmm2_reserved_in                         ( pld_avmm2_reserved_in_int      ),
    .pld_avmm2_reserved_out                        ( pld_avmm2_reserved_out         )
  );

          
  //--------------------------------------------
  // -- Current profile port/xcvr/datarate/FEC                 
  // --------------------------------------------------
 
  
assign fracture_cnt          = profile_sel_reg[13:9];
assign xcvr_cnt_per_fracture = profile_sel_reg[8:4];
assign rate_per_xcvr         = profile_sel_reg[3:0];

assign rsfec_on   = {{4{1'b0}},(|fec_mode_group2[15:12]),(|fec_mode_group2[11:8]),(|fec_mode_group2[7:4]),(|fec_mode_group2[3:0]),(|fec_mode_group1[31:28]),(|fec_mode_group1[27:24]),(|fec_mode_group1[23:20]),(|fec_mode_group1[19:16]),(|fec_mode_group1[15:12]),(|fec_mode_group1[11:8]),(|fec_mode_group1[7:4]),(|fec_mode_group1[3:0])};
assign rsfec_type = {(fec_mode_group2[15:12]),(fec_mode_group2[11:8]),(fec_mode_group2[7:4]),(fec_mode_group2[3:0]),(fec_mode_group1[31:28]),(fec_mode_group1[27:24]),(fec_mode_group1[23:20]),(fec_mode_group1[19:16]),(fec_mode_group1[15:12]),(fec_mode_group1[11:8]),(fec_mode_group1[7:4]),(fec_mode_group1[3:0])};

endmodule

// Change log:
//    HSD:22010528537   Driven by Reset Controller
//    HSD:<id>          <comment>


