// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// Copyright 2012 Intel Corporation. All rights reserved.  
// Intel products are protected under numerous U.S. and foreign patents, 
// maskwork rights, copyrights and other intellectual property laws.  
//
// This reference design file, and your use thereof, is subject to and governed
// by the terms and conditions of the applicable Intel Reference Design 
// License Agreement (either as signed by you or found at www.altera.com).  By
// using this reference design file, you indicate your acceptance of such terms
// and conditions between you and Intel Corporation.  In the event that you do
// not agree with such terms and conditions, you may not use the reference 
// design file and please promptly destroy any copies you have made.
//
// This reference design file is being provided on an "as-is" basis and as an 
// accommodation and therefore all warranties, representations or guarantees of 
// any kind (whether express, implied or statutory) including, without 
// limitation, warranties of merchantability, non-infringement, or fitness for
// a particular purpose, are Intel disclaimed.  By making this reference
// design file available, Intel expressly does not recommend, suggest or 
// require that this reference design file be used in combination with any 
// other product not provided by Intel.
/////////////////////////////////////////////////////////////////////////////


`timescale 1 ps / 1 ps

// baeckler - 01-08-2012

module sync_regs_aclr_m2 #(
	parameter WIDTH = 32,
	parameter DEPTH = 2		// minimum of 2
)(
	input clk,
	input aclr,
	input [WIDTH-1:0] din,
	output [WIDTH-1:0] dout
);

reg [WIDTH-1:0] din_meta = 0;

reg [WIDTH*(DEPTH-1)-1:0] sync_sr = 0;


always @(posedge clk or posedge aclr) begin
	if (aclr) begin 
		din_meta <= {WIDTH{1'b0}};
		sync_sr <= {(WIDTH*(DEPTH-1)){1'b0}};
	end
	else begin
		din_meta <= din;
		sync_sr <= (DEPTH==2)? din_meta : (sync_sr << WIDTH) | din_meta;
	end
end
assign dout = sync_sr[WIDTH*(DEPTH-1)-1:WIDTH*(DEPTH-2)];

endmodule

// BENCHMARK INFO :  5SGXEA7N2F45C2
// BENCHMARK INFO :  Max depth :  0.0 LUTs
// BENCHMARK INFO :  Total registers : 64
// BENCHMARK INFO :  Total pins : 66
// BENCHMARK INFO :  Total virtual pins : 0
// BENCHMARK INFO :  Total block memory bits : 0
// BENCHMARK INFO :  Comb ALUTs :                         ; 1               ;       ;
// BENCHMARK INFO :  ALMs : 17 / 234,720 ( < 1 % )
// BENCHMARK INFO :  Worst setup path @ 468.75MHz : 1.702 ns, From din_meta[22], To sync_sr[22]}
// BENCHMARK INFO :  Worst setup path @ 468.75MHz : 1.705 ns, From din_meta[13], To sync_sr[13]}
// BENCHMARK INFO :  Worst setup path @ 468.75MHz : 1.708 ns, From din_meta[13], To sync_sr[13]}
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRxhV5IoRzfE7XKbbV6kYEyf8uKruhFr1M6AwisOnba49sqPSZDgOuwqyY0yHcqLRqo/ynFwmFZqGK34GBZnV2tGHKsXIBuiXO0NVJdR2MxClBatZJ2Jcda3pfbXFe51CGbpphmnHd6QTpqlF7Ex5IS5hPZJWWBxADLFqxoVJTK3LqW7aXLAuZbAOoHoROcM9bGS+4jCSd4375axUhVg5+BZeVPJy75GBx7GHfdQFY1KdSdnMWlO5o0B3K7L/3S2GULihSEnyocUQKzdd9ZQqZeG8fAA9rCIurgg0O6gov0uRaZ6dLLh5phyp9mL+NUppFxz4pqaAtO/dCCSDKlHYvIYpr26oMnoSLr1gyOAMGy8+NlD1xHYYH2I4q3Zyp8Ra4tugVTj9VAyWVhrSl8yhD9X/+4fIUIgx9FA3zg0b9sczGbpt8JpY5Hl1WivLRkWyv5TkEz812T5iiIK2j35PVDMQoO/AkdEA8zGlwVnryuqyjxaZq8ol2pbE2AeOgkVMjxX6nF4P0EtvOin91BBlHRseAYjYky9uTKQJxvlnxXAUuWavfDBqlOli1vCrd9GYAu93u7XKlmD2v7Sa1Y+FZHuwoqklQdGubHMywCC/XjAXCfRsrAQSTR71h8oDggo5IolAOJ+wQOy21jLsCYrM55tNFFAWp5taMlYIa12qsycPAsI8b8y+Qyyb3jLM97t/zXAb1dDGzV91D/31nDOLSjAQ1kw5VwmLmw7MYEXAlWdVbjAYudVHTUD/H00HLXAwuhoPxysTT8mAJgNN9gyhBJl"
`endif