// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// Copyright 2012 Intel Corporation. All rights reserved.  
// Intel products are protected under numerous U.S. and foreign patents, 
// maskwork rights, copyrights and other intellectual property laws.  
//
// This reference design file, and your use thereof, is subject to and governed
// by the terms and conditions of the applicable Intel Reference Design 
// License Agreement (either as signed by you or found at www.altera.com).  By
// using this reference design file, you indicate your acceptance of such terms
// and conditions between you and Intel Corporation.  In the event that you do
// not agree with such terms and conditions, you may not use the reference 
// design file and please promptly destroy any copies you have made.
//
// This reference design file is being provided on an "as-is" basis and as an 
// accommodation and therefore all warranties, representations or guarantees of 
// any kind (whether express, implied or statutory) including, without 
// limitation, warranties of merchantability, non-infringement, or fitness for
// a particular purpose, are specifically disclaimed.  By making this reference
// design file available, Intel expressly does not recommend, suggest or 
// require that this reference design file be used in combination with any 
// other product not provided by Intel.
/////////////////////////////////////////////////////////////////////////////
 
`timescale 1ps/1ps
 
module directphy_f_gray_cntr_5_sl #(
	parameter SLD_VAL = 5'h0,
	parameter TARGET_CHIP = 2,
	parameter LOAD_IMPLIES_ENA = 1'b1
)(
	input clk,
	input ena,
	input sld,
	output [4:0] cntr
);
 
wire [5:0] din = {1'b1,cntr};
wire [4:0] dout_w;
 
directphy_f_wys_lut w0 (.a(din[5]),.b(din[4]),.c(din[3]),.d(din[2]),.e(din[1]),.f(din[0]),.out(dout_w[0]));
defparam w0 .MASK = 64'hc33c3cc3c33c3cc3;
defparam w0 .TARGET_CHIP = TARGET_CHIP;
 
directphy_f_wys_lut w1 (.a(din[5]),.b(din[4]),.c(din[3]),.d(din[2]),.e(din[1]),.f(din[0]),.out(dout_w[1]));
defparam w1 .MASK = 64'h3cc33cc3ffff0000;
defparam w1 .TARGET_CHIP = TARGET_CHIP;
 
directphy_f_wys_lut w2 (.a(din[5]),.b(din[4]),.c(din[3]),.d(din[2]),.e(din[1]),.f(din[0]),.out(dout_w[2]));
defparam w2 .MASK = 64'hff00ff00c3c3ff00;
defparam w2 .TARGET_CHIP = TARGET_CHIP;
 
directphy_f_wys_lut w3 (.a(din[5]),.b(din[4]),.c(din[3]),.d(din[2]),.e(din[1]),.f(din[0]),.out(dout_w[3]));
defparam w3 .MASK = 64'hf0f0f0f0f0f033f0;
defparam w3 .TARGET_CHIP = TARGET_CHIP;
 
directphy_f_wys_lut w4 (.a(din[5]),.b(din[4]),.c(din[3]),.d(din[2]),.e(din[1]),.f(din[0]),.out(dout_w[4]));
defparam w4 .MASK = 64'hccccccccccccccf0;
defparam w4 .TARGET_CHIP = TARGET_CHIP;
 
wire mod_ena = LOAD_IMPLIES_ENA ? (sld | ena) : ena;
 
genvar i;
 
generate
for (i=0; i<5; i=i+1) begin : rl
		if(i == 0) begin
		dffeas df (.d(dout_w[i]),
					.clk(clk),
					.ena(mod_ena),
					.sload(1'b0),
					.sclr(1'b0),
					.clrn(1'b1),
					.prn(~sld),
				// synthesis translate off
					.devclrn(1'b1),
					.devpor(1'b1),
				// synthesis translate on					
					.asdata(1'b0),
					.aload(1'b0),
					.q(cntr[i])
		);
		defparam df .power_up = "low";
		defparam df .is_wysiwyg = "false";					
		end else begin
		dffeas df (.d(dout_w[i]),
					.clk(clk),
					.ena(mod_ena),
					.sload(1'b0),
					.sclr(1'b0),
					.clrn(~sld),
					.prn(1'b1),
				// synthesis translate off
					.devclrn(1'b1),
					.devpor(1'b1),
				// synthesis translate on					
					.asdata(1'b0),
					.aload(1'b0),
					.q(cntr[i])
		);
		defparam df .power_up = "low";
		defparam df .is_wysiwyg = "false";
		end
end
endgenerate
 
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRzVy0lyG9sD4l71as+ormrsXiVAOGbh5tEg6zsDZCZxYD/iwr4ZPynQnn1FrxCzRbUM+6J47/CcFXzeht9iWsFcbTsfLE6gE3JDqBRLuHzzf8M37CsS9zU+ZZQ0TAQWsS3pU648FnAwA9IlRmEx0foE90g31NUBhvoXLBKr7v9vwNOImfJcS0LH3qWcxFmdH2sz99XZppupmRUYcAYqGfFJicO7DQG7dB3UlPvBU+0Y7XdpvJtNliGSgyDKoaAeJa2tCHVS/YZoRB1bXS0M2lK5pnICZkanjVK3L5rRcLVShshtx7kp8CtopDd0IVg4jdlIL33BxRuHq6gRNXgpKODrXRYurp6aF9nG9/ayWLxU31RHFYW0kS+ueLSV5oEQ9QcQGM3seKdmwgxIM6j1Kv08P66VbhfN7NB8uCpXrvJ03f4LjZT9mYtWatbUmyWjvEQ2WYzbyBBhpzOiiCeKJmWeEPEtOwwsxisKV3fQOgoYhF1rokB9dp/D37hC6CNcYll+IWst5FGA6DgUFs8el5M5K5QidMwlNLqsLikWppLY26vTbHOCNCZDoqG6hCry9/uQ5MBc5QHlHmmnpH+6HfgEP5TKwxrwwUUC7iS6OPIkTwlfi6oNtu0NKlh9MDi7spMq1DxOv8e6JKJy0NAEdpy3MVABjjktuqonEq54gyakRN6KXymsrkaJeh1acXIpBAajfe7fKPJowwWY7ld3nsgzn0pqpNGFPwE6KUoD33PejeHQaf5MUlOOiaMQFPobhKBgajI0ukoQaIexHTAPQY5j"
`endif