// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// Copyright 2012 Intel Corporation. All rights reserved.  
// Intel products are protected under numerous U.S. and foreign patents, 
// maskwork rights, copyrights and other intellectual property laws.  
//
// This reference design file, and your use thereof, is subject to and governed
// by the terms and conditions of the applicable Intel Reference Design 
// License Agreement (either as signed by you or found at www.altera.com).  By
// using this reference design file, you indicate your acceptance of such terms
// and conditions between you and Intel Corporation.  In the event that you do
// not agree with such terms and conditions, you may not use the reference 
// design file and please promptly destroy any copies you have made.
//
// This reference design file is being provided on an "as-is" basis and as an 
// accommodation and therefore all warranties, representations or guarantees of 
// any kind (whether express, implied or statutory) including, without 
// limitation, warranties of merchantability, non-infringement, or fitness for
// a particular purpose, are Intel disclaimed.  By making this reference
// design file available, Intel expressly does not recommend, suggest or 
// require that this reference design file be used in combination with any 
// other product not provided by Intel.
/////////////////////////////////////////////////////////////////////////////


`timescale 1 ps / 1 ps

// baeckler - 01-08-2012

module directphy_f_sync_regs_aclr_m2 #(
	parameter WIDTH = 32,
	parameter DEPTH = 2		// minimum of 2
)(
	input clk,
	input aclr,
	input [WIDTH-1:0] din,
	output [WIDTH-1:0] dout
);

reg [WIDTH-1:0] din_meta = 0;

reg [WIDTH*(DEPTH-1)-1:0] sync_sr = 0;


always @(posedge clk or posedge aclr) begin
	if (aclr) begin 
		din_meta <= {WIDTH{1'b0}};
		sync_sr <= {(WIDTH*(DEPTH-1)){1'b0}};
	end
	else begin
		din_meta <= din;
		sync_sr <= (DEPTH==2)? din_meta : (sync_sr << WIDTH) | din_meta;
	end
end
assign dout = sync_sr[WIDTH*(DEPTH-1)-1:WIDTH*(DEPTH-2)];

endmodule

// BENCHMARK INFO :  5SGXEA7N2F45C2
// BENCHMARK INFO :  Max depth :  0.0 LUTs
// BENCHMARK INFO :  Total registers : 64
// BENCHMARK INFO :  Total pins : 66
// BENCHMARK INFO :  Total virtual pins : 0
// BENCHMARK INFO :  Total block memory bits : 0
// BENCHMARK INFO :  Comb ALUTs :                         ; 1               ;       ;
// BENCHMARK INFO :  ALMs : 17 / 234,720 ( < 1 % )
// BENCHMARK INFO :  Worst setup path @ 468.75MHz : 1.702 ns, From din_meta[22], To sync_sr[22]}
// BENCHMARK INFO :  Worst setup path @ 468.75MHz : 1.705 ns, From din_meta[13], To sync_sr[13]}
// BENCHMARK INFO :  Worst setup path @ 468.75MHz : 1.708 ns, From din_meta[13], To sync_sr[13]}
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "58Y0Pn55Fe2JKb7e0A+udX7xXXgvc4XXL0ncHJuhjuNr2I/2v7Rv/VGS+yOHbPt8sqN5yzDfFtY/N2f5i7fM4D1NaPeRvwaI0rhQ6Rt2LS/KFCeglVSHEMA7/NSKgdz7z1H0+lOkNYJLPhmpwpi/xWtNiphYMFHsCwtKxU3etlKESNVVnPUZdyM5jEgjN7KwexXS6xvWvHDrFEibsnFdVP8fgRwSp9W9H0sO0x5GiRwxb3eNySSdrkEuP6HeLPsDeYA19lZSDo4vAxBX7nstpdWxKOumVw2xUoXcKc7dK36/zJ4+GNRXWai0J/BjhNTxObtfg1HRO0NV+48fNSRipdcekv0YfJVpvvrJN3UL18PubGEoHGeDuSqNVmPcKEnWG46/jFyTZRPFfLM78+fngv+fXsj5JM8lZ2mWiuJV5QB6ygui/cA56nCwXvpu4yVqXWJ2T7vVvodMhDBFR3+ifZvBvt1R7xtdPw3e8c6TU3o/ZGvo5rgV35kEVo/9YfW+RPZteflnbAJv240g8ewUA2uTVpEmlFaUhlNJS2mNHrOQbYWwpr1UMcR9eXH8g4cNYXygtdJ4zG8fiId0+8QC/2Ucvw6R6mYDO8MwB6nzpntTERy82tj5DggwEu4INiLV2WnDlvHN4IVnvVdIhmghYOC241OHMtr4aYjRRzlI5yQuRA8VJW9LaovUI1uZC744q2BAWWPjkQDj2C4DsS5pZVn/ZWSIRweDZ7loRQrk6h65YuZ63EgjCHct/iguOdj9IoYIng6dokCayQacMsUG17y1iw+qt14qJUwyz+6mBB2BJnidmQp8+O6AuoX/YX52uv9+LOOHvvFEzrHpgkaPXA26nYr7/0/KmyrgtkWf3cRv+SvNl/6CwwWf0KeUwy0JlRLInyZiXDTpQqPaQ+I8Ip79ARHoLJNv1WIuTckeZK3QM1uWjmelz6Wxr0ss3DGC57845h3FP6tilhFM8rkTX3CO6lzi4icCPd3X8FnW5hK6G2npgEeVY0l/4m7Nr9vq"
`endif