// (C) 2001-2023 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module rx_mr_top #(
    parameter           NUM_STREAMS             = 1,
    parameter [14:0]    MRPHY_RX_BASE_PROFILE   = 15'd1
)(
    // System PLL Link clock
    input  logic                        system_pll_clk,
    // RX clocks
    input  logic                        rx_core_refclk,
    input  logic                        rx_cdr_refclk,
    input  logic                        rx_rcfg_mgmt_clk,

    // RX Reference Reset
    input  logic                        rx_resetn,
    input  logic                        rx_rcfg_mgmt_resetn,

    // RX Video Signal Interface (Could be Interface with CVI)
    output logic                        rx_vid_clkout,
    output logic [NUM_STREAMS*20-1:0]   rx_vid_data,
    output logic                        rx_vid_datavalid,
    output logic                        rx_vid_locked,
    output logic [2:0]                  rx_vid_std,
    output logic [NUM_STREAMS-1:0]      rx_vid_hsync,
    output logic [NUM_STREAMS-1:0]      rx_vid_vsync,
    output logic [NUM_STREAMS-1:0]      rx_vid_f,
    output logic [NUM_STREAMS-1:0]      rx_vid_trs,
    // Other SDI RX Video Protocol Interfaces
    output logic                        sdi_rx_align_locked,
    output logic [NUM_STREAMS-1:0]      sdi_rx_trs_locked,
    output logic                        sdi_rx_clkout_is_ntsc_paln,
    output logic                        sdi_rx_rst_proto_out,
    output logic [NUM_STREAMS*4-1:0]    sdi_rx_format,
    output logic [NUM_STREAMS-1:0]      sdi_rx_ap,
    output logic [NUM_STREAMS-1:0]      sdi_rx_eav,
    output logic [NUM_STREAMS*11-1:0]   sdi_rx_ln,
    output logic [NUM_STREAMS*11-1:0]   sdi_rx_ln_b,
    output logic [NUM_STREAMS*11-1:0]   sdi_rx_line_f0,
    output logic [NUM_STREAMS*11-1:0]   sdi_rx_line_f1,
    output logic [NUM_STREAMS*8-1:0]    sdi_rx_vpid_byte1,
    output logic [NUM_STREAMS*8-1:0]    sdi_rx_vpid_byte2,
    output logic [NUM_STREAMS*8-1:0]    sdi_rx_vpid_byte3,
    output logic [NUM_STREAMS*8-1:0]    sdi_rx_vpid_byte4,
    output logic [NUM_STREAMS-1:0]      sdi_rx_vpid_checksum_error,
    output logic [NUM_STREAMS-1:0]      sdi_rx_vpid_valid,
    output logic [NUM_STREAMS*8-1:0]    sdi_rx_vpid_byte1_b,
    output logic [NUM_STREAMS*8-1:0]    sdi_rx_vpid_byte2_b,
    output logic [NUM_STREAMS*8-1:0]    sdi_rx_vpid_byte3_b,
    output logic [NUM_STREAMS*8-1:0]    sdi_rx_vpid_byte4_b,
    output logic [NUM_STREAMS-1:0]      sdi_rx_vpid_checksum_error_b,
    output logic [NUM_STREAMS-1:0]      sdi_rx_vpid_valid_b,

    // DR Interface
    input  logic                        dr_rx_new_cfg_applied,
    input  logic                        dr_rx_avmm_readdata_valid,
    input  logic                        dr_rx_avmm_waitrequest,
    input  logic [31:0]                 dr_rx_avmm_readdata,
    output logic                        cdr_reconfig_busy,
    output logic                        dr_rx_new_cfg_applied_ack,
    output logic                        dr_rx_avmm_write,
    output logic                        dr_rx_avmm_read,
    output logic [31:0]                 dr_rx_avmm_writedata,
    output logic  [9:0]                 dr_rx_avmm_address,

    // RX Transceiver Interface
    input  logic                        gxb_rx_serial_data,
    input  logic                        gxb_rx_serial_data_n,
    output logic                        gxb_rx_reset_ack,
    output logic                        gxb_rx_ready
);

// ----------------------
// Signal Declaration
// ----------------------
logic                       rx_syspll_clkout;
logic                       trig_rst_ctrl;
logic [NUM_STREAMS*20-1:0]  sdi_rx_datain;
logic [79:0]                rx_parallel_data;
logic                       rx_sdi_start_reconfig;
logic                       rx_set_ltd;
logic                       enable;
logic                       gxb_rx_reconfig_pdp_avmm_write;
logic                       gxb_rx_reconfig_pdp_avmm_read;
logic [31:0]                gxb_rx_reconfig_pdp_avmm_writedata;
logic [13:0]                gxb_rx_reconfig_pdp_avmm_address;
logic [31:0]                gxb_rx_reconfig_pdp_avmm_readdata;
logic                       gxb_rx_reconfig_pdp_avmm_waitrequest;

assign enable = ~rx_set_ltd;

sdi_ftile_phy_adapter   #(
    .VIDEO_STANDARD ("mr"),
    .DIRECTION      ("rx")
) sdi_phy_adapter_inst (
// Input Clocks and reset
    .rx_resetn          (~trig_rst_ctrl),
    .rx_syspll_clkout   (rx_syspll_clkout),
    .rx_vid_clkout      (rx_vid_clkout),
    .tx_resetn          (1'b0),
    .tx_syspll_clkout   (1'b0),
    .tx_vid_clkout      (1'b0),

// Inputs
    .gxb_rx_ready       (gxb_rx_ready),
    .rx_parallel_data   (rx_parallel_data),
    .rx_vid_std         (rx_vid_std),
    .sdi_txdata         ({NUM_STREAMS{20'd0}}),
    .gxb_tx_ready       (1'b0),
    .tx_cadence         (1'b0),

// Outputs
    .tx_parallel_data   (),
    .rxdata_to_sdi      (sdi_rx_datain)
);

sdi_rx_dr_f #(
    .MRPHY_RX_BASE_PROFILE  (MRPHY_RX_BASE_PROFILE),
    .VIDEO_STANDARD         ("mr")
) rx_rcfg_inst (
// Input Clocks and reset
    .clk                    (rx_rcfg_mgmt_clk),
    .reset                  (~rx_rcfg_mgmt_resetn),

// Inputs
    .xcvr_reset_ack         (gxb_rx_reset_ack),
    .sdi_reconfig_request   (rx_sdi_start_reconfig),
    .sdi_rx_std             (rx_vid_std),
    .dr_new_cfg_applied     (dr_rx_new_cfg_applied),
    .dr_avmm_readdata_valid (dr_rx_avmm_readdata_valid),
    .dr_avmm_waitrequest    (dr_rx_avmm_waitrequest),
    .dr_avmm_readdata       (dr_rx_avmm_readdata),

// Outputs
    .cdr_reconfig_busy      (cdr_reconfig_busy),
    .dr_new_cfg_applied_ack (dr_rx_new_cfg_applied_ack),
    .dr_avmm_write          (dr_rx_avmm_write),
    .dr_avmm_read           (dr_rx_avmm_read),
    .dr_avmm_address        (dr_rx_avmm_address),
    .dr_avmm_writedata      (dr_rx_avmm_writedata)
);

sdi_rx_phy_access  rx_phy_access_inst (
// Input Clocks and reset
    .clk                        (rx_rcfg_mgmt_clk),
    .reset                      (~rx_rcfg_mgmt_resetn),

// Inputs
    .en_phy_access              (enable),
    .pdp_avmm_waitrequest       (gxb_rx_reconfig_pdp_avmm_waitrequest),
    .pdp_avmm_readdata          (gxb_rx_reconfig_pdp_avmm_readdata),

// Outputs
    .pdp_avmm_write             (gxb_rx_reconfig_pdp_avmm_write),
    .pdp_avmm_read              (gxb_rx_reconfig_pdp_avmm_read),
    .pdp_avmm_address           (gxb_rx_reconfig_pdp_avmm_address),
    .pdp_avmm_writedata         (gxb_rx_reconfig_pdp_avmm_writedata)
);

// ----------------------
// SDI RX Core with PHY
// ----------------------
sdi_mr_rx_sys  sdi_mr_rx_sys_inst (
// Input Clocks and reset
    .rx_phy_system_pll_clk_link_clk                         (system_pll_clk),
    .rx_phy_rx_cdr_refclk_link_xcvr0_prof0_clk              (rx_cdr_refclk),
    .rx_phy_coreclkin_coreclkin                             (rx_syspll_clkout),
    .rx_sdi_rx_coreclk_clk                                  (rx_core_refclk),
    .rx_sdi_xcvr_rxclk_clk                                  (rx_vid_clkout),
    .rx_phy_reconfig_pdp_clk_clk                            (rx_rcfg_mgmt_clk),
    .rx_phy_reconfig_pdp_reset_reset                        (~rx_rcfg_mgmt_resetn),
    .rx_phy_rx_reset_rx_reset                               (~rx_resetn || trig_rst_ctrl),
    .rx_sdi_rx_rst_reset                                    (~rx_resetn),

// Output clocks and reset
    .rx_phy_rx_clkout_stream0_clk                           (rx_syspll_clkout),
    .rx_phy_rx_clkout2_stream0_clk                          (rx_vid_clkout),
    .rx_phy_rx_reset_ack_rx_reset_ack                       (gxb_rx_reset_ack),
    .rx_sdi_trig_rst_ctrl_reset                             (trig_rst_ctrl),

// Inputs
    .rx_phy_rx_serial_data_rx_serial_data                   (gxb_rx_serial_data),
    .rx_phy_rx_serial_data_n_rx_serial_data_n               (gxb_rx_serial_data_n),
    .rx_phy_fgt_rx_set_locktodata_fgt_rx_set_locktodata     (rx_set_ltd),
    .rx_phy_reconfig_pdp_avmm_write                         (gxb_rx_reconfig_pdp_avmm_write),
    .rx_phy_reconfig_pdp_avmm_read                          (gxb_rx_reconfig_pdp_avmm_read),
    .rx_phy_reconfig_pdp_avmm_address                       (gxb_rx_reconfig_pdp_avmm_address),
    .rx_phy_reconfig_pdp_avmm_byteenable                    (4'b1111),
    .rx_phy_reconfig_pdp_avmm_writedata                     (gxb_rx_reconfig_pdp_avmm_writedata),
    .rx_sdi_rx_datain_rx_parallel_data                      (sdi_rx_datain),
    .rx_sdi_rx_xcvr_reset_ack_rx_reset_ack                  (gxb_rx_reset_ack),
    .rx_sdi_rx_sdi_reconfig_done_export                     (dr_rx_new_cfg_applied_ack),

// Outputs
    .rx_phy_rx_ready_rx_ready                               (gxb_rx_ready),
    .rx_phy_rx_is_lockedtodata_rx_is_lockedtodata           (),
    .rx_phy_rx_is_lockedtoref_rx_is_lockedtoref             (),
    .rx_phy_rx_parallel_data_rx_parallel_data               (rx_parallel_data),
    .rx_phy_reconfig_pdp_avmm_readdata                      (gxb_rx_reconfig_pdp_avmm_readdata),
    .rx_phy_reconfig_pdp_avmm_waitrequest                   (gxb_rx_reconfig_pdp_avmm_waitrequest),
    .rx_sdi_gxb_ltd_gxb_ltd                                 (rx_set_ltd),
    .rx_sdi_rx_sdi_start_reconfig_export                    (rx_sdi_start_reconfig),
    .rx_sdi_rx_dataout_export                               (rx_vid_data),
    .rx_sdi_rx_dataout_valid_export                         (rx_vid_datavalid),
    .rx_sdi_rx_f_export                                     (rx_vid_f),
    .rx_sdi_rx_v_export                                     (rx_vid_vsync),
    .rx_sdi_rx_h_export                                     (rx_vid_hsync),
    .rx_sdi_rx_ap_export                                    (sdi_rx_ap),
    .rx_sdi_rx_format_export                                (sdi_rx_format),
    .rx_sdi_rx_align_locked_export                          (sdi_rx_align_locked),
    .rx_sdi_rx_trs_locked_export                            (sdi_rx_trs_locked),
    .rx_sdi_rx_frame_locked_export                          (rx_vid_locked),
    .rx_sdi_rx_ln_export                                    (sdi_rx_ln),
    .rx_sdi_rx_ln_b_export                                  (sdi_rx_ln_b),
    .rx_sdi_rx_std_export                                   (rx_vid_std),
    .rx_sdi_rx_line_f0_export                               (sdi_rx_line_f0),
    .rx_sdi_rx_line_f1_export                               (sdi_rx_line_f1),
    .rx_sdi_rx_vpid_byte1_export                            (sdi_rx_vpid_byte1),
    .rx_sdi_rx_vpid_byte2_export                            (sdi_rx_vpid_byte2),
    .rx_sdi_rx_vpid_byte3_export                            (sdi_rx_vpid_byte3),
    .rx_sdi_rx_vpid_byte4_export                            (sdi_rx_vpid_byte4),
    .rx_sdi_rx_vpid_checksum_error_export                   (sdi_rx_vpid_checksum_error),
    .rx_sdi_rx_vpid_valid_export                            (sdi_rx_vpid_valid),
    .rx_sdi_rx_vpid_byte1_b_export                          (sdi_rx_vpid_byte1_b),
    .rx_sdi_rx_vpid_byte2_b_export                          (sdi_rx_vpid_byte2_b),
    .rx_sdi_rx_vpid_byte3_b_export                          (sdi_rx_vpid_byte3_b),
    .rx_sdi_rx_vpid_byte4_b_export                          (sdi_rx_vpid_byte4_b),
    .rx_sdi_rx_vpid_checksum_error_b_export                 (sdi_rx_vpid_checksum_error_b),
    .rx_sdi_rx_vpid_valid_b_export                          (sdi_rx_vpid_valid_b),
    .rx_sdi_rx_eav_export                                   (sdi_rx_eav),
    .rx_sdi_rx_clkout_is_ntsc_paln_export                   (sdi_rx_clkout_is_ntsc_paln),
    .rx_sdi_rx_ready_rx_ready                               (gxb_rx_ready),
    .rx_sdi_rx_rst_proto_out_export                         (sdi_rx_rst_proto_out),
    .rx_sdi_rx_trs_export                                   (rx_vid_trs)
);

endmodule

